/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine.gl;

import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.el.rec.filing.tools.FilingUtils;
import com.kingdee.eas.el.rec.tool.engine.gl.ExcelConfigs;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class SXSSFWorkbookUtils {
    private static Logger logger = Logger.getLogger(SXSSFWorkbookUtils.class);
    private SXSSFWorkbook sxssfWorkbook = null;
    private int sheetIndex = 0;
    private static int windowSize = 100000;
    private String nameDefault = "Sheet";
    private CellStyle cellStyle = null;
    private DataFormat dataFormat = null;
    private final String DATA_FORMAT = "#,##0.00";
    private HashMap<Sheet, Integer> sheetsRow = new HashMap();
    private HashMap<Sheet, Integer> columnSizeMap = new HashMap();

    public static SXSSFWorkbookUtils createSXSSFWorkbookInstance() {
        return SXSSFWorkbookUtils.createSXSSFWorkbookInstance(windowSize);
    }

    public static SXSSFWorkbookUtils createSXSSFWorkbookInstance(int windowSize) {
        return new SXSSFWorkbookUtils(windowSize);
    }

    private SXSSFWorkbookUtils() {
        this(windowSize);
    }

    private SXSSFWorkbookUtils(int windowSize) {
        this.sxssfWorkbook = new SXSSFWorkbook(windowSize);
        this.cellStyle = this.getCellStyle(ExcelConfigs.getExcelConfigsInstance());
        this.dataFormat = this.sxssfWorkbook.createDataFormat();
    }

    public Sheet createSheet() {
        return this.createSheet(this.nameDefault + this.sheetIndex++, windowSize);
    }

    public Sheet createSheet(String name, int maxRow) {
        SXSSFSheet createSheet = this.sxssfWorkbook.createSheet(name);
        return createSheet;
    }

    public void setSheetHeader(Sheet sheet, String[] headerName) {
        this.setSheetHeader(sheet, headerName, 0);
    }

    public void setSheetHeader(Sheet sheet, String[] headerName, int headIndex) {
        this.setSheetHeader(sheet, new ArrayList<Object>(Arrays.asList((Object[])headerName)), headIndex);
    }

    public void setSheetHeader(Sheet sheet, List<Object> headerName) {
        this.setSheetHeader(sheet, headerName, 0);
    }

    public void setSheetHeader(Sheet sheet, List<Object> headerName, int headIndex) {
        if (sheet == null || null == headerName || headerName.size() == 0) {
            return;
        }
        Row row = sheet.getRow(headIndex);
        int columnSize = headerName.size();
        if (null == row) {
            row = sheet.createRow(headIndex);
            this.setSheetRowValue(row, headerName, true);
            this.columnSizeMap.put(sheet, headerName.size());
            this.sheetsRow.put(sheet, this.sheetsRow.get(sheet) == null ? 1 : this.sheetsRow.get(sheet) + 1);
        } else {
            this.checkColumnSize(sheet, headerName);
            for (int i = 0; i < columnSize; ++i) {
                Cell cell = row.getCell(i);
                this.setCellValue(cell, headerName.get(i));
            }
        }
    }

    public void createSheetRows(Sheet sheet, List<List<Object>> rowDatas) {
        if (sheet == null || null == rowDatas || rowDatas.size() == 0) {
            return;
        }
        Iterator<List<Object>> iterator = rowDatas.iterator();
        while (iterator.hasNext()) {
            this.createSheetRow(sheet, iterator.next());
        }
    }

    public void createSheetRow(Sheet sheet, List<Object> rowData) {
        Integer integer;
        if (sheet == null || null == rowData || rowData.size() == 0) {
            return;
        }
        if (null == this.columnSizeMap.get(sheet)) {
            this.setSheetHeader(sheet, rowData);
            return;
        }
        this.checkColumnSize(sheet, rowData);
        Integer n = integer = this.sheetsRow.get(sheet);
        Integer n2 = integer = Integer.valueOf(integer + 1);
        Row row = sheet.createRow(n.intValue());
        this.sheetsRow.put(sheet, integer);
        this.setSheetRowValue(row, rowData);
    }

    public void setSheetRowValue(Row row, List<Object> headerName) {
        this.setSheetRowValue(row, headerName, false);
    }

    public void setSheetRowValue(Row row, List<Object> headerName, boolean isHead) {
        int columnSize = headerName.size();
        Cell[] csCell = new Cell[columnSize];
        for (int i = 0; i < columnSize; ++i) {
            csCell[i] = row.createCell(i);
            if (isHead) {
                this.cellStyle.setAlignment(HorizontalAlignment.CENTER);
                this.cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
            } else {
                this.cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
            }
            csCell[i].setCellStyle(this.cellStyle);
            this.setCellValue(csCell[i], headerName.get(i));
        }
    }

    private void checkColumnSize(Sheet sheet, List<Object> headerName) {
        if (this.columnSizeMap.get(sheet).intValue() != headerName.size()) {
            throw new RuntimeException("List.size != sheet.row.size ");
        }
    }

    private void setCellValue(Cell cell, Object object) {
        if (object instanceof Boolean) {
            cell.setCellValue(((Boolean)object).booleanValue());
        } else if (object instanceof Double) {
            cell.getCellStyle().setDataFormat(this.dataFormat.getFormat("#,##0.00"));
            cell.setCellValue(((Double)object).doubleValue());
        } else if (object instanceof Date) {
            cell.setCellValue((Date)object);
        } else if (object instanceof String) {
            cell.setCellValue((String)object);
        } else if (object instanceof Integer) {
            cell.setCellValue((Integer)object + "");
        } else if (object == null) {
            cell.setCellValue("");
        } else if (object instanceof BigDecimal) {
            if (((BigDecimal)object).compareTo(new BigDecimal("0")) == 0) {
                cell.setCellValue("");
            } else {
                cell.getCellStyle().setDataFormat(this.dataFormat.getFormat("#,##0.00"));
                cell.setCellValue(((BigDecimal)object).doubleValue());
            }
        } else if (object instanceof BalanceDirectionEnum) {
            cell.setCellValue(((BalanceDirectionEnum)object).getAlias());
        } else {
            cell.setCellValue(object.toString());
            logger.error((Object)("The input value is error : " + object + " object.getClass = " + object.getClass()));
        }
    }

    private CellStyle getCellStyle(ExcelConfigs excelConfigs) {
        CellStyle structStyle = this.sxssfWorkbook.createCellStyle();
        structStyle.setFillPattern(excelConfigs.getCellFillPattern());
        structStyle.setFillForegroundColor(excelConfigs.getCellFillForegroundColor());
        structStyle.setAlignment(excelConfigs.getCellAlignment());
        structStyle.setHidden(excelConfigs.isCellHidden());
        structStyle.setLocked(excelConfigs.isCellLocked());
        structStyle.setBorderLeft(excelConfigs.getCellBorderLeft());
        structStyle.setBorderRight(excelConfigs.getCellBorderRight());
        structStyle.setBorderTop(excelConfigs.getCellBorderTop());
        structStyle.setBorderBottom(excelConfigs.getCellBorderBottom());
        structStyle.setBottomBorderColor(excelConfigs.getCellBottomBorderColor());
        structStyle.setTopBorderColor(excelConfigs.getCellTopBorderColor());
        structStyle.setLeftBorderColor(excelConfigs.getCellLeftBorderColor());
        structStyle.setRightBorderColor(excelConfigs.getCellRightBorderColor());
        structStyle.setVerticalAlignment(excelConfigs.getCellVerticalAlignment());
        Font defaultFont = this.sxssfWorkbook.createFont();
        defaultFont.setFontName(excelConfigs.getCellFontName());
        defaultFont.setFontHeightInPoints(excelConfigs.getCellFontHeightInPoints());
        structStyle.setFont(defaultFont);
        return structStyle;
    }

    public void saveExcel(String path) {
        this.saveExcel(path, true);
    }

    public void saveExcel(String path, String name) {
        this.saveExcel(path + name, true);
    }

    public void setCellStyle(ExcelConfigs excelConfigs) {
        this.cellStyle = this.getCellStyle(excelConfigs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream toInputStream() throws IOException {
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        ByteArrayInputStream inputStream = null;
        try {
            this.sxssfWorkbook.write((OutputStream)boas);
            inputStream = new ByteArrayInputStream(boas.toByteArray());
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
        }
        finally {
            boas.close();
            inputStream.close();
        }
        return inputStream;
    }

    public OutputStream toOutputStream() throws IOException {
        try (ByteArrayOutputStream boas = new ByteArrayOutputStream();){
            this.sxssfWorkbook.write((OutputStream)boas);
        }
        return boas;
    }

    public void saveExcel(String path, ByteArrayOutputStream outputStream) throws IOException {
        this.saveExcel(path, outputStream, true);
    }

    public void saveExcel(InputStream is, String path) throws IOException {
        this.saveExcel(is, path, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveExcel(InputStream is, String path, boolean overide) throws IOException {
        if (overide) {
            this.deleteOldExcel(path);
        }
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        FileOutputStream fout = null;
        try {
            in = new BufferedInputStream(is);
            fout = new FileOutputStream(path);
            out = new BufferedOutputStream(fout);
            int len = -1;
            byte[] b = new byte[1024];
            while ((len = in.read(b)) != -1) {
                ((BufferedOutputStream)out).write(b, 0, len);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage());
            }
            catch (Throwable throwable) {
                FilingUtils.safeClose(in);
                FilingUtils.safeClose(fout);
                if (null != out) {
                    out.close();
                }
                throw throwable;
            }
            FilingUtils.safeClose(in);
            FilingUtils.safeClose(fout);
            if (null != out) {
                out.close();
            }
        }
        FilingUtils.safeClose(in);
        FilingUtils.safeClose(fout);
        if (null != out) {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveExcel(String path, ByteArrayOutputStream outputStream, boolean overide) throws IOException {
        if (overide) {
            this.deleteOldExcel(path);
        }
        File file = new File(path);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            ((OutputStream)fos).write(outputStream.toByteArray());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        finally {
            if (null != fos) {
                ((OutputStream)fos).close();
            }
        }
    }

    public void deleteOldExcel(String path, String name) {
        this.deleteOldExcel(path + name);
    }

    public void deleteOldExcel(String path) {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveExcel(String path, boolean overide) {
        if (overide) {
            this.deleteOldExcel(path);
        }
        FileOutputStream fileOut = null;
        try {
            fileOut = new FileOutputStream(path);
            return;
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage());
            return;
        }
        finally {
            if (fileOut != null) {
                try {
                    this.sxssfWorkbook.write((OutputStream)fileOut);
                }
                catch (IOException e2) {
                    logger.error((Object)e2.getMessage());
                }
                finally {
                    try {
                        fileOut.close();
                    }
                    catch (IOException e3) {
                        logger.error((Object)e3.getMessage());
                    }
                }
            }
        }
    }
}

