/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine.gl.provider;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.el.rec.tool.engine.gl.provider.AbstractGLRptPrintProvider;
import com.kingdee.eas.el.rec.tool.engine.gl.setting.GLRptSubLedgerPrintSetting;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;

public class GLRptSubLedgerPrintProvider
extends AbstractGLRptPrintProvider {
    private String strOverHypoPage = EASResource.getString((String)"com.kingdee.eas.fi.gl.TaoDaResource", (String)"overHypoPage");
    private String strBearForwardPage = EASResource.getString((String)"com.kingdee.eas.fi.gl.TaoDaResource", (String)"bearForwardPage");
    private String allCurrency = GLResUtil.getRes((String)"all_currency");
    private static final String[][] col = new String[][]{{"sysDateNow", ""}, {"userName", ""}, {"companyName", ""}, {"period", ""}, {"currency", ""}, {"FDateYear", ""}, {"FDateMonth", ""}, {"FDateDay", ""}, {"FAsstAccountNameGroup", ""}, {"topKeMu", ""}, {"FAsstAccountName0Title", ""}, {"FAsstAccountName1Title", ""}, {"FAsstAccountName2Title", ""}, {"FAsstAccountName3Title", ""}, {"FAsstAccountName4Title", ""}, {"FAsstAccountName5Title", ""}, {"FAsstAccountName6Title", ""}, {"FAsstAccountName7Title", ""}, {"FAsstAccountNameGroupTitle", ""}, {"FaccountName", "accountName"}, {"FAsstAccountName0", "FAsstAccountName0"}, {"FAsstAccountName1", "FAsstAccountName1"}, {"FAsstAccountName2", "FAsstAccountName2"}, {"FAsstAccountName3", "FAsstAccountName3"}, {"FAsstAccountName4", "FAsstAccountName4"}, {"FAsstAccountName5", "FAsstAccountName5"}, {"FAsstAccountName6", "FAsstAccountName6"}, {"FAsstAccountName7", "FAsstAccountName7"}, {"FDC", "accountDC"}, {"FDate", "FBookedDate"}, {"FVoucherNumber", "voucherNumber"}, {"FBizDate", "FBizdate"}, {"accountName", "oppAccountName"}, {"FDescription", "FDescription"}, {"FBaseRate", "FLocalExchangeRate"}, {"FRptRate", "FReportingExchangeRate"}, {"FDebitUnit", "debitMeasureUnitName"}, {"FDebitQuantity", "FSubDebitQty"}, {"FDebitPrice", "FDebitPrice"}, {"FDebitFor", "FSubDebitFor"}, {"FDebitLocal", "FSubDebitLocal"}, {"FDebitRpt", "FSubDebitRpt"}, {"FCreditUnit", "creditMeasureUnitName"}, {"FCreditQuantity", "FSubCreditQty"}, {"FCreditPrice", "FCreditPrice"}, {"FCreditFor", "FSubCreditFor"}, {"FCreditLocal", "FSubCreditLocal"}, {"FCreditRpt", "FSubCreditRpt"}, {"FBalanceUnit", "endMeasureUnitName"}, {"FBalanceQuantity", "FEndQty"}, {"FBalancePrice", "FEndPrice"}, {"FBalanceFor", "FEndBalanceFor"}, {"FBalanceLocal", "FEndBalanceLocal"}, {"FBalanceRpt", "FEndBalanceRpt"}, {"FCurrencyName", "currencyName"}, {"FBizNumber", "FBizNumber"}, {"FInvoiceNumber", "FInvoiceNumber"}, {"FSettlementCode", "FSettlementCode"}, {"FSettlementType", "settleTypeName"}, {"FTicketNumber", "FTicketNumber"}, {"FFeeType", ""}, {"FHandler", ""}};
    private boolean isShowDisplayAsstDetail = false;

    public GLRptSubLedgerPrintProvider(Map<String, Object> params) {
        super(params);
        if (params != null) {
            this.isShowDisplayAsstDetail = ((GLRptSubLedgerCondition)params.get("cond")).isShowDisplayAsstDetail();
        }
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet rs = null;
        for (int i = 4; i <= 30; ++i) {
            if (!("ds" + i).equalsIgnoreCase(ds.getID())) continue;
            rs = this.getRowSet(i);
            break;
        }
        return rs;
    }

    public IRowSet getRowSet(int rowLineCount) {
        GLRptSubLedgerPrintSetting config = (GLRptSubLedgerPrintSetting)this.config;
        DateFormat format = GlUtils.getDateFormat();
        int colCount = col.length;
        DynamicRowSet drs = null;
        try {
            drs = new DynamicRowSet(colCount);
            for (int i = 0; i < colCount; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = col[i][0];
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            CurrencyInfo baseCurrency = this.curCompany.getBaseCurrency();
            baseCurrency = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId()));
            CurrencyInfo rptCurrency = this.curCompany.getReportCurrency();
            if (rptCurrency != null) {
                rptCurrency = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(rptCurrency.getId()));
            }
            String currencyId = (String)this.vars.get("currencyId");
            CurrencyInfo currency = null;
            if (currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
                currency = baseCurrency;
            } else if (currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
                currency = rptCurrency;
            } else if (!currencyId.equalsIgnoreCase("AllCurrency")) {
                currency = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            }
            boolean isBaseCurrency = currency != null && baseCurrency.getId().equals((Object)currency.getId());
            boolean isGBaseCy = currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC");
            boolean isGRptCy = currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC");
            int rowCount = 0;
            this.rs.beforeFirst();
            String lastItemID = null;
            String lastAssGrpID = null;
            while (this.rs.next()) {
                String itemID = this.rs.getString("FAccountID");
                String assGrpID = null;
                if (config.isPageByAsst()) {
                    itemID = itemID + this.getAsstItem(this.rs);
                }
                if (config.isChkAcctAndAsst()) {
                    assGrpID = this.rs.getString("FAssGrpId");
                    if (lastAssGrpID == null && assGrpID != null) {
                        while (rowCount % rowLineCount != 0) {
                            drs.moveToInsertRow();
                            this.clearRow((IRowSet)drs);
                            drs.insertRow();
                            ++rowCount;
                        }
                        lastAssGrpID = assGrpID;
                    } else {
                        lastAssGrpID = assGrpID;
                    }
                }
                if (lastItemID != null && !itemID.equals(lastItemID)) {
                    while (rowCount % rowLineCount != 0) {
                        drs.moveToInsertRow();
                        this.clearRow((IRowSet)drs);
                        drs.insertRow();
                        ++rowCount;
                    }
                    lastItemID = itemID;
                } else {
                    lastItemID = itemID;
                }
                drs.moveToInsertRow();
                this.clearRow((IRowSet)drs);
                ++rowCount;
                drs.updateString("sysDateNow", GlUtils.formatDate((DateFormat)format, (Date)new Date()));
                UserInfo user = (UserInfo)this.ctx.get((Object)"UserInfo");
                drs.updateString("userName", user.getName());
                drs.updateString("companyName", this.curCompany.toString());
                drs.updateString("FaccountName", (String)this.vars.get("accountNumber") + " " + (String)this.vars.get("accountName"));
                drs.updateObject("period", this.vars.get("Period"));
                drs.updateObject("currency", (Object)(currency == null ? this.allCurrency : currency.getName()));
                int precision = 0;
                if (currency == null) {
                    Object currencyPre = this.rs.getObject("currencyPre");
                    if (currencyPre != null) {
                        precision = Integer.parseInt(currencyPre.toString());
                    }
                } else {
                    precision = currency.getPrecision();
                }
                int colNum = col.length - 1;
                boolean fDateYear = false;
                for (int i = 19; i < colNum; ++i) {
                    Object value;
                    if (this.rs.indexOf(col[i][1]) == -1 || (value = this.rs.getObject(col[i][1])) == null) continue;
                    if (value instanceof BigDecimal) {
                        BigDecimal val = (BigDecimal)value;
                        if (val.doubleValue() == 0.0) {
                            drs.updateString(col[i][0], "");
                        } else if (col[i][1].endsWith("Local")) {
                            drs.updateString(col[i][0], GlUtils.withComma((BigDecimal)val, (int)baseCurrency.getPrecision()));
                            if (isGBaseCy) {
                                drs.updateString(col[i][0].substring(0, col[i][0].length() - 5) + "For", GlUtils.withComma((BigDecimal)val, (int)baseCurrency.getPrecision()));
                            }
                        } else if (col[i][1].endsWith("Rpt")) {
                            drs.updateString(col[i][0], GlUtils.withComma((BigDecimal)val, (int)rptCurrency.getPrecision()));
                            if (isGRptCy) {
                                drs.updateString(col[i][0].substring(0, col[i][0].length() - 3) + "For", GlUtils.withComma((BigDecimal)val, (int)rptCurrency.getPrecision()));
                            }
                        } else if (col[i][1].endsWith("For")) {
                            drs.updateString(col[i][0], GlUtils.withComma((BigDecimal)val, (int)precision));
                            if (isBaseCurrency) {
                                drs.updateString(col[i][0].substring(0, col[i][0].length() - 3) + "Local", GlUtils.withComma((BigDecimal)val, (int)precision));
                            }
                        } else if (col[i][1].equals("FLocalExchangeRate")) {
                            drs.updateString(col[i][0], GlUtils.withComma((BigDecimal)val, (int)this.rs.getInt("FLocalExRatePre")));
                        } else if (col[i][1].equals("FReportingExchangeRate")) {
                            drs.updateString(col[i][0], GlUtils.withComma((BigDecimal)val, (int)this.rs.getInt("FRptExRatePre")));
                        } else if (col[i][1].endsWith("Qty")) {
                            drs.updateString(col[i][0], GlUtils.withComma((BigDecimal)val, (int)((Integer)this.vars.get("qtyScale"))));
                        } else if (col[i][1].endsWith("Price")) {
                            drs.updateString(col[i][0], GlUtils.withComma((BigDecimal)val, (int)((Integer)this.vars.get("priceScale"))));
                        } else {
                            drs.updateString(col[i][0], val.toString());
                        }
                    } else if ("accountName".equals(col[i][1])) {
                        String accountNumber = (String)this.rs.getObject("accountName");
                        if (accountNumber != null && accountNumber.trim().length() > 0) {
                            drs.updateString(col[i][0], accountNumber + " " + value.toString());
                        } else {
                            drs.updateString(col[i][0], value.toString());
                        }
                    } else {
                        drs.updateString(col[i][0], value.toString());
                    }
                    if (!col[i][1].equalsIgnoreCase("FBookedDate")) continue;
                    String[] sDate = value.toString().split("\\-");
                    drs.updateString("FDateYear", sDate[0]);
                    drs.updateString("FDateMonth", sDate[1]);
                    drs.updateString("FDateDay", sDate[2]);
                    fDateYear = true;
                }
                if (!fDateYear) {
                    String period = (String)this.vars.get("Period");
                    int start = period.indexOf(":");
                    drs.updateString("FDateYear", period.substring(period.indexOf(":") + 1, start + 5));
                    try {
                        Integer.parseInt(period.substring(period.indexOf(":") + 7, start + 9));
                        drs.updateString("FDateMonth", period.substring(period.indexOf(":") + 7, start + 9));
                    }
                    catch (Exception e) {
                        drs.updateString("FDateMonth", "0" + period.substring(period.indexOf(":") + 7, start + 8));
                    }
                }
                drs.updateString("FAsstAccountNameGroup", this.getAsstGroupName(this.rs));
                this.updateAssTitle(drs);
                drs.insertRow();
                if (!config.isBF()) continue;
                int currIndex = this.rs.getCurrRowIndex();
                if ((rowCount + 1) % rowLineCount == 0 && this.rs.next() && this.rs.next()) {
                    String itID = this.rs.getString("FAccountID");
                    if (config.isPageByAsst()) {
                        itID = itID + this.getAsstItem(this.rs);
                    } else if (itID.equals(lastItemID)) {
                        String creditRpt;
                        drs.moveToInsertRow();
                        this.clearValue(drs);
                        drs.updateString("FDescription", this.strOverHypoPage);
                        String debitFor = config.isSumPeriod() ? "FDebitFor" : "FYearDebitFor";
                        String debitLocal = config.isSumPeriod() ? "FDebitLocal" : "FYearDebitLocal";
                        String debitRpt = config.isSumPeriod() ? "FDebitRpt" : "FYearDebitRpt";
                        String creditFor = config.isSumPeriod() ? "FCreditFor" : "FYearCreditFor";
                        String creditLocal = config.isSumPeriod() ? "FCreditLocal" : "FYearCreditLocal";
                        String string = creditRpt = config.isSumPeriod() ? "FCreditRpt" : "FYearCreditRpt";
                        if (this.rs.indexOf(debitFor) != -1) {
                            drs.updateString("FDebitFor", this.getFormatedValue(this.rs.getBigDecimal(currIndex, debitFor), precision));
                            if (isBaseCurrency) {
                                drs.updateString("FDebitLocal", this.getFormatedValue(this.rs.getBigDecimal(currIndex, debitFor), baseCurrency.getPrecision()));
                            }
                        }
                        if (this.rs.indexOf(debitLocal) != -1) {
                            drs.updateString("FDebitLocal", this.getFormatedValue(this.rs.getBigDecimal(currIndex, debitLocal), baseCurrency.getPrecision()));
                        }
                        if (this.rs.indexOf(debitRpt) != -1) {
                            drs.updateString("FDebitRpt", this.getFormatedValue(this.rs.getBigDecimal(currIndex, debitRpt), rptCurrency.getPrecision()));
                        }
                        if (this.rs.indexOf(creditFor) != -1) {
                            drs.updateString("FCreditFor", this.getFormatedValue(this.rs.getBigDecimal(currIndex, creditFor), precision));
                        }
                        if (this.rs.indexOf(creditLocal) != -1) {
                            drs.updateString("FCreditLocal", this.getFormatedValue(this.rs.getBigDecimal(currIndex, creditLocal), baseCurrency.getPrecision()));
                        }
                        if (this.rs.indexOf(creditRpt) != -1) {
                            drs.updateString("FCreditRpt", this.getFormatedValue(this.rs.getBigDecimal(currIndex, creditRpt), rptCurrency.getPrecision()));
                        }
                        drs.insertRow();
                        ++rowCount;
                        drs.moveToInsertRow();
                        this.clearValue(drs);
                        drs.updateString("FDescription", this.strBearForwardPage);
                        ++rowCount;
                        drs.insertRow();
                    }
                }
                this.rs.absolute(currIndex);
            }
            drs.beforeFirst();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            e.printStackTrace();
            SysUtil.abort();
        }
        return drs;
    }

    private String getFormatedValue(BigDecimal value, int scale) {
        if (value == null) {
            value = GlUtils.zero;
        }
        return GlUtils.withComma((BigDecimal)value, (int)scale);
    }

    private String getAsstGroupName(GLRptRowSet rs) throws BOSException, SQLException {
        StringBuffer asstGroupName = new StringBuffer();
        for (int i = 0; i < 8 && rs.indexOf("FAsstAccountName" + i) != -1; ++i) {
            String asstName = rs.getString("FAsstAccountName" + i);
            if (i > 0 && asstName != null) {
                asstGroupName.append(";");
            }
            if (asstName == null) continue;
            asstGroupName.append(asstName);
        }
        if (asstGroupName.length() == 0) {
            return "";
        }
        return asstGroupName.toString();
    }

    private void updateAssTitle(DynamicRowSet drs) throws BOSException, SQLException {
        String assGroupName = drs.getString("FAsstAccountNameGroup");
        for (int i = 0; i < 8; ++i) {
            drs.updateString("FAsstAccountName" + i + "Title", drs.getString("FAsstAccountName" + i));
        }
        drs.updateString("FAsstAccountNameGroupTitle", assGroupName);
    }

    private void clearValue(DynamicRowSet drs) throws SQLException {
        drs.updateString("FDateDay", "");
        drs.updateString("FDate", "");
        drs.updateString("FVoucherNumber", "");
        drs.updateString("FCurrencyName", "");
        drs.updateString("FBaseRate", "");
        drs.updateString("FRptRate", "");
        drs.updateString("FDebitUnit", "");
        drs.updateString("FCreditUnit", "");
        drs.updateString("FBalanceUnit", "");
        drs.updateString("FBizNumber", "");
        drs.updateString("FInvoiceNumber", "");
        drs.updateString("FSettlementCode", "");
        drs.updateString("FSettlementType", "");
        drs.updateString("FTicketNumber", "");
    }

    private String getAsstItem(GLRptRowSet rs) throws BOSException, SQLException {
        StringBuffer asstItemName = new StringBuffer();
        String[] keys = rs.getColumKeys();
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].startsWith("FAsstAccountName")) continue;
            if (asstItemName.length() > 0) {
                asstItemName.append(";");
            }
            asstItemName.append(rs.getString(keys[i]));
        }
        return asstItemName.toString();
    }

    private void clearRow(IRowSet rs) throws Exception {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        for (int i = 21; i <= colCount; ++i) {
            rs.updateString(i, null);
        }
    }
}

