/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.upgrade;

import com.kingdee.bos.Context;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.RecordBaseCollection;
import com.kingdee.eas.el.rec.RecordBaseFactory;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.upgrade.RbOutPutXmlUpgrad;
import com.kingdee.eas.util.app.DbUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;

public class RbOutPutXmlUpgrad_V2
extends RbOutPutXmlUpgrad {
    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public void doUpgrad(Context ctx) throws RecException {
        this.syncDocType(ctx);
        this.enableInvoice(ctx);
        this.addAccountdimensions(ctx);
    }

    private void addAccountdimensions(Context ctx) throws RecException {
        try {
            RecordBaseCollection rbColl = RecordBaseFactory.getLocalInstance(ctx).getRecordBaseCollection("select outputXmlTemplate where billType.bosType = '2652E01E'");
            String defaultSql = "update t_rec_recordbase set FOUTPUTXMLTEMPLATE= ? where FID = ? ";
            for (int i = 0; i < rbColl.size(); ++i) {
                RecordBaseInfo recordBaseInfo = rbColl.get(i);
                Document xmlDoc = this.xml2Document(recordBaseInfo.getOutPutXMLTemplate());
                Element root = xmlDoc.getRootElement();
                Element rule_list = root.element("rule-list");
                List elements = rule_list.elements("rule");
                boolean hasDemension = false;
                for (Element el : elements) {
                    Element elDestField = el.element("destfield");
                    if (!"jeline-list.jeline.accountdimensions".equals(elDestField.getTextTrim())) continue;
                    hasDemension = true;
                    break;
                }
                if (hasDemension) continue;
                this.addRuleElement(rule_list, "\u6838\u7b97\u7ef4\u5ea6", "entries.assistRecords.assGrp.longNameGroup", "jeline-list.jeline.accountdimensions", "{\"expr\":\"entry(#0,{entries[all].assistRecords[appendNoDup].assGrp.longNameGroup})\"}");
                DbUtil.execute((Context)ctx, (String)defaultSql, (Object[])new Object[]{RbOutPutXmlUpgrad_V2.document2Xml(xmlDoc), recordBaseInfo.getId().toString()});
            }
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"addAccountdimensions \u5f02\u5e38"});
        }
    }

    private void enableInvoice(Context ctx) throws RecException {
        try {
            RecordBaseCollection rbColl = RecordBaseFactory.getLocalInstance(ctx).getRecordBaseCollection("select outputXmlTemplate where billType.bosType in ('4A44F49F','C57003BC','92F938DD')");
            String defaultSql = "update t_rec_recordbase set FOUTPUTXMLTEMPLATE= ?,FINVOICE = ? where FID = ? ";
            for (int i = 0; i < rbColl.size(); ++i) {
                RecordBaseInfo recordBaseInfo = rbColl.get(i);
                Document xmlDoc = this.xml2Document(recordBaseInfo.getOutPutXMLTemplate());
                Element root = xmlDoc.getRootElement();
                Element rule_list = root.element("rule-list");
                List elements = rule_list.elements("rule");
                boolean hasInvoiceCode = false;
                boolean hasInvoiceSerialno = false;
                boolean hasInvoiceNo = false;
                boolean downloadUrl = false;
                for (Element el : elements) {
                    Element elDestField = el.element("destfield");
                    if ("invoice-list.invoice.invoicecode".equals(elDestField.getTextTrim())) {
                        hasInvoiceCode = true;
                    }
                    if ("invoice-list.invoice.serialno".equals(elDestField.getTextTrim())) {
                        hasInvoiceSerialno = true;
                    }
                    if ("invoice-list.invoice.invoiceno".equals(elDestField.getTextTrim())) {
                        hasInvoiceNo = true;
                    }
                    if ("invoice-list.invoice.downloadurl".equals(elDestField.getTextTrim())) {
                        downloadUrl = true;
                    }
                    if (!hasInvoiceCode || !hasInvoiceSerialno || !hasInvoiceNo) continue;
                    break;
                }
                if (!hasInvoiceCode) {
                    this.addRuleElement(rule_list, "\u53d1\u7968\u53f7\u7801", "tickeEntries.ticketNumber", "invoice-list.invoice.invoicecode", "");
                }
                if (!hasInvoiceSerialno) {
                    this.addRuleElement(rule_list, "\u53d1\u7968\u6d41\u6c34\u53f7", "tickeEntries.serialNo", "invoice-list.invoice.serialno", "");
                }
                if (!hasInvoiceNo) {
                    this.addRuleElement(rule_list, "\u53d1\u7968\u8868\u5934", "tickeEntries.ticketCode", "invoice-list.invoice.invoiceno", "");
                }
                if (!downloadUrl) {
                    this.addRuleElement(rule_list, "\u53d1\u7968\u4e0b\u8f7d\u5730\u5740", "", "invoice-list.invoice.downloadurl", "");
                }
                if (hasInvoiceCode && hasInvoiceSerialno && hasInvoiceNo && downloadUrl) continue;
                DbUtil.execute((Context)ctx, (String)defaultSql, (Object[])new Object[]{RbOutPutXmlUpgrad_V2.document2Xml(xmlDoc), 1, recordBaseInfo.getId().toString()});
            }
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"enableInvoice \u5f02\u5e38"});
        }
    }

    private void syncDocType(Context ctx) throws RecException {
        try {
            RecordBaseCollection rbColl = RecordBaseFactory.getLocalInstance(ctx).getRecordBaseCollection("select outputXmlTemplate, xmlDocType where recordType = 'bill'");
            String defaultSql = "update t_rec_recordbase set FOUTPUTXMLTEMPLATE= ? where FID = ? ";
            for (int i = 0; i < rbColl.size(); ++i) {
                RecordBaseInfo recordBaseInfo = rbColl.get(i);
                Document xmlDoc = this.xml2Document(recordBaseInfo.getOutPutXMLTemplate());
                Element root = xmlDoc.getRootElement();
                Element doctypeEl = root.element("doctype");
                String textTrim = doctypeEl.getTextTrim();
                String xmlDocType = recordBaseInfo.getXmlDocType();
                if (StringUtils.isEmpty((String)xmlDocType) || xmlDocType.equals(textTrim)) continue;
                doctypeEl.setText(xmlDocType);
                DbUtil.execute((Context)ctx, (String)defaultSql, (Object[])new Object[]{RbOutPutXmlUpgrad_V2.document2Xml(xmlDoc), recordBaseInfo.getId().toString()});
            }
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"syncDocType \u5f02\u5e38"});
        }
    }
}

