/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.directDeliveryPlan.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.directDeliveryPlan.SDDPFBStatus;
import com.kingdee.eas.industry.directDeliveryPlan.SonDPMapVO;
import com.kingdee.eas.industry.directDeliveryPlan.SonDeliveryPlanSTVO;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryFBCollection;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryFBEntryInfo;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryFBFactory;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryFBInfo;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanFBdetialVO;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanSPurEntryCollection;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanSPurEntryFactory;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanSPurEntryInfo;
import com.kingdee.eas.industry.directDeliveryPlan.app.AbstractSonDirectDeliveryFBFacadeControllerBean;
import com.kingdee.eas.industry.emm.project.biz.psp.util.FBDetailSpVO;
import com.kingdee.eas.industry.emm.project.biz.psp.util.FbVO;
import com.kingdee.eas.industry.emm.project.biz.psp.util.SpVO;
import com.kingdee.eas.industry.emm.scm.sm.directdelivery.DirectDeliveryFBEntryFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.time.DateUtils;

public class SonDirectDeliveryFBFacadeControllerBean
extends AbstractSonDirectDeliveryFBFacadeControllerBean {
    private static final long serialVersionUID = 3208712229558380933L;

    private void deleteFBusedQty(Context ctx, String fbdID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" \n");
        sql.append("  delete from CT_SM_SonDDPTOFB   \n");
        sql.append("  where fdpFBdetailid = '").append(fbdID).append("' \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected String _singleSupply(Context ctx, IObjectValue param) throws BOSException, EASBizException {
        if (param == null) {
            return "\u53c2\u6570\u4f20\u9012\u4e3a\u7a7a";
        }
        SonDirectDeliveryFBInfo info = (SonDirectDeliveryFBInfo)param;
        BigDecimal totalQty = info.getSupDeQty() == null ? BigDecimal.ZERO : info.getSupDeQty();
        this.deleteFBusedQty(ctx, info.getId().toString());
        if (totalQty.compareTo(BigDecimal.ZERO) <= 0) {
            totalQty = BigDecimal.ZERO;
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("  /*dialect*/ \n");
        sql.append(" select dp.fid as fid ,max(dp.fqty) as qty,sum(pfb.fusefbqty) as useqty,min(sddp.fbizdate) as redate    \n");
        sql.append(" from ct_sm_sonddpspe dp \n");
        sql.append(" left join ct_sm_sondirectdeliveryplan sddp on dp.fparentid = sddp.fid");
        sql.append(" left join CT_SM_SonDDPTOFB pfb on pfb.fdpmergeid = dp.fid    \n");
        sql.append(" where nvl(sddp.fsupplierid,'0') = '").append(info.getSupplier() != null ? info.getSupplier().getId().toString() : "0").append("'  \n");
        sql.append(" and nvl(dp.fprojectid,'0') = '").append(info.getProject() != null ? info.getProject().getId().toString() : "0").append("'  \n");
        sql.append(" and nvl(dp.ftracknumberid,'0')= '").append(info.getTrackNumber() != null ? info.getTrackNumber().getId().toString() : "0").append("'  \n");
        sql.append(" and nvl(sddp.fstorageorgunitid,'0') = '").append(info.getStorageOrgUnit() != null ? info.getStorageOrgUnit().getId().toString() : "0").append("'  \n");
        sql.append(" and dp.fmaterialid = '").append(info.getMaterial() != null ? info.getMaterial().getId().toString() : "0").append("'  \n");
        sql.append(" and sddp.fbizdate >= ");
        sql.append(" to_date('").append(info.getSupDeDate()).append("' ,'yyyy-MM-dd')");
        sql.append(" group by dp.fid  \n");
        sql.append(" order by redate  \n");
        IRowSet irs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (irs != null) {
            try {
                while (irs.next() && totalQty.compareTo(BigDecimal.ZERO) > 0) {
                    String spfid = irs.getString("fid");
                    BigDecimal spQty = irs.getBigDecimal("qty");
                    BigDecimal userQty = irs.getBigDecimal("useqty") == null ? BigDecimal.ZERO : irs.getBigDecimal("useqty");
                    Date reDate = irs.getDate("redate");
                    if (userQty.compareTo(spQty) >= 0) continue;
                    if ((spQty = spQty.subtract(userQty)).compareTo(totalQty) < 0) {
                        this.updateFBTOTable(ctx, info, spfid, spQty, reDate);
                        totalQty = totalQty.subtract(spQty);
                        continue;
                    }
                    this.updateFBTOTable(ctx, info, spfid, totalQty, reDate);
                    totalQty = BigDecimal.ZERO;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new EASBizException(new NumericExceptionSubItem("\u53cd\u9988\u5931\u8d25\uff01", "\u53cd\u9988\u5931\u8d25\uff1a\n" + e.getMessage()));
            }
        }
        return "true";
    }

    private void updateFBTOTable(Context ctx, SonDirectDeliveryFBInfo info, String spid, BigDecimal useQty, java.util.Date reDate) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" \n");
        sql.append("  /*dialect*/ \n");
        sql.append(" insert into CT_SM_SonDDPTOFB (fid,fdpMergeID ,fdpFBdetailid,fusefbqty,fdemanddate,fsupplydate)  \n");
        sql.append(" VALUES ( \n");
        sql.append(" newbosid('88888888') ,");
        sql.append("'").append(spid).append("' ,");
        sql.append("'").append(info.getId().toString()).append("' ,");
        sql.append("").append(useQty).append(" ,");
        sql.append("to_date('").append(reDate).append("' ,'yyyy-mm-dd'),");
        sql.append("to_date('").append(info.getSupDeDate()).append("' ,'yyyy-mm-dd') )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private java.util.Date getZERO(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private java.util.Date getMaxDay(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    @Override
    protected HashMap _queryDeliveryPlanMerge(Context ctx, HashMap param) throws BOSException, EASBizException {
        HashMap<Object, Object> mapR = new HashMap();
        SonDirectDeliveryPlanSPurEntryCollection colls = SonDirectDeliveryPlanSPurEntryFactory.getLocalInstance(ctx).getSonDirectDeliveryPlanSPurEntryCollection(this.getQueryCondition(param));
        mapR = this.reorganizeSpurEntry(ctx, colls);
        return mapR;
    }

    private EntityViewInfo getQueryCondition(HashMap param) {
        FilterInfo filter = (FilterInfo)param.get("queryString");
        EntityViewInfo viewinfo = new EntityViewInfo();
        viewinfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("parent.supplier.id"));
        selector.add(new SelectorItemInfo("parent.supplier.number"));
        selector.add(new SelectorItemInfo("parent.supplier.name"));
        selector.add(new SelectorItemInfo("parent.bizDate"));
        selector.add(new SelectorItemInfo("storage.id"));
        selector.add(new SelectorItemInfo("storage.name"));
        selector.add(new SelectorItemInfo("storage.number"));
        selector.add(new SelectorItemInfo("supplier.id"));
        selector.add(new SelectorItemInfo("supplier.name"));
        selector.add(new SelectorItemInfo("supplier.number"));
        selector.add(new SelectorItemInfo("material.id"));
        selector.add(new SelectorItemInfo("material.name"));
        selector.add(new SelectorItemInfo("material.number"));
        selector.add(new SelectorItemInfo("project.id"));
        selector.add(new SelectorItemInfo("project.name"));
        selector.add(new SelectorItemInfo("project.number"));
        selector.add(new SelectorItemInfo("tracknumber.id"));
        selector.add(new SelectorItemInfo("tracknumber.name"));
        selector.add(new SelectorItemInfo("tracknumber.number"));
        selector.add(new SelectorItemInfo("unit.id"));
        selector.add(new SelectorItemInfo("unit.name"));
        selector.add(new SelectorItemInfo("unit.number"));
        selector.add(new SelectorItemInfo("*"));
        viewinfo.setSelector(selector);
        return viewinfo;
    }

    private BigDecimal getSupplyQty(Context ctx, String mergeid) throws BOSException, EASBizException {
        BigDecimal supplyqty = BigDecimal.ZERO;
        StringBuffer sql = new StringBuffer();
        sql.append("select fusefbqty from CT_SM_SonDDPTOFB where fdpmergeid = '").append(mergeid).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                supplyqty = supplyqty.add(rs.getBigDecimal("fusefbqty"));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return supplyqty;
    }

    private HashMap<String, Object> reorganizeSpurEntry(Context ctx, SonDirectDeliveryPlanSPurEntryCollection colls) throws BOSException, EASBizException {
        HashMap<String, Object> mapR = new HashMap<String, Object>();
        HashMap<String, SonDeliveryPlanSTVO> spVO_map = new HashMap<String, SonDeliveryPlanSTVO>();
        HashSet<java.util.Date> setOfTime = new HashSet<java.util.Date>();
        for (int n = 0; n < colls.size(); ++n) {
            List<SonDirectDeliveryPlanSPurEntryInfo> spList;
            SonDPMapVO sdVo;
            HashMap<java.util.Date, SonDPMapVO> sdMap;
            SonDirectDeliveryPlanSPurEntryInfo spurentryinfo = colls.get(n);
            java.util.Date demandDate = spurentryinfo.getParent().getBizDate();
            setOfTime.add(this.getZERO(demandDate));
            BigDecimal supplyQty = this.getSupplyQty(ctx, spurentryinfo.getId().toString());
            BigDecimal deliveredQty = BigDecimal.ZERO;
            BigDecimal demandqty = spurentryinfo.getQty();
            if (demandqty.compareTo(BigDecimal.ZERO) == 0) continue;
            String key = this.getDimensionKey(spurentryinfo);
            SonDeliveryPlanSTVO spVo = new SonDeliveryPlanSTVO();
            if (spVO_map.containsKey(key)) {
                spVo = (SonDeliveryPlanSTVO)spVO_map.get(key);
                sdMap = spVo.getSdMap();
                sdVo = new SonDPMapVO();
                if (sdMap.containsKey(demandDate)) {
                    sdVo = sdMap.get(demandDate);
                    sdVo.setDemandQty(sdVo.getDemandQty().add(demandqty));
                    sdVo.setSupplierQty(sdVo.getSupplierQty().add(supplyQty != null ? supplyQty : BigDecimal.ZERO));
                    sdVo.setDeliveredQty(sdVo.getDeliveredQty().add(deliveredQty != null ? deliveredQty : BigDecimal.ZERO));
                    spList = sdVo.getDPList();
                    spList.add(spurentryinfo);
                    sdVo.setDPList(spList);
                } else {
                    sdVo.setDemandDate(demandDate);
                    sdVo.setDemandQty(demandqty);
                    sdVo.setSupplierQty(supplyQty != null ? supplyQty : BigDecimal.ZERO);
                    sdVo.setDeliveredQty(deliveredQty != null ? deliveredQty : BigDecimal.ZERO);
                    spList = new ArrayList<SonDirectDeliveryPlanSPurEntryInfo>();
                    spList.add(spurentryinfo);
                    sdVo.setDPList(spList);
                }
                sdMap.put(demandDate, sdVo);
                spVo.setSdMap(sdMap);
            } else {
                spVo.setMaterialID(spurentryinfo.getMaterial() == null ? null : spurentryinfo.getMaterial().getId().toString());
                spVo.setMaterialName(spurentryinfo.getMaterial() == null ? null : spurentryinfo.getMaterial().getName());
                spVo.setMaterialNumber(spurentryinfo.getMaterial() == null ? null : spurentryinfo.getMaterial().getNumber());
                spVo.setSupplyStroageOrgUnitID(spurentryinfo.getStorage() == null ? null : spurentryinfo.getStorage().getId().toString());
                spVo.setSupplyStroageOrgUnitName(spurentryinfo.getStorage() == null ? null : spurentryinfo.getStorage().getName());
                spVo.setSupplyStroageOrgUnitNumber(spurentryinfo.getStorage() == null ? null : spurentryinfo.getStorage().getNumber());
                spVo.setProjectID(spurentryinfo.getProject() == null ? null : spurentryinfo.getProject().getId().toString());
                spVo.setProjectName(spurentryinfo.getProject() == null ? null : spurentryinfo.getProject().getName());
                spVo.setProjectNumber(spurentryinfo.getProject() == null ? null : spurentryinfo.getProject().getNumber());
                spVo.setTrackNumberID(spurentryinfo.getTracknumber() == null ? null : spurentryinfo.getTracknumber().getId().toString());
                spVo.setTrackNumberName(spurentryinfo.getTracknumber() == null ? null : spurentryinfo.getTracknumber().getName());
                spVo.setTrackNumberNumber(spurentryinfo.getTracknumber() == null ? null : spurentryinfo.getTracknumber().getNumber());
                spVo.setSupplierID(spurentryinfo.getParent().getSupplier() == null ? null : spurentryinfo.getParent().getSupplier().getId().toString());
                spVo.setSupplierName(spurentryinfo.getParent().getSupplier() == null ? null : spurentryinfo.getParent().getSupplier().getName());
                spVo.setSupplierNumber(spurentryinfo.getParent().getSupplier() == null ? null : spurentryinfo.getParent().getSupplier().getNumber());
                spVo.setBaseunitID(spurentryinfo.getUnit() == null ? null : spurentryinfo.getUnit().getId().toString());
                spVo.setBaseunitName(spurentryinfo.getUnit() == null ? null : spurentryinfo.getUnit().getName());
                spVo.setBaseunitNumber(spurentryinfo.getUnit() == null ? null : spurentryinfo.getUnit().getNumber());
                spVo.setPurchaseorgid(spurentryinfo.getPurchaseorg() == null ? null : spurentryinfo.getPurchaseorg().getId().toString());
                sdMap = new HashMap();
                sdVo = new SonDPMapVO();
                sdVo.setDemandDate(demandDate);
                sdVo.setDemandQty(demandqty);
                sdVo.setSupplierQty(supplyQty != null ? supplyQty : BigDecimal.ZERO);
                sdVo.setDeliveredQty(deliveredQty != null ? deliveredQty : BigDecimal.ZERO);
                spList = new ArrayList();
                spList.add(spurentryinfo);
                sdVo.setDPList(spList);
                sdMap.put(demandDate, sdVo);
                spVo.setSdMap(sdMap);
            }
            spVO_map.put(key, spVo);
        }
        mapR.put("spVO_map", spVO_map);
        mapR.put("setOfTime", setOfTime);
        return mapR;
    }

    private String getDimensionKey(SonDirectDeliveryPlanSPurEntryInfo spurentryinfo) {
        StringBuffer key = new StringBuffer();
        key.append(spurentryinfo.getParent().getSupplier() != null ? spurentryinfo.getParent().getSupplier().getId().toString() : "#");
        key.append(spurentryinfo.getStorage() != null ? spurentryinfo.getStorage().getId().toString() : "#");
        key.append(spurentryinfo.getMaterial().getId().toString());
        key.append(spurentryinfo.getProject() != null ? spurentryinfo.getProject().getId().toString() : "#");
        key.append(spurentryinfo.getTracknumber() != null ? spurentryinfo.getTracknumber().getId().toString() : "#");
        key.append(spurentryinfo.getPurchaseorg() != null ? spurentryinfo.getPurchaseorg().getId().toString() : "#");
        return key.toString();
    }

    @Override
    protected IObjectValue _getExsitFBInfo(Context ctx, HashMap param) throws BOSException, EASBizException {
        SonDirectDeliveryPlanFBdetialVO spVo = (SonDirectDeliveryPlanFBdetialVO)param.get("spVo");
        String supplyStorageid = spVo.getSupplyStroageOrgUnit() != null ? spVo.getSupplyStroageOrgUnit().getId().toString() : "0";
        String materialid = spVo.getMaterial().getId().toString();
        String supplierid = spVo.getSupplier().getId().toString();
        String projectid = spVo.getProject() != null ? spVo.getProject().getId().toString() : "0";
        String tracknumid = spVo.getTrackNumber() != null ? spVo.getTrackNumber().getId().toString() : "0";
        java.util.Date demandDate = spVo.getDemandDate();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialid, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supplierid, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)projectid, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("trackNumber.id", (Object)tracknumid, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("deliveryDate", (Object)this.getZERO(demandDate), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("deliveryDate", (Object)this.getMaxDay(demandDate), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("supplyStorageOrgUnit.id", (Object)supplyStorageid, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)"20", CompareType.EQUALS));
        view.setFilter(filter);
        SonDirectDeliveryFBCollection colls = SonDirectDeliveryFBFactory.getLocalInstance(ctx).getSonDirectDeliveryFBCollection(view);
        if (colls != null && colls.size() > 0) {
            return colls.get(0);
        }
        return super._getExsitFBInfo(ctx, param);
    }

    @Override
    protected HashMap _refreshSupplyList(Context ctx, HashMap param) throws BOSException, EASBizException {
        String purorgid = (String)param.get("PURORGID");
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" update CT_SM_SonDirectDeliveryFB set cfbasestatus = '10' \n");
        sql.append(" where cfsupdeqty = cfdeliveryqty \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("/*dialect*/");
        sql.append(" \n");
        sql.append(" update CT_SM_SonDirectDeliveryFB set cfuncloseqty = nvl(CFSupDeQty,0) - nvl(CFDeliveryQty,0) \n");
        sql.append(" where 1=1 \n");
        sql.append(" and FPurOrgID = '" + purorgid + "' \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" /*dialect*/ \n");
        sql.append(" select sc.fid , nvl(sc.cfsupdeqty,0)-nvl(sc.cfdeliveryqty ,0) as qty ,sc.cfsupdedate as  fbdate , \n");
        sql.append(" sc.fpurorgid,sc.cfsupplystorageorg,sc.cfmaterialid , \n");
        sql.append(" sc.cfprojectid ,sc.cftracknumberid ,sc.cfsupplierid \n");
        sql.append(" from CT_SM_SonDirectDeliveryFB sc \n");
        sql.append(" where sc.cfbasestatus = '20' \n");
        sql.append(" order by sc.cfsupdedate  \n");
        IRowSet irs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, FBDetailSpVO> fb_Map = new HashMap<String, FBDetailSpVO>();
        if (irs != null) {
            try {
                while (irs.next()) {
                    ArrayList<FbVO> fbList;
                    FBDetailSpVO fspVO;
                    String purchaseorgunitid = irs.getString("fpurorgid");
                    String materialid = irs.getString("cfmaterialid");
                    String projectid = irs.getString("cfprojectid");
                    String tracknumberid = irs.getString("cftracknumberid");
                    String supplierid = irs.getString("cfsupplierid");
                    String supplyorgunitid = irs.getString("cfsupplystorageorg");
                    String fid = irs.getString("fid");
                    BigDecimal qty = irs.getBigDecimal("qty");
                    Date fbDate = irs.getDate("fbDate");
                    String key = "#" + purchaseorgunitid + "#" + supplyorgunitid + "#" + supplierid + "#" + materialid + "#" + (projectid == null ? "" : projectid) + "#" + (tracknumberid == null ? "" : tracknumberid);
                    if (fb_Map.containsKey(key)) {
                        fspVO = (FBDetailSpVO)fb_Map.get(key);
                        fbList = fspVO.getFbList();
                        fbList.add(new FbVO((java.util.Date)fbDate, fid, qty));
                        fspVO.setFbList(fbList);
                        fb_Map.put(key, fspVO);
                        continue;
                    }
                    fspVO = new FBDetailSpVO();
                    fbList = new ArrayList<FbVO>();
                    fbList.add(new FbVO((java.util.Date)fbDate, fid, qty));
                    fspVO.setFbList(fbList);
                    fb_Map.put(key, fspVO);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new EASBizException(new NumericExceptionSubItem("\u53cd\u9988\u5237\u65b0\u5931\u8d25\uff01", "\u53cd\u9988\u5237\u65b0\u5931\u8d25\uff1a\n" + e.getMessage()));
            }
        }
        sql.setLength(0);
        sql.append(" /*dialect*/ \n");
        sql.append("  select a.fid,nvl(a.fqty,0) as fqty,b.fbizdate rdate,\n");
        sql.append("  a.fpurorgid,a.fstroageid ,a.fmaterialid,a.fprojectid,a.ftracknumberid,a.fsupplierid\n");
        sql.append("  from Ct_Sm_Sonddpspe a left join ct_sm_sondirectdeliveryplan b on a.fparentid = b.fid \n");
        sql.append("  order by b.fbizdate\n");
        IRowSet irs_SP = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (irs_SP != null) {
            try {
                while (irs_SP.next()) {
                    String purchaseorgunitid = irs_SP.getString("fpurorgid");
                    String materialid = irs_SP.getString("fmaterialid");
                    String projectid = irs_SP.getString("fprojectid");
                    String tracknumberid = irs_SP.getString("ftracknumberid");
                    String supplierid = irs_SP.getString("fsupplierid");
                    String supplyorgunitid = irs_SP.getString("fstroageid");
                    String fid = irs_SP.getString("fid");
                    BigDecimal spqty = irs_SP.getBigDecimal("fqty");
                    Date spDate = irs_SP.getDate("rdate");
                    String key = "#" + purchaseorgunitid + "#" + supplyorgunitid + "#" + supplierid + "#" + materialid + "#" + (projectid == null ? "" : projectid) + "#" + (tracknumberid == null ? "" : tracknumberid);
                    if (!fb_Map.containsKey(key)) continue;
                    FBDetailSpVO fspVO = (FBDetailSpVO)fb_Map.get(key);
                    ArrayList spList = fspVO.getSpList();
                    spList.add(new SpVO((java.util.Date)spDate, fid, spqty));
                    fspVO.setSpList(spList);
                    fb_Map.put(key, fspVO);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new EASBizException(new NumericExceptionSubItem("\u53cd\u9988\u5237\u65b0\u5931\u8d25\uff01", "\u53cd\u9988\u5237\u65b0\u5931\u8d25\uff1a\n" + e.getMessage()));
            }
        }
        Set keys = fb_Map.keySet();
        for (Object key : keys) {
            FBDetailSpVO fspVO = (FBDetailSpVO)fb_Map.get(key);
            this.handleProcess(ctx, fspVO, purorgid);
        }
        return super._refreshSupplyList(ctx, param);
    }

    private void handleProcess(Context ctx, FBDetailSpVO fspVO, String purorgid) throws EASBizException {
        ArrayList fbList = fspVO.getFbList();
        ArrayList spList = fspVO.getSpList();
        if (spList == null || spList.size() == 0) {
            return;
        }
        int spCount = spList.size();
        int j = 0;
        for (int i = 0; i < fbList.size(); ++i) {
            FbVO fbVO = (FbVO)fbList.get(i);
            BigDecimal fbQty = fbVO.getQty();
            java.util.Date fbDate = fbVO.getFbDate();
            while (fbQty.compareTo(BigDecimal.ZERO) > 0 && j < spCount) {
                SpVO spVO = (SpVO)spList.get(j);
                if (DateUtils.isSameDay((java.util.Date)spVO.getSpDate(), (java.util.Date)fbDate) || this.getZERO(spVO.getSpDate()).after(this.getZERO(fbDate))) {
                    BigDecimal spQty = spVO.getSpqty();
                    if (spQty.compareTo(BigDecimal.ZERO) == 0) {
                        ++j;
                        continue;
                    }
                    if (spQty.compareTo(fbQty) > 0) {
                        this.insetNewRelation(ctx, fbVO, spVO, fbQty, purorgid);
                        fbQty = BigDecimal.ZERO;
                        spVO.setSpqty(spQty.subtract(fbQty));
                        spList.set(j, spVO);
                        continue;
                    }
                    if (spQty.compareTo(fbQty) == 0) {
                        this.insetNewRelation(ctx, fbVO, spVO, fbQty, purorgid);
                        fbQty = BigDecimal.ZERO;
                        spVO.setSpqty(BigDecimal.ZERO);
                        spList.set(j, spVO);
                        ++j;
                        continue;
                    }
                    if (spQty.compareTo(fbQty) >= 0) continue;
                    this.insetNewRelation(ctx, fbVO, spVO, spQty, purorgid);
                    fbQty = fbQty.subtract(spQty);
                    spVO.setSpqty(BigDecimal.ZERO);
                    spList.set(j, spVO);
                    ++j;
                    continue;
                }
                ++j;
            }
            if (j >= spCount) break;
        }
    }

    private void insetNewRelation(Context ctx, FbVO fbVO, SpVO spVO, BigDecimal useQty, String purorgid) throws EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" \n");
        sql.append("  /*dialect*/ \n");
        sql.append(" insert into CT_SM_SonDDPTOFB (fid,fdpMergeID ,fdpFBdetailid,fusefbqty,fdemanddate,fsupplydate,fpurorgid)   \n");
        sql.append(" VALUES ( \n");
        sql.append(" newbosid('88888888') ,");
        sql.append("'").append(spVO.getSpID()).append("' ,");
        sql.append("'").append(fbVO.getFbID()).append("' ,");
        sql.append("").append(useQty).append(" ,");
        sql.append("to_date('").append(spVO.getSpDate()).append("' ,'yyyy-mm-dd'),");
        sql.append("to_date('").append(fbVO.getFbDate()).append("' ,'yyyy-mm-dd'),");
        sql.append("'").append(purorgid).append("' )");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem("\u53cd\u9988\u5237\u65b0\u5931\u8d25\uff01", "\u53cd\u9988\u5237\u65b0\u5931\u8d25\uff1a\n" + e.getMessage()));
        }
    }

    protected String getBillNumber(Context ctx, IObjectValue billInfo, String bizOrgUnitID) throws BOSException, EASBizException {
        String billNumber = null;
        CodingRuleInfo ruleInfo = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule(billInfo, bizOrgUnitID);
        if (ruleInfo != null) {
            billNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber(billInfo, ruleInfo);
        }
        return billNumber;
    }

    @Override
    protected String _singleSupply4Port(Context ctx, SonDirectDeliveryPlanFBdetialVO param) throws BOSException, EASBizException {
        if (param == null) {
            return "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a";
        }
        HashMap<String, SonDirectDeliveryPlanFBdetialVO> map = new HashMap<String, SonDirectDeliveryPlanFBdetialVO>();
        map.put("spVo", param);
        IObjectValue obj = this._getExsitFBInfo(ctx, map);
        SonDirectDeliveryFBInfo fbInfo = new SonDirectDeliveryFBInfo();
        fbInfo.setNumber(this.getBillNumber(ctx, (IObjectValue)fbInfo, ContextUtil.getCurrentCtrlUnit((Context)ctx) != null ? ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() : ""));
        if (obj != null) {
            fbInfo = (SonDirectDeliveryFBInfo)obj;
            SonDirectDeliveryFBEntryInfo fbeInfo = new SonDirectDeliveryFBEntryInfo();
            fbeInfo.setProject(fbInfo.getProject());
            fbeInfo.setParent(fbInfo);
            fbeInfo.setStorageOrgUnit(fbInfo.getStorageOrgUnit());
            fbeInfo.setSupplyStorageOrgUnit(fbInfo.getSupplyStorageOrgUnit());
            fbeInfo.setSupplier(fbInfo.getSupplier());
            fbeInfo.setFbPerson(fbInfo.getFbPerson());
            fbeInfo.setFbReason(fbInfo.getFbExReason());
            fbeInfo.setTrackNumber(fbInfo.getTrackNumber());
            fbeInfo.setMaterial(fbInfo.getMaterial());
            fbeInfo.setDemandQty(fbInfo.getDemandQty());
            fbeInfo.setDeliveriedQty(fbInfo.getDeliveryQty());
            fbeInfo.setDeliveryDate(fbInfo.getDeliveryDate());
            fbeInfo.setUnit(fbInfo.getUnit());
            DirectDeliveryFBEntryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)fbeInfo);
        } else {
            fbInfo.setSupplyStorageOrgUnit(param.getSupplyStroageOrgUnit());
            fbInfo.setStorageOrgUnit(param.getSupplyStroageOrgUnit());
            fbInfo.setMaterial(param.getMaterial());
            fbInfo.setMaterialName(param.getMaterial().getName());
            fbInfo.setUnit(param.getBaseunit());
            fbInfo.setSupplier(param.getSupplier());
            fbInfo.setProject(param.getProject());
            fbInfo.setTrackNumber(param.getTrackNumber());
            fbInfo.setDemandQty(param.getDemandQty());
            fbInfo.setDeliveryDate(param.getDemandDate());
        }
        fbInfo.setSupDeQty(param.getSupplierQty());
        fbInfo.setCmsFBStatus(param.getSupplierFBStatus());
        fbInfo.setSupDeDate(param.getSupplierDate());
        fbInfo.setSupplierFBDate(new java.util.Date());
        fbInfo.setDemandQty(param.getDemandQty());
        fbInfo.setFbPerson(param.getSupplierPerson());
        fbInfo.setFbExReason(param.getSupplierReason());
        if (obj == null) {
            fbInfo.setBaseStatus(SDDPFBStatus.OPEN);
            IObjectPK pk = SonDirectDeliveryFBFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)fbInfo);
            fbInfo.setId(BOSUuid.read((String)pk.toString()));
        } else {
            SonDirectDeliveryFBFactory.getLocalInstance(ctx).save((CoreBaseInfo)fbInfo);
        }
        this._singleSupply(ctx, (IObjectValue)fbInfo);
        return super._singleSupply4Port(ctx, param);
    }
}

