/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.scm.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.industry.emm.scm.material.EMMMaterialPlanFactory;
import com.kingdee.eas.industry.emm.scm.material.EMMMaterialPlanInfo;
import com.kingdee.eas.industry.emm.scm.material.app.AbstractEMMMaterialPlanControllerBean;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class EMMMaterialPlanControllerBean
extends AbstractEMMMaterialPlanControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.scm.material.app.EMMMaterialPlanControllerBean");

    @Override
    protected void _startup(Context ctx, List ids, boolean basestatus) throws BOSException, EASBizException {
        this.checkValidate(ctx, ids, basestatus);
        this.execStartup(ctx, ids, basestatus);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkValidateExist(ctx, model);
        return super._addnew(ctx, model);
    }

    private void checkValidateExist(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EMMMaterialPlanInfo _model = (EMMMaterialPlanInfo)model;
        String storageOrgUnitID = _model.getStorageOrgUnit().getId().toString();
        if (_model.getMaterial() == null) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0000", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0001", (Locale)ctx.getLocale())));
        }
        String materialid = _model.getMaterial().getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialid, CompareType.EQUALS));
        view.setFilter(filterInfo);
        CoreBaseCollection colls = this.getCollection(ctx, view);
        if (colls.size() > 0) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0002", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0010", (Locale)ctx.getLocale())));
        }
    }

    private void checkValidate(Context ctx, List<String> ids, boolean basestatus) throws BOSException, EASBizException {
        if (ids.contains(null) && basestatus) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0002", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0004", (Locale)ctx.getLocale())));
        }
        if (ids.contains(null) && !basestatus) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0002", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0005", (Locale)ctx.getLocale())));
        }
        if (basestatus) {
            try {
                this.checkdoubleDatas(ctx, ids);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> set = new HashSet<String>();
        set.addAll(ids);
        filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        CoreBaseCollection colls = this.getCollection(ctx, view);
        for (int i = 0; i < colls.size(); ++i) {
            EMMMaterialPlanInfo emmmaterial = (EMMMaterialPlanInfo)colls.get(i);
            boolean _basestatus = emmmaterial.isBaseStatus();
            if (!Boolean.toString(basestatus).equals(Boolean.toString(_basestatus))) continue;
            if (basestatus) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0002", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0006", (Locale)ctx.getLocale())));
            }
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0002", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0007", (Locale)ctx.getLocale())));
        }
    }

    private void checkdoubleDatas(Context ctx, List<String> ids) throws BOSException, EASBizException, SQLException {
        StringBuilder sql = new StringBuilder();
        String idString = SQLUtil.arrayToString((Object[])ids.toArray());
        sql.append(" select distinct m.fnumber as fmaterialnumber,s.fname_l2 as forgunitname ");
        sql.append(" from t_mat_emmmaterialplan a");
        sql.append(" left outer join t_bd_material m on m.fid = a.fmaterialid ");
        sql.append(" left outer join t_org_storage s on s.fid = a.fstorageorgunitid ");
        sql.append(" where a.fid in(").append(idString).append(")");
        sql.append(" and exists(select 1 from t_mat_emmmaterialplan b where b.fmaterialid = a.fmaterialid and b.fstorageorgunitid = a.fstorageorgunitid and b.fid <> a.fid and (b.fbasestatus = 1 or b.fid in (").append(idString).append(")))");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String errorString = "\u4ee5\u4e0b\u7269\u6599\u5728\u5e93\u5b58\u7ec4\u7ec7\u4e0b\u5b58\u5728\u91cd\u590d\u7684\u8ba1\u5212\u5c5e\u6027(\u6269\u5c55)\uff0c\u4e0d\u5141\u8bb8\r\n";
        boolean iseror = false;
        while (rs.next()) {
            errorString = errorString + rs.getString("fmaterialnumber") + "(" + rs.getString("forgunitname") + ")\r\n";
            iseror = true;
        }
        if (iseror) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0002", (Locale)ctx.getLocale()), errorString));
        }
    }

    private void execStartup(Context ctx, List<String> ids, boolean basestatus) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> set = new HashSet<String>();
        set.addAll(ids);
        filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        CoreBaseCollection colls = this.getCollection(ctx, view);
        for (int i = 0; i < colls.size(); ++i) {
            EMMMaterialPlanInfo emmmaterial = (EMMMaterialPlanInfo)colls.get(i);
            emmmaterial.setBaseStatus(basestatus);
        }
        try {
            EMMMaterialPlanFactory.getLocalInstance(ctx).save(colls);
        }
        catch (EASBizException e) {
            if (basestatus) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0002", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0008", (Locale)ctx.getLocale())));
            }
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0002", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0009", (Locale)ctx.getLocale())));
        }
    }

    @Override
    protected EMMMaterialPlanInfo _queryInfoByMaterial(Context ctx, String storageOrgUnitId, String materialId) throws BOSException, EASBizException {
        EMMMaterialPlanInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection siColl = new SelectorItemCollection();
        siColl.add(new SelectorItemInfo("*"));
        siColl.add(new SelectorItemInfo("distributionOrgUnit.id"));
        siColl.add(new SelectorItemInfo("distributionOrgUnit.number"));
        siColl.add(new SelectorItemInfo("distributionOrgUnit.name"));
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)1, CompareType.EQUALS));
        view.setFilter(filterInfo);
        view.setSelector(siColl);
        CoreBaseCollection colls = this.getCollection(ctx, view);
        if (colls.size() > 0) {
            info = (EMMMaterialPlanInfo)colls.get(0);
        }
        return info;
    }
}

