/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.scm.sm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.scm.sm.IPricingPolicyBillEntry;
import com.kingdee.eas.industry.emm.scm.sm.PricingPolicyBillEntryCollection;
import com.kingdee.eas.industry.emm.scm.sm.PricingPolicyBillEntryFactory;
import com.kingdee.eas.industry.emm.scm.sm.PricingPolicyBillEntryInfo;
import com.kingdee.eas.industry.emm.scm.sm.PricingPolicyBillInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.zjbom.app.util.BomBotpUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PricingPolicyUtils {
    public static Map getPricingPolicy_date(Context ctx, Set purorgids, Set materialids) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add(new SelectorItemInfo("purPrice"));
        evi.getSelector().add(new SelectorItemInfo("parent.effectiveEndDate"));
        evi.getSelector().add(new SelectorItemInfo("parent.effectiveStartDate"));
        evi.getSelector().add(new SelectorItemInfo("material.number"));
        evi.getSelector().add(new SelectorItemInfo("parent.purOrg.number"));
        evi.getSelector().add(new SelectorItemInfo("parent.priceingway"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("parent.purOrg.id", (Object)purorgids, CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("material.id", (Object)materialids, CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("parent.pricingbilltype", (Object)3));
        Date now = new Date();
        evi.getFilter().getFilterItems().add(new FilterItemInfo("parent.effectiveEndDate", (Object)now, CompareType.GREATER_EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("parent.effectiveStartDate", (Object)now, CompareType.LESS_EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("parent.baseStatus", (Object)4));
        evi.setSorter(new SorterItemCollection());
        SorterItemInfo sorter = new SorterItemInfo("parent.auditTime");
        sorter.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorter);
        IPricingPolicyBillEntry ippe = PricingPolicyBillEntryFactory.getLocalInstance(ctx);
        PricingPolicyBillEntryCollection ppes = ippe.getPricingPolicyBillEntryCollection(evi);
        HashMap<String, PricingPolicyBillEntryInfo> kv = new HashMap<String, PricingPolicyBillEntryInfo>();
        int size = ppes.size();
        for (int i = 0; i < size; ++i) {
            PricingPolicyBillEntryInfo ppe = ppes.get(i);
            PricingPolicyBillInfo pp = ppe.getParent();
            String key = pp.getPurOrg().getId().toString() + ppe.getMaterial().getId().toString();
            kv.put(key, ppe);
        }
        return kv;
    }

    public static boolean existsDatePricingPolicy(PricingPolicyBillInfo pp, PricingPolicyBillEntryInfo entry, Map kv) {
        return PricingPolicyUtils.existsDatePricingPolicy(pp, entry, kv, false);
    }

    public static boolean existsDatePricingPolicy(PricingPolicyBillInfo pp, PricingPolicyBillEntryInfo entry, Map kv, boolean isUpdate) {
        String key = null;
        if (pp.getPurOrg() != null && entry.getMaterial() != null) {
            key = pp.getPurOrg().getId().toString() + entry.getMaterial().getId().toString();
        }
        if (key == null || !kv.containsKey(key)) {
            return false;
        }
        if (isUpdate) {
            PricingPolicyBillEntryInfo date_ppe = (PricingPolicyBillEntryInfo)kv.get(key);
            PricingPolicyBillInfo date_pp = date_ppe.getParent();
            entry.setPurPrice(date_ppe.getPurPrice());
            pp.put("effectiveEndDate", date_pp.get("effectiveEndDate"));
            pp.put("effectiveStartDate", date_pp.get("effectiveStartDate"));
            pp.setPriceingway(date_pp.getPriceingway());
        }
        return true;
    }

    public static boolean existsDatePricingPolicy(PurOrderInfo info, PurOrderEntryInfo entry, Map kv) {
        String key = null;
        if (info.getPurchaseOrgUnit() != null && entry.getMaterial() != null) {
            key = info.getPurchaseOrgUnit().getId().toString() + entry.getMaterial().getId().toString();
        }
        return key != null && kv.containsKey(key);
    }

    public static SelectorItemCollection getUpateSelector_existsDatePricingPolicy() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entries.purPrice"));
        sic.add(new SelectorItemInfo("effectiveEndDate"));
        sic.add(new SelectorItemInfo("effectiveStartDate"));
        sic.add(new SelectorItemInfo("priceingway"));
        return sic;
    }

    public static IObjectCollection toPricingPolicy_botp(Context ctx, CoreBillBaseCollection collection, String botp) throws EASBizException, BOSException {
        BOTMappingInfo botInfo = BomBotpUtil.getBOTP((Context)ctx, (String)botp);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            CoreBillBaseInfo info = collection.get(i);
            BomBotpUtil.isNoReBuild((Context)ctx, (BOTMappingInfo)botInfo, (BOSUuid)info.getId());
        }
        BTPTransformResult result = BomBotpUtil.transform((Context)ctx, (CoreBillBaseCollection)collection, (BOTMappingInfo)botInfo);
        IObjectCollection bills = result.getBills();
        IBTPManager ibt = BTPManagerFactory.getLocalInstance((Context)ctx);
        int size2 = bills.size();
        for (int i = 0; i < size2; ++i) {
            ibt.saveRelations((CoreBillBaseInfo)bills.getObject(i), result.getBOTRelationCollection());
        }
        return bills;
    }
}

