/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.scm.sm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.common.EmmUtils;
import com.kingdee.eas.industry.emm.pcm.IPcmFacade;
import com.kingdee.eas.industry.emm.pcm.PcmFacadeFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassCodeMaterialRelationCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassCodeMaterialRelationFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ControlStrategyCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.ControlStrategyFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ControlStrategyInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.IClassCodeMaterialRelation;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesInfo;
import com.kingdee.eas.industry.emm.pm.SqlExecuteFacadeFactory;
import com.kingdee.eas.industry.emm.scm.sm.IPricingPolicyBillEntry;
import com.kingdee.eas.industry.emm.scm.sm.PricingPolicyBillCollection;
import com.kingdee.eas.industry.emm.scm.sm.PricingPolicyBillEntryCollection;
import com.kingdee.eas.industry.emm.scm.sm.PricingPolicyBillEntryFactory;
import com.kingdee.eas.industry.emm.scm.sm.PricingPolicyBillEntryInfo;
import com.kingdee.eas.industry.emm.scm.sm.PricingPolicyBillInfo;
import com.kingdee.eas.industry.emm.scm.sm.PricingPolicyTypeEnum;
import com.kingdee.eas.industry.emm.scm.sm.PricingPolicyUtils;
import com.kingdee.eas.industry.emm.scm.sm.app.AbstractPricingPolicyBillControllerBean;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.sm.pur.HostTypeEnum;
import com.kingdee.eas.scm.sm.pur.PurReTypeFactory;
import com.kingdee.eas.scm.sm.pur.PurReTypeInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.app.util.BomBotpUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PricingPolicyBillControllerBean
extends AbstractPricingPolicyBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.scm.sm.app.PricingPolicyBillControllerBean");

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entries.planQty"));
        sic.add(new SelectorItemInfo("entries.xcxxQty"));
        sic.add(new SelectorItemInfo("entries.xkcQty"));
        sic.add(new SelectorItemInfo("entries.purPrice"));
        sic.add(new SelectorItemInfo("entries.xkcPrice"));
        sic.add(new SelectorItemInfo("entries.otherPrice"));
        sic.add(new SelectorItemInfo("entries.saleTotalPrice"));
        sic.add(new SelectorItemInfo("entries.materialname"));
        sic.add(new SelectorItemInfo("entries.materialmodel"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.material.*"));
        sic.add(new SelectorItemInfo("entries.unit.*"));
        sic.add(new SelectorItemInfo("entries.startTrack.*"));
        sic.add(new SelectorItemInfo("entries.endTrack.*"));
        sic.add(new SelectorItemInfo("entries.project.*"));
        sic.add(new SelectorItemInfo("entries.suppliera.*"));
        sic.add(new SelectorItemInfo("entries.supplierb.*"));
        sic.add(new SelectorItemInfo("entries.supplierc.*"));
        sic.add(new SelectorItemInfo("entries.remark"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser.*"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("firstperson"));
        sic.add(new SelectorItemInfo("firsttime"));
        sic.add(new SelectorItemInfo("secperson"));
        sic.add(new SelectorItemInfo("sectime"));
        sic.add(new SelectorItemInfo("thperson"));
        sic.add(new SelectorItemInfo("thtime"));
        sic.add(new SelectorItemInfo("fourperson"));
        sic.add(new SelectorItemInfo("fourtime"));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("auditTime"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("purGroup.*"));
        sic.add(new SelectorItemInfo("pricingbilltype"));
        sic.add(new SelectorItemInfo("purPerson.*"));
        sic.add(new SelectorItemInfo("customer.*"));
        sic.add(new SelectorItemInfo("purOrg.*"));
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    protected IObjectPK _save(Context arg0, IObjectValue arg1) throws BOSException, EASBizException {
        IObjectPK objectPK = super._save(arg0, arg1);
        return objectPK;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK objectPK = super._addnew(ctx, model);
        PricingPolicyBillInfo info = (PricingPolicyBillInfo)model;
        PricingPolicyBillEntryCollection collection = info.getEntries();
        String sourceIds = "";
        for (int i = 0; i < collection.size(); ++i) {
            PricingPolicyBillEntryInfo billEntryInfo = collection.get(i);
            sourceIds = sourceIds + "'" + billEntryInfo.getSourceBillEntryId() + "',";
        }
        if (sourceIds.endsWith(",")) {
            sourceIds = sourceIds.substring(0, sourceIds.length() - 1);
        }
        if (sourceIds != null && !"".equals(sourceIds.trim())) {
            String isMerge;
            String sql = "";
            if (info.getPricingbilltype().equals((Object)PricingPolicyTypeEnum.NORPRICEPOLICY) || info.getPricingbilltype() == PricingPolicyTypeEnum.price_platform) {
                sql = "/*dialect*/update T_SM_PurOrderEntry aa set aa.fpricingpolicyentryids =\n(\nselect max(bb.fid) from T_SM_PricingPolicyBillEntry bb where aa.fid = bb.fsourcebillentryid\n)\nwhere aa.fid in (" + sourceIds + ")";
            } else if (info.getPricingbilltype().equals((Object)PricingPolicyTypeEnum.NONORPRICEPOLICY)) {
                sql = "/*dialect*/update T_SM_SalesSplitEntry aa set aa.fpricingpolicyentryids =\n(\nselect max(bb.fid) from T_SM_PricingPolicyBillEntry bb where aa.fid = bb.fsourcebillentryid\n)\nwhere aa.fid in (" + sourceIds + ")";
            }
            String string = isMerge = info.getIsMerge() == null ? "" : info.getIsMerge();
            if (!sql.equals("") && !isMerge.equals("\u5408\u5e76")) {
                SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
            }
        }
        return objectPK;
    }

    public boolean checkPermission(Context ctx, PricingPolicyBillInfo info) throws EASBizException, BOSException {
        UserInfo currentUser = (UserInfo)ctx.get((Object)"UserInfo");
        Object purTypenumber = null;
        String sql = null;
        if (info.getPurOrg() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0036", (Locale)ctx.getLocale())));
        }
        String purorgnumber = "";
        if (info.getPurOrg().getNumber() != null) {
            purorgnumber = info.getPurOrg().getNumber();
        } else {
            PurchaseOrgUnitInfo purorginfo = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx).getPurchaseOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getPurOrg().getId().toString()));
            purorgnumber = purorginfo.getNumber();
        }
        PricingPolicyTypeEnum type = info.getPricingbilltype();
        if (type == null) {
            type = PricingPolicyTypeEnum.NONORPRICEPOLICY;
        }
        sql = "select cflevel,fid from  t_zj_WorkflowPersonData where FTreeID= (select fid from t_zj_workflowpersondattree where fnumber='DJD001') and  Fdescription_L2='" + purorgnumber + "'  and fname_l2='" + type.getAlias() + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                int cflevel = rs.getInt("cflevel");
                PersonInfo personInfo = null;
                if (cflevel >= 0) {
                    if (currentUser.getPerson() == null) {
                        throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0037", (Locale)ctx.getLocale())));
                    }
                    personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(currentUser.getPerson().getId().toString()));
                }
                if (cflevel == 0) {
                    if (info.get("firstperson") == null) {
                        String entrySql = "select fid,flevels,fpersonid from t_zj_WorkflowPersonDataentry where fparentid = '" + rs.getString("fid") + "'  and flevels = 0  and fpersonid = '" + currentUser.getPerson().getId().toString() + "'";
                        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)entrySql);
                        if (!rs2.next()) {
                            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0038", (Locale)ctx.getLocale())));
                        }
                        DbUtil.execute((Context)ctx, (String)("update T_SM_PricingPolicyBill set CFFirstperson='" + personInfo.getName() + "',CFFirsttime=sysdate where fid='" + info.getId().toString() + "'"));
                        return true;
                    }
                } else if (cflevel == 1) {
                    if (info.get("firstperson") == null) {
                        String entrySql = "select fid,flevels,fpersonid from t_zj_WorkflowPersonDataentry where fparentid = '" + rs.getString("fid") + "'  and flevels = 0  and fpersonid = '" + currentUser.getPerson().getId().toString() + "'";
                        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)entrySql);
                        if (!rs2.next()) {
                            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0038", (Locale)ctx.getLocale())));
                        }
                        DbUtil.execute((Context)ctx, (String)("update T_SM_PricingPolicyBill set CFFirstperson='" + personInfo.getName() + "',CFFirsttime=sysdate where fid='" + info.getId().toString() + "'"));
                        return false;
                    }
                    if (info.get("secperson") == null) {
                        String entrySql = "select fid,flevels,fpersonid from t_zj_WorkflowPersonDataentry where fparentid = '" + rs.getString("fid") + "'  and flevels = 1  and fpersonid = '" + currentUser.getPerson().getId().toString() + "'";
                        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)entrySql);
                        if (!rs2.next()) {
                            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0039", (Locale)ctx.getLocale())));
                        }
                        DbUtil.execute((Context)ctx, (String)("update T_SM_PricingPolicyBill set CFSecperson='" + personInfo.getName() + "',CFSectime=sysdate where fid='" + info.getId().toString() + "'"));
                        return true;
                    }
                } else if (cflevel == 2) {
                    if (info.get("firstperson") == null) {
                        String entrySql = "select fid,flevels,fpersonid from t_zj_WorkflowPersonDataentry where fparentid = '" + rs.getString("fid") + "'  and flevels = 0  and fpersonid = '" + currentUser.getPerson().getId().toString() + "'";
                        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)entrySql);
                        if (!rs2.next()) {
                            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0038", (Locale)ctx.getLocale())));
                        }
                        DbUtil.execute((Context)ctx, (String)("update T_SM_PricingPolicyBill set CFFirstperson='" + personInfo.getName() + "',CFFirsttime=sysdate where fid='" + info.getId().toString() + "'"));
                        return false;
                    }
                    if (info.get("secperson") == null) {
                        String entrySql = "select fid,flevels,fpersonid from t_zj_WorkflowPersonDataentry where fparentid = '" + rs.getString("fid") + "'  and flevels = 1  and fpersonid = '" + currentUser.getPerson().getId().toString() + "'";
                        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)entrySql);
                        if (!rs2.next()) {
                            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0039", (Locale)ctx.getLocale())));
                        }
                        DbUtil.execute((Context)ctx, (String)("update T_SM_PricingPolicyBill set CFSecperson='" + personInfo.getName() + "',CFSectime=sysdate where fid='" + info.getId().toString() + "'"));
                        return false;
                    }
                    if (info.get("thperson") == null) {
                        String entrySql = "select fid,flevels,fpersonid from t_zj_WorkflowPersonDataentry where fparentid = '" + rs.getString("fid") + "'  and flevels = 2  and fpersonid = '" + currentUser.getPerson().getId().toString() + "'";
                        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)entrySql);
                        if (!rs2.next()) {
                            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0040", (Locale)ctx.getLocale())));
                        }
                        DbUtil.execute((Context)ctx, (String)("update T_SM_PricingPolicyBill set CFThperson='" + personInfo.getName() + "',CFThtime=sysdate where fid='" + info.getId().toString() + "'"));
                        return true;
                    }
                } else if (cflevel == 3) {
                    if (info.get("firstperson") == null) {
                        String entrySql = "select fid,flevels,fpersonid from t_zj_WorkflowPersonDataentry where fparentid = '" + rs.getString("fid") + "'  and flevels = 0  and fpersonid = '" + currentUser.getPerson().getId().toString() + "'";
                        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)entrySql);
                        if (!rs2.next()) {
                            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0038", (Locale)ctx.getLocale())));
                        }
                        DbUtil.execute((Context)ctx, (String)("update T_SM_PricingPolicyBill set CFFirstperson='" + personInfo.getName() + "',CFFirsttime=sysdate where fid='" + info.getId().toString() + "'"));
                        return false;
                    }
                    if (info.get("secperson") == null) {
                        String entrySql = "select fid,flevels,fpersonid from t_zj_WorkflowPersonDataentry where fparentid = '" + rs.getString("fid") + "'  and flevels = 1  and fpersonid = '" + currentUser.getPerson().getId().toString() + "'";
                        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)entrySql);
                        if (!rs2.next()) {
                            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0039", (Locale)ctx.getLocale())));
                        }
                        DbUtil.execute((Context)ctx, (String)("update T_SM_PricingPolicyBill set CFSecperson='" + personInfo.getName() + "',CFSectime=sysdate where fid='" + info.getId().toString() + "'"));
                        return false;
                    }
                    if (info.get("thperson") == null) {
                        String entrySql = "select fid,flevels,fpersonid from t_zj_WorkflowPersonDataentry where fparentid = '" + rs.getString("fid") + "'  and flevels = 2  and fpersonid = '" + currentUser.getPerson().getId().toString() + "'";
                        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)entrySql);
                        if (!rs2.next()) {
                            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0040", (Locale)ctx.getLocale())));
                        }
                        DbUtil.execute((Context)ctx, (String)("update T_SM_PricingPolicyBill set CFThperson='" + personInfo.getName() + "',CFThtime=sysdate where fid='" + info.getId().toString() + "'"));
                        return false;
                    }
                    if (info.get("fourperson") == null) {
                        String entrySql = "select fid,flevels,fpersonid from t_zj_WorkflowPersonDataentry where fparentid = '" + rs.getString("fid") + "'  and flevels = 3  and fpersonid = '" + currentUser.getPerson().getId().toString() + "'";
                        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)entrySql);
                        if (!rs2.next()) {
                            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0041", (Locale)ctx.getLocale())));
                        }
                        DbUtil.execute((Context)ctx, (String)("update T_SM_PricingPolicyBill set CFFourperson='" + personInfo.getName() + "',CFFourtime=sysdate where fid='" + info.getId().toString() + "'"));
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
        }
        return true;
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        IPcmFacade iPcmFacade = PcmFacadeFactory.getLocalInstance((Context)ctx);
        PricingPolicyBillInfo info = null;
        info = this.getPricingPolicyBillInfo(ctx, pk, this.getSelectors());
        if (!this.checkPermission(ctx, info)) {
            return;
        }
        super._passAudit(ctx, pk, (IObjectValue)info);
        PricingPolicyTypeEnum type = info.getPricingbilltype();
        if (type == PricingPolicyTypeEnum.NONORPRICEPOLICY) {
            try {
                this.unnormalPriceAuditLogic(ctx, info);
            }
            catch (Exception e) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0042", (Locale)ctx.getLocale()) + e.getMessage()), (Throwable)e);
            }
        } else {
            this.normalPriceAuditLogic(ctx, info);
        }
        this.updateAuditStatus(ctx, (IObjectValue)info);
        if (type == PricingPolicyTypeEnum.NORPRICEPOLICY && info.isSyncPlatform()) {
            CoreBillBaseCollection coll = new CoreBillBaseCollection();
            coll.add((CoreBillBaseInfo)info);
            SelectorItemCollection usic_effectiveDate = new SelectorItemCollection();
            usic_effectiveDate.add(new SelectorItemInfo("baseStatus"));
            IObjectCollection bills = PricingPolicyUtils.toPricingPolicy_botp(ctx, coll, "DJ-KU-A");
            int size = bills.size();
            for (int i = 0; i < size; ++i) {
                PricingPolicyBillInfo pp = (PricingPolicyBillInfo)bills.getObject(i);
                pp.setBaseStatus(BillBaseStatusEnum.AUDITED);
                this.updatePartial(ctx, pp, usic_effectiveDate);
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(info.getId().toString());
        MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(list);
        try {
            this.updatePrice(ctx, info);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected void unnormalPriceAuditLogic(Context ctx, PricingPolicyBillInfo info) throws Exception {
        SQLUtil sql = new SQLUtil();
        sql.appendSql(" select b.fsaletotalprice,b.fxcxxtotalprice,a.fid,a.fdiscounttype,a.fdiscount,a.fqty,a.ftaxrate,a.cfisnormal ");
        sql.appendSql(" from  T_SD_SaleOrderEntry a  ");
        sql.appendSql(" inner join T_SM_SalesSplitEntry se on a.fsourcebillentryid=se.fid");
        sql.appendSql(" inner join T_SM_PricingPolicyBillEntry b on se.fpricingpolicyentryids = b.fid");
        sql.appendSql(" where b.fparentid='").appendSql(info.getId().toString()).appendSql("'");
        ResultSet set = sql.exeQuery(ctx);
        if (!set.next()) {
            sql = new SQLUtil();
            sql.appendSql(" select b.fsaletotalprice,b.fxcxxtotalprice,a.fid,a.fdiscounttype,a.fdiscount,a.fqty,a.ftaxrate,a.cfisnormal ");
            sql.appendSql(" from  T_SD_SaleOrderEntry a  inner join T_SM_PricingPolicyBillEntry b ");
            sql.appendSql(" on a.fsourcebillentryid=b.fsourcebillentryid");
            sql.appendSql(" where b.fparentid='").appendSql(info.getId().toString()).appendSql("'");
            set = sql.exeQuery(ctx);
        } else {
            set.beforeFirst();
        }
        BigDecimal fprice = BigDecimal.ZERO;
        BigDecimal factualprice = BigDecimal.ZERO;
        BigDecimal factualtaxprice = BigDecimal.ZERO;
        BigDecimal famount = BigDecimal.ZERO;
        BigDecimal ftaxamount = BigDecimal.ZERO;
        BigDecimal ftax = BigDecimal.ZERO;
        BigDecimal fdiscountamount = BigDecimal.ZERO;
        BigDecimal fsaletotalprice = BigDecimal.ZERO;
        BigDecimal hundred = BigDecimal.valueOf(100L);
        DecimalFormat format = new DecimalFormat("###0.00000000");
        while (set.next()) {
            int fdiscounttype = set.getInt("fdiscounttype");
            BigDecimal fdiscount = set.getBigDecimal("fdiscount");
            String cfisnormal = set.getString("cfisnormal");
            cfisnormal = cfisnormal != null ? cfisnormal.trim() : "";
            fsaletotalprice = "\u9500\u5e93\u5b58".equals(cfisnormal) ? set.getBigDecimal("fsaletotalprice") : set.getBigDecimal("fxcxxtotalprice");
            BigDecimal fqty = set.getBigDecimal("fqty");
            BigDecimal ftaxrate = set.getBigDecimal("ftaxrate");
            String fid = set.getString("fid");
            StringBuffer subsql = new StringBuffer();
            switch (fdiscounttype) {
                case -1: {
                    factualprice = fprice = fsaletotalprice.divide(BigDecimal.ONE.add(ftaxrate.divide(hundred)), 6, 2);
                    factualtaxprice = fsaletotalprice;
                    famount = factualprice.multiply(fqty);
                    ftaxamount = factualtaxprice.multiply(fqty);
                    ftax = ftaxamount.subtract(famount);
                    break;
                }
                case 0: {
                    fdiscountamount = fsaletotalprice.multiply(fdiscount).multiply(fqty);
                    factualprice = fprice = fsaletotalprice.divide(BigDecimal.ONE.add(ftaxrate.divide(hundred)), 6, 2).multiply(BigDecimal.ONE.subtract(fdiscount));
                    factualtaxprice = fsaletotalprice.multiply(BigDecimal.ONE.subtract(fdiscount));
                    famount = factualprice.multiply(fqty);
                    ftaxamount = factualtaxprice.multiply(fqty);
                    ftax = ftaxamount.subtract(famount);
                    subsql.append(",fdiscountamount=").append(fdiscountamount.toString());
                    break;
                }
                case 1: {
                    fdiscountamount = fdiscount.multiply(fqty);
                    factualprice = fprice = fsaletotalprice.subtract(fdiscount).divide(BigDecimal.ONE.add(ftaxrate.divide(hundred)), 6, 2);
                    factualtaxprice = fsaletotalprice.subtract(fdiscount);
                    famount = factualprice.multiply(fqty);
                    ftaxamount = factualtaxprice.multiply(fqty);
                    ftax = ftaxamount.subtract(famount);
                    subsql.append(",fdiscountamount=").append(fdiscountamount.toString());
                }
            }
            SQLUtil usql = new SQLUtil();
            usql.appendSql(" update T_SD_SaleOrderEntry set ");
            usql.appendSql(" fprice=").appendSql(format.format(fprice));
            usql.appendSql(" ,factualprice=").appendSql(format.format(factualprice));
            usql.appendSql(" ,famount=").appendSql(format.format(famount));
            usql.appendSql(" ,ftaxamount=").appendSql(format.format(ftaxamount));
            usql.appendSql(" ,ftax=").appendSql(format.format(ftax));
            usql.appendSql(" ,ftaxprice =").appendSql(format.format(fsaletotalprice));
            usql.appendSql(" ,factualtaxprice=").appendSql(format.format(factualtaxprice));
            usql.appendSql(subsql.toString());
            usql.appendSql(" where fid='").appendSql(fid).appendSql("'");
            usql.execute(ctx);
        }
    }

    protected void normalPriceAuditLogic(Context ctx, PricingPolicyBillInfo info) throws BOSException, EASBizException {
    }

    public String trackNum(String trackNum) {
        return trackNum.substring(trackNum.length() - 4, trackNum.length());
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IBTPManager iBTPManager;
        super._unAudit(ctx, pk);
        PricingPolicyBillInfo info = this.getPricingPolicyBillInfo(ctx, pk);
        IPcmFacade iPcmFacade = PcmFacadeFactory.getLocalInstance((Context)ctx);
        PurReTypeInfo purReType = (PurReTypeInfo)info.get("purType");
        if (purReType != null) {
            purReType = PurReTypeFactory.getLocalInstance(ctx).getPurReTypeInfo((IObjectPK)new ObjectUuidPK(purReType.getId()));
        }
        if ((iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx)).ifHaveDestBills(pk.toString())) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0043", (Locale)ctx.getLocale()) + "\uff1a" + info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0044", (Locale)ctx.getLocale())));
        }
        if (info != null && info.getEntries() != null && info.getEntries().get(0) != null && info.getEntries().get(0).getBoolean("iscp")) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0043", (Locale)ctx.getLocale()) + "\uff1a" + info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0045", (Locale)ctx.getLocale())));
        }
        this.updateUnAuditStatus(ctx, (IObjectValue)info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        model.put("fourtime", null);
        model.put("fourperson", null);
        model.put("thtime", null);
        model.put("thperson", null);
        model.put("sectime", null);
        model.put("secperson", null);
        model.put("firsttime", null);
        model.put("firstperson", null);
        PricingPolicyBillInfo billInfo = (PricingPolicyBillInfo)model;
        if (billInfo.getPurType() != null) {
            ControlStrategyCollection controlCollection = ControlStrategyFactory.getLocalInstance((Context)ctx).getControlStrategyCollection("Where purClass = '" + billInfo.getPurType().getId() + "' and controlMode = 2");
            if (controlCollection.get(0) != null) {
                IClassCodeMaterialRelation iccmr = ClassCodeMaterialRelationFactory.getLocalInstance((Context)ctx);
                for (int i = 0; i < billInfo.getEntries().size(); ++i) {
                    PricingPolicyBillEntryInfo entry = billInfo.getEntries().get(i);
                    ControlStrategyInfo csInfo = controlCollection.get(0);
                    csInfo = ControlStrategyFactory.getLocalInstance((Context)ctx).getControlStrategyInfo((IObjectPK)new ObjectUuidPK(csInfo.getId()));
                    ProjectInfo projectInfo = ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(entry.getProject().getId()));
                    if (projectInfo.getProjectTypes() == null) continue;
                    ProjectTypesInfo csProjectTypeInfo = ProjectTypesFactory.getLocalInstance((Context)ctx).getProjectTypesInfo((IObjectPK)new ObjectUuidPK(csInfo.getProjectType().getId()));
                    ProjectTypesInfo projectTypeInfo = ProjectTypesFactory.getLocalInstance((Context)ctx).getProjectTypesInfo((IObjectPK)new ObjectUuidPK(projectInfo.getProjectTypes().getId()));
                    if (!csProjectTypeInfo.getNumber().equals(projectTypeInfo.getNumber()) || entry.getProject() == null || entry.getMaterial() == null) continue;
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select cfprojecttypesid from t_mm_project where fid='" + entry.getProject().getId().toString() + "' and cfprojecttypesid is not null"));
                    String projectTypeId = null;
                    try {
                        if (rs.next()) {
                            projectTypeId = rs.getString("cfprojecttypesid");
                        }
                        if (projectTypeId == null) continue;
                        ClassCodeMaterialRelationCollection ccmrColl = iccmr.getClassCodeMaterialRelationCollection("where projectType.id='" + projectTypeId + "' and material.id='" + entry.getMaterial().getId().toString() + "' and classCode.id is not null");
                        if (ccmrColl != null && ccmrColl.size() > 0) {
                            entry.setClassCode(ccmrColl.get(0).getClassCode());
                            continue;
                        }
                        throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0046", (Locale)ctx.getLocale())));
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        throw new BOSException((Throwable)e);
                    }
                }
            }
        } else {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0047", (Locale)ctx.getLocale())));
        }
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }

    public Map getMapByRelation(BOTRelationCollection relations) {
        HashMap<String, BOTRelationCollection> map = new HashMap<String, BOTRelationCollection>();
        for (int i = 0; i < relations.size(); ++i) {
            BOTRelationCollection botrelationcollection;
            BOTRelationInfo relationInfo = relations.get(i);
            String oid = relationInfo.getDestObjectID();
            if (map.get(oid) != null) {
                botrelationcollection = (BOTRelationCollection)map.get(oid);
                botrelationcollection.add(relationInfo);
                map.put(oid, botrelationcollection);
                continue;
            }
            botrelationcollection = new BOTRelationCollection();
            botrelationcollection.add(relationInfo);
            map.put(oid, botrelationcollection);
        }
        return map;
    }

    @Override
    protected IRowSet _getappriceLastYear(Context ctx, String mid) throws BOSException, EASBizException {
        MaterialInfo info;
        BigDecimal apprice = new BigDecimal(0);
        if (mid == null || "".equals(mid)) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        String StrSQL = "select top 1  e.FPurPrice AS FAPPRICE,e.FSupplieraID As FVendId,a.fnumber from T_SM_PricingPolicyBillEntry e inner join T_SM_PricingPolicyBill a on a.fid = e.fparentid  where year(a.faudittime) = " + (c.get(1) - 1) + " and a.fbasestatus = " + 4 + " and e.FMaterialID = '" + mid + "' and a.FPricingbilltype = " + 1 + " order by e.FPurPrice,a.faudittime desc ";
        IRowSet rs = null;
        rs = DbUtil.executeQuery((Context)ctx, (String)StrSQL);
        if (rs.size() == 0 && (info = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)mid)))).getNumber().length() > 13) {
            StrSQL = "select top 1  e.FPurPrice AS FAPPRICE,e.FSupplieraID As FVendId,a.fnumber from T_SM_PricingPolicyBillEntry e inner join T_SM_PricingPolicyBill a on a.fid = e.fparentid  inner join t_bd_material ma on ma.fid=e.fmaterialid  where a.fbasestatus = 4 and year(a.faudittime) = " + (c.get(1) - 1) + " and e.fparentid <> '" + 0 + "' and ma.fnumber like '%" + info.getNumber().substring(0, 13) + "%' and a.FPricingbilltype = " + 1 + " order by e.FPurPrice,a.faudittime desc ";
            rs = DbUtil.executeQuery((Context)ctx, (String)StrSQL);
        }
        return rs;
    }

    @Override
    protected String _back(Context ctx, Set entryids) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add(new SelectorItemInfo("backTime"));
        evi.getSelector().add(new SelectorItemInfo("backUser"));
        evi.getSelector().add(new SelectorItemInfo("parent.id"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)entryids, CompareType.INCLUDE));
        IPricingPolicyBillEntry ippbe = PricingPolicyBillEntryFactory.getLocalInstance(ctx);
        PricingPolicyBillEntryCollection colls = ippbe.getPricingPolicyBillEntryCollection(evi);
        HashSet<String> ids = new HashSet<String>();
        CoreBaseCollection cbs = new CoreBaseCollection();
        Date now = new Date();
        UserInfo ui = ContextUtil.getCurrentUserInfo((Context)ctx);
        String backUser = null;
        if (ui != null) {
            backUser = ui.getName();
        }
        for (int i = 0; i < colls.size(); ++i) {
            PricingPolicyBillEntryInfo ei = colls.get(i);
            ei.setBackTime(now);
            ei.setBackUser(backUser);
            ids.add(ei.getParent().getId().toString());
            cbs.add((CoreBaseInfo)ei);
        }
        if (cbs.size() > 0) {
            ippbe.update(cbs);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("basestatus", (Object)2, CompareType.NOTEQUALS));
        if (this.exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0048", (Locale)ctx.getLocale())));
        }
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            this._unAudit(ctx, (IObjectPK)new ObjectUuidPK(it.next().toString()));
        }
        return EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0049", (Locale)ctx.getLocale());
    }

    @Override
    protected String _toDatePrice(Context ctx, List entryids, Date effectiveStartDate, Date effectiveEndDate) throws BOSException, EASBizException {
        PricingPolicyBillInfo pp;
        PricingPolicyBillEntryInfo entry;
        StringBuilder errors = new StringBuilder();
        IPricingPolicyBillEntry ippe = PricingPolicyBillEntryFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("material.number"));
        evi.getSelector().add(new SelectorItemInfo("parent.purOrg.id"));
        evi.getSelector().add(new SelectorItemInfo("parent.*"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(entryids), CompareType.INCLUDE));
        PricingPolicyBillEntryCollection ppes = ippe.getPricingPolicyBillEntryCollection(evi);
        HashSet<String> parentids = new HashSet<String>();
        HashSet<String> purorgids = new HashSet<String>();
        HashSet<String> materialids = new HashSet<String>();
        boolean isTra = true;
        int size = ppes.size();
        for (int i = 0; i < size; ++i) {
            entry = ppes.get(i);
            pp = entry.getParent();
            isTra = true;
            if (pp.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
                errors.append(pp.getNumber()).append(EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0050", (Locale)ctx.getLocale()) + "\uff1a");
                if (pp.getBaseStatus() != null) {
                    errors.append(pp.getBaseStatus().getAlias());
                }
                errors.append("\n");
                isTra = false;
            }
            if (pp.getPricingbilltype() != PricingPolicyTypeEnum.NORPRICEPOLICY) {
                errors.append(pp.getNumber()).append(EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0051", (Locale)ctx.getLocale()) + "\uff1a");
                if (pp.getPricingbilltype() != null) {
                    errors.append(pp.getPricingbilltype().getAlias());
                }
                errors.append("\n");
                isTra = false;
            }
            if (pp.getPurOrg() != null) {
                purorgids.add(pp.getPurOrg().getId().toString());
            }
            if (entry.getMaterial() != null) {
                materialids.add(entry.getMaterial().getId().toString());
            }
            if (!isTra) continue;
            parentids.add(pp.getId().toString());
        }
        if (errors.length() > 0) {
            errors.insert(0, EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0052", (Locale)ctx.getLocale()) + "\n");
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0053", (Locale)ctx.getLocale()) + "\n" + errors.toString()));
        }
        if (parentids.size() == 0 || errors.length() > 0) {
            return EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0054", (Locale)ctx.getLocale()) + "\n" + errors.toString();
        }
        EntityViewInfo evi_parent = new EntityViewInfo();
        evi_parent.setSelector(new SelectorItemCollection());
        evi_parent.getSelector().add(new SelectorItemInfo("*"));
        evi_parent.getSelector().add(new SelectorItemInfo("entries.id"));
        evi_parent.setFilter(new FilterInfo());
        evi_parent.getFilter().getFilterItems().add(new FilterItemInfo("id", parentids, CompareType.INCLUDE));
        PricingPolicyBillCollection pps = this.getPricingPolicyBillCollection(ctx, evi_parent);
        CoreBillBaseCollection traColl = new CoreBillBaseCollection();
        int size2 = pps.size();
        for (int i = 0; i < size2; ++i) {
            pp = pps.get(i);
            Iterator it = pp.getEntries().iterator();
            while (it.hasNext()) {
                entry = (PricingPolicyBillEntryInfo)it.next();
                String eid = entry.getId().toString();
                if (entryids.contains(eid)) continue;
                it.remove();
            }
            if (pp.getEntries().size() <= 0) continue;
            traColl.add((CoreBillBaseInfo)pp);
        }
        if (traColl.size() <= 0) {
            return EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0054", (Locale)ctx.getLocale());
        }
        SelectorItemCollection usic_effectiveDate = new SelectorItemCollection();
        usic_effectiveDate.add(new SelectorItemInfo("effectiveStartDate"));
        usic_effectiveDate.add(new SelectorItemInfo("effectiveEndDate"));
        usic_effectiveDate.add(new SelectorItemInfo("baseStatus"));
        IObjectCollection bills = PricingPolicyUtils.toPricingPolicy_botp(ctx, traColl, "DJ-KU-T");
        int size3 = bills.size();
        for (int i = 0; i < size3; ++i) {
            pp = (PricingPolicyBillInfo)bills.getObject(i);
            pp.put("effectiveEndDate", effectiveEndDate);
            pp.put("effectiveStartDate", effectiveStartDate);
            pp.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            this.updatePartial(ctx, pp, usic_effectiveDate);
        }
        return EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0055", (Locale)ctx.getLocale());
    }

    @Override
    protected String _toPlatformPrice(Context ctx, List entryids) throws BOSException, EASBizException {
        PricingPolicyBillInfo pp;
        PricingPolicyBillEntryInfo entry;
        StringBuilder errors = new StringBuilder();
        IPricingPolicyBillEntry ippe = PricingPolicyBillEntryFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("material.number"));
        evi.getSelector().add(new SelectorItemInfo("parent.purOrg.id"));
        evi.getSelector().add(new SelectorItemInfo("parent.*"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(entryids), CompareType.INCLUDE));
        PricingPolicyBillEntryCollection ppes = ippe.getPricingPolicyBillEntryCollection(evi);
        HashSet<String> parentids = new HashSet<String>();
        HashSet<String> purorgids = new HashSet<String>();
        HashSet<String> materialids = new HashSet<String>();
        boolean isTra = true;
        int size = ppes.size();
        for (int i = 0; i < size; ++i) {
            entry = ppes.get(i);
            pp = entry.getParent();
            isTra = true;
            if (pp.getBaseStatus() != BillBaseStatusEnum.TEMPORARILYSAVED) {
                errors.append(pp.getNumber()).append(EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0050", (Locale)ctx.getLocale()) + "\uff1a");
                if (pp.getBaseStatus() != null) {
                    errors.append(pp.getBaseStatus().getAlias());
                }
                errors.append("\n");
                isTra = false;
            }
            if (pp.getPricingbilltype() != PricingPolicyTypeEnum.NORPRICEPOLICY) {
                errors.append(pp.getNumber()).append(EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0051", (Locale)ctx.getLocale()) + "\uff1a");
                if (pp.getPricingbilltype() != null) {
                    errors.append(pp.getPricingbilltype().getAlias());
                }
                errors.append("\n");
                isTra = false;
            }
            if (pp.getPurOrg() != null) {
                purorgids.add(pp.getPurOrg().getId().toString());
            }
            if (entry.getMaterial() != null) {
                materialids.add(entry.getMaterial().getId().toString());
            }
            if (!isTra) continue;
            parentids.add(pp.getId().toString());
        }
        if (errors.length() > 0) {
            errors.insert(0, EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0052", (Locale)ctx.getLocale()) + "\n");
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0056", (Locale)ctx.getLocale()) + "\n" + errors.toString()));
        }
        Map kv = PricingPolicyUtils.getPricingPolicy_date(ctx, purorgids, materialids);
        int size2 = ppes.size();
        for (int i = 0; i < size2; ++i) {
            entry = ppes.get(i);
            pp = entry.getParent();
            if (PricingPolicyUtils.existsDatePricingPolicy(pp, entry, kv)) continue;
            errors.append(pp.getNumber()).append("\t");
            if (entry.getMaterial() != null) {
                errors.append(entry.getMaterial().getNumber());
            }
            errors.append("\n");
        }
        if (errors.length() > 0) {
            errors.insert(0, EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0057", (Locale)ctx.getLocale()) + "\n");
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0058", (Locale)ctx.getLocale()) + "\n" + errors.toString()));
        }
        if (parentids.size() == 0 || errors.length() > 0) {
            return EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0059", (Locale)ctx.getLocale()) + "\n" + errors.toString();
        }
        EntityViewInfo evi_parent = new EntityViewInfo();
        evi_parent.setSelector(new SelectorItemCollection());
        evi_parent.getSelector().add(new SelectorItemInfo("*"));
        evi_parent.getSelector().add(new SelectorItemInfo("entries.*"));
        evi_parent.setFilter(new FilterInfo());
        evi_parent.getFilter().getFilterItems().add(new FilterItemInfo("id", parentids, CompareType.INCLUDE));
        PricingPolicyBillCollection pps = this.getPricingPolicyBillCollection(ctx, evi_parent);
        SelectorItemCollection usic_type = PricingPolicyUtils.getUpateSelector_existsDatePricingPolicy();
        usic_type.add(new SelectorItemInfo("pricingbilltype"));
        String sourceBillType = "3171BFAD";
        String destBillType = "298D3323";
        int size3 = pps.size();
        for (int i = 0; i < size3; ++i) {
            pp = pps.get(i);
            boolean isAllTra = true;
            PricingPolicyBillEntryCollection newentrys = new PricingPolicyBillEntryCollection();
            Iterator it = pp.getEntries().iterator();
            while (it.hasNext()) {
                entry = (PricingPolicyBillEntryInfo)it.next();
                String eid = entry.getId().toString();
                if (!entryids.contains(eid)) {
                    isAllTra = false;
                    continue;
                }
                boolean isExists = PricingPolicyUtils.existsDatePricingPolicy(pp, entry, kv, true);
                if (!isExists) continue;
                newentrys.add(entry);
            }
            if (isAllTra) {
                pp.setPricingbilltype(PricingPolicyTypeEnum.price_platform);
                this.updatePartial(ctx, pp, usic_type);
                continue;
            }
            if (newentrys.size() <= 0) continue;
            PricingPolicyBillInfo newparent = (PricingPolicyBillInfo)pp.clone();
            newparent.setId(BOSUuid.create((BOSObjectType)pp.getBOSType()));
            newparent.setNumber(null);
            newparent.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            newparent.setPricingbilltype(PricingPolicyTypeEnum.price_platform);
            newparent.getEntries().clear();
            this.save(ctx, (CoreBaseInfo)newparent);
            HashSet<String> old_entryids = new HashSet<String>();
            int ksize = newentrys.size();
            for (int k = 0; k < ksize; ++k) {
                PricingPolicyBillEntryInfo newentry = newentrys.get(k);
                newentry.setParent(newparent);
                old_entryids.add(newentry.getId().toString());
                ippe.save((CoreBaseInfo)newentry);
            }
            BomBotpUtil.copyBOTPRelation((Context)ctx, (String)sourceBillType, (String)destBillType, (String)pp.getId().toString(), (String)newparent.getId().toString(), old_entryids);
        }
        return EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0060", (Locale)ctx.getLocale());
    }

    @Override
    protected String _splitBill(Context ctx, String id, List entryids) throws BOSException, EASBizException {
        if (id == null || entryids == null || entryids.size() == 0) {
            return null;
        }
        PricingPolicyBillInfo old_info = this.getPricingPolicyBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        BillBaseStatusEnum billbaseStatusEnum = old_info.getBaseStatus();
        if (!billbaseStatusEnum.equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0061", (Locale)ctx.getLocale())));
        }
        if (entryids.size() == 0) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0062", (Locale)ctx.getLocale())));
        }
        if (entryids.size() == old_info.getEntries().size()) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0063", (Locale)ctx.getLocale())));
        }
        PricingPolicyBillInfo newPricingPlicyBill = (PricingPolicyBillInfo)old_info.clone();
        newPricingPlicyBill.put("entries", (Object)new PricingPolicyBillEntryCollection());
        newPricingPlicyBill.setId(BOSUuid.create((BOSObjectType)newPricingPlicyBill.getBOSType()));
        newPricingPlicyBill.setNumber(null);
        this.save(ctx, (CoreBaseInfo)newPricingPlicyBill);
        PricingPolicyBillEntryCollection priPolicyEntryColl = old_info.getEntries();
        IPricingPolicyBillEntry ippe = PricingPolicyBillEntryFactory.getLocalInstance(ctx);
        for (int i = 0; i < priPolicyEntryColl.size(); ++i) {
            PricingPolicyBillEntryInfo entryInfo = priPolicyEntryColl.get(i);
            String newEntryId = entryInfo.getId().toString();
            if (!entryids.contains(newEntryId)) continue;
            newPricingPlicyBill.getEntries().add(entryInfo);
            entryInfo.setParent(newPricingPlicyBill);
            ippe.save((CoreBaseInfo)entryInfo);
        }
        BomBotpUtil.copyBOTPRelation((Context)ctx, null, (String)newPricingPlicyBill.getBOSType().toString(), (String)id, (String)newPricingPlicyBill.getId().toString(), new HashSet(entryids));
        return EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0064", (Locale)ctx.getLocale());
    }

    @Override
    protected String _mergeBill(Context ctx, List ids, List entryids) throws BOSException, EASBizException {
        PricingPolicyBillInfo info;
        if (ids == null || ids.size() == 0) {
            return null;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(this.getBOTPSelectors());
        evi.getSelector().add(new SelectorItemInfo("purType.*"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        PricingPolicyBillCollection coll = this.getPricingPolicyBillCollection(ctx, evi);
        PricingPolicyTypeEnum pricingbilltype = null;
        String orgID = null;
        String purGroupId = null;
        Object baseStatus = null;
        String purTypeID = null;
        HostTypeEnum ishost = null;
        String customerid = null;
        CoreBillBaseCollection collection = new CoreBillBaseCollection();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            String msg;
            info = coll.get(i);
            if (info.getBaseStatus() != BillBaseStatusEnum.TEMPORARILYSAVED) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0065", (Locale)ctx.getLocale())));
            }
            if (info.getPricingbilltype() == null) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0066", (Locale)ctx.getLocale())));
            }
            if (pricingbilltype == null) {
                pricingbilltype = info.getPricingbilltype();
            } else if (pricingbilltype != info.getPricingbilltype()) {
                msg = EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0067", (Locale)ctx.getLocale()) + "\n\n";
                msg = msg + pricingbilltype.getAlias() + "\u3001" + info.getPricingbilltype().getAlias();
                throw new EASBizException(new NumericExceptionSubItem("", msg));
            }
            if (info.getPurOrg() == null) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0068", (Locale)ctx.getLocale())));
            }
            if (orgID == null) {
                orgID = info.getPurOrg().getId().toString();
            } else if (!orgID.equals(info.getPurOrg().getId().toString())) {
                msg = EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0069", (Locale)ctx.getLocale());
                throw new EASBizException(new NumericExceptionSubItem("", msg));
            }
            if (info.getPurGroup() == null) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0070", (Locale)ctx.getLocale())));
            }
            if (purGroupId == null) {
                purGroupId = info.getPurGroup().getId().toString();
            } else if (!purGroupId.equals(info.getPurGroup().getId().toString())) {
                msg = EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0071", (Locale)ctx.getLocale());
                throw new EASBizException(new NumericExceptionSubItem("", msg));
            }
            if (pricingbilltype == PricingPolicyTypeEnum.NORPRICEPOLICY || pricingbilltype == PricingPolicyTypeEnum.price_platform) {
                PurReTypeInfo purreTypeInfo;
                if (info.get("purType") == null) {
                    throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0072", (Locale)ctx.getLocale())));
                }
                if (purTypeID == null) {
                    purreTypeInfo = (PurReTypeInfo)info.get("purType");
                    purTypeID = purreTypeInfo.getId().toString();
                    ishost = purreTypeInfo.getHostType();
                } else if (ishost == HostTypeEnum.IS_HOST) {
                    purreTypeInfo = (PurReTypeInfo)info.get("purType");
                    if (purreTypeInfo.getHostType() != HostTypeEnum.IS_HOST) {
                        String msg2 = EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0073", (Locale)ctx.getLocale()) + "\n\n";
                        msg2 = msg2 + EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0074", (Locale)ctx.getLocale());
                        throw new EASBizException(new NumericExceptionSubItem("", msg2));
                    }
                } else {
                    purreTypeInfo = (PurReTypeInfo)info.get("purType");
                    if (!purTypeID.equals(purreTypeInfo.getId().toString())) {
                        String msg3 = EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0073", (Locale)ctx.getLocale()) + "\n\n";
                        msg3 = msg3 + EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0074", (Locale)ctx.getLocale());
                        throw new EASBizException(new NumericExceptionSubItem("", msg3));
                    }
                }
            } else if (pricingbilltype == PricingPolicyTypeEnum.NONORPRICEPOLICY) {
                if (info.getCustomer() == null) {
                    throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0075", (Locale)ctx.getLocale())));
                }
                if (customerid == null) {
                    customerid = info.getCustomer().getId().toString();
                } else if (!customerid.equals(info.getCustomer().getId().toString())) {
                    msg = EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0076", (Locale)ctx.getLocale()) + "\n\n";
                    throw new EASBizException(new NumericExceptionSubItem("", msg));
                }
            }
            collection.add((CoreBillBaseInfo)info);
        }
        StringBuffer str_sql = new StringBuffer();
        StringBuffer str_id = new StringBuffer();
        IObjectCollection new_coll = PricingPolicyUtils.toPricingPolicy_botp(ctx, collection, "DJ-KU-M");
        if (new_coll == null || new_coll.size() == 0 || new_coll.size() > 1) {
            return EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0077", (Locale)ctx.getLocale()) + " size=" + (new_coll == null ? 0 : new_coll.size());
        }
        str_id.setLength(0);
        int size2 = new_coll.size();
        for (int i = 0; i < size2; ++i) {
            info = (PricingPolicyBillInfo)new_coll.getObject(i);
            str_id.append(",'").append(info.getId().toString()).append("'");
        }
        String str_ppids = str_id.substring(1);
        str_sql.setLength(0);
        str_sql.append("select re.fkeyid,re.fsrcentryid,re.fdestentryid");
        str_sql.append(" from T_BOT_Relation r left join t_Bot_Relationentry re on re.fkeyid = r.fid");
        str_sql.append(" where re.fdestentryid in (");
        str_sql.append(" select e.fid");
        str_sql.append(" from T_SM_PricingPolicyBill a left join t_Sm_Pricingpolicybillentry e on e.fparentid = a.fid");
        str_sql.append(" where a.fid in (").append(str_ppids).append(")");
        str_sql.append(" )");
        IRowSet rows = SQLUtils.executeQuery((Context)ctx, (String)str_sql.toString());
        ArrayList<String> sqls = new ArrayList<String>();
        ArrayList<Object[]> l_params = new ArrayList<Object[]>();
        try {
            str_id.setLength(0);
            while (rows.next()) {
                String fid = rows.getString("fkeyid");
                str_id.append(",'").append(fid).append("'");
                ArrayList<String> params = new ArrayList<String>();
                String fdestentryid = rows.getString("fdestentryid");
                params.add(fdestentryid);
                String fsrcentryid = rows.getString("fsrcentryid");
                params.add(fsrcentryid);
                l_params.add(params.toArray());
                str_sql.setLength(0);
                str_sql.append("update t_Bot_Relationentry ");
                str_sql.append(" set fdestentryid = '").append(fdestentryid).append("'");
                str_sql.append(" ,fdestobjectid = ").append(str_ppids);
                str_sql.append(" where fdestentryid = '").append(fsrcentryid).append("'");
                sqls.add(str_sql.toString());
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        String delete_fkeyids = str_id.substring(1);
        if (l_params.size() > 0) {
            String update_orderentry = " update T_SM_PurOrderEntry set fpricingpolicyentryids = ? where fpricingpolicyentryids = ?";
            SQLUtils.executeBatch((Context)ctx, (String)update_orderentry, l_params);
            String update_splitentry = " update T_SM_SalesSplitEntry set fpricingpolicyentryids = ? where fpricingpolicyentryids = ?";
            SQLUtils.executeBatch((Context)ctx, (String)update_splitentry, l_params);
        }
        int size3 = ids.size();
        for (int i = 0; i < size3; ++i) {
            str_sql.setLength(0);
            str_sql.append("update T_BOT_Relation ");
            str_sql.append(" set fdestobjectid = ").append(str_ppids);
            str_sql.append(" where fdestobjectid = '").append(ids.get(i)).append("'");
            sqls.add(str_sql.toString());
        }
        if (delete_fkeyids.length() > 0) {
            str_sql.setLength(0);
            str_sql.append("delete T_BOT_Relation where fid in (").append(delete_fkeyids).append(")");
            sqls.add(str_sql.toString());
            str_sql.setLength(0);
            str_sql.append("delete t_Bot_Relationentry where fkeyid in (").append(delete_fkeyids).append(")");
            sqls.add(str_sql.toString());
        }
        if (sqls.size() > 0) {
            String[] ss = new String[sqls.size()];
            sqls.toArray(ss);
            SQLUtils.executeBatch((Context)ctx, (String[])ss);
        }
        FilterInfo delete_filter = new FilterInfo();
        delete_filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        this.delete(ctx, delete_filter);
        return EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0078", (Locale)ctx.getLocale());
    }

    protected void updatePrice(Context ctx, PricingPolicyBillInfo info) throws BOSException, EASBizException, SQLException {
        PricingPolicyBillEntryCollection collection = info.getEntries();
        String p_org = info.getPurOrg().getNumber();
        ArrayList<String> updateListSql = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        StringBuffer update_sql = new StringBuffer();
        StringBuffer update_sql2 = new StringBuffer();
        SQLUtil sqlaa = new SQLUtil();
        sqlaa.appendSql(" select a.fid ");
        sqlaa.appendSql(" from  T_SM_PurOrderEntry a  ");
        sqlaa.appendSql(" inner join T_SM_SalesSplitEntry se on a.fsourcebillentryid=se.fid");
        sqlaa.appendSql(" inner join T_SM_PricingPolicyBillEntry b on se.fpricingpolicyentryids = b.fid");
        sqlaa.appendSql(" where b.fparentid='").appendSql(info.getId().toString()).appendSql("'");
        ResultSet set = sqlaa.exeQuery(ctx);
        if (!set.next()) {
            sqlaa = new SQLUtil();
            sqlaa.appendSql(" select a.fid ");
            sqlaa.appendSql(" from  T_SM_PurOrderEntry a  inner join T_SM_PricingPolicyBillEntry b ");
            sqlaa.appendSql(" on a.fsourcebillentryid=b.fsourcebillentryid");
            sqlaa.appendSql(" where b.fparentid='").appendSql(info.getId().toString()).appendSql("'");
            set = sqlaa.exeQuery(ctx);
        } else {
            set.beforeFirst();
        }
        String fpurorderentryidStr = "'*'";
        while (set.next()) {
            fpurorderentryidStr = fpurorderentryidStr + ",'" + set.getString("fid") + "'";
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            PricingPolicyBillEntryInfo billEntryInfo = collection.get(i);
            BigDecimal price = billEntryInfo.getPurPrice() == null ? BigDecimal.ZERO : billEntryInfo.getPurPrice();
            String number = billEntryInfo.getMaterial().getNumber();
            sql.setLength(0);
            sql.append("/*dialect*/ select FExchangeRate from T_SM_PurOrder sp ");
            sql.append(" inner join T_SM_PurOrderEntry poe on poe.fparentid=sp.fid ");
            sql.append(" where poe.fpricingpolicyentryids='" + billEntryInfo.getId() + "'");
            sql.append(" or poe.fid in (" + fpurorderentryidStr + ")");
            IRowSet rs_t = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            BigDecimal exchangeRate = BigDecimal.ZERO;
            while (rs_t.next()) {
                exchangeRate = rs_t.getBigDecimal("FExchangeRate");
            }
            update_sql.setLength(0);
            update_sql.append("/*dialect*/ update t_bd_materialpurchasing t_mp set t_mp.FPRICE =" + price);
            update_sql.append(" where t_mp.fid=(select mp.fid  from t_bd_materialpurchasing mp");
            update_sql.append(" left join t_bd_material m on mp.fmaterialid=m.fid");
            update_sql.append(" left join t_org_purchase o on o.fid=mp.forgunit");
            update_sql.append(" where m.fnumber ='" + number.trim() + "' and o.fnumber='" + p_org.trim() + "'");
            update_sql.append(" )");
            updateListSql.add(update_sql.toString());
            sql.setLength(0);
            sql.append("/*dialect*/ select e1.FDiscountMode from T_SM_PurInnerDealPrice e1 ");
            sql.append(" inner join T_SM_PurOrderEntry e on e1.fpurorderentryid=e.fid");
            sql.append(" where e.fpricingpolicyentryids='" + billEntryInfo.getId() + "'");
            sql.append(" or e.fid in (" + fpurorderentryidStr + ")");
            rs_t = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            int discountmode = -1;
            while (rs_t.next()) {
                discountmode = rs_t.getInt("FDiscountMode");
            }
            update_sql2.setLength(0);
            update_sql2.append("/*dialect*/ update T_SM_PurOrderEntry  set CFDjPrice =" + price);
            update_sql2.append("  where (fpricingpolicyentryids='" + billEntryInfo.getId() + "') ");
            update_sql2.append(" or fid in (" + fpurorderentryidStr + ")");
            DbUtil.execute((Context)ctx, (String)update_sql2.toString());
        }
        EmmUtils.executeBatchUpdate((Context)ctx, updateListSql);
    }
}

