/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.processor.stocktransferplan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.industry.emm.mm.mo.StockTransferPlan;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.sd.sale.SaleOrderCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;

public class SaleOrderWriteBackSourceBillProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 6374923597825950355L;
    private String RESOURCE_NAME = "com.kingdee.eas.scm.im.inv.EMMSCMInvResource";
    public static final String BIZTYPE_SALEPLAN_NO = "250";

    public SaleOrderWriteBackSourceBillProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public SaleOrderWriteBackSourceBillProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SaleOrderWriteBackSourceBillProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        BatchExecuteParamsEntry[] entries = batchResults.getParamEntries();
        if (null == collection || collection.size() == 0 || entries == null || entries.length == 0) {
            return;
        }
        if (!(BatchActionEnum.SAVE.equals((Object)this.batchAction) || BatchActionEnum.ADDNEW.equals((Object)this.batchAction) || BatchActionEnum.SUBMIT.equals((Object)this.batchAction))) {
            return;
        }
        for (int i = 0; i < collection.size(); ++i) {
            IObjectValue iObjectValue = collection.getObject(i);
        }
        if (BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) {
            for (BatchExecuteParamsEntry entrie : entries) {
                SaleOrderInfo saleInfo = (SaleOrderInfo)entrie.get(0);
                SaleOrderCollection billColl = new SaleOrderCollection();
                billColl.add(saleInfo);
                this.checkRequiredFieldWhenBatchSubmit(this.ctx, billColl);
            }
        } else if (BatchActionEnum.SAVE.equals((Object)this.batchAction)) {
            for (BatchExecuteParamsEntry entrie : entries) {
                SaleOrderInfo saleInfo = (SaleOrderInfo)entrie.get(0);
                SaleOrderCollection billColl = new SaleOrderCollection();
                billColl.add(saleInfo);
                this.handleAfterTransform(this.ctx, "SAVE", billColl);
            }
        }
        this.writeBackSourceBill(this.ctx, collection, this.batchAction);
    }

    protected void checkRequiredFieldWhenBatchSubmit(Context ctx, SaleOrderCollection billColl) throws EASBizException, BOSException {
        for (SaleOrderInfo billInfo : billColl) {
            String strInfo;
            String strInfo2;
            BillBaseStatusEnum statusEnum = billInfo.getBaseStatus();
            if (null != statusEnum) {
                if (BillBaseStatusEnum.CLOSED.equals((Object)statusEnum)) {
                    strInfo2 = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0000", (Object[])new Object[]{billInfo.getNumber()});
                    throw new EASBizException(new NumericExceptionSubItem("0000", strInfo2));
                }
                if (BillBaseStatusEnum.AUDITED.equals((Object)statusEnum)) {
                    strInfo2 = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0001", (Object[])new Object[]{billInfo.getNumber()});
                    throw new EASBizException(new NumericExceptionSubItem("0001", strInfo2));
                }
            }
            if (billInfo.getSaleOrgUnit() == null) {
                strInfo2 = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0002", (Object[])new Object[]{billInfo.getNumber()});
                throw new EASBizException(new NumericExceptionSubItem("0002", strInfo2));
            }
            if (billInfo.getOrderCustomer() == null) {
                strInfo2 = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0003", (Object[])new Object[]{billInfo.getNumber()});
                throw new EASBizException(new NumericExceptionSubItem("0003", strInfo2));
            }
            if (billInfo.getSalePerson() == null) {
                strInfo2 = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0004", (Object[])new Object[]{billInfo.getNumber()});
                throw new EASBizException(new NumericExceptionSubItem("0004", strInfo2));
            }
            if (billInfo.getBizType() == null) {
                strInfo2 = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0005", (Object[])new Object[]{billInfo.getNumber()});
                throw new EASBizException(new NumericExceptionSubItem("0005", strInfo2));
            }
            if (billInfo.getPaymentType() == null) {
                billInfo.setPaymentType(PaymentTypeFactory.getLocalInstance((Context)ctx).getPaymentTypeInfo((IObjectPK)new ObjectUuidPK("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")));
            }
            if (billInfo.getBizDate() == null) {
                strInfo2 = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0006", (Object[])new Object[]{billInfo.getNumber()});
                throw new EASBizException(new NumericExceptionSubItem("0006", strInfo2));
            }
            String bizTypeId = billInfo.getBizType().getId().toString();
            boolean isDerectSale = "d8e80652-0111-1000-e000-04c5c0a812202407435C".equalsIgnoreCase(bizTypeId);
            if (isDerectSale && billInfo.getDirectSupplier() == null) {
                strInfo = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0007", (Object[])new Object[]{billInfo.getNumber()});
                throw new EASBizException(new NumericExceptionSubItem("0007", strInfo));
            }
            if (billInfo.getDeliveryType() == null) {
                strInfo = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0008", (Object[])new Object[]{billInfo.getNumber()});
                throw new EASBizException(new NumericExceptionSubItem("0008", strInfo));
            }
            if (billInfo.isIsCentralBalance()) {
                if (billInfo.getStorageOrgUnit() == null) {
                    strInfo = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0009", (Object[])new Object[]{billInfo.getNumber()});
                    throw new EASBizException(new NumericExceptionSubItem("0009", strInfo));
                }
                if (billInfo.isIsCentralBalance()) {
                    if (billInfo.getBalanceCompanyOrgUnit() == null) {
                        strInfo = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0010", (Object[])new Object[]{billInfo.getNumber()});
                        throw new EASBizException(new NumericExceptionSubItem("0010", strInfo));
                    }
                    if (billInfo.getBalanceSaleOrgUnit() == null) {
                        strInfo = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0011", (Object[])new Object[]{billInfo.getNumber()});
                        throw new EASBizException(new NumericExceptionSubItem("0011", strInfo));
                    }
                    if (billInfo.getBalanceStorageOrgUnit() == null) {
                        strInfo = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0012", (Object[])new Object[]{billInfo.getNumber()});
                        throw new EASBizException(new NumericExceptionSubItem("0012", strInfo));
                    }
                    if (billInfo.getBalanceWarehouse() == null) {
                        strInfo = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0013", (Object[])new Object[]{billInfo.getNumber()});
                        throw new EASBizException(new NumericExceptionSubItem("0013", strInfo));
                    }
                }
            }
            if (billInfo.getCurrency() == null) {
                strInfo = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0014", (Object[])new Object[]{billInfo.getNumber()});
                throw new EASBizException(new NumericExceptionSubItem("0014", strInfo));
            }
            if (billInfo.getExchangeRate() == null) {
                strInfo = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0015", (Object[])new Object[]{billInfo.getNumber()});
                throw new EASBizException(new NumericExceptionSubItem("0015", strInfo));
            }
            if (billInfo.getEntries() == null || billInfo.getEntries().isEmpty() || billInfo.getEntries().size() <= 0) {
                strInfo = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0016", (Object[])new Object[]{billInfo.getNumber()});
                throw new EASBizException(new NumericExceptionSubItem("0016", strInfo));
            }
            String SALEORDER203 = this.getParamValue(ctx, "SALEORDER203", billInfo.getSaleOrgUnit().getId().toString());
            SaleOrderEntryCollection entryColl = billInfo.getEntries();
            for (SaleOrderEntryInfo entryInfo : entryColl) {
                SimpleDateFormat sdf;
                String strInfo3;
                if (entryInfo.getTaxRate() == null) {
                    entryInfo.setTaxRate(BigDecimal.valueOf(17.0));
                }
                if (entryInfo.getMaterial() == null) {
                    strInfo3 = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0017", (Object[])new Object[]{billInfo.getNumber(), entryInfo.getSeq()});
                    throw new EASBizException(new NumericExceptionSubItem("0017", strInfo3));
                }
                if (entryInfo.getUnit() == null) {
                    strInfo3 = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0018", (Object[])new Object[]{billInfo.getNumber(), entryInfo.getSeq()});
                    throw new EASBizException(new NumericExceptionSubItem("0018", strInfo3));
                }
                if (entryInfo.getBaseUnit() == null) {
                    strInfo3 = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0019", (Object[])new Object[]{billInfo.getNumber(), entryInfo.getSeq()});
                    throw new EASBizException(new NumericExceptionSubItem("0019", strInfo3));
                }
                if (entryInfo.getQty() == null || entryInfo.getQty().compareTo(BigDecimal.ZERO) <= 0) {
                    strInfo3 = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0020", (Object[])new Object[]{billInfo.getNumber(), entryInfo.getSeq()});
                    throw new EASBizException(new NumericExceptionSubItem("0020", strInfo3));
                }
                if (entryInfo.getBaseQty() == null || entryInfo.getBaseQty().compareTo(BigDecimal.ZERO) <= 0) {
                    strInfo3 = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0021", (Object[])new Object[]{billInfo.getNumber(), entryInfo.getSeq()});
                    throw new EASBizException(new NumericExceptionSubItem("0021", strInfo3));
                }
                if (!(entryInfo.isIsPresent() || entryInfo.getPrice() != null && entryInfo.getPrice().compareTo(BigDecimal.ZERO) > 0)) {
                    strInfo3 = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0022", (Object[])new Object[]{billInfo.getNumber(), entryInfo.getSeq()});
                    throw new EASBizException(new NumericExceptionSubItem("0022", strInfo3));
                }
                if (!(entryInfo.isIsPresent() || entryInfo.getAmount() != null && entryInfo.getAmount().compareTo(BigDecimal.ZERO) > 0)) {
                    strInfo3 = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0023", (Object[])new Object[]{billInfo.getNumber(), entryInfo.getSeq()});
                    throw new EASBizException(new NumericExceptionSubItem("0023", strInfo3));
                }
                if (entryInfo.getSendDate() == null) {
                    strInfo3 = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0024", (Object[])new Object[]{billInfo.getNumber(), entryInfo.getSeq()});
                    throw new EASBizException(new NumericExceptionSubItem("0024", strInfo3));
                }
                if (null != entryInfo.getDeliveryDate() && (sdf = new SimpleDateFormat("yyyy-MM-dd")).format(entryInfo.getDeliveryDate()).compareTo(sdf.format(entryInfo.getSendDate())) < 0) {
                    String strInfo4 = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0025", (Object[])new Object[]{billInfo.getNumber(), entryInfo.getSeq()});
                    throw new EASBizException(new NumericExceptionSubItem("0025", strInfo4));
                }
                if (SALEORDER203 == null || !"true".equals(SALEORDER203) || entryInfo.getPrice() != null && entryInfo.getPrice().compareTo(new BigDecimal(0)) != 0) continue;
                strInfo3 = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0026", (Object[])new Object[]{billInfo.getNumber(), entryInfo.getSeq()});
                throw new EASBizException(new NumericExceptionSubItem("0026", strInfo3));
            }
        }
    }

    public void handleAfterTransform(Context ctx, String action, SaleOrderCollection collection) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        IRowSet rs = null;
        try {
            for (int i = 0; i < collection.size(); ++i) {
                SaleOrderInfo info = (SaleOrderInfo)collection.getObject(i);
                if (info == null || info.getSaleOrgUnit() == null) continue;
                String SALEORDER204 = this.getParamValue(ctx, "SALEORDER204", info.getSaleOrgUnit().getId().toString());
                if (SALEORDER204 == null || "".equals(SALEORDER204) || "false".equals(SALEORDER204) || "FALSE".equals(SALEORDER204)) {
                    // empty if block
                }
                SaleOrderEntryCollection col = info.getEntries();
                for (int a = 0; a < col.size(); ++a) {
                    SaleOrderEntryInfo entry = col.get(a);
                    if (entry.getMaterial() == null || entry.getSourceBillId() == null) continue;
                    BOSUuid sourceBillBOSUUID = BOSUuid.read((String)entry.getSourceBillId());
                    BOSObjectType sourceBillType = sourceBillBOSUUID == null ? null : sourceBillBOSUUID.getType();
                    BigDecimal fqty = entry.getQty();
                    if (sourceBillBOSUUID == null || sourceBillType == null || !new StockTransferPlan().getType().equals((Object)sourceBillType)) continue;
                    sql.setLength(0);
                    sql.append(" Select a.fnumber, isNull(a.cfsubmitqty,0) as fsubmitqty, \r\n");
                    sql.append(" isNull((select sum(TOBE.FQty) from T_IM_TransferOrderBillEntry TOBE where TOBE.FSourceBillID = a.fid),0) as ftransferOrderQty, \r\n");
                    sql.append(" isNull((select sum(sd.fqty) from t_sd_saleorderentry sd where sd.fsourcebillid = a.fid  ");
                    if (entry.getId() != null) {
                        sql.append(" and sd.fid <> '").append(entry.getId()).append("'");
                    }
                    sql.append(" ),0) as fsdqty \r\n");
                    sql.append(" from CT_MO_StockTransferPlan a \r\n");
                    sql.append(" where a.fid = '").append(entry.getSourceBillId()).append("' \r\n");
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    while (rs.next()) {
                        BigDecimal fsubmitqty = rs.getBigDecimal("fsubmitqty");
                        BigDecimal ftransferOrderQty = rs.getBigDecimal("ftransferOrderQty");
                        BigDecimal fsdqty = rs.getBigDecimal("fsdqty");
                        String fdbplanNumber = rs.getString("fnumber");
                        if (fqty.add(fsdqty).add(ftransferOrderQty).compareTo(fsubmitqty) <= 0) continue;
                        if (ftransferOrderQty.compareTo(new BigDecimal(0)) != 0) {
                            String strInfo = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0027", (Object[])new Object[]{fdbplanNumber, fsubmitqty.setScale(2).toString(), fqty.setScale(2).toString(), fsdqty.setScale(2).toString(), ftransferOrderQty.setScale(2).toString()});
                            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.EMMSCMInvResource", (String)"0EMMSCMInv-0005", (Locale)ctx.getLocale()), strInfo));
                        }
                        String strInfo = com.kingdee.eas.util.client.EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_XSDD_0028", (Object[])new Object[]{fdbplanNumber, fsubmitqty.setScale(2).toString(), fqty.setScale(2).toString(), fsdqty.setScale(2).toString()});
                        throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.EMMSCMInvResource", (String)"0EMMSCMInv-0005", (Locale)ctx.getLocale()), strInfo));
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
        }
    }

    protected boolean getSystemParamValue(Context ctx, StorageOrgUnitInfo storage, String paramName) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select fvalue_").append(ctx.getLocale()).append("  value from t_bas_paramitem where  fkeyid in (select fid from t_bas_param where fnumber = '").append(paramName).append("')  ");
        sb.append(" and forgunitid = '").append(storage.getId().toString()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        boolean value = false;
        try {
            while (rs.next()) {
                value = new Boolean(rs.getString("value"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return value;
    }

    protected void writeBackSourceBill(Context ctx, IObjectCollection objectCollection, BatchActionEnum action) throws BOSException, EASBizException {
        if (ctx == null || objectCollection == null || action == null) {
            return;
        }
        if (objectCollection.size() == 0) {
            return;
        }
        int effectedRows = 0;
        StringBuffer sql = new StringBuffer();
        HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>();
        for (int index = 0; index < objectCollection.size(); ++index) {
            SaleOrderEntryCollection tobeCollection;
            SaleOrderInfo tobInfo;
            IObjectValue objectValue = objectCollection.getObject(index);
            SaleOrderInfo saleOrderInfo = objectValue == null ? null : (tobInfo = objectValue instanceof SaleOrderInfo ? (SaleOrderInfo)objectValue : null);
            if (tobInfo == null || (tobeCollection = tobInfo.getEntries()) == null || tobeCollection.size() <= 0) continue;
            for (int entryIndex = 0; entryIndex < tobeCollection.size(); ++entryIndex) {
                BigDecimal qty;
                BOSObjectType sourceBillType;
                String sourceBillID;
                SaleOrderEntryInfo tobeInfo = tobeCollection.get(entryIndex);
                String string = sourceBillID = tobeInfo == null ? null : tobeInfo.getSourceBillId();
                BOSUuid sourceBillBOSUUID = sourceBillID == null ? null : (sourceBillID.trim().length() == 0 ? null : BOSUuid.read((String)sourceBillID));
                BOSObjectType bOSObjectType = sourceBillType = sourceBillBOSUUID == null ? null : sourceBillBOSUUID.getType();
                if (sourceBillID == null || sourceBillBOSUUID == null || sourceBillType == null || !new StockTransferPlan().getType().equals((Object)sourceBillType)) continue;
                BigDecimal bigDecimal = tobeInfo == null ? BigDecimal.ZERO : (qty = tobeInfo.getQty() == null ? BigDecimal.ZERO : tobeInfo.getQty());
                BigDecimal sumQty = qtyMap.containsKey(sourceBillID) ? (qtyMap.get(sourceBillID) == null ? BigDecimal.ZERO : (qtyMap.get(sourceBillID) instanceof BigDecimal ? (BigDecimal)qtyMap.get(sourceBillID) : BigDecimal.ZERO)) : BigDecimal.ZERO;
                qtyMap.put(sourceBillID, sumQty.add(qty));
            }
        }
        if (qtyMap != null && qtyMap.size() > 0) {
            Set qtyMapKeySet = qtyMap.keySet();
            for (Object qtyMapKey : qtyMapKeySet) {
                BOSObjectType sourceType;
                String sourceID;
                String string = sourceID = qtyMapKey == null ? null : qtyMapKey.toString();
                BOSUuid sourceBOSUUID = sourceID == null ? null : (sourceID.trim().length() == 0 ? null : BOSUuid.read((String)sourceID));
                BOSObjectType bOSObjectType = sourceType = sourceBOSUUID == null ? null : sourceBOSUUID.getType();
                if (sourceID == null || sourceID == null || sourceType == null || !new StockTransferPlan().getType().equals((Object)sourceType)) continue;
                if (BatchActionEnum.ADDNEW.equals((Object)action) || BatchActionEnum.SAVE.equals((Object)action)) {
                    sql.setLength(0);
                    sql.append("Update CT_MO_StockTransferPlan UT\r\n");
                    sql.append("Set CFSubmitTransferQty=IsNull((");
                    sql.append("Select\r\n");
                    sql.append("Sum(SOBE.FQty) FSOBESumQty\r\n");
                    sql.append("From CT_MO_StockTransferPlan STP\r\n");
                    sql.append("Inner Join t_sd_saleorderentry SOBE On SOBE.FSourceBillID=STP.FID\r\n");
                    sql.append("Where\r\n");
                    sql.append("1=1\r\n");
                    sql.append("And STP.FID='").append(sourceID).append("'\r\n");
                    sql.append("),0)\r\n");
                    sql.append(" + IsNull((");
                    sql.append("Select\r\n");
                    sql.append("Sum(TOBE.FQty) FTOBESumQty\r\n");
                    sql.append("From CT_MO_StockTransferPlan STP\r\n");
                    sql.append("Inner Join T_IM_TransferOrderBillEntry TOBE On TOBE.FSourceBillID=STP.FID\r\n");
                    sql.append("Where\r\n");
                    sql.append("1=1\r\n");
                    sql.append("And STP.FID='").append(sourceID).append("'\r\n");
                    sql.append("),0)\r\n");
                    sql.append("Where\r\n");
                    sql.append("1=1\r\n");
                    sql.append("And UT.FID='").append(sourceID).append("'\r\n");
                }
                effectedRows = SQLUtils.execute((Context)ctx, (String)sql.toString());
                this.writeStockTransferPlanDetial(ctx, sourceID, action);
                System.out.println("Execute SQL Effected Rows " + effectedRows + ":\r\n" + sql.toString());
            }
        }
    }

    protected void writeStockTransferPlanDetial(Context ctx, String sourceBillid, BatchActionEnum action) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Select fid, CFSTORAGEORGUNITID,CFMATERIALID,Isnull(CFTRANSFERQTY,0) As CFTRANSFERQTY ,Isnull(CFSUBMITQTY,0) As CFSUBMITQTY,Isnull(CFAUDITTRANSFERQTY,0) As CFAUDITTRANSFERQTY , \r\n");
        sql.append(" CFPROJECTID,CFTRACEID,CFPROJECTJCHID,Isnull(CFSUBMITTRANSFERQTY,0) As CFSUBMITTRANSFERQTY,CFPROCESSFLOW,CFSUPPLYSOUID \r\n");
        sql.append(" From CT_MO_StockTransferPlan UT\r\n");
        if (BatchActionEnum.DELETE.equals((Object)action)) {
            sql.append(" where fid in(").append(sourceBillid).append(")");
        } else {
            sql.append(" where fid = '").append(sourceBillid).append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        IRowSet rs2 = null;
        ArrayList<String> sqlList = new ArrayList<String>();
        int irow = 0;
        int rsSize = 0;
        try {
            while (rs.next()) {
                String fid = rs.getString("fid");
                BigDecimal fqty = rs.getBigDecimal("CFSUBMITTRANSFERQTY");
                sql.setLength(0);
                sql.append(" Select ut.fid, ut.CFSTORAGEORGUNITID,ut.CFMATERIALID,Isnull(ut.CFTRANSFERQTY,0) As CFTRANSFERQTY,Isnull(ut.CFSUBMITQTY,0) As CFSUBMITQTY,Isnull(ut.CFAUDITTRANSFERQTY,0) As CFAUDITTRANSFERQTY, \r\n");
                sql.append(" ut.CFPROJECTID,ut.CFTRACEID,ut.CFPROJECTJCHID,Isnull(ut.CFSUBMITTRANSFERQTY,0) As CFSUBMITTRANSFERQTY,ut.CFPROCESSFLOW,ut.CFSUPPLYSOUID \r\n");
                sql.append(" From CT_MO_StockTransferPlandetial ut\r\n");
                sql.append(" Left outer join t_mm_tracknumber t on ut.CFTRACEID = t.fid \r\n");
                sql.append(" where exists(select 1 from t_bot_relation a where a.FSRCOBJECTID = ut.fid and a.FDESTOBJECTID = '").append(fid).append("' and a.FSRCENTITYID = '9CBCD44C' and a.FDESTENTITYID = '08B2670B')\r\n");
                sql.append(" and exists(Select 1 from CT_MO_StockTransferPlan b where b.fid = '").append(fid).append("' and isnull(b.CFMATERIALID,'Null') = isnull(ut.cfmaterialid,'Null') \r\n");
                sql.append(" and isnull(b.CFPROJECTID,'Null') = isnull(ut.CFPROJECTID,'Null') ");
                sql.append(" and isnull(b.CFSTORAGEORGUNITID,'Null') = isnull(ut.CFSTORAGEORGUNITID,'Null') ");
                sql.append(" and isnull(b.CFSUPPLYSOUID,'Null') = isnull(ut.CFSUPPLYSOUID,'Null') ");
                sql.append(" and isnull(b.CFPROCESSFLOW,'Null') = isnull(ut.CFPROCESSFLOW,'Null') ");
                sql.append(" )\r\n");
                sql.append(" order by t.fnumber \r\n");
                rs2 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                rsSize = rs2.size();
                irow = 0;
                while (rs2.next()) {
                    String fdetialid = rs2.getString("fid");
                    BigDecimal fdetialsubmitQty = rs2.getBigDecimal("CFSUBMITTRANSFERQTY");
                    BigDecimal fdetialQty = rs2.getBigDecimal("CFSubmitQTY");
                    BigDecimal fnewdetialsubmitQty = new BigDecimal(0);
                    if (fdetialQty.compareTo(fqty) >= 0) {
                        fnewdetialsubmitQty = fqty;
                        fqty = new BigDecimal(0);
                    } else {
                        fnewdetialsubmitQty = fdetialQty;
                        fqty = fqty.subtract(fdetialQty);
                    }
                    if (++irow == rsSize && fqty.compareTo(new BigDecimal(0)) > 0) {
                        fnewdetialsubmitQty = fnewdetialsubmitQty.add(fqty);
                        fqty = new BigDecimal(0);
                    }
                    sql.setLength(0);
                    sql.append("update CT_MO_StockTransferPlandetial  ");
                    sql.append(" set CFSUBMITTRANSFERQTY = ").append(fnewdetialsubmitQty);
                    sql.append(" where fid = '").append(fdetialid).append("'");
                    sqlList.add(sql.toString());
                }
            }
            if (sqlList.size() > 0) {
                com.kingdee.eas.base.core.util.DbUtil.executeBatch((Context)ctx, sqlList);
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.scm.im.inv.EMMSCMInvResource", (String)"0EMMSCMInv-0004", (Locale)ctx.getLocale()) + e.getMessage()));
        }
    }

    protected String getParamValue(Context ctx, String paramName, String orgUnitID) throws BOSException, EASBizException {
        if (orgUnitID == null) {
            return null;
        }
        String value = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("value"));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnitID.id", (Object)orgUnitID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)paramName, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        ParamItemCollection paramItemCollection = ParamItemFactory.getLocalInstance((Context)ctx).getParamItemCollection(entityViewInfo);
        if (paramItemCollection != null && paramItemCollection.size() > 0 && paramItemCollection.get(0) != null) {
            value = paramItemCollection.get(0).getValue() == null ? "" : paramItemCollection.get(0).getValue();
        }
        return value;
    }
}

