/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.core.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.GeneTreeBaseInfo;
import com.kingdee.eas.eqm.common.core.app.AbstractGeneTreeBaseControllerBean;
import com.kingdee.eas.eqm.common.core.app.action.CascadeDeleteDataBaseServerAction;
import com.kingdee.eas.eqm.common.core.app.action.IServerActionManager;
import com.kingdee.eas.eqm.common.core.app.action.ServerActionManager;
import com.kingdee.eas.eqm.common.core.app.action.ServerEvent;
import com.kingdee.eas.eqm.common.core.app.util.GeneServerUtils;
import com.kingdee.eas.eqm.common.core.app.util.GeneSeverMetadataUtils;
import com.kingdee.eas.eqm.common.core.app.verify.GeneDataBaseAddnewCommonVerifyItem;
import com.kingdee.eas.eqm.common.core.app.verify.GeneDataBaseAuditCommonVerifyItem;
import com.kingdee.eas.eqm.common.core.app.verify.GeneDataBaseBlockedCommonVerifyItem;
import com.kingdee.eas.eqm.common.core.app.verify.GeneDataBaseCancelCancelCommonVerifyItem;
import com.kingdee.eas.eqm.common.core.app.verify.GeneDataBaseCancelCommonVerifyItem;
import com.kingdee.eas.eqm.common.core.app.verify.GeneDataBaseDeleteCommonVerifyItem;
import com.kingdee.eas.eqm.common.core.app.verify.GeneDataBaseUnAuditCommonVerifyItem;
import com.kingdee.eas.eqm.common.core.app.verify.GeneDataBaseUnBlockedCommonVerifyItem;
import com.kingdee.eas.eqm.common.core.app.verify.GeneDataBaseUpdateCommonVerifyItem;
import com.kingdee.eas.eqm.common.core.app.verify.NameDuplicateVerifyItem;
import com.kingdee.eas.eqm.common.core.codingrule.ISuportCodingRule;
import com.kingdee.eas.eqm.common.core.codingrule.ServerCodingRuleStrategy;
import com.kingdee.eas.eqm.common.core.util.GeneFilterUtils;
import com.kingdee.eas.eqm.common.core.verify.IVerifyManager;
import com.kingdee.eas.eqm.common.core.verify.VerifyManager;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class GeneTreeBaseControllerBean
extends AbstractGeneTreeBaseControllerBean
implements ISuportCodingRule {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.common.core.app.GeneTreeBaseControllerBean");
    private IServerActionManager serverActionManager = null;

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        GeneTreeBaseInfo info = (GeneTreeBaseInfo)model;
        String tableName = this.getTableName(ctx);
        GeneServerUtils.checkLastUpTime(ctx, (ObjectBaseInfo)info, tableName);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        GeneTreeBaseInfo info = (GeneTreeBaseInfo)model;
        String tableName = this.getTableName(ctx);
        GeneServerUtils.checkLastUpTime(ctx, (ObjectBaseInfo)info, tableName);
        this.getCodingRuleStrategy().initEditNumber(this, ctx, info);
        this._checkNumberBlank(ctx, info);
        this._checkNumberDup(ctx, info);
        return super._submit(ctx, model);
    }

    protected void _moveTreeNode(Context ctx, IObjectValue sourceNode, IObjectValue targetNode) throws EASBizException, BOSException {
        GeneTreeBaseInfo targetInfo = (GeneTreeBaseInfo)targetNode;
        if (targetInfo == null || targetInfo.isIsLeaf()) {
            // empty if block
        }
        super._moveTreeNode(ctx, sourceNode, targetNode);
    }

    public ServerCodingRuleStrategy getCodingRuleStrategy() {
        return new ServerCodingRuleStrategy();
    }

    public FilterInfo getFilterForCheckNumber(CoreBillBaseInfo model) {
        return null;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        GeneTreeBaseInfo info = (GeneTreeBaseInfo)this.getValue(ctx, pk);
        IVerifyManager verifymanager = this.getDeleteVerifyManager(ctx, info);
        verifymanager.verify();
        super._delete(ctx, pk);
        String orgID = "";
        orgID = info.getMainOrgUnit() != null ? info.getMainOrgUnit().getId().toString() : ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        this.getCodingRuleStrategy().recycleNumber(ctx, (CoreBaseInfo)info, orgID);
        this.fireServerAction(ctx, pk, "AFTER_DELETE", null);
    }

    protected IVerifyManager getDeleteVerifyManager(Context ctx, GeneTreeBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        GeneDataBaseDeleteCommonVerifyItem verifyItem = new GeneDataBaseDeleteCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    private TreeBaseInfo getFullParent(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        TreeBaseInfo parent = treeBaseInfo.innerGetParent();
        if (parent == null || parent.getId().equals((Object)treeBaseInfo.getId())) {
            return null;
        }
        parent = this.lazyLoad(ctx, (IObjectValue)parent);
        treeBaseInfo.innerSetParent(parent);
        return parent;
    }

    private TreeBaseInfo lazyLoad(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("CU.id"));
        selector.add(new SelectorItemInfo("longNumber"));
        selector.add(new SelectorItemInfo("parent"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("level"));
        selector.add(new SelectorItemInfo("isLeaf"));
        selector.add(new SelectorItemInfo("displayName"));
        selector.add(new SelectorItemInfo("deletedStatus"));
        TreeBaseInfo result = (TreeBaseInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(treeBaseInfo.getId()), selector);
        return result;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        GeneTreeBaseInfo info = (GeneTreeBaseInfo)model;
        this.getCodingRuleStrategy().initNumber(this, ctx, info);
        LogControllManager.getInstance().enableLog();
        this.logAddnew(ctx, info);
        this._checkNumberBlank(ctx, info);
        this._checkNameBlank(ctx, info);
        this._checkNumberDup(ctx, info);
        IVerifyManager verifymanager = this.getAddnewVerifyManager(ctx, info);
        verifymanager.verify();
        IObjectPK pk = null;
        pk = super._addnew(ctx, model);
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        GeneTreeBaseInfo info = (GeneTreeBaseInfo)model;
        this._checkNumberBlank(ctx, info);
        this._checkNameBlank(ctx, info);
        this._checkNumberDup(ctx, info);
        this.getCodingRuleStrategy().initEditNumber(this, ctx, info);
        IVerifyManager verifymanager = this.getUpdateVerifyManager(ctx, info);
        verifymanager.verify();
        super._update(ctx, pk, model);
    }

    @Override
    public boolean isNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)coreBillBaseInfo.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (coreBillBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)coreBillBaseInfo.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1");
        }
        if (FilterUtility.hasFilterItem((FilterInfo)this.getFilterForDefaultCU(ctx, (IObjectValue)coreBillBaseInfo))) {
            filter.mergeFilter(this.getFilterForDefaultCU(ctx, (IObjectValue)coreBillBaseInfo), "AND");
        }
        return super._exists(ctx, filter);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        GeneTreeBaseInfo info = (GeneTreeBaseInfo)this.getValue(ctx, pk);
        IVerifyManager verifymanager = this.getAuditVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FCheckedStatus=? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), pk.toString()});
    }

    protected IVerifyManager getAuditVerifyManager(Context ctx, GeneTreeBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        GeneDataBaseAuditCommonVerifyItem verifyItem = new GeneDataBaseAuditCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    protected IVerifyManager getUpdateVerifyManager(Context ctx, GeneTreeBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        GeneDataBaseUpdateCommonVerifyItem verifyItem = new GeneDataBaseUpdateCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        verifymanager.addVerifyItem(new NameDuplicateVerifyItem(ctx, info, null, info.getParentProperty()));
        return verifymanager;
    }

    protected IVerifyManager getAddnewVerifyManager(Context ctx, GeneTreeBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        GeneDataBaseAddnewCommonVerifyItem verifyItem = new GeneDataBaseAddnewCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        verifymanager.addVerifyItem(new NameDuplicateVerifyItem(ctx, info, null, info.getParentProperty()));
        return verifymanager;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String controlType;
        GeneTreeBaseInfo treeModel = (GeneTreeBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)treeModel.getNumber(), CompareType.EQUALS);
        GeneFilterUtils.mergeFilter(filter, filterItem);
        if (treeModel.getId() != null) {
            FilterItemInfo filterItem2 = new FilterItemInfo("id", (Object)treeModel.getId().toString(), CompareType.NOTEQUALS);
            GeneFilterUtils.mergeFilter(filter, filterItem2);
        }
        if ((controlType = GeneSeverMetadataUtils.getControlType(ctx, this.getBOSType())) != null && (controlType.equalsIgnoreCase("D") || controlType.equalsIgnoreCase("I")) && treeModel.getMainOrgUnit() != null && FilterUtility.hasFilterItem((FilterInfo)filter)) {
            GeneFilterUtils.mergeFilter(filter, new FilterItemInfo(treeModel.getBizOrgPropertyName() + ".id", (Object)treeModel.getMainOrgUnit().getId().toString()));
        }
        if (this._exists(ctx, filter)) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{treeModel.getNumber()});
        }
    }

    protected void lockData(Context ctx, String pk) throws BOSException {
        String tbl = this.getTableName(ctx);
        String sql = "update " + tbl + " set FLastUpdateTime= now() where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{pk.toString()});
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        GeneTreeBaseInfo info = (GeneTreeBaseInfo)this.getValue(ctx, pk);
        IVerifyManager verifymanager = this.getUnAuditVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FCheckedStatus=? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(1), pk.toString()});
    }

    protected IVerifyManager getUnAuditVerifyManager(Context ctx, GeneTreeBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        GeneDataBaseUnAuditCommonVerifyItem verifyItem = new GeneDataBaseUnAuditCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    protected IVerifyManager getUnBlockedVerifyManager(Context ctx, GeneTreeBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        GeneDataBaseUnBlockedCommonVerifyItem verifyItem = new GeneDataBaseUnBlockedCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    protected IVerifyManager getBlockedVerifyManager(Context ctx, GeneTreeBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        GeneDataBaseBlockedCommonVerifyItem verifyItem = new GeneDataBaseBlockedCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    public String getTableName(Context ctx) {
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(this.getBOSType());
        return entity.getTable().getName();
    }

    @Override
    protected void _blocked(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        GeneTreeBaseInfo info = (GeneTreeBaseInfo)this.getValue(ctx, pk);
        IVerifyManager verifymanager = this.getBlockedVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FBlockedStatus=? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), pk.toString()});
    }

    @Override
    protected void _unBlocked(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        GeneTreeBaseInfo info = (GeneTreeBaseInfo)this.getValue(ctx, pk);
        IVerifyManager verifymanager = this.getUnBlockedVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FBlockedStatus=?   where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(1), pk.toString()});
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        GeneTreeBaseInfo info = (GeneTreeBaseInfo)this.getValue(ctx, pk);
        IVerifyManager verifymanager = this.getCancelVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FDeletedStatus=? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), pk.toString()});
    }

    @Override
    protected void _cancelCancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        GeneTreeBaseInfo info = (GeneTreeBaseInfo)this.getValue(ctx, pk);
        IVerifyManager verifymanager = this.getCancelCancelVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FDeletedStatus=?   where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(1), pk.toString()});
    }

    protected IVerifyManager getCancelCancelVerifyManager(Context ctx, GeneTreeBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        GeneDataBaseCancelCancelCommonVerifyItem verifyItem = new GeneDataBaseCancelCancelCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    protected IVerifyManager getCancelVerifyManager(Context ctx, GeneTreeBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        GeneDataBaseCancelCommonVerifyItem verifyItem = new GeneDataBaseCancelCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    @Override
    public FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return super.getFilterForDefaultCU(ctx, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            super.audit(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            super.unAudit(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            super.cancel(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelCancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            super.cancelCancel(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blocked(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            super.blocked(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unBlocked(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            super.unBlocked(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            super.delete(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    public void mutexRequest(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean b = MutexServiceControlFactory.getLocalInstance((Context)ctx).requestObjIDForUpdate(pk.toString());
        if (!b) {
            throw new EASBizException(new NumericExceptionSubItem("100", ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request", (Locale)ctx.getLocale())));
        }
    }

    @Override
    protected void _logAddnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    public synchronized IServerActionManager getServerActionManager(Context ctx) throws BOSException {
        if (this.serverActionManager == null) {
            this.serverActionManager = new ServerActionManager();
            this.regesterServerAction(ctx, this.serverActionManager);
        }
        return this.serverActionManager;
    }

    protected void regesterServerAction(Context ctx, IServerActionManager serverActionManager) throws BOSException {
        serverActionManager.addServerAction(new CascadeDeleteDataBaseServerAction());
    }

    protected void fireServerAction(Context ctx, Object model, String eventName, Object[] args) throws EASBizException, BOSException {
        ServerEvent event = new ServerEvent();
        event.setEventName(eventName);
        event.setSrcObject(model);
        event.setParams(args);
        this.getServerActionManager(ctx).fireServerAction(ctx, event);
    }
}

