/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.core.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.impl.SQLGeneratorPub;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.framework.IResultSetTableGetterFacade;
import com.kingdee.eas.basedata.framework.ResultSetTableGetterFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.util.TODOException;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GeneVirtualModeQueryHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.common.core.app.util.GeneVirtualModeQueryHelper");
    private BOSObjectType bosType = null;
    private String[] selectorItemName = new String[]{"id", "number", "name"};

    public GeneVirtualModeQueryHelper(BOSObjectType bosType, String[] selectorItemName) {
        this.bosType = bosType;
        this.selectorItemName = selectorItemName;
    }

    public GeneVirtualModeQueryHelper(BOSObjectType bosType) {
        this.bosType = bosType;
    }

    public List getGeneDataCollection(Context ctx, EntityViewInfo viewInfo, int start, int length) throws BOSException, EASBizException {
        try {
            if (viewInfo == null) {
                return null;
            }
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo bo = loader.getEntity(this.bosType);
            ArrayList<WrapProperty> fieldList = new ArrayList<WrapProperty>();
            HashMap relatedBoMap = new HashMap();
            Arrays.sort(this.selectorItemName, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
            SelectorItemCollection selItems = new SelectorItemCollection();
            PropertyCollection props = bo.getInheritedPropertiesRuntime();
            int n = props.size();
            block3: for (int i = 0; i < n; ++i) {
                PropertyInfo parentProp = props.get(i);
                if (parentProp instanceof OwnPropertyInfo) {
                    if (viewInfo.getSelector() != null) {
                        SelectorItemInfo selectorInfo = null;
                        Object propInfo = null;
                        for (int j = 0; j < viewInfo.getSelector().size(); ++j) {
                            selectorInfo = viewInfo.getSelector().get(j);
                            if (!selectorInfo.getPropertyName().equals(parentProp.getName())) continue;
                            selItems.add(new SelectorItemInfo(parentProp.getName(), parentProp.getName()));
                            fieldList.add(new WrapProperty(null, parentProp, null, parentProp.getMappingField() == null ? 1 : parentProp.getMappingField().getSQLType()));
                            continue block3;
                        }
                        continue;
                    }
                    selItems.add(new SelectorItemInfo(parentProp.getName(), parentProp.getName()));
                    fieldList.add(new WrapProperty(null, parentProp, null, parentProp.getMappingField() == null ? 1 : parentProp.getMappingField().getSQLType()));
                    continue;
                }
                if (!(parentProp instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)parentProp;
                EntityObjectInfo childBo = linkPropertyInfo.getRelationship().getSupplierObject();
                PropertyCollection props1 = childBo.getInheritedPropertiesRuntime();
                block5: for (int j = 0; j < props1.size(); ++j) {
                    PropertyInfo childProp = props1.get(j);
                    if (Arrays.binarySearch(this.selectorItemName, childProp.getName()) <= -1) continue;
                    if (viewInfo.getSelector() != null) {
                        SelectorItemInfo selectorInfo = null;
                        Object propInfo = null;
                        for (int k = 0; k < viewInfo.getSelector().size(); ++k) {
                            selectorInfo = viewInfo.getSelector().get(k);
                            if (!selectorInfo.getPropertyName().equals(parentProp.getName() + "." + this.selectorItemName[0]) && !selectorInfo.getPropertyName().equals(parentProp.getName() + "." + this.selectorItemName[1]) && !selectorInfo.getPropertyName().equals(parentProp.getName() + "." + this.selectorItemName[2])) continue;
                            selItems.add(new SelectorItemInfo(parentProp.getName() + "." + childProp.getName(), parentProp.getName() + "." + childProp.getName()));
                            fieldList.add(new WrapProperty((PropertyInfo)linkPropertyInfo, childProp, childBo, parentProp.getMappingField() == null ? 1 : parentProp.getMappingField().getSQLType()));
                            continue block5;
                        }
                        continue;
                    }
                    selItems.add(new SelectorItemInfo(parentProp.getName() + "." + childProp.getName(), parentProp.getName() + "." + childProp.getName()));
                    fieldList.add(new WrapProperty((PropertyInfo)linkPropertyInfo, childProp, childBo, parentProp.getMappingField() == null ? 1 : parentProp.getMappingField().getSQLType()));
                }
            }
            viewInfo.setSelector(selItems);
            String sql = SQLGeneratorPub.getSQLByEntityView((EntityObjectInfo)bo, (EntityViewInfo)viewInfo, (Context)ctx);
            Map alianMap = SQLGeneratorPub.getAliasMapping();
            IResultSetTableGetterFacade rstgf = ResultSetTableGetterFacadeFactory.getLocalInstance((Context)ctx);
            RptRowSet rowset = rstgf.getResultSetTable(sql, start, length);
            IObjectCollection collection = this.populateCollection(rowset, bo, fieldList, alianMap, relatedBoMap);
            ArrayList<Integer> l = new ArrayList<Integer>();
            l.add(new Integer(rowset.getVirtualRowCount()));
            l.add((Integer)collection);
            return l;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private IObjectCollection populateCollection(RptRowSet rowSet, EntityObjectInfo bo, List fieldList, Map alianMap, Map relatedBoMap) throws BOSException {
        try {
            Class<?> class1 = Class.forName(bo.getObjectCollectionClass());
            IObjectCollection collection = (IObjectCollection)class1.newInstance();
            while (rowSet.next()) {
                CoreBaseInfo info = this.instanceByEntity(bo);
                for (WrapProperty wrapProperty : fieldList) {
                    if (wrapProperty.getParent() == null && wrapProperty.getChildBo() == null) {
                        Object sqlValue = GeneVirtualModeQueryHelper.getDataFromDr(wrapProperty.getSqlType(), rowSet, wrapProperty.getChild().getName());
                        Object javaValue = GeneVirtualModeQueryHelper.ConvertSQLTypeData2Java((PropertyInfo)((OwnPropertyInfo)wrapProperty.getChild()), sqlValue);
                        info.put(wrapProperty.getChild().getName(), javaValue);
                        continue;
                    }
                    LinkPropertyInfo parent = (LinkPropertyInfo)wrapProperty.getParent();
                    if (info.get(parent.getName()) != null && !(info.get(parent.getName()) instanceof CoreBaseInfo)) continue;
                    CoreBaseInfo linkObj = (CoreBaseInfo)info.get(parent.getName());
                    if (linkObj == null) {
                        linkObj = this.instanceByEntity(wrapProperty.getChildBo());
                    }
                    Object sqlValue = GeneVirtualModeQueryHelper.getDataFromDr(wrapProperty.getSqlType(), rowSet, this.getTblAlais(alianMap, parent.getName()) + "." + wrapProperty.getChild().getName());
                    Object javaValue = GeneVirtualModeQueryHelper.ConvertSQLTypeData2Java((PropertyInfo)((OwnPropertyInfo)wrapProperty.getChild()), sqlValue);
                    linkObj.put(wrapProperty.getChild().getName(), javaValue);
                    info.put(parent.getName(), (Object)linkObj);
                }
                collection.addObject((IObjectValue)info);
            }
            return collection;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getTblAlais(Map alianMap, String parentProp) {
        for (String key : alianMap.keySet()) {
            String alian = (String)alianMap.get(key);
            if (!parentProp.equals(alian)) continue;
            return key;
        }
        return "";
    }

    private CoreBaseInfo instanceByEntity(EntityObjectInfo bo) throws BOSException {
        try {
            String className = bo.getObjectValueClass();
            Class<?> class1 = Class.forName(className);
            Object obj = class1.newInstance();
            return (CoreBaseInfo)obj;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static Object getDataFromDr(int dataType, RptRowSet rset, String index) throws SQLException {
        Object data = null;
        try {
            switch (dataType) {
                case 1: 
                case 12: {
                    data = rset.getString(index);
                    break;
                }
                case -7: {
                    boolean b = rset.getInt(index) == 1;
                    data = b;
                    break;
                }
                case 4: {
                    data = new Integer(rset.getInt(index));
                    break;
                }
                case 3: {
                    data = rset.getBigDecimal(index);
                    break;
                }
                case 91: {
                    data = (Date)rset.getObject(index);
                    break;
                }
                case 92: {
                    data = (Time)rset.getObject(index);
                    break;
                }
                case 93: {
                    data = (Timestamp)rset.getObject(index);
                    break;
                }
                case -5: {
                    data = new Long(rset.getLong(index));
                    break;
                }
                case 2: {
                    data = rset.getBigDecimal(index);
                    break;
                }
                case 6: 
                case 8: {
                    data = new Double(rset.getDouble(index));
                    break;
                }
                case 2004: {
                    break;
                }
                case 2005: {
                    data = rset.getString(index);
                }
            }
            return data;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object ConvertSQLTypeData2Java(PropertyInfo propInfo, Object sqlVal) throws BOSException {
        Enum enumVal;
        Class<?> type;
        Object val = sqlVal;
        if (!(propInfo instanceof OwnPropertyInfo)) throw new TODOException();
        OwnPropertyInfo ownPropInfo = (OwnPropertyInfo)propInfo;
        DataType dataType = ownPropInfo.getDataType();
        if (sqlVal == null) {
            return null;
        }
        if (dataType.equals((Object)DataType.BOSUUID)) {
            if (!(sqlVal instanceof String)) throw new TODOException();
            BOSUuid boId = BOSUuid.read((String)((String)sqlVal));
            return boId;
        }
        if (dataType.equals((Object)DataType.INTEGER)) {
            if (!(sqlVal instanceof Integer)) throw new TODOException();
            return sqlVal;
        }
        if (dataType.equals((Object)DataType.STRING)) {
            if (!(sqlVal instanceof String)) throw new TODOException(sqlVal.getClass().toString());
            return sqlVal;
        }
        if (dataType.equals((Object)DataType.DATE)) {
            if (sqlVal instanceof java.util.Date) {
                java.util.Date dataVal = (java.util.Date)sqlVal;
                long time = dataVal.getTime();
                long tuncatedTime = time / 1000L * 1000L;
                return new Timestamp(tuncatedTime);
            }
            if (!(sqlVal instanceof Timestamp)) return TypeConversionUtils.objToDate((Object)sqlVal);
            Timestamp timestampVal = (Timestamp)sqlVal;
            long time = timestampVal.getTime();
            long tuncatedTime = time / 1000L * 1000L;
            timestampVal = new Timestamp(tuncatedTime);
            return timestampVal;
        }
        if (dataType.equals((Object)DataType.BOOLEAN)) {
            boolean booleanVal = TypeConversionUtils.objToBoolean((Object)sqlVal);
            if (!(sqlVal instanceof Boolean)) return booleanVal ? Boolean.TRUE : Boolean.FALSE;
            return sqlVal;
        }
        if (dataType.equals((Object)DataType.DECIMAL)) {
            if (!(sqlVal instanceof BigDecimal)) return TypeConversionUtils.objToBigDecimal((Object)sqlVal);
            return sqlVal;
        }
        if (dataType.equals((Object)DataType.TIMESTAMP)) {
            if (!(sqlVal instanceof Timestamp)) return TypeConversionUtils.objToTimestamp((Object)sqlVal);
            return sqlVal;
        }
        if (dataType.equals((Object)DataType.BYTEARRAY)) {
            if (!(sqlVal instanceof byte[])) return TypeConversionUtils.objToBytes((Object)sqlVal);
            return sqlVal;
        }
        if (dataType.equals((Object)DataType.DOUBLE)) {
            if (sqlVal instanceof Double) {
                return sqlVal;
            }
            double doubleVal = TypeConversionUtils.objToDouble((Object)sqlVal);
            return new Double(doubleVal);
        }
        if (dataType.equals((Object)DataType.FLOAT)) {
            if (sqlVal instanceof Float) {
                return sqlVal;
            }
            float floatVal = TypeConversionUtils.objToFloat((Object)sqlVal);
            return new Float(floatVal);
        }
        if (!dataType.equals((Object)DataType.ENUM)) throw new TODOException(dataType.getName());
        String metaDataRef = ownPropInfo.getMetaDataRef();
        try {
            type = Class.forName(metaDataRef);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (IntEnum.class.isAssignableFrom(type)) {
            int intVal = TypeConversionUtils.objToInt((Object)sqlVal);
            try {
                Method method = type.getMethod("getEnum", Integer.TYPE);
                enumVal = (Enum)method.invoke(null, new Integer(intVal));
                return enumVal;
            }
            catch (SecurityException e) {
                logger.error((Object)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error((Object)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        if (!StringEnum.class.isAssignableFrom(type)) throw new TODOException();
        String strVal = TypeConversionUtils.objToString((Object)sqlVal);
        try {
            Method method = type.getMethod("getEnum", String.class);
            enumVal = (Enum)method.invoke(null, strVal);
            return enumVal;
        }
        catch (SecurityException e) {
            logger.error((Object)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private class WrapProperty {
        private PropertyInfo parent = null;
        private PropertyInfo child = null;
        private EntityObjectInfo childBo = null;
        private int sqlType = 1;

        public WrapProperty(PropertyInfo parent, PropertyInfo child, EntityObjectInfo bo, int sqlType) {
            this.parent = parent;
            this.child = child;
            this.childBo = bo;
            this.sqlType = sqlType;
        }

        public PropertyInfo getParent() {
            return this.parent;
        }

        public void setParent(PropertyInfo parent) {
            this.parent = parent;
        }

        public PropertyInfo getChild() {
            return this.child;
        }

        public void setChild(PropertyInfo child) {
            this.child = child;
        }

        public EntityObjectInfo getChildBo() {
            return this.childBo;
        }

        public void setChildBo(EntityObjectInfo childBo) {
            this.childBo = childBo;
        }

        public int getSqlType() {
            return this.sqlType;
        }

        public void setSqlType(int sqlType) {
            this.sqlType = sqlType;
        }
    }
}

