/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.core.filter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.filter.FilterElement;
import com.kingdee.eas.eqm.common.core.filter.IFilterElement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class CompositeFilterElement
extends FilterElement {
    private static final Logger logger = Logger.getLogger(CompositeFilterElement.class);
    private List elementMap = new ArrayList();
    private String logic = "and";

    public CompositeFilterElement(String logic) {
        this.logic = logic;
    }

    public CompositeFilterElement() {
    }

    public void add(IFilterElement element) {
        this.elementMap.add(element);
        this.getVerifyManager().addChildrenManager(element.getVerifyManager());
    }

    public int size() {
        return this.elementMap.size();
    }

    public IFilterElement get(int i) {
        return (IFilterElement)this.elementMap.get(i);
    }

    @Override
    public FilterInfo getFilterInfo() {
        IFilterElement element = null;
        FilterInfo result = null;
        FilterInfo filterInfo = null;
        for (int i = 0; i < this.size(); ++i) {
            element = this.get(i);
            if (!element.isEnable() || (filterInfo = element.getFilterInfo()) == null || filterInfo.getFilterItems().size() <= 0) continue;
            if (result == null) {
                result = filterInfo;
                continue;
            }
            try {
                result.mergeFilter(filterInfo, this.logic);
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        return result;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).clear();
        }
    }

    public void addCustomerParam(CustomerParams cp) {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setElementValue(cp);
        }
    }

    protected boolean verify() throws EASBizException, BOSException {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).getVerifyManager().verify()) continue;
            return false;
        }
        return true;
    }

    protected void clear(Object obj) {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).clear();
        }
    }

    @Override
    public String getValue() {
        return null;
    }

    @Override
    public CustomerParams getElementValue() {
        CustomerParams rst = new CustomerParams();
        for (int i = 0; i < this.size(); ++i) {
            CustomerParams ev = this.get(i).getElementValue();
            rst.putMe(Integer.toString(i), ev);
        }
        return rst;
    }

    @Override
    public void setElementValue(CustomerParams cp) {
        for (int i = 0; i < this.size(); ++i) {
            CustomerParams ev = cp.getMe(Integer.toString(i));
            this.get(i).setElementValue(ev);
        }
    }
}

