/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class EQMBaseDataTransmission
extends AbstractDataTransmission {
    public static final int MaxLength_80 = 80;
    public static final int MaxLength_100 = 100;
    public static final int MaxLength_255 = 255;
    public static final String PLANNEDORDER_BILLTYPENO = "660";
    protected Map cache_info = new HashMap();
    protected Map cache_entryInfo = new HashMap();
    protected Map cache_storageInfo = new HashMap();
    protected Set _cacheAuthorizedOrgUnits = null;
    private static final String RESOURCE_PATH = "com.kingdee.eas.eqm.common.core.GeneResource";

    protected StorageOrgUnitInfo getStorageOrgUnitInfoFromNumber(Context ctx, String storageOrgNumber) throws BOSException {
        if (storageOrgNumber == null || storageOrgNumber.trim().length() == 0) {
            return null;
        }
        String ckey = storageOrgNumber;
        if (this.cache_storageInfo.get(ckey) != null) {
            return (StorageOrgUnitInfo)this.cache_storageInfo.get(ckey);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("CU.*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)storageOrgNumber, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        StorageOrgUnitInfo info = null;
        if (storageOrgNumber != null && storageOrgNumber.trim().length() > 0) {
            IStorageOrgUnit iStorageOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
            StorageOrgUnitCollection collection = iStorageOrgUnit.getStorageOrgUnitCollection(viewInfo);
            if (collection == null || collection.size() != 1) {
                throw new BOSException(MessageFormat.format(this.getMsg("errStorageNumber"), storageOrgNumber));
            }
            info = collection.get(0);
            this.cache_storageInfo.put(ckey, info);
        }
        return info;
    }

    protected void putTable(Hashtable htable, Object key, Object value) {
        if (value != null) {
            htable.put(key, value);
        }
    }

    protected String getDataString(Hashtable hsData, String key) {
        DataToken dataToken = (DataToken)hsData.get(key);
        if (dataToken == null) {
            return null;
        }
        String number = (String)dataToken.data;
        return number;
    }

    public Map getCache() {
        return this.cache_info;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return super.getExportFilterForQuery(ctx);
    }

    public String getExportQueryInfo(Context ctx) {
        return null;
    }

    protected boolean isAuthorizedOrgUnit(Context ctx, String storageOrgNumber) throws TaskExternalException {
        if (this._cacheAuthorizedOrgUnits == null) {
            try {
                OrgUnitInfo[] orgUnits = DataImportEqmTools.getAuthorizedBizOrgUnits(ctx, OrgType.Storage, this.getImportPermItemName());
                if (orgUnits != null && orgUnits.length > 0) {
                    this._cacheAuthorizedOrgUnits = new HashSet();
                    for (int i = 0; i < orgUnits.length; ++i) {
                        this._cacheAuthorizedOrgUnits.add(orgUnits[i].getNumber());
                    }
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        if (this._cacheAuthorizedOrgUnits == null || !this._cacheAuthorizedOrgUnits.contains(storageOrgNumber)) {
            throw new TaskExternalException(this.getMsg("notUserImportPermissionOrg"));
        }
        return true;
    }

    protected String getImportPermItemName() {
        return null;
    }

    protected String getMsg(String key) {
        return ResourceBase.getString((String)RESOURCE_PATH, (String)key, (Locale)ContextUtils.getLocaleFromEnv());
    }

    protected String getPropertyAlias(Context ctx, AbstractObjectValue dataBaseInfo, String propertyName) {
        return DataImportEqmTools.getPropertyAlias(ctx, dataBaseInfo, propertyName);
    }

    protected boolean isIntFormat(String str) {
        boolean isNumber = true;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') continue;
            isNumber = false;
            break;
        }
        return isNumber;
    }

    protected int getInt(Context ctx, AbstractObjectValue dataBaseInfo, String value, String propertyName) throws TaskExternalException {
        boolean isNumber = this.isIntFormat(value);
        int b = 0;
        if (isNumber) {
            try {
                b = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new TaskExternalException(MessageFormat.format(this.getMsg("INTEGER_VALUE_INVALID"), this.getPropertyAlias(ctx, dataBaseInfo, propertyName)));
            }
        } else {
            throw new TaskExternalException(MessageFormat.format(this.getMsg("IS_NOT_POSITIVEINTEGER"), this.getPropertyAlias(ctx, dataBaseInfo, propertyName)));
        }
        return b;
    }

    public CoreBaseInfo getInfoByNumber(Context ctx, ICoreBase biz, String number, String storageOrgNumber, EntityViewInfo ev) throws BOSException {
        if (biz == null) {
            return null;
        }
        if (number == null || number.trim().length() == 0) {
            return null;
        }
        String ckey = biz.getType() + number + storageOrgNumber;
        if (this.cache_info.get(ckey) != null) {
            return (CoreBaseInfo)this.cache_info.get(ckey);
        }
        if (ev == null) {
            ev = this.getDefaultView(number, storageOrgNumber);
        }
        CoreBaseCollection coll = biz.getCollection(ev);
        CoreBaseInfo voInfo = null;
        if (coll == null || coll.size() == 0) {
            BOSObjectType type = biz.getType();
            EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(type);
            throw new BOSException(MessageFormat.format(this.getMsg("objectIsNull"), number, entity.getAlias()));
        }
        if (coll.size() == 1) {
            voInfo = coll.get(0);
        }
        if (coll.size() > 1) {
            BOSObjectType type = biz.getType();
            EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(type);
            throw new BOSException(entity.getAlias() + MessageFormat.format(this.getMsg("dupliateNumber"), number, entity.getAlias()));
        }
        this.cache_info.put(ckey, voInfo);
        return voInfo;
    }

    public IObjectValue getInfoByNumber(Context ctx, BOSObjectType bostype, String number, String storageOrgNumber, EntityViewInfo ev) throws BOSException, EASBizException {
        if (bostype == null) {
            return null;
        }
        if (number == null || number.trim().length() == 0) {
            return null;
        }
        String ckey = bostype + number + storageOrgNumber;
        if (this.cache_info.get(ckey) != null) {
            return (CoreBaseInfo)this.cache_info.get(ckey);
        }
        if (ev == null) {
            ev = this.getDefaultView(number, storageOrgNumber);
        }
        IObjectCollection coll = BusinessProcessUtil.getCollectionByBosType((Context)ctx, (String)bostype.toString(), (EntityViewInfo)ev, (FilterItemInfo[][])null, null);
        IObjectValue voInfo = null;
        if (coll == null || coll.size() == 0) {
            BOSObjectType type = bostype;
            EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(type);
            throw new BOSException(MessageFormat.format(this.getMsg("objectIsNull"), number, entity.getAlias()));
        }
        if (coll.size() == 1) {
            voInfo = coll.getObject(0);
        }
        if (coll.size() > 1) {
            BOSObjectType type = bostype;
            EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(type);
            throw new BOSException(entity.getAlias() + MessageFormat.format(this.getMsg("dupliateNumber"), number, entity.getAlias()));
        }
        this.cache_info.put(ckey, voInfo);
        return voInfo;
    }

    protected EntityViewInfo getDefaultView(String number, String storageOrgNumber) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        if (storageOrgNumber != null) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.number", (Object)storageOrgNumber));
        }
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    public CoreBaseInfo getEntryInfoByNumber(Context ctx, ICoreBase biz, String headNumber, String storageOrgNumber, String entryNumber, EntityViewInfo ev) throws BOSException {
        if (biz == null) {
            return null;
        }
        if (headNumber == null || headNumber.trim().length() == 0) {
            return null;
        }
        if (entryNumber == null || entryNumber.trim().length() == 0) {
            return null;
        }
        String ckey = biz.getType() + headNumber + storageOrgNumber + entryNumber.toString();
        if (this.cache_entryInfo.get(ckey) != null) {
            return (CoreBaseInfo)this.cache_entryInfo.get(ckey);
        }
        if (ev == null) {
            ev = this.getDefaultEntrytView(headNumber, storageOrgNumber, entryNumber);
        }
        CoreBaseCollection coll = biz.getCollection(ev);
        CoreBaseInfo voInfo = null;
        if (coll != null && coll.size() > 0) {
            voInfo = coll.get(0);
            this.cache_entryInfo.put(ckey, voInfo);
        }
        return voInfo;
    }

    protected EntityViewInfo getDefaultEntrytView(String headNumber, String storageOrgNumber, String entryNumber) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)entryNumber));
        filter.getFilterItems().add(new FilterItemInfo("parent.number", (Object)headNumber));
        if (storageOrgNumber != null) {
            filter.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit.number", (Object)storageOrgNumber));
        }
        viewInfo.setFilter(filter);
        return viewInfo;
    }
}

