/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.bi.subject;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.fi.bi.subject.AbstractAccountBalanceAnalysisFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AccountBalanceAnalysisFacadeControllerBean
extends AbstractAccountBalanceAnalysisFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.bi.subject.AccountBalanceAnalysisFacadeControllerBean");

    protected void _updatePBDimension(Context ctx) throws BOSException {
        super._updatePBDimension(ctx);
        String yearRes = ResourceBase.getString((String)"com.kingdee.eas.fi.bi.BIAutoGenerateResource", (String)"1_Year", (Locale)ctx.getLocale());
        String periodRes = ResourceBase.getString((String)"com.kingdee.eas.fi.bi.BIAutoGenerateResource", (String)"0_Period", (Locale)ctx.getLocale());
        String delPeriod = "truncate table dw_dim_bd_period";
        StringBuffer inPeriod = new StringBuffer();
        inPeriod.append("INSERT INTO DW_Dim_BD_Period(FID,FNUMBER,FYEAR,FPERIOD,FQUARTER,FBEGINDATE,FENDDATE,FIsAdjustPeriod,FTypeID,FDESCRIPTION_L2)");
        inPeriod.append("\n  SELECT FID,FNUMBER,FPERIODYEAR,FPERIODNUMBER,FPERIODQUARTER,FBeginDate,FENDDATE,FIsAdjustPeriod,FTypeID");
        inPeriod.append(",CONCAT(CONCAT(TOCHAR(FPERIODYEAR),CONCAT('" + yearRes + "',TOCHAR(FPERIODNUMBER))),'" + periodRes + "') FROM T_BD_PERIOD");
        String delFinance = "truncate table dw_dim_finance";
        StringBuffer inFinance = new StringBuffer();
        inFinance.append(" insert into dw_dim_finance(fid,fname_l1,fname_l2,fname_l3,fnumber,flongnumber,fparentid,fisstart,fmainorgid,faccountschemeid,fisousealup)\r\n");
        inFinance.append(" (\r\n");
        inFinance.append(" select c.fid,c.fname_l1,c.fname_l2,c.fname_l3,c.fnumber,c.flongnumber,c.fparentid,c.fisstart,c.fmainorgid,c.faccountschemeid,fisousealup\r\n");
        inFinance.append(" from t_org_company c where c.fiscompanyorgunit=1\r\n");
        inFinance.append(" )\r\n");
        String delPLAccount = "truncate table dw_dim_placcount";
        StringBuffer inPLAccount = new StringBuffer();
        inPLAccount.append(" insert into dw_dim_placcount(fid,fname_l1,fname_l2,fname_l3,fnumber,fisleaf,flevel,fdc,flongnumber,fparentid,fcompanyid)\r\n");
        inPLAccount.append(" (\r\n");
        inPLAccount.append(" select av.fid,av.fname_l1,av.fname_l2,av.fname_l3,av.fnumber,av.fisleaf,av.flevel,av.fdc,av.flongnumber,av.fparentid,av.fcompanyid\r\n");
        inPLAccount.append(" from t_bd_accountview av\r\n");
        inPLAccount.append(" inner join t_bd_accounttype accounttype\r\n");
        inPLAccount.append(" on av.faccounttypeid=accounttype.fid\r\n");
        inPLAccount.append(" where accounttype.fproperty=4\r\n");
        inPLAccount.append(" )\r\n");
        String delScheme = "truncate table dw_dim_booksscheme";
        StringBuffer inScheme = new StringBuffer();
        inScheme.append(" insert into dw_dim_booksscheme\r\n");
        inScheme.append(" (\r\n");
        inScheme.append(" fid,fname_l1,fname_l2,fname_l3,fnumber,fdescription_l1,fdescription_l2,fdescription_l3,\r\n");
        inScheme.append(" fsimplename,fperiodtypeid,faccounttableid,fratetableid ,fcurrencyid,freportcurrencyid,\r\n");
        inScheme.append(" ftype,frptratetableid,fadjratetableid,fismaster,fislock,frule,fbooktype,fcontrolunitid\r\n");
        inScheme.append(" )\r\n");
        inScheme.append(" (\r\n");
        inScheme.append(" select fid,fname_l1,fname_l2,fname_l3,fnumber,fdescription_l1,fdescription_l2,fdescription_l3,\r\n");
        inScheme.append(" fsimplename,fperiodtypeid,faccounttableid,fratetableid ,fcurrencyid,freportcurrencyid,\r\n");
        inScheme.append(" ftype,frptratetableid,fadjratetableid,fismaster,fislock,frule,fbooktype,fcontrolunitid\r\n");
        inScheme.append(" from t_bks_acountscheme\r\n");
        inScheme.append(" )\r\n");
        DbUtil.execute((Context)ctx, (String)delPeriod);
        DbUtil.execute((Context)ctx, (String)inPeriod.toString());
        DbUtil.execute((Context)ctx, (String)delFinance);
        DbUtil.execute((Context)ctx, (String)inFinance.toString());
        DbUtil.execute((Context)ctx, (String)delPLAccount);
        DbUtil.execute((Context)ctx, (String)inPLAccount.toString());
        DbUtil.execute((Context)ctx, (String)delScheme);
        DbUtil.execute((Context)ctx, (String)inScheme.toString());
    }

    protected void _updatePBFact(Context ctx) throws BOSException {
        super._updatePBFact(ctx);
        String sqlDeleteFact = "truncate table dw_fact_profitbalance";
        DbUtil.execute((Context)ctx, (String)sqlDeleteFact);
        this.insertProfitBalanceDataToFact(ctx);
        this.insertBalanceData(ctx);
        this.insertAsstActItem(ctx);
    }

    protected void _updateBooksDiffFact(Context ctx) throws BOSException {
        super._updateBooksDiffFact(ctx);
        String sqlDeleteFact = "truncate table dw_fact_booksdiff";
        DbUtil.execute((Context)ctx, (String)sqlDeleteFact);
        this.insertBooksDiffDataToFact(ctx);
    }

    private void insertBooksDiffDataToFact(Context ctx) throws BOSException {
        this.insertBooksDiffPeriodData(ctx);
        this.insertBooksDiffQuarterData(ctx);
        this.insertBooksDiffSemiYearData(ctx);
        this.insertBooksDiffYearData(ctx);
    }

    private void insertBooksDiffPeriodData(Context ctx) throws BOSException {
        this.insertAllPeriodData(ctx);
        this.recalculateOverCurrentPeriodData(ctx);
        this.deleteInitOverCurrentPeriodData(ctx);
        this.insertOverCurrentPeriodLostData(ctx);
    }

    private void insertOverCurrentPeriodLostData(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("-----\u5982\u5f53\u524d\u671f\u95f4\u4e3a200705\u4e14\u6709\u8bb0\u5f55,200708\u67d0\u4e2a\u79d1\u76ee\u6709\u53d1\u751f\u989d,\r\n");
        sql.append("-----\u9700\u8981\u5224\u65ad\u5176\u4ed6\u79d1\u76ee200706,200707,200708\u6709\u6ca1\u6709\u8bb0\u5f55,\u5982\u679c\u6ca1\u6709\u5219\u9700\u8981\u63d2\u5165\r\n");
        sql.append("insert into dw_fact_booksdiff\r\n");
        sql.append("(fcompanyid,faccountproperty,fcurrencyid,fperiodyear,fperiodsemiyear,fperiodquarter,\r\n");
        sql.append(" fperiodnumber,fbooksschemeid,fperiodtype,fyearbegindebit,fyearbegincredit,\r\n");
        sql.append(" fenddebit,fendcredit,fyeardebit,fyearcredit,fdebit,fcredit,\r\n");
        sql.append(" fiscurrentperiod,fisovercurrentyear,fisdeleted\r\n");
        sql.append(")\r\n");
        sql.append("(\r\n");
        sql.append("  select tb.fcompanyid,tb.faccountproperty,tb.fcurrencyid,\r\n");
        sql.append("         ta.fperiodyear,\r\n");
        sql.append("         case when ta.fperiodquarter>2 then 2 else 1 end fperiodsemiyear,\r\n");
        sql.append("         ta.fperiodquarter,ta.fperiodnumber,\r\n");
        sql.append("         tb.fbooksschemeid,tb.fperiodtype,tb.fyearbegindebit,tb.fyearbegincredit,\r\n");
        sql.append("         tb.fenddebit,tb.fendcredit,\r\n");
        sql.append("         -----\u5982\u679c\u8de8\u5e74,\u5219\u672c\u5e74\u7d2f\u8ba1\u4e3a0\r\n");
        sql.append("         case when ta.fperiodyear>tb.fperiodyear then 0 else tb.fyeardebit end fyeardebit,\r\n");
        sql.append("         case when ta.fperiodyear>tb.fperiodyear then 0 else tb.fyearcredit end fyearcredit,\r\n");
        sql.append("         tb.fdebit, tb.fcredit,1 fiscurrentperiod,\r\n");
        sql.append("         case when ta.fperiodyear>tb.fperiodyear then 1 else 0 end fisovercurrentyear,\r\n");
        sql.append("         0 fisdeleted from\r\n");
        sql.append("  (\r\n");
        sql.append("    -----\u627e\u51fa\u4ece\u5f53\u524d\u671f\u95f4(\u4e0d\u5305\u62ec)\u5230\u6700\u5927\u53d1\u751f\u989d\u671f\u95f4\u7684\u6240\u6709\u671f\u95f4\r\n");
        sql.append("    select ta.fcompanyid,ta.faccountproperty,ta.fcurrencyid,\r\n");
        sql.append("           ta.fperiodyear,ta.fperiodquarter,ta.fperiodnumber\r\n");
        sql.append("    from\r\n");
        sql.append("    (\r\n");
        sql.append("      select * from dw_fact_booksdiff where fiscurrentperiod=0\r\n");
        sql.append("    ) ta\r\n");
        sql.append("    inner join\r\n");
        sql.append("    (\r\n");
        sql.append("      select fcompanyid,faccountproperty,fcurrencyid,\r\n");
        sql.append("             max(fperiodyear*100+fperiodnumber) maxperiod\r\n");
        sql.append("      from dw_fact_booksdiff\r\n");
        sql.append("      group by fcompanyid,faccountproperty,fcurrencyid\r\n");
        sql.append("    ) tb\r\n");
        sql.append("    on ta.fcompanyid=tb.fcompanyid\r\n");
        sql.append("       and ta.faccountproperty=tb.faccountproperty\r\n");
        sql.append("       and ta.fcurrencyid=tb.fcurrencyid\r\n");
        sql.append("    inner join\r\n");
        sql.append("    (\r\n");
        sql.append("      select distinct fnumber from dw_dim_bd_period\r\n");
        sql.append("    ) tp on 1=1\r\n");
        sql.append("    where ta.fperiodyear*100+ta.fperiodnumber < maxperiod\r\n");
        sql.append("          and ta.fperiodyear*100+ta.fperiodnumber<tp.fnumber\r\n");
        sql.append("          and tp.fnumber<=tb.maxperiod\r\n");
        sql.append("  ) ta\r\n");
        sql.append("  inner join\r\n");
        sql.append("  (\r\n");
        sql.append("    select * from dw_fact_booksdiff where fiscurrentperiod=0\r\n");
        sql.append("  ) tb\r\n");
        sql.append("  on ta.fcompanyid=tb.fcompanyid\r\n");
        sql.append("     and ta.faccountproperty=tb.faccountproperty\r\n");
        sql.append("     and ta.fcurrencyid=tb.fcurrencyid\r\n");
        sql.append("  left join dw_fact_booksdiff tc\r\n");
        sql.append("  on ta.fcompanyid=tc.fcompanyid\r\n");
        sql.append("     and ta.faccountproperty=tc.faccountproperty\r\n");
        sql.append("     and ta.fcurrencyid=tc.fcurrencyid\r\n");
        sql.append("  where ta.fperiodyear*100+ta.fperiodnumber=tc.fperiodyear*100+tc.fperiodnumber\r\n");
        sql.append("        and tc.fcompanyid is null-----\u6ca1\u6709\u6570\u636e\u7684\u8bb0\u5f55\r\n");
        sql.append(")\r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void deleteInitOverCurrentPeriodData(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("-----\u5220\u9664\u5927\u4e8e\u5f53\u524d\u671f\u95f4\u7684\u6570\u636e\r\n");
        sql.append("delete from dw_fact_booksdiff where fisdeleted=1\r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void recalculateOverCurrentPeriodData(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("-----\u63d2\u5165\u91cd\u65b0\u8ba1\u7b97\u540e\u5927\u4e8e\u5f53\u524d\u671f\u95f4\u7684\u6570\u636e\r\n");
        sql.append("insert into dw_fact_booksdiff\r\n");
        sql.append("(fcompanyid,faccountproperty,fcurrencyid,fperiodyear,fperiodsemiyear,fperiodquarter,\r\n");
        sql.append(" fperiodnumber,fbooksschemeid,fperiodtype,fyearbegindebit,fyearbegincredit,\r\n");
        sql.append(" fenddebit,fendcredit,fyeardebit,fyearcredit,fdebit,fcredit,\r\n");
        sql.append(" fiscurrentperiod,fisovercurrentyear,fisdeleted\r\n");
        sql.append(")\r\n");
        sql.append("(\r\n");
        sql.append("  select fcompanyid,faccountproperty,fcurrencyid,fperiodyear,\r\n");
        sql.append("         fperiodsemiyear,fperiodquarter,fperiodnumber,\r\n");
        sql.append("         fbooksschemeid,1 fperiodtype,\r\n");
        sql.append("         -----\u8ba1\u7b97\u5e74\u521d\u6570\r\n");
        sql.append("         case when fenddebit-fendcredit+fyearcredit-fyeardebit>= 0\r\n");
        sql.append("               then fenddebit-fendcredit+fyearcredit-fyeardebit\r\n");
        sql.append("               else 0\r\n");
        sql.append("         end fyearbegindebit,\r\n");
        sql.append("         ----------\u8ba1\u7b97\u5e74\u521d\u6570\r\n");
        sql.append("         case when fenddebit-fendcredit+fyearcredit-fyeardebit<0\r\n");
        sql.append("               then (-1)*(fenddebit-fendcredit+fyearcredit-fyeardebit)\r\n");
        sql.append("               else 0\r\n");
        sql.append("         end fyearbegincredit,\r\n");
        sql.append("        fenddebit,fendcredit,fyeardebit,fyearcredit,fdebit,fcredit,\r\n");
        sql.append("        1 fiscurrentperiod,fisovercurrentyear,0 fisdeleted\r\n");
        sql.append("  from\r\n");
        sql.append("  (\r\n");
        sql.append("    select ta.fcompanyid,ta.fcurrencyid,ta.fperiodyear,ta.fperiodnumber,\r\n");
        sql.append("           ta.fperiodsemiyear,ta.fperiodquarter,ta.faccountproperty,\r\n");
        sql.append("           ta.fbooksschemeid,ta.fenddebit+tb.fenddebit fenddebit,\r\n");
        sql.append("           ta.fendcredit+tb.fendcredit fendcredit,\r\n");
        sql.append("           case when ta.fisovercurrentyear=1\r\n");
        sql.append("                then ta.fyeardebit\r\n");
        sql.append("                else ta.fyeardebit+tb.fyeardebit \r\n");
        sql.append("           end fyeardebit,\r\n");
        sql.append("           case when ta.fisovercurrentyear=1\r\n");
        sql.append("                then ta.fyearcredit\r\n");
        sql.append("                else ta.fyearcredit+tb.fyearcredit \r\n");
        sql.append("           end fyearcredit,ta.fenddebit fdebit,ta.fendcredit fcredit,\r\n");
        sql.append("           ta.fisovercurrentyear\r\n");
        sql.append("    from\r\n");
        sql.append("    (\r\n");
        sql.append("      select t1.fcompanyid,t1.fcurrencyid,t1.fperiodyear,t1.fperiodnumber,\r\n");
        sql.append("             t1.fperiodsemiyear,t1.fperiodquarter,t1.faccountproperty,\r\n");
        sql.append("             t1.fbooksschemeid,sum(t2.fdebit) fenddebit,sum(t2.fcredit) fendcredit,\r\n");
        sql.append("             sum(case when t1.fperiodyear=t2.fperiodyear then t2.fdebit else 0 end) fyeardebit,\r\n");
        sql.append("             sum(case when t1.fperiodyear=t2.fperiodyear then t2.fcredit else 0 end) fyearcredit,\r\n");
        sql.append("             t1.fisovercurrentyear\r\n");
        sql.append("      from\r\n");
        sql.append("      (select * from dw_fact_booksdiff where fiscurrentperiod=1) t1\r\n");
        sql.append("      left join\r\n");
        sql.append("      (select * from dw_fact_booksdiff where fiscurrentperiod=1) t2\r\n");
        sql.append("      on t1.fcompanyid=t2.fcompanyid\r\n");
        sql.append("         and t1.fcurrencyid=t2.fcurrencyid\r\n");
        sql.append("         and t1.faccountproperty=t2.faccountproperty\r\n");
        sql.append("      where t1.fperiodyear*100+t1.fperiodnumber>=t2.fperiodyear*100+t2.fperiodnumber\r\n");
        sql.append("      group by t1.fcompanyid,t1.faccountproperty,t1.fcurrencyid,\r\n");
        sql.append("               t1.fperiodyear,t1.fperiodsemiyear,t1.fperiodquarter,\r\n");
        sql.append("               t1.fperiodnumber,t1.fbooksschemeid,t1.fisovercurrentyear\r\n");
        sql.append("    ) ta\r\n");
        sql.append("    left join\r\n");
        sql.append("    (\r\n");
        sql.append("      select * from dw_fact_booksdiff where fiscurrentperiod=0\r\n");
        sql.append("    ) tb\r\n");
        sql.append("    on ta.fcompanyid=tb.fcompanyid\r\n");
        sql.append("       and ta.faccountproperty=tb.faccountproperty\r\n");
        sql.append("       and ta.fcurrencyid=tb.fcurrencyid\r\n");
        sql.append("  ) t\r\n");
        sql.append(")\r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void insertAllPeriodData(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into dw_fact_booksdiff\r\n");
        sql.append("(fcompanyid,faccountproperty,fcurrencyid,fperiodyear,fperiodsemiyear,fperiodquarter,\r\n");
        sql.append(" fperiodnumber,fbooksschemeid,fperiodtype,fyearbegindebit,fyearbegincredit,\r\n");
        sql.append(" fenddebit,fendcredit,fyeardebit,fyearcredit,fdebit,fcredit,\r\n");
        sql.append(" fiscurrentperiod,fisovercurrentyear,fisdeleted\r\n");
        sql.append(")\r\n");
        sql.append("(\r\n");
        sql.append("select t3.fcompanyid,t3.faccountproperty,t3.fcurrencyid,t3.fperiodyear,\r\n");
        sql.append("       case when t3.fperiodquarter>2 then 2 else 1 end fperiodsemiyear,\r\n");
        sql.append("       t3.fperiodquarter,t3.fperiodnumber,t3.faccountschemeid,t3.fperiodtype,\r\n");
        sql.append("       t3.fyearbegindebit,t3.fyearbegincredit,\r\n");
        sql.append("       t3.fenddebit,t3.fendcredit,t3.fyeardebit,t3.fyearcredit,\r\n");
        sql.append("       t3.fdebit,t3.fcredit,\r\n");
        sql.append("       case when t3.fperiodyear*100+t3.fperiodnumber=currentperiod.fnumber\r\n");
        sql.append("            then 0\r\n");
        sql.append("            when t3.fperiodyear*100+t3.fperiodnumber>currentperiod.fnumber\r\n");
        sql.append("            then 1\r\n");
        sql.append("            else -1\r\n");
        sql.append("       end fiscurrentperiod,\r\n");
        sql.append("       case when t3.fperiodyear>currentperiod.fperiodyear\r\n");
        sql.append("            then 1 else 0\r\n");
        sql.append("       end fisovercurrentyear,\r\n");
        sql.append("       case when t3.fperiodyear*100+t3.fperiodnumber>currentperiod.fnumber\r\n");
        sql.append("            then 1 else 0\r\n");
        sql.append("       end fisdeleted\r\n");
        sql.append("from\r\n");
        sql.append("(\r\n");
        sql.append("   select fcompanyid,faccountproperty,fcurrencyid,fperiodyear,fperiodquarter,\r\n");
        sql.append("          fperiodnumber,faccountschemeid,1 fperiodtype,\r\n");
        sql.append("          sum(fenddebit) fenddebit,sum(fendcredit) fendcredit,\r\n");
        sql.append("          sum(fyeardebit) fyeardebit,sum(fyearcredit) fyearcredit,\r\n");
        sql.append("          sum(fyearbegindebit) fyearbegindebit,\r\n");
        sql.append("          sum(fyearbegincredit) fyearbegincredit,\r\n");
        sql.append("          sum(fdebit) fdebit,sum(fcredit) fcredit\r\n");
        sql.append("   from\r\n");
        sql.append("   (\r\n");
        sql.append("       select fcompanyid,faccountproperty,fcurrencyid,fperiodyear,fperiodquarter,\r\n");
        sql.append("              fperiodnumber,faccountschemeid,fenddebit,fendcredit,fyeardebit,fyearcredit,\r\n");
        sql.append("              -----\u8ba1\u7b97\u5e74\u521d\u6570\r\n");
        sql.append("              case when fenddebit-fendcredit+fyearcredit-fyeardebit>= 0\r\n");
        sql.append("                   then fenddebit-fendcredit+fyearcredit-fyeardebit\r\n");
        sql.append("                   else 0\r\n");
        sql.append("              end fyearbegindebit,\r\n");
        sql.append("              ----------\u8ba1\u7b97\u5e74\u521d\u6570\r\n");
        sql.append("              case when fenddebit-fendcredit+fyearcredit-fyeardebit<0\r\n");
        sql.append("                   then (-1)*(fenddebit-fendcredit+fyearcredit-fyeardebit)\r\n");
        sql.append("                   else 0\r\n");
        sql.append("              end fyearbegincredit,fdebit,fcredit\r\n");
        sql.append("       from\r\n");
        sql.append("       (\r\n");
        sql.append("           select balance.forgunitid fcompanyid,accounttype.fproperty faccountproperty,\r\n");
        sql.append("                  balance.fcurrencyid,period.fperiodyear,period.fperiodquarter,\r\n");
        sql.append("                  period.fperiodnumber,company.faccountschemeid,\r\n");
        sql.append("      \t       -----\u5982\u679c\u671f\u672b\u4f59\u989d(\u635f\u76ca\u7c7b\u79d1\u76ee\u5254\u9664\u7ed3\u8f6c\u635f\u76ca)\u5927\u4e8e0\u5219\u8ba4\u4e3a\u662f\u501f\u65b9\r\n");
        sql.append("                  -----\u635f\u76ca\u7c7b\u79d1\u76ee\u5254\u9664\u7ed3\u8f6c\u635f\u76ca:\u671f\u672b\u6263\u9664\u672c\u5e74\u7d2f\u8ba1\u635f\u76ca\u6570\r\n");
        sql.append("                  case when accounttype.fproperty=4\r\n");
        sql.append("                       then\r\n");
        sql.append("                         case when statusctrl.fstartperiodid=balance.fperiodid\r\n");
        sql.append("                              then\r\n");
        sql.append("                                case when fendbalancelocal+(fmonthpnllocal-(fdebitlocal -fcreditlocal))>=0\r\n");
        sql.append("                                     then fendbalancelocal+(fmonthpnllocal-(fdebitlocal -fcreditlocal))\r\n");
        sql.append("                                     else 0\r\n");
        sql.append("                                end\r\n");
        sql.append("                              else\r\n");
        sql.append("                                case when fendbalancelocal+fyearpnllocal-(fdebitlocal -fcreditlocal)>=0\r\n");
        sql.append("                                     then fendbalancelocal+fyearpnllocal-(fdebitlocal -fcreditlocal)\r\n");
        sql.append("                                     else 0\r\n");
        sql.append("                                end\r\n");
        sql.append("                         end\r\n");
        sql.append("                       else\r\n");
        sql.append("                         case when balance.fendbalancelocal>=0 then balance.fendbalancelocal else 0 end\r\n");
        sql.append("                  end fenddebit,\r\n");
        sql.append("                  -----\u5982\u679c\u671f\u672b\u4f59\u989d(\u635f\u76ca\u7c7b\u79d1\u76ee\u5254\u9664\u7ed3\u8f6c\u635f\u76ca)\u5c0f\u4e8e0\u5219\u8ba4\u4e3a\u662f\u8d37\u65b9\r\n");
        sql.append("                  -----\u635f\u76ca\u7c7b\u79d1\u76ee\u5254\u9664\u7ed3\u8f6c\u635f\u76ca:\u671f\u672b\u6263\u9664\u672c\u5e74\u7d2f\u8ba1\u635f\u76ca\u6570\r\n");
        sql.append("                  case when accounttype.fproperty=4\r\n");
        sql.append("                       then\r\n");
        sql.append("                         case when statusctrl.fstartperiodid=balance.fperiodid\r\n");
        sql.append("                              then\r\n");
        sql.append("                                case when fendbalancelocal+(fmonthpnllocal-(fdebitlocal -fcreditlocal))<0\r\n");
        sql.append("                                     then (-1)*(fendbalancelocal+(fmonthpnllocal-(fdebitlocal -fcreditlocal)))\r\n");
        sql.append("                                     else 0\r\n");
        sql.append("                                end\r\n");
        sql.append("                              else\r\n");
        sql.append("                                case when fendbalancelocal+fyearpnllocal-(fdebitlocal -fcreditlocal)<0\r\n");
        sql.append("                                     then (-1)*(fendbalancelocal+fyearpnllocal-(fdebitlocal -fcreditlocal))\r\n");
        sql.append("                                     else 0\r\n");
        sql.append("                                end\r\n");
        sql.append("                         end\r\n");
        sql.append("                       else\r\n");
        sql.append("                         case when balance.fendbalancelocal<0 then (-1)*balance.fendbalancelocal else 0 end\r\n");
        sql.append("                  end fendcredit,\r\n");
        sql.append("                  -----\u672c\u5e74\u7d2f\u8ba1\uff08\u635f\u76ca\u7c7b\u79d1\u76ee\u5254\u9664\u7ed3\u8f6c\u635f\u76ca)\r\n");
        sql.append("                  case when accounttype.fproperty=4\r\n");
        sql.append("                       then\r\n");
        sql.append("                         case when statusctrl.fstartperiodid=balance.fperiodid\r\n");
        sql.append("                            then\r\n");
        sql.append("                              case when balance.fmonthpnllocal-(balance.fdebitlocal-balance.fcreditlocal)<0\r\n");
        sql.append("                                   then\r\n");
        sql.append("                                     balance.fmonthpnllocal-(balance.fdebitlocal-balance.fcreditlocal)\r\n");
        sql.append("                                     +balance.fyeardebitlocal\r\n");
        sql.append("                                   else balance.fyeardebitlocal\r\n");
        sql.append("                              end\r\n");
        sql.append("                            else\r\n");
        sql.append("                              case when balance.fyearpnllocal-(balance.fdebitlocal-balance.fcreditlocal) < 0\r\n");
        sql.append("                                   then balance.fyearpnllocal-(balance.fdebitlocal-balance.fcreditlocal)\r\n");
        sql.append("                                        +balance.fyeardebitlocal\r\n");
        sql.append("                                   else balance.fyeardebitlocal\r\n");
        sql.append("                              end\r\n");
        sql.append("                          end\r\n");
        sql.append("                        else\r\n");
        sql.append("                          balance.fyeardebitlocal\r\n");
        sql.append("                  end fyeardebit,\r\n");
        sql.append("                  -----\u672c\u5e74\u7d2f\u8ba1\uff08\u635f\u76ca\u7c7b\u79d1\u76ee\u5254\u9664\u7ed3\u8f6c\u635f\u76ca)\r\n");
        sql.append("                  case when accounttype.fproperty=4\r\n");
        sql.append("                       then\r\n");
        sql.append("                          case when statusctrl.fstartperiodid=balance.fperiodid\r\n");
        sql.append("                             then\r\n");
        sql.append("                               case when balance.fmonthpnllocal-(balance.fdebitlocal-balance.fcreditlocal) < 0\r\n");
        sql.append("                                    then balance.fyearcreditlocal\r\n");
        sql.append("                                    else balance.fyearcreditlocal-(balance.fmonthpnllocal-(balance.fdebitlocal\r\n");
        sql.append("                                         -balance.fcreditlocal))\r\n");
        sql.append("                               end\r\n");
        sql.append("                             else\r\n");
        sql.append("                               case when balance.fyearpnllocal-(balance.fdebitlocal-balance.fcreditlocal) < 0\r\n");
        sql.append("                                    then balance.fyearcreditlocal\r\n");
        sql.append("                                    else balance.fyearcreditlocal-(balance.fyearpnllocal-(balance.fdebitlocal\r\n");
        sql.append("                                         -balance.fcreditlocal))\r\n");
        sql.append("                               end\r\n");
        sql.append("                          end\r\n");
        sql.append("                       else balance.fyearcreditlocal\r\n");
        sql.append("                  end fyearcredit,\r\n");
        sql.append("                  balance.fyearpnllocal,balance.fcreditlocal fcredit,balance.fdebitlocal fdebit\r\n");
        sql.append("      \t\t from t_gl_accountbalance balance\r\n");
        sql.append("      \t\t inner join t_bd_period period on balance.fperiodid=period.fid\r\n");
        sql.append("      \t\t inner join t_bd_accountview accountview on balance.faccountid=accountview.fid\r\n");
        sql.append("      \t\t inner join t_bd_accounttype accounttype on accountview.faccounttypeid=accounttype.fid\r\n");
        sql.append("      \t\t inner join t_org_company company on balance.forgunitid=company.fid\r\n");
        sql.append("               left join t_bd_systemstatusctrol statusctrl on company.fid=statusctrl.fcompanyid\r\n");
        sql.append("               left join t_bd_systemstatus status on statusctrl.fsystemstatusid=status.fid\r\n");
        sql.append("               left join t_bd_period currentperiod on statusctrl.fcurrentperiodid=currentperiod.fid\r\n");
        sql.append("      \t\t where balance.fbaltype=5 and balance.forgunitid=accountview.fcompanyid\r\n");
        sql.append("                     -----\u5e01\u522b\u4e3a\u7efc\u5408\u672c\u4f4d\u5e01\u6216\u7efc\u5408\u62a5\u544a\u5e01\r\n");
        sql.append("                     and (balance.fcurrencyid='22222222-2222-2222-2222-222222222222DEB58FDC'\r\n");
        sql.append("      \t\t            or balance.fcurrencyid='11111111-1111-1111-1111-111111111111DEB58FDC')\r\n");
        sql.append("      \t\t       and accounttype.fproperty in(0,1,2,3,4)\r\n");
        sql.append("      \t\t       and status.fname=6\r\n");
        sql.append("                     -----\u7531\u4e8e\u8fd9\u91cc\u662f\u52a0\u603b,\u6240\u4ee5\u4e0d\u9700\u8981\u660e\u7ec6,\u76f4\u63a5\u53d6\u6700\u4e0a\u7ea7\u79d1\u76ee\r\n");
        sql.append("                     and accountview.flevel=1\r\n");
        sql.append("       ) t1\r\n");
        sql.append("   ) t2 group by fcompanyid,faccountproperty,fcurrencyid,fperiodyear,\r\n");
        sql.append("                fperiodquarter,fperiodnumber,faccountschemeid\r\n");
        sql.append(") t3\r\n");
        sql.append("inner join t_org_company company on t3.fcompanyid=company.fid\r\n");
        sql.append("left join t_bd_systemstatusctrol statusctrl on company.fid=statusctrl.fcompanyid\r\n");
        sql.append("left join t_bd_systemstatus status on statusctrl.fsystemstatusid=status.fid\r\n");
        sql.append("left join t_bd_period currentperiod on statusctrl.fcurrentperiodid=currentperiod.fid\r\n");
        sql.append("where status.fname=6\r\n");
        sql.append(")\r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void insertBooksDiffQuarterData(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into dw_fact_booksdiff\r\n");
        sql.append("(fcompanyid,faccountproperty,fcurrencyid,fperiodyear,fperiodsemiyear,fperiodquarter,\r\n");
        sql.append(" fperiodnumber,fbooksschemeid,fperiodtype,fyearbegindebit,fyearbegincredit,\r\n");
        sql.append(" fenddebit,fendcredit,fyeardebit,fyearcredit\r\n");
        sql.append(")\r\n");
        sql.append("(\r\n");
        sql.append(" select fcompanyid,faccountproperty,fcurrencyid,fperiodyear,fperiodsemiyear,fperiodquarter,\r\n");
        sql.append("        fperiodnumber,fbooksschemeid,2 fperiodtype,fyearbegindebit,fyearbegincredit,\r\n");
        sql.append("        fenddebit,fendcredit,fyeardebit,fyearcredit\r\n");
        sql.append(" from dw_fact_booksdiff c\r\n");
        sql.append(" where exists (select fcompanyid from\r\n");
        sql.append("   (select fcompanyid,faccountproperty,fcurrencyid,fperiodyear,fperiodquarter,max(fperiodnumber) fmaxperiodnumber\r\n");
        sql.append("     from dw_fact_booksdiff where fperiodtype=1\r\n");
        sql.append("     group by fcompanyid,faccountproperty,fcurrencyid,fperiodyear,fperiodquarter) d\r\n");
        sql.append("     where c.fcompanyid=d.fcompanyid\r\n");
        sql.append("           and c.faccountproperty=d.faccountproperty\r\n");
        sql.append("           and c.fcurrencyid=d.fcurrencyid\r\n");
        sql.append("           and c.fperiodyear=d.fperiodyear\r\n");
        sql.append("           and c.fperiodnumber=d.fmaxperiodnumber\r\n");
        sql.append("    ) and fperiodtype=1\r\n");
        sql.append(")\r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void insertBooksDiffSemiYearData(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into dw_fact_booksdiff\r\n");
        sql.append("(fcompanyid,faccountproperty,fcurrencyid,fperiodyear,fperiodsemiyear,fperiodquarter,\r\n");
        sql.append(" fperiodnumber,fbooksschemeid,fperiodtype,fyearbegindebit,fyearbegincredit,\r\n");
        sql.append(" fenddebit,fendcredit,fyeardebit,fyearcredit\r\n");
        sql.append(")\r\n");
        sql.append("(\r\n");
        sql.append(" select fcompanyid,faccountproperty,fcurrencyid,fperiodyear,fperiodsemiyear,fperiodquarter,\r\n");
        sql.append("        fperiodnumber,fbooksschemeid,3 fperiodtype,fyearbegindebit,fyearbegincredit,\r\n");
        sql.append("        fenddebit,fendcredit,fyeardebit,fyearcredit\r\n");
        sql.append(" from dw_fact_booksdiff c\r\n");
        sql.append(" where exists (select fcompanyid from\r\n");
        sql.append("   (select fcompanyid,faccountproperty,fcurrencyid,fperiodyear,fperiodsemiyear,max(fperiodquarter) fmaxperiodquarter\r\n");
        sql.append("     from dw_fact_booksdiff where fperiodtype=2 group by fcompanyid,faccountproperty,fcurrencyid,\r\n");
        sql.append("          fperiodyear,fperiodsemiyear) d\r\n");
        sql.append("     where c.fcompanyid=d.fcompanyid\r\n");
        sql.append("           and c.faccountproperty=d.faccountproperty\r\n");
        sql.append("           and c.fcurrencyid=d.fcurrencyid\r\n");
        sql.append("           and c.fperiodyear=d.fperiodyear\r\n");
        sql.append("           and c.fperiodquarter=fmaxperiodquarter\r\n");
        sql.append("    ) and c.fperiodtype=2\r\n");
        sql.append(")\r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void insertBooksDiffYearData(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into dw_fact_booksdiff\r\n");
        sql.append("(fcompanyid,faccountproperty,fcurrencyid,fperiodyear,fperiodsemiyear,fperiodquarter,\r\n");
        sql.append(" fperiodnumber,fbooksschemeid,fperiodtype,fyearbegindebit,fyearbegincredit,\r\n");
        sql.append(" fenddebit,fendcredit,fyeardebit,fyearcredit\r\n");
        sql.append(")\r\n");
        sql.append("(\r\n");
        sql.append(" select fcompanyid,faccountproperty,fcurrencyid,fperiodyear,fperiodsemiyear,fperiodquarter,\r\n");
        sql.append("        fperiodnumber,fbooksschemeid,4 fperiodtype,fyearbegindebit,fyearbegincredit,\r\n");
        sql.append("        fenddebit,fendcredit,fyeardebit,fyearcredit\r\n");
        sql.append(" from dw_fact_booksdiff c\r\n");
        sql.append(" where exists (select fcompanyid from\r\n");
        sql.append("   (select fcompanyid,faccountproperty,fcurrencyid,fperiodyear,max(fperiodsemiyear) fmaxperiodsemiyear\r\n");
        sql.append("     from dw_fact_booksdiff where fperiodtype=3 group by fcompanyid,faccountproperty,fcurrencyid,fperiodyear) d\r\n");
        sql.append("     where c.fcompanyid=d.fcompanyid\r\n");
        sql.append("           and c.faccountproperty=d.faccountproperty\r\n");
        sql.append("           and c.fcurrencyid=d.fcurrencyid\r\n");
        sql.append("           and c.fperiodyear=d.fperiodyear\r\n");
        sql.append("           and c.fperiodsemiyear=d.fmaxperiodsemiyear\r\n");
        sql.append("    ) and c.fperiodtype=3\r\n");
        sql.append(")\r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void insertAsstActItem(Context ctx) throws BOSException {
        String delAsstActItem = "truncate table dw_dim_pbasstactitem";
        StringBuffer inAsstActItem = new StringBuffer();
        inAsstActItem.append(" insert into dw_dim_pbasstactitem(fcompanyid,fcurrencyid,fasstactitemid,fname_l1,fname_l2,fname_l3,fnumber,fparentid)\r\n");
        inAsstActItem.append(" (\r\n");
        inAsstActItem.append(" select distinct t2.fcompanyid,t2.fcurrencyid,t1.fid,t1.fname_l1,\r\n");
        inAsstActItem.append(" t1.fname_l2,t1.fname_l3,t1.fnumber,t1.fparentid\r\n");
        inAsstActItem.append(" from v_bd_pbasstactitem t1\r\n");
        inAsstActItem.append(" inner join\r\n");
        inAsstActItem.append(" (\r\n");
        inAsstActItem.append(" select fcompanyid,fcurrencyid,fasstactitemid from dw_fact_profitbalance\r\n");
        inAsstActItem.append(" group by fcompanyid,fcurrencyid,fasstactitemid\r\n");
        inAsstActItem.append(" ) t2 on t2.fasstactitemid=t1.fid\r\n");
        inAsstActItem.append(" union\r\n");
        inAsstActItem.append(" select 'fcompanyid' fcompanyid,'fcurrencyid' fcurrencyid,fid,fname_l1,fname_l2,fname_l3,fnumber,fparentid\r\n");
        inAsstActItem.append(" from v_bd_pbasstactitem where fparentid is null\r\n");
        inAsstActItem.append(" )\r\n");
        DbUtil.execute((Context)ctx, (String)delAsstActItem);
        DbUtil.execute((Context)ctx, (String)inAsstActItem.toString());
    }

    private void insertBalanceData(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into dw_fact_profitbalance\r\n");
        sql.append(" (fcompanyid,faccountid,fcurrencyid,fyearaccumulation,fcurresult,\r\n");
        sql.append("  fperiodyear,fperiodquarter,fperiodnumber,fasstactitemid,fhgid)\r\n");
        sql.append(" (\r\n");
        sql.append("     select fcompanyid,faccountid,fcurrencyid,fyearaccumulation,\r\n");
        sql.append("            fcurresult,fperiodyear,fperiodquarter,fperiodnumber,null fasstactitemid,fhgid from\r\n");
        sql.append("     (\r\n");
        sql.append("       select fcompanyid,faccountid,fperiodyear,fperiodquarter,fperiodnumber,fcurrencyid,fhgid,\r\n");
        sql.append("              (-1)*(count(*)-1)*fyearaccumulation fyearaccumulation,\r\n");
        sql.append("              (-1)*(count(*)-1)*fcurresult fcurresult from dw_fact_profitbalance t\r\n");
        sql.append("         -----\u6ca1\u6709\u6838\u7b97\u9879\u76ee\u7684\u8bb0\u5f55\u4e0d\u9700\u8981\u63d2\u5165\u62b5\u6d88\u8bb0\u5f55\r\n");
        sql.append("         where fasstactitemid <> 'noasstactitem'\r\n");
        sql.append("         group by fcompanyid,faccountid,fperiodyear,fperiodquarter,\r\n");
        sql.append("                fperiodnumber,fcurrencyid,fhgid,fyearaccumulation,fcurresult\r\n");
        sql.append("         -----\u53ea\u6709\u4e00\u4e2a\u6838\u7b97\u9879\u76ee\u7684\u8bb0\u5f55\u4e0d\u9700\u8981\u63d2\u5165\u62b5\u6d88\u8bb0\u5f55\r\n");
        sql.append("         having count(*) > 1\r\n");
        sql.append("     ) t\r\n");
        sql.append(" )\r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void insertProfitBalanceDataToFact(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into dw_fact_profitbalance\r\n");
        sql.append(" (fcompanyid,faccountid,fcurrencyid,fyearaccumulation,fcurresult,\r\n");
        sql.append("  fperiodyear,fperiodquarter,fperiodnumber,fasstactitemid,fhgid)\r\n");
        sql.append(" (\r\n");
        sql.append(" select balance.forgunitid,balance.faccountid,balance.fcurrencyid,\r\n");
        sql.append("        -----\u53d6\u6570\u89c4\u5219\uff1a\u5982\u679cfhgid\u4e3anull,\u8868\u660e\u6838\u7b97\u9879\u76ee\u4f59\u989d\u8868\u6ca1\u6709\u8bb0\u5f55\u5bf9\u5e94\u79d1\u76ee\u4f59\u989d\u8868\u7684\u8bb0\u5f55,\u4ece\u800c\u8868\u660e\u79d1\u76ee\u65e0\u6838\u7b97\u9879\u76ee,\r\n");
        sql.append("        -----\u9700\u8981\u4ece\u79d1\u76ee\u4f59\u989d\u8868\u4e2d\u53d6\u6570.\u5982\u679cfhgid\u4e0d\u4e3a\u7a7a,\u8868\u660e\u6838\u7b97\u9879\u76ee\u4f59\u989d\u8868\u6709\u8bb0\u5f55\u5bf9\u5e94\u79d1\u76ee\u4f59\u989d\u8868\u7684\u8bb0\u5f55,\u4ece\u800c\u8868\u660e\r\n");
        sql.append("        -----\u79d1\u76ee\u6709\u6838\u7b97\u9879\u76ee,\u9700\u8981\u4ece\u6838\u7b97\u9879\u76ee\u4f59\u989d\u8868\u4e2d\u53d6\u6570(\u6b64\u65f6,\u79d1\u76ee\u4f59\u989d\u8868\u4e2d\u7684\u91d1\u989d\u521a\u597d\u7b49\u4e8e\u6838\u7b97\u9879\u76ee\u4f59\u989d\u8868\u4e2d\u91d1\u989d\u52a0\u603b).\r\n");
        sql.append("        -----\u5254\u9664\u7ed3\u8f6c\u635f\u76ca\u51ed\u8bc1\u91d1\u989d\u89c4\u5219\uff1a\r\n");
        sql.append("case when asstbalance.fassistgrpid is null\r\n");
        sql.append("then case when statusctrl.fstartperiodid=balance.fperiodid\r\n");
        sql.append("        then case when balance.fmonthpnllocal-(balance.fdebitlocal-balance.fcreditlocal) < 0\r\n");
        sql.append("             then accountview.fdc*((balance.fmonthpnllocal-(balance.fdebitlocal-balance.fcreditlocal)\r\n");
        sql.append("                   +balance.fyeardebitlocal)-balance.fyearcreditlocal)\r\n");
        sql.append("             else accountview.fdc*(balance.fyeardebitlocal-(balance.fyearcreditlocal-\r\n");
        sql.append("                 (balance.fmonthpnllocal-(balance.fdebitlocal-balance.fcreditlocal))))\r\n");
        sql.append("             end\r\n");
        sql.append("        else  case when balance.fyearpnllocal-(balance.fdebitlocal-balance.fcreditlocal) < 0\r\n");
        sql.append("              then accountview.fdc*((balance.fyearpnllocal-(balance.fdebitlocal-balance.fcreditlocal)\r\n");
        sql.append("                   +balance.fyeardebitlocal)-balance.fyearcreditlocal)\r\n");
        sql.append("              else accountview.fdc*(balance.fyeardebitlocal-(balance.fyearcreditlocal-\r\n");
        sql.append("                   (balance.fyearpnllocal-(balance.fdebitlocal-balance.fcreditlocal))))\r\n");
        sql.append("              end\r\n");
        sql.append("        end\r\n");
        sql.append("else\r\n");
        sql.append("   case when statusctrl.fstartperiodid=asstbalance.fperiodid\r\n");
        sql.append("        then case when asstbalance.fmonthpnllocal-(asstbalance.fdebitlocal-asstbalance.fcreditlocal) < 0\r\n");
        sql.append("             then accountview.fdc*((asstbalance.fmonthpnllocal-(asstbalance.fdebitlocal-asstbalance.fcreditlocal)\r\n");
        sql.append("                  +asstbalance.fyeardebitlocal)-asstbalance.fyearcreditlocal)\r\n");
        sql.append("             else accountview.fdc*(asstbalance.fyeardebitlocal-(asstbalance.fyearcreditlocal-\r\n");
        sql.append("                  (asstbalance.fmonthpnllocal-(asstbalance.fdebitlocal-asstbalance.fcreditlocal))))\r\n");
        sql.append("             end\r\n");
        sql.append("        else  case when asstbalance.fyearpnllocal-(asstbalance.fdebitlocal-asstbalance.fcreditlocal) < 0\r\n");
        sql.append("              then accountview.fdc*((asstbalance.fyearpnllocal-(asstbalance.fdebitlocal-asstbalance.fcreditlocal)\r\n");
        sql.append("                   +asstbalance.fyeardebitlocal)-asstbalance.fyearcreditlocal)\r\n");
        sql.append("              else accountview.fdc*(asstbalance.fyeardebitlocal-(asstbalance.fyearcreditlocal-\r\n");
        sql.append("                   (asstbalance.fyearpnllocal-(asstbalance.fdebitlocal-asstbalance.fcreditlocal))))\r\n");
        sql.append("              end\r\n");
        sql.append("        end\r\n");
        sql.append("end fyearaccumulation,\r\n");
        sql.append("       case when asstbalance.fassistgrpid is null\r\n");
        sql.append("            then\r\n");
        sql.append(" \t      case when balance.fmonthpnllocal-(balance.fdebitlocal-balance.fcreditlocal) < 0\r\n");
        sql.append(" \t             then accountview.fdc*(balance.fmonthpnllocal-(balance.fdebitlocal-balance.fcreditlocal) + balance.fdebitlocal)-accountview.fdc*balance.fcreditlocal\r\n");
        sql.append(" \t             else accountview.fdc*balance.fdebitlocal-accountview.fdc*(balance.fcreditlocal-(balance.fmonthpnllocal-(balance.fdebitlocal-balance.fcreditlocal)))\r\n");
        sql.append(" \t      end\r\n");
        sql.append(" \t   else\r\n");
        sql.append(" \t     case when asstbalance.fmonthpnllocal-(asstbalance.fdebitlocal-asstbalance.fcreditlocal) < 0\r\n");
        sql.append(" \t             then accountview.fdc*(asstbalance.fmonthpnllocal-(asstbalance.fdebitlocal-asstbalance.fcreditlocal) + asstbalance.fdebitlocal)-accountview.fdc*asstbalance.fcreditlocal\r\n");
        sql.append(" \t             else accountview.fdc*asstbalance.fdebitlocal-accountview.fdc*(asstbalance.fcreditlocal-(asstbalance.fmonthpnllocal-(asstbalance.fdebitlocal-asstbalance.fcreditlocal)))\r\n");
        sql.append(" \t     end\r\n");
        sql.append("        end fcurresult,\r\n");
        sql.append("        period.fperiodyear,period.fperiodquarter,period.fperiodnumber,\r\n");
        sql.append("        isnull(hg.fasstactitemid,'noasstactitem') fasstactitemid,asstbalance.fassistgrpid\r\n");
        sql.append(" from t_gl_accountbalance balance\r\n");
        sql.append(" inner join t_bd_period period on balance.fperiodid=period.fid\r\n");
        sql.append(" inner join t_bd_accountview accountview on balance.faccountid=accountview.fid\r\n");
        sql.append(" inner join t_bd_accounttype accounttype on accountview.faccounttypeid=accounttype.fid\r\n");
        sql.append(" -----\u7531\u4e8e\u79d1\u76ee\u53ef\u4ee5\u6ca1\u6709\u6838\u7b97\u9879\u76ee,\u6240\u4ee5\u8fd9\u91cc\u7528left join-----\r\n");
        sql.append(" left join t_gl_assistbalance asstbalance on balance.forgunitid=asstbalance.forgunitid\r\n");
        sql.append("           and balance.faccountid=asstbalance.faccountid and balance.fcurrencyid=asstbalance.fcurrencyid\r\n");
        sql.append("           and balance.fperiodid=asstbalance.fperiodid\r\n");
        sql.append(" left join v_bd_assistanthg hg on asstbalance.fassistgrpid=hg.fid\r\n");
        sql.append(" -----\u9650\u5236\u53d6\u6570\u5230\u6bcf\u4e2a\u516c\u53f8\u7684\u5f53\u524d\u603b\u8d26\u7cfb\u7edf\u4f1a\u8ba1\u671f\u95f4-----\r\n");
        sql.append(" left join t_bd_systemstatusctrol statusctrl on balance.forgunitid=statusctrl.fcompanyid\r\n");
        sql.append(" left join t_bd_systemstatus status on statusctrl.fsystemstatusid=status.fid\r\n");
        sql.append(" left join t_bd_period currentperiod on statusctrl.fcurrentperiodid=currentperiod.fid\r\n");
        sql.append(" where balance.fbaltype=5 and accounttype.fproperty=4 and status.fname=6\r\n");
        sql.append("       and (currentperiod.fnumber is null or period.fnumber <= currentperiod.fnumber)\r\n");
        sql.append(" )\r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }
}

