/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.books.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fi.gl.GLUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AccountBooksException;
import com.kingdee.eas.fi.books.AccountRuleInfo;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.books.VoucherMessageFactory;
import com.kingdee.eas.fi.books.VoucherStatusEnum;
import com.kingdee.eas.fi.books.app.AbstractAccountRuleControllerBean;
import com.kingdee.eas.fi.books.util.BooksRuleInfo;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountRuleControllerBean
extends AbstractAccountRuleControllerBean {
    private static final long serialVersionUID = -2570035747552065189L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.books.app.AccountRuleControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super._checkNameBlank(ctx, model);
        super._checkNumberBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._checkNameBlank(ctx, model);
        super._checkNumberBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkDelete(ctx, pk);
        super._delete(ctx, pk);
    }

    protected void checkDelete(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        AccountRuleInfo scheme = (AccountRuleInfo)this._getValue(ctx, pk, this.getSelectors());
        if (scheme.isIsEnable()) {
            throw new AccountBooksException(AccountBooksException.ENABLEACCOUNTRULE);
        }
    }

    @Override
    protected boolean _save(Context ctx, BooksRuleInfo saveInfo) throws BOSException, EASBizException {
        Iterator iter = saveInfo.getProperties().values().iterator();
        CompanyOrgUnitInfo company = BooksUtil.getCurrentMasterCompany(ctx);
        while (iter.hasNext()) {
            AccountRuleInfo info = (AccountRuleInfo)iter.next();
            if ("update".equals(info.get("status"))) {
                this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), (CoreBaseInfo)info);
                continue;
            }
            info.setCompany(company);
            this.addnew(ctx, (CoreBaseInfo)info);
        }
        return false;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue saveInfo) throws BOSException, EASBizException {
        AccountRuleInfo ruleInfo = (AccountRuleInfo)saveInfo;
        if (ruleInfo.getId() != null && ((AccountRuleInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(ruleInfo.getId()), this.getSelectors())).isIsEnable()) {
            throw new AccountBooksException(AccountBooksException.ENABLECANNOTEDIT);
        }
        return super._submit(ctx, (IObjectValue)ruleInfo);
    }

    @Override
    protected BooksRuleInfo _getRuleS(Context ctx, String book) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = BooksUtil.getCurrentMasterCompany(ctx);
        HashMap<String, AccountRuleInfo> prop = new HashMap<String, AccountRuleInfo>();
        BooksRuleInfo booksRuleInfo = new BooksRuleInfo(prop);
        String sql = " select fid,fnumber,fvalue,Ffilter  from T_BKS_AccountRule where  FCompanyID=? and FAccountSchemeID=? and FisEnable = 1 ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{company.getId().toString(), book});
            if (rs.next()) {
                AccountRuleInfo info = new AccountRuleInfo();
                String number = rs.getString("fnumber");
                String value = rs.getString("fvalue");
                String filter = rs.getString("Ffilter");
                info.setId(BOSUuid.read((String)rs.getString("fid")));
                info.setValue(VoucherStatusEnum.getEnum(value));
                info.setNumber(number);
                info.setCompany(company);
                info.setFilter(filter);
                prop.put("B001", info);
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        return booksRuleInfo;
    }

    @Override
    protected void _enable(Context ctx, String pk) throws BOSException, EASBizException {
        AccountRuleInfo scheme = (AccountRuleInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(pk), this.getSelectors());
        this._cancelCancel(ctx, (IObjectPK)new ObjectUuidPK(pk), (IObjectValue)scheme);
    }

    @Override
    protected void _disEnable(Context ctx, String pk) throws BOSException, EASBizException {
        AccountRuleInfo scheme = (AccountRuleInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(pk), this.getSelectors());
        this._cancel(ctx, (IObjectPK)new ObjectUuidPK(pk), (IObjectValue)scheme);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isEnable"));
        sic.add(new SelectorItemInfo("accountScheme.id"));
        sic.add(new SelectorItemInfo("accountScheme.name"));
        sic.add(new SelectorItemInfo("company.id"));
        return sic;
    }

    protected void check(AcountSchemeInfo scheme) throws EASBizException, BOSException {
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AccountRuleInfo scheme = (AccountRuleInfo)model;
        IObjectPK logPK = null;
        logPK = LogUtil.beginLog((Context)ctx, (String)"update", (BOSObjectType)this.getBOSType(), null, (String)(scheme.getNumber() + "  " + scheme.getName()), (String)"books_rule_disenable");
        FilterInfo filter = new FilterInfo();
        String companyid = null;
        if (BooksUtil.isMasterBook(ctx)) {
            CompanyOrgUnitInfo company = BooksUtil.getUnMasterCompany(ctx, scheme.getAccountScheme());
            if (company == null) {
                throw new AccountBooksException(AccountBooksException.NOTEXISTBOOK, new Object[]{ContextUtil.getCurrentFIUnit((Context)ctx).getName(), scheme.getName()});
            }
            companyid = company.getId().toString();
        } else {
            companyid = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
        filter.getFilterItems().add(new FilterItemInfo("accountScheme.id", (Object)scheme.getAccountScheme().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isSuc", (Object)new Integer(1)));
        if (VoucherMessageFactory.getLocalInstance((Context)ctx).exists(filter)) {
            throw new AccountBooksException(AccountBooksException.CANNOTENABLERULE);
        }
        scheme.setIsEnable(false);
        super._update(ctx, pk, (IObjectValue)scheme);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        String mainOrg = BooksUtil.getCurrentMasterCompanyID(ctx);
        AccountRuleInfo scheme = (AccountRuleInfo)model;
        IObjectPK logPK = null;
        logPK = LogUtil.beginLog((Context)ctx, (String)"update", (BOSObjectType)this.getBOSType(), null, (String)(scheme.getNumber() + "  " + scheme.getName()), (String)"books_rule_enable");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)scheme.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountScheme.id", (Object)scheme.getAccountScheme().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isEnable", (Object)new Integer(1)));
        if (this.exists(ctx, filter)) {
            throw new AccountBooksException(AccountBooksException.HASBOOKRULE);
        }
        String companyID = null;
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mainOrg.id", (Object)mainOrg));
        filter.getFilterItems().add(new FilterItemInfo("accountScheme.id", (Object)scheme.getAccountScheme().getId().toString()));
        if (!CompanyOrgUnitFactory.getLocalInstance((Context)ctx).exists(filter)) {
            throw new AccountBooksException(AccountBooksException.NOTEXISTBOOK, new Object[]{ContextUtil.getCurrentFIUnit((Context)ctx).getName(), scheme.getName()});
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        CompanyOrgUnitCollection col = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        companyID = col.get(0).getId().toString();
        HashMap hmParamIn = this.getDefaultGLParam(ctx, companyID);
        HashMap mainParamIn = this.getDefaultGLParam(ctx, mainOrg);
        Set set = hmParamIn.keySet();
        Iterator it = set.iterator();
        String param = "";
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = hmParamIn.get(key);
            if (!mainParamIn.containsKey(key) || value.equals(mainParamIn.get(key))) continue;
            if (param.length() > 0) {
                param = param + ",";
            }
            param = param + key;
        }
        if (param.length() > 0) {
            throw new AccountBooksException(AccountBooksException.PARAMNOTSAME, new Object[]{scheme.getAccountScheme().getName(), param});
        }
        String companyid = null;
        if (BooksUtil.isMasterBook(ctx)) {
            CompanyOrgUnitInfo company = BooksUtil.getUnMasterCompany(ctx, scheme.getAccountScheme());
            companyid = company.getId().toString();
        } else {
            companyid = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        }
        GLUtil.getStartPeriod((Context)ctx, (String)companyid);
        scheme.setIsEnable(true);
        super._update(ctx, pk, (IObjectValue)scheme);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private HashMap getDefaultGLParam(Context ctx, String companyID) throws BOSException, EASBizException {
        ObjectUuidPK comPK = new ObjectUuidPK(companyID);
        HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
        hmParamIn.put("GL_028", comPK);
        hmParamIn.put("GL_052", comPK);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        return pc.getParamHashMap(hmParamIn);
    }

    @Override
    protected BooksRuleInfo _getRuleS(Context ctx, String book, CompanyOrgUnitInfo masterCompany) throws BOSException {
        HashMap<String, AccountRuleInfo> prop = new HashMap<String, AccountRuleInfo>();
        BooksRuleInfo booksRuleInfo = new BooksRuleInfo(prop);
        String sql = " select fid,fnumber,fvalue,Ffilter  from T_BKS_AccountRule where  FCompanyID=? and FAccountSchemeID=? and FisEnable = 1 ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{masterCompany.getId().toString(), book});
            if (rs.next()) {
                AccountRuleInfo info = new AccountRuleInfo();
                String number = rs.getString("fnumber");
                String value = rs.getString("fvalue");
                String filter = rs.getString("Ffilter");
                info.setId(BOSUuid.read((String)rs.getString("fid")));
                info.setValue(VoucherStatusEnum.getEnum(value));
                info.setNumber(number);
                info.setCompany(masterCompany);
                info.setFilter(filter);
                prop.put("B001", info);
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        return booksRuleInfo;
    }
}

