/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.books.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.fi.gl.GLUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ReportCurrencyConvertMode;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AccountBooksException;
import com.kingdee.eas.fi.books.AcountSchemeCollection;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.books.app.AbstractAcountSchemeControllerBean;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.util.app.ContextUtil;
import org.apache.log4j.Logger;

public class AcountSchemeControllerBean
extends AbstractAcountSchemeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.books.app.AcountSchemeControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super._checkNameBlank(ctx, model);
        super._checkNumberBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._checkNameBlank(ctx, model);
        super._checkNumberBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        super._update(ctx, pk, model);
    }

    @Override
    protected boolean _lock(Context ctx, String pk) throws BOSException, EASBizException {
        AcountSchemeInfo scheme = (AcountSchemeInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(pk), this.getAcountSchemeSic());
        IObjectPK logPK = null;
        logPK = LogUtil.beginLog((Context)ctx, (String)"update", (BOSObjectType)this.getBOSType(), null, (String)(scheme.getNumber() + "  " + scheme.getName()), (String)"books_account_lock");
        if (scheme.isIsMaster()) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isLock", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("isMaster", (Object)new Integer(0)));
            if (this.exists(ctx, filter)) {
                throw new AccountBooksException(AccountBooksException.DISENABLEACCOUNTS);
            }
        } else {
            String companyNUmber = BooksUtil.isUsedByCompany(ctx, pk.toString());
            if (companyNUmber != null) {
                throw new AccountBooksException(AccountBooksException.HASUSERDBYCOM, new Object[]{companyNUmber});
            }
        }
        scheme.setIsLock(false);
        this._update(ctx, (IObjectPK)new ObjectUuidPK(pk), (IObjectValue)scheme);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return false;
    }

    @Override
    protected boolean _unLock(Context ctx, String pk) throws BOSException, EASBizException {
        AcountSchemeInfo scheme = (AcountSchemeInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(pk), this.getAcountSchemeSic());
        IObjectPK logPK = null;
        logPK = LogUtil.beginLog((Context)ctx, (String)"update", (BOSObjectType)this.getBOSType(), null, (String)(scheme.getNumber() + "  " + scheme.getName()), (String)"books_account_unlock");
        boolean isUseRptCurrency = GLUtil.getDefaultGLParam((Context)ctx, null, (String)"G001");
        this.checkAll(scheme, isUseRptCurrency);
        if (scheme.isIsMaster()) {
            this.checkAllWithcompany(ctx, scheme, isUseRptCurrency);
        } else {
            this.checkAllWithMaster(ctx, scheme, isUseRptCurrency);
        }
        scheme.setIsLock(true);
        this._update(ctx, (IObjectPK)new ObjectUuidPK(pk), (IObjectValue)scheme);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return false;
    }

    @Override
    protected IObjectValue _switchAccountScheme(Context ctx, String pk) throws BOSException, EASBizException {
        BooksUtil.setCurrentBook(ctx, null);
        AcountSchemeInfo scheme = (AcountSchemeInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(pk), this.getAcountSchemeSic());
        CompanyOrgUnitInfo company = null;
        company = scheme.isIsMaster() ? BooksUtil.getCurrentMasterCompany(ctx) : BooksUtil.getUnMasterCompany(ctx, scheme);
        if (company == null) {
            company = BooksUtil.getCurrentMasterCompany(ctx);
            throw new AccountBooksException(AccountBooksException.NOTEXISTBOOK, new Object[]{company.getName(), scheme.getName()});
        }
        if (!scheme.isIsMaster() && !PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()), (IObjectPK)new ObjectUuidPK(company.getId().toString()), (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.books.client.AccountSchemeRuleListUI"), (IMetaDataPK)new MetaDataPK("ActionOnLoad"))) {
            throw new AccountBooksException(AccountBooksException.NOSWITCH, new Object[]{scheme.getName()});
        }
        BooksUtil.setCurrentBook(ctx, scheme);
        company.setAccountScheme(scheme);
        ContextUtil.setCurrentFIUnit((Context)ctx, (CompanyOrgUnitInfo)company);
        ContextUtil.setCurrentOrgUnit((Context)ctx, (OrgUnitInfo)company);
        return company;
    }

    @Override
    protected IObjectValue _getMasterScheme(Context ctx) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getAcountSchemeSic());
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isMaster", (Object)new Integer(1)));
        AcountSchemeCollection col = this.getAcountSchemeCollection(ctx, view);
        if (col != null && col.size() > 0) {
            return col.get(0);
        }
        return null;
    }

    @Override
    protected IObjectValue _switchMasterAccountScheme(Context ctx) throws BOSException, EASBizException {
        AcountSchemeInfo scheme = (AcountSchemeInfo)this._getMasterScheme(ctx);
        BooksUtil.setCurrentBook(ctx, scheme);
        return scheme;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkDelete(ctx, pk);
        super._delete(ctx, pk);
    }

    protected void checkDelete(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        AcountSchemeInfo scheme = (AcountSchemeInfo)this.getValue(ctx, pk, this.getAcountSchemeSic());
        if (scheme.isIsMaster()) {
            throw new AccountBooksException(AccountBooksException.CANNTDELETMASTE);
        }
        if (scheme.isIsLock()) {
            throw new AccountBooksException(AccountBooksException.ENABLEACCOUNT);
        }
        String companyNUmber = BooksUtil.isUsedByCompany(ctx, pk.toString());
        if (companyNUmber != null) {
            throw new AccountBooksException(AccountBooksException.HASUSERDBYCOM, new Object[]{companyNUmber});
        }
    }

    protected void checkAll(AcountSchemeInfo scheme, boolean isUseRptCurrency) throws EASBizException, BOSException {
        if (scheme.getCurrency() == null) {
            throw new AccountBooksException(AccountBooksException.NOCURRENCY);
        }
        if (scheme.getPeriodType() == null) {
            throw new AccountBooksException(AccountBooksException.NOPERIOD);
        }
        if (scheme.getAccountTable() == null) {
            throw new AccountBooksException(AccountBooksException.NOACCOUNTTABLE);
        }
        if (scheme.getRateTable() == null) {
            throw new AccountBooksException(AccountBooksException.NORATTABLE);
        }
        if (isUseRptCurrency) {
            if (scheme.getReportCurrency() == null) {
                throw new AccountBooksException(AccountBooksException.NORPTCUURENCY);
            }
            if (scheme.getRptRateTable() == null) {
                throw new AccountBooksException(AccountBooksException.NORPTTATABLE);
            }
            if (scheme.getType() == null || ReportCurrencyConvertMode.Zero.equals((Object)scheme.getType())) {
                throw new AccountBooksException(AccountBooksException.NORPTMODE);
            }
        }
    }

    protected void checkAllWithcompany(Context ctx, AcountSchemeInfo scheme, boolean isUseRptCurrency) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
        if (company == null) {
            throw new AccountBooksException(AccountBooksException.CREATECOMPANY);
        }
        if (company.getBaseCurrency() == null || !scheme.getCurrency().getId().toString().equalsIgnoreCase(company.getBaseCurrency().getId().toString())) {
            throw new AccountBooksException(AccountBooksException.NOSAMECURRENCY);
        }
        if (company.getAccountPeriodType() == null || !scheme.getPeriodType().getId().toString().equalsIgnoreCase(company.getAccountPeriodType().getId().toString())) {
            throw new AccountBooksException(AccountBooksException.NOSAMEPERIOD);
        }
        if (company.getAccountTable() == null || !scheme.getAccountTable().getId().toString().equalsIgnoreCase(company.getAccountTable().getId().toString())) {
            throw new AccountBooksException(AccountBooksException.NOSAMEACCOUNTTABLE);
        }
        if (company.getBaseExchangeTable() == null || !scheme.getRateTable().getId().toString().equalsIgnoreCase(company.getBaseExchangeTable().getId().toString())) {
            throw new AccountBooksException(AccountBooksException.NOSAMEBASETABLE);
        }
        if (isUseRptCurrency) {
            if (company.getReportCurrency() == null || !scheme.getReportCurrency().getId().toString().equalsIgnoreCase(company.getReportCurrency().getId().toString())) {
                throw new AccountBooksException(AccountBooksException.NOSAMERPTCURRENCY);
            }
            if (company.getReportExchangeTable() == null || !scheme.getRptRateTable().getId().toString().equalsIgnoreCase(company.getReportExchangeTable().getId().toString())) {
                throw new AccountBooksException(AccountBooksException.NOSAMERPTTABLE);
            }
            if (company.getReportConvertMode() == null || scheme.getType().getValue() != company.getReportConvertMode().getValue()) {
                throw new AccountBooksException(AccountBooksException.NOSAMERPTTYPE);
            }
        }
    }

    protected void checkAllWithMaster(Context ctx, AcountSchemeInfo scheme, boolean isUseRptCurrency) throws EASBizException, BOSException {
        AcountSchemeInfo masterscheme = (AcountSchemeInfo)this._getMasterScheme(ctx);
        if (!masterscheme.isIsLock()) {
            throw new AccountBooksException(AccountBooksException.UNLOCKMASTER);
        }
        if (isUseRptCurrency && (scheme.getReportCurrency() == null || masterscheme.getReportCurrency() == null || !scheme.getReportCurrency().getId().toString().equalsIgnoreCase(masterscheme.getReportCurrency().getId().toString()))) {
            throw new AccountBooksException(AccountBooksException.NOTSAMERPTCUR);
        }
    }

    private SelectorItemCollection getAcountSchemeSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("periodType.id"));
        sic.add(new SelectorItemInfo("periodType.number"));
        sic.add(new SelectorItemInfo("periodType.name"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("rateTable.id"));
        sic.add(new SelectorItemInfo("rateTable.number"));
        sic.add(new SelectorItemInfo("rateTable.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.precision"));
        sic.add(new SelectorItemInfo("type"));
        sic.add(new SelectorItemInfo("isMaster"));
        sic.add(new SelectorItemInfo("rptRateTable.id"));
        sic.add(new SelectorItemInfo("rptRateTable.number"));
        sic.add(new SelectorItemInfo("rptRateTable.name"));
        sic.add(new SelectorItemInfo("adjRateTable.id"));
        sic.add(new SelectorItemInfo("adjRateTable.number"));
        sic.add(new SelectorItemInfo("adjRateTable.name"));
        sic.add(new SelectorItemInfo("isLock"));
        sic.add(new SelectorItemInfo("rule"));
        sic.add(new SelectorItemInfo("bookType"));
        sic.add(new SelectorItemInfo("isSyncCard"));
        return sic;
    }
}

