/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccrualDirectionEnum;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.TemplateVoucherEntryCollection;
import com.kingdee.eas.fi.gl.TemplateVoucherEntryInfo;
import com.kingdee.eas.fi.gl.TemplateVoucherInfo;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.util.client.EASResource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;

public class AccountViewDcCtrlUtil {
    public static boolean ctrlEntryDC(BaseVoucherInfo info) {
        if (SourceType.PROFIT_AND_LOSS.equals((Object)info.getSourceType())) {
            return false;
        }
        return !SourceType.ACCOUNTADJUST.equals((Object)info.getSourceType());
    }

    public static String checkTemplateVchDC(TemplateVoucherInfo tpInfo) {
        StringBuffer error = new StringBuffer();
        TemplateVoucherEntryCollection entries = tpInfo.getEntries();
        int j = entries.size();
        for (int i = 0; i < j; ++i) {
            TemplateVoucherEntryInfo entryInfo = entries.get(i);
            if (AccountViewDcCtrlUtil.checkTemplateVchEntryDC(entryInfo)) continue;
            String errorSrc = EASResource.getString((String)"com.kingdee.eas.fi.gl.VoucherinputResource", (String)"tempVoucherImpDcError");
            errorSrc = MessageFormat.format(errorSrc, new Object[]{entryInfo.getSeq(), entryInfo.getAccount().getNumber(), entryInfo.getEntryDC(), entryInfo.getAccount().getAccrualDirection()});
            error.append(errorSrc).append("\r\n");
        }
        if (error.length() == 0) {
            return null;
        }
        return error.toString();
    }

    public static boolean checkTemplateVchEntryDC(TemplateVoucherEntryInfo entryInfo) {
        return AccountViewDcCtrlUtil.verifyEntryDC(entryInfo.getEntryDC(), entryInfo.getAccount());
    }

    public static boolean checkVchEntryDC(Context ctx, VoucherEntryInfo entryInfo) {
        return AccountViewDcCtrlUtil.verifyEntryDC(ctx, entryInfo.getEntryDC(), entryInfo.getAccount());
    }

    public static boolean checkVchEntryDC(VoucherEntryInfo entryInfo) {
        return AccountViewDcCtrlUtil.checkVchEntryDC(null, entryInfo);
    }

    public static boolean verifyEntryDC(Context ctx, EntryDC entryDC, AccountViewInfo acc) {
        int entryDc = entryDC.getValue();
        AccountViewDcCtrlUtil.fillAccrualDirectionProp(ctx, acc);
        int accountDc = acc.getAccrualDirection().getValue();
        return (0 != entryDc || 30 != accountDc) && (1 != entryDc || 20 != accountDc);
    }

    public static boolean verifyEntryDC(EntryDC entryDC, AccountViewInfo acc) {
        return AccountViewDcCtrlUtil.verifyEntryDC(null, entryDC, acc);
    }

    public static void fillAccrualDirectionProp(AccountViewInfo acc) {
        AccountViewDcCtrlUtil.fillAccrualDirectionProp(null, acc);
    }

    public static void fillAccrualDirectionProp(Context ctx, AccountViewInfo acc) {
        if (acc != null && acc.getAccrualDirection() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("accrualDirection"));
            try {
                IAccountView ia = ctx != null ? AccountViewFactory.getLocalInstance((Context)ctx) : AccountViewFactory.getRemoteInstance();
                AccountViewInfo acctemp = ia.getAccountViewInfo((IObjectPK)new ObjectUuidPK(acc.getId()), sic);
                acc.setAccrualDirection(acctemp.getAccrualDirection());
            }
            catch (EASBizException e) {
                acc.setAccrualDirection(AccrualDirectionEnum.NOCONTROL);
                e.printStackTrace();
            }
            catch (BOSException e) {
                acc.setAccrualDirection(AccrualDirectionEnum.NOCONTROL);
                e.printStackTrace();
            }
            catch (Exception e) {
                acc.setAccrualDirection(AccrualDirectionEnum.NOCONTROL);
                e.printStackTrace();
            }
        }
    }

    public static String checkVchDC(VoucherInfo tpInfo) {
        StringBuffer error = new StringBuffer();
        VoucherEntryCollection entries = tpInfo.getEntries();
        int j = entries.size();
        for (int i = 0; i < j; ++i) {
            VoucherEntryInfo entryInfo = entries.get(i);
            if (AccountViewDcCtrlUtil.checkVchEntryDC(entryInfo)) continue;
            String errorSrc = EASResource.getString((String)"com.kingdee.eas.fi.gl.VoucherinputResource", (String)"voucherImpDcError");
            errorSrc = MessageFormat.format(errorSrc, new Object[]{entryInfo.getSeq(), entryInfo.getAccount().getNumber(), entryInfo.getEntryDC(), entryInfo.getAccount().getAccrualDirection()});
            error.append(errorSrc).append("\r\n");
        }
        if (error.length() == 0) {
            return null;
        }
        return error.toString();
    }

    public static void removeErrorDcEntry(VoucherInfo info) {
        VoucherEntryCollection voucherEntryCollection = info.getEntries();
        ArrayList<VoucherEntryInfo> removeEntrys = new ArrayList<VoucherEntryInfo>();
        Iterator iteratorEntry = voucherEntryCollection.iterator();
        VoucherEntryInfo voucherEntryInfo = null;
        while (iteratorEntry.hasNext()) {
            voucherEntryInfo = (VoucherEntryInfo)iteratorEntry.next();
            if (AccountViewDcCtrlUtil.checkVchEntryDC(voucherEntryInfo)) continue;
            removeEntrys.add(voucherEntryInfo);
        }
        for (int i = 0; i < removeEntrys.size(); ++i) {
            voucherEntryCollection.remove((VoucherEntryInfo)removeEntrys.get(i));
        }
    }
}

