/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.ExchangeTypeEnum;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.AbstractVoucherInfo;
import com.kingdee.eas.fi.gl.AssistCustomizedDataTypeEnum;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.TemplateCashflowRecordCollection;
import com.kingdee.eas.fi.gl.TemplateCashflowRecordInfo;
import com.kingdee.eas.fi.gl.TemplateVoucherAsstRecordCollection;
import com.kingdee.eas.fi.gl.TemplateVoucherAsstRecordInfo;
import com.kingdee.eas.fi.gl.TemplateVoucherEntryCollection;
import com.kingdee.eas.fi.gl.TemplateVoucherEntryInfo;
import com.kingdee.eas.fi.gl.TemplateVoucherInfo;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class VoucherInfo
extends AbstractVoucherInfo
implements Serializable {
    private static final long serialVersionUID = 3856740659360825451L;
    public static final String VOUCHER = "com.kingdee.eas.fi.gl.app.Voucher";

    public VoucherInfo() {
        this("id");
    }

    protected VoucherInfo(String pkField) {
        super(pkField);
    }

    public TemplateVoucherInfo transfer() {
        TemplateVoucherInfo info = new TemplateVoucherInfo();
        info.setAttachments(this.getAttachments());
        info.setAuditor(this.getAuditor());
        info.setBizOU(this.getBizOU());
        info.setCompany(this.getCompany());
        info.setCreateTime(this.getCreateTime());
        if (this.get("isWeb") == null) {
            info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        }
        info.setCU(this.getCU());
        info.setCurrency(this.getCurrency());
        info.setDescription(this.getDescription());
        info.setDisplayFormat(this.getDisplayFormat());
        info.setEntryCount(this.getEntryCount());
        info.setLocalCreditAmount(this.getLocalCreditAmount());
        info.setLocalDebitAmount(this.getLocalDebitAmount());
        info.setReportingCreditAmount(this.getReportingCreditAmount());
        info.setReportingDebitAmount(this.getReportingDebitAmount());
        info.setHandler(this.getHandler());
        info.setHasCashAccount(this.isHasCashAccount());
        info.setHasEffected(this.isHasEffected());
        info.setLastUpdateTime(this.getLastUpdateTime());
        info.setLastUpdateUser(this.getLastUpdateUser());
        info.setVoucherType(this.getVoucherType());
        info.setVoucherTypeDetail(this.getVoucherTypeDetail());
        info.setCategory(this.getCategory());
        TemplateVoucherEntryCollection entries = this.transferEntry(this.getEntries());
        info.setEntries(entries);
        info.setCashflowFlag(this.getCashflowFlag());
        TemplateCashflowRecordCollection tcr = this.transferCashflow((CashflowRecordCollection)this.getCashflowRecords(), info);
        info.setCashflowRecords(tcr);
        return info;
    }

    public TemplateVoucherEntryCollection transferEntry(VoucherEntryCollection entry) {
        TemplateVoucherEntryCollection col = new TemplateVoucherEntryCollection();
        if (entry != null && entry.size() > 0) {
            int count = entry.size();
            for (int i = 0; i < count; ++i) {
                VoucherEntryInfo entryInfo = entry.get(i);
                TemplateVoucherEntryInfo info = this.transferEntry(entryInfo);
                info.setSeq(i + 1);
                col.add(info);
            }
        }
        return col;
    }

    public TemplateVoucherEntryInfo transferEntry(VoucherEntryInfo entry) {
        TemplateVoucherEntryInfo info = new TemplateVoucherEntryInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setProfitCenter(entry.getProfitCenter());
        info.setAccount(entry.getAccount());
        info.setCurrency(entry.getCurrency());
        info.setDescription(entry.getDescription());
        info.setDisplayFormat(entry.getDisplayFormat());
        info.setEntryDC(entry.getEntryDC());
        info.setMeasureUnit(entry.getMeasureUnit());
        info.setOriginalAmount(entry.getOriginalAmount());
        info.setLocalAmount(entry.getLocalAmount());
        info.setReportingAmount(entry.getReportingAmount());
        info.setLocalExchangeRate(entry.getLocalExchangeRate());
        info.setReportingExchangeRate(entry.getReportingExchangeRate());
        info.setPrice(entry.getPrice());
        info.setQuantity(entry.getQuantity());
        info.setStandardQuantity(entry.getStandardQuantity());
        info.setSeq(entry.getSeq());
        TemplateVoucherAsstRecordCollection tvar = this.transferAsst(entry.getAssistRecords());
        info.setAssistRecords(tvar);
        info.setOprStatus(1);
        return info;
    }

    public TemplateVoucherAsstRecordCollection transferAsst(VoucherAssistRecordCollection asst) {
        TemplateVoucherAsstRecordCollection tvar = new TemplateVoucherAsstRecordCollection();
        if (asst != null && asst.size() > 0) {
            int count = asst.size();
            for (int i = 0; i < count; ++i) {
                VoucherAssistRecordInfo asstInfo = asst.get(i);
                TemplateVoucherAsstRecordInfo info = this.transferAsst(asstInfo);
                tvar.add(info);
            }
        }
        return tvar;
    }

    public TemplateVoucherAsstRecordInfo transferAsst(VoucherAssistRecordInfo asstInfo) {
        TemplateVoucherAsstRecordInfo info = new TemplateVoucherAsstRecordInfo();
        info.setId(BOSUuid.create((BOSObjectType)asstInfo.getBOSType()));
        info.setAssGrp(asstInfo.getAssGrp());
        info.setDescription(asstInfo.getDescription());
        info.setIsFullProp(asstInfo.isIsFullProp());
        info.setLocalAmount(asstInfo.getLocalAmount());
        info.setOriginalAmount(asstInfo.getOriginalAmount());
        info.setReportingAmount(asstInfo.getReportingAmount());
        info.setQuantity(asstInfo.getQuantity());
        info.setSeq(asstInfo.getSeq());
        info.setStandardQuantity(asstInfo.getStandardQuantity());
        info.setPrice(asstInfo.getPrice());
        info.setMeasureUnitID(asstInfo.getMeasureUnit());
        info.setBizNumber(asstInfo.getBizNumber());
        info.setSettlementCode(asstInfo.getSettlementCode());
        info.setTicketNumber(asstInfo.getTicketNumber());
        info.setInvoiceNumber(asstInfo.getInvoiceNumber());
        if (asstInfo.getFeeType() != null) {
            info.setFeeType(asstInfo.getFeeType());
        }
        info.setSettlementType(asstInfo.getSettlementType());
        info.setCustomer(asstInfo.getCustomer());
        info.setSupplier(asstInfo.getSupplier());
        info.setOrgUnit(asstInfo.getOrgUnit());
        info.setMaterial(asstInfo.getMaterial());
        info.setHandler(asstInfo.getHandler());
        info.setOprStatus(1);
        return info;
    }

    public TemplateCashflowRecordCollection transferCashflow(CashflowRecordCollection cashflowCol, TemplateVoucherInfo tempInfo) {
        if (cashflowCol == null) {
            return null;
        }
        HashMap<String, TemplateVoucherEntryInfo> enMap = new HashMap<String, TemplateVoucherEntryInfo>();
        TemplateVoucherEntryCollection entries = tempInfo.getEntries();
        if (entries != null && entries.size() > 0) {
            int count = entries.size();
            for (int i = 0; i < count; ++i) {
                TemplateVoucherEntryInfo info = entries.get(i);
                enMap.put(String.valueOf(info.getSeq()), info);
            }
            tempInfo.setEntriesMap(enMap);
        }
        TemplateCashflowRecordCollection col = new TemplateCashflowRecordCollection();
        if (entries != null && entries.size() > 0) {
            int count = cashflowCol.size();
            for (int i = 0; i < count; ++i) {
                CashflowRecordInfo cashflow = cashflowCol.get(i);
                TemplateCashflowRecordInfo info = this.transferCashflow(cashflow, tempInfo);
                col.add(info);
            }
            tempInfo.setCashflowFetched(this.getCashflowFetched());
        }
        return col;
    }

    public TemplateCashflowRecordInfo transferCashflow(CashflowRecordInfo cashflow, TemplateVoucherInfo tempInfo) {
        TemplateCashflowRecordInfo info = new TemplateCashflowRecordInfo();
        Map entriesMap = tempInfo.getEntriesMap();
        String seq = String.valueOf(cashflow.getEntry().getSeq());
        TemplateVoucherEntryInfo entryInfo = (TemplateVoucherEntryInfo)entriesMap.get(seq);
        String oppseq = String.valueOf(cashflow.getOpposingAccountEntry().getSeq());
        TemplateVoucherEntryInfo oppEntryInfo = (TemplateVoucherEntryInfo)entriesMap.get(oppseq);
        info.setEntry(entryInfo);
        info.setOpposingAccountEntry(oppEntryInfo);
        info.setCreateTime(cashflow.getCreateTime());
        info.setCreator(cashflow.getCreator());
        info.setCU(cashflow.getCU());
        info.setDisplayFormat(cashflow.getDisplayFormat());
        info.setLastUpdateTime(cashflow.getLastUpdateTime());
        info.setLastUpdateUser(cashflow.getLastUpdateUser());
        info.setLocalAmount(cashflow.getLocalAmount());
        info.setOriginalAmount(cashflow.getOriginalAmount());
        info.setPrimaryItem(cashflow.getPrimaryItem());
        info.setPrimaryCoefficient(cashflow.getPrimaryCoefficient());
        info.setReportingAmount(cashflow.getReportingAmount());
        info.setSupplementaryItem(cashflow.getSupplementaryItem());
        info.setSupplementaryCoefficient(cashflow.getSupplementaryCoefficient());
        info.setSeq(cashflow.getSeq());
        info.setItemFlag(cashflow.getItemFlag());
        info.setVoucher(tempInfo);
        return info;
    }

    public static class DynamicColumnInfo
    implements Serializable {
        private static final long serialVersionUID = -2072247435505651139L;
        private BOSUuid id;
        private boolean isCreditNecessary;
        private boolean isDebitNecessary;
        private String colName;
        private String colNumber;
        private AssistCustomizedDataTypeEnum dataType;
        private String mappingPropName;
        private String realtionDataObject;
        private String mappingFieldName;
        private String defaultQueryName;
        private String defaultF7UI;
        private int precision;
        private boolean isQty;
        private boolean isForCompany;
        private HashMap hmMultiLangColName;
        private GeneralAsstActTypeGroupInfo grp;
        private boolean isSameWithAccount;
        private String groupTableName;
        private boolean isMultilevel;
        private boolean useLongNumber;

        public DynamicColumnInfo(boolean isNec, String cn, AssistCustomizedDataTypeEnum dt, String propName, String queryName, String f7UI, int prec, boolean isForCom, HashMap mlcn) {
            this.colName = cn;
            this.dataType = dt;
            this.mappingPropName = propName;
            this.defaultQueryName = queryName;
            this.precision = prec;
            this.isForCompany = isForCom;
            this.hmMultiLangColName = mlcn;
        }

        public DynamicColumnInfo(String cn, String propName, String queryName, String f7UI, boolean isForCom, HashMap mlcn, BOSUuid id) {
            this.colName = cn;
            this.dataType = AssistCustomizedDataTypeEnum.BUSINESSOBJECT;
            this.mappingPropName = propName;
            this.defaultQueryName = queryName;
            this.defaultF7UI = f7UI;
            this.precision = 0;
            this.isForCompany = isForCom;
            this.hmMultiLangColName = mlcn;
            this.id = id;
        }

        public boolean getIsDebitNecessary() {
            return this.isDebitNecessary;
        }

        public boolean getIsCreditNecessary() {
            return this.isCreditNecessary;
        }

        public String getColName() {
            return this.colName;
        }

        public AssistCustomizedDataTypeEnum getDataType() {
            return this.dataType;
        }

        public String getMappingPropName() {
            return this.mappingPropName;
        }

        public String getDefaultQueryName() {
            return this.defaultQueryName;
        }

        public String getDefaultF7UI() {
            return this.defaultF7UI;
        }

        public int getPrecision() {
            return this.precision;
        }

        public boolean isQty() {
            return this.isQty;
        }

        public void setQty(boolean isQty) {
            this.isQty = isQty;
        }

        public boolean getIsForCompany() {
            return this.isForCompany;
        }

        public HashMap getHmMultiLangColName() {
            return this.hmMultiLangColName;
        }

        public String getColName(Locale loc) {
            Object obj = this.hmMultiLangColName.get(loc);
            return obj == null ? null : obj.toString();
        }

        public GeneralAsstActTypeGroupInfo getGrp() {
            return this.grp;
        }

        public void setGrp(GeneralAsstActTypeGroupInfo grp) {
            this.grp = grp;
        }

        public BOSUuid getId() {
            return this.id;
        }

        public void setId(BOSUuid id) {
            this.id = id;
        }

        public String getMappingFieldName() {
            return this.mappingFieldName;
        }

        public void setMappingFieldName(String mappingFieldName) {
            this.mappingFieldName = mappingFieldName;
        }

        public String getRealtionDataObject() {
            return this.realtionDataObject;
        }

        public void setRealtionDataObject(String realtionDataObject) {
            this.realtionDataObject = realtionDataObject;
        }

        public String getColNumber() {
            return this.colNumber;
        }

        public void setColNumber(String colNumber) {
            this.colNumber = colNumber;
        }

        public void setCreditNecessary(boolean isCreditNecessary) {
            this.isCreditNecessary = isCreditNecessary;
        }

        public void setDebitNecessary(boolean isDebitNecessary) {
            this.isDebitNecessary = isDebitNecessary;
        }

        public boolean isSameWithAccount() {
            return this.isSameWithAccount;
        }

        public void setSameWithAccount(boolean isSameWithAccount) {
            this.isSameWithAccount = isSameWithAccount;
        }

        public void setDataType(AssistCustomizedDataTypeEnum dataType) {
            this.dataType = dataType;
        }

        public String getGroupTableName() {
            return this.groupTableName;
        }

        public void setGroupTableName(String groupTableName) {
            this.groupTableName = groupTableName;
        }

        public boolean isMultilevel() {
            return this.isMultilevel;
        }

        public void setMultilevel(boolean isMultilevel) {
            this.isMultilevel = isMultilevel;
        }

        public boolean isUseLongNumber() {
            return this.useLongNumber;
        }

        public void setUseLongNumber(boolean useLongNumber) {
            this.useLongNumber = useLongNumber;
        }

        public String toString() {
            return this.mappingPropName + this.colName;
        }
    }

    public static class ExchangeRateWithValue
    implements Serializable {
        private static final long serialVersionUID = 1004959274680931028L;
        public static final ExchangeRateWithValue STANDARD_EXCHANGERATE = new ExchangeRateWithValue(ExchangeTypeEnum.FIXEXCHANGERATE, ConvertModeEnum.DIRECTEXCHANGERATE, Constants.ONE);
        public static final int GET_LOCAL_EXCHANGERATE_TABLE = 0;
        public static final int GET_REPORTING_EXCHANGERATE_TABLE = 1;
        public static final int GET_ORIGINAL_CURRENCY = 2;
        public static final int GET_LOCAL_CURRENCY = 3;
        public static final int GET_REPORTING_CURRENCY = 4;
        public static final int GET_TIME = 5;
        public static final int GET_PERIOD_BEGIN_DATE = 6;
        public static final int GET_COMPANYID = 7;
        public static final int END_OF_GET = 8;
        public static final int RETURN_LOCALEXCHANGERATE = 0;
        public static final int RETURN_REPORTINGEXCHANGERATE = 1;
        public static final int END_OF_RETURN = 2;
        private ExchangeTypeEnum type;
        private ConvertModeEnum convertMode;
        private BigDecimal value;
        private int presion;

        public ExchangeRateWithValue(ExchangeTypeEnum t, ConvertModeEnum mode, BigDecimal val) {
            this.type = t;
            this.convertMode = mode;
            this.value = val;
        }

        public ExchangeTypeEnum getType() {
            return this.type;
        }

        public ConvertModeEnum getConvertMode() {
            return this.convertMode;
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public int getPresion() {
            return this.presion;
        }

        public void setPresion(int presion) {
            this.presion = presion;
        }
    }
}

