/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.bi.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.gr.bi.app.AbstractRptDynaItemAnalysisFacadeControllerBean;
import com.kingdee.eas.fi.gr.bi.util.DynaItemInfo;
import com.kingdee.eas.fi.gr.bi.util.RptBiUtil;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.dynamic.DynaRptItemDataFacadeFactory;
import com.kingdee.eas.fi.gr.dynamic.IDynaRptItemDataFacade;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RptDynaItemAnalysisFacadeControllerBean
extends AbstractRptDynaItemAnalysisFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.bi.app.RptDynaItemAnalysisFacadeControllerBean");

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        boolean singleOrg;
        SchemaSource schema = new SchemaSource();
        schema.setCaller(RptDynaItemAnalysisFacadeControllerBean.class);
        schema.setFilename("RptDynaItemAnalysisSchema_" + ctx.getLocale() + ".xml");
        Integer start_year = (Integer)params.getObject("START_YEAR");
        Integer start_period = (Integer)params.getObject("START_PERIOD");
        Integer end_year = (Integer)params.getObject("END_YEAR");
        Integer end_period = (Integer)params.getObject("END_PERIOD");
        int period_type = params.getInt("PERIOD_TYPE");
        schema.setMacroValue("PeriodLevel", RptBiUtil.getBIPeriodSegment(period_type));
        schema.setMacroValue("FetchTypeMeasure", RptBiUtil.buildFetchType(params));
        String tree_id = (String)params.getObject("ORG_TREE_ID");
        List orgs = (List)params.getObject("ORGS");
        schema.setDataItem("Orgs", RptBiUtil.buildOrgs(ctx, orgs, tree_id), null);
        String report_id = (String)params.getObject("REPORT_ID");
        if (tree_id == null) {
            OrgTreeInfo treeinfo = this.findTreeByReportID(ctx, report_id);
            if (treeinfo == null) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"12_RptDynaItemAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale())});
            }
            params.setObject("ORG_TREE_ID", (Object)treeinfo.getId().toString());
            params.setObject("ORG_TREE_Number", (Object)treeinfo.getNumber());
        }
        String periodSql = null;
        if (period_type == 3 && CslRptUtil.isSupport13Period(ctx)) {
            periodSql = RptBiUtil.buildPeriodSqlFor13q(period_type, start_year, start_period, end_year, end_period, ctx);
        } else {
            PeriodCollection periodCollection = (PeriodCollection)params.getObject("periodCollection");
            boolean isMergeByFiscalPeriod = (Boolean)params.getObject("isMergeByFiscalPeriod");
            periodSql = RptBiUtil.buildPeriodSQL(start_year, start_period, end_year, end_period, period_type, periodCollection, isMergeByFiscalPeriod);
        }
        schema.setDataItem("Period", periodSql, null);
        List items = (List)params.getObject("ITEMS");
        schema.setDataItem("Item", RptBiUtil.buildItemSQL(items), null);
        schema.setDataItem("DItem", this.buildDItemsSQL(params), null);
        boolean show_org_sum = params.getBoolean("SHOW_ORG_SUM");
        boolean show_period_sum = params.getBoolean("SHOW_PERIOD_SUM");
        List data_type = (List)params.getObject("DATA_TYPE");
        if (data_type.size() > 1) {
            schema.setMacroValue("DataTypeTable", "<Parameter name=\"DataType\"  type=\"Table\"/>");
            StringBuffer sb = new StringBuffer();
            sb.append("\t<Dimension name=\"DataType\" caption=\"" + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"780_RptDynaItemAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "\" table=\"DataType\" primaryKey=\"FValue\"> \n").append("\t\t<Hierarchy>                                                 \n").append("\t\t\t<Level name=\"name\" column=\"FValue\" orderBy=\"FSEQ\">   \n").append("\t\t\t\t<Property name=\"name\" column=\"FName\"/>          \n").append("\t\t\t</Level>                                                \n").append("\t\t</Hierarchy>                                                \n").append("\t</Dimension>                                                    \n");
            schema.setMacroValue("DataTypeDim", sb.toString());
            schema.setMacroValue("DataTypeUsage", "<DimensionUsage name=\"DataType\" foreignKey=\"FDataType\"/>");
            schema.setDataItem("DataType", this.buildEnumSQL(data_type), null);
        } else {
            schema.setMacroValue("DataTypeTable", "");
            schema.setMacroValue("DataTypeDim", "");
            schema.setMacroValue("DataTypeUsage", "");
        }
        boolean singlePeriod = start_year.intValue() == end_year.intValue() && start_period.intValue() == end_period.intValue();
        boolean bl = singleOrg = orgs.size() == 1;
        if (singlePeriod) {
            schema.setMacroValue("PeriodUseage", "");
        } else {
            schema.setMacroValue("PeriodUseage", "<DimensionUsage name=\"Period\" foreignKey=\"FYearPeriod\"/>");
        }
        if (singleOrg) {
            schema.setMacroValue("OrgsUseage", "");
        } else {
            schema.setMacroValue("OrgsUseage", "<DimensionUsage name=\"Orgs\" foreignKey=\"FOrgUnitID\"/>");
        }
        schema.setDataItem("Fact", this.buildFact(ctx, params, schema), null);
        schema.setMdx(this.makeMdx(singlePeriod, singleOrg, show_org_sum, show_period_sum, params, ctx));
        return schema;
    }

    private String buildDItemsSQL(RptParams params) {
        List list = (List)params.getObject("DITEMS");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            DynaItemInfo a = (DynaItemInfo)list.get(i);
            if (i != 0) {
                sb.append("\n UNION ALL ");
            }
            sb.append(" SELECT '").append(a.getDitemName()).append("(").append(a.getDitemNumber()).append(")' AS FName, '").append(a.getDitemNumber()).append("' AS FNumber, ").append(i).append(" AS FID ");
        }
        return sb.toString();
    }

    private String buildFact(Context ctx, RptParams params, SchemaSource schema) throws BOSException, EASBizException {
        int i;
        String tableName = RptDynaItemAnalysisFacadeControllerBean.getTempTableName((String)"RptDynaItemAnalysis", (Context)ctx);
        schema.setProperty("TEMP_TABLE", (Object)tableName);
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table ").append(tableName).append("( FOrgUnitID varchar(44), FItemNumber varchar(80), FDItemNumber varchar(400),").append(" FYearPeriod int , FDATATYPE int");
        List fetchtype = (List)params.getObject("FETCH_TYPE");
        int iSize = fetchtype.size();
        for (int i2 = 0; i2 < iSize; ++i2) {
            DataElementInfo dataElementInfo = (DataElementInfo)fetchtype.get(i2);
            sql.append(",F").append(dataElementInfo.getNumber().replaceAll("-", "_")).append(" Numeric(28,10)");
        }
        sql.append(")");
        TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(sql.toString().replaceAll("-", "_"));
        ItemDataCondition condition = new ItemDataCondition();
        condition.setForBiReport(true);
        condition.setOrgTreeNumber(params.getString("ORG_TREE_ID"));
        List orgs = (List)params.getObject("ORGS");
        ArrayList<String> orgNumbers = new ArrayList<String>(orgs.size());
        for (OrgUnitInfo info : orgs) {
            orgNumbers.add(info.getNumber());
        }
        condition.setOrgUnitNumber(orgNumbers);
        int period_type = params.getInt("PERIOD_TYPE");
        condition.setRptPeriodType(period_type);
        int startYear = params.getInt("START_YEAR");
        condition.setRptYearStart(startYear);
        int endyear = params.getInt("END_YEAR");
        condition.setRptYearEnd(endyear);
        int startperiod = params.getInt("START_PERIOD");
        condition.setRptPeriodStart(startperiod);
        int endperiod = params.getInt("END_PERIOD");
        condition.setRptPeriodEnd(endperiod);
        condition.setTargetCurrency(params.getString("CURRENCY_ID"));
        HashMap mapItemList = new HashMap();
        List ArrItemList = (List)params.getObject("ITEMS");
        for (int i3 = 0; i3 < ArrItemList.size(); ++i3) {
            mapItemList.put(ArrItemList.get(i3), null);
        }
        condition.setItemList(mapItemList);
        condition.setIsAdjusted(params.getInt("ADJUST") == 1);
        List fetchType = (List)params.getObject("FETCH_TYPE");
        ArrayList<String> lstDataElement = new ArrayList<String>(fetchType.size());
        for (int i4 = 0; i4 < fetchType.size(); ++i4) {
            DataElementInfo info = (DataElementInfo)fetchType.get(i4);
            lstDataElement.add("" + info.getInterSeq());
        }
        condition.setDataElement(lstDataElement);
        condition.setDataSource(params.getInt("DATA_SRC_TYPE") == 2 ? 2 : 3);
        if (params.containsKey("COMMITSTATUS")) {
            condition.setCommitStatus(params.getInt("COMMITSTATUS"));
        }
        HashMap<String, Object> extConditions = new HashMap<String, Object>(4);
        extConditions.put("dataType", new Integer(2));
        extConditions.put("DATA_TYPE", params.getObject("DATA_TYPE"));
        List list = (List)params.getObject("DITEMS");
        ArrayList<String> keys = new ArrayList<String>(list.size());
        for (int i5 = 0; i5 < list.size(); ++i5) {
            DynaItemInfo a = (DynaItemInfo)list.get(i5);
            keys.add(a.getDitemNumber());
        }
        extConditions.put("keyName", keys);
        condition.setIsShowFreezeItem(true);
        condition.setDataCollectNumber(params.getString("DATACOLLECT"));
        IDynaRptItemDataFacade dataService = DynaRptItemDataFacadeFactory.getLocalInstance((Context)ctx);
        condition.setRptYearStart(startYear);
        condition.setRptYearEnd(endyear);
        condition.setRptPeriodStart(startperiod);
        condition.setRptPeriodEnd(endperiod);
        List result = dataService.getDynamicItemData(condition, extConditions);
        ArrayList<Object> ps = new ArrayList<Object>();
        StringBuffer insertSQL = null;
        for (i = 0; result != null && i < result.size(); ++i) {
            insertSQL = new StringBuffer();
            ps.clear();
            Object[] row = (Object[])result.get(i);
            insertSQL.append("INSERT INTO ").append(tableName).append(" (FOrgUnitID, FItemNumber, FDItemNumber, FYearPeriod, FDATATYPE, F").append(row[13].toString().replaceAll("-", "_")).append(") values (?,?,?,?,?,?)");
            ps.add(row[2]);
            ps.add(row[11]);
            ps.add(row[19]);
            int year = Integer.parseInt((String)row[8]);
            int period = Integer.parseInt((String)row[9]);
            ps.add(RptBiUtil.generatePeriodID(year, period));
            ps.add(row[26]);
            if (row[21] != null && row[21] instanceof BigDecimal && CslConstant.BGZERO.compareTo((BigDecimal)row[21]) != 0) {
                ps.add(row[21]);
            } else {
                ps.add(row[22]);
            }
            DbUtil.execute((Context)ctx, (String)insertSQL.toString(), (Object[])ps.toArray());
        }
        sql = new StringBuffer("SELECT FOrgUnitID, FItemNumber, FDItemNumber, FYearPeriod, FDATATYPE ");
        for (i = 0; i < iSize; ++i) {
            DataElementInfo dataElementInfo = (DataElementInfo)fetchtype.get(i);
            sql.append(",SUM(F").append(dataElementInfo.getNumber().replaceAll("-", "_")).append(") AS F").append(dataElementInfo.getNumber().replaceAll("-", "_"));
        }
        sql.append(" FROM ").append(tableName).append(" GROUP BY FOrgUnitID, FItemNumber, FDItemNumber, FYearPeriod, FDATATYPE");
        return sql.toString();
    }

    private String makeMdx(boolean singlePeriod, boolean singleOrg, boolean show_org_sum, boolean show_period_sum, RptParams params, Context ctx) {
        StringBuffer sb = new StringBuffer();
        if (!singlePeriod && show_period_sum) {
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"7_RptCellAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()));
        }
        if (!singleOrg && show_org_sum) {
            if (sb.length() < 1) {
                sb.append("With ");
            }
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"8_RptCellAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()));
        }
        List data_type = (List)params.getObject("DATA_TYPE");
        sb.append("SELECT ").append(singleOrg ? "" : "{Orgs.Members" + (show_org_sum ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"9_RptCellAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) : "") + "}*").append(singlePeriod ? "" : "{Period.Members" + (show_period_sum ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"10_RptCellAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) : "") + "}*").append("Item.Members*Measures.Members");
        if (data_type.size() > 1) {
            sb.append("* DataType.Members");
        }
        sb.append(" ON COLUMNS, DItem.Members ON ROWS FROM Fact");
        return sb.toString();
    }
}

