/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.bi.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.gr.bi.app.AbstractRptXDynaItemAnalysisFacadeControllerBean;
import com.kingdee.eas.fi.gr.bi.util.DynaItemInfo;
import com.kingdee.eas.fi.gr.bi.util.PeriodIterator;
import com.kingdee.eas.fi.gr.bi.util.RptBiUtil;
import com.kingdee.eas.fi.gr.bi.util.SimplePeriod;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.IMultiDynaItemDataFacade;
import com.kingdee.eas.fi.gr.dynamic.MultiDynaItemDataFacadeFactory;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class RptXDynaItemAnalysisFacadeControllerBean
extends AbstractRptXDynaItemAnalysisFacadeControllerBean {
    private static final long serialVersionUID = -5588523254276372229L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.bi.app.RptXDynaItemAnalysisFacadeControllerBean");

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        boolean singleOrg;
        int i;
        SchemaSource schema = new SchemaSource();
        schema.setCaller(RptXDynaItemAnalysisFacadeControllerBean.class);
        schema.setFilename("RptXDynaItemAnalysisSchema_" + ctx.getLocale() + ".xml");
        Integer start_year = (Integer)params.getObject("START_YEAR");
        Integer start_period = (Integer)params.getObject("START_PERIOD");
        Integer end_year = (Integer)params.getObject("END_YEAR");
        Integer end_period = (Integer)params.getObject("END_PERIOD");
        int period_type = params.getInt("PERIOD_TYPE");
        schema.setMacroValue("PeriodLevel", RptBiUtil.getBIPeriodSegment(period_type));
        this.handleRepeatDataElement((List)params.getObject("FETCH_TYPE"));
        schema.setMacroValue("FetchTypeMeasure", RptBiUtil.buildFetchType(params));
        List asstTypeList = (List)params.getObject("ASST");
        String tree_id = (String)params.getObject("ORG_TREE_ID");
        List orgs = (List)params.getObject("ORGS");
        schema.setDataItem("Orgs", RptBiUtil.buildOrgs(ctx, orgs, tree_id), null);
        String report_id = (String)params.getObject("REPORT_ID");
        if (tree_id == null) {
            OrgTreeInfo treeinfo = this.findTreeByReportID(ctx, report_id);
            if (treeinfo == null) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"12_RptDynaItemAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale())});
            }
            params.setObject("ORG_TREE_ID", (Object)treeinfo.getId().toString());
            params.setObject("ORG_TREE_Number", (Object)treeinfo.getNumber());
        }
        String periodSql = null;
        if (period_type == 3 && CslRptUtil.isSupport13Period(ctx)) {
            periodSql = RptBiUtil.buildPeriodSqlFor13q(period_type, start_year, start_period, end_year, end_period, ctx);
        } else {
            PeriodCollection periodCollection = (PeriodCollection)params.getObject("periodCollection");
            boolean isMergeByFiscalPeriod = (Boolean)params.getObject("isMergeByFiscalPeriod");
            periodSql = RptBiUtil.buildPeriodSQL(start_year, start_period, end_year, end_period, period_type, periodCollection, isMergeByFiscalPeriod);
        }
        schema.setDataItem("Period", periodSql, null);
        List items = (List)params.getObject("ITEMS");
        schema.setDataItem("Item", RptBiUtil.buildItemSQL(items), null);
        Map map = (Map)params.getObject("DITEMS");
        ArrayList ditems = new ArrayList(map.values());
        StringBuffer ditemVar = new StringBuffer();
        for (i = 0; i < ditems.size(); ++i) {
            ditemVar.append("<DimensionUsage name=\"DItem").append(i).append("\" foreignKey=\"FDItem").append(i).append("Number\"/>");
            schema.setDataItem("DItem" + i, this.buildDItemsSQL(ditems.get(i)), null);
        }
        schema.setMacroValue("ditemVar", ditemVar.toString());
        ditemVar = new StringBuffer();
        for (i = 0; i < asstTypeList.size(); ++i) {
            ditemVar.append("<Dimension name=\"DItem" + i + "\" caption=\"" + ((AsstActTypeInfo)asstTypeList.get(i)).getName() + "\" table=\"DItem" + i + "\" primaryKey=\"FNumber\"> \n");
            ditemVar.append("<Hierarchy hasAll=\"false\"> \n");
            ditemVar.append("<Level name=\"DItem" + i + "\" column=\"FNumber\" orderBy=\"FID\"> \n");
            ditemVar.append("<Property  name=\"name\" column=\"FNumber\" /> \n");
            ditemVar.append("<Property  name=\"caption\" column=\"FName\" /> \n");
            ditemVar.append("</Level> \n");
            ditemVar.append("</Hierarchy> \n");
            ditemVar.append("</Dimension> \n");
        }
        schema.setMacroValue("DItem0", ditemVar.toString());
        boolean show_org_sum = params.getBoolean("SHOW_ORG_SUM");
        boolean show_period_sum = params.getBoolean("SHOW_PERIOD_SUM");
        List data_type = (List)params.getObject("DATA_TYPE");
        if (data_type.size() > 1) {
            schema.setMacroValue("DataTypeTable", "<Parameter name=\"DataType\"  type=\"Table\"/>");
            StringBuffer sb = new StringBuffer();
            sb.append("\t<Dimension name=\"DataType\" caption=\"" + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"780_RptDynaItemAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "\" table=\"DataType\" primaryKey=\"FValue\"> \n").append("\t\t<Hierarchy>                                                 \n").append("\t\t\t<Level name=\"name\" column=\"FValue\" orderBy=\"FSEQ\">   \n").append("\t\t\t\t<Property name=\"name\" column=\"FName\"/>          \n").append("\t\t\t</Level>                                                \n").append("\t\t</Hierarchy>                                                \n").append("\t</Dimension>                                                    \n");
            schema.setMacroValue("DataTypeDim", sb.toString());
            schema.setMacroValue("DataTypeUsage", "<DimensionUsage name=\"DataType\" foreignKey=\"FDataType\"/>");
            schema.setDataItem("DataType", this.buildEnumSQL(data_type), null);
        } else {
            schema.setMacroValue("DataTypeTable", "");
            schema.setMacroValue("DataTypeDim", "");
            schema.setMacroValue("DataTypeUsage", "");
        }
        boolean singlePeriod = start_year.intValue() == end_year.intValue() && start_period.intValue() == end_period.intValue();
        boolean bl = singleOrg = orgs.size() == 1;
        if (singlePeriod) {
            schema.setMacroValue("PeriodUseage", "");
        } else {
            schema.setMacroValue("PeriodUseage", "<DimensionUsage name=\"Period\" foreignKey=\"FYearPeriod\"/>");
        }
        if (singleOrg) {
            schema.setMacroValue("OrgsUseage", "");
        } else {
            schema.setMacroValue("OrgsUseage", "<DimensionUsage name=\"Orgs\" foreignKey=\"FOrgUnitID\"/>");
        }
        schema.setDataItem("Fact", this.buildFact(ctx, params, schema), null);
        schema.setMdx(this.makeMdx(singlePeriod, singleOrg, show_org_sum, show_period_sum, params, ctx));
        return schema;
    }

    private void handleRepeatDataElement(List data_type) {
        HashSet<String> numbers = new HashSet<String>();
        for (Object obj : data_type) {
            String number = ((DataElementInfo)obj).getNumber().toUpperCase(Locale.ENGLISH);
            while (numbers.contains(number)) {
                number = number + "1";
            }
            numbers.add(number);
            ((DataElementInfo)obj).put("extNumber", number);
        }
    }

    private String buildDItemsSQL(Object o) {
        List list = (List)o;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            DynaItemInfo a = (DynaItemInfo)list.get(i);
            if (i != 0) {
                sb.append("\n UNION ALL ");
            }
            sb.append(" SELECT '").append(a.getDitemName()).append("' AS FName, '").append(a.getDitemNumber()).append("' AS FNumber, ").append(i).append(" AS FID ");
        }
        return sb.toString();
    }

    private String buildFact(Context ctx, RptParams params, SchemaSource schema) throws BOSException, EASBizException {
        int i;
        int j;
        String tableName = RptXDynaItemAnalysisFacadeControllerBean.getTempTableName((String)"RptXDynaItemAnalysis", (Context)ctx);
        schema.setProperty("TEMP_TABLE", (Object)tableName);
        Map map = (Map)params.getObject("DITEMS");
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table ").append(tableName).append("( FOrgUnitID varchar(44), FItemNumber varchar(80),");
        for (int i2 = 0; i2 < map.size(); ++i2) {
            sql.append("FDItem");
            sql.append(i2);
            sql.append("Number varchar(400),");
        }
        sql.append(" FYearPeriod int , FDATATYPE int");
        List fetchtype = (List)params.getObject("FETCH_TYPE");
        int iSize = fetchtype.size();
        for (int i3 = 0; i3 < iSize; ++i3) {
            DataElementInfo dataElementInfo = (DataElementInfo)fetchtype.get(i3);
            sql.append(",F").append(dataElementInfo.get("extNumber")).append(" Numeric(28,10)");
        }
        sql.append(")");
        TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(sql.toString());
        IMultiDynaItemDataFacade multiDyna = MultiDynaItemDataFacadeFactory.getLocalInstance((Context)ctx);
        ArrayList<Parameter> dyparams = new ArrayList<Parameter>();
        int startYear = params.getInt("START_YEAR");
        int endyear = params.getInt("END_YEAR");
        int startperiod = params.getInt("START_PERIOD");
        int endperiod = params.getInt("END_PERIOD");
        int period_type = params.getInt("PERIOD_TYPE");
        List arrItemList = (List)params.getObject("ITEMS");
        List orgs = (List)params.getObject("ORGS");
        ArrayList ditems = new ArrayList(map.values());
        List ditemsR = RptXDynaItemAnalysisFacadeControllerBean.getResult(ditems);
        long b = System.currentTimeMillis();
        boolean isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod(ctx);
        ArrayList<SimplePeriod> yearAndMonth = null;
        if (isMergeByFiscalPeriod) {
            PeriodCollection periodCollection = (PeriodCollection)params.getObject("periodCollection");
            PeriodIterator iterator = new PeriodIterator(startYear, endyear, startperiod, endperiod, period_type, periodCollection, isMergeByFiscalPeriod);
            yearAndMonth = new ArrayList<SimplePeriod>();
            while (iterator.hasNext()) {
                yearAndMonth.add(iterator.next());
            }
        } else {
            yearAndMonth = RptBiUtil.getPeriodListFor13q(startYear, startperiod, endyear, endperiod, period_type);
        }
        for (int n = 0; n < yearAndMonth.size(); ++n) {
            SimplePeriod period = (SimplePeriod)yearAndMonth.get(n);
            for (int k = 0; k < orgs.size(); ++k) {
                OrgUnitInfo info = (OrgUnitInfo)orgs.get(k);
                for (int j2 = 0; j2 < arrItemList.size(); ++j2) {
                    for (int m = 0; m < iSize; ++m) {
                        for (int i4 = 0; i4 < ditemsR.size(); ++i4) {
                            String a = (String)ditemsR.get(i4);
                            List datatype = (List)params.getObject("DATA_TYPE");
                            for (int l = 0; l < datatype.size(); ++l) {
                                DataElementInfo dataElementInfo = (DataElementInfo)fetchtype.get(m);
                                Object[] args = new Object[14];
                                args[0] = new Variant((Object)params.getString("ORG_TREE_Number"));
                                args[1] = new Variant((Object)info.getNumber());
                                args[2] = new Variant((Object)"");
                                args[3] = new Variant((Object)params.getString("CURRENCY"));
                                args[4] = new Variant(arrItemList.get(j2));
                                args[5] = new Variant((Object)a);
                                args[6] = new Variant((Object)params.getString("PERIOD_TYPE_NAME"));
                                args[7] = new Variant(period.year);
                                args[8] = new Variant(period.period);
                                args[9] = new Variant(period.period);
                                args[10] = new Variant((Object)"MULTIDYNAMICNORMALREPORT");
                                args[11] = new Variant((Object)dataElementInfo.getNumber());
                                ValueTypeEnum valueType = (ValueTypeEnum)((Object)datatype.get(l));
                                args[12] = new Variant((Object)valueType.getName());
                                args[13] = new Variant(params.getBoolean("ADJUST"));
                                Parameter param = new Parameter(new Object[]{args}, "sheetmd");
                                dyparams.add(param);
                            }
                        }
                    }
                }
            }
        }
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"16_RptMultiCslAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) + (System.currentTimeMillis() - b)));
        b = System.currentTimeMillis();
        List result = (List)multiDyna.getMuitlDynaItemData(dyparams);
        logger.info((Object)(dyparams.size() + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"17_RptMultiCslAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) + (System.currentTimeMillis() - b)));
        ArrayList ps = new ArrayList();
        b = System.currentTimeMillis();
        HashMap<String, Integer> dataEle = new HashMap<String, Integer>();
        sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tableName).append(" (FOrgUnitID, FItemNumber,FYearPeriod, FDATATYPE");
        for (j = 0; j < map.size(); ++j) {
            sql.append(",FDItem").append(j).append("Number");
        }
        for (int i5 = 0; i5 < iSize; ++i5) {
            DataElementInfo dataElementInfo = (DataElementInfo)fetchtype.get(i5);
            sql.append(",F").append(dataElementInfo.get("extNumber")).append(" ");
            dataEle.put(dataElementInfo.getNumber(), new Integer(i5));
        }
        sql.append(") values (?,?,?,?");
        for (j = 0; j < map.size() + iSize; ++j) {
            sql.append(",?");
        }
        sql.append(")");
        Connection con = super.getConnection(ctx);
        PreparedStatement pStmt = null;
        try {
            pStmt = con.prepareStatement(sql.toString());
            for (i = 0; result != null && i < result.size(); ++i) {
                ps.clear();
                Parameter row = (Parameter)result.get(i);
                if (row.getValue() == null || !(row.getValue() instanceof BigDecimal) || ((BigDecimal)row.getValue()).signum() == 0) continue;
                Object[] obj = (Object[])row.getArgs()[0];
                ArrayList<SimplePeriod> yearAndPeriod = null;
                if (isMergeByFiscalPeriod) {
                    PeriodCollection periodCollection = (PeriodCollection)params.getObject("periodCollection");
                    PeriodIterator iterator = new PeriodIterator(Integer.valueOf(obj[7].toString()), Integer.valueOf(obj[7].toString()), Integer.valueOf(obj[8].toString()), Integer.valueOf(obj[9].toString()), period_type, periodCollection, isMergeByFiscalPeriod);
                    yearAndPeriod = new ArrayList<SimplePeriod>();
                    while (iterator.hasNext()) {
                        yearAndPeriod.add(iterator.next());
                    }
                } else {
                    yearAndPeriod = RptBiUtil.getPeriodListFor13q(Integer.valueOf(obj[7].toString()), Integer.valueOf(obj[8].toString()), Integer.valueOf(obj[7].toString()), Integer.valueOf(obj[9].toString()), period_type);
                }
                for (int k = 0; k < yearAndPeriod.size(); ++k) {
                    SimplePeriod period = (SimplePeriod)yearAndPeriod.get(k);
                    pStmt.setString(1, obj[1].toString());
                    pStmt.setString(2, ((Variant)obj[4]).getValue().toString());
                    pStmt.setString(3, period.generateID());
                    pStmt.setInt(4, 1);
                    String dyItemNumber = (String)((Variant)obj[5]).getValue();
                    String[] dyNumberArr = dyItemNumber.split(";");
                    for (int j3 = 0; j3 < dyNumberArr.length; ++j3) {
                        String dyNumber = dyNumberArr[j3];
                        pStmt.setString(5 + j3, dyNumber);
                    }
                    int init = 5 + dyNumberArr.length;
                    for (int j4 = 0; j4 < dataEle.size(); ++j4) {
                        String temp = obj[11].toString();
                        if (j4 == (Integer)dataEle.get(temp)) {
                            pStmt.setBigDecimal(init + j4, (BigDecimal)row.getValue());
                            continue;
                        }
                        pStmt.setObject(init + j4, null);
                    }
                    pStmt.addBatch();
                }
            }
            pStmt.executeBatch();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)pStmt, (Connection)con);
        }
        sql = new StringBuffer("SELECT FOrgUnitID, FItemNumber, ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"18_RptMultiCslAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) + (System.currentTimeMillis() - b)));
        for (i = 0; i < map.size(); ++i) {
            sql.append("FDItem");
            sql.append(i);
            sql.append("Number,");
        }
        sql.append(" FYearPeriod, FDATATYPE ");
        for (i = 0; i < iSize; ++i) {
            DataElementInfo dataElementInfo = (DataElementInfo)fetchtype.get(i);
            sql.append(",SUM(F").append(dataElementInfo.get("extNumber")).append(") AS F").append(dataElementInfo.get("extNumber"));
        }
        sql.append(" FROM ").append(tableName).append(" GROUP BY FOrgUnitID, FItemNumber,");
        for (i = 0; i < map.size(); ++i) {
            sql.append("FDItem");
            sql.append(i);
            sql.append("Number,");
        }
        sql.append(" FYearPeriod, FDATATYPE ");
        return sql.toString();
    }

    private static List getResult(List list) {
        List result = null;
        List tempResult = null;
        if (list.size() == 1) {
            return RptXDynaItemAnalysisFacadeControllerBean.getResult((List)list.get(0), null);
        }
        Iterator it = list.iterator();
        if (it.hasNext()) {
            ArrayList l = (ArrayList)it.next();
            it.remove();
            for (int i = 0; i < l.size(); ++i) {
                if (list.size() == 1) {
                    if (result == null) {
                        result = RptXDynaItemAnalysisFacadeControllerBean.getResult((ArrayList)list.get(0), ((DynaItemInfo)l.get(i)).getDitemNumber());
                        continue;
                    }
                    result.addAll(RptXDynaItemAnalysisFacadeControllerBean.getResult((ArrayList)list.get(0), ((DynaItemInfo)l.get(i)).getDitemNumber()));
                    continue;
                }
                --i;
                tempResult = RptXDynaItemAnalysisFacadeControllerBean.getResult(list);
                list = new ArrayList<List>();
                list.add(tempResult);
            }
        }
        return result;
    }

    private static List getResult(List list, String s) {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            String dynaNumber;
            Object o = list.get(i);
            if (o instanceof String) {
                dynaNumber = (String)o;
            } else {
                DynaItemInfo temp = (DynaItemInfo)list.get(i);
                dynaNumber = temp.getDitemNumber();
            }
            if (s != null) {
                l.add(s + ";" + dynaNumber);
                continue;
            }
            l.add(dynaNumber);
        }
        return l;
    }

    private String makeMdx(boolean singlePeriod, boolean singleOrg, boolean show_org_sum, boolean show_period_sum, RptParams params, Context ctx) {
        boolean showTypeSum = params.getBoolean("SHOW_TYPE_SUM");
        boolean showSumUp = params.getBoolean("SHOW_SUM_UP");
        Map map = (Map)params.getObject("DITEMS");
        StringBuffer sb = new StringBuffer();
        if (!singlePeriod && show_period_sum) {
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"7_RptCellAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()));
        }
        if (!singleOrg && show_org_sum) {
            if (sb.length() < 1) {
                sb.append("With ");
            }
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"8_RptCellAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()));
        }
        if (showTypeSum) {
            if (sb.length() < 1) {
                sb.append("With ");
            }
            for (int i = 0; i < map.values().size(); ++i) {
                sb.append("  Member [DItem").append(i).append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"19_RptMultiCslAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale())).append(i).append("].members)' ");
            }
        }
        List data_type = (List)params.getObject("DATA_TYPE");
        sb.append("SELECT ");
        if (showSumUp) {
            sb.append(singlePeriod ? "" : "{" + (show_period_sum ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"20_RptMultiCslAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) : "") + "Period.Members}*");
        } else {
            sb.append(singlePeriod ? "" : "{Period.Members" + (show_period_sum ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"10_RptCellAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) : "") + "}*");
        }
        sb.append("Item.Members*Measures.Members");
        if (data_type.size() > 1) {
            sb.append("* DataType.Members");
        }
        sb.append(" ON COLUMNS, ");
        if (showSumUp) {
            sb.append(singleOrg ? "" : "{" + (show_org_sum ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"21_RptMultiCslAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) : "") + "Orgs.Members}*");
        } else {
            sb.append(singleOrg ? "" : "{Orgs.Members" + (show_org_sum ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"9_RptCellAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) : "") + "}*");
        }
        for (int i = 0; i < map.values().size(); ++i) {
            if (i != 0) {
                sb.append("*");
            }
            sb.append("{");
            if (showTypeSum && showSumUp) {
                sb.append("[DItem").append(i).append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"22_RptMultiCslAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            }
            sb.append("DItem").append(i).append(".Members");
            if (showTypeSum && !showSumUp) {
                sb.append(",[DItem").append(i).append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"23_RptMultiCslAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            }
            sb.append("}");
        }
        sb.append(" ON ROWS FROM Fact");
        return sb.toString();
    }
}

