/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt;

import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class CSLConditionBase
implements Serializable,
Cloneable {
    public static final String KEY = "CSLBaseCondition";
    public static final String ALL_CURRENCY = "AllCurrency";
    private String orgTreeNumber = null;
    private String itemNumberStart = null;
    private String itemNumberEnd = null;
    private int itemNumberLevelStart = -1;
    private int itemNumberLevelEnd = -1;
    private int rptYearStart = -1;
    private int rptYearEnd = -1;
    private int rptPeriodStart = -1;
    private int rptPeriodEnd = -1;
    private int debitOrCredit = -1;
    private String currencyID = null;
    private String currencyName = null;
    private String itemId = null;

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getOrgTreeNumber() {
        return this.orgTreeNumber;
    }

    public void setOrgTreeNumber(String v) {
        this.orgTreeNumber = v;
    }

    public String getItemNumberStart() {
        return this.itemNumberStart;
    }

    public void setItemNumberStart(String itemNumber) {
        this.itemNumberStart = itemNumber;
    }

    public boolean isInputCodeStart() {
        return this.itemNumberStart != null && this.itemNumberStart.length() > 0;
    }

    public String getItemNumberEnd() {
        return this.itemNumberEnd;
    }

    public void setItemNumberEnd(String itemNumber) {
        this.itemNumberEnd = itemNumber;
    }

    public boolean isInputNumberEnd() {
        return this.itemNumberEnd != null && this.itemNumberEnd.length() > 0;
    }

    public int getItemNumberLevelStart() {
        return this.itemNumberLevelStart;
    }

    public void setItemNumberLevelStart(int level) {
        this.itemNumberLevelStart = level;
    }

    public int getItemNumberLevelEnd() {
        return this.itemNumberLevelEnd;
    }

    public void setItemNumberLevelEnd(int level) {
        this.itemNumberLevelEnd = level;
    }

    public int getDebitOrCredit() {
        return this.debitOrCredit;
    }

    public void setDebitOrCredit(int v) {
        this.debitOrCredit = v;
    }

    public int getRptYearStart() {
        return this.rptYearStart;
    }

    public void setRptYearStart(int year) {
        this.rptYearStart = year;
    }

    public int getRptYearEnd() {
        return this.rptYearEnd;
    }

    public void setRptYearEnd(int year) {
        this.rptYearEnd = year;
    }

    public int getRptPeriodStart() {
        return this.rptPeriodStart;
    }

    public void setRptPeriodStart(int period) {
        this.rptPeriodStart = period;
    }

    public int getRptPeriodEnd() {
        return this.rptPeriodEnd;
    }

    public void setRptPeriodEnd(int period) {
        this.rptPeriodEnd = period;
    }

    public int getRptPeriodYearStart() {
        return RPTDateUtil.getPeriodYear(this.getRptYearStart(), this.getRptPeriodStart());
    }

    public int getRptPeriodYearEnd() {
        return RPTDateUtil.getPeriodYear(this.getRptYearEnd(), this.getRptPeriodEnd());
    }

    public String getCurrency() {
        return this.currencyID;
    }

    public void setCurrency(String id) {
        this.currencyID = id;
    }

    public boolean isAllCurrency() {
        return ALL_CURRENCY.equals(this.currencyID);
    }

    public Map toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getClass().getName(), this.getClass().getName());
        map.put("OrgBound", this.getOrgTreeNumber());
        map.put("RptYearStart", new Integer(this.getRptYearStart()));
        map.put("RptYearEnd", new Integer(this.getRptYearEnd()));
        map.put("RptPeriodStart", new Integer(this.getRptPeriodStart()));
        map.put("RptPeriodEnd", new Integer(this.getRptPeriodEnd()));
        map.put("ItemNumberStart", this.getItemNumberStart());
        map.put("ItemNumberEnd", this.getItemNumberEnd());
        map.put("ItemNumberLevelStart", new Integer(this.getItemNumberLevelStart()));
        map.put("ItemNumberLevelEnd", new Integer(this.getItemNumberLevelEnd()));
        map.put("DebitOrCredit", new Integer(this.getDebitOrCredit()));
        map.put("Currency", this.getCurrency());
        return map;
    }

    public CSLConditionBase(Map map) throws CloneNotSupportedException {
        if (map == null) {
            return;
        }
        if (map.get(this.getClass().getName()) == null) {
            throw new CloneNotSupportedException();
        }
        this.setOrgTreeNumber((String)map.get("OrgBound"));
        this.setRptYearStart(this.getInt((Integer)map.get("RptYearStart")));
        this.setRptYearEnd(this.getInt((Integer)map.get("RptYearEnd")));
        this.setRptPeriodStart(this.getInt((Integer)map.get("RptPeriodStart")));
        this.setRptPeriodStart(this.getInt((Integer)map.get("RptPeriodEnd")));
        this.setItemNumberStart((String)map.get("ItemNumberStart"));
        this.setItemNumberEnd((String)map.get("ItemNumberEnd"));
        this.setItemNumberLevelStart(this.getInt((Integer)map.get("ItemNumberLevelStart")));
        this.setItemNumberLevelEnd(this.getInt((Integer)map.get("ItemNumberLevelEnd")));
        this.setDebitOrCredit(this.getInt((Integer)map.get("DebitOrCredit")));
        this.setCurrency((String)map.get("Currency"));
    }

    public CSLConditionBase() {
    }

    protected boolean getBoolean(Boolean value) {
        return value == null ? false : value;
    }

    protected int getInt(Integer value) {
        return value == null ? 0 : value;
    }

    public String getCurrencyName() {
        return this.currencyName;
    }

    public void setCurrencyName(String cryName) {
        this.currencyName = cryName;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String item) {
        this.itemId = item;
    }

    public void clearData() {
        this.orgTreeNumber = null;
        this.itemNumberStart = null;
        this.itemNumberEnd = null;
        this.itemNumberLevelStart = -1;
        this.itemNumberLevelEnd = -1;
        this.rptYearStart = -1;
        this.rptYearEnd = -1;
        this.rptPeriodStart = -1;
        this.rptPeriodEnd = -1;
        this.debitOrCredit = -1;
        this.currencyID = null;
        this.currencyName = null;
        this.itemId = null;
    }
}

