/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EliminationTaoPrintProvider
implements BOSQueryDelegate {
    private Set ids = null;
    private IMetaDataPK qpk = null;
    private FilterInfo filter = null;
    private ICSLContext ctx = CSLContextHelper.getCSLContext();
    private UserInfo curUser = SysContext.getSysContext().getCurrentUserInfo();
    private CtrlUnitInfo ctrlUnit = null;

    public EliminationTaoPrintProvider(Set id, IMetaDataPK qpk) throws BOSException {
        this.ids = id;
        this.qpk = qpk;
        this.intCtrlUnit();
    }

    public EliminationTaoPrintProvider(List id, IMetaDataPK qpk) throws BOSException {
        this.ids = new HashSet(id);
        this.qpk = qpk;
        this.intCtrlUnit();
    }

    private void intCtrlUnit() throws BOSException {
        String s = "select name where level=1";
        CtrlUnitCollection col = CtrlUnitFactory.getRemoteInstance().getCtrlUnitCollection(s);
        if (col == null || col.size() == 0) {
            this.ctrlUnit = null;
        } else if (col != null && col.size() > 0) {
            CtrlUnitInfo info;
            this.ctrlUnit = info = col.get(0);
        }
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = null;
        try {
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.qpk);
            exec.option().isAutoTranslateEnum = true;
            exec.option().isAutoTranslateBoolean = true;
            EntityViewInfo ev = new EntityViewInfo();
            if (this.filter == null) {
                this.filter = new FilterInfo();
                if (this.ids.size() == 1) {
                    this.filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.ids.toArray()[0].toString(), CompareType.EQUALS));
                } else {
                    this.filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.ids, CompareType.INCLUDE));
                }
            }
            ev.setFilter(this.filter);
            exec.setObjectView(ev);
            iRowSet = exec.executeQuery();
            while (iRowSet.next()) {
                this.handleOrgUnit(iRowSet);
                this.handleCurUser(iRowSet);
                this.handleCtrlUnit(iRowSet);
            }
            iRowSet.beforeFirst();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e);
        }
        return iRowSet;
    }

    private void handleOrgUnit(IRowSet iRowSet) throws BOSException, SQLException {
        OrgUnitInfo uif = this.ctx.getCurOrgGroup();
        String orgUnit = iRowSet.getString("orgUnit.name");
        if (orgUnit != null) {
            iRowSet.updateString("curOrgUnit", orgUnit);
        } else if (uif != null) {
            iRowSet.updateString("curOrgUnit", uif.getName());
        } else {
            iRowSet.updateString("curOrgUnit", "");
        }
    }

    private void handleCurUser(IRowSet iRowSet) throws SQLException {
        if (this.curUser != null) {
            iRowSet.updateString("printPerson", this.curUser.getName());
        }
    }

    private void handleCtrlUnit(IRowSet iRowSet) throws SQLException {
        if (this.ctrlUnit != null) {
            iRowSet.updateString("rootCUName", this.ctrlUnit.getName());
        } else {
            iRowSet.updateString("rootCUName", "");
        }
    }

    private void handleDate(IRowSet iRowSet) throws SQLException, ParseException {
    }

    public FilterInfo getFilter() {
        return this.filter;
    }

    public void setFilter(FilterInfo filter) {
        this.filter = filter;
    }
}

