/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt;

import com.kingdee.bos.Context;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class RPTDate13Util {
    private static Calendar calendar = Calendar.getInstance();

    public static Date getPrePeriodLastDayByDate(Date date, int period, RptPeriodTypeEnum periodType, boolean isSupport13Period) {
        if (!isSupport13Period) {
            return RPTDateUtil.getPrePeriodLastDayByDate(date, periodType);
        }
        calendar.setTime(date);
        if (RPTDate13Util.isPeriod13(period, periodType)) {
            return RPTDate13Util.getPeriodLastDate(calendar.get(1), calendar.get(2) + 1, periodType);
        }
        return RPTDateUtil.getPrePeriodLastDayByDate(date, periodType);
    }

    public static int[] getPreYearAndPeriod(int iYear, int iPeriod, RptPeriodTypeEnum periodType, boolean isSupport13Period) {
        if (!isSupport13Period) {
            return RPTDateUtil.getPrevYearAndPeriod(iYear, iPeriod, periodType);
        }
        if (RptPeriodTypeEnum.MONTHLY.equals((Object)periodType) && iPeriod == 1) {
            int[] result = new int[]{iYear - 1, 13};
            return result;
        }
        return RPTDateUtil.getPrevYearAndPeriod(iYear, iPeriod, periodType);
    }

    public static void getRptYearAndPeriod(ItemFormula srcFormula, int RptYear, int RptPeriod, RptPeriodTypeEnum RptPeriodType, boolean isSupport13Period) {
        if (srcFormula == null) {
            return;
        }
        if (!isSupport13Period) {
            RPTDateUtil.getRptYearAndPeriod(srcFormula, RptYear, RptPeriod, RptPeriodType);
        } else if (RptPeriodTypeEnum.MONTHLY.equals((Object)RptPeriodType)) {
            int offsetPeriod;
            int offsetYear = srcFormula.getYearOffSet();
            int[] calAbsYearPeriod = RPTDate13Util.getAbsYearPeriod(RptYear, RptPeriod, offsetYear, offsetPeriod = srcFormula.getPeriodOffSet());
            int p = calAbsYearPeriod[1] == 13 ? 12 : calAbsYearPeriod[1];
            Date date = RPTDate13Util.getPeriodLastDate(calAbsYearPeriod[0], p, RptPeriodType);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            srcFormula.putExt("10", String.valueOf(calAbsYearPeriod[0]));
            srcFormula.putExt("11", String.valueOf(calAbsYearPeriod[1]));
            srcFormula.putExt("12", format.format(date).toString());
        } else {
            RPTDateUtil.getRptYearAndPeriod(srcFormula, RptYear, RptPeriod, RptPeriodType);
        }
    }

    public static int[] getAbsYearPeriod(int RptYear, int RptPeriod, int offsetYear, int offsetPeriod) {
        if (offsetYear > 1000) {
            offsetYear -= RptYear;
        }
        if (offsetPeriod > 0) {
            offsetPeriod -= RptPeriod;
        }
        int[] calAbsYearPeriod = RPTDate13Util.calAbsYearPeriodOf13ByOffset(RptYear, RptPeriod, offsetYear, offsetPeriod);
        return calAbsYearPeriod;
    }

    public static int[] calAbsYearPeriodOf13ByOffset(int RptYear, int RptPeriod, int offsetYear, int offsetPeriod) {
        int y = RptYear + offsetYear;
        int p = RptPeriod + offsetPeriod;
        if (p > 13) {
            int oy = p / 13;
            int op = p % 13;
            y += oy;
            p = op;
        } else if (p == 0) {
            p = 13;
        } else if (p < 0) {
            if (p < -13) {
                int oy = offsetPeriod / 13;
                int op = offsetPeriod % 13;
                y += oy;
                if (Math.abs(op) > RptPeriod) {
                    --y;
                    p = op + RptPeriod + 13;
                } else {
                    p = op + RptPeriod;
                }
            } else {
                --y;
                p = 13 + p;
            }
        }
        return new int[]{--y, p};
    }

    public static int[] getRptYearAndPeriod(int RptYear, int RptPeriod, int RptPeriodType, int offsetYear, int offsetPeriod, boolean isSupport13Period) {
        if (!isSupport13Period) {
            if (3 == RptPeriodType && RptPeriod > 12) {
                RptPeriod = 12;
            }
            return RPTDateUtil.getRptYearAndPeriod(RptYear, RptPeriod, RptPeriodType, offsetYear, offsetPeriod);
        }
        if (3 == RptPeriodType) {
            return RPTDate13Util.getAbsYearPeriod(RptYear, RptPeriod, offsetYear, offsetPeriod);
        }
        return RPTDateUtil.getRptYearAndPeriod(RptYear, RptPeriod, RptPeriodType, offsetYear, offsetPeriod);
    }

    public static int[] getRptYearAndPeriod(int RptYear, int RptPeriod, int RptPeriodType, int offsetYear, int offsetPeriod, Context ctx) {
        if (CslRptUtil.isSupport13Period(ctx)) {
            if (3 == RptPeriodType) {
                return RPTDate13Util.getAbsYearPeriod(RptYear, RptPeriod, offsetYear, offsetPeriod);
            }
            return RPTDateUtil.getRptYearAndPeriod(RptYear, RptPeriod, RptPeriodType, offsetYear, offsetPeriod);
        }
        return RPTDateUtil.getRptYearAndPeriod(RptYear, RptPeriod, RptPeriodType, offsetYear, offsetPeriod);
    }

    public static int[] getStartAndEndPeriod(int iYear, int iStartPeriod, int iEndPeriod, int iPeriodType, int iOffsetYear, int iOffsetPeriod, boolean isSupport13Period) {
        if (isSupport13Period && 3 == iPeriodType) {
            int endPeriod;
            int endYear;
            int startPeriod;
            int startYear;
            int[] start = RPTDate13Util.getAbsYearPeriod(iYear, iStartPeriod, iOffsetYear, iOffsetPeriod);
            int[] end = RPTDate13Util.getAbsYearPeriod(iYear, iEndPeriod, iOffsetYear, iOffsetPeriod);
            if (start == null) {
                startYear = iYear;
                startPeriod = iStartPeriod;
            } else {
                startYear = start[0];
                startPeriod = start[1];
            }
            if (end == null) {
                endYear = iYear;
                endPeriod = iEndPeriod;
            } else {
                endYear = end[0];
                endPeriod = end[1];
            }
            int[] result = new int[]{startYear, startPeriod, endYear, endPeriod};
            return result;
        }
        return RPTDateUtil.getStartAndEndPeriod(iYear, iStartPeriod, iEndPeriod, iPeriodType, iOffsetYear, iOffsetPeriod);
    }

    public static int[] getRptYearAndPeriod(int RptYear, int RptPeriod, int RptPeriodType, int offsetYear, int offsetPeriodBegin, int offsetPeriodEnd, boolean isSupport13Period) {
        if (isSupport13Period && 3 == RptPeriodType) {
            int[] periodBegin = RPTDate13Util.getAbsYearPeriod(RptYear, RptPeriod, offsetYear, offsetPeriodBegin);
            int[] periodEnd = RPTDate13Util.getAbsYearPeriod(RptYear, RptPeriod, offsetYear, offsetPeriodEnd);
            int resultYear = periodEnd[0];
            int resultPeriodBegin = periodBegin[1];
            int resultPeriodEnd = periodEnd[1];
            int[] result = new int[]{resultYear, resultPeriodBegin, resultPeriodEnd};
            return result;
        }
        return RPTDateUtil.getRptYearAndPeriod(RptYear, RptPeriod, RptPeriodType, offsetYear, offsetPeriodBegin, offsetPeriodEnd);
    }

    public static Date getPeriodLastDate(int year, int period, RptPeriodTypeEnum periodType) {
        if (3 == periodType.getValue() && period > 13) {
            period = 12;
        }
        return RPTDateUtil.getPeriodLastDate(year, period, periodType);
    }

    public static List getRptYearAndPeriodAndDate(int RptYear, int RptPeriod, int RptPeriodType, int offsetYear, int offsetPeriod, boolean isSupport13Period) {
        ArrayList<Comparable<Integer>> result = new ArrayList<Comparable<Integer>>();
        int[] yearAndPeriod = RPTDate13Util.getRptYearAndPeriod(RptYear, RptPeriod, RptPeriodType, offsetYear, offsetPeriod, isSupport13Period);
        Integer year = new Integer(yearAndPeriod[0]);
        Integer period = new Integer(yearAndPeriod[1]);
        Date date = RPTDate13Util.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)RptPeriodType));
        result.add(0, year);
        result.add(1, period);
        result.add(2, date);
        return result;
    }

    public static boolean isPeriod13(int period, RptPeriodTypeEnum periodType) {
        if (periodType == null) {
            return false;
        }
        return periodType.equals((Object)RptPeriodTypeEnum.MONTHLY) && period == 13;
    }

    public static int getPeriods(int year, RptPeriodTypeEnum periodType, boolean isSupport13Period) {
        int periods = 0;
        Date date = null;
        try {
            date = BatchHelper.dateFormat.parse(year + "-12-31");
        }
        catch (ParseException e) {
            return periods;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (periodType.getValue() == 3) {
            periods = isSupport13Period ? 13 : 12;
        } else if (periodType.getValue() == 4) {
            periods = 4;
        } else if (periodType.getValue() == 6) {
            periods = 1;
        } else if (periodType.getValue() == 2) {
            periods = calendar.get(3);
        } else if (periodType.getValue() == 1) {
            periods = calendar.get(6);
        }
        return periods;
    }
}

