/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorResultProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.service.ServiceExecutionException;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.service.OrgPermissionService;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.fi.gr.cslrpt.AbstractAdjustEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.AcctItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.AdjustCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustDetailsEnum;
import com.kingdee.eas.fi.gr.cslrpt.AdjustDynamicItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustDynamicItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustDynamicItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustEntryDetailsCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustEntryDetailsInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustTempleCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustTempleEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustTempleFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustTempleInfo;
import com.kingdee.eas.fi.gr.cslrpt.ArchivedStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CslReduceRpcFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.DebitOrCreditEnum;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IAdjust;
import com.kingdee.eas.fi.gr.cslrpt.IAdjustTemple;
import com.kingdee.eas.fi.gr.cslrpt.IItemDataProvider;
import com.kingdee.eas.fi.gr.cslrpt.IsCitedByLaterEnum;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTEffectItemEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemControlEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.RptItemRelationshipFactory;
import com.kingdee.eas.fi.gr.cslrpt.RptReceivedInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractAdjustControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.app.CslElimUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.cslrpt.util.CslOrgTreeUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.cslrpt.util.RelatingAdjustElimHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.gr.dynamic.DynaItemTypeEnum;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AdjustControllerBean
extends AbstractAdjustControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.AdjustControllerBean");
    private static final long serialVersionUID = 913756090319819151L;
    private static final String SPLIT = ";";
    private boolean hasCodeRule = false;
    private Book book = null;

    private void initCodeRule(Context ctx) throws EASBizException, BOSException {
        this.hasCodeRule = CSLServerHelper.isHasCodingRuleByOrg(ctx, (IObjectValue)new AdjustInfo(), CSLServerHelper.getRootOrgIDForRootCU(ctx));
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        this.saveItemData(ctx, pk, (AdjustInfo)model);
        super._passAudit(ctx, pk, model);
        this.auditLog(ctx, (AdjustInfo)model);
    }

    private DynaItemTypeEnum getDynaItemType(Context ctx, String typeNumber, Map dynaItemTypes) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)typeNumber)) {
            return DynaItemTypeEnum.ManualImport;
        }
        DynaItemTypeEnum type = null;
        if (dynaItemTypes.containsKey(typeNumber)) {
            type = (DynaItemTypeEnum)dynaItemTypes.get(typeNumber);
        } else {
            String sql = "select FAsstHGAttribute from t_bd_asstActType where FNumber = ?";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{typeNumber});
            try {
                if (rowSet.next()) {
                    String asstType = rowSet.getString("FAsstHGAttribute");
                    type = asstType.equals("companyOrg") ? DynaItemTypeEnum.Company : (asstType.equals("customer") ? DynaItemTypeEnum.Custom : (asstType.equals("provider") ? DynaItemTypeEnum.Provider : DynaItemTypeEnum.Other));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            dynaItemTypes.put(typeNumber, type);
        }
        return type;
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        this.clearItemData(ctx, pk, (AdjustInfo)model);
        super._unpassAudit(ctx, pk, model);
        this.unauditLog(ctx, (AdjustInfo)model);
    }

    protected boolean _checkLineExist(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return false;
    }

    protected SystemEnum _getOwnedSys(Context ctx) throws BOSException, EASBizException {
        return SystemEnum.CORPORATIONMANAGEMENT;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, (AdjustInfo)model);
        this.removeHideEntries((AdjustInfo)model);
        this.autoCreateAdjust(ctx, (AdjustInfo)model);
        this.addNewLog(ctx, (AdjustInfo)model);
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    private void autoCreateAdjust(Context ctx, AdjustInfo adjustInfo) throws EASBizException, BOSException {
        boolean param = Boolean.valueOf(ParamManager.getParamValue((Context)ctx, null, (String)"GR_CSL_AutoBuildTotal"));
        if (param) {
            this.autoAdjust(ctx, adjustInfo);
        } else {
            this.autoAdjustParentItems(ctx, adjustInfo);
            this.autoCreateRelationshipItems(ctx, adjustInfo);
            this.doSpecialRptItem(ctx, (IObjectValue)adjustInfo);
        }
    }

    private void autoCreateRelationshipItems(Context ctx, AdjustInfo adjustInfo) throws BOSException, EASBizException {
        if (adjustInfo == null || adjustInfo.getEntries() == null) {
            return;
        }
        Map itemMap = RptItemRelationshipFactory.getLocalInstance(ctx).getItemRelationshipMap(2);
        RptItemRelationshipFactory.getLocalInstance(ctx).autoCreateRelationshipItems(adjustInfo, itemMap);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateCheck(ctx, model);
        super._update(ctx, pk, model);
    }

    private void addnewCheck(Context ctx, AdjustInfo model) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)model.getNumber())) {
            this.initCodeRule(ctx);
            if (!this.hasCodeRule) {
                this.checkNumberBlank(model);
            }
        }
        this._checkNumberDup(ctx, null, (IObjectValue)model);
        this.checkRptItemBlankAndDup(ctx, (IObjectValue)model);
        this.checkDebitAndCredit((IObjectValue)model, ctx);
    }

    private void updateCheck(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AdjustInfo info = (AdjustInfo)model;
        if (StringUtils.isEmpty((String)info.getNumber())) {
            this.initCodeRule(ctx);
            if (!this.hasCodeRule) {
                this.checkNumberBlank(info);
            }
        }
        this._checkNumberDup(ctx, null, model);
        this.checkRptItemBlankAndDup(ctx, model);
        this.checkDebitAndCredit(model, ctx);
    }

    private void deleteCheck(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        AdjustInfo info = this.getAdjustInfo(ctx, pk);
        EnactmentServiceProxy iEnactmentService = new EnactmentServiceProxy();
        AssignmentInfo[] assignments = iEnactmentService.checkAssignmentInfos(info.getId().toString(), ctx.getCaller().toString());
        boolean isInWorkflow = false;
        isInWorkflow = assignments != null && assignments.length != 0;
        if (isInWorkflow) {
            throw new AdjustException(AdjustException.NOT_DELETE_INWF);
        }
    }

    private void checkRptItemBlankAndDup(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        AdjustInfo info = (AdjustInfo)model;
        AdjustEntryCollection adjustEntries = info.getEntries();
        if (adjustEntries == null) {
            return;
        }
        this.fixRptItemNumber(ctx, info);
        ArrayList<String> list = new ArrayList<String>(adjustEntries.size());
        RPTItemInfo rptItem = null;
        AdjustEntryInfo adjustEntryInfo = null;
        String keyAdjust = "GR_CSL_AllowAdjustRRTM";
        Object value = CslRptUtil.getParamValue(ctx, null, keyAdjust);
        for (int i = 0; i < adjustEntries.size(); ++i) {
            adjustEntryInfo = adjustEntries.get(i);
            rptItem = adjustEntryInfo.getItem();
            if (rptItem != null && (rptItem.getId() == null || StringUtils.isEmpty((String)rptItem.getId().toString()))) {
                throw new AdjustException(AdjustException.RPTITEM_BLANK);
            }
            if (!"false".equals(value) || !adjustEntryInfo.isIsVisible()) continue;
            String key = adjustEntryInfo.getItem().getNumber();
            if (list.contains(key = key + "," + adjustEntryInfo.getDataElement())) {
                ArrayList<Object> exParam = new ArrayList<Object>(3);
                exParam.add(new Integer(i + 1));
                exParam.add(rptItem.getNumber());
                exParam.add(DataElementProvider.getDataElementName(ctx, adjustEntryInfo.getDataElement()));
                throw new AdjustException(AdjustException.RPTITEMDATAELEMENT_DUP, exParam.toArray());
            }
            list.add(key);
        }
    }

    private void checkDebitAndCredit(IObjectValue model, Context ctx) throws EASBizException {
        AdjustInfo info = (AdjustInfo)model;
        if (info.getEntries() != null && info.getEntries().size() > 0) {
            AdjustEntryCollection entry = info.getEntries();
            for (int i = 0; i < entry.size(); ++i) {
                AdjustEntryInfo lineInfo = entry.get(i);
                String summary = lineInfo.getSummary();
                if (summary != null && summary.length() > 1000) {
                    throw new EASBizException(new NumericExceptionSubItem("001", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"92_AdjustControllerBean", (Locale)ctx.getOriginLocale())));
                }
                BigDecimal bgDebit = lineInfo.getDebit();
                BigDecimal bgCredit = lineInfo.getCredit();
                if (bgDebit == null || bgCredit == null) continue;
                throw new AdjustException(AdjustException.DC_ALL_HAVE);
            }
        }
    }

    @Override
    protected Map _audit(Context ctx, List list) throws BOSException, EASBizException {
        HashMap auditFailMap = new HashMap();
        this.checkAdjustEntryByParam(ctx, auditFailMap, true, list);
        StringBuilder failSbInfo = new StringBuilder();
        HashMap<String, Object> itemErrors = new HashMap<String, Object>(4);
        ArrayList<String> auditedRecords = new ArrayList<String>();
        ArrayList<String> successItemNumber = new ArrayList<String>();
        for (IObjectPK pk : list) {
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("*"));
            sc.add(new SelectorItemInfo("orgunit.name"));
            sc.add(new SelectorItemInfo("entries.*"));
            sc.add(new SelectorItemInfo("entries.item.*"));
            AdjustInfo info = this.getAdjustInfo(ctx, pk, sc);
            UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
            if (info.getCheckedStatus() == CheckedStatusEnum.AUDITED) {
                auditedRecords.add(info.getNumber());
                continue;
            }
            if (auditFailMap.containsKey(pk.toString())) {
                failSbInfo.append(auditFailMap.get(pk.toString())).append("\n");
                continue;
            }
            info.setAuditor(user);
            info.setAuditDate(new Timestamp(System.currentTimeMillis()));
            this._passAudit(ctx, pk, (IObjectValue)info);
            successItemNumber.add(info.getNumber());
        }
        if (failSbInfo.length() > 0) {
            itemErrors.put("failInfo", failSbInfo.toString());
        }
        if (!auditedRecords.isEmpty()) {
            itemErrors.put("Audited", auditedRecords);
        }
        if (!successItemNumber.isEmpty() && list.size() > successItemNumber.size()) {
            itemErrors.put("SUCCESS", successItemNumber);
        }
        return itemErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAdjustEntryByParam(Context ctx, Map failMap, boolean unAudit, List list) {
        int adjustEntryCheckCslRptParam = CSLParamUtil.getParamAdjustEntryCheckCslRpt(ctx);
        if (adjustEntryCheckCslRptParam == 0 || list == null || list.isEmpty()) {
            return;
        }
        ParamTempTblService cmpParamSrv = null;
        try {
            AdjustInfo adjustInfo = AdjustFactory.getLocalInstance(ctx).getAdjustInfo("select orgBound where id='" + list.get(0).toString() + "'");
            boolean isSupportCrossMerger = CSLParamUtil.isSupportCrossMerger(ctx, adjustInfo.getOrgBound().getId().toString());
            if (isSupportCrossMerger) {
                return;
            }
            String info_param2 = "";
            StringBuilder sqlSb = new StringBuilder();
            sqlSb.append("select distinct adjust.fid adjustId, adjust.fnumber adjustNumber, cslRpt.fname rptname,cslRpt.fsourcetype rptsourcetype from t_csl_cslreport cslRpt\t\t\t\n");
            sqlSb.append("inner join T_CSL_Adjust adjust on adjust.fyear=cslRpt.fyear and adjust.fperiod=cslRpt.fperiod and adjust.forgboundid=cslRpt.forgtreeid and adjust.fcurrencyid=cslRpt.fcurrencyid\t\n");
            sqlSb.append("inner join T_CSL_Adjustentry adjustentry on adjustentry.fadjustid=adjust.fid\t\t\t\t\t\t\n");
            sqlSb.append("inner join t_csl_rptitem item on item.fid=adjustentry.fitemid\t\t\t\t\t\t\t\t\t\t\n");
            sqlSb.append("inner join T_ORG_Structure str on str.funitid=adjust.forgunit and adjust.forgboundid=str.ftreeid\t\n");
            sqlSb.append("inner join T_ORG_Structure parentStr on str.fparentid=parentStr.fid and parentStr.funitid=cslRpt.forgunitid\t\t\t\t\t\n");
            sqlSb.append("inner join t_csl_templetitemlist itemList on itemList.ftemplateid=cslRpt.ftemplateid and item.fnumber=itemList.fitemnumber and adjustentry.fdataelement=itemList.fdataelement and adjust.fvaluetype=itemList.fvaluetype \n");
            if (list.size() > 500) {
                HashSet<String> adjustIdSet = new HashSet<String>();
                for (int i = 0; i < list.size(); ++i) {
                    adjustIdSet.add(list.get(i).toString());
                }
                TableInfo table = new TableInfo("adjustid_temp");
                table.addColumn(new ColumnInfo("fid", "varchar(44)"));
                cmpParamSrv = new ParamTempTblService(ctx, table, adjustIdSet, null);
                String tmpTable = cmpParamSrv.getTmpTableName();
                sqlSb.append("where adjust.fid in(select fid from " + tmpTable + ")\t\t\t\t\t\t\t\t\t\t\t\n");
            } else {
                sqlSb.append("where adjust.fid in(" + CslRptUtil.collection2String(list, ",", true) + ")\t\t\t\t\t\t\n");
            }
            sqlSb.append("and cslRpt.fsourcetype in(2,3,11,12)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            if (adjustEntryCheckCslRptParam == 1) {
                sqlSb.append("and cslRpt.fauditedstatus=2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
                info_param2 = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"adjust_rpt_audit", (Locale)ctx.getOriginLocale());
            }
            String messAge = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"adjust_audit_fail", (Locale)ctx.getOriginLocale());
            String info_param1 = unAudit ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"adjust_audit", (Locale)ctx.getOriginLocale()) : ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"adjust_unaudit", (Locale)ctx.getOriginLocale());
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlSb.toString());
            while (rowSet.next()) {
                String adjustId = rowSet.getString("adjustId");
                String adjustNumber = rowSet.getString("adjustNumber");
                String rptName = rowSet.getString("rptname");
                int rptSourceType = rowSet.getInt("rptsourcetype");
                String info = MessageFormat.format(messAge, adjustNumber, info_param1, info_param2, RptSrcTypeEnum.getEnum((int)rptSourceType), rptName) + "<br/>";
                if (failMap.containsKey(adjustId)) {
                    failMap.put(adjustId, failMap.get(adjustId) + info);
                    continue;
                }
                failMap.put(adjustId, info);
            }
        }
        catch (Exception e) {
            logger.error((Object)"checkAdjustEntryByParam_error:", (Throwable)e);
        }
        finally {
            if (cmpParamSrv != null) {
                cmpParamSrv.release();
            }
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk, IObjectValue adjustInfo, IObjectPK userPK) throws EASBizException, BOSException {
        AdjustInfo info = (AdjustInfo)adjustInfo;
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("entries.*"));
        sc.add(new SelectorItemInfo("entries.item.*"));
        info = (AdjustInfo)AdjustFactory.getLocalInstance(ctx).getBillBaseInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getId().toString())), sc);
        IUser ie = UserFactory.getLocalInstance((Context)ctx);
        UserInfo user = (UserInfo)ie.getValue(userPK);
        if (info.getCheckedStatus() == CheckedStatusEnum.AUDITED) {
            throw new AdjustException(AdjustException.ALL_HAVE_AUDITED);
        }
        info.setAuditor(user);
        info.setAuditDate(new Timestamp(System.currentTimeMillis()));
        this._passAudit(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected Map _unAudit(Context ctx, List list) throws BOSException, EASBizException {
        HashMap unAuditFailMap = new HashMap();
        this.checkAdjustEntryByParam(ctx, unAuditFailMap, false, list);
        StringBuilder failSbInfo = new StringBuilder();
        Iterator iter = list.iterator();
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        HashMap<String, Object> itemErrors = new HashMap<String, Object>(4);
        ArrayList<String> unauditedRecords = new ArrayList<String>();
        ArrayList<String> archivedRecords = new ArrayList<String>();
        ArrayList<String> notSameAuditorRecords = new ArrayList<String>();
        ArrayList<String> successItemNumber = new ArrayList<String>();
        while (iter.hasNext()) {
            IObjectPK pk = (IObjectPK)iter.next();
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("*"));
            sc.add(new SelectorItemInfo("entries.*"));
            sc.add(new SelectorItemInfo("orgunit.name"));
            sc.add(new SelectorItemInfo("entries.item.*"));
            AdjustInfo info = (AdjustInfo)AdjustFactory.getLocalInstance(ctx).getBillBaseInfo(pk, sc);
            if (info.getCheckedStatus() == CheckedStatusEnum.UNAUDITED) {
                unauditedRecords.add(info.getNumber());
                continue;
            }
            if (info.getArchivedStatus() == ArchivedStatusEnum.ARCHIVED) {
                archivedRecords.add(info.getNumber());
                continue;
            }
            if (!info.getAuditor().getId().equals((Object)user.getId()) && CslRptUtil.canUnAuditCheck(ctx)) {
                notSameAuditorRecords.add(info.getNumber());
                continue;
            }
            if (unAuditFailMap.containsKey(pk.toString())) {
                failSbInfo.append(unAuditFailMap.get(pk.toString())).append("\n");
                continue;
            }
            info.setAuditor(null);
            info.setAuditDate(null);
            this._unpassAudit(ctx, pk, (IObjectValue)info);
            successItemNumber.add(info.getNumber());
        }
        if (failSbInfo.length() > 0) {
            itemErrors.put("failInfo", failSbInfo.toString());
        }
        if (!unauditedRecords.isEmpty()) {
            itemErrors.put("HaveAuditForUnaudit", unauditedRecords);
        }
        if (!archivedRecords.isEmpty()) {
            itemErrors.put("HaveArchivedForUnaudit", archivedRecords);
        }
        if (!notSameAuditorRecords.isEmpty()) {
            itemErrors.put("MustBeSameAuditorForUnaudit", notSameAuditorRecords);
        }
        if (!successItemNumber.isEmpty() && list.size() > successItemNumber.size()) {
            itemErrors.put("SUCCESS", successItemNumber);
        }
        return itemErrors;
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk, IObjectValue adjustInfo, IObjectPK userPK) throws BOSException, EASBizException {
        AdjustInfo info = (AdjustInfo)adjustInfo;
        IUser ie = UserFactory.getLocalInstance((Context)ctx);
        UserInfo user = (UserInfo)ie.getValue(userPK);
        if (info.getCheckedStatus() == CheckedStatusEnum.UNAUDITED) {
            throw new AdjustException(AdjustException.ALL_HAVE_NOT_AUDIT);
        }
        if (info.getArchivedStatus() == ArchivedStatusEnum.ARCHIVED) {
            throw new AdjustException(AdjustException.HAVE_ARCHIVED);
        }
        if (!info.getAuditor().getId().equals((Object)user.getId()) && CslRptUtil.canUnAuditCheck(ctx)) {
            throw new AdjustException(AdjustException.SAME_AUDITOR);
        }
        info.setAuditor(null);
        info.setAuditDate(null);
        this._unpassAudit(ctx, pk, (IObjectValue)info);
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        AdjustInfo info = (AdjustInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem0 = new FilterItemInfo("number", (Object)info.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem0);
        FilterItemInfo filterItem1 = new FilterItemInfo("orgBound.id", (Object)info.getOrgBound().getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem1);
        FilterItemInfo filterItem2 = new FilterItemInfo("periodType", (Object)new Integer(info.getPeriodType().getValue()), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem2);
        FilterItemInfo filterItem3 = new FilterItemInfo("year", (Object)new Integer(info.getYear()), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem3);
        FilterItemInfo filterItem4 = new FilterItemInfo("period", (Object)new Integer(info.getPeriod()), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem4);
        FilterItemInfo filterItem5 = new FilterItemInfo("dataCollectNumber", (Object)info.getDataCollectNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem5);
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and #6");
        } else {
            filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5");
        }
        boolean exist = this.exists(ctx, filter);
        if (exist) {
            throw new AdjustException(AdjustException.ADJUSTNUMBER_DUP, new Object[]{info.getNumber()});
        }
        return true;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AdjustInfo info = (AdjustInfo)model;
        if (StringUtils.isEmpty((String)info.getNumber())) {
            String strOrgID = CSLServerHelper.getRootOrgIDForRootCU(ctx);
            boolean isHasCodingRuleByOrg = CSLServerHelper.isHasCodingRuleByOrg(ctx, (IObjectValue)info, strOrgID);
            if (strOrgID != null && isHasCodingRuleByOrg) {
                String number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)info, strOrgID);
                info.setNumber(number);
            }
        }
        this.deleteAdjustDetails(ctx, (IObjectValue)info);
        IObjectPK pk = super._save(ctx, (IObjectValue)info);
        this.submitAdjustDetails(ctx, (IObjectValue)info);
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AdjustInfo info = (AdjustInfo)model;
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        String strOrgID = CSLServerHelper.getRootOrgIDForRootCU(ctx);
        boolean isHasCodingRuleByOrg = CSLServerHelper.isHasCodingRuleByOrg(ctx, (IObjectValue)info, strOrgID);
        boolean isExist = false;
        ICodingRuleManager codingRule = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        ICtrlUnit iCtrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
        if (strOrgID != null && isHasCodingRuleByOrg) {
            IFullOrgUnit IFullOrgUnit2 = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            String fullOrgUnitID = info.getOrgUnit().getId().toString();
            FullOrgUnitInfo fullOrgUnitInfo = IFullOrgUnit2.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(fullOrgUnitID));
            String fullOrgUnitCuID = fullOrgUnitInfo.getCU().getId().toString();
            CtrlUnitInfo cuInfo = iCtrlUnit.getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(fullOrgUnitCuID));
            fullOrgUnitInfo.setCU(cuInfo);
            info.setOrgUnit(fullOrgUnitInfo);
            if (codingRule.isModifiable((IObjectValue)info, strOrgID) && !StringUtils.isEmpty((String)info.getNumber())) {
                if (info.containsKey("isNumberModify") && !info.getBoolean("isNumberModify")) {
                    codingRule.getNumber((IObjectValue)info, strOrgID);
                }
            } else if (codingRule.isAddView((IObjectValue)info, strOrgID)) {
                // empty if block
            }
            if (StringUtils.isEmpty((String)info.getNumber())) {
                String number = codingRule.getNumber((IObjectValue)info, strOrgID);
                info.setNumber(number);
            }
        }
        if (info.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))) {
            this.removeHideEntries((AdjustInfo)model);
            this.autoCreateAdjust(ctx, (AdjustInfo)model);
            isExist = true;
        }
        this.deleteAdjustDetails(ctx, (IObjectValue)info);
        IObjectPK pk = super._submit(ctx, (IObjectValue)info);
        if (isExist) {
            this.updateLog(ctx, info);
        }
        this.submitAdjustDetails(ctx, (IObjectValue)info);
        return pk;
    }

    private void deleteAdjustDetails(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BOSUuid adjustId = ((AdjustInfo)model).getId();
        if (adjustId != null) {
            try {
                List list;
                AdjustEntryCollection adjustEntryCollection = ((AdjustInfo)model).getEntries();
                String key = "entryDetails";
                StringBuffer ids = new StringBuffer();
                for (int i = 0; i < adjustEntryCollection.size(); ++i) {
                    AdjustEntryInfo entryInfo = adjustEntryCollection.get(i);
                    if (((AdjustInfo)model).containsKey("delete")) {
                        if (entryInfo.getId() == null) continue;
                        ids.append("'").append(entryInfo.getId().toString()).append("',");
                        continue;
                    }
                    if (!entryInfo.containsKey(key) || entryInfo.getId() == null) continue;
                    ids.append("'").append(entryInfo.getId().toString()).append("',");
                }
                if (((AdjustInfo)model).containsKey("deleteEntryIds") && (list = (List)((AdjustInfo)model).get("deleteEntryIds")) != null && list.size() > 0) {
                    for (int n = 0; n < list.size(); ++n) {
                        ids.append("'").append(list.get(n).toString()).append("',");
                    }
                }
                if (ids.length() > 0) {
                    ids.deleteCharAt(ids.length() - 1);
                    StringBuffer sql = new StringBuffer();
                    sql.append("delete t_csl_adjustentrydetails where ");
                    sql.append(" fadjustentryid in (");
                    sql.append(ids.toString());
                    sql.append(" ) ");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                }
            }
            catch (SQLDataException e) {
                new BOSException((Throwable)e);
            }
        }
    }

    private void queryAdjustDetails(Context ctx, AdjustEntryCollection collection) throws BOSException, EASBizException {
        for (int m = 0; m < collection.size(); ++m) {
            if (collection.get(m).getHasAdjustDetails().getValue() != 1 || collection.get(m).getId() == null) continue;
            collection.get(m).put("entryDetails", (Object)RelatingAdjustElimHelper.queryAdjustDetails(ctx, collection.get(m).getId().toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitAdjustDetails(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (((AdjustInfo)model).getId() == null) {
            return;
        }
        AdjustEntryCollection adjustEntryCollection = ((AdjustInfo)model).getEntries();
        AdjustEntryCollection newAdjustEntryColl = null;
        String key = "entryDetails";
        AdjustEntryDetailsCollection submitColl = new AdjustEntryDetailsCollection();
        for (int i = 0; i < adjustEntryCollection.size(); ++i) {
            int debitOrCredit;
            AdjustEntryInfo entryInfo = adjustEntryCollection.get(i);
            if (entryInfo.getHasAdjustDetails().getValue() != 1 || !adjustEntryCollection.get(i).containsKey(key)) continue;
            AdjustEntryDetailsCollection collection = (AdjustEntryDetailsCollection)((Object)entryInfo.get(key));
            int n = debitOrCredit = entryInfo.getDebit() != null ? 1 : 0;
            if (entryInfo.getId() == null) {
                if (newAdjustEntryColl == null) {
                    newAdjustEntryColl = this.getAdjustInfo(ctx, (IObjectPK)new ObjectUuidPK(((AdjustInfo)model).getId())).getEntries();
                }
                for (int x = 0; x < newAdjustEntryColl.size(); ++x) {
                    if (!newAdjustEntryColl.get(x).getItem().getId().equals((Object)entryInfo.getItem().getId()) || newAdjustEntryColl.get(x).getHasAdjustDetails().getValue() != entryInfo.getHasAdjustDetails().getValue() || newAdjustEntryColl.get(x).getSeq() != entryInfo.getSeq() || newAdjustEntryColl.get(x).getDataElement() != entryInfo.getDataElement()) continue;
                    entryInfo.setId(newAdjustEntryColl.get(x).getId());
                    break;
                }
            }
            for (int j = 0; j < collection.size(); ++j) {
                AdjustEntryDetailsInfo detailsInfo = collection.get(j);
                detailsInfo.setAdjustEntry(entryInfo);
                detailsInfo.setDebitOrCredit(DebitOrCreditEnum.getEnum(debitOrCredit));
                detailsInfo.setSeq(j + 1);
                detailsInfo.setItemDCValue(entryInfo.getItem().getDc().getValue() == debitOrCredit ? detailsInfo.getAdjustData() : detailsInfo.getAdjustData().negate());
                submitColl.add(detailsInfo);
            }
        }
        if (submitColl.size() > 0) {
            Connection cn = null;
            try {
                cn = this.getConnection(ctx);
                IORMappingDAO iOrMapping = ORMappingDAO.getInstance((BOSObjectType)new AdjustEntryDetailsInfo().getBOSType(), (Context)ctx, (Connection)cn);
                Iterator it = submitColl.iterator();
                AdjustEntryDetailsInfo info = null;
                while (it.hasNext()) {
                    info = (AdjustEntryDetailsInfo)it.next();
                    info.setId(BOSUuid.create((BOSObjectType)new AdjustEntryDetailsInfo().getBOSType()));
                    iOrMapping.addNewBatch((IObjectValue)info);
                }
                iOrMapping.executeBatch();
            }
            catch (SQLDataException e) {
                new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup(null, (Connection)cn);
            }
        }
    }

    private void removeHideEntries(AdjustInfo model) {
        AdjustEntryCollection entries = model.getEntries();
        if (entries == null || entries.isEmpty()) {
            return;
        }
        for (int i = entries.size() - 1; i >= 0; --i) {
            if (entries.get(i).isIsVisible()) continue;
            entries.removeObject(i);
        }
    }

    private Map getParentRptItems(Context ctx, AdjustInfo adjust) throws BOSException {
        HashMap<String, RPTItemInfo> parentItems = new HashMap<String, RPTItemInfo>();
        ArrayList<String> numbers = new ArrayList<String>();
        AdjustEntryCollection entries = adjust.getEntries();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            AdjustEntryInfo adjustEntry = (AdjustEntryInfo)iter.next();
            String number = adjustEntry.getItem().getNumber();
            int end = number.length();
            while ((end = number.lastIndexOf(46, end)) > 0) {
                String num = number.substring(0, end);
                if (!numbers.contains(num)) {
                    numbers.add(num);
                }
                --end;
            }
        }
        if (!numbers.isEmpty()) {
            StringBuffer querySql = new StringBuffer();
            querySql.append("select FID,FNumber from t_csl_RptItem").append("\r\n");
            querySql.append("where FisFreezed=0").append("\r\n");
            querySql.append("and FNumber in('").append(numbers.get(0)).append("'");
            for (int i = 1; i < numbers.size(); ++i) {
                querySql.append(",'").append(numbers.get(i)).append("'");
            }
            querySql.append(")\r\n");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            try {
                while (rowSet.next()) {
                    RPTItemInfo rptItemInfo = new RPTItemInfo();
                    rptItemInfo.setId(BOSUuid.read((String)rowSet.getString(1)));
                    rptItemInfo.setNumber(rowSet.getString(2));
                    parentItems.put(rptItemInfo.getNumber(), rptItemInfo);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return parentItems;
    }

    private Map getParentRptItems(Context ctx, AdjustEntryInfo entryInfo) throws BOSException {
        HashMap<String, RPTItemInfo> parentItems = new HashMap<String, RPTItemInfo>();
        ArrayList<String> numbers = new ArrayList<String>();
        String number = entryInfo.getItem().getNumber();
        int end = number.length();
        while ((end = number.lastIndexOf(46, end)) > 0) {
            String num = number.substring(0, end);
            if (!numbers.contains(num)) {
                numbers.add(num);
            }
            --end;
        }
        if (!numbers.isEmpty()) {
            StringBuffer querySql = new StringBuffer();
            querySql.append("select FID,FNumber from t_csl_RptItem").append("\r\n");
            querySql.append("where FisFreezed=0").append("\r\n");
            querySql.append("and FNumber in('").append(numbers.get(0)).append("'");
            for (int i = 1; i < numbers.size(); ++i) {
                querySql.append(",'").append(numbers.get(i)).append("'");
            }
            querySql.append(")\r\n");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            try {
                while (rowSet.next()) {
                    RPTItemInfo rptItemInfo = new RPTItemInfo();
                    rptItemInfo.setId(BOSUuid.read((String)rowSet.getString(1)));
                    rptItemInfo.setNumber(rowSet.getString(2));
                    parentItems.put(rptItemInfo.getNumber(), rptItemInfo);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return parentItems;
    }

    private void autoAdjust(Context ctx, AdjustInfo adjustInfo) throws BOSException, EASBizException {
        if (adjustInfo == null || adjustInfo.getEntries() == null) {
            return;
        }
        if (adjustInfo.getEntries().size() == 0) {
            throw new AdjustException(AdjustException.LINE_NOT_EXIST);
        }
        this.fixRptItemNumber(ctx, adjustInfo);
        StringBuffer entryItemNumbers = new StringBuffer();
        AdjustEntryCollection entryColl = adjustInfo.getEntries();
        for (int i = 0; i < entryColl.size(); ++i) {
            if (i == entryColl.size() - 1) {
                entryItemNumbers.append("'").append(entryColl.get(i).getItem().getNumber()).append("'");
                continue;
            }
            entryItemNumbers.append("'").append(entryColl.get(i).getItem().getNumber()).append("',");
        }
        if (this.checkIfSumItemExist(ctx, entryItemNumbers.toString())) {
            throw new AdjustException(AdjustException.EXIST_SUMITEM_NOSAVE);
        }
        HashMap totalRptItems = this.getTotoalRptItems(ctx);
        HashMap treatedPALMap = new HashMap();
        HashMap treatedParentMap = new HashMap();
        Map treatedSumMap = this.getTreatedSumMap(ctx, adjustInfo);
        ArrayList treatedPALList = new ArrayList();
        ArrayList treatedParentList = new ArrayList();
        for (int i = 0; i < entryColl.size(); ++i) {
            AdjustEntryInfo entryInfo = entryColl.get(i);
            this.autoTreatment(ctx, entryInfo, totalRptItems, i, treatedPALMap, treatedParentMap, treatedPALList, treatedParentList);
        }
        this.createAutoRptItems(ctx, adjustInfo, treatedPALMap, treatedParentMap, treatedSumMap, treatedPALList, treatedParentList);
    }

    private Map getTreatedSumMap(Context ctx, AdjustInfo adjustInfo) throws BOSException {
        HashMap treatedSumMap = new HashMap();
        HashMap totalRptItems = this.getTotoalRptItems(ctx);
        AdjustEntryCollection entryColl = adjustInfo.getEntries();
        for (int i = 0; i < entryColl.size(); ++i) {
            AdjustEntryInfo entryInfo = entryColl.get(i);
            this.loopTreatedSumItem(ctx, entryInfo, totalRptItems, i, treatedSumMap);
        }
        return treatedSumMap;
    }

    private void loopTreatedSumItem(Context ctx, AdjustEntryInfo entryInfo, Map totalRptItems, int entryid, Map treatedSumMap) {
        String number = entryInfo.getItem().getNumber();
        if (totalRptItems.containsKey(number)) {
            ArrayList sumItemsList = (ArrayList)totalRptItems.get(number);
            for (String sumItemNumberStr : sumItemsList) {
                String sumItemNumber = sumItemNumberStr.split(SPLIT)[1];
                String key = entryid + SPLIT + sumItemNumberStr + SPLIT + number + SPLIT + entryInfo.getDataElement();
                AdjustEntryInfo newLineInfo = new AdjustEntryInfo();
                RPTItemInfo rptItem = new RPTItemInfo();
                rptItem.setNumber(sumItemNumber);
                newLineInfo.setItem(rptItem);
                newLineInfo.setDataElement(entryInfo.getDataElement());
                newLineInfo.setCredit(entryInfo.getCredit());
                newLineInfo.setDebit(entryInfo.getDebit());
                treatedSumMap.put(key, newLineInfo);
                this.loopTreatedSumItem(ctx, newLineInfo, totalRptItems, entryid, treatedSumMap);
            }
        }
    }

    private void autoTreatment(Context ctx, AdjustEntryInfo entryInfo, HashMap totalRptItems, int entryid, HashMap treatedPALMap, HashMap treatedParentMap, List treatedPALList, List treatedParentList) throws EASBizException, BOSException {
        if (entryInfo.getItem().isIsProfitAndLosses() && entryInfo.getDataElement() == 3) {
            this.autoTreatProfitAndLossRptItem(ctx, entryInfo, totalRptItems, entryid, treatedPALMap, treatedParentMap, treatedPALList, treatedParentList);
        }
        if (this.getParentRptItems(ctx, entryInfo).size() != 0) {
            this.autoTreatParentItems(ctx, entryInfo, totalRptItems, entryid, treatedPALMap, treatedParentMap, treatedPALList, treatedParentList);
        }
    }

    private void autoTreatProfitAndLossRptItem(Context ctx, AdjustEntryInfo unTreatedAdjustEntryInfo, HashMap totalRptItems, int entryid, HashMap treatedPALMap, HashMap treatedParentMap, List treatedPALList, List treatedParentList) throws BOSException, EASBizException {
        AdjustEntryInfo lineInfo = unTreatedAdjustEntryInfo;
        if (lineInfo != null && lineInfo.getItem() != null) {
            String id = lineInfo.getItem().getId().toString();
            String number = lineInfo.getItem().getNumber();
            String key = entryid + SPLIT + number;
            if (!treatedPALMap.containsKey(key)) {
                AdjustEntryInfo newLineInfo = new AdjustEntryInfo();
                RPTItemInfo rptItem = new RPTItemInfo();
                rptItem.setId(BOSUuid.read((String)id));
                rptItem.setNumber(number);
                newLineInfo.setItem(rptItem);
                newLineInfo.setDataElement(lineInfo.getDataElement());
                newLineInfo.setCredit(lineInfo.getCredit());
                newLineInfo.setDebit(lineInfo.getDebit());
                treatedPALMap.put(key, newLineInfo);
                treatedPALList.add(number);
                this.autoTreatment(ctx, newLineInfo, totalRptItems, entryid, treatedPALMap, treatedParentMap, treatedPALList, treatedParentList);
            }
        }
    }

    private void autoTreatParentItems(Context ctx, AdjustEntryInfo unTreatedAdjustEntryInfo, HashMap totalRptItems, int entryid, HashMap treatedPALMap, HashMap treatedParentMap, List treatedPALList, List treatedParentList) throws BOSException, EASBizException {
        Map parentItems = this.getParentRptItems(ctx, unTreatedAdjustEntryInfo);
        AdjustEntryInfo lineInfo = unTreatedAdjustEntryInfo;
        String number = lineInfo.getItem().getNumber();
        List parentNumbers = this.getParentNumbers(number);
        for (int index = 0; parentNumbers != null && index < parentNumbers.size(); ++index) {
            String pnumber = (String)parentNumbers.get(index);
            String key = entryid + SPLIT + pnumber + SPLIT + lineInfo.getDataElement();
            if (treatedParentMap.containsKey(key) || treatedPALList.contains(pnumber)) continue;
            AdjustEntryInfo newLineInfo = new AdjustEntryInfo();
            newLineInfo.setItem((RPTItemInfo)parentItems.get(pnumber));
            newLineInfo.setDataElement(lineInfo.getDataElement());
            newLineInfo.setCredit(lineInfo.getCredit());
            newLineInfo.setDebit(lineInfo.getDebit());
            treatedParentMap.put(key, newLineInfo);
            treatedParentList.add(pnumber);
            this.autoTreatment(ctx, newLineInfo, totalRptItems, entryid, treatedPALMap, treatedParentMap, treatedPALList, treatedParentList);
        }
    }

    private void createAutoRptItems(Context ctx, AdjustInfo adjustInfo, HashMap treatedPALMap, HashMap treatedParentMap, Map treatedSumMap, List treatedPALList, List treatedParentList) throws EASBizException, BOSException {
        Iterator<Object> itr;
        Set set;
        BigDecimal zeroValue = new BigDecimal("0");
        if (treatedPALMap != null && treatedPALMap.size() > 0) {
            set = treatedPALMap.keySet();
            itr = set.iterator();
            BigDecimal debitTotal = new BigDecimal("0");
            BigDecimal creditTotal = new BigDecimal("0");
            BigDecimal resultTotal = new BigDecimal("0");
            while (itr.hasNext()) {
                String key = (String)itr.next();
                AdjustEntryInfo entryInfo = (AdjustEntryInfo)treatedPALMap.get(key);
                if (entryInfo.getDebit() != null) {
                    debitTotal = debitTotal.add(entryInfo.getDebit());
                }
                if (entryInfo.getCredit() == null) continue;
                creditTotal = creditTotal.add(entryInfo.getCredit());
            }
            if (debitTotal.compareTo(creditTotal) != 0) {
                AdjustEntryInfo unSharedProfitEntry = new AdjustEntryInfo();
                unSharedProfitEntry.setIsVisible(false);
                unSharedProfitEntry.setDataElement(4);
                unSharedProfitEntry.setItem(this.getUnAssignRptItemId(ctx, false));
                unSharedProfitEntry.setAdjust(adjustInfo);
                unSharedProfitEntry.setSummary(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AdjustBAutoCreate", (Locale)ctx.getOriginLocale()));
                resultTotal = debitTotal.subtract(creditTotal);
                if (resultTotal.compareTo(zeroValue) > 0) {
                    unSharedProfitEntry.setDebit(resultTotal);
                    unSharedProfitEntry.setCredit(null);
                }
                if (resultTotal.compareTo(zeroValue) < 0) {
                    unSharedProfitEntry.setCredit(resultTotal.abs());
                    unSharedProfitEntry.setDebit(null);
                }
                adjustInfo.getEntries().add(unSharedProfitEntry);
            }
        }
        if (treatedParentMap != null && treatedParentMap.size() > 0) {
            set = treatedParentMap.keySet();
            itr = set.iterator();
            HashMap<String, AdjustEntryInfo> parentMap = new HashMap<String, AdjustEntryInfo>();
            while (itr.hasNext()) {
                String key = (String)itr.next();
                AdjustEntryInfo entryInfo = (AdjustEntryInfo)treatedParentMap.get(key);
                String[] keyArray = key.split(SPLIT);
                String parentKey = keyArray[1] + SPLIT + keyArray[2];
                if (parentMap.containsKey(parentKey)) {
                    AdjustEntryInfo parentEntryInfo = (AdjustEntryInfo)parentMap.get(parentKey);
                    if (entryInfo.getDebit() != null) {
                        if (parentEntryInfo.getDebit() != null) {
                            parentEntryInfo.setDebit(parentEntryInfo.getDebit().add(entryInfo.getDebit()));
                        } else {
                            parentEntryInfo.setDebit(entryInfo.getDebit());
                        }
                    }
                    if (entryInfo.getCredit() != null) {
                        if (parentEntryInfo.getCredit() != null) {
                            parentEntryInfo.setCredit(parentEntryInfo.getCredit().add(entryInfo.getCredit()));
                        } else {
                            parentEntryInfo.setCredit(entryInfo.getCredit());
                        }
                    }
                    if (parentEntryInfo.getSummary().lastIndexOf(42) != -1) continue;
                    parentEntryInfo.setSummary(parentEntryInfo.getSummary() + " *");
                    continue;
                }
                entryInfo.setSummary(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"autoGererateParent", (Locale)ctx.getOriginLocale()));
                parentMap.put(parentKey, entryInfo);
            }
            if (parentMap != null && parentMap.size() > 0) {
                Collection collection = parentMap.values();
                for (AdjustEntryInfo entryInfo : collection) {
                    if (treatedPALList.contains(entryInfo.getItem().getNumber()) || !this.offsetDebitOrCredit(entryInfo)) continue;
                    entryInfo.setAdjust(adjustInfo);
                    entryInfo.setIsVisible(false);
                    adjustInfo.getEntries().add(entryInfo);
                }
            }
        }
        Map itemMap = RptItemRelationshipFactory.getLocalInstance(ctx).getItemRelationshipMap(2);
        RptItemRelationshipFactory.getLocalInstance(ctx).autoCreateRelationshipItems(adjustInfo, itemMap);
        this.autoCreateSumItem(ctx, adjustInfo, treatedSumMap, treatedPALList, treatedParentList, itemMap);
    }

    private boolean offsetDebitOrCredit(AdjustEntryInfo adjustEntry) {
        boolean isAdd = true;
        if (adjustEntry.getDebit() != null && adjustEntry.getCredit() != null) {
            if (adjustEntry.getDebit().compareTo(adjustEntry.getCredit()) > 0) {
                adjustEntry.setDebit(adjustEntry.getDebit().subtract(adjustEntry.getCredit()));
                adjustEntry.setCredit(null);
            } else if (adjustEntry.getDebit().compareTo(adjustEntry.getCredit()) < 0) {
                adjustEntry.setCredit(adjustEntry.getCredit().subtract(adjustEntry.getDebit()));
                adjustEntry.setDebit(null);
            } else {
                isAdd = false;
            }
        }
        return isAdd;
    }

    private void autoCreateSumItem(Context ctx, AdjustInfo adjustInfo, Map treatedSumMap, List treatedPALList, List treatedParentList, Map itemMap) throws BOSException {
        this.removeItemRelationshipFromTreatedSumMap(ctx, treatedSumMap, adjustInfo, itemMap);
        if (treatedSumMap != null && treatedSumMap.size() > 0) {
            Set set = treatedSumMap.keySet();
            Iterator<Object> itr = set.iterator();
            HashMap<String, AdjustEntryInfo> sumMap = new HashMap<String, AdjustEntryInfo>();
            while (itr.hasNext()) {
                String key = (String)itr.next();
                AdjustEntryInfo entryInfo = (AdjustEntryInfo)treatedSumMap.get(key);
                String[] keyArray = key.split(SPLIT);
                String addOrSubtract = keyArray[1];
                String number = keyArray[2];
                String id = keyArray[3];
                String sumItemKey = keyArray[2] + SPLIT + keyArray[5];
                if (sumMap.containsKey(sumItemKey)) {
                    AdjustEntryInfo sumEntryInfo = (AdjustEntryInfo)sumMap.get(sumItemKey);
                    if (entryInfo.getDebit() != null) {
                        if (sumEntryInfo.getDebit() != null) {
                            if (addOrSubtract.equals("+")) {
                                sumEntryInfo.setDebit(sumEntryInfo.getDebit().add(entryInfo.getDebit()));
                            } else if (addOrSubtract.equals("-")) {
                                sumEntryInfo.setDebit(sumEntryInfo.getDebit().subtract(entryInfo.getDebit()));
                            }
                        } else {
                            sumEntryInfo.setDebit(entryInfo.getDebit());
                        }
                    }
                    if (entryInfo.getCredit() != null) {
                        if (sumEntryInfo.getCredit() != null) {
                            if (addOrSubtract.equals("+")) {
                                sumEntryInfo.setCredit(sumEntryInfo.getCredit().add(entryInfo.getCredit()));
                            } else if (addOrSubtract.equals("-")) {
                                sumEntryInfo.setCredit(sumEntryInfo.getCredit().subtract(entryInfo.getCredit()));
                            }
                        } else {
                            sumEntryInfo.setCredit(entryInfo.getCredit());
                        }
                    }
                    if (sumEntryInfo.getSummary().lastIndexOf(42) != -1) continue;
                    sumEntryInfo.setSummary(sumEntryInfo.getSummary() + " *");
                    continue;
                }
                RPTItemInfo rptItemInfo = new RPTItemInfo();
                rptItemInfo.setId(BOSUuid.read((String)id));
                rptItemInfo.setNumber(number);
                entryInfo.setItem(rptItemInfo);
                entryInfo.setSummary(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"autoGererateTotalItem", (Locale)ctx.getOriginLocale()));
                BigDecimal zero = new BigDecimal(0);
                if (addOrSubtract.equals("-")) {
                    if (entryInfo.getDebit() != null) {
                        entryInfo.setDebit(zero.subtract(entryInfo.getDebit()));
                    }
                    if (entryInfo.getCredit() != null) {
                        entryInfo.setCredit(zero.subtract(entryInfo.getCredit()));
                    }
                }
                sumMap.put(sumItemKey, entryInfo);
            }
            if (sumMap != null && sumMap.size() > 0) {
                Collection collection = sumMap.values();
                itr = collection.iterator();
                BigDecimal zeroValue = new BigDecimal("0");
                while (itr.hasNext()) {
                    AdjustEntryInfo entryInfo = (AdjustEntryInfo)itr.next();
                    if (treatedPALList.contains(entryInfo.getItem().getNumber()) || treatedParentList.contains(entryInfo.getItem().getNumber()) || !this.offsetDebitOrCredit(entryInfo)) continue;
                    entryInfo.setAdjust(adjustInfo);
                    entryInfo.setIsVisible(false);
                    if (!(entryInfo.getCredit() != null && entryInfo.getCredit().compareTo(zeroValue) != 0 || entryInfo.getDebit() != null && entryInfo.getDebit().compareTo(zeroValue) != 0)) continue;
                    adjustInfo.getEntries().add(entryInfo);
                }
            }
        }
    }

    private void removeItemRelationshipFromTreatedSumMap(Context ctx, Map treatedSumMap, AdjustInfo adjustInfo, Map itemMap) throws BOSException {
        if (itemMap != null && itemMap.size() > 0 && treatedSumMap != null && treatedSumMap.size() > 0) {
            Set set = treatedSumMap.keySet();
            Iterator itr = set.iterator();
            HashSet<String> removeKeySet = new HashSet<String>();
            while (itr.hasNext()) {
                String key = (String)itr.next();
                if (!this.isRemoveKey(itemMap, key)) continue;
                removeKeySet.add(key);
            }
            this.loopRemoveByRemoveKeySet(removeKeySet, treatedSumMap);
        }
    }

    private void loopRemoveByRemoveKeySet(Set removeKeySet, Map treatedSumMap) {
        Iterator itr = removeKeySet.iterator();
        while (itr.hasNext()) {
            treatedSumMap.remove(itr.next());
        }
        boolean reLoop = false;
        for (String key : treatedSumMap.keySet()) {
            for (String removeKey : removeKeySet) {
                String[] keyArray = removeKey.split(SPLIT);
                if (!key.startsWith(keyArray[0]) || !key.endsWith(keyArray[2] + SPLIT + keyArray[5])) continue;
                removeKeySet.add(key);
                reLoop = true;
                break;
            }
            if (!reLoop) continue;
            break;
        }
        if (reLoop) {
            this.loopRemoveByRemoveKeySet(removeKeySet, treatedSumMap);
        }
    }

    private boolean isRemoveKey(Map itemMap, String key) {
        Set itemRelationSet;
        String[] keyArray = key.split(SPLIT);
        String fromItem = keyArray[4] + SPLIT + keyArray[5];
        String toItem = keyArray[2] + SPLIT + keyArray[5];
        return itemMap.containsKey(toItem) && (itemRelationSet = (Set)itemMap.get(toItem)).contains(fromItem);
    }

    private HashMap getTotoalRptItems(Context ctx) throws BOSException {
        HashMap totalRptItems = new HashMap();
        StringBuffer querySql = new StringBuffer();
        querySql.append("select  FID,FNumber,FControl,FItemGroup,FSumItemFormula,FIsProfitAndLosses").append("\r\n");
        querySql.append("from t_csl_RptItem").append("\r\n");
        querySql.append("where FisFreezed=0 and FIsSumItem = 1 ").append("\r\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        String id = null;
        String number = null;
        String sumItemFormula = null;
        String subSumItem = null;
        try {
            while (rowSet.next()) {
                int beginIndex = 0;
                id = rowSet.getString(1);
                number = rowSet.getString(2);
                sumItemFormula = rowSet.getString(5);
                if (!this.checkIfCreateSumItem(sumItemFormula) || sumItemFormula == null) continue;
                char[] sumItemFormulaChar = sumItemFormula.toCharArray();
                for (int i = 0; i < sumItemFormulaChar.length; ++i) {
                    List<String> sumItemList;
                    if (sumItemFormulaChar[i] != '+' && sumItemFormulaChar[i] != '-' && i != sumItemFormulaChar.length - 1) continue;
                    subSumItem = i < sumItemFormulaChar.length - 1 ? sumItemFormula.substring(beginIndex, i) : sumItemFormula.substring(beginIndex, i + 1);
                    String addOrSubtract = "";
                    addOrSubtract = beginIndex == 0 ? "+" : sumItemFormula.substring(beginIndex - 1, beginIndex);
                    String key = addOrSubtract + SPLIT + number + SPLIT + id;
                    if (totalRptItems.get(subSumItem) != null) {
                        sumItemList = (List)totalRptItems.get(subSumItem);
                        sumItemList.add(key);
                    } else {
                        sumItemList = new ArrayList();
                        sumItemList.add(key);
                        totalRptItems.put(subSumItem, sumItemList);
                    }
                    beginIndex = i + 1;
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return totalRptItems;
    }

    private boolean checkIfCreateSumItem(String sumItemFormula) {
        boolean ifCreateSumItem = true;
        if (sumItemFormula != null && (sumItemFormula.indexOf("*") != -1 || sumItemFormula.indexOf("/") != -1)) {
            ifCreateSumItem = false;
        }
        return ifCreateSumItem;
    }

    private boolean checkIfSumItemExist(Context ctx, String entryItemNumbers) throws BOSException {
        boolean ifSumItemExist = false;
        StringBuffer querySql = new StringBuffer();
        querySql.append("select  count(*) count ").append("\r\n");
        querySql.append("from t_csl_RptItem").append("\r\n");
        querySql.append("where FisFreezed=0 and FIsSumItem = 1 ").append("\r\n");
        querySql.append("and FNumber in (").append(entryItemNumbers).append(")").append("\r\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        try {
            while (rowSet.next()) {
                if (rowSet.getInt(1) <= 0) continue;
                ifSumItemExist = true;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return ifSumItemExist;
    }

    private Map fixRptItemNumber(Context ctx, AdjustInfo adjustInfo) throws BOSException {
        RPTItemInfo item;
        AdjustEntryCollection entries = adjustInfo.getEntries();
        HashMap<String, String> idAndNumber = new HashMap<String, String>(entries.size());
        StringBuffer ids = new StringBuffer();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            item = ((AdjustEntryInfo)iter.next()).getItem();
            if (item == null || !StringUtils.isEmpty((String)item.getNumber())) continue;
            String id = item.getId().toString();
            if (ids.length() == 0) {
                ids.append("'").append(id).append("'");
                continue;
            }
            ids.append(",'").append(id).append("'");
        }
        if (ids.length() > 0) {
            StringBuffer querySql = new StringBuffer();
            querySql.append("select FID,FNumber from t_csl_RptItem").append("\r\n");
            querySql.append("where FID in(").append(ids.toString()).append(")");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            try {
                while (rowSet.next()) {
                    idAndNumber.put(rowSet.getString(1), rowSet.getString(2));
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (!idAndNumber.isEmpty()) {
            iter = entries.iterator();
            while (iter.hasNext()) {
                item = ((AdjustEntryInfo)iter.next()).getItem();
                if (!StringUtils.isEmpty((String)item.getNumber())) continue;
                item.setNumber((String)idAndNumber.get(item.getId().toString()));
            }
        }
        return idAndNumber;
    }

    private void autoAdjustParentItems(Context ctx, AdjustInfo model) throws BOSException, EASBizException {
        AdjustEntryCollection entries = model.getEntries();
        this.fixRptItemNumber(ctx, model);
        Map parentItems = this.getParentRptItems(ctx, model);
        if (parentItems == null || parentItems.isEmpty()) {
            return;
        }
        HashMap<String, AdjustEntryInfo> autoAdjustData = new HashMap<String, AdjustEntryInfo>();
        int maxSeq = entries.size() + 1;
        Map itemIdMap = new HashMap();
        Map itemRelationshipMap = RptItemRelationshipFactory.getLocalInstance(ctx).getItemRelationshipMap(2);
        if (itemRelationshipMap != null) {
            itemIdMap = (Map)itemRelationshipMap.get("itemIdMap");
            itemRelationshipMap.remove("itemIdMap");
        }
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            AdjustEntryInfo entryInfo = (AdjustEntryInfo)iter.next();
            if (maxSeq < entryInfo.getSeq()) {
                ++maxSeq;
            }
            String number = entryInfo.getItem().getNumber();
            List parentNumbers = this.getParentNumbers(number);
            for (int index = 0; parentNumbers != null && index < parentNumbers.size(); ++index) {
                String pnumber = (String)parentNumbers.get(index);
                String key = pnumber + ", " + entryInfo.getDataElement();
                AdjustEntryInfo entry = (AdjustEntryInfo)autoAdjustData.get(key);
                if (entry == null) {
                    entry = new AdjustEntryInfo();
                    entry.setAdjust(entryInfo.getAdjust());
                    entry.setItem((RPTItemInfo)parentItems.get(pnumber));
                    entry.setSummary(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AdjustBAutoCreate", (Locale)ctx.getOriginLocale()) + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"94_AdjustControllerBean", (Locale)ctx.getOriginLocale()));
                    entry.setDataElement(entryInfo.getDataElement());
                    entry.setIsVisible(false);
                    autoAdjustData.put(key, entry);
                } else if (entry.getSummary().lastIndexOf(42) == -1) {
                    entry.setSummary(entry.getSummary() + " *");
                }
                if (entryInfo.getDebit() != null) {
                    if (entry.getDebit() == null) {
                        entry.setDebit(entryInfo.getDebit());
                        continue;
                    }
                    entry.setDebit(entry.getDebit().add(entryInfo.getDebit()));
                    continue;
                }
                if (entry.getCredit() == null) {
                    entry.setCredit(entryInfo.getCredit());
                    continue;
                }
                entry.setCredit(entry.getCredit().add(entryInfo.getCredit()));
            }
        }
        for (Map.Entry entry : autoAdjustData.entrySet()) {
            AdjustEntryInfo adjustEntry = (AdjustEntryInfo)entry.getValue();
            adjustEntry.setSeq(maxSeq++);
            if (!this.offsetDebitOrCredit(adjustEntry)) continue;
            entries.add((AdjustEntryInfo)entry.getValue());
        }
        parentItems.clear();
        parentItems = null;
        autoAdjustData.clear();
        autoAdjustData = null;
    }

    private List getParentNumbers(String number) {
        if (number.indexOf(46) == -1) {
            return null;
        }
        ArrayList<String> numbers = new ArrayList<String>();
        int end = number.length();
        while ((end = number.lastIndexOf(46, end)) > 0) {
            numbers.add(number.substring(0, end));
            --end;
        }
        return numbers;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AdjustInfo info = this.getAdjustInfo(ctx, pk, this.getSelectors());
        this.deleteCheck(ctx, pk);
        this.initCodeRule(ctx);
        String strOrgID = CSLServerHelper.getRootOrgIDForRootCU(ctx);
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean isUseIntermitNumber = iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, strOrgID);
        if (this.hasCodeRule && strOrgID != null && isUseIntermitNumber) {
            iCodingRuleManager.recycleNumber((IObjectValue)info, strOrgID, info.getNumber());
        }
        ArrayList<String> delIds = new ArrayList<String>();
        Iterator iter = info.getEntries().iterator();
        while (iter.hasNext()) {
            AdjustEntryInfo element = (AdjustEntryInfo)iter.next();
            if (element.getId() == null) continue;
            delIds.add(element.getId().toString());
        }
        if (!delIds.isEmpty()) {
            AdjustDynamicItemFactory.getLocalInstance(ctx).deleteDynamicAdjustItems(delIds);
        }
        info.put("delete", "delete");
        this.deleteAdjustDetails(ctx, (IObjectValue)info);
        super._delete(ctx, pk);
        this.deleteElimRelaOrgTree(ctx, info);
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entries.debit"));
        sic.add(new SelectorItemInfo("entries.credit"));
        sic.add(new SelectorItemInfo("entries.summary"));
        sic.add(new SelectorItemInfo("entries.dataElement"));
        sic.add(new SelectorItemInfo("entries.item"));
        sic.add(new SelectorItemInfo("entries.item.number"));
        sic.add(new SelectorItemInfo("entries.item.name"));
        sic.add(new SelectorItemInfo("adjustMode"));
        sic.add(new SelectorItemInfo("orgUnit"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("dataSource"));
        sic.add(new SelectorItemInfo("date"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("valueType"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("entries.item.*"));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("CheckedStatus"));
        sic.add(new SelectorItemInfo("archivedStatus"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("orgBound.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        return sic;
    }

    private void checkNumberBlank(AdjustInfo info) throws EASBizException {
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new AdjustException(AdjustException.NUMBER_CANNOT_BLANK);
        }
    }

    @Override
    protected void _submitWF(Context ctx, IObjectPK pk) throws BOSException {
    }

    @Override
    protected IObjectCollection _getAdjustRecord(Context ctx, int period, int year, int periodType, String treeId, String orgUnitId, boolean isForBugetBound) throws BOSException, EASBizException {
        return this._getAdjustRecordByBasicBound(ctx, period, year, periodType, treeId, orgUnitId, isForBugetBound, null);
    }

    @Override
    protected IObjectCollection _getAdjustRecord(Context ctx, int period, int year, int periodType, String sourceTreeId, String importTreeId, String orgUnitId, boolean isForBugetBound) throws BOSException, EASBizException {
        return this._getAdjustRecordByBasicBound(ctx, period, year, periodType, sourceTreeId, importTreeId, orgUnitId, isForBugetBound, null);
    }

    @Override
    protected Map _doImportAdjustRecords(Context ctx, List listId, RptProperties rptProperties, IObjectValue dataCollect) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (listId == null || listId.size() == 0) {
            return result;
        }
        String orgTreeID = rptProperties.getString("orgTreeID");
        boolean isSynBasicScopeData = rptProperties.getBoolean("isSynBasicScopeData");
        Map mapAdjust = null;
        if (isSynBasicScopeData) {
            ArrayList targetList = (ArrayList)rptProperties.getObject("targetAdjustIds");
            mapAdjust = this.getMapTargetAdjust(ctx, targetList, rptProperties);
        } else {
            mapAdjust = this.getMapTargetAdjust(ctx, listId, rptProperties);
        }
        List lstUnAudit = (List)mapAdjust.get("lstUnAudit");
        this.unAuditAdjustInfo(ctx, lstUnAudit);
        this.deleteBatchData(ctx, (IObjectPK[])mapAdjust.get("deletePks"));
        EntityViewInfo sourceEntityViewInfo = this.getSourceEntityViewInfo(listId);
        AdjustCollection sourceAdjustCollection = AdjustFactory.getLocalInstance(ctx).getAdjustCollection(sourceEntityViewInfo);
        int iSize = sourceAdjustCollection.size();
        AdjustInfo sourceAdjustInfo = null;
        AdjustInfo targetAdjustInfo = null;
        String BoId = null;
        boolean hasCodeRule = CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist((IObjectValue)new AdjustInfo(), "00000000-0000-0000-0000-000000000000CCE7AED4");
        BOSObjectType bosType = new AdjustDynamicItemInfo().getBOSType();
        HashMap entryIds = new HashMap();
        Object numbers = null;
        String number = null;
        StringBuffer msg = new StringBuffer();
        boolean isbasicimport = rptProperties.getBoolean("isbasicimport");
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        for (int i = 0; i < iSize; ++i) {
            sourceAdjustInfo = sourceAdjustCollection.get(i);
            BoId = sourceAdjustInfo.getId().toString();
            String oldNumber = sourceAdjustInfo.getNumber();
            targetAdjustInfo = (AdjustInfo)mapAdjust.get(sourceAdjustInfo.getId());
            if (hasCodeRule) {
                number = CslElimUtil.getAdjustNumber(ctx, sourceAdjustInfo, rptProperties, timestamp);
            }
            sourceAdjustInfo = this.generateAdjustInfo(ctx, targetAdjustInfo, sourceAdjustInfo, orgTreeID, isSynBasicScopeData, dataCollect, hasCodeRule, bosType, entryIds, number);
            if (isbasicimport) {
                try {
                    this.addnewCheck(ctx, sourceAdjustInfo);
                }
                catch (Exception ex) {
                    msg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"entryImportTitle", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{oldNumber})).append("<br/>");
                    msg.append(ex.getMessage()).append("<br/>");
                    this.removeEntryIds(entryIds, sourceAdjustInfo);
                    continue;
                }
            }
            IObjectPK obPk = AdjustFactory.getLocalInstance(ctx).submit((CoreBaseInfo)sourceAdjustInfo);
            if (isSynBasicScopeData && sourceAdjustInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED) && null != obPk) {
                sourceAdjustInfo.setId(BOSUuid.read((String)obPk.toString()));
                sourceAdjustInfo.setAuditor((UserInfo)ctx.get((Object)"UserInfo"));
                sourceAdjustInfo.setAuditDate(new Timestamp(System.currentTimeMillis()));
                this._passAudit(ctx, obPk, (IObjectValue)sourceAdjustInfo);
            }
            this.addAttachment(ctx, obPk, BoId);
        }
        CslRptUtil.copyDynamicItem(ctx, entryIds, true);
        if (isbasicimport) {
            result.put("message", msg.toString());
        }
        return result;
    }

    private void removeEntryIds(Map entryIds, AdjustInfo newInfo) {
        for (int j = 0; j < newInfo.getEntries().size(); ++j) {
            AdjustEntryInfo entryInfo = newInfo.getEntries().get(j);
            String newEntryId = entryInfo.getId().toString();
            Iterator it = entryIds.keySet().iterator();
            boolean isRemoved = false;
            String oldEntryId = null;
            while (it.hasNext()) {
                oldEntryId = String.valueOf(it.next());
                String entryId = String.valueOf(entryIds.get(oldEntryId));
                if (!newEntryId.equals(entryId)) continue;
                isRemoved = true;
            }
            if (!isRemoved) continue;
            entryIds.remove(oldEntryId);
        }
    }

    private void unAuditAdjustInfo(Context ctx, List lstUnAudit) throws BOSException, EASBizException {
        int iSize = lstUnAudit.size();
        if (null == lstUnAudit || iSize == 0) {
            return;
        }
        ObjectUuidPK pk = null;
        for (int i = 0; i < lstUnAudit.size(); ++i) {
            pk = new ObjectUuidPK(lstUnAudit.get(i).toString());
            this.operateDataByAdjustPk(ctx, (IObjectPK)pk);
        }
        this.batchDeleteByAdjustPk(ctx, lstUnAudit);
    }

    private void operateDataByAdjustPk(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IItemDataProvider itemDataProvider = ItemDataProviderFactory.getLocalInstance(ctx);
        if (itemDataProvider != null) {
            itemDataProvider.clearItemData(pk.toString());
            itemDataProvider.updateAuditedItemData(pk.toString(), false);
        }
    }

    private void batchDeleteByAdjustPk(Context ctx, List lstId) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" DELETE FROM T_CSL_RptReceived WHERE FReportID IN (  ");
        int iSize = lstId.size();
        for (int i = 0; i < iSize; ++i) {
            if (i == 0) {
                sql.append("'").append(lstId.get(i).toString()).append("'");
                continue;
            }
            sql.append(",'").append(lstId.get(i).toString()).append("'");
        }
        sql.append(" )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void addAttachment(Context ctx, IObjectPK obPk, String BoId) throws BOSException, EASBizException {
        if (null == obPk) {
            return;
        }
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        String[] attachIDs = asm.getAttachmentIDsByBoID(BoId);
        asm.addAssociations(obPk.toString(), attachIDs);
    }

    private Map getMapTargetAdjust(Context ctx, List listId, RptProperties params) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = this.getEntityViewInfo(listId, params);
        AdjustCollection adjustCollection = AdjustFactory.getLocalInstance(ctx).getAdjustCollection(entityViewInfo);
        int iSize = adjustCollection.size();
        HashMap<Object, Object> mapAdjust = new HashMap<Object, Object>(iSize);
        IObjectPK[] deletePKs = new IObjectPK[iSize];
        ArrayList<BOSUuid> lstUnAudit = new ArrayList<BOSUuid>();
        for (int i = 0; i < iSize; ++i) {
            AdjustInfo adjustInfo = adjustCollection.get(i);
            mapAdjust.put(adjustInfo.getSourceAdjust().getId(), adjustInfo);
            deletePKs[i] = new ObjectUuidPK(adjustInfo.getId());
            if (CheckedStatusEnum.AUDITED.equals((Object)adjustInfo.getCheckedStatus())) {
                lstUnAudit.add(adjustInfo.getId());
            }
            AttachmentManagerFactory.getServerManager((Context)ctx).deleteAttachemtsByBoID(adjustInfo.getId().toString());
        }
        mapAdjust.put("deletePks", deletePKs);
        mapAdjust.put("lstUnAudit", lstUnAudit);
        return mapAdjust;
    }

    private EntityViewInfo getSourceEntityViewInfo(List listId) {
        Set setIds = this.getSet(listId);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)setIds, CompareType.INCLUDE));
        filter.setMaskString("#0");
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entries.*"));
        selector.add(new SelectorItemInfo("entries.item.id"));
        selector.add(new SelectorItemInfo("entries.item.number"));
        selector.add(new SelectorItemInfo("entries.item.isProfitAndLosses"));
        selector.add(new SelectorItemInfo("entries.item.effectItem"));
        selector.add(new SelectorItemInfo("entries.item.dc"));
        selector.add(new SelectorItemInfo("entries.company.number"));
        selector.add(new SelectorItemInfo("entries.hasAdjustDetails"));
        return viewInfo;
    }

    private Set getSet(List listId) {
        int iSize = listId.size();
        HashSet setIds = new HashSet(iSize);
        for (int i = 0; i < iSize; ++i) {
            setIds.add(listId.get(i));
        }
        return setIds;
    }

    private EntityViewInfo getEntityViewInfo(List listId, RptProperties rptProperties) {
        Set setIds = this.getSet(listId);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        boolean isSynBasicScopeData = rptProperties.getBoolean("isSynBasicScopeData");
        if (isSynBasicScopeData) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)setIds, CompareType.INCLUDE));
            filter.setMaskString("#0");
        } else {
            String year = rptProperties.getObject("year").toString();
            String period = rptProperties.getObject("period").toString();
            String periodType = rptProperties.getObject("periodType").toString();
            OrgTreeInfo orgTreeInfo = (OrgTreeInfo)rptProperties.getObject("KEY_ORGTREE_INFO");
            String orgTreeID = orgTreeInfo.getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)period, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodType, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("year", (Object)year, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("orgBound", (Object)orgTreeID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("sourceAdjust.id", (Object)setIds, CompareType.INCLUDE));
            filter.setMaskString("#0 and #1 and #2 and #3 and #4");
        }
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("orgBound.id"));
        selector.add(new SelectorItemInfo("orgUnit.id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("checkedStatus"));
        selector.add(new SelectorItemInfo("sourceAdjust.id"));
        selector.add(new SelectorItemInfo("currency.id"));
        selector.add(new SelectorItemInfo("sourceCurrency.id"));
        return viewInfo;
    }

    private OrgTreeInfo getOrgTreeInfo(String orgTreeID) {
        OrgTreeInfo orgTreeInfo = new OrgTreeInfo();
        orgTreeInfo.setId(BOSUuid.read((String)orgTreeID));
        return orgTreeInfo;
    }

    private AdjustInfo generateAdjustInfo(Context ctx, AdjustInfo targetAdjustInfo, AdjustInfo sourceAdjustInfo, String orgTreeID, boolean isSynBasicScopeData, IObjectValue dataCollect, boolean hasCodeRule, BOSObjectType bosType, Map entryIds, String number) throws BOSException, EASBizException {
        if (null != targetAdjustInfo) {
            sourceAdjustInfo.setOrgBound(targetAdjustInfo.getOrgBound());
            sourceAdjustInfo.setOrgUnit(targetAdjustInfo.getOrgUnit());
            if (targetAdjustInfo.getCurrency() != null && sourceAdjustInfo.getCurrency() != null && targetAdjustInfo.getCurrency().getId().equals((Object)sourceAdjustInfo.getCurrency().getId()) && targetAdjustInfo.getSourceCurrency() != null && sourceAdjustInfo.getSourceCurrency() != null && targetAdjustInfo.getSourceCurrency().getId().equals((Object)sourceAdjustInfo.getSourceCurrency().getId())) {
                sourceAdjustInfo.setNumber(targetAdjustInfo.getNumber());
            }
        } else {
            sourceAdjustInfo.setOrgBound(this.getOrgTreeInfo(orgTreeID));
        }
        sourceAdjustInfo.setSourceAdjust((AdjustInfo)sourceAdjustInfo.clone());
        sourceAdjustInfo.setId(null);
        sourceAdjustInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        sourceAdjustInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        if (!isSynBasicScopeData && hasCodeRule && null != number) {
            sourceAdjustInfo.setNumber(number);
        }
        if (!isSynBasicScopeData) {
            sourceAdjustInfo.setAuditor(null);
            sourceAdjustInfo.setAuditDate(null);
            sourceAdjustInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        }
        if (dataCollect != null) {
            sourceAdjustInfo.setDataCollect((DataCollectInfo)dataCollect);
            if (!StringUtils.isEmpty((String)((DataCollectInfo)dataCollect).getNumber())) {
                sourceAdjustInfo.setDataCollectNumber(((DataCollectInfo)dataCollect).getNumber());
            }
        }
        AdjustEntryCollection entryCollection = sourceAdjustInfo.getEntries();
        this.queryAdjustDetails(ctx, entryCollection);
        int iSize = entryCollection.size();
        if (entryCollection == null || iSize == 0) {
            return sourceAdjustInfo;
        }
        BOSUuid bosUuid = null;
        for (int j = 0; j < iSize; ++j) {
            bosUuid = BOSUuid.create((BOSObjectType)bosType);
            entryIds.put(entryCollection.get(j).getId().toString(), bosUuid.toString());
            entryCollection.get(j).setId(bosUuid);
            entryCollection.get(j).setAdjust(null);
        }
        for (int i = 0; i < iSize; ++i) {
            AdjustEntryInfo adjustEntryInfo = entryCollection.get(i);
            AdjustDynamicItemCollection adjustDynamicItemCollection = adjustEntryInfo.getAdjustDynamicItem();
            if (adjustDynamicItemCollection == null || adjustDynamicItemCollection.isEmpty()) continue;
            adjustDynamicItemCollection.clear();
        }
        return sourceAdjustInfo;
    }

    @Override
    protected int _doTemplateBatchImportAdjustRecords(Context ctx, List listId, Map valueMap) throws BOSException, EASBizException {
        int successCount = 0;
        String orgTreeID = null;
        FullOrgUnitInfo fullOrgUnit = null;
        FullOrgUnitInfo companyOrgUnit = null;
        CurrencyInfo sourceCurrency = null;
        CurrencyInfo currency = null;
        RptSrcTypeEnum dataSource = null;
        Date date = null;
        Timestamp createTime = null;
        int periodType = -1;
        int year = -1;
        int period = -1;
        OrgTreeInfo OrgBound = null;
        String mnsRptGenerate = null;
        boolean param = false;
        if (valueMap != null) {
            if (valueMap.get("orgTreeID") != null) {
                orgTreeID = (String)valueMap.get("orgTreeID");
            }
            if (valueMap.get("fullOrgUnit") != null) {
                fullOrgUnit = (FullOrgUnitInfo)valueMap.get("fullOrgUnit");
            }
            if (valueMap.get("companyOrgUnit") != null) {
                companyOrgUnit = valueMap.get("companyOrgUnit") instanceof CompanyOrgUnitInfo ? ((CompanyOrgUnitInfo)valueMap.get("companyOrgUnit")).castToFullOrgUnitInfo() : (FullOrgUnitInfo)valueMap.get("companyOrgUnit");
            }
            if (valueMap.get("sourceCurrency") != null) {
                sourceCurrency = (CurrencyInfo)valueMap.get("sourceCurrency");
            }
            if (valueMap.get("currency") != null) {
                currency = (CurrencyInfo)valueMap.get("currency");
            }
            if (valueMap.get("dpkAdjustDate") != null) {
                date = (Date)valueMap.get("dpkAdjustDate");
            }
            if (valueMap.get("dpkCreateTime") != null) {
                createTime = new Timestamp(((Date)valueMap.get("dpkCreateTime")).getTime());
            }
            if (valueMap.get("comboDataSource") != null) {
                dataSource = (RptSrcTypeEnum)valueMap.get("comboDataSource");
            }
            if (valueMap.get("periodType") != null) {
                periodType = (Integer)valueMap.get("periodType");
            }
            if (valueMap.get("year") != null) {
                year = (Integer)valueMap.get("year");
            }
            if (valueMap.get("period") != null) {
                period = (Integer)valueMap.get("period");
            }
            if (valueMap.get("OrgBound") != null) {
                OrgBound = (OrgTreeInfo)valueMap.get("OrgBound");
            }
            if (valueMap.get("csl_Rpt_Generate_Entry") != null) {
                mnsRptGenerate = String.valueOf(valueMap.get("csl_Rpt_Generate_Entry"));
            }
            if (valueMap.get("GR_CSL_DCBalance") != null) {
                param = Boolean.valueOf(valueMap.get("GR_CSL_DCBalance").toString());
            }
        }
        boolean hasCodeRule = false;
        String orgID = "00000000-0000-0000-0000-000000000000CCE7AED4";
        AdjustInfo caller = new AdjustInfo();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        hasCodeRule = iCodingRuleManager.isExist((IObjectValue)caller, orgID);
        OrgTreeInfo orgTreeInfo = new OrgTreeInfo();
        orgTreeInfo.setId(BOSUuid.read((String)orgTreeID));
        IAdjustTemple iAdjustTemple = AdjustTempleFactory.getLocalInstance(ctx);
        AdjustTempleInfo templateInfo = null;
        AdjustTempleEntryCollection templeEntryCollection = null;
        String templateId = null;
        AdjustCollection adjustCollection = null;
        AdjustInfo adjustInfo = null;
        int rowIndex = 0;
        if (listId != null && listId.size() > 0) {
            Sheet sheet = null;
            try {
                sheet = this.initBook(ctx, fullOrgUnit, companyOrgUnit, sourceCurrency, currency, year, periodType, period, OrgBound);
            }
            catch (Exception e) {
                logger.error((Object)"initBook error.", (Throwable)e);
            }
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            adjustCollection = new AdjustCollection();
            for (int i = 0; i < listId.size(); ++i) {
                templateId = (String)listId.get(i);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("*"));
                selector.add(new SelectorItemInfo("entries.*"));
                selector.add(new SelectorItemInfo("entries.item.id"));
                selector.add(new SelectorItemInfo("entries.item.number"));
                selector.add(new SelectorItemInfo("entries.item.isProfitAndLosses"));
                selector.add(new SelectorItemInfo("entries.item.effectItem"));
                selector.add(new SelectorItemInfo("entries.company.number"));
                templateInfo = iAdjustTemple.getAdjustTempleInfo((IObjectPK)new ObjectUuidPK(templateId), selector);
                adjustInfo = new AdjustInfo();
                adjustInfo.setId(null);
                adjustInfo.setNumber(null);
                adjustInfo.setOrgBound(orgTreeInfo);
                if (fullOrgUnit != null) {
                    adjustInfo.setOrgUnit(fullOrgUnit);
                } else if (companyOrgUnit != null) {
                    adjustInfo.setOrgUnit(companyOrgUnit);
                }
                adjustInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                adjustInfo.setCreateTime(createTime);
                adjustInfo.setDate(date);
                adjustInfo.setSourceCurrency(sourceCurrency);
                adjustInfo.setCurrency(currency);
                adjustInfo.setTemplet(templateInfo);
                if (mnsRptGenerate != null && mnsRptGenerate.equals("csl_Rpt_Generate_Entry")) {
                    adjustInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
                } else {
                    adjustInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
                }
                adjustInfo.setAdjustMode(templateInfo.getAdjustMode());
                adjustInfo.setValueType(templateInfo.getValueType());
                adjustInfo.setIsCitedByLater(templateInfo.getIsCitedByLater());
                adjustInfo.setDataSource(dataSource);
                adjustInfo.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
                adjustInfo.setYear(year);
                adjustInfo.setPeriod(period);
                adjustInfo.setBizDate(timestamp);
                templeEntryCollection = templateInfo.getEntries();
                if (templeEntryCollection != null && templeEntryCollection.size() > 0) {
                    AdjustEntryInfo adjustEntryInfo = null;
                    for (int j = 0; j < templeEntryCollection.size(); ++j) {
                        adjustEntryInfo = new AdjustEntryInfo();
                        adjustEntryInfo.setId(null);
                        adjustEntryInfo.setAdjust(null);
                        adjustEntryInfo.setItem(templeEntryCollection.get(j).getItem());
                        adjustEntryInfo.setSummary(templeEntryCollection.get(j).getSummary());
                        adjustEntryInfo.setDataElement(templeEntryCollection.get(j).getDataElement());
                        adjustEntryInfo.setIsVisible(true);
                        adjustEntryInfo.setHasAdjustDetails(AdjustDetailsEnum.NO);
                        adjustInfo.getEntries().add(adjustEntryInfo);
                        Cell cell = null;
                        if (sheet != null) {
                            if (templeEntryCollection.get(j).getDebitFormula() != null) {
                                cell = sheet.getCell(rowIndex, 0, true);
                                cell.setFormula("=" + templeEntryCollection.get(j).getDebitFormula());
                            } else {
                                cell = sheet.getCell(rowIndex, 0, true);
                                cell.setFormula(null);
                                cell.setValue(Variant.emptyVariant);
                            }
                            if (templeEntryCollection.get(j).getCreditFormula() != null) {
                                cell = sheet.getCell(rowIndex, 1, true);
                                cell.setFormula("=" + templeEntryCollection.get(j).getCreditFormula());
                            } else {
                                cell = sheet.getCell(rowIndex, 1, true);
                                cell.setFormula(null);
                                cell.setValue(Variant.emptyVariant);
                            }
                        }
                        ++rowIndex;
                    }
                }
                adjustCollection.add(adjustInfo);
            }
        }
        Object[][] values = this.getCalcValues(rowIndex);
        if (adjustCollection != null) {
            IAdjust iAdjust = AdjustFactory.getLocalInstance(ctx);
            rowIndex = 0;
            BigDecimal zero = new BigDecimal(0);
            AdjustInfo newAdjustInfo = null;
            for (int i = 0; i < adjustCollection.size(); ++i) {
                int k;
                BigDecimal debitSum = new BigDecimal(0.0);
                BigDecimal creditSum = new BigDecimal(0.0);
                newAdjustInfo = adjustCollection.get(i);
                AdjustEntryCollection adjustEntryCollection = newAdjustInfo.getEntries();
                int entrySize = adjustEntryCollection.size();
                ArrayList<Integer> allEmptyEntryList = new ArrayList<Integer>();
                for (k = 0; k < entrySize; ++k) {
                    if (values[rowIndex][0] instanceof Number) {
                        adjustCollection.get(i).getEntries().get(k).setDebit((BigDecimal)values[rowIndex][0]);
                        debitSum = debitSum.add((BigDecimal)values[rowIndex][0]);
                    }
                    if (values[rowIndex][1] instanceof Number) {
                        adjustCollection.get(i).getEntries().get(k).setCredit((BigDecimal)values[rowIndex][1]);
                        creditSum = creditSum.add((BigDecimal)values[rowIndex][1]);
                    }
                    if (adjustEntryCollection.get(k).getDebit() == null && adjustEntryCollection.get(k).getCredit() == null || adjustEntryCollection.get(k).getCredit() != null && adjustEntryCollection.get(k).getDebit() == null && adjustEntryCollection.get(k).getCredit().compareTo(zero) == 0 || adjustEntryCollection.get(k).getDebit() != null && adjustEntryCollection.get(k).getDebit().compareTo(zero) == 0 && adjustEntryCollection.get(k).getCredit() == null || adjustEntryCollection.get(k).getDebit() != null && adjustEntryCollection.get(k).getCredit() != null && adjustEntryCollection.get(k).getDebit().compareTo(zero) == 0 && adjustEntryCollection.get(k).getCredit().compareTo(zero) == 0) {
                        allEmptyEntryList.add(new Integer(k));
                    }
                    ++rowIndex;
                }
                if (allEmptyEntryList.size() == entrySize || param && debitSum.compareTo(creditSum) != 0 && "csl_Rpt_Generate_Entry".equals(mnsRptGenerate)) continue;
                for (k = allEmptyEntryList.size() - 1; k >= 0; --k) {
                    adjustEntryCollection.removeObject((Integer)allEmptyEntryList.get(k));
                }
                if (hasCodeRule) {
                    adjustCollection.get(i).setNumber(null);
                    adjustCollection.get(i).setNumber(iCodingRuleManager.getNumber((IObjectValue)adjustCollection.get(i), orgID));
                } else {
                    String tableName = "t_csl_adjust";
                    BigDecimal number = new BigDecimal("1");
                    StringBuffer ret = new StringBuffer("AUTO_");
                    StringBuffer sbSQL = new StringBuffer(" SELECT Replace(fnumber,'AUTO_','') As Fnumber From \r\n");
                    sbSQL.append(tableName).append(" a  \r\n");
                    sbSQL.append("\tWHERE a.fOrgBoundId = '").append(orgTreeID).append("' \r\n");
                    sbSQL.append("  and a.fyear = ").append(year).append(" \r\n");
                    sbSQL.append("  and a.fperiod = ").append(period).append(" \r\n");
                    sbSQL.append("  and a.fperiodType = ").append(periodType).append(" \r\n");
                    sbSQL.append("  and a.fNumber like 'AUTO\\_%' ESCAPE '\\' \r\n");
                    try {
                        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
                        String tempNumber = "";
                        BigDecimal curNumber = new BigDecimal("1");
                        while (rowSet.next()) {
                            tempNumber = rowSet.getString("Fnumber");
                            if (StringUtils.isEmpty((String)tempNumber) || !tempNumber.matches("[0-9]{" + tempNumber.length() + "}") || number.compareTo(curNumber = new BigDecimal(tempNumber)) >= 0) continue;
                            number = curNumber;
                        }
                        if (number != null) {
                            number = number.add(new BigDecimal("1"));
                        }
                    }
                    catch (SQLException exc) {
                        throw new SQLDataException(exc);
                    }
                    int n = 8 - number.toString().length();
                    for (int k2 = 0; k2 < n; ++k2) {
                        ret.append("0");
                    }
                    ret.append(number);
                    newAdjustInfo.setNumber(ret.toString());
                }
                IObjectPK obPk = iAdjust.submit((CoreBaseInfo)newAdjustInfo);
                if (mnsRptGenerate != null && mnsRptGenerate.equals("csl_Rpt_Generate_Entry")) {
                    newAdjustInfo.setId(BOSUuid.read((String)obPk.toString()));
                    newAdjustInfo.setAuditor((UserInfo)ctx.get((Object)"UserInfo"));
                    newAdjustInfo.setAuditDate(new Timestamp(System.currentTimeMillis()));
                    this._passAudit(ctx, obPk, (IObjectValue)newAdjustInfo);
                }
                ++successCount;
            }
        }
        return successCount;
    }

    private Sheet initBook(final Context ctx, final FullOrgUnitInfo fullOrgUnit, final FullOrgUnitInfo companyOrgUnit, final CurrencyInfo sourceCurrency, final CurrencyInfo currency, final int year, final int periodType, final int period, final OrgTreeInfo OrgBound) throws Exception {
        if (this.book == null) {
            this.book = Book.Manager.getNewBook((String)"Sheet1", (int)1);
            this.book.setCalculate(false);
        }
        Sheet sheet = this.book.getSheet(0);
        FormulaDefinition.registerFormulaToBook((Book)this.book, (ICalculateContextProvider)new ICalculateContextProvider(){
            private static final long serialVersionUID = 4558806141205673468L;

            public IErrorProvider getErrorProvider() {
                return null;
            }

            public IErrorResultProvider getErrorResultProvider() {
                return null;
            }

            public IReportPropertyAdapter getReportAdapter() {
                CslReportInfo cslReport = new CslReportInfo();
                cslReport.setOrgTree(OrgBound);
                cslReport.setOrgUnit(fullOrgUnit);
                cslReport.setCompany(companyOrgUnit);
                cslReport.setYear(year);
                cslReport.setPeriod((short)period);
                cslReport.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
                cslReport.setSourceCurrency(sourceCurrency);
                cslReport.setCurrency(currency);
                CSLPropertyAdapter adapter = new CSLPropertyAdapter(cslReport, ctx);
                return adapter;
            }

            public ReportVariables getReportVariables() {
                return new ReportVariables();
            }

            public Context getServerContext() {
                return ctx;
            }
        });
        return sheet;
    }

    private Object[][] getCalcValues(int entrySize) {
        this.book.calc();
        Sheet sheet = this.book.getSheet(0);
        Cell cell = null;
        Object[][] values = new Object[entrySize][2];
        for (int i = 0; i < entrySize; ++i) {
            cell = sheet.getCell(i, 0, false);
            if (cell != null && cell.getValue() != null) {
                values[i][0] = cell.getValue().getValue();
            }
            if ((cell = sheet.getCell(i, 1, false)) == null || cell.getValue() == null) continue;
            values[i][1] = cell.getValue().getValue();
        }
        return values;
    }

    private void doSpecialRptItem(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AdjustInfo info = (AdjustInfo)model;
        AdjustEntryCollection entry = info.getEntries();
        int entrySize = 0;
        if (entry != null) {
            entrySize = entry.size();
        }
        AdjustEntryInfo lineInfo = null;
        ArrayList<AdjustEntryInfo> list = new ArrayList<AdjustEntryInfo>();
        if (entry != null && entrySize > 0) {
            for (int i = 0; i < entrySize; ++i) {
                lineInfo = entry.get(i);
                if (lineInfo.getItem() == null || lineInfo.getItem().getControl() != RPTItemControlEnum.UNSHARED_PROFIT && lineInfo.getItem().getControl() != RPTItemControlEnum.OVERSEAUNSHARED_PROFIT || lineInfo.isIsVisible()) continue;
                list.add(lineInfo);
            }
        }
        int n = list.size();
        for (int j = 0; j < n; ++j) {
            info.getEntries().removeObject((IObjectValue)((AdjustEntryInfo)list.get(j)));
        }
        if (info.getEntries().size() == 0) {
            throw new AdjustException(AdjustException.LINE_NOT_EXIST);
        }
        entry = info.getEntries();
        if (entry != null) {
            entrySize = entry.size();
        }
        if (entry != null && entrySize > 0) {
            BigDecimal debitTotal = new BigDecimal("0");
            BigDecimal creditTotal = new BigDecimal("0");
            BigDecimal debitTotalOverSea = new BigDecimal("0");
            BigDecimal creditTotalOverSea = new BigDecimal("0");
            for (int i = 0; i < entrySize; ++i) {
                boolean isDoSpecialSummay;
                lineInfo = entry.get(i);
                if (lineInfo.getItem() == null) continue;
                String summay = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AdjustBAutoCreate", (Locale)ctx.getOriginLocale()) + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"94_AdjustControllerBean", (Locale)ctx.getOriginLocale());
                boolean bl = isDoSpecialSummay = lineInfo.getSummary() == null || !lineInfo.getSummary().startsWith(summay);
                if (!lineInfo.getItem().isIsProfitAndLosses() || lineInfo.getDataElement() != 3 || !isDoSpecialSummay || lineInfo.getBoolean("isAutoCreateParentItem")) continue;
                if (RPTEffectItemEnum.UNSHARED_PROFIT.equals((Object)lineInfo.getItem().getEffectItem())) {
                    if (lineInfo.getDebit() != null) {
                        debitTotal = debitTotal.add(lineInfo.getDebit());
                    }
                    if (lineInfo.getCredit() == null) continue;
                    creditTotal = creditTotal.add(lineInfo.getCredit());
                    continue;
                }
                if (!RPTEffectItemEnum.OVERSEAUNSHARED_PROFIT.equals((Object)lineInfo.getItem().getEffectItem())) continue;
                if (lineInfo.getDebit() != null) {
                    debitTotalOverSea = debitTotalOverSea.add(lineInfo.getDebit());
                }
                if (lineInfo.getCredit() == null) continue;
                creditTotalOverSea = creditTotalOverSea.add(lineInfo.getCredit());
            }
            lineInfo = entry.get(entrySize - 1);
            int seq = lineInfo.getSeq() + 1;
            if (debitTotal.compareTo(creditTotal) != 0) {
                this.addAdjustEntry(ctx, info, debitTotal, creditTotal, seq, false);
            }
            if (debitTotalOverSea.compareTo(creditTotalOverSea) != 0) {
                if (debitTotal.compareTo(creditTotal) != 0) {
                    ++seq;
                }
                this.addAdjustEntry(ctx, info, debitTotalOverSea, creditTotalOverSea, seq, true);
            }
        }
    }

    private RPTItemInfo getUnAssignRptItemId(Context ctx, boolean isOverSea) throws BOSException, EASBizException {
        String ControlEnumAlias = "";
        int ControlEnumValues = 1;
        if (!isOverSea) {
            ControlEnumAlias = RPTItemControlEnum.UNSHARED_PROFIT.getAlias();
            ControlEnumValues = 27;
        } else {
            ControlEnumAlias = RPTItemControlEnum.OVERSEAUNSHARED_PROFIT.getAlias();
            ControlEnumValues = 28;
        }
        String oql = "SELECT id,number WHERE isFreezed = 0 and Control = " + ControlEnumValues;
        RPTItemCollection items = RPTItemFactory.getLocalInstance(ctx).getRPTItemCollection(oql);
        if (items != null && items.size() > 0) {
            return items.get(0);
        }
        throw new AdjustException(AdjustException.UN_EXIST_UNSHARED_RPTITEM, new Object[]{ControlEnumAlias});
    }

    @Override
    protected Map _copyHisData(Context ctx, String orgTreeId, int periodType, int year, int period, String tableName, List list, boolean select, IObjectValue dataCollect, int resultStatus) throws BOSException, EASBizException {
        BOSObjectType bosType = new AdjustDynamicItemInfo().getBOSType();
        HashMap<String, String> entryIds = new HashMap<String, String>();
        BOSUuid bosUuid = null;
        OrgTreeInfo orgTree = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)new ObjectUuidPK(orgTreeId));
        boolean isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod(ctx);
        PeriodCollection periods = null;
        if (FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, RptPeriodTypeEnum.getEnum((int)periodType))) {
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, orgTree);
        }
        Iterator iter = null;
        ArrayList<AbstractAdjustEntryInfo> array = new ArrayList<AbstractAdjustEntryInfo>();
        AbstractAdjustEntryInfo lineInfo = null;
        RPTItemInfo itemInfo1 = null;
        String oql = "select id,dc, number, name, effectItem, isprofitandlosses where isFreezed=0 and control=10";
        RPTItemCollection itemCol = RPTItemFactory.getLocalInstance(ctx).getRPTItemCollection(oql);
        if (itemCol.size() > 0) {
            itemInfo1 = itemCol.get(0);
        }
        this.initCodeRule(ctx);
        iter = list.iterator();
        AdjustInfo info = null;
        UserInfo nowUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        Timestamp time = new Timestamp(System.currentTimeMillis());
        ArrayList<String> lstResult = new ArrayList<String>();
        HashMap<String, ArrayList<String>> mapResult = new HashMap<String, ArrayList<String>>();
        String strNumber = null;
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        while (iter.hasNext()) {
            BigDecimal debit = new BigDecimal("0");
            BigDecimal credit = new BigDecimal("0");
            BigDecimal zero = new BigDecimal("0");
            String id = iter.next().toString();
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("date"));
            sic.add(new SelectorItemInfo("adjustMode.name"));
            sic.add(new SelectorItemInfo("templet.id"));
            sic.add(new SelectorItemInfo("templet.name"));
            sic.add(new SelectorItemInfo("dataSource"));
            sic.add(new SelectorItemInfo("valueType"));
            sic.add(new SelectorItemInfo("currency.name"));
            sic.add(new SelectorItemInfo("sourceCurrency.name"));
            sic.add(new SelectorItemInfo("entries.summary"));
            sic.add(new SelectorItemInfo("entries.item.effectItem"));
            sic.add(new SelectorItemInfo("entries.item.id"));
            sic.add(new SelectorItemInfo("entries.item.dc"));
            sic.add(new SelectorItemInfo("entries.item.number"));
            sic.add(new SelectorItemInfo("entries.item.name"));
            sic.add(new SelectorItemInfo("entries.item.isProfitAndLosses"));
            sic.add(new SelectorItemInfo("entries.item.effectItem"));
            sic.add(new SelectorItemInfo("entries.debit"));
            sic.add(new SelectorItemInfo("entries.credit"));
            sic.add(new SelectorItemInfo("entries.isVisible"));
            sic.add(new SelectorItemInfo("entries.hasAdjustDetails"));
            sic.add(new SelectorItemInfo("creator.name"));
            sic.add(new SelectorItemInfo("createTime"));
            sic.add(new SelectorItemInfo("CheckedStatus"));
            sic.add(new SelectorItemInfo("auditor.name"));
            sic.add(new SelectorItemInfo("auditDate"));
            sic.add(new SelectorItemInfo("orgUnit.name"));
            sic.add(new SelectorItemInfo("orgUnit.number"));
            sic.add(new SelectorItemInfo("orgUnit.id"));
            sic.add(new SelectorItemInfo("orgUnit.isUnion"));
            sic.add(new SelectorItemInfo("entries.id"));
            sic.add(new SelectorItemInfo("entries.dataElement"));
            sic.add(new SelectorItemInfo("orgBound.id"));
            sic.add(new SelectorItemInfo("entries.adjust.id"));
            sic.add(new SelectorItemInfo("entries.seq"));
            sic.add(new SelectorItemInfo("isCitedByLater"));
            sic.add(new SelectorItemInfo("isFixed"));
            sic.add(new SelectorItemInfo("remark"));
            sic.add(new SelectorItemInfo("dataCollect.name"));
            sic.add(new SelectorItemInfo("dataCollectNumber"));
            sic.add(new SelectorItemInfo("customNumber"));
            sic.add(new SelectorItemInfo("entries.adjustDynamicItem.*"));
            sic.add(new SelectorItemInfo("year"));
            sic.add(new SelectorItemInfo("period"));
            info = this.getAdjustInfo(ctx, (IObjectPK)pk, sic);
            AdjustInfo sourceAjustInfo = new AdjustInfo();
            sourceAjustInfo.setId(info.getId());
            info.setSourceAdjust(sourceAjustInfo);
            info.setBizDate(timestamp);
            if ((info.getDataSource().getValue() == 2 || info.getDataSource().getValue() == 3) && (new Timestamp(info.getDate().getTime()).compareTo(orgTree.getStartDate()) < 0 || orgTree.getEndDate() != null && new Timestamp(info.getDate().getTime()).compareTo(orgTree.getEndDate()) > 0)) {
                String oldUnitId = info.getOrgUnit().getId().toString();
                String oldUnitNumber = info.getOrgUnit().getNumber();
                boolean oldUnitIsUnion = info.getOrgUnit().isIsUnion();
                String newTreeId = orgTreeId;
                String oldTreeId = info.getOrgBound().getId().toString();
                String newUnitId = null;
                StringBuffer sql = new StringBuffer();
                ArrayList<Object> arr = new ArrayList<Object>();
                sql.append(" select structure.funitid \n");
                sql.append(" from t_org_structure structure \n");
                sql.append(" inner join t_org_baseunit unit on structure.FUNITID = unit.fid \n");
                sql.append(" where structure.ftreeid = ? \n");
                arr.add(newTreeId);
                sql.append(" and unit.fnumber = ? And unit.FIsUnion = ? \n");
                arr.add(oldUnitNumber);
                arr.add(oldUnitIsUnion ? 1 : 0);
                IRowSet rstemp = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])arr.toArray());
                try {
                    if (rstemp.next()) {
                        newUnitId = rstemp.getString("funitid");
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
                FullOrgUnitCollection newUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection("select id where id = '" + newUnitId + "'");
                if (newUnitInfo.size() <= 0) continue;
                info.setOrgUnit(newUnitInfo.get(0));
            }
            info.setOrgBound(orgTree);
            try {
                info.setDate(FiscalPeriodHelper.getPeriodLastDate(periods, year, period, RptPeriodTypeEnum.getEnum((int)periodType), isMergeByFiscalPeriod));
            }
            catch (Exception e) {
                info.setDate(RPTDate13Util.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType)));
            }
            int oldYear = info.getYear();
            int oldPeriod = info.getPeriod();
            strNumber = info.getNumber();
            info.setYear(year);
            info.setPeriod(period);
            info.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
            info.setId(null);
            info.setNumber(null);
            if (resultStatus == 1 && info.getCheckedStatus().getValue() == 2) {
                info.setAuditDate(time);
                info.setAuditor(nowUser);
                info.setCheckedStatus(CheckedStatusEnum.AUDITED);
            } else {
                info.setAuditDate(null);
                info.setAuditor(null);
                info.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
            }
            info.setCreator(nowUser);
            info.setCreateTime(time);
            AdjustEntryCollection col = info.getEntries();
            this.queryAdjustDetails(ctx, col);
            boolean isGeneratePeriod = FiscalPeriodHelper.isGeneratePeriod(periods, oldYear, oldPeriod, RptPeriodTypeEnum.getEnum((int)periodType), isMergeByFiscalPeriod);
            AdjustDynamicItemCollection adjustDynamicItems = null;
            for (int i = 0; i < col.size(); ++i) {
                adjustDynamicItems = col.get(i).getAdjustDynamicItem();
                for (int j = 0; j < adjustDynamicItems.size(); ++j) {
                    adjustDynamicItems.get(j).setId(null);
                }
                if (isGeneratePeriod && col.get(i).getItem().isIsProfitAndLosses() && col.get(i).getDataElement() == 3 && select && col.get(i).isIsVisible()) {
                    lineInfo = info.getEntries().get(i);
                    if (col.get(i).getDebit() != null) {
                        debit = debit.add(col.get(i).getDebit());
                    } else if (col.get(i).getCredit() != null) {
                        credit = credit.add(col.get(i).getCredit());
                    }
                    array.add(col.get(i));
                } else if (col.get(i).getSummary() != null && (col.get(i).getSummary().equals("AdjustEntry_Auto_Summary") || col.get(i).getSummary().equals(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"97_AdjustControllerBean", (Locale)ctx.getOriginLocale())))) {
                    array.add(col.get(i));
                } else {
                    bosUuid = BOSUuid.create((BOSObjectType)bosType);
                    entryIds.put(col.get(i).getId().toString(), bosUuid.toString());
                    col.get(i).setId(bosUuid);
                    col.get(i).getAdjust().setId(null);
                }
                info.getEntries();
            }
            if (!array.isEmpty()) {
                int j;
                int n = array.size();
                for (j = 0; j < n; ++j) {
                    info.getEntries().remove((AdjustEntryInfo)array.get(j));
                }
                array.clear();
                if (lineInfo != null) {
                    lineInfo.setDataElement(3);
                    lineInfo.setItem(itemInfo1);
                    bosUuid = BOSUuid.create((BOSObjectType)bosType);
                    entryIds.put(lineInfo.getId().toString(), bosUuid.toString());
                    lineInfo.setId(bosUuid);
                    lineInfo.getAdjust().setId(null);
                    if (debit.subtract(credit).compareTo(zero) == 1) {
                        lineInfo.setDebit(debit.subtract(credit));
                        lineInfo.setCredit(null);
                    } else if (debit.subtract(credit).compareTo(zero) == -1) {
                        lineInfo.setCredit(credit.subtract(debit));
                        lineInfo.setDebit(null);
                    } else if (debit.subtract(credit).compareTo(zero) == 0 || debit.subtract(credit).compareTo(zero) == 0) {
                        lineInfo.setDebit(null);
                        lineInfo.setCredit(null);
                        array.add(lineInfo);
                    }
                    col.add((AdjustEntryInfo)lineInfo);
                    n = array.size();
                    for (j = 0; j < n; ++j) {
                        info.getEntries().remove((AdjustEntryInfo)array.get(j));
                    }
                    array.clear();
                }
            }
            if (info.getEntries().size() == 0) continue;
            lstResult.add(strNumber);
            if (!this.hasCodeRule) {
                BigDecimal number = new BigDecimal("0");
                StringBuffer ret = new StringBuffer("AUTO_");
                StringBuffer sbSQL = new StringBuffer(" SELECT Replace(fnumber,'AUTO_','') As Fnumber From \r\n");
                sbSQL.append(tableName).append(" a  \r\n");
                sbSQL.append("\tWHERE a.fOrgBoundId = '").append(orgTreeId).append("' \r\n");
                sbSQL.append("  and a.fyear = ").append(year).append(" \r\n");
                sbSQL.append("  and a.fperiod = ").append(period).append(" \r\n");
                sbSQL.append("  and a.fperiodType = ").append(periodType).append(" \r\n");
                sbSQL.append("  and a.fNumber like 'AUTO\\_%' ESCAPE '\\' \r\n");
                try {
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
                    String tempNumber = "";
                    BigDecimal curNumber = new BigDecimal("1");
                    while (rowSet.next()) {
                        tempNumber = rowSet.getString("Fnumber");
                        if (StringUtils.isEmpty((String)tempNumber) || !tempNumber.matches("[0-9]{" + tempNumber.length() + "}") || number.compareTo(curNumber = new BigDecimal(tempNumber)) >= 0) continue;
                        number = curNumber;
                    }
                    if (number != null) {
                        number = number.add(new BigDecimal("1"));
                    }
                }
                catch (SQLException exc) {
                    throw new SQLDataException(exc);
                }
                int n = 8 - number.toString().length();
                for (int i = 0; i < n; ++i) {
                    ret.append("0");
                }
                ret.append(number);
                info.setNumber(ret.toString());
            }
            info.setDataCollect((DataCollectInfo)dataCollect);
            info.setDataCollectNumber(((DataCollectInfo)dataCollect).getNumber());
            info.remove("id");
            this.submit(ctx, (CoreBaseInfo)info);
        }
        list.clear();
        list.size();
        mapResult.put("successRecord", lstResult);
        return mapResult;
    }

    @Override
    protected void _forbidCitedByLater(Context ctx, List list) throws BOSException, EASBizException {
        Iterator iter = list.iterator();
        AdjustInfo info = null;
        while (iter.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)iter.next().toString()));
            info = this.getAdjustInfo(ctx, (IObjectPK)pk);
            IsCitedByLaterEnum isCited = IsCitedByLaterEnum.ISFALSE;
            info.setIsCitedByLater(isCited);
            this._update(ctx, (IObjectPK)pk, (IObjectValue)info);
        }
        list.clear();
    }

    @Override
    protected void _unForbidCitedByLater(Context ctx, List list) throws BOSException, EASBizException {
        Iterator iter = list.iterator();
        AdjustInfo info = null;
        while (iter.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)iter.next().toString()));
            info = this.getAdjustInfo(ctx, (IObjectPK)pk);
            IsCitedByLaterEnum isCited = IsCitedByLaterEnum.ISTRUE;
            info.setIsCitedByLater(isCited);
            this._update(ctx, (IObjectPK)pk, (IObjectValue)info);
        }
        list.clear();
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("orgunit.name"));
        AdjustInfo info = this.getAdjustInfo(ctx, pk, sc);
        StringBuffer retValue = new StringBuffer();
        if (info.getOrgUnit() != null && !StringUtils.isEmpty((String)info.getOrgUnit().getName())) {
            retValue.append(info.getOrgUnit().getName()).append(" ");
        }
        retValue.append(info.getYear()).append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"nian", (Locale)ContextUtils.getLocaleFromEnv()));
        retValue.append(info.getPeriod()).append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"qi1", (Locale)ContextUtils.getLocaleFromEnv())).append(" ");
        retValue.append(info.getNumber());
        return retValue.toString();
    }

    @Override
    protected boolean _removeBatch(Context ctx, List idList) throws BOSException, EASBizException {
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < idList.size(); ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)idList.get(i).toString()));
            try {
                CslRptUtil.invokeByManual(this, "delete", new Class[]{Context.class, IObjectPK.class}, new Object[]{ctx, pk}, 3);
                continue;
            }
            catch (Exception e) {
                Throwable undeclaredThrow;
                if (e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof UndeclaredThrowableException && (undeclaredThrow = ((UndeclaredThrowableException)e.getCause().getCause()).getUndeclaredThrowable()) instanceof InvocationTargetException && ((InvocationTargetException)undeclaredThrow).getTargetException() != null && ((InvocationTargetException)undeclaredThrow).getTargetException() instanceof ObjectReferedException) {
                    AdjustInfo info = AdjustFactory.getLocalInstance(ctx).getAdjustInfo("select number where id='" + pk.toString() + "'");
                    if (((InvocationTargetException)undeclaredThrow).getTargetException().getCause() != null && !StringUtils.isEmpty((String)((InvocationTargetException)undeclaredThrow).getTargetException().getCause().getMessage())) {
                        msg.append(info.getNumber() + ((InvocationTargetException)undeclaredThrow).getTargetException().getCause().getMessage()).append("\n");
                    }
                }
                logger.error((Object)("remover adjust error:" + pk), (Throwable)e);
            }
        }
        if (msg.length() > 0) {
            throw new BOSException(msg.toString());
        }
        return true;
    }

    @Override
    protected boolean _isImport(Context ctx, Map param) throws BOSException, EASBizException {
        OrgTreeInfo tree = (OrgTreeInfo)param.get("orgBound");
        OrgTreeCollection orgTreeColl = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeCollection("select number where basic = 1 and type = 8 and status = 1");
        return orgTreeColl != null && orgTreeColl.size() > 0 && orgTreeColl.get(0).getNumber().equals(tree.getNumber());
    }

    @Override
    protected Map _getDataZipForRPC(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        if ("elimType".equals(params.get("operType"))) {
            OrgTreeInfo orgBound = (OrgTreeInfo)params.get("orgBound");
            HashMap<String, OrgTreeInfo> importParams = new HashMap<String, OrgTreeInfo>(2);
            importParams.put("orgBound", orgBound);
            result.put("isImport", this.isImport(ctx, importParams));
            if (!orgBound.containsKey("isForBudget")) {
                IOrgTree iOrgTree = OrgTreeFactory.getLocalInstance((Context)ctx);
                orgBound = iOrgTree.getOrgTreeInfo((IObjectPK)new ObjectStringPK(orgBound.getId().toString()));
            }
            result.put("isForBudget", orgBound.isIsForBudget());
            return result;
        }
        HashMap cslParams = (HashMap)params.get("cslParams");
        boolean isQueryBudget = false;
        if (params.get("ISQUERYBUDGET") != null) {
            isQueryBudget = (Boolean)params.get("ISQUERYBUDGET");
        }
        List items = AdjustDynamicItemFactory.getLocalInstance(ctx).getExistDyItemAdjusts(cslParams, null, isQueryBudget);
        result.put("adjustDynamicItem", items);
        if (params.get("AdjustWorktableUI") == null) {
            OrgTreeInfo orgBound = (OrgTreeInfo)params.get("orgBound");
            HashMap<String, OrgTreeInfo> importParams = new HashMap<String, OrgTreeInfo>(2);
            importParams.put("orgBound", orgBound);
            result.put("isImport", this.isImport(ctx, importParams));
        }
        return result;
    }

    @Override
    protected AdjustCollection _getAdjustForRemove(Context ctx, List idList) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < idList.size(); ++i) {
            idSet.add(idList.get(i).toString());
        }
        if (idSet.size() == 0) {
            return new AdjustCollection();
        }
        EntityViewInfo v = new EntityViewInfo();
        v.getSelector().add(new String("id"));
        v.getSelector().add(new String("number"));
        v.getSelector().add(new String("checkedStatus"));
        v.getSelector().add(new String("convertBefore"));
        FilterInfo f = new FilterInfo();
        v.setFilter(f);
        f.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        f.getFilterItems().add(new FilterItemInfo("convertBefore", idSet, CompareType.INCLUDE));
        f.setMaskString("#0 or #1");
        AdjustCollection infos = this.getAdjustCollection(ctx, v);
        idSet.clear();
        for (int i = 0; i < infos.size(); ++i) {
            AdjustInfo info = infos.get(i);
            if (info.getConvertBefore() == null || info.getConvertBefore().length() <= 0) continue;
            idSet.add(info.getConvertBefore());
        }
        if (idSet.size() > 0) {
            f = new FilterInfo();
            f.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            v.setFilter(f);
            infos.addCollection(this.getAdjustCollection(ctx, v));
        }
        return infos;
    }

    @Override
    protected String _getBasicOrgTree(Context ctx, Map param) throws BOSException, EASBizException {
        int year = (Integer)param.get("year");
        int period = (Integer)param.get("period");
        int periodType = (Integer)param.get("periodType");
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid from t_org_tree where fisbasic = 1 and ftype= 8 and fstartdate < Timestamp'" + new Timestamp(RPTDate13Util.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType)).getTime()) + "' and (fenddate is null or fenddate > Timestamp'" + new Timestamp(RPTDate13Util.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType)).getTime()) + "')");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String orgTreeId = null;
        try {
            if (rs.next()) {
                orgTreeId = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return orgTreeId;
    }

    private void deleteElimRelaOrgTree(Context ctx, AdjustInfo info) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_CSL_ElimRelaOrgTree where FCurrentElimId ='").append(info.getId().toString()).append("'");
        sql.append(" and FOrgTreeId ='").append(info.getOrgBound().getId().toString()).append("'");
        sql.append(" and (FRecordType=").append(0);
        sql.append(" or FRecordType = ").append(2);
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected AdjustCollection _getAdjustInOtherTree(Context ctx, String sourceTreeId, String importedTreeId, String unitId, int startYear, int startPeriod, int endYear, int endPeriod, int periodType) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select s2.funitid as FCompanyId from t_org_structure s1 ");
        sql.append(" inner join t_org_structure s2 on s1.ftreeid = s2.ftreeid ");
        sql.append(" and charindex(s1.flongnumber||'!', s2.flongnumber)=1 ");
        sql.append(" where s1.ftreeid = '" + importedTreeId + "' and s1.funitid = '" + unitId + "' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer bf = new StringBuffer("");
        try {
            while (rs.next()) {
                bf.append("'" + rs.getString("FCompanyId") + "',");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (0 < rs.size()) {
            bf.deleteCharAt(bf.lastIndexOf(","));
        }
        OrgTreeInfo sourceTree = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)new ObjectStringPK(sourceTreeId));
        AdjustCollection list = null;
        IAdjust iAdjust = AdjustFactory.getLocalInstance(ctx);
        StringBuffer oql = new StringBuffer();
        oql.append("SELECT id,number,adjustMode.name,year,period,orgUnit.name,sourceCurrency.name,currency.name,orgBound.id,isFixed ");
        oql.append("WHERE (year > ").append(startYear);
        oql.append(" or (year = ").append(startYear).append(" and period >= ").append(startPeriod);
        oql.append(")) and (year < ").append(endYear);
        oql.append(" or (year = ").append(endYear).append(" and period <= ").append(endPeriod);
        oql.append("))  AND periodType = ").append(periodType);
        oql.append("  AND orgBound.number  = '").append(sourceTree.getNumber());
        oql.append("' AND orgUnit.id in (").append(bf.toString()).append(")");
        oql.append(" and isCitedByLater = 1 ORDER BY orgUnit.id, year, period, number");
        list = iAdjust.getAdjustCollection(oql.toString());
        return list;
    }

    @Override
    protected String _getAutoNumber(Context ctx, String treeId, int year, int period, int periodType) throws BOSException, EASBizException {
        BigDecimal number = new BigDecimal("1");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT Max(to_int(Replace(fnumber,'AUTO_',''))) As Fmaxnumber From ");
        sql.append(" t_csl_adjust a  \r\n");
        sql.append("  WHERE a.fOrgBoundId = ? \r\n");
        sql.append("  and a.fyear = ? \r\n");
        sql.append("  and a.fperiod = ? \r\n");
        sql.append("  and a.fperiodType = ? \r\n");
        sql.append("  and a.fNumber like N'AUTO_%' \r\n");
        Object[] param = new Object[]{treeId, new Integer(year), new Integer(period), new Integer(periodType)};
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
            if (rs.next() && rs.getBigDecimal("Fmaxnumber") != null) {
                number = rs.getBigDecimal("Fmaxnumber").add(new BigDecimal("1"));
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        StringBuffer result = new StringBuffer("AUTO_");
        int n = 8 - number.toString().length();
        for (int i = 0; i < n; ++i) {
            result.append("0");
        }
        result.append(number);
        return result.toString();
    }

    @Override
    protected Map _getPermissionUnion(Context ctx, Map param) throws BOSException, EASBizException {
        String treeId = (String)param.get("treeId");
        if (StringUtils.isEmpty((String)treeId)) {
            return new HashMap(2);
        }
        HashMap map = new HashMap(2);
        IObjectPK userPk = ctx.getCaller();
        ObjectStringPK treePk = new ObjectStringPK(treeId);
        Map unionMap = CslOrgTreeUtil.getAuthorizedOrgs(ctx, userPk, (IObjectPK)treePk, true);
        map.put(treeId, new HashSet(unionMap.keySet()));
        return map;
    }

    @Override
    protected Map _getOrgUnit(Context ctx, Set idList) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select unit.fname_" + ctx.getLocale() + " from t_org_baseunit unit join t_org_structure stru on unit.fid = stru.funitid ");
        sql.append("\r\n where stru.fid in(select str.fparentid from t_org_structure str join t_org_tree tree on str.ftreeid = tree.fid ");
        sql.append("\r\n and str.fisleaf =1 join t_org_baseunit unit2 on unit2.fid = str.funitid ");
        sql.append("\r\n join t_csl_adjust t1 on tree.fid=t1.forgboundid and unit2.fid=t1.forgunit  ");
        sql.append("\r\n where t1.fid in ");
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select base.fname_" + ctx.getLocale() + ",adjust.fid from t_org_baseunit base join t_org_structure str on base.fid = str.funitid");
        sql2.append("\r\n and str.fisleaf =0 join t_csl_adjust adjust on str.ftreeid = adjust.forgboundid and str.funitid=adjust.forgunit ");
        sql2.append("\r\n where adjust.fid in (");
        IRowSet rowset = null;
        HashMap<Object, String> result = null;
        Object[] obj = null;
        if (idList != null && idList.size() > 0) {
            try {
                result = new HashMap<Object, String>();
                obj = idList.toArray();
                for (int i = 0; i < obj.length; ++i) {
                    sql2.append("'").append(obj[i]).append("'");
                    if (i + 1 >= obj.length) continue;
                    sql2.append(",");
                }
                sql2.append(")");
                rowset = DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
                if (rowset != null) {
                    while (rowset.next()) {
                        result.put(rowset.getString(2), rowset.getString(1));
                        idList.remove(rowset.getObject(2));
                    }
                }
                if (idList.size() > 0) {
                    obj = idList.toArray();
                    sql.append("(");
                    for (int k = 0; k < obj.length; ++k) {
                        sql.append("'").append(obj[k]).append("'");
                        if (k + 1 >= obj.length) continue;
                        sql.append(",");
                    }
                    sql.append("))");
                    rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    if (rowset != null) {
                        int index = 0;
                        while (rowset.next()) {
                            result.put(obj[index], rowset.getString(1));
                            ++index;
                        }
                    }
                }
            }
            catch (SQLException exc) {
                throw new SQLDataException(exc);
            }
        }
        return result;
    }

    @Override
    protected AdjustTempleCollection _getCurrentAdjustTemplate(Context ctx, Map map) throws BOSException, EASBizException {
        AdjustTempleCollection templetCollection = null;
        Map<String, String> dispenseParams = this.getDispenseParam(ctx, map);
        map.put("dispenseParams", dispenseParams);
        StringBuffer filterSql = this.getAdjustTemplateFilterSql(dispenseParams);
        if (filterSql != null && 0 < filterSql.length()) {
            List typeIds;
            StringBuffer osql = new StringBuffer();
            osql.append("select id,number,name,adjustmode,adjustmode.name,valueType,isCitedByLater,orgUnit,orgUnit.*,entries.*,entries.debitFormula,entries.creditFormula,entries.item,entries.item.number,entries.item.name").append("\r\n");
            osql.append(" where checkedstatus = '").append(2).append("'").append("\r\n");
            osql.append(" and id in (").append(filterSql.toString()).append(")").append("\r\n");
            if (map != null && map.get("adjustTmpTypeIds") != null && (typeIds = (List)map.get("adjustTmpTypeIds")).size() > 0) {
                String idStr = CslRptUtil.changeIdIter2String(typeIds.iterator());
                osql.append(" and id in(").append(idStr).append(")");
            }
            osql.append(" order by number asc ").append("\r\n");
            IAdjustTemple iAdjustTemplet = AdjustTempleFactory.getLocalInstance(ctx);
            templetCollection = iAdjustTemplet.getAdjustTempleCollection(osql.toString());
        }
        return templetCollection;
    }

    private StringBuffer getAdjustTemplateFilterSql(Map map) {
        StringBuffer filterSql = new StringBuffer();
        Set keys = map.keySet();
        for (String key : keys) {
            filterSql.append("'").append(key).append("'").append(",");
        }
        if (keys.size() > 0) {
            filterSql.deleteCharAt(filterSql.length() - 1);
        }
        return filterSql;
    }

    private Map<String, String> getDispenseParam(Context ctx, Map map) throws BOSException {
        HashMap<String, String> params = new HashMap<String, String>();
        String orgUnitID = null;
        String orgBoundId = null;
        if (map != null) {
            if (map.get("orgUnitID") != null) {
                orgUnitID = (String)map.get("orgUnitID");
            }
            if (map.get("orgBoundId") != null) {
                orgBoundId = (String)map.get("orgBoundId");
            }
        }
        StringBuffer querySql = new StringBuffer();
        if (map.get("autoGenerateAdjust") == null) {
            querySql.append("select FDispenseSrcID dispenseSrcID, FCompanyID companyID from T_CSL_AdjustAndElimDispense ").append("\r\n");
            querySql.append(" where FSourceType = 1 ").append("\r\n");
            if (orgUnitID != null) {
                querySql.append("and FCompanyID = '").append(orgUnitID).append("'").append("\r\n");
            }
            if (orgBoundId != null) {
                querySql.append(" and FOrgBoundID = '").append(orgBoundId).append("'").append("\r\n");
            }
        } else if ("true".equals(map.get("autoGenerateAdjust"))) {
            this.appendSelectDispenseSql(querySql, orgUnitID, orgBoundId);
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        try {
            while (rs.next()) {
                String value = rs.getString("companyID");
                params.put(rs.getString("dispenseSrcID"), value);
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        return params;
    }

    private void appendSelectDispenseSql(StringBuffer querySql, String orgUnitID, String orgBoundId) {
        querySql.append("select distinct dispense.FDispenseSrcID dispenseSrcID, dispense.FCompanyID companyID from T_CSL_AdjustAndElimDispense dispense").append("\r\n");
        querySql.append("join t_org_structure structure on structure.FTREEID=dispense.FOrgBoundId and structure.FUNITID = dispense.FCompanyID").append("\r\n");
        querySql.append("join t_org_tree tree on tree.fid=dispense.FOrgBoundId").append("\r\n");
        querySql.append("join t_org_baseunit unit on unit.fid=structure.FUNITID").append("\r\n");
        querySql.append("where dispense.FSourceType = 1 ").append("\r\n");
        querySql.append("and tree.fid ='").append(orgBoundId).append("'").append("\r\n");
        if (orgUnitID != null) {
            querySql.append("and (structure.funitid = '").append(orgUnitID).append("'").append("\r\n");
            querySql.append(" or (structure.FPARENTID in (select str.fid from t_org_structure str where str.FTREEID = '").append(orgBoundId).append("' ");
            querySql.append(" and str.FUNITID ='").append(orgUnitID).append("')))");
        }
    }

    @Override
    protected void _copyFixedAdjustData(Context ctx, String orgTreeId, int periodType, int year, int period, IObjectValue dataCollect, String orgUnitId) throws BOSException, EASBizException {
        Map map = this.getNumber(ctx, orgUnitId, orgTreeId);
        String treeNumber = (String)map.get("treeNumber");
        String unitNumber = (String)map.get("unitNumber");
        int[] pre = null;
        boolean isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod(ctx);
        PeriodCollection periods = null;
        if (FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, RptPeriodTypeEnum.getEnum((int)periodType))) {
            OrgTreeInfo orgTree = new OrgTreeInfo();
            orgTree.setId(BOSUuid.read((String)orgTreeId));
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, orgTree);
        }
        pre = FiscalPeriodHelper.getPrevYearAndPeriod(periods, year, period, RptPeriodTypeEnum.getEnum((int)periodType), isMergeByFiscalPeriod, CslRptUtil.isSupport13Period(ctx));
        ArrayList<String> list = new ArrayList<String>();
        DataCollectInfo dataColInfo = (DataCollectInfo)dataCollect;
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct TPreAdjust.fid from t_csl_adjust TPreAdjust ");
        sql.append(" inner join T_ORG_Structure tstru on tstru.FUnitId=TPreAdjust.FOrgUnit");
        sql.append(" inner join T_Org_Tree tree2 on tree2.fid = tstru.ftreeid and tree2.fnumber = ?");
        sql.append(" left join T_ORG_Structure tParentStru on tParentStru.FId=tstru.FParentID");
        sql.append(" left join T_Org_Tree tree3 on tree3.fid = tParentStru.ftreeid and tree3.fnumber = ?");
        sql.append(" inner join T_Org_Tree tree on tree.fid = TPreAdjust.FOrgBoundID");
        sql.append(" where TPreAdjust.FisFixed = 1");
        sql.append(" and tree.fnumber = ?");
        sql.append(" and ((tParentStru.flongnumber like ? or tParentStru.flongnumber = ?) or ");
        sql.append(" (tstru.FIsLeaf=0 and tstru.flongnumber= ?) )");
        sql.append(" and TPreAdjust.Fyear = ? and TPreAdjust.Fperiod=?");
        sql.append(" and TPreAdjust.FperiodType = ?");
        sql.append(" and TPreAdjust.FDataCollectID = '" + dataColInfo.getId().toString() + "'");
        Object[] param = new Object[]{treeNumber, treeNumber, treeNumber, unitNumber + "!%", unitNumber, unitNumber, new Integer(pre[0]), new Integer(pre[1]), new Integer(periodType)};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        try {
            while (rs.next()) {
                list.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        sql = new StringBuffer();
        sql.append("select unit.Fid fid from t_org_baseunit unit ");
        sql.append(" inner join t_org_structure str on str.funitid = unit.fid");
        sql.append(" where str.ftreeid = ? and (str.flongNumber like ? or str.flongNumber = ? )");
        IRowSet ids = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgTreeId, unitNumber + "!%", unitNumber});
        boolean isDisplayAdjustRPTMByOrg = CslRptUtil.isDisplayAdjustRPTMByOrg(ctx);
        ArrayList<String> companyIds = new ArrayList<String>();
        try {
            Set orgIDSet = null;
            if (isDisplayAdjustRPTMByOrg) {
                orgIDSet = CslOrgTreeUtil.getPermOrgUnitSetForServer(ctx, orgTreeId, null, ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString());
            }
            while (ids.next()) {
                if (isDisplayAdjustRPTMByOrg && orgIDSet != null) {
                    if (!orgIDSet.contains(ids.getString("fid"))) continue;
                    companyIds.add(ids.getString("fid"));
                    continue;
                }
                companyIds.add(ids.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        FullOrgUnitCollection orgColl = null;
        try {
            orgColl = this.getFullOrgUnitCollection(ctx, companyIds);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        ArrayList<String> adjustIds = new ArrayList<String>();
        AdjustInfo info = null;
        for (int i = 0; i < list.size(); ++i) {
            String id = (String)list.get(i);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            info = this.getAdjustInfo(ctx, (IObjectPK)pk);
            if (info == null) continue;
            String preCompanyId = info.getOrgUnit().getId().toString();
            FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo("select number,isUnion where id='" + preCompanyId + "'");
            String number = fullOrgUnitInfo.getNumber();
            boolean isUnion = fullOrgUnitInfo.isIsUnion();
            if (orgColl != null && orgColl.size() > 0) {
                for (int j = 0; j < orgColl.size(); ++j) {
                    FullOrgUnitInfo orgUnitInfo = orgColl.get(j);
                    String num = orgUnitInfo.getNumber();
                    boolean isunion = orgUnitInfo.isIsUnion();
                    if (!number.equals(num) || !String.valueOf(isUnion).equals(String.valueOf(isunion))) continue;
                    adjustIds.add(id);
                }
                continue;
            }
            adjustIds.addAll(list);
        }
        if (adjustIds.size() == 0) {
            throw new AdjustException(AdjustException.FIXLINE_NOT_EXIST);
        }
        String tableName = "t_csl_adjust";
        this.copyHisData(ctx, orgTreeId, periodType, year, period, tableName, list, false, dataColInfo, 0);
    }

    private FullOrgUnitCollection getFullOrgUnitCollection(Context ctx, List orgUnitIds) throws BOSException, SQLException {
        Iterator iter = orgUnitIds.iterator();
        HashSet idSet = new HashSet();
        while (iter.hasNext()) {
            idSet.add(iter.next());
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add("id");
        sel.add("number");
        sel.add("isUnion");
        view.setSelector(sel);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        FullOrgUnitCollection coll = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(view);
        return coll;
    }

    @Override
    protected boolean _isHaveFixedAdjustData(Context ctx, String orgTreeId, int periodType, int year, int period, IObjectValue dataCollect, String orgUnitId) throws BOSException, EASBizException {
        IRowSet rs;
        DataCollectInfo dataColInfo = (DataCollectInfo)dataCollect;
        StringBuffer sql = new StringBuffer();
        sql.append(" select TAdj.fid from t_csl_adjust tadj");
        sql.append(" inner join T_ORG_Structure tstru on tstru.FUnitId=tadj.FOrgUnit and tstru.FTreeId='" + orgTreeId + "'");
        sql.append(" left join T_ORG_Structure tParentStru on tParentStru.FId=tstru.FParentID and tParentStru.FTreeId='" + orgTreeId + "'");
        sql.append(" where TAdj.FisFixed = 1");
        sql.append(" and ((tParentStru.FUnitID='" + orgUnitId + "') or ");
        sql.append(" (tstru.FIsLeaf=0 and tadj.FOrgUnit='" + orgUnitId + "') )");
        sql.append(" and TAdj.FOrgBoundID = '" + orgTreeId + "'");
        sql.append(" and TAdj.Fyear = " + year + " and TAdj.Fperiod=" + period);
        sql.append(" and TAdj.FperiodType = " + periodType);
        sql.append(" and TAdj.FDataCollectID = '" + dataColInfo.getId().toString() + "'");
        boolean isDisplayAdjustRPTMByOrg = CslRptUtil.isDisplayAdjustRPTMByOrg(ctx);
        Set orgIDSet = null;
        if (isDisplayAdjustRPTMByOrg) {
            try {
                orgIDSet = CslOrgTreeUtil.getPermOrgUnitSetForServer(ctx, orgTreeId, orgUnitId, ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString());
            }
            catch (SQLException e) {
                orgIDSet = null;
            }
        }
        if (orgIDSet != null && !orgIDSet.isEmpty()) {
            Iterator iter = orgIDSet.iterator();
            StringBuffer ids = new StringBuffer();
            while (iter.hasNext()) {
                ids.append("'").append(iter.next()).append("',");
            }
            sql.append("and tadj.FOrgUnit in (").append(ids.deleteCharAt(ids.length() - 1)).append(")");
        }
        return (rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString())).size() > 0;
    }

    private Map getNumber(Context ctx, String orgUnitId, String orgTreeId) throws BOSException {
        HashMap<String, String> numbers = new HashMap<String, String>();
        String sql = "select fnumber from t_org_tree where fid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgTreeId});
        try {
            while (rs.next()) {
                String treeNumber = rs.getString("fnumber");
                numbers.put("treeNumber", treeNumber);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        String newSql = "select flongnumber from T_ORG_Structure where funitid = ?";
        IRowSet newrs = DbUtil.executeQuery((Context)ctx, (String)newSql, (Object[])new Object[]{orgUnitId});
        try {
            while (newrs.next()) {
                String unitNumber = newrs.getString("flongnumber");
                numbers.put("unitNumber", unitNumber);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return numbers;
    }

    private void addAdjustEntry(Context ctx, AdjustInfo info, BigDecimal debitTotal, BigDecimal creditTotal, int seq, boolean isOverSer) throws BOSException, EASBizException {
        BigDecimal resultTotal = null;
        BigDecimal zeroValue = new BigDecimal("0");
        AdjustEntryInfo anotherLineInfo = new AdjustEntryInfo();
        anotherLineInfo.setSeq(seq);
        anotherLineInfo.setIsVisible(false);
        anotherLineInfo.setDataElement(4);
        anotherLineInfo.setItem(this.getUnAssignRptItemId(ctx, isOverSer));
        anotherLineInfo.setAdjust(info);
        anotherLineInfo.setSummary(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AdjustBAutoCreate", (Locale)ctx.getOriginLocale()));
        resultTotal = debitTotal.subtract(creditTotal);
        if (resultTotal.compareTo(zeroValue) > 0) {
            anotherLineInfo.setDebit(resultTotal);
            anotherLineInfo.setCredit(null);
        }
        if (resultTotal.compareTo(zeroValue) < 0) {
            anotherLineInfo.setCredit(resultTotal.abs());
            anotherLineInfo.setDebit(null);
        }
        info.getEntries().add(anotherLineInfo);
    }

    protected IObjectCollection _getAdjustRecord(Context ctx, int period, int year, int periodType, String treeId, String unitId, String dataCollectNumber) throws BOSException {
        return null;
    }

    @Override
    protected Map _buildUnionTreeInfo(Context ctx, IObjectPK ctrlUnitPK, IObjectPK userPK, String treeID, String rootID, boolean useFilter, boolean invalidEnable) throws BOSException, EASBizException {
        if (userPK == null || treeID == null || ctrlUnitPK == null) {
            return new HashMap(2);
        }
        return CslReduceRpcFacadeFactory.getLocalInstance(ctx).buildTreeModelInfo(userPK.toString(), ctrlUnitPK.toString(), treeID, rootID, false);
    }

    @Override
    protected IObjectCollection _getAdjustRecordByBasicBound(Context ctx, int period, int year, int periodType, String treeId, String orgUnitId, boolean isForBugetBound, String adjustModeId) throws BOSException, EASBizException {
        return this._getAdjustRecordByBasicBoundNew(ctx, period, year, periodType, treeId, orgUnitId, isForBugetBound, adjustModeId, false, false);
    }

    @Override
    protected IObjectCollection _getAdjustRecordByBasicBound(Context ctx, int period, int year, int periodType, String sourceTreeId, String importTreeId, String orgUnitId, boolean isForBugetBound, String adjustModeId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select s2.funitid as FCompanyId from t_org_structure s1 ");
        sql.append(" inner join t_org_structure s2 on s1.ftreeid = s2.ftreeid ");
        sql.append(" and charindex(s1.flongnumber||'!', s2.flongnumber)=1 ");
        sql.append(" where s1.ftreeid = '" + importTreeId + "' and s1.funitid = '" + orgUnitId + "' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean[] values = CSLParamUtil.batchGetParam(ctx, new String[]{"GR_CSL_AdjustRPTMDisplayByOrg", "GR_CSL_MergeByFiscalPeriod", "GR_CSL_SupportOtherDS"});
        boolean isDisplayAdjustRPTMByOrg = values[0];
        boolean isMergeByFiscalPeriod = values[1];
        boolean isSupportOtherDS = values[2];
        StringBuffer bf = new StringBuffer("");
        try {
            Set orgIDSet = null;
            if (isDisplayAdjustRPTMByOrg) {
                orgIDSet = CslOrgTreeUtil.getPermOrgUnitSetForServer(ctx, importTreeId, orgUnitId, ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString());
            }
            while (rs.next()) {
                if (isDisplayAdjustRPTMByOrg && orgIDSet != null) {
                    if (!orgIDSet.contains(rs.getString("FCompanyId"))) continue;
                    bf.append("'" + rs.getString("FCompanyId") + "',");
                    continue;
                }
                bf.append("'" + rs.getString("FCompanyId") + "',");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (0 < rs.size()) {
            bf.deleteCharAt(bf.lastIndexOf(","));
        }
        DataCollectInfo dataCollectInfo = new DataCollectInfo();
        dataCollectInfo.setNumber("BUDGETDATA");
        boolean hasBudgetedPermission = false;
        boolean hasACPermission = true;
        if (isSupportOtherDS) {
            hasBudgetedPermission = CSLPermissionUtil.hasDataCollectPermission(ctx, ctx.getCaller().toString(), dataCollectInfo, isSupportOtherDS);
            dataCollectInfo.setNumber("ACTUALDATA");
            hasACPermission = CSLPermissionUtil.hasDataCollectPermission(ctx, ctx.getCaller().toString(), dataCollectInfo, isSupportOtherDS);
        }
        AdjustCollection list = null;
        IAdjust iAdjust = AdjustFactory.getLocalInstance(ctx);
        StringBuffer oql = new StringBuffer();
        oql.append(" SELECT id,number,ValueType,dataCollectNumber, adjustMode.name,year,period, ");
        oql.append(" orgUnit.name,sourceCurrency.name,currency.name, ");
        oql.append(" currency.precision,isFixed,entries.id, entries.dataElement, ");
        oql.append(" entries.item.name,entries.item.number,entries.credit,entries.debit, ");
        oql.append(" entries.summary,dataCollect.name ");
        oql.append(" where year=").append(year);
        oql.append(" AND period=").append(period);
        oql.append(" AND periodType=").append(periodType);
        oql.append(" AND orgBound.id='").append(sourceTreeId).append("'");
        oql.append(" AND checkedStatus =").append(2);
        if (!StringUtils.isEmpty((String)adjustModeId)) {
            oql.append(" AND adjustMode.id in(").append(adjustModeId).append(")");
        }
        oql.append(" AND orgUnit.id in(").append(bf.toString()).append(")");
        if (!hasBudgetedPermission) {
            oql.append(" AND  dataCollectNumber!='").append("BUDGETDATA").append("'");
        }
        if (!hasACPermission) {
            oql.append(" AND  dataCollectNumber!='").append("ACTUALDATA").append("'");
        }
        oql.append(" ORDER BY orgUnit.id");
        list = iAdjust.getAdjustCollection(oql.toString());
        return list;
    }

    @Override
    protected boolean _isHaveAdjustDataByTemp(Context ctx, String templetId, String orgTreeId, int periodType, int year, int period, String orgUnitId, String sourceCurrency, String currency) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select TAdj.fid from t_csl_adjust tadj");
        sql.append(" where TAdj.FTempletId = '" + templetId + "'");
        sql.append(" and TAdj.FOrgBoundID = '" + orgTreeId + "'");
        sql.append(" and TAdj.FOrgunit = '" + orgUnitId + "'");
        sql.append(" and TAdj.FSourceCurrencyID = '" + sourceCurrency + "'");
        sql.append(" and TAdj.FCurrencyID = '" + currency + "'");
        sql.append(" and TAdj.Fyear = " + year + " and TAdj.Fperiod=" + period);
        sql.append(" and TAdj.FperiodType = " + periodType);
        sql.append(" and TAdj.FDataCollectID = 'ziBdkQEdEADgAAjWwKgT2FWbAvw='");
        sql.append(" and TAdj.FCheckedStatus = 2");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs.size() > 0;
    }

    @Override
    protected boolean _isHaveAdjustDataByTemps(Context ctx, List ids, String orgTreeId, int periodType, int year, int period, String orgUnitId, String sourceCurrency, String currency) throws BOSException, EASBizException {
        StringBuffer templetIds = new StringBuffer();
        templetIds.append("(");
        for (int i = 0; i < ids.size(); ++i) {
            if (i == 0) {
                templetIds.append("'" + (String)ids.get(i) + "'");
                continue;
            }
            templetIds.append(",'" + (String)ids.get(i) + "'");
        }
        templetIds.append(")");
        StringBuffer sql = new StringBuffer();
        sql.append(" select TAdj.fid from t_csl_adjust tadj");
        sql.append(" where TAdj.FTempletId in " + templetIds.toString());
        sql.append(" and TAdj.FOrgBoundID = '" + orgTreeId + "'");
        sql.append(" and TAdj.FOrgunit = '" + orgUnitId + "'");
        sql.append(" and TAdj.FSourceCurrencyID = '" + sourceCurrency + "'");
        sql.append(" and TAdj.FCurrencyID = '" + currency + "'");
        sql.append(" and TAdj.Fyear = " + year + " and TAdj.Fperiod=" + period);
        sql.append(" and TAdj.FperiodType = " + periodType);
        sql.append(" and TAdj.FDataCollectID = 'ziBdkQEdEADgAAjWwKgT2FWbAvw='");
        sql.append(" and TAdj.FCheckedStatus = 1");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs.size() > 0;
    }

    @Override
    protected void _delUnAuditAdjustDataByTemp(Context ctx, String templetId, String orgTreeId, int periodType, int year, int period, String orgUnitId, String sourceCurrency, String currency) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from  t_csl_adjustentry");
        sql.append(" where fadjustid in (select fid from t_csl_adjust TAdj ");
        sql.append(" where TAdj.FTempletId ='" + templetId + "'");
        sql.append(" and TAdj.FOrgBoundID = '" + orgTreeId + "'");
        sql.append(" and TAdj.FOrgunit = '" + orgUnitId + "'");
        sql.append(" and TAdj.FSourceCurrencyID = '" + sourceCurrency + "'");
        sql.append(" and TAdj.FCurrencyID = '" + currency + "'");
        sql.append(" and TAdj.Fyear = " + year + " and TAdj.Fperiod=" + period);
        sql.append(" and TAdj.FperiodType = " + periodType);
        sql.append(" and TAdj.FDataCollectID = 'ziBdkQEdEADgAAjWwKgT2FWbAvw='");
        sql.append(" and TAdj.FCheckedStatus = 1)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.delete(0, sql.length());
        sql.append(" delete from  t_csl_adjust ");
        sql.append(" where FTempletId ='" + templetId + "'");
        sql.append(" and FOrgBoundID = '" + orgTreeId + "'");
        sql.append(" and FOrgunit = '" + orgUnitId + "'");
        sql.append(" and FSourceCurrencyID = '" + sourceCurrency + "'");
        sql.append(" and FCurrencyID = '" + currency + "'");
        sql.append(" and Fyear = " + year + " and Fperiod=" + period);
        sql.append(" and FperiodType = " + periodType);
        sql.append(" and FDataCollectID = 'ziBdkQEdEADgAAjWwKgT2FWbAvw='");
        sql.append(" and FCheckedStatus = 1");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected Map _synBasicScopeData(Context ctx, RptProperties rptProperties) throws BOSException, EASBizException {
        String orgUnitID = rptProperties.getObject("orgUnitId").toString();
        String orgTreeID = rptProperties.getObject("orgTreeID").toString();
        IObjectValue dataCollect = (IObjectValue)rptProperties.getObject("dataCollect");
        String year = rptProperties.getObject("year").toString();
        String period = rptProperties.getObject("period").toString();
        String periodType = rptProperties.getObject("periodType").toString();
        String strLongNumber = this.getOrgStructureLongNumber(ctx, orgUnitID, orgTreeID);
        StringBuffer sql = new StringBuffer();
        sql.append(" select t1.FsourceAdjustID AS sourceAdjustID, t1.Fid AS ID from T_CSL_ADJUST t1 inner join T_ORG_Structure t2 ");
        sql.append(" on t1.FOrgUnit = t2.FUnitId ");
        sql.append(" and t1.FOrgBoundID = t2.FTreeId ");
        sql.append(" where t1.FOrgBoundID = ? and t2.FLongNumber like ? and t1.Fyear = ? and t1.Fperiod = ? and t1.FPeriodType = ? ");
        sql.append(" and t1.FsourceAdjustID is not null ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgTreeID, strLongNumber, year, period, periodType});
        ArrayList<String> sourceAdjustIds = new ArrayList<String>();
        ArrayList<String> targetAdjustIds = new ArrayList<String>();
        try {
            while (rs.next()) {
                sourceAdjustIds.add(rs.getString("sourceAdjustID"));
                targetAdjustIds.add(rs.getString("ID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        if (null == sourceAdjustIds || sourceAdjustIds.size() == 0) {
            map.put("notDataNeedSyn", "notDataNeedSyn");
            return map;
        }
        rptProperties.setBoolean("isSynBasicScopeData", true);
        rptProperties.setObject("targetAdjustIds", targetAdjustIds);
        this._doImportAdjustRecords(ctx, sourceAdjustIds, rptProperties, dataCollect);
        map.put("synSuccess", "synSuccess");
        return map;
    }

    private String getOrgStructureLongNumber(Context ctx, String orgUnitID, String orgTreeID) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)orgTreeID));
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)orgUnitID));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        OrgStructureCollection orgStructureCollection = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection(view);
        if (null == orgStructureCollection || orgStructureCollection.size() == 0) {
            return null;
        }
        return orgStructureCollection.get(0).getLongNumber() + "%";
    }

    @Override
    protected Map _autoGenerateAdjust(Context ctx, Map mapParams) throws BOSException, EASBizException {
        String orgUnitInfoId;
        HashMap<String, Object> mapResult = new HashMap<String, Object>(1);
        HashMap<String, String> mapOrgAndUnit = new HashMap<String, String>();
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)mapParams.get("OrgBound");
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)mapParams.get("KeyOrgUnit");
        String string = orgUnitInfoId = mapParams.get("onlyCompany") != null ? mapParams.get("onlyCompany").toString() : orgUnitInfo.getId().toString();
        if (null != orgTreeInfo && null != orgUnitInfo) {
            mapOrgAndUnit.put("orgBoundId", orgTreeInfo.getId().toString());
            mapOrgAndUnit.put("orgUnitID", orgUnitInfoId);
            mapOrgAndUnit.put("orgUnitNumber", orgUnitInfo.getNumber());
            mapOrgAndUnit.put("orgUnitLongNumber", orgUnitInfo.getLongNumber());
            mapParams.put("orgUnitNumber", orgUnitInfo.getNumber());
            mapParams.put("orgUnitLongNumber", orgUnitInfo.getLongNumber());
        }
        mapParams.put("autoGenerateAdjust", "true");
        AdjustTempleCollection templetCollection = this.getCurrentAdjustTemplate(ctx, mapOrgAndUnit);
        if (mapParams.get("deleteIds") == null) {
            Map<String, String> hasAdjustTemplate = this.hasAdjustTemplateNames(ctx, templetCollection, mapParams);
            if (hasAdjustTemplate.size() > 0) {
                mapResult.put("hasAdjustTemplate", hasAdjustTemplate);
                return mapResult;
            }
        } else {
            String deleteAdjustSql = "delete from t_csl_adjust where fid in(" + mapParams.get("deleteIds") + ")";
            DbUtil.execute((Context)ctx, (String)deleteAdjustSql);
        }
        if (null == templetCollection || templetCollection.size() == 0) {
            return null;
        }
        List lstTempleteIds = this.generateTempParams(templetCollection);
        Map dispenseParams = (Map)mapOrgAndUnit.get("dispenseParams");
        int successCount = 0;
        if (null != lstTempleteIds && lstTempleteIds.size() > 0) {
            for (int j = 0; j < lstTempleteIds.size(); ++j) {
                String companyid = (String)dispenseParams.get(lstTempleteIds.get(j));
                FullOrgUnitInfo fullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyid)));
                ArrayList idList = new ArrayList();
                idList.add(lstTempleteIds.get(j));
                mapParams.put("fullOrgUnit", fullOrgUnit);
                successCount += this.doTemplateBatchImportAdjustRecords(ctx, idList, mapParams);
            }
        }
        mapResult.put("successCount", new Integer(successCount));
        return mapResult;
    }

    private Map<String, String> hasAdjustTemplateNames(Context ctx, AdjustTempleCollection templetCollection, Map mapParams) throws BOSException {
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuffer names = new StringBuffer();
        StringBuffer ids = new StringBuffer();
        if (templetCollection != null && templetCollection.size() > 0) {
            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)mapParams.get("KeyOrgUnit");
            String orgUnitInfoId = mapParams.get("onlyCompany") != null ? mapParams.get("onlyCompany").toString() : orgUnitInfo.getId().toString();
            StringBuffer sql = new StringBuffer("SELECT distinct template.fname").append(" name, adjust.fid id FROM T_CSL_ADJUST adjust join T_CSL_ADJUSTTEMPLET template ON ADJUST.FTEMPLETID = template.FID where ");
            sql.append(" adjust.FYEAR =").append((Integer)mapParams.get("year"));
            sql.append(" and adjust.FPERIOD=").append((Integer)mapParams.get("period"));
            sql.append(" and adjust.FORGBOUNDID ='").append(mapParams.get("orgTreeID")).append("'");
            sql.append(" and adjust.FORGUNIT='").append(orgUnitInfoId).append("'");
            sql.append(" and adjust.FCURRENCYID ='").append(((CurrencyInfo)mapParams.get("currency")).getId().toString()).append("'");
            sql.append(" and adjust.FSOURCECURRENCYID ='").append(((CurrencyInfo)mapParams.get("sourceCurrency")).getId().toString()).append("'");
            sql.append(" and template.FID in(");
            for (int i = 0; i < templetCollection.size(); ++i) {
                sql.append("'").append(templetCollection.get(i).getId().toString()).append("'");
                if (i == templetCollection.size() - 1) continue;
                sql.append(",");
            }
            sql.append(")");
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (row.next()) {
                    names.append(row.getString("name")).append(",");
                    ids.append("'").append(row.getString("id")).append("'").append(",");
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (names.length() > 0) {
                names.deleteCharAt(names.length() - 1);
                result.put("names", names.toString());
            }
            if (ids.length() > 0) {
                ids.deleteCharAt(ids.length() - 1);
                result.put("ids", ids.toString());
            }
        }
        return result;
    }

    public List generateTempParams(AdjustTempleCollection templetCollection) {
        AdjustTempleInfo templetInfo = null;
        Object acctItemFormula = null;
        ArrayList<String> lstTempParams = new ArrayList<String>();
        String templetID = null;
        int iSize = templetCollection.size();
        for (int i = 0; i < iSize; ++i) {
            templetInfo = templetCollection.get(i);
            templetID = templetInfo.getId().toString();
            lstTempParams.add(templetID);
        }
        return lstTempParams;
    }

    private void generateTempIds(Set setIDs, Map mapTempParams, List lstTempParams, AcctItemFormula acctItemFormula, String templetID) {
        StringBuffer sbTempParams = new StringBuffer();
        String itemNumberStart = acctItemFormula.getItemNumberStart();
        if (null != acctItemFormula.getItemNumberStart() && null != acctItemFormula.getDataElement() && null != acctItemFormula.getMoney()) {
            if (null == itemNumberStart) {
                itemNumberStart = acctItemFormula.getItemNumberEnd();
            }
            sbTempParams.append(acctItemFormula.getItemNumberStart()).append(acctItemFormula.getDataElement()).append(acctItemFormula.getMoney());
        }
        if (null != lstTempParams && lstTempParams.contains(sbTempParams.toString())) {
            setIDs = (HashSet)mapTempParams.get(sbTempParams.toString());
            setIDs.add(templetID);
            mapTempParams.put(sbTempParams.toString(), setIDs);
        } else {
            setIDs.add(templetID);
            mapTempParams.put(sbTempParams.toString(), setIDs);
            lstTempParams.add(sbTempParams.toString());
        }
    }

    private void deleteAdjust(Context ctx, List lstIDs) throws BOSException {
        if (null != lstIDs && lstIDs.size() > 0) {
            IObjectPK[] deletePKs = new IObjectPK[lstIDs.size()];
            int iSize = lstIDs.size();
            for (int i = 0; i < iSize; ++i) {
                deletePKs[i] = new ObjectUuidPK(BOSUuid.read((String)lstIDs.get(i).toString()));
            }
            try {
                this.deleteBatchData(ctx, deletePKs);
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private FullOrgUnitCollection getSelectCompanysByTempId(String dispenseSrcID, Context ctx, Map valueMap) throws BOSException {
        String orgUnitID = null;
        String orgUnitNumber = null;
        String orgUnitLongNumber = null;
        String orgBoundId = null;
        String orgTreeID = null;
        if (valueMap != null) {
            if (valueMap.get("orgUnitID") != null) {
                orgUnitID = (String)valueMap.get("orgUnitID");
            }
            if (valueMap.get("orgUnitNumber") != null) {
                orgUnitNumber = (String)valueMap.get("orgUnitNumber");
                orgUnitLongNumber = (String)valueMap.get("orgUnitLongNumber");
            }
            if (valueMap.get("onlyCompany") != null) {
                orgUnitLongNumber = null;
                orgUnitID = (String)valueMap.get("onlyCompany");
            }
            if (valueMap.get("orgBoundId") != null) {
                orgBoundId = (String)valueMap.get("orgBoundId");
            }
            if (valueMap.get("orgTreeID") != null) {
                orgTreeID = (String)valueMap.get("orgTreeID");
            }
        }
        StringBuffer querySql = new StringBuffer();
        querySql.append("select FCompanyID from T_CSL_AdjustAndElimDispense ").append("\r\n");
        querySql.append(" where FSourceType = 1 ").append("\r\n");
        if (orgUnitLongNumber != null) {
            querySql.append("and FCompanyID  in (").append("\r\n");
            querySql.append("select  s1.funitid  as unitid from t_org_structure s1 ").append("\r\n");
            querySql.append("join t_org_tree  tree1 on s1.ftreeid = tree1.fid").append("\r\n");
            querySql.append("where tree1.fid = '").append(orgTreeID).append("' \tand").append("\r\n");
            querySql.append(" ( s1.flongnumber =  '").append(orgUnitLongNumber).append("' ").append("\r\n");
            querySql.append(" or s1.flongnumber like   '").append(orgUnitLongNumber).append("!%')").append("\r\n");
            querySql.append(" and s1.flongnumber not like   '").append(orgUnitLongNumber).append("!%!%')").append("\r\n");
        } else if (orgUnitID != null) {
            querySql.append("and FCompanyID  = '").append(orgUnitID).append("'").append("\r\n");
        }
        if (orgBoundId != null) {
            querySql.append(" and FOrgBoundID = '").append(orgBoundId).append("'").append("\r\n");
        }
        querySql.append("and  FDispenseSrcID = '").append(dispenseSrcID).append("'").append("\r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        HashSet<String> idSet = new HashSet<String>();
        try {
            while (rs.next()) {
                idSet.add(rs.getString("FCompanyID"));
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        view.setFilter(f);
        f.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        FullOrgUnitCollection infos = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(view);
        return infos;
    }

    private List getListIds(List lstTempleteIds) {
        ArrayList<String> lstIds = new ArrayList<String>();
        String strId = null;
        int iSize = lstTempleteIds.size();
        for (int i = 0; i < iSize; ++i) {
            strId = lstTempleteIds.get(i).toString();
            if (lstIds.contains(strId = strId.substring(1, strId.length() - 1))) continue;
            lstIds.add(strId);
        }
        return lstIds;
    }

    private List generateListTempIds(Map mapTempParams, List lstTempParams, List lstParams) {
        ArrayList lstTempleteIds = new ArrayList();
        String strKey = null;
        if (null != lstParams && lstParams.size() > 0) {
            int iLstParamSize = lstParams.size();
            for (int i = 0; i < iLstParamSize; ++i) {
                strKey = lstParams.get(i).toString();
                if (!lstTempParams.contains(strKey)) continue;
                lstTempleteIds.add(mapTempParams.get(strKey));
            }
        }
        return lstTempleteIds;
    }

    protected void invokeServiceBefore(ServiceContext svcCtx) throws ServiceExecutionException, BOSException {
        Object isAdjustProcListUI = null;
        if (isAdjustProcListUI != null || "a94a3987-00fb-1000-e000-0007c0a813e6".equals(svcCtx.getOperationPK().toString()) || "a94a3987-00fb-1000-e000-0009c0a813e6".equals(svcCtx.getOperationPK().toString())) {
            ServiceStateManager.getInstance().disableNextCallService("PERMISSION_SERVICE");
            ServiceStateManager.getInstance().disableNextCallServices();
        }
        ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
        super.invokeServiceBefore(svcCtx);
    }

    @Override
    protected void _clearItemData(Context ctx, IObjectPK pk, IObjectValue adjustInfo) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" DELETE FROM T_CSL_RptReceived WHERE FReportID = '").append(pk.toString() + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        IItemDataProvider itemDataProvider = ItemDataProviderFactory.getLocalInstance(ctx);
        if (itemDataProvider != null) {
            itemDataProvider.clearItemData(pk.toString());
            itemDataProvider.updateAuditedItemData(pk.toString(), false);
        }
    }

    @Override
    protected void _saveItemData(Context ctx, IObjectPK pk, IObjectValue adjustInfo) throws BOSException, EASBizException {
        BOSObjectType bosType = new RptReceivedInfo().getBOSType();
        String userID = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO T_CSL_RptReceived                      \n");
        sql.append(" (FID, FReportID, FOrgTreeID, FCreatorID, FCreateTime)");
        sql.append(" VALUES                                             \n");
        sql.append(" ( ");
        sql.append("'" + BOSUuid.create((BOSObjectType)bosType).toString() + "'").append(",");
        sql.append("'" + pk.toString()).append("',");
        sql.append("'" + ((AdjustInfo)adjustInfo).getOrgBound().getId().toString() + "'").append(",");
        sql.append("'" + userID + "'").append(", getdate());");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        StringBuffer querySql = new StringBuffer();
        querySql.append("select t1.Fyear,t1.fperiod,t1.fvaluetype,t1.fdate").append("\r\n");
        querySql.append(",t2.fdataelement,t3.FNumber as FItemNumber").append("\r\n");
        querySql.append(",(isnull(sum(t2.fdebit),0)-isnull(sum(t2.fcredit),0))*(2*t3.FDC-1) as FValue").append("\r\n");
        querySql.append("from T_CSL_Adjust t1").append("\r\n");
        querySql.append("inner join T_CSL_AdjustEntry t2").append("\r\n");
        querySql.append("on t1.fid = t2.fAdjustId").append("\r\n");
        querySql.append("inner join T_CSL_RptItem t3").append("\r\n");
        querySql.append("on t3.fid = t2.fitemid").append("\r\n");
        querySql.append("where t1.FID='").append(pk.toString()).append("'").append("\r\n");
        querySql.append("group by t1.fid,t1.Fyear,t1.fperiod,t1.fvaluetype").append("\r\n");
        querySql.append(",t1.fdate,t1.FDataCollectNumber,t2.fdataelement,t3.fdc,t3.FNumber").append("\r\n");
        sql = new StringBuffer();
        sql.append("select t1.FYear, t1.FPeriod, t1.FValueType, t1.FDate, t1.FDataCollectNumber, t2.FDataElement, ");
        sql.append("item.FNumber, t3.FKeyLongNumber, t3.FValue*(2*item.FDC-1) as FValue, ");
        sql.append(" t3.FKeyName, t3.FAsstActTypeNumber");
        sql.append(" from t_csl_adjust t1 join t_csl_adjustEntry t2 on t1.FId = t2.FAdjustId");
        sql.append(" join t_csl_adjustDynamicItem t3 on t3.FAdjustEntryID = t2.FId");
        sql.append(" join t_csl_rptItem item on item.FId = t2.FItemId");
        sql.append(" where t1.FId = '").append(pk.toString()).append("'");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            IItemDataProvider itemDataProvider = ItemDataProviderFactory.getLocalInstance(ctx);
            HashMap views = new HashMap();
            BigDecimal adjustValue = null;
            while (rs.next()) {
                StringBuffer key = new StringBuffer();
                key.append(rs.getInt("FDataElement") + ",").append(rs.getInt("FValueType") + ",").append(rs.getInt("FYear") + ",").append(rs.getInt("FPeriod") + ",").append(rs.getDate("FDate") + ",");
                adjustValue = rs.getBigDecimal("FValue");
                if (adjustValue == null || adjustValue.compareTo(CslConstant.BGZERO) == 0) continue;
                Object value = views.get(key.toString());
                if (value != null && value instanceof HashMap) {
                    ((HashMap)value).put(rs.getString("FItemNumber"), adjustValue);
                    continue;
                }
                value = new HashMap();
                ((HashMap)value).put(rs.getString("FItemNumber"), adjustValue);
                views.put(key.toString(), value);
            }
            itemDataProvider.saveItemData(pk.toString(), views, null, null, null, 1);
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            views = new HashMap();
            adjustValue = null;
            HashMap dynaItemTypes = new HashMap();
            while (rs.next()) {
                HashMap dmap;
                StringBuffer key = new StringBuffer();
                key.append(rs.getInt("FDataElement") + ",").append(rs.getInt("FValueType") + ",").append(rs.getInt("FYear") + ",").append(rs.getInt("FPeriod") + ",").append(rs.getDate("FDate") + ",");
                adjustValue = rs.getBigDecimal("FValue");
                String itemNumber = rs.getString("FNumber");
                String dNumber = rs.getString("FKeyLongNumber");
                HashMap imap = (HashMap)views.get(key.toString());
                if (imap == null) {
                    imap = new HashMap();
                    views.put(key.toString(), imap);
                }
                if ((dmap = (HashMap)imap.get(itemNumber)) == null) {
                    dmap = new HashMap();
                    imap.put(itemNumber, dmap);
                }
                ArrayList<Object> data = new ArrayList<Object>(3);
                data.add(0, adjustValue);
                data.add(1, rs.getString("FKeyName"));
                DynaItemTypeEnum type = this.getDynaItemType(ctx, rs.getString("FAsstActTypeNumber"), dynaItemTypes);
                data.add(2, new Integer(type.getValue()));
                dmap.put(dNumber, data);
            }
            itemDataProvider.saveDynaItemData(pk.toString(), views, 1);
            itemDataProvider.updateAuditedItemData(pk.toString(), false);
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
    }

    @Override
    protected void _auditLog(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _unauditLog(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _addNewLog(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _updateLog(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected IObjectCollection _getAdjustRecordByBasicBoundNew(Context ctx, int period, int year, int periodType, String treeId, String orgUnitId, boolean isForBugetBound, String adjustModeId, boolean isFromAdjustWorkTable, boolean isFromAdjustCompany) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select s2.funitid as FCompanyId from t_org_structure s1 ");
        sql.append(" inner join t_org_structure s2 on s1.ftreeid = s2.ftreeid ");
        sql.append(" and charindex(s1.flongnumber||'!', s2.flongnumber)=1 ");
        sql.append(" where s1.ftreeid = '" + treeId + "' and s1.funitid = '" + orgUnitId + "' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean[] values = CSLParamUtil.batchGetParam(ctx, new String[]{"GR_CSL_AdjustRPTMDisplayByOrg", "GR_CSL_MergeByFiscalPeriod", "GR_CSL_SupportOtherDS"});
        boolean isDisplayAdjustRPTMByOrg = values[0];
        boolean isMergeByFiscalPeriod = values[1];
        boolean isSupportOtherDS = values[2];
        StringBuffer bf = new StringBuffer("");
        try {
            Set orgIDSet = null;
            if (isDisplayAdjustRPTMByOrg) {
                orgIDSet = CslOrgTreeUtil.getPermOrgUnitSetForServer(ctx, treeId, orgUnitId, ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString());
            }
            while (rs.next()) {
                if (isDisplayAdjustRPTMByOrg && orgIDSet != null) {
                    if (!orgIDSet.contains(rs.getString("FCompanyId"))) continue;
                    bf.append("'" + rs.getString("FCompanyId") + "',");
                    continue;
                }
                bf.append("'" + rs.getString("FCompanyId") + "',");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (rs.size() > 0 && bf.length() > 0) {
            bf.deleteCharAt(bf.lastIndexOf(","));
        }
        sql = new StringBuffer();
        PeriodCollection periods = null;
        if (FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, RptPeriodTypeEnum.getEnum((int)periodType))) {
            OrgTreeInfo orgTree = new OrgTreeInfo();
            orgTree.setId(BOSUuid.read((String)treeId));
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, orgTree);
        }
        Date currRptDate = FiscalPeriodHelper.getPeriodLastDate(periods, year, period, RptPeriodTypeEnum.getEnum((int)periodType), isMergeByFiscalPeriod);
        sql.append(" select fid from t_org_tree where fisbasic = 1 and ftype= 8 and fstartdate <= " + CslRptUtil.formatDateForSql(currRptDate) + " and (fenddate is null or fenddate >= " + CslRptUtil.formatDateForSql(currRptDate) + ")");
        if (isForBugetBound) {
            sql.append(" and fisforbudget =").append(1);
        } else {
            sql.append(" and fisforbudget =").append(0);
        }
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String orgTreeId = null;
        try {
            if (rs.next()) {
                orgTreeId = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (orgTreeId == null) {
            return null;
        }
        DataCollectInfo dataCollectInfo = new DataCollectInfo();
        dataCollectInfo.setNumber("BUDGETDATA");
        boolean hasBudgetedPermission = false;
        boolean hasACPermission = true;
        if (isSupportOtherDS) {
            hasBudgetedPermission = CSLPermissionUtil.hasDataCollectPermission(ctx, ctx.getCaller().toString(), dataCollectInfo, isSupportOtherDS);
            dataCollectInfo.setNumber("ACTUALDATA");
            hasACPermission = CSLPermissionUtil.hasDataCollectPermission(ctx, ctx.getCaller().toString(), dataCollectInfo, isSupportOtherDS);
        }
        AdjustCollection list = null;
        IAdjust iAdjust = AdjustFactory.getLocalInstance(ctx);
        StringBuffer oql = new StringBuffer();
        oql.append(" SELECT id,number,ValueType,dataCollectNumber, adjustMode.name,year,period, ");
        oql.append(" orgUnit.name,sourceCurrency.name,currency.name, ");
        oql.append(" currency.precision,isFixed,entries.id, entries.dataElement, ");
        oql.append(" entries.item.name,entries.item.number,entries.credit,entries.debit, ");
        oql.append(" entries.summary,dataCollect.name,customNumber ");
        oql.append(" where year=").append(year);
        oql.append(" AND period=").append(period);
        oql.append(" AND periodType=").append(periodType);
        oql.append(" AND orgBound.id='").append(orgTreeId).append("'");
        if (adjustModeId != null) {
            if ("NULL".equals(adjustModeId)) {
                oql.append(" AND adjustMode.name is null");
            } else {
                oql.append(" AND ( adjustMode.id IN(").append(adjustModeId).append(")");
                if (adjustModeId.indexOf("null") >= 0) {
                    oql.append(" OR adjustMode.name IS NULL ");
                }
                oql.append(" ) \r\n");
            }
        }
        oql.append(" AND orgUnit.id in(").append(bf.toString()).append(")");
        if (!hasBudgetedPermission) {
            oql.append(" AND  dataCollectNumber!='").append("BUDGETDATA").append("'");
        }
        if (!hasACPermission) {
            oql.append(" AND  dataCollectNumber!='").append("ACTUALDATA").append("'");
        }
        if (isFromAdjustWorkTable) {
            OrgPermissionService service = new OrgPermissionService(ctx);
            Set authorizedOrgidSet = service.getAuthorizedOrgWithNoDetails(ctx.getCaller(), OrgType.Company, "cslrpt_adjvoucher_addnew");
            Set ids = this.convertValueType(authorizedOrgidSet);
            if (ids.size() > 0) {
                oql.append(" AND orgUnit.id in(").append(CslRptUtil.collection2String(ids, ",", true)).append(")");
            } else {
                oql.append(" AND orgUnit.id is null");
            }
        }
        if (isFromAdjustCompany) {
            oql.append(" AND orgUnit.id = '").append(((OrgUnitInfo)ctx.get((Object)"CurOU")).getId().toString()).append("' )");
        }
        oql.append(" ORDER BY orgUnit.id");
        list = iAdjust.getAdjustCollection(oql.toString());
        return list;
    }

    private Set convertValueType(Set authorizedOrgidSet) {
        HashSet<String> result = new HashSet<String>();
        Iterator it = authorizedOrgidSet.iterator();
        while (it.hasNext()) {
            String orgid = String.valueOf(it.next());
            result.add(orgid);
        }
        return result;
    }

    @Override
    protected Map _checkRela(Context ctx, ArrayList ids) throws BOSException, EASBizException {
        ParamTempTblService svr = null;
        StringBuffer detail = new StringBuffer();
        String res = "com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource";
        ArrayList<String> noRemoveIds = new ArrayList<String>();
        try {
            String periodStr;
            String tarNumber;
            int period;
            String year;
            String sourcerNumber;
            String adjustId;
            svr = this.getCompanyIDParamSrv(ctx, ids);
            StringBuffer sql = new StringBuffer();
            sql.append(" Select s.fid id, s.FNumber sourcerNumber,t.FYear year,t.FPeriod period,t.FNumber tarNumber \n");
            sql.append(" From T_CSL_Adjust s \n");
            sql.append(" Inner join T_CSL_Adjust t On s.FId = t.FSourceAdjustID \n");
            sql.append(" Where s.FId in (").append(svr.getParamsSql()).append(") \n");
            sql.append(" Order By s.FNumber ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                adjustId = rs.getString("id");
                if (!noRemoveIds.contains(adjustId)) {
                    noRemoveIds.add(adjustId);
                }
                sourcerNumber = rs.getString("sourcerNumber");
                year = rs.getString("year");
                period = rs.getInt("period");
                tarNumber = rs.getString("tarNumber");
                periodStr = period < 10 ? "0" + period : String.valueOf(period);
                detail.append(ResourceBase.getString((String)res, (String)"941_chkRela", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{sourcerNumber, year, periodStr, tarNumber})).append(" \n ");
            }
            sql = new StringBuffer();
            sql.append(" Select s.fid id, s.FNumber sourcerNumber,t.FYear year,t.FPeriod period,t.FNumber tarNumber \n");
            sql.append(" From T_CSL_Adjust s \n");
            sql.append(" Inner join T_CSL_Adjust t On s.FId = t.FSrcCopyAdjustID \n");
            sql.append(" Where s.FId in (").append(svr.getParamsSql()).append(") \n");
            sql.append(" Order By s.FNumber ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                adjustId = rs.getString("id");
                if (!noRemoveIds.contains(adjustId)) {
                    noRemoveIds.add(adjustId);
                }
                sourcerNumber = rs.getString("sourcerNumber");
                year = rs.getString("year");
                period = rs.getInt("period");
                tarNumber = rs.getString("tarNumber");
                periodStr = period < 10 ? "0" + period : String.valueOf(period);
                detail.append(ResourceBase.getString((String)res, (String)"941_chkRela", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{sourcerNumber, year, periodStr, tarNumber})).append(" \n ");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            svr.release();
        }
        StringBuffer msg = new StringBuffer();
        if (detail.length() > 0) {
            msg.append(ResourceBase.getString((String)res, (String)"942_chkRela", (Locale)ctx.getOriginLocale())).append(" \n ");
            msg.append(detail);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("noRemoveIds", noRemoveIds);
        map.put("detail", msg.toString());
        return map;
    }

    private ParamTempTblService getCompanyIDParamSrv(Context ctx, Collection params) {
        TableInfo table = new TableInfo("Tmp_TempAdjustIdTable");
        table.addColumn("FAdjustId");
        return ParamTempTblService.getInstance(ctx, table, params, null);
    }

    protected void _isReferenced(Context ctx, IObjectPK pk, Connection cn) throws ObjectReferedException {
        BizReference ref = null;
        try {
            ref = ReferenceDAO.getReference((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        }
        catch (Exception e) {
            throw new ObjectReferedException((Object)ref, (Throwable)e);
        }
        if (this.isRela(ref)) {
            return;
        }
        if (ref != null) {
            logger.error((Object)(ref.getClass() + "," + ref.getRefEntityName() + "," + ref.getRefFieldName() + "," + ref.getRefFieldName() + "," + ref.getRefTableName()));
            throw new ObjectReferedException((Object)ref, (Throwable)new BizReferenceException(BizReferenceException.BIZ_REFENCED));
        }
    }

    private boolean isRela(BizReference ref) {
        if (ref == null) {
            return true;
        }
        return ref.getRefEntityName().equals("Adjust") && (ref.getRefFieldName().equals("FsourceAdjustID") || ref.getRefFieldName().equals("FSrcCopyAdjustID")) && ref.getRefTableName().equals("T_CSL_Adjust");
    }
}

