/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustTempleCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustTempleEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustTempleEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustTempleInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.IsCitedByLaterEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractAdjustTempleControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.SundryException;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AdjustTempleControllerBean
extends AbstractAdjustTempleControllerBean {
    protected boolean _checkLineExist(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return false;
    }

    protected SystemEnum _getOwnedSys(Context ctx) throws BOSException, EASBizException {
        return SystemEnum.CORPORATIONMANAGEMENT;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AdjustTempleInfo vo = (AdjustTempleInfo)model;
        vo.setCU(super.getCU(ctx, (ObjectBaseInfo)vo));
        this.addnewCheck(ctx, vo);
        super._addnew(ctx, pk, (IObjectValue)vo);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AdjustTempleInfo vo = (AdjustTempleInfo)model;
        vo.setCU(super.getCU(ctx, (ObjectBaseInfo)vo));
        this.addnewCheck(ctx, vo);
        return super._addnew(ctx, (IObjectValue)vo);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AdjustTempleInfo vo = (AdjustTempleInfo)model;
        vo.setCU(super.getCU(ctx, (ObjectBaseInfo)vo));
        this.updateCheck(ctx, (IObjectValue)vo);
        super._update(ctx, pk, (IObjectValue)vo);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.deleteCheck(ctx, pk);
        super._delete(ctx, pk);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        AdjustTempleInfo dataBaseInfo = (AdjustTempleInfo)info;
        EntityViewInfo view = this.buildIsNumExistView(dataBaseInfo);
        AdjustTempleCollection adjustTempleCollection = this.getAdjustTempleCollection(ctx, view);
        if (adjustTempleCollection.size() > 0) {
            AdjustTempleInfo infoInDB = adjustTempleCollection.get(0);
            throw new SundryException(SundryException.NUMEXISTINORG, new Object[]{infoInDB.getNumber(), infoInDB.getTrackRecordCreator().getName()});
        }
    }

    private EntityViewInfo buildIsNumExistView(AdjustTempleInfo dataBaseInfo) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("trackRecordCreator.name"));
        coll.add(new SelectorItemInfo("number"));
        view.setFilter(filter);
        view.setSelector(coll);
        return view;
    }

    private void addnewCheck(Context ctx, AdjustTempleInfo model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, (IObjectValue)model);
        this.checkRptItemBlankAndDup(ctx, (IObjectValue)model);
        this.checkDebitAndCredit((IObjectValue)model);
    }

    private void updateCheck(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        this.checkRptItemBlankAndDup(ctx, model);
        this.checkDebitAndCredit(model);
    }

    private void deleteCheck(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        AdjustTempleInfo info = this.getAdjustTempleInfo(ctx, pk);
        if (info.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
            throw new AdjustException(AdjustException.HAVE_AUDITED);
        }
    }

    private void checkRptItemBlankAndDup(Context ctx, IObjectValue model) throws EASBizException {
        AdjustTempleInfo info = (AdjustTempleInfo)model;
        if (info.getEntries() != null && info.getEntries().size() > 0) {
            AdjustTempleEntryCollection entry = info.getEntries();
            ArrayList<String> list = new ArrayList<String>();
            String keyAdjust = "GR_CSL_AllowAdjustRRTM";
            Object value = null;
            try {
                value = CslRptUtil.getParamValue(ctx, null, keyAdjust);
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
            for (int i = 0; i < entry.size(); ++i) {
                AdjustTempleEntryInfo lineInfo = entry.get(i);
                RPTItemInfo item = lineInfo.getItem();
                int dataElement = lineInfo.getDataElement();
                if (item == null) {
                    throw new AdjustException(AdjustException.RPTITEM_BLANK, new Object[]{String.valueOf(i + 1)});
                }
                if (item.getNumber() == null) continue;
                String item_DataElement = item.getNumber() + "_" + new Integer(dataElement).toString();
                if ("false".equals(value) && list.contains(item_DataElement)) {
                    ArrayList<Object> exParam = new ArrayList<Object>(3);
                    exParam.add(new Integer(i + 1));
                    exParam.add(item.getName());
                    exParam.add(DataElementProvider.getDataElementName(ctx, lineInfo.getDataElement()));
                    throw new AdjustException(AdjustException.RPTITEMDATAELEMENT_DUP, exParam.toArray());
                }
                list.add(item_DataElement);
            }
        }
    }

    private void checkDebitAndCredit(IObjectValue model) throws EASBizException {
        AdjustTempleInfo info = (AdjustTempleInfo)model;
        if (info.getEntries() != null && info.getEntries().size() > 0) {
            AdjustTempleEntryCollection entry = info.getEntries();
            for (int i = 0; i < entry.size(); ++i) {
                AdjustTempleEntryInfo lineInfo = entry.get(i);
                if (lineInfo.getDebitFormula() == null || lineInfo.getCreditFormula() == null) continue;
                throw new AdjustException(AdjustException.DC_ALL_HAVE);
            }
        }
    }

    @Override
    protected void _forbidCitedByLater(Context ctx, List list) throws BOSException, EASBizException {
        Iterator iter = list.iterator();
        AdjustTempleInfo info = null;
        while (iter.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)iter.next().toString()));
            info = this.getAdjustTempleInfo(ctx, (IObjectPK)pk);
            IsCitedByLaterEnum isCited = IsCitedByLaterEnum.ISFALSE;
            info.setIsCitedByLater(isCited);
            this._update(ctx, (IObjectPK)pk, (IObjectValue)info);
        }
        list.clear();
    }

    @Override
    protected void _unForbidCitedByLater(Context ctx, List list) throws BOSException, EASBizException {
        Iterator iter = list.iterator();
        AdjustTempleInfo info = null;
        while (iter.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)iter.next().toString()));
            info = this.getAdjustTempleInfo(ctx, (IObjectPK)pk);
            IsCitedByLaterEnum isCited = IsCitedByLaterEnum.ISTRUE;
            info.setIsCitedByLater(isCited);
            this._update(ctx, (IObjectPK)pk, (IObjectValue)info);
        }
        list.clear();
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AdjustTempleInfo info = this.getAdjustTempleInfo(ctx, pk);
        String s = info.getLogInfo();
        return s;
    }
}

