/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ArchivedStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractArchiveControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ArchiveControllerBean
extends AbstractArchiveControllerBean {
    private static final String ADJUST_TB = "T_CSL_Adjust";
    private static final String ELIMINATION_TB = "T_CSL_Elimination";
    private static final String CSL_REPORT_TB = "T_CSL_CslReport";
    private static final String REPORT_TB = "T_RPT_Report";
    private static final String ARCHIVE_TB = "T_CSL_PublishedStatus";
    ParamTempTblService service = null;
    ParamTempTblService serviceForUnit = null;

    @Override
    protected void _archive(Context ctx, String orgTreeId, int periodType, int year, int period, ArrayList allOrgUnits) throws BOSException {
        String tempUnitName = null;
        if (allOrgUnits != null && allOrgUnits.size() > 0) {
            this.serviceForUnit = this.getTemplateUnitService(ctx, allOrgUnits);
            tempUnitName = this.serviceForUnit.getTmpTableName();
        }
        Connection conn = null;
        Statement st = null;
        try {
            String updElimination;
            String updAdjust;
            String updCslRpt;
            String updManuScript;
            String updSumRpt;
            String updSingleReport;
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            this.saveStatus(ctx, orgTreeId, periodType, year, period, allOrgUnits, st);
            String updSingleCslRpt = this.archiveSingleCslRpt(ctx, orgTreeId, periodType, year, period, tempUnitName, PublishedStatusEnum.PUBLISHED);
            if (updSingleCslRpt != null) {
                st.addBatch(updSingleCslRpt);
            }
            if ((updSingleReport = this.archiveSingleRpt(PublishedStatusEnum.PUBLISHED)) != null) {
                st.addBatch(updSingleReport);
            }
            if ((updSumRpt = this.archiveSumRpt(ctx, orgTreeId, periodType, year, period, tempUnitName, PublishedStatusEnum.PUBLISHED)) != null) {
                st.addBatch(updSumRpt);
            }
            if ((updManuScript = this.archiveManuScript(ctx, orgTreeId, periodType, year, period, tempUnitName, PublishedStatusEnum.PUBLISHED)) != null) {
                st.addBatch(updManuScript);
            }
            if ((updCslRpt = this.archiveCslRpt(ctx, orgTreeId, periodType, year, period, tempUnitName, PublishedStatusEnum.PUBLISHED)) != null) {
                st.addBatch(updCslRpt);
            }
            if ((updAdjust = this.archiveAdjust(ctx, orgTreeId, periodType, year, period, tempUnitName, ArchivedStatusEnum.ARCHIVED)) != null) {
                st.addBatch(updAdjust);
            }
            if ((updElimination = this.archiveElimination(ctx, orgTreeId, periodType, year, period, tempUnitName, ArchivedStatusEnum.ARCHIVED)) != null) {
                st.addBatch(updElimination);
            }
            st.executeBatch();
            st.clearBatch();
        }
        catch (SQLException exc) {
            throw new BOSException("Sql execute exception : When Archive Report", (Throwable)exc);
        }
        finally {
            if (this.service != null) {
                this.service.release();
            }
            if (this.serviceForUnit != null) {
                this.serviceForUnit.release();
            }
            SQLUtils.cleanup((Statement)st, (Connection)conn);
        }
    }

    @Override
    protected void _unArchive(Context ctx, String orgTreeId, int periodType, int year, int period, ArrayList allOrgUnits) throws BOSException {
        String tempUnitName = null;
        if (allOrgUnits != null && allOrgUnits.size() > 0) {
            this.serviceForUnit = this.getTemplateUnitService(ctx, allOrgUnits);
            tempUnitName = this.serviceForUnit.getTmpTableName();
        }
        Connection conn = null;
        Statement st = null;
        try {
            String updElimination;
            String updAdjust;
            String updCslRpt;
            String updManuScript;
            String updSumRpt;
            String updSingleReport;
            String updSingleCslRpt;
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            String updStatus = this.removeStatus(ctx, orgTreeId, periodType, year, period, tempUnitName);
            if (updStatus != null) {
                st.addBatch(updStatus);
            }
            if ((updSingleCslRpt = this.archiveSingleCslRpt(ctx, orgTreeId, periodType, year, period, tempUnitName, PublishedStatusEnum.UNPUBLISHED)) != null) {
                st.addBatch(updSingleCslRpt);
            }
            if ((updSingleReport = this.archiveSingleRpt(PublishedStatusEnum.UNPUBLISHED)) != null) {
                st.addBatch(updSingleReport);
            }
            if ((updSumRpt = this.archiveSumRpt(ctx, orgTreeId, periodType, year, period, tempUnitName, PublishedStatusEnum.UNPUBLISHED)) != null) {
                st.addBatch(updSumRpt);
            }
            if ((updManuScript = this.archiveManuScript(ctx, orgTreeId, periodType, year, period, tempUnitName, PublishedStatusEnum.UNPUBLISHED)) != null) {
                st.addBatch(updManuScript);
            }
            if ((updCslRpt = this.archiveCslRpt(ctx, orgTreeId, periodType, year, period, tempUnitName, PublishedStatusEnum.UNPUBLISHED)) != null) {
                st.addBatch(updCslRpt);
            }
            if ((updAdjust = this.archiveAdjust(ctx, orgTreeId, periodType, year, period, tempUnitName, ArchivedStatusEnum.UNARCHIVED)) != null) {
                st.addBatch(updAdjust);
            }
            if ((updElimination = this.archiveElimination(ctx, orgTreeId, periodType, year, period, tempUnitName, ArchivedStatusEnum.UNARCHIVED)) != null) {
                st.addBatch(updElimination);
            }
            st.executeBatch();
            st.clearBatch();
        }
        catch (SQLException exc) {
            throw new BOSException("Sql execute exception : When UnArchive Report", (Throwable)exc);
        }
        finally {
            if (this.service != null) {
                this.service.release();
            }
            if (this.serviceForUnit != null) {
                this.serviceForUnit.release();
            }
            SQLUtils.cleanup((Statement)st, (Connection)conn);
        }
    }

    private String archiveSingleRpt(PublishedStatusEnum archiveEnum) throws BOSException {
        if (this.service != null && this.service.getTmpTableName() != null) {
            String tempTblName = this.service.getTmpTableName();
            StringBuffer updateSql = new StringBuffer();
            updateSql.append(" update ").append(REPORT_TB);
            updateSql.append(" set FPublishedStatus = ").append(archiveEnum.getValue());
            updateSql.append(" where FCslreportid in (select Frptid from ").append(tempTblName).append(" )");
            return updateSql.toString();
        }
        return null;
    }

    private void saveStatus(Context ctx, String orgTreeId, int periodType, int year, int period, ArrayList orgUnits, Statement st) throws SQLException {
        for (int i = 0; i < orgUnits.size(); ++i) {
            String orgUnitId = (String)orgUnits.get(i);
            StringBuffer sql = new StringBuffer();
            sql.append("insert into ").append(ARCHIVE_TB);
            sql.append(" (FID, FOrgTreeID, FOrgUnitID, FYear, FPeriod, FPeriodType)");
            sql.append(" values('").append(Uuid.create().toString());
            sql.append("', '").append(orgTreeId);
            sql.append("', '").append(orgUnitId);
            sql.append("', ").append(year);
            sql.append(", ").append(period);
            sql.append(", ").append(periodType);
            sql.append(")");
            st.addBatch(sql.toString());
        }
    }

    private String removeStatus(Context ctx, String orgTreeId, int periodType, int year, int period, String tempUnitName) {
        if (tempUnitName != null) {
            StringBuffer sql = new StringBuffer();
            sql.append("delete ").append(ARCHIVE_TB);
            sql.append(" where FOrgTreeId = '").append(orgTreeId);
            sql.append("' and FOrgUnitId in ( ");
            sql.append(" select Funitid from ").append(tempUnitName).append(" )");
            sql.append(" and FYear = ").append(year);
            sql.append(" and FPeriod = ").append(period);
            sql.append(" and FPeriodType = ").append(periodType);
            return sql.toString();
        }
        return null;
    }

    private String archiveSingleCslRpt(Context ctx, String orgTreeId, int periodType, int year, int period, String tempUnitName, PublishedStatusEnum archiveEnum) throws BOSException {
        if (tempUnitName == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select cslrpt.FId as FId from T_CSL_CslReport as cslrpt");
        sql.append(" inner join T_CSL_RptReceived as received");
        sql.append(" on cslrpt.FId = received.FReportID");
        sql.append(" WHERE (cslrpt.FSourceType = ?");
        sql.append(" or cslrpt.FSourceType = ? ");
        sql.append(" or cslrpt.FSourceType = ? )");
        sql.append(" and cslrpt.FCommittedStatus = ?");
        sql.append(" and received.FOrgTreeID = ?");
        sql.append(" and cslrpt.FOrgUnitID = ?");
        sql.append(" and cslrpt.FPeriodType = ?");
        sql.append(" and cslrpt.FYear = ?");
        sql.append(" and cslrpt.FPeriod = ?");
        Object[] param = new Object[]{new Integer(1), new Integer(10), new Integer(13), new Integer(3), orgTreeId, null, new Integer(periodType), new Integer(year), new Integer(period)};
        String queryCompany = "select distinct FUnitId from t_org_structure where FTreeId = '" + orgTreeId + "' and FParentId in (select FId from t_org_structure where FUnitId in ( select Funitid from " + tempUnitName + "))";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryCompany);
        ArrayList<String> rptIdList = new ArrayList<String>();
        try {
            while (rs.next()) {
                String companyId = rs.getString("FUnitId");
                param[5] = companyId;
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
                while (rowSet.next()) {
                    rptIdList.add(rowSet.getString("Fid"));
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (rptIdList.size() > 0) {
            this.service = this.getTemplateTblService(ctx, rptIdList);
            String tempTblName = this.service.getTmpTableName();
            return "update t_csl_cslReport cslrpt set FPublishedStatus = " + archiveEnum.getValue() + " where FId in (select Frptid from " + tempTblName + "  ) ";
        }
        return null;
    }

    private ParamTempTblService getTemplateTblService(Context ctx, List rptIdList) throws BOSException {
        TableInfo table = new TableInfo("t_temp_cslrpt");
        table.addColumn(new ColumnInfo("Frptid", "varchar(80)"));
        ParamTempTblService service = ParamTempTblService.getInstance(ctx, table, rptIdList, null);
        return service;
    }

    private ParamTempTblService getTemplateUnitService(Context ctx, List rptIdList) throws BOSException {
        TableInfo table = new TableInfo("t_temp_unit");
        table.addColumn(new ColumnInfo("Funitid", "varchar(80)"));
        ParamTempTblService service = ParamTempTblService.getInstance(ctx, table, rptIdList, null);
        return service;
    }

    private String archiveSumRpt(Context ctx, String orgTreeId, int periodType, int year, int period, String tempUnitName, PublishedStatusEnum archiveEnum) {
        if (tempUnitName != null) {
            int archiveStatus = archiveEnum.getValue();
            StringBuffer updSQL = new StringBuffer(" UPDATE ");
            updSQL.append(CSL_REPORT_TB);
            updSQL.append(" SET FPublishedStatus = ").append(archiveStatus);
            updSQL.append(" WHERE (FSourceType = ").append(2);
            updSQL.append(" or FSourceType = ").append(11);
            updSQL.append(") and FOrgTreeID = '").append(orgTreeId);
            updSQL.append("' and FPeriodType = ").append(periodType);
            updSQL.append(" and FYear = ").append(year);
            updSQL.append(" and FPeriod = ").append(period);
            updSQL.append(" and FOrgUnitID IN ( ");
            updSQL.append(" select Funitid from ").append(tempUnitName).append(")");
            return updSQL.toString();
        }
        return null;
    }

    private String archiveManuScript(Context ctx, String orgTreeId, int periodType, int year, int period, String tempUnitName, PublishedStatusEnum archiveEnum) {
        if (tempUnitName != null) {
            int archiveStatus = archiveEnum.getValue();
            StringBuffer updSQL = new StringBuffer(" UPDATE ");
            updSQL.append(CSL_REPORT_TB);
            updSQL.append(" SET FPublishedStatus = ").append(archiveStatus);
            updSQL.append(" WHERE FSourceType = ").append(4);
            updSQL.append(" and FOrgTreeID = '").append(orgTreeId);
            updSQL.append("' and FPeriodType = ").append(periodType);
            updSQL.append(" and FYear = ").append(year);
            updSQL.append(" and FPeriod = ").append(period);
            updSQL.append(" and FOrgUnitID IN ( ");
            updSQL.append(" select Funitid from ").append(tempUnitName).append(")");
            return updSQL.toString();
        }
        return null;
    }

    private String archiveCslRpt(Context ctx, String orgTreeId, int periodType, int year, int period, String tempUnitName, PublishedStatusEnum archiveEnum) {
        if (tempUnitName != null) {
            int archiveStatus = archiveEnum.getValue();
            StringBuffer updSQL = new StringBuffer(" UPDATE ");
            updSQL.append(CSL_REPORT_TB);
            updSQL.append(" SET FPublishedStatus = ").append(archiveStatus);
            updSQL.append(" WHERE FSourceType = ").append(3);
            updSQL.append(" and FOrgTreeID = '").append(orgTreeId);
            updSQL.append("' and FPeriodType = ").append(periodType);
            updSQL.append(" and FYear = ").append(year);
            updSQL.append(" and FPeriod = ").append(period);
            updSQL.append(" and FOrgUnitID IN ( ");
            updSQL.append(" select Funitid from ").append(tempUnitName).append(")");
            return updSQL.toString();
        }
        return null;
    }

    private String archiveAdjust(Context ctx, String orgTreeId, int periodType, int year, int period, String tempUnitName, ArchivedStatusEnum archiveEnum) {
        if (tempUnitName != null) {
            int archiveStatus = archiveEnum.getValue();
            StringBuffer updSQL = new StringBuffer(" UPDATE ");
            updSQL.append(ADJUST_TB);
            updSQL.append(" SET FArchivedStatus = ").append(archiveStatus);
            updSQL.append(" WHERE FOrgBoundID = '").append(orgTreeId);
            updSQL.append("' and FPeriodType = ").append(periodType);
            updSQL.append(" and FYear = ").append(year);
            updSQL.append(" and FPeriod = ").append(period);
            updSQL.append(" and FOrgUnit IN ( ");
            updSQL.append(" select Funitid from ").append(tempUnitName).append(")");
            return updSQL.toString();
        }
        return null;
    }

    private String archiveElimination(Context ctx, String orgTreeId, int periodType, int year, int period, String tempUnitName, ArchivedStatusEnum archiveEnum) {
        if (tempUnitName != null) {
            int archiveStatus = archiveEnum.getValue();
            StringBuffer updSQL = new StringBuffer(" UPDATE ");
            updSQL.append(ELIMINATION_TB);
            updSQL.append(" SET FArchivedStatus = ").append(archiveStatus);
            updSQL.append(" WHERE FOrgBoundID = '").append(orgTreeId);
            updSQL.append("' and FPeriodType = ").append(periodType);
            updSQL.append(" and FYear = ").append(year);
            updSQL.append(" and FPeriod = ").append(period);
            updSQL.append(" and FOrgUnit IN ( ");
            updSQL.append(" select Funitid from ").append(tempUnitName).append(")");
            return updSQL.toString();
        }
        return null;
    }

    @Override
    protected boolean _isPublised(Context ctx, String orgTreeID, String orgUnitID, int year, int period, int periodType) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FId from t_csl_publishedStatus ");
        sql.append(" where FOrgTreeID = ?");
        sql.append(" and FOrgUnitID = ?");
        sql.append(" and FYear = ?");
        sql.append(" and FPeriod = ?");
        sql.append(" and FPeriodType = ?");
        Object[] param = new Object[]{orgTreeID, orgUnitID, new Integer(year), new Integer(period), new Integer(periodType)};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        return rowSet.size() > 0;
    }

    @Override
    protected String _checkBeforArchive(Context ctx, String orgTreeId, int year, int period, int periodType, ArrayList allOrgUnits) throws BOSException, EASBizException {
        String msg;
        StringBuffer result = new StringBuffer();
        String tempUnitName = null;
        if (allOrgUnits != null && allOrgUnits.size() > 0) {
            this.serviceForUnit = this.getTemplateUnitService(ctx, allOrgUnits);
            tempUnitName = this.serviceForUnit.getTmpTableName();
        }
        if (!StringUtils.isEmpty((String)(msg = this.checkGroupRpt(ctx, orgTreeId, year, period, periodType, tempUnitName)))) {
            result.append(msg);
        }
        for (int i = 0; i < allOrgUnits.size(); ++i) {
            String orgUnitId = (String)allOrgUnits.get(i);
            StringBuffer errorMsg = new StringBuffer();
            StringBuffer sql = new StringBuffer();
            sql.append("select FId from ").append(CSL_REPORT_TB);
            sql.append(" WHERE (FSourceType = ?");
            sql.append(" or FSourceType = ?)");
            sql.append(" and FCommittedStatus <> ?");
            sql.append(" and FOrgTreeID = ?");
            sql.append(" and FOrgUnitID = ?");
            sql.append(" and FPeriodType = ?");
            sql.append(" and FYear = ?");
            sql.append(" and FPeriod = ?");
            sql.append(" and FAdjustStatus = ?");
            Object[] param = new Object[]{new Integer(2), new Integer(11), new Integer(3), orgTreeId, orgUnitId, new Integer(periodType), new Integer(year), new Integer(period), new Integer(0)};
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
            if (rowSet.size() > 0) {
                errorMsg.append("\t");
                errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Archive_ErrorMsg2", (Locale)ctx.getOriginLocale()));
                errorMsg.append("\n");
            }
            if (this.isTopOrgUnit(ctx, orgTreeId, orgUnitId)) {
                sql = new StringBuffer();
                sql.append("select FId from ").append(CSL_REPORT_TB);
                sql.append(" WHERE FSourceType = ?");
                sql.append(" and FAuditedStatus = ?");
                sql.append(" and FOrgTreeID = ?");
                sql.append(" and FOrgUnitID = ?");
                sql.append(" and FPeriodType = ?");
                sql.append(" and FYear = ?");
                sql.append(" and FPeriod = ?");
                sql.append(" and FAdjustStatus = ?");
                param = new Object[]{new Integer(3), new Integer(1), orgTreeId, orgUnitId, new Integer(periodType), new Integer(year), new Integer(period), new Integer(0)};
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
                if (rowSet.size() > 0) {
                    errorMsg.append("\t");
                    errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Archive_ErrorMsg3", (Locale)ctx.getOriginLocale()));
                    errorMsg.append("\n");
                }
            } else {
                sql = new StringBuffer();
                sql.append("select FId from ").append(CSL_REPORT_TB);
                sql.append(" WHERE FSourceType = ?");
                sql.append(" and FCommittedStatus <> ?");
                sql.append(" and FOrgTreeID = ?");
                sql.append(" and FOrgUnitID = ?");
                sql.append(" and FPeriodType = ?");
                sql.append(" and FYear = ?");
                sql.append(" and FPeriod = ?");
                sql.append(" and FAdjustStatus = ?");
                param = new Object[]{new Integer(3), new Integer(3), orgTreeId, orgUnitId, new Integer(periodType), new Integer(year), new Integer(period), new Integer(0)};
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
                if (rowSet.size() > 0) {
                    errorMsg.append("\t");
                    errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Archive_ErrorMsg4", (Locale)ctx.getOriginLocale()));
                    errorMsg.append("\n");
                }
            }
            sql = new StringBuffer();
            sql.append("select FId from ").append(ADJUST_TB);
            sql.append(" WHERE FOrgBoundID = ?");
            sql.append(" and FOrgUnit = ?");
            sql.append(" and FPeriodType = ?");
            sql.append(" and FYear = ?");
            sql.append(" and FPeriod = ?");
            sql.append(" and FCheckedStatus = ?");
            param = new Object[]{orgTreeId, orgUnitId, new Integer(periodType), new Integer(year), new Integer(period), new Integer(1)};
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
            if (rowSet.size() > 0) {
                errorMsg.append("\t");
                errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Archive_ErrorMsg5", (Locale)ctx.getOriginLocale()));
                errorMsg.append("\n");
            }
            sql = new StringBuffer();
            sql.append("select FId from ").append(ELIMINATION_TB);
            sql.append(" WHERE FOrgBoundID = ?");
            sql.append(" and FOrgUnit = ?");
            sql.append(" and FPeriodType = ?");
            sql.append(" and FYear = ?");
            sql.append(" and FPeriod = ?");
            sql.append(" and FCheckedStatus = ?");
            param = new Object[]{orgTreeId, orgUnitId, new Integer(periodType), new Integer(year), new Integer(period), new Integer(1)};
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
            if (rowSet.size() > 0) {
                errorMsg.append("\t");
                errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Archive_ErrorMsg6", (Locale)ctx.getOriginLocale()));
                errorMsg.append("\n");
            }
            if (StringUtils.isEmpty((String)errorMsg.toString())) continue;
            result.append(this.getOrgUnitNameById(ctx, orgUnitId)).append("\n");
            result.append(errorMsg).append("\n\n");
        }
        if (this.serviceForUnit != null) {
            this.serviceForUnit.release();
        }
        if (!StringUtils.isEmpty((String)result.toString())) {
            StringBuffer tmp = new StringBuffer();
            tmp.append(this.getOrgTreeNameById(ctx, orgTreeId));
            tmp.append("\n\n");
            tmp.append(result);
            return tmp.toString();
        }
        return result.toString();
    }

    private String checkGroupRpt(Context ctx, String orgTreeId, int year, int period, int periodType, String tempUnitName) throws BOSException {
        if (tempUnitName == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select cslrpt.FId from T_CSL_CslReport as cslrpt");
        sql.append(" inner join T_CSL_RptReceived as received");
        sql.append(" on cslrpt.FId = received.FReportID");
        sql.append(" WHERE (cslrpt.FSourceType = ?");
        sql.append(" or cslrpt.FSourceType = ? ");
        sql.append(" or cslrpt.FSourceType = ? )");
        sql.append(" and cslrpt.FCommittedStatus = ?");
        sql.append(" and received.FOrgTreeID = ?");
        sql.append(" and cslrpt.FOrgUnitID = ?");
        sql.append(" and cslrpt.FPeriodType = ?");
        sql.append(" and cslrpt.FYear = ?");
        sql.append(" and cslrpt.FPeriod = ?");
        Object[] param = new Object[]{new Integer(1), new Integer(10), new Integer(13), new Integer(2), orgTreeId, null, new Integer(periodType), new Integer(year), new Integer(period)};
        StringBuffer errorMsg = new StringBuffer();
        String queryCompany = "select distinct FUnitId from t_org_structure where FTreeId = '" + orgTreeId + "' and FParentId in (select FId from t_org_structure where FUnitId in ( select Funitid from " + tempUnitName + "))";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryCompany);
        try {
            while (rs.next()) {
                String companyId = rs.getString("FUnitId");
                param[5] = companyId;
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
                if (rowSet.size() <= 0) continue;
                errorMsg.append(this.getOrgUnitNameById(ctx, companyId));
                errorMsg.append("\n\t");
                errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Archive_ErrorMsg1", (Locale)ctx.getOriginLocale()));
                errorMsg.append("\n");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return errorMsg.toString();
    }

    private boolean isTopOrgUnit(Context ctx, String orgTreeId, String orgUnitId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FLevel from t_org_structure");
        sql.append(" where FTreeId = ? and FUnitId = ?");
        Object[] param = new Object[]{orgTreeId, orgUnitId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        try {
            int level;
            if (rowSet.next() && (level = rowSet.getInt("FLevel")) == 1) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return false;
    }

    private String getOrgUnitNameById(Context ctx, String orgUnitId) throws BOSException {
        String sql = "select FName_" + ctx.getLocale() + " as FName from t_org_baseunit where fid = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgUnitId});
        try {
            if (rowSet.next()) {
                String name = rowSet.getString("FName");
                return name;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }

    private String getOrgTreeNameById(Context ctx, String orgTreeId) throws BOSException {
        String sql = "select FName_" + ctx.getLocale() + " as FName from t_org_tree where fid = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgTreeId});
        try {
            if (rowSet.next()) {
                String name = rowSet.getString("FName");
                return name;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }
}

