/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AssistGetFormulaResult;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextCompanyInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.IFormulaCalcContext;
import com.kingdee.eas.fi.gr.cslrpt.NeedSelectorForFormulaCalcContext;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractAutoItemBusinessFacadeControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.CalcContextHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.CalculateByFormulaCalcContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ICalcContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.InvokeFormulaExecutor;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.ctx.QueryItemValueByContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.AutoItemLog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report.CreateReportByFormulaCalcContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.GetNewVersionTemplate;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.CheckItemValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.IItemSourceType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemValueSet;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AutoItemBusinessFacadeControllerBean
extends AbstractAutoItemBusinessFacadeControllerBean {
    private static final long serialVersionUID = -2433364558268289999L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.AutoItemBusinessFacadeControllerBean");

    @Override
    protected void _calculate(Context ctx, IObjectValue formulaCalcContext, String executeTaskId) throws BOSException, EASBizException {
        logger.error((Object)("_calculateStart::" + ctx.toString()));
        DBHandler dao = new DBHandler(ctx);
        new CalculateByFormulaCalcContext(dao).exec((FormulaCalcContextInfo)formulaCalcContext, executeTaskId);
        logger.error((Object)("_calculateEnd::" + ctx.toString()));
    }

    protected ReportCollection _createReport(Context ctx, IObjectValue formulaCalcContext, boolean save) throws BOSException, EASBizException {
        DBHandler dao = new DBHandler(ctx);
        ReportCollection reports = new CreateReportByFormulaCalcContext(dao).exec((FormulaCalcContextInfo)formulaCalcContext);
        if (save) {
            IReport reportDao = ReportFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < reports.size(); ++i) {
                try {
                    ArrayList<String> params = new ArrayList<String>();
                    StringBuffer sql1 = new StringBuffer();
                    sql1.append(" SELECT DISTINCT td.FOrgBoundID                             \n");
                    sql1.append(" FROM T_CSL_TempletDispense td                              \n");
                    sql1.append(" INNER JOIN T_ORG_TREE tree                                 \n");
                    sql1.append(" ON tree.FID = td.FOrgBoundID and tree.FStatus <> 0      \n");
                    sql1.append(" INNER JOIN T_RPT_Template t                                \n");
                    sql1.append("    ON td.FDispenseSrcID = t.FID                            \n");
                    sql1.append(" INNER JOIN T_RPT_Template t2                               \n");
                    sql1.append("    ON t.FGroup = t2.FGroup                                 \n");
                    sql1.append(" WHERE t2.FID = ?                                            \n");
                    sql1.append(" AND TO_INT(SUBSTRING(T.FVERSIONNUMBER,1,CHARINDEX('.',T.FVERSIONNUMBER)-1)) =  ");
                    sql1.append(" TO_INT(SUBSTRING(T2.FVERSIONNUMBER,1,CHARINDEX('.',T2.FVERSIONNUMBER)-1))    \n");
                    sql1.append(" AND T.FGROUPTEMPLATEID IS NULL                             \n");
                    sql1.append(" AND td.FCompanyID = ?                      \n");
                    params.add(reports.get(i).getTemplate().getId().toString());
                    params.add(reports.get(i).getCompany().getId().toString());
                    IRowSet rs = dao.getExecuteSQL().executeQuery(sql1.toString(), params.toArray());
                    if (!rs.next()) {
                        throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.AutoItemResource", (String)"template.not.be.dispensed.to.this.company", (Locale)ctx.getOriginLocale()));
                    }
                }
                catch (BOSException e) {
                    throw e;
                }
                catch (Exception e) {
                    logger.warn((Object)"", (Throwable)e);
                }
                reportDao.save((CoreBaseInfo)reports.get(i));
                continue;
            }
        }
        return reports;
    }

    @Override
    protected IObjectValue _createOneReport(Context ctx, IObjectValue calcContext, IObjectValue template, IObjectValue company, boolean save) throws BOSException, EASBizException {
        DBHandler dao = new DBHandler(ctx);
        TemplateInfo newVersionTemplate = new GetNewVersionTemplate(dao).exec((TemplateInfo)template, (OrgUnitInfo)company, new NeedSelectorForFormulaCalcContext().template());
        if (newVersionTemplate == null) {
            logger.error((Object)("query non for the lastest version template :{0}" + ((TemplateInfo)template).getName() + "(" + ((TemplateInfo)template).getId() + ")"));
            newVersionTemplate = (TemplateInfo)template;
        }
        if (newVersionTemplate.isIsFreezed()) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.AutoItemResource", (String)"template.have.been.freezed", (Locale)ctx.getOriginLocale()));
        }
        ReportInfo report = new CreateReportByFormulaCalcContext(dao).exec((FormulaCalcContextInfo)calcContext, newVersionTemplate, (OrgUnitInfo)company);
        if (report.containsKey("existedReport") && AuditedStatusEnum.AUDITED.equals((Object)report.getAuditedStatus())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.AutoItemResource", (String)"report.exists.and.audited", (Locale)ctx.getOriginLocale()));
        }
        if (save) {
            IReport reportDao = ReportFactory.getLocalInstance((Context)ctx);
            try {
                ArrayList<String> params = new ArrayList<String>();
                StringBuffer sql1 = new StringBuffer();
                sql1.append(" SELECT DISTINCT td.FOrgBoundID                             \n");
                sql1.append(" FROM T_CSL_TempletDispense td                              \n");
                sql1.append(" INNER JOIN T_ORG_TREE tree                                 \n");
                sql1.append(" ON tree.FID = td.FOrgBoundID and tree.FStatus <> 0      \n");
                sql1.append(" INNER JOIN T_RPT_Template t                                \n");
                sql1.append("    ON td.FDispenseSrcID = t.FID                            \n");
                sql1.append(" INNER JOIN T_RPT_Template t2                               \n");
                sql1.append("    ON t.FGroup = t2.FGroup                                 \n");
                sql1.append(" WHERE t2.FID = ?                                            \n");
                sql1.append(" AND TO_INT(SUBSTRING(T.FVERSIONNUMBER,1,CHARINDEX('.',T.FVERSIONNUMBER)-1)) =  ");
                sql1.append(" TO_INT(SUBSTRING(T2.FVERSIONNUMBER,1,CHARINDEX('.',T2.FVERSIONNUMBER)-1))    \n");
                sql1.append(" AND T.FGROUPTEMPLATEID IS NULL                             \n");
                sql1.append(" AND td.FCompanyID = ?                      \n");
                params.add(report.getTemplate().getId().toString());
                params.add(report.getCompany().getId().toString());
                IRowSet rs = dao.getExecuteSQL().executeQuery(sql1.toString(), params.toArray());
                if (!rs.next()) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.AutoItemResource", (String)"template.not.be.dispensed.to.this.company", (Locale)ctx.getOriginLocale()));
                }
            }
            catch (BOSException e) {
                throw e;
            }
            catch (Exception e) {
                logger.warn((Object)"", (Throwable)e);
            }
            if (report.getId() != null && report.containsKey("existedReport")) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("data");
                reportDao.updatePartial((CoreBaseInfo)report, selector);
            } else {
                reportDao.save((CoreBaseInfo)report);
            }
        }
        return report;
    }

    @Override
    protected String _checkItemValue(Context ctx, IObjectValue formulaCalcContext) throws BOSException, EASBizException {
        return new CheckItemValue(new DBHandler(ctx)).exec((FormulaCalcContextInfo)formulaCalcContext);
    }

    @Override
    protected void _calculateForTimeDispatch(Context ctx, String formulaCalcContextId) throws BOSException, EASBizException {
        SelectorItemCollection needSelector = ActionFactory.get(NeedSelectorForFormulaCalcContext.class).exec();
        needSelector.add("dispatchCurrency.id");
        IFormulaCalcContext formulaCalcContextDao = new DBHandler(ctx).get(IFormulaCalcContext.class);
        FormulaCalcContextInfo calcContextInfo = formulaCalcContextDao.getFormulaCalcContextInfo((IObjectPK)new ObjectUuidPK(formulaCalcContextId), needSelector);
        String executeTaskId = Uuid.randomUUID().toString();
        this.calculate(ctx, calcContextInfo, executeTaskId);
    }

    @Override
    protected ItemValueSet _queryItemValue(Context ctx, IObjectValue calcContext, IObjectValue company) throws BOSException, EASBizException {
        return new QueryItemValueByContext(new DBHandler(ctx)).exec((FormulaCalcContextInfo)calcContext, (OrgUnitInfo)company, IItemSourceType.SUPPORTED_SOURCE_TYPE);
    }

    @Override
    protected byte[] _executeFormula(Context ctx, Map parameterMaps, ICalcContext calcContext) throws BOSException, EASBizException {
        CalcContextHandler calContext = new CalcContextHandler(ctx, calcContext);
        new InvokeFormulaExecutor().exec(parameterMaps, calContext);
        AssistGetFormulaResult get = new AssistGetFormulaResult();
        return get.serial(parameterMaps);
    }

    @Override
    protected void _addAndCalcRpt(Context ctx, IObjectValue formulaCalcContext, IObjectValue template, IObjectValue companyEntity, AutoItemLog reportLog) throws BOSException, EASBizException {
        try {
            DBHandler dao = new DBHandler(ctx);
            new CalculateByFormulaCalcContext(dao).addAndCalc((FormulaCalcContextInfo)formulaCalcContext, (TemplateInfo)template, (FormulaCalcContextCompanyInfo)companyEntity, reportLog);
        }
        catch (Exception e) {
            logger.error((Object)"_addAndCalcRpt error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }
}

