/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.CSLConditionBase;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import java.security.SecureRandom;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CSLServerHelper {
    public static final String CSLSYSPARAM_INFO_BASECURRENCY = "GR_CSL_BASECRY_001";
    public static final String CSLSYSPARAM_INFO_RATETABLE = "GR_CSL_CRYRATE_002";
    public static final String CSLSYSPARAM_INFO_ISUPTFORMATOFTEMPLET = "GR_CSL_TEMPMODE_003";
    public static final String CSLSYSPARAM_INFO_MERGETYPE = "GR_CSL_MERGETYPE_004";
    public static final String CSLSYSPARAM_INFO_ALLOW_UNDETAILITEM = "GR_CSL_DETAILITEM_005";
    public static final int CSLSERVERHELPER_INFO_UPT = 0;
    public static final int CSLSERVERHELPER_INFO_PLUS = 1;
    public static final int CSLSERVERHELPER_INFO_NEG = -1;
    private Context context = null;
    private Connection connection = null;
    private EntityViewInfo condition = null;
    private CSLConditionBase baseCondition = null;
    private int startIndex = -1;
    private int lineCount = -1;
    private ITableManagerFacade tableManagerFacade = null;
    private String tempTableName = null;
    private String fieldNameLocale = null;
    private Map variables = new HashMap();
    private static SelectorItemCollection selectorForRootCU = null;
    private static SelectorItemCollection selectorForCompanyID = null;

    public CSLServerHelper(Context ctx) {
        this.context = ctx;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context ctx) {
        this.context = ctx;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setTempTableName(String tableName) {
        this.tempTableName = tableName;
    }

    public String getTempTableName() {
        return this.tempTableName;
    }

    public EntityViewInfo getCondition() {
        return this.condition;
    }

    public void setCondition(EntityViewInfo conditionInfo) {
        this.condition = conditionInfo;
        this.baseCondition = this.condition == null ? null : (CSLConditionBase)this.condition.get("CSLBaseCondition");
    }

    public CSLConditionBase getBaseCondition() {
        return this.baseCondition;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int index) {
        this.startIndex = index;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public void setLineCount(int count) {
        this.lineCount = count;
    }

    public boolean isNewQuery() {
        return this.startIndex == 0;
    }

    public String getTableHeadInfo() {
        return null;
    }

    public Object getVariable(String name) {
        return this.variables.get(name);
    }

    public void setVariable(String name, Object obj) {
        this.variables.put(name, obj);
    }

    public String getFieldNameExtend() throws BOSException {
        if (this.fieldNameLocale == null) {
            this.fieldNameLocale = "_" + this.getContext().getLocale().getLanguage();
        }
        return this.fieldNameLocale;
    }

    protected Boolean getMergeMode() throws BOSException, EASBizException {
        return false;
    }

    protected Object getOrgBoundBaseCry() throws BOSException, EASBizException {
        return null;
    }

    protected Object getItemMappingViewInfo() {
        return null;
    }

    protected static String createTempTableName(String key) {
        int v = 472333 + new SecureRandom().nextInt(100000);
        StringBuffer s = new StringBuffer(key);
        s.append(v);
        return s.toString();
    }

    public static String getOrStringByList(List keys, String aliasString, String fieldString) {
        if (keys == null || keys.size() == 0 || fieldString == null || fieldString.length() == 0) {
            return null;
        }
        return CSLServerHelper.getOrString(keys.iterator(), aliasString, fieldString);
    }

    public static String getInStringByList(List lstParams, List keys, String aliasString, String fieldString) {
        if (keys == null || keys.size() == 0 || fieldString == null || fieldString.length() == 0) {
            return null;
        }
        return CSLServerHelper.getInString(lstParams, keys.iterator(), aliasString, fieldString);
    }

    public static String getOrStringByMap(Map keys, String aliasString, String fieldString) {
        if (keys == null || keys.size() == 0 || fieldString == null || fieldString.length() == 0) {
            return null;
        }
        return CSLServerHelper.getOrString(keys.keySet().iterator(), aliasString, fieldString);
    }

    private static String getInString(List lstParams, Iterator itor, String aliasString, String fieldString) {
        StringBuffer orString = new StringBuffer();
        int count = 0;
        while (itor.hasNext()) {
            if (count == 0) {
                if (aliasString != null && aliasString.length() != 0) {
                    orString.append(aliasString + "." + fieldString);
                } else {
                    orString.append(fieldString);
                }
                orString.append(" in (");
            } else {
                orString.append(",");
            }
            orString.append("?");
            ++count;
            lstParams.add(itor.next());
        }
        orString.append(")");
        return orString.toString();
    }

    private static String getOrString(Iterator itor, String aliasString, String fieldString) {
        StringBuffer orString = new StringBuffer();
        int count = 0;
        while (itor.hasNext()) {
            if (count == 0) {
                if (aliasString != null && aliasString.length() != 0) {
                    orString.append(aliasString + "." + fieldString);
                } else {
                    orString.append(fieldString);
                }
                orString.append(" in (");
            } else {
                orString.append(",");
            }
            orString.append("'");
            orString.append((String)itor.next());
            orString.append("'");
            ++count;
        }
        orString.append(")");
        return orString.toString();
    }

    public static ArrayList getCslOrgs(Context ctx, OrgTreeInfo orgTree, OrgUnitInfo company) throws EASBizException, BOSException {
        return CslRptUtil.getCslOrgs(ctx, orgTree, company);
    }

    public final String createTempTable(String nameKey, String fieldDefine) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String tempTableName = null;
        ITableManagerFacade tableMg = TableManagerFacadeFactory.getLocalInstance((Context)this.getContext());
        tempTableName = tableMg.getTableName(nameKey);
        if (tempTableName == null) {
            tempTableName = CSLServerHelper.createTempTableName(nameKey);
        }
        sql.append("CREATE TABLE \r\n");
        sql.append(tempTableName);
        sql.append(" \r\n");
        sql.append(fieldDefine);
        this.getTableManagerFacade().createTable(sql.toString());
        return tempTableName;
    }

    public final String createTempTableAsynchronism(String nameKey, String fieldDefine) throws BOSException, EASBizException {
        return this.createTempTable(nameKey, fieldDefine);
    }

    public ITableManagerFacade getTableManagerFacade() throws BOSException, EASBizException {
        if (this.tableManagerFacade == null) {
            this.tableManagerFacade = TableManagerFacadeFactory.getLocalInstance((Context)this.getContext());
        }
        return this.tableManagerFacade;
    }

    public static Map getSysParamValues(Context ctx, OrgTreeInfo orgTree) throws EASBizException, BOSException {
        if (orgTree == null) {
            return null;
        }
        HashMap vs = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(CSLServerHelper.getSysParamKeys(orgTree));
        return vs;
    }

    public static String getSysParamValue(Context ctx, OrgTreeInfo orgTree, String keyString) throws EASBizException, BOSException {
        if (orgTree == null) {
            return null;
        }
        ObjectUuidPK pk = new ObjectUuidPK(orgTree.getId());
        String v = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)pk, keyString);
        return v;
    }

    public static HashMap getSysParamKeys(OrgTreeInfo orgTree) {
        if (orgTree == null) {
            return null;
        }
        ObjectUuidPK pk = new ObjectUuidPK(orgTree.getId());
        HashMap<String, ObjectUuidPK> keys = new HashMap<String, ObjectUuidPK>(8);
        keys.put(CSLSYSPARAM_INFO_BASECURRENCY, pk);
        keys.put(CSLSYSPARAM_INFO_RATETABLE, pk);
        keys.put(CSLSYSPARAM_INFO_ISUPTFORMATOFTEMPLET, pk);
        keys.put(CSLSYSPARAM_INFO_MERGETYPE, pk);
        keys.put(CSLSYSPARAM_INFO_ALLOW_UNDETAILITEM, pk);
        return keys;
    }

    public static String getRootOrgIDForRootCU(Context ctx) throws BOSException, EASBizException {
        String strRootCompanyID = null;
        String pkId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        ObjectUuidPK pk = new ObjectUuidPK(pkId);
        CtrlUnitInfo rootCUInfo = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)pk, CSLServerHelper.getSelectorForRootCU());
        if (rootCUInfo.isIsCompanyOrgUnit()) {
            CompanyOrgUnitInfo rootCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk, CSLServerHelper.getSelectorForCompanyID());
            return rootCompany.getId().toString();
        }
        return strRootCompanyID;
    }

    private static SelectorItemCollection getSelectorForRootCU() {
        if (selectorForRootCU == null) {
            selectorForRootCU = new SelectorItemCollection();
            selectorForRootCU.add(new SelectorItemInfo("isCompanyOrgUnit"));
        }
        return selectorForRootCU;
    }

    private static SelectorItemCollection getSelectorForCompanyID() {
        if (selectorForCompanyID == null) {
            selectorForCompanyID = new SelectorItemCollection();
            selectorForCompanyID.add(new SelectorItemInfo("id"));
        }
        return selectorForCompanyID;
    }

    public static boolean isHasCodingRuleByOrg(Context ctx, IObjectValue v, String strOrgID) throws CodingRuleException, EASBizException, BOSException {
        if (strOrgID == null) {
            return false;
        }
        return strOrgID != null && CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist(v, strOrgID);
    }
}

