/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptCommitException;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractCheckFormulaControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.articulation.ArticulationCheckResultAdapter;
import com.kingdee.eas.fi.gr.cslrpt.articulation.ArticulationServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.articulation.IArticulationService;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.check.ReportCheck;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class CheckFormulaControllerBean
extends AbstractCheckFormulaControllerBean {
    private static Logger logger = Logger.getLogger(CheckFormulaControllerBean.class);

    private SelectorItemCollection getCslReportSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("orgTree"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("orgUnit"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("data"));
        return sic;
    }

    @Override
    protected void _passCheck(Context ctx, String orgTree, String orgUnit, String currency, int periodType, int year, int period, int sourceType) throws BOSException {
        if (orgTree != null && orgUnit != null && currency != null) {
            String orgTreeId = orgTree;
            String orgUnitId = orgUnit;
            String currencyId = currency;
            StringBuffer sql = new StringBuffer(" UPDATE T_CSL_CslReport SET FCheckedStatus = ");
            sql.append(2).append("  \r\n ");
            sql.append(" WHERE FOrgTreeId = '").append(orgTreeId).append("' \r\n");
            sql.append(" and FOrgUnitId = '").append(orgUnitId).append("' \r\n");
            sql.append(" and FCurrencyId = '").append(currencyId).append("' \r\n");
            sql.append(" and FPeriodType = ").append(periodType);
            sql.append(" and FYear = ").append(year);
            sql.append(" and FPeriod = ").append(period);
            sql.append(" and FSourceType = ").append(sourceType);
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    @Override
    protected void _cslRptCommit(Context ctx, String cslRptInfo, boolean isCommit, boolean isGroupCommit) throws BOSException, EASBizException {
        if (cslRptInfo != null) {
            StringBuffer sql;
            ICslReport iCslRpt = CslReportFactory.getLocalInstance(ctx);
            CslReportInfo info = iCslRpt.getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cslRptInfo)), this.getCslReportSelector());
            String reportId = cslRptInfo;
            String orgTreeId = info.getOrgTree().getId().toString();
            String orgUnitId = info.getOrgUnit().getId().toString();
            String currencyId = info.getCurrency().getId().toString();
            int periodType = info.getPeriodType().getValue();
            int year = info.getYear();
            short period = info.getPeriod();
            int sourceType = info.getSourceType().getValue();
            int commitStatus = -1;
            if (isCommit) {
                commitStatus = isGroupCommit ? 3 : 2;
            } else {
                sql = new StringBuffer(" SELECT FCommittedStatus  FROM T_CSL_CslReport \r\n");
                sql.append(" WHERE FOrgTreeId = '").append(orgTreeId).append("' \r\n");
                sql.append(" and FOrgUnitId = '").append(orgUnitId).append("' \r\n");
                sql.append(" and FCurrencyId = '").append(currencyId).append("' \r\n");
                sql.append(" and FPeriodType = ").append(periodType);
                sql.append(" and FYear = ").append(year);
                sql.append(" and FPeriod = ").append(period);
                sql.append(" and FSourceType = ").append(sourceType);
                sql.append(" and FCommittedStatus = ").append(3);
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                StringBuffer innerSql = new StringBuffer(" SELECT FCommitStatus FROM T_CSL_InterItemData \r\n ");
                innerSql.append(" WHERE FReport = '").append(reportId).append("' \r\n");
                innerSql.append(" and FCommitStatus = ").append(3);
                IRowSet innerRs = DbUtil.executeQuery((Context)ctx, (String)innerSql.toString());
                StringBuffer exchSql = new StringBuffer(" SELECT FCommitStatus FROM T_CSL_ExchItemData \r\n ");
                exchSql.append(" WHERE FReport = '").append(reportId).append("' \r\n");
                exchSql.append(" and FCommitStatus = ").append(3);
                IRowSet exchRs = DbUtil.executeQuery((Context)ctx, (String)exchSql.toString());
                try {
                    if (rs.next() || innerRs.next() || exchRs.next()) {
                        throw new CslRptCommitException(CslRptCommitException.CANNOT_UNCOMMIT);
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                commitStatus = isGroupCommit ? 2 : 1;
            }
            sql = new StringBuffer(" UPDATE T_CSL_CslReport SET FCommittedStatus = ");
            sql.append(commitStatus).append("  \r\n ");
            sql.append(" WHERE Fid in (SELECT FID FROM T_CSL_CslReport \r\n");
            sql.append(" WHERE FOrgTreeId = '").append(orgTreeId).append("' \r\n");
            sql.append(" and FOrgUnitId = '").append(orgUnitId).append("' \r\n");
            sql.append(" and FCurrencyId = '").append(currencyId).append("' \r\n");
            sql.append(" and FPeriodType = ").append(periodType);
            sql.append(" and FYear = ").append(year);
            sql.append(" and FPeriod = ").append(period);
            sql.append(" and FSourceType = ").append(sourceType);
            sql.append(" and FAuditedStatus = 2");
            sql.append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            StringBuffer sql1 = new StringBuffer(" UPDATE T_CSL_ItemData SET FCommitStatus = ");
            sql1.append(commitStatus).append("  \r\n ");
            sql1.append(" WHERE FReportID in (SELECT FID FROM T_CSL_CslReport \r\n");
            sql1.append(" WHERE FOrgTreeId = '").append(orgTreeId).append("' \r\n");
            sql1.append(" and FOrgUnitId = '").append(orgUnitId).append("' \r\n");
            sql1.append(" and FCurrencyId = '").append(currencyId).append("' \r\n");
            sql1.append(" and FPeriodType = ").append(periodType);
            sql1.append(" and FYear = ").append(year);
            sql1.append(" and FPeriod = ").append(period);
            sql1.append(" and FSourceType = ").append(sourceType);
            sql1.append(" and FAuditedStatus = 2");
            sql1.append(")");
            DbUtil.execute((Context)ctx, (String)sql1.toString());
            sql1 = new StringBuffer(" UPDATE T_CSL_ItemDataEntry SET FCommitStatus = ");
            sql1.append(commitStatus).append("  \r\n ");
            sql1.append(" WHERE FReportID in (SELECT FID FROM T_CSL_CslReport \r\n");
            sql1.append(" WHERE FOrgTreeId = '").append(orgTreeId).append("' \r\n");
            sql1.append(" and FOrgUnitId = '").append(orgUnitId).append("' \r\n");
            sql1.append(" and FCurrencyId = '").append(currencyId).append("' \r\n");
            sql1.append(" and FPeriodType = ").append(periodType);
            sql1.append(" and FYear = ").append(year);
            sql1.append(" and FPeriod = ").append(period);
            sql1.append(" and FSourceType = ").append(sourceType);
            sql1.append(" and FAuditedStatus = 2");
            sql1.append(")");
            DbUtil.execute((Context)ctx, (String)sql1.toString());
            Timestamp commitDate = new Timestamp(System.currentTimeMillis());
            StringBuffer sql2 = new StringBuffer(" UPDATE T_CSL_InterItemData  SET FCommitStatus = ");
            sql2.append(commitStatus).append(", \r\n");
            sql2.append(" FCommitDate = Date'").append(commitDate).append("' \r\n");
            sql2.append(" WHERE FReport = '").append(reportId).append("' \r\n");
            DbUtil.execute((Context)ctx, (String)sql2.toString());
            StringBuffer sql3 = new StringBuffer(" UPDATE T_CSL_ExchItemData  SET FCommitStatus = ");
            sql3.append(commitStatus).append(", \r\n");
            sql3.append(" FCommitDate = Date'").append(commitDate).append("' \r\n");
            sql3.append(" WHERE FReport = '").append(reportId).append("' \r\n");
            DbUtil.execute((Context)ctx, (String)sql3.toString());
        }
    }

    @Override
    public void _passCheck(Context ctx, String orgTree, List orgUnit, List currency, int periodType, int year, int period) throws BOSException, EASBizException {
        if (orgTree != null && orgUnit != null && currency != null) {
            int i;
            StringBuffer sql = new StringBuffer(" UPDATE T_CSL_CslReport SET FCheckedStatus = ");
            sql.append(2).append("  \r\n ");
            sql.append(" WHERE FOrgTreeId = '").append(orgTree).append("' \r\n");
            if (orgUnit.size() <= 1) {
                sql.append(" and FOrgUnitId = '").append(orgUnit.get(0)).append("' \r\n");
            } else {
                sql.append(" and FOrgUnitId  in(");
                for (i = 0; i < orgUnit.size(); ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append("'" + orgUnit.get(i) + "'");
                }
                sql.append(") \r\n");
            }
            if (currency.size() <= 1) {
                sql.append(" and FCurrencyId = '").append(currency.get(0)).append("' \r\n");
            } else {
                sql.append(" and FCurrencyId in (");
                for (i = 0; i < currency.size(); ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append("'" + currency.get(i) + "'");
                }
                sql.append(") \r\n");
            }
            sql.append(" and FPeriodType = ").append(periodType);
            sql.append(" and FYear = ").append(year);
            sql.append(" and FPeriod = ").append(period);
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    @Override
    protected List _checkBtwRelation(Context ctx, List idList, int entryType) throws BOSException, EASBizException {
        return ArticulationCheckResultAdapter.getArticulationCheckResult(ArticulationServiceFactory.getArticulationService().checkArticulation(ctx, idList, 2));
    }

    @Override
    protected List _exeItemDiffCheck(Context ctx, List idList, int entryType) throws BOSException, EASBizException {
        IArticulationService articulationService = ArticulationServiceFactory.getArticulationService();
        Map reportArticulationResult = articulationService.checkArticulation(ctx, idList, 3);
        List resultList = ArticulationCheckResultAdapter.getArticulationCheckResult(reportArticulationResult);
        return resultList;
    }

    @Override
    protected Map _checkCslReportList(Context ctx, List reportList, int entryType) throws BOSException, EASBizException {
        HashMap returnMap = new HashMap(2);
        if (reportList.isEmpty()) {
            return returnMap;
        }
        CslReportInfo cslReport = null;
        boolean isReceiveCheck001 = CSLParamUtil.isReceiveCheck001(ctx);
        ArrayList<Boolean> checkResult = new ArrayList<Boolean>(reportList.size());
        ArrayList<String> idList = new ArrayList<String>(reportList.size());
        for (int i = 0; i < reportList.size(); ++i) {
            cslReport = (CslReportInfo)reportList.get(i);
            idList.add(cslReport.getId().toString());
        }
        Map cslReportmap = this.getCslReportMap(ctx, idList);
        for (int i = 0; i < reportList.size(); ++i) {
            cslReport = (CslReportInfo)reportList.get(i);
            cslReport = (CslReportInfo)cslReportmap.get(cslReport.getId().toString());
            ArrayList msg = null;
            if (!isReceiveCheck001) {
                msg = ReportCheck.checkReport((Context)ctx, (ReportBaseInfo)cslReport, null);
            }
            boolean ispass = false;
            ispass = msg == null ? true : (Boolean)msg.get(0);
            checkResult.add(ispass ? Boolean.TRUE : Boolean.FALSE);
            if (ispass) continue;
            CslReportFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(cslReport.getId().toString()), true);
        }
        returnMap.put("checkResult", checkResult);
        return returnMap;
    }

    private Map getCslReportMap(Context ctx, List idList) throws BOSException {
        if (idList != null && idList.size() > 0) {
            ICslReport iCslReport = CslReportFactory.getLocalInstance(ctx);
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            TreeSet set = new TreeSet();
            for (int i = 0; i < idList.size(); ++i) {
                set.add(idList.get(i));
            }
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("template.number"));
            sic.add(new SelectorItemInfo("template.templateType"));
            sic.add(new SelectorItemInfo("template.group"));
            sic.add(new SelectorItemInfo("sourceCurrency.number"));
            sic.add(new SelectorItemInfo("currency.number"));
            sic.add(new SelectorItemInfo("orgUnit.number"));
            sic.add(new SelectorItemInfo("orgUnit.name"));
            sic.add(new SelectorItemInfo("company.number"));
            sic.add(new SelectorItemInfo("company.name"));
            sic.add(new SelectorItemInfo("orgTree.number"));
            sic.add(new SelectorItemInfo("dataCollect.*"));
            sic.add(new SelectorItemInfo("dataCollect.id"));
            sic.add(new SelectorItemInfo("dataCollect.number"));
            view.setSelector(sic);
            CslReportCollection collection = iCslReport.getCslReportCollection(view);
            HashMap<String, CslReportInfo> map = new HashMap<String, CslReportInfo>();
            for (int i = 0; i < collection.size(); ++i) {
                map.put(collection.get(i).getId().toString(), collection.get(i));
            }
            return map;
        }
        return null;
    }
}

