/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.ConvertStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.IItemDataProvider;
import com.kingdee.eas.fi.gr.cslrpt.ISumRptAddedPerporty;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RunTimeException;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyCollection;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.CslReportControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.ElimReportUtils;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.dynamic.DynaItemTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluFactory;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.IsSupportGroupReportEnum;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptAndTempException;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.awt.Point;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CslReportSave {
    public static final int DynaValue = 0;
    public static final int DynaName = 1;
    public static final int DynaType = 2;
    public static final int DynaRow = 3;
    public static final int DynaCol = 4;
    public static final int DynaSheetId = 5;
    public static final int Grade = 6;
    private static final String RES_CSLRPTAutoGenerate = "com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource";
    private boolean GR_CSL_SUPPORTSAVEZERIDYITEM;
    private boolean isSaveOffSetYearOrPeriodItemData = false;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.CslReportSave");

    public void update(Context ctx, IObjectPK pk, IObjectValue model, boolean isSaveItemData) throws BOSException, EASBizException {
        try {
            if (this.isAudited(ctx, pk)) {
                throw new RptAndTempException(RptAndTempException.CANNTUPDATE_AUDITED);
            }
            ICslReport icslrpt = CslReportFactory.getLocalInstance(ctx);
            CslReportInfo info = (CslReportInfo)model;
            this.setDefaultSourceCurrency(info);
            if (info.getSourceType().equals((Object)RptSrcTypeEnum.CONSOLIDATION) || info.getSourceType().equals((Object)RptSrcTypeEnum.CONSOLIDATION_FASTMERGE)) {
                icslrpt.update_Csl();
            } else if (info.getSourceType().equals((Object)RptSrcTypeEnum.MANUSCRIPT) || info.getSourceType().equals((Object)RptSrcTypeEnum.MANUSCRIPT_FASTMERGE)) {
                icslrpt.update_Mns();
            } else if (info.getSourceType().equals((Object)RptSrcTypeEnum.NORMAL) || info.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICNORMALREPORT) || info.getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT) || info.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE)) {
                icslrpt.update_Group();
            } else if (info.getSourceType().equals((Object)RptSrcTypeEnum.SUM) || info.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT) || info.getSourceType().equals((Object)RptSrcTypeEnum.DIFFTABLE) || info.getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT)) {
                icslrpt.update_Sum();
            }
            int srcTypeEnum = info.getSourceType().getValue();
            if (srcTypeEnum != 2 && srcTypeEnum != 31 && srcTypeEnum != 11 && srcTypeEnum != 32 && srcTypeEnum != 4 && srcTypeEnum != 33 && srcTypeEnum != 35 && srcTypeEnum != 34 && srcTypeEnum != 43 && srcTypeEnum != 44 && srcTypeEnum != 16 && icslrpt.isExistsSameReport(pk, model) && info.getFormulaCalc() == null) {
                throw new ServerException(ServerException.EXISTS_SAME_RPT);
            }
            CslReportControllerBean bean = new CslReportControllerBean();
            bean.superUpdate(ctx, pk, (IObjectValue)info);
            if (srcTypeEnum == 4 || srcTypeEnum == 16 || srcTypeEnum == 2 || srcTypeEnum == 11 || srcTypeEnum == 3 || srcTypeEnum == 12 || srcTypeEnum == 31 || srcTypeEnum == 33 || srcTypeEnum == 32 || srcTypeEnum == 34 || srcTypeEnum == 35 || srcTypeEnum == 14) {
                SumRptAddedPerportyInfo addedPerporty;
                ISumRptAddedPerporty iAddedPerporty = SumRptAddedPerportyFactory.getLocalInstance(ctx);
                if (info.containsKey("addedPerporty")) {
                    addedPerporty = (SumRptAddedPerportyInfo)info.get("addedPerporty");
                    if (pk != null) {
                        addedPerporty.setReport(pk.toString());
                    }
                    if (!(srcTypeEnum == 4 || srcTypeEnum == 3 || srcTypeEnum == 2 && IsSupportGroupReportEnum.SUPPORT.equals((Object)addedPerporty.getIsSupportGroup()) || addedPerporty.getIsSupportGroup() != null && addedPerporty.getIsSupportGroup().getValue() == 1)) {
                        isSaveItemData = false;
                    }
                    iAddedPerporty.addnew(addedPerporty);
                } else {
                    addedPerporty = null;
                    SumRptAddedPerportyCollection addedPerportys = iAddedPerporty.getSumRptAddedPerportyCollection("where report='" + pk.toString() + "'");
                    if (addedPerportys != null && addedPerportys.size() > 0 && !info.containsKey("isUpdate")) {
                        if (!addedPerportys.get(0).getIsSupportGroup().equals((Object)IsSupportGroupReportEnum.SUPPORT) && srcTypeEnum != 4 && srcTypeEnum != 3) {
                            isSaveItemData = false;
                        }
                    } else {
                        HashMap<String, Object> params = new HashMap<String, Object>(10);
                        params.put("treeID", info.getOrgTree().getId().toString());
                        params.put("companyID", info.getOrgUnit().getId().toString());
                        params.put("periodType", new Integer(info.getPeriodType().getValue()));
                        params.put("year", new Integer(info.getYear()));
                        params.put("period", new Integer(info.getPeriod()));
                        params.put("currencyID", info.getCurrency().getId().toString());
                        params.put("templateGroupNumber", info.getTemplate().getGroup());
                        params.put("reportType", new Integer(info.getReportSourceType().getValue()));
                        params.put("dataCollectNumber", "ACTUALDATA");
                        addedPerporty = RptAutoWeaveUtil.getNextSumRptAddedPerportyInfo(ctx, params);
                        if (addedPerporty == null) {
                            addedPerporty = new SumRptAddedPerportyInfo();
                            addedPerporty.setVersion(1);
                            addedPerporty.setRemark("");
                        }
                        if (info.getFastMergeSoluId() != null && ConvertStatusEnum.Converted.equals((Object)info.getConvertStatus())) {
                            FastMergeSoluInfo fastinfo = FastMergeSoluFactory.getLocalInstance(ctx).getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(info.getFastMergeSoluId()));
                            if (fastinfo != null && fastinfo.isIsSupportGroupReport()) {
                                addedPerporty.setIsSupportGroup(IsSupportGroupReportEnum.SUPPORT);
                            } else {
                                addedPerporty.setIsSupportGroup(IsSupportGroupReportEnum.NOTSUPPORT);
                            }
                        } else {
                            addedPerporty.setIsSupportGroup(IsSupportGroupReportEnum.SUPPORT);
                        }
                        addedPerporty.setReport(pk.toString());
                        if (StringUtils.isEmpty((String)addedPerporty.getGroup())) {
                            addedPerporty.setGroup(Uuid.create().toString());
                        }
                        iAddedPerporty.addnew(addedPerporty);
                    }
                }
                if (info.getFastMergeSoluId() != null && this.isFastMergeReport(info) || isSaveItemData) {
                    this.saveItemData(ctx, pk, info);
                }
            } else if (isSaveItemData) {
                this.saveItemData(ctx, pk, info);
            }
            IReport irpt = ReportFactory.getLocalInstance((Context)ctx);
            if (irpt.exists("Where cslreport.id = '" + pk.toString() + "'")) {
                ReportInfo rpt = irpt.getReportInfo("Where cslreport.id = '" + pk.toString() + "'");
                rpt.setData(info.getData());
                irpt.save((CoreBaseInfo)rpt);
            }
        }
        catch (Exception e) {
            logger.error((Object)"update error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private boolean isAudited(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        ICslReport cslReport;
        CslReportCollection coll;
        if (pk != null && (coll = (cslReport = ctx != null ? CslReportFactory.getLocalInstance(ctx) : CslReportFactory.getRemoteInstance()).getCslReportCollection("select auditedStatus where id='" + pk + "'")) != null && coll.size() > 0) {
            return AuditedStatusEnum.AUDITED.equals((Object)coll.get(0).getAuditedStatus());
        }
        return false;
    }

    private boolean isFastMergeReport(CslReportInfo cslReportInfo) {
        int srcTypeEnum = cslReportInfo.getSourceType().getValue();
        boolean isSupportGroupReport = srcTypeEnum == 31 || srcTypeEnum == 33 || srcTypeEnum == 32 || srcTypeEnum == 34 || srcTypeEnum == 35 || srcTypeEnum == 14;
        return isSupportGroupReport;
    }

    private void saveItemData(Context ctx, IObjectPK pk, CslReportInfo info) throws EASBizException, BOSException {
        if (info.getSourceType().equals((Object)RptSrcTypeEnum.DIFFTABLE)) {
            return;
        }
        boolean isAdjustRpt = AdjustStatusEnum.ADJUSTED.equals((Object)info.getAdjustStatus());
        boolean isCaliAdjustRpt = AdjustStatusEnum.CALIADJUSTED.equals((Object)info.getAdjustStatus());
        boolean isAddNew = info.getBoolean("isAddNew");
        if ((isAdjustRpt || isCaliAdjustRpt) && isAddNew) {
            return;
        }
        Book book = null;
        try {
            book = IOHelper.unpackBook((byte[])info.getData(), (String)"rpt_trans");
            book.setCalculate(false);
            BookProperties p = BookProperties.loadFromBook((Book)book);
            CSLPropertyAdapter adapter = new CSLPropertyAdapter();
            adapter.initReportProperties((IObjectValue)info, ctx);
            FormulaDefinition.registerFormulaToBook((Book)book, (ICalculateContextProvider)new ReportCalculateContext(ctx, (IReportPropertyAdapter)adapter, p.getVariables(), (IErrorProvider)p.getErrorProvider(), null));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        Set sheetIdSet = this.getIncludeItemSheetSet(ctx, info, book);
        if (sheetIdSet.isEmpty()) {
            return;
        }
        List sheetList = this.getIncludeItemSheetList(sheetIdSet, book, info);
        boolean[] values = CSLParamUtil.batchGetParam(ctx, new String[]{"GR_CSL_MergeByFiscalPeriod", "GR_CSL_Support13Period"});
        boolean isMergeByFiscalPeriod = values[0];
        boolean isSupport13Period = values[1];
        PeriodCollection periods = null;
        if (isMergeByFiscalPeriod) {
            if (CslRptUtil.isCslRpt(info.getSourceType().getValue())) {
                periods = FiscalPeriodHelper.getPeriodCollection(ctx, info.getOrgTree());
            } else if (info.getCompany() != null) {
                periods = FiscalPeriodHelper.getPeriodCollection(ctx, info.getOrgUnit().getId().toString());
            }
        }
        int valueType = 0;
        if (isAdjustRpt) {
            valueType = 2;
        } else if (isCaliAdjustRpt) {
            valueType = 12;
        }
        Map mapH = new HashMap();
        HashMap mapV = new HashMap();
        HashMap mapE = new HashMap();
        HashMap mapInvest = new HashMap();
        boolean isDynamic = this.isDynamic(ctx, info);
        if (isDynamic) {
            this.GR_CSL_SUPPORTSAVEZERIDYITEM = CSLParamUtil.isSupportSaveZeroDyItem(ctx);
        }
        this.isSaveOffSetYearOrPeriodItemData = CSLParamUtil.isSaveOffSetYearOrPeriodItemData(ctx);
        if (isAdjustRpt || isCaliAdjustRpt) {
            mapH = this.getAdjustedData(ctx, info, book, sheetList, periods, isMergeByFiscalPeriod, isSupport13Period);
        } else {
            Sheet sheet = null;
            for (int i = 0; i < sheetList.size(); ++i) {
                sheet = (Sheet)sheetList.get(i);
                this.scanTable(ctx, info, sheet, mapH, mapV, mapE, mapInvest, periods, isMergeByFiscalPeriod, isSupport13Period);
            }
        }
        IItemDataProvider iItemData = ItemDataProviderFactory.getLocalInstance(ctx);
        if (isDynamic) {
            iItemData.saveDynaItemData(pk.toString(), mapH, valueType);
        } else {
            iItemData.saveItemData(pk.toString(), mapH, mapV, mapE, mapInvest, valueType);
        }
    }

    private Set getIncludeItemSheetSet(Context ctx, CslReportInfo info, Book book) throws BOSException {
        int count = book.getSheetCount();
        HashSet<String> sheetIdSet = new HashSet<String>(count);
        if (info.getTemplate() != null) {
            String templateId = info.getTemplate().getId().toString();
            String sql = new StringBuffer("SELECT DISTINCT FSHEETID FROM T_CSL_TEMPLETITEMLIST").append(" WHERE FTEMPLATEID = (SELECT ISNULL(FGROUPTEMPLATEID,FID) AS FID ").append(" FROM T_RPT_TEMPLATE WHERE FID = ?)").toString();
            String sheetId = null;
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{templateId});
                while (rowSet.next()) {
                    sheetId = rowSet.getString("FSHEETID");
                    sheetIdSet.add(sheetId);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        } else {
            for (int i = 0; i < count; ++i) {
                sheetIdSet.add(book.getSheet(i).getID());
            }
        }
        return sheetIdSet;
    }

    private Map getAdjustedData(Context ctx, CslReportInfo report, Book book, List sheetList, PeriodCollection periods, boolean isMergeByFiscalPeriod, boolean isSupport13Period) throws EASBizException, BOSException {
        HashMap itemData = new HashMap();
        HashMap dynamicItems = null;
        ArrayList list = null;
        HashMap dynaItemTypes = null;
        int sourceType = report.getSourceType().getValue();
        boolean isDynamic = sourceType == 10 || sourceType == 11 || sourceType == 12;
        int dyType = report.getDynaRptType().getValue();
        int sheets = book.getSheetCount();
        for (int i = 0; i < sheetList.size(); ++i) {
            Sheet sheet = (Sheet)sheetList.get(i);
            if (isDynamic) {
                list = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
                dynaItemTypes = new HashMap();
                dynamicItems = this.getDynaNameMap(sheet);
            }
            int rows = sheet.getMaxRowIndex();
            int cols = sheet.getMaxColIndex();
            Sheet.ICellsIterator cellsIterator = sheet.getCellsIterator(0, 0, rows, cols, false, true);
            while (cellsIterator.hasNext()) {
                boolean need;
                Cell cell = cellsIterator.next();
                ItemFormula itemFormula = UserObjectHelper.getItemFormula((Cell)cell);
                if (itemFormula == null || StringUtils.isEmpty((String)itemFormula.getItemNumber()) || StringUtils.isEmpty((String)itemFormula.getDataElementNumber()) || !cell.hasFormula()) continue;
                if (isSupport13Period) {
                    RPTDate13Util.getRptYearAndPeriod(itemFormula, report.getYear(), report.getPeriod(), report.getPeriodType(), isSupport13Period);
                } else {
                    FiscalPeriodHelper.getRptYearAndPeriod(periods, itemFormula, report.getYear(), report.getPeriod(), report.getPeriodType(), isMergeByFiscalPeriod);
                }
                String formula = cell.getFormula();
                boolean bl = need = !CslRptUtil.isDebarFormula(formula);
                if (formula.startsWith("=AcctItem") || formula.startsWith("=DyItem")) {
                    need = true;
                }
                if (!need) continue;
                StringBuffer key = new StringBuffer();
                try {
                    key.append(DataElementProvider.getDataElementInnerValue(ctx, itemFormula.getDataElementNumber()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                key.append(",");
                key.append(itemFormula.getValueType());
                key.append(",");
                key.append(itemFormula.getYear());
                key.append(",");
                key.append(itemFormula.getPeriod());
                key.append(",");
                key.append(itemFormula.getDay().toString());
                HashMap<String, Object> value = (HashMap<String, Object>)itemData.get(key.toString());
                if (value == null) {
                    value = new HashMap<String, Object>();
                    itemData.put(key.toString(), value);
                }
                if (!isDynamic) {
                    if (cell.getValue().getValue() != null && !cell.getValue().getValue().toString().equals("")) {
                        value.put(itemFormula.getItemNumber(), cell.getValue().getValue());
                    }
                } else if (!StringUtils.isEmpty((String)itemFormula.getDItemNumber())) {
                    String dItemNumber = itemFormula.getDItemNumber();
                    HashMap mapd = (HashMap)value.get(itemFormula.getItemNumber());
                    if (mapd == null) {
                        mapd = new HashMap();
                        value.put(itemFormula.getItemNumber(), mapd);
                    }
                    if (cell.getValue().getValue() != null && !cell.getValue().getValue().toString().equals("")) {
                        ArrayList<Object> dValue = new ArrayList<Object>(3);
                        dValue.add(cell.getValue().getValue());
                        dValue.add(this.getDynaName(dynamicItems, cell.getRow(), cell.getCol()));
                        if (isDynamic) {
                            Point point = new Point(cell.getCol(), cell.getRow());
                            if ((point = DynamicTemplateUtility.getBasePoint((Sheet)sheet, (Point)point, (ArrayList)list)) == null) continue;
                            DynaItemTypeEnum dynaItemType = DynaItemTypeEnum.ManualImport;
                            if (report.getSourceType() != RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT && report.getSourceType() != RptSrcTypeEnum.MULTIDYNAMICSUMREPORT) {
                                dynaItemType = this.getDynaItemType(ctx, sheet, point, dynaItemTypes);
                            }
                            dValue.add(new Integer(dynaItemType.getValue()));
                        } else {
                            dValue.add(new Integer(dyType));
                        }
                        mapd.put(dItemNumber, dValue);
                    }
                }
                itemData.put(key.toString(), value);
            }
        }
        Iterator it = itemData.entrySet().iterator();
        ArrayList<String> keyList = new ArrayList<String>();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!((Map)entry.getValue()).isEmpty()) continue;
            keyList.add(entry.getKey().toString());
        }
        for (int i = 0; i < keyList.size(); ++i) {
            itemData.remove(keyList.get(i));
        }
        return itemData;
    }

    private String getDynaName(HashMap mapExt, int r, int c) {
        if (mapExt == null) {
            return null;
        }
        for (Point element : mapExt.keySet()) {
            if (r != element.y && c != element.x) continue;
            return (String)mapExt.get(element);
        }
        return null;
    }

    private DynaItemTypeEnum getDynaItemType(Context ctx, Sheet sheet, Point point, Map dynaItemTypes) throws BOSException, EASBizException {
        if (point == null) {
            return DynaItemTypeEnum.Other;
        }
        DynaItemTypeEnum type = null;
        if (dynaItemTypes.containsKey(point.x + "&" + point.y)) {
            type = (DynaItemTypeEnum)dynaItemTypes.get(point.x + "&" + point.y);
        } else {
            block8: {
                DynaParameters params = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)point);
                if (params.getDynaItemSource() == 0) {
                    type = DynaItemTypeEnum.ManualImport;
                } else {
                    String itemname = params.getAssistantType().properityName;
                    String sql = "select FAsstHGAttribute from t_bd_asstActType where FNumber = ?";
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{itemname});
                    try {
                        if (rowSet.next()) {
                            String asstType = rowSet.getString("FAsstHGAttribute");
                            type = asstType.equals("companyOrg") ? DynaItemTypeEnum.Company : (asstType.equals("customer") ? DynaItemTypeEnum.Custom : (asstType.equals("provider") ? DynaItemTypeEnum.Provider : DynaItemTypeEnum.Other));
                            break block8;
                        }
                        throw new EASBizException(new NumericExceptionSubItem("001", this.getResString(ctx, "136_CSLReportCalculatorControllerBean") + params.getAssistantType().properityAlias + "    " + itemname));
                    }
                    catch (SQLException e) {
                        throw new SQLDataException(e);
                    }
                }
            }
            dynaItemTypes.put(point.x + "&" + point.y, type);
        }
        return type;
    }

    private String getResString(Context ctx, String resName) {
        return ResourceBase.getString((String)RES_CSLRPTAutoGenerate, (String)resName, (Locale)ctx.getLocale());
    }

    private HashMap getDynaNameMap(Sheet sheet) {
        HashMap<Point, String> dynaNameMap;
        block4: {
            int colCount;
            int spreadStyle;
            Point firstBasePoint;
            block3: {
                dynaNameMap = new HashMap<Point, String>();
                ArrayList basePointList = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
                if (basePointList == null || basePointList.size() == 0) {
                    return null;
                }
                firstBasePoint = (Point)basePointList.get(0);
                DynaParameters params = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)firstBasePoint);
                spreadStyle = params.getSpreadStyle();
                int rowCount = sheet.getRows().getMaxIntMark() + 1;
                colCount = sheet.getCols().getMaxIntMark() + 1;
                if (spreadStyle != 0) break block3;
                for (int i = firstBasePoint.y; i < rowCount; ++i) {
                    Point pt = new Point(firstBasePoint.x, i);
                    String displayText = sheet.getRange(i, firstBasePoint.x).getText();
                    displayText = displayText == null ? "" : displayText.trim();
                    dynaNameMap.put(pt, displayText);
                }
                break block4;
            }
            if (spreadStyle != 1) break block4;
            for (int i = firstBasePoint.x; i < colCount; ++i) {
                Point pt = new Point(i, firstBasePoint.y);
                String displayText = sheet.getRange(firstBasePoint.y, i).getText();
                displayText = displayText == null ? "" : displayText.trim();
                dynaNameMap.put(pt, displayText);
            }
        }
        return dynaNameMap;
    }

    private boolean isDynamic(Context ctx, CslReportInfo info) throws BOSException {
        int sourceType = info.getSourceType().getValue();
        if (sourceType == 10 || sourceType == 11 || sourceType == 12 || sourceType == 42 || sourceType == 43 || sourceType == 35 || sourceType == 32 || sourceType == 13 || sourceType == 15 || sourceType == 45 || sourceType == 14) {
            return true;
        }
        if (sourceType == 8) {
            int tmpType = -1;
            if (info.getTemplate().getTemplateType() != null) {
                tmpType = info.getTemplate().getTemplateType().getValue();
            } else {
                String sql = "select FTemplateType from t_rpt_template where fid = ?";
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{info.getTemplate().getId().toString()});
                try {
                    if (rowSet.next()) {
                        tmpType = rowSet.getInt("FTemplateType");
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
            if (tmpType == 10 || tmpType == 11 || tmpType == 13) {
                return true;
            }
        }
        return false;
    }

    private void scanTable(Context ctx, CslReportInfo info, Sheet sheet, Map mapH, HashMap mapV, HashMap mapE, HashMap mapInvest, PeriodCollection periods, boolean isMergeByFiscalPeriod, boolean isSupport13Period) throws EASBizException, BOSException {
        int row = sheet.getRows().getMaxIntMark() + 1;
        int col = sheet.getCols().getMaxIntMark() + 1;
        CSLReportGroupEnum rptGroupEnum = this.getRptGroupEnum(info, sheet);
        if (rptGroupEnum != null && rptGroupEnum.getValue() == 10) {
            int left = CslRptUtil.getBasePosition_Left(sheet);
            int top = CslRptUtil.getBasePosition_Top(sheet);
            if (left < 0 || top < 0) {
                throw new ServerException(ServerException.NOT_EXISTS_BASEPOINT);
            }
            for (int i = top + 1; i < row; ++i) {
                for (int j = left + 1; j < col; ++j) {
                    this.setItemDataByV(ctx, info, sheet, i, j, left, top, mapV);
                }
            }
        } else if (rptGroupEnum != null && rptGroupEnum.getValue() == 20) {
            int left = CslRptUtil.getBasePosition_Left(sheet);
            int top = CslRptUtil.getBasePosition_Top(sheet);
            if (left < 0 || top < 0) {
                throw new ServerException(ServerException.NOT_EXISTS_BASEPOINT);
            }
            for (int i = top + 1; i < row; ++i) {
                for (int j = left + 1; j < col; ++j) {
                    this.setItemDataByV(ctx, info, sheet, i, j, left, top, mapE);
                }
            }
        } else if (rptGroupEnum != null && (rptGroupEnum.getValue() == 30 || rptGroupEnum.getValue() == 40)) {
            int left = CslRptUtil.getBasePosition_Left(sheet);
            int top = CslRptUtil.getBasePosition_Top(sheet);
            if (left < 0 || top < 0) {
                throw new ServerException(ServerException.NOT_EXISTS_BASEPOINT);
            }
            for (int i = top + 1; i < row; ++i) {
                for (int j = left + 1; j < col; ++j) {
                    this.setItemDataByV(ctx, info, sheet, i, j, left, top, mapInvest);
                }
            }
        } else if (this.isDynamic(ctx, info)) {
            HashMap mapExt = null;
            if (this.isDynamic(ctx, info)) {
                mapExt = this.getDynaNameMap(sheet);
            }
            ArrayList list = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
            HashMap dynaItemTypes = new HashMap();
            Point basePoint = null;
            DynaParameters parameters = null;
            Rectangle rectangle = null;
            Sheet.ICellsIterator iter = null;
            Cell cell = null;
            for (int i = 0; i < list.size(); ++i) {
                basePoint = (Point)list.get(i);
                parameters = DynamicTemplateUtility.getDynaParametersFromCell((Sheet)sheet, (int)basePoint.y, (int)basePoint.x);
                rectangle = DynamicTemplateUtility.getRectangle((Sheet)sheet, (Point)basePoint);
                iter = sheet.getCellsIterator(rectangle.y, rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, false, true);
                while (iter.hasNext()) {
                    cell = iter.next();
                    DynaItemTypeEnum dynaItemType = DynaItemTypeEnum.ManualImport;
                    if (info.getSourceType() != RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT && info.getSourceType() != RptSrcTypeEnum.MULTIDYNAMICSUMREPORT && info.getSourceType() != RptSrcTypeEnum.MULTIDYNAMICCSLELIMREPORT && info.getSourceType() != RptSrcTypeEnum.MULTIDYNAMICCSLREPORT) {
                        dynaItemType = this.getDynaItemType(ctx, sheet, basePoint, dynaItemTypes);
                    }
                    this.setItemDataByH(ctx, info, sheet, cell.getRow(), cell.getCol(), mapH, mapExt, dynaItemType.getValue(), basePoint, periods, isMergeByFiscalPeriod, isSupport13Period, parameters);
                }
            }
        } else {
            for (int i = 0; i < row; ++i) {
                for (int j = 0; j < col; ++j) {
                    Point point = new Point(j, i);
                    this.setItemDataByH(ctx, info, sheet, i, j, mapH, null, 10, point, periods, isMergeByFiscalPeriod, isSupport13Period, null);
                }
            }
        }
    }

    private CSLReportGroupEnum getRptGroupEnum(CslReportInfo info, Sheet sheet) {
        CSLReportGroupEnum rptGroupEnum = null;
        RptSheetParamCollection paras = info.getSheetParam();
        for (int i = 0; i < paras.size(); ++i) {
            RptSheetParamInfo para = paras.get(i);
            if (!para.getSheetID().equals(sheet.getID())) continue;
            rptGroupEnum = para.getReportClass();
        }
        return rptGroupEnum;
    }

    private void setItemDataByV(Context ctx, CslReportInfo report, Sheet sheet, int rowIndex, int colIndex, int left, int top, HashMap mapV) {
        ItemFormula fh = (ItemFormula)sheet.getRange(top, colIndex).getUserObject("ITEM");
        ItemFormula fv = (ItemFormula)sheet.getRange(rowIndex, left).getUserObject("ITEM");
        if (fh == null || fv == null || fh.getExt("0") == null || fv.getExt("16") == null) {
            return;
        }
        if (this.isZeroOrNullValue(sheet.getRange(rowIndex, colIndex), null)) {
            return;
        }
        StringBuffer key = new StringBuffer();
        StringBuffer value = new StringBuffer();
        key.append(fh.getExt("0").toString());
        key.append(",");
        key.append("");
        key.append(",");
        key.append(fv.getExt("16").toString());
        key.append(",");
        key.append(report.getCompany().getId().toString());
        key.append(",");
        key.append(report.getSourceCurrency().getId().toString());
        key.append(",");
        key.append(report.getCurrency().getId().toString());
        key.append(",");
        key.append(report.getYear());
        key.append(",");
        key.append(report.getPeriod());
        key.append(",");
        key.append(report.getPeriodType().getValue());
        key.append(",");
        if (report.getStartDate() != null) {
            key.append(DateTimeUtils.truncateDate((Date)report.getStartDate()).getTime());
        } else {
            key.append(DateTimeUtils.truncateDate((Date)new Date()).getTime());
        }
        if (fh.getExt("3") != null) {
            key.append(",");
            key.append(fh.getExt("3").toString());
        } else {
            key.append(",");
            key.append("YTDAMOUNT");
        }
        key.append(",");
        key.append(report.getDataCollectNumber());
        Range range = sheet.getRange(rowIndex, colIndex);
        Variant var = range.getValue();
        Object cellValue = var.isEmpty() ? null : var.getValue();
        Comment reportComment = range.getComment();
        String commentString = reportComment != null ? reportComment.getText() : null;
        BigDecimal v_item = null;
        try {
            if (cellValue != null) {
                v_item = var.isNumeric() ? var.toBigDecimal() : new BigDecimal(cellValue.toString().trim());
            }
        }
        catch (Exception e) {
            v_item = null;
        }
        if (v_item == null) {
            value.append("null");
        } else {
            value.append(v_item);
        }
        value.append(",");
        if (commentString != null) {
            value.append("'" + CslRptUtil.escapeKSqlstr(commentString) + "'");
        } else {
            value.append("null");
        }
        mapV.put(key.toString(), value);
    }

    private boolean isOffSetOrWillBeSaveItemData(ItemFormula f) {
        return f.getYearOffSet() == 0 && f.getPeriodOffSet() == 0 || (f.getYearOffSet() != 0 || f.getPeriodOffSet() != 0) && this.isSaveOffSetYearOrPeriodItemData;
    }

    private void setItemDataByH(Context ctx, CslReportInfo report, Sheet sheet, int r, int c, Map mapH, HashMap mapExt, int dynaItemType, Point basePoint, PeriodCollection periods, boolean isMergeByFiscalPeriod, boolean isSupport13Period, DynaParameters params) throws EASBizException, BOSException {
        HashMap value1;
        String ks;
        Range range = sheet.getRange(r, c);
        ItemFormula f = NewRptUtil.getItemFormula((Cell)sheet.getCell(r, c, false), (Point)basePoint);
        if (f == null || f.getFormula() == null) {
            return;
        }
        if (ElimReportUtils.isMultiCslElimReport(report.getSourceType()) && this.isZeroOrNullValue(range, f)) {
            return;
        }
        boolean isDynamic = this.isDynamic(ctx, report);
        String dNumber = f.getDItemNumber();
        if (isDynamic && (dNumber == null || dNumber.length() == 0)) {
            return;
        }
        if (!this.isOffSetOrWillBeSaveItemData(f)) {
            return;
        }
        if (isSupport13Period) {
            RPTDate13Util.getRptYearAndPeriod(f, report.getYear(), report.getPeriod(), report.getPeriodType(), isSupport13Period);
        } else {
            FiscalPeriodHelper.getRptYearAndPeriod(periods, f, report.getYear(), report.getPeriod(), report.getPeriodType(), isMergeByFiscalPeriod);
        }
        StringBuffer key = new StringBuffer();
        key.append(DataElementProvider.getDataElementInnerValue(ctx, f.getDataElementNumber()));
        key.append(",");
        key.append(f.getValueType());
        key.append(",");
        key.append(f.getYear());
        key.append(",");
        key.append(f.getPeriod());
        key.append(",");
        key.append(f.getDay().toString());
        if (ElimReportUtils.isMultiCslElimReport(report.getSourceType())) {
            Row row = sheet.getRow(r, false);
            String companyId = row == null ? null : (row.getUserObject("COMPANY_NUMBER") == null ? null : (String)row.getUserObject("COMPANY_NUMBER").getValue());
            key.append(",").append(companyId);
        }
        if (this.isDynamicContainsAndRemoveZeroByParam(mapH, range, isDynamic, ks = key.toString(), key, f)) {
            return;
        }
        Variant var = range.getValue();
        Object cellValue = var.isEmpty() ? null : var.getValue();
        String companyId = null;
        if (isDynamic || cellValue != null && !cellValue.toString().equals("")) {
            HashMap value = null;
            if (!mapH.containsKey(ks)) {
                value = new HashMap();
                mapH.put(ks, value);
            } else {
                value = (HashMap)mapH.get(ks);
            }
            Object v_item = null;
            if (f.getValueType() == 3) {
                v_item = range.getText();
            } else if (var.isNumeric()) {
                try {
                    v_item = var.toBigDecimal();
                }
                catch (SyntaxErrorException e) {
                    v_item = range.getText();
                }
            } else {
                v_item = range.getText();
            }
            String itemNumber = f.getItemNumber();
            if (!isDynamic) {
                if (v_item instanceof BigDecimal) {
                    value.put(itemNumber, v_item);
                }
            } else {
                Map mapD = null;
                if (!value.containsKey(itemNumber)) {
                    mapD = new HashMap();
                    value.put(itemNumber, mapD);
                } else {
                    mapD = (Map)value.get(itemNumber);
                }
                ArrayList<Object> valueList = new ArrayList<Object>();
                String keyName = null;
                if (report.getSourceType() == RptSrcTypeEnum.MULTIDYNAMICSUMREPORT || report.getSourceType() == RptSrcTypeEnum.MULTIDYNAMICCSLREPORT) {
                    List oldValueList = (List)mapD.get(f.getDItemNumber());
                    if (oldValueList != null) {
                        Object oldValue;
                        if (f.getValueType() == 3) {
                            oldValue = oldValueList.get(0).toString();
                            if (oldValue != null && v_item != null && ((String)oldValue).indexOf(v_item.toString()) >= 0) {
                                valueList.add(0, oldValueList.get(0).toString());
                            } else {
                                valueList.add(0, oldValueList.get(0).toString() + v_item);
                            }
                        } else {
                            oldValue = (BigDecimal)oldValueList.get(0);
                            BigDecimal newValue = (BigDecimal)v_item;
                            valueList.add(0, ((BigDecimal)oldValue).add(newValue));
                        }
                    } else {
                        valueList.add(0, v_item);
                    }
                    keyName = "null";
                } else if (ElimReportUtils.isMultiCslElimReport(report.getSourceType())) {
                    Row row;
                    valueList.add(0, v_item);
                    keyName = this.getDynaName(mapExt, r, c);
                    if (StringUtils.isEmpty((String)keyName)) {
                        keyName = "null";
                    }
                    companyId = (row = sheet.getRow(r, false)) == null ? null : (row.getUserObject("COMPANY_NUMBER") == null ? null : (String)row.getUserObject("COMPANY_NUMBER").getValue());
                } else {
                    valueList.add(0, v_item);
                    keyName = this.getDynaName(mapExt, r, c);
                    if (keyName == null || keyName.length() == 0) {
                        String cellName = sheet.getCell(r, c, true).getName(false, true);
                        String str = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"CslReportBCannotFindNameInCell", (Locale)ctx.getLocale());
                        throw new RunTimeException(RunTimeException.CUSTOMEXCEPTION, new Object[]{MessageFormat.format(str, cellName)});
                    }
                }
                valueList.add(1, keyName);
                valueList.add(2, new Integer(dynaItemType));
                valueList.add(3, new Integer(r));
                valueList.add(4, new Integer(c));
                valueList.add(5, sheet.getID());
                if (params.getDynaItemSource() == 0 && params.isGrade()) {
                    ItemFormula edge;
                    Cell cell = null;
                    cell = params.getSpreadStyle() == 0 ? sheet.getCell(r, basePoint.x, false) : sheet.getCell(basePoint.y, c, false);
                    if (cell != null && (edge = NewRptUtil.getItemFormula((Cell)cell, (Point)basePoint)) != null) {
                        DItemGradeInfo gradeinfo;
                        String grade = edge.getExt("GRADE_NUMBER");
                        valueList.add(6, grade);
                        if (!StringUtils.isEmpty((String)grade) && (gradeinfo = DynamicTemplateUtility.getGradeInfo((Range)sheet.getRange(basePoint.y, basePoint.x))) != null) {
                            DItemGradeEntryInfo find = gradeinfo.find(grade);
                            valueList.add(7, find == null ? true : find.isLeaf());
                        }
                    }
                }
                if (ElimReportUtils.isMultiCslElimReport(report.getSourceType())) {
                    valueList.add(companyId);
                }
                mapD.put(f.getDItemNumber(), valueList);
            }
        }
        if ((value1 = (HashMap)mapH.get(ks)) != null && value1.isEmpty()) {
            mapH.remove(ks);
        }
        key = null;
    }

    private boolean isDynamicContainsAndRemoveZeroByParam(Map mapH, Range range, boolean isDynamic, String ks, StringBuffer key, ItemFormula f) {
        boolean result = false;
        if (this.GR_CSL_SUPPORTSAVEZERIDYITEM) {
            return result;
        }
        if (isDynamic && this.isZeroOrNullValue(range, f)) {
            HashMap value1 = (HashMap)mapH.get(ks);
            if (value1 != null && value1.isEmpty()) {
                mapH.remove(ks);
            }
            key = null;
            result = true;
        }
        return result;
    }

    private boolean isZeroOrNullValue(Range range, ItemFormula f) {
        Variant var;
        int valueType = 1;
        if (range != null) {
            if (f == null) {
                f = (ItemFormula)range.getUserObject("ITEM");
            }
            if (f != null) {
                valueType = f.getValueType();
            }
        }
        Object cellValue = (var = range.getValue()).isEmpty() ? null : var.getValue();
        BigDecimal v_item = null;
        if (cellValue != null) {
            if (valueType == 3) {
                return cellValue.toString().trim().equals("");
            }
            try {
                v_item = var.isNumeric() ? var.toBigDecimal() : new BigDecimal(cellValue.toString().trim());
            }
            catch (Exception e) {
                logger.error((Object)"isZeroOrNullValue error.", (Throwable)e);
                return true;
            }
        }
        return v_item == null || v_item.compareTo(new BigDecimal("0.00")) == 0;
    }

    private List getIncludeItemSheetList(Set sheetIdSet, Book book, CslReportInfo info) throws BOSException {
        int i;
        int count = book.getSheetCount();
        ArrayList<Sheet> sheetList = new ArrayList<Sheet>(count);
        Sheet sheet = null;
        for (i = 0; i < count; ++i) {
            sheet = book.getSheet(i);
            if (!sheetIdSet.contains(sheet.getID())) continue;
            sheetList.add(sheet);
        }
        if (sheetIdSet.size() > sheetList.size()) {
            sheetList.clear();
            for (i = 0; i < count; ++i) {
                sheetList.add(book.getSheet(i));
            }
            logger.error((Object)("CslReportSave-TemplateSheetCount bigger RptSheetCount->ReportID:[" + info.getId().toString() + "]"));
        }
        return sheetList;
    }

    private void setDefaultSourceCurrency(CslReportInfo info) {
        if (info.getSourceCurrency() == null) {
            info.setSourceCurrency(info.getCurrency());
        }
    }
}

