/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.UnionVersionUtil;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractCslReportServiceFacadeControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.DynItemFillData;
import com.kingdee.eas.fi.gr.cslrpt.app.DynItemFillSqlParse;
import com.kingdee.eas.fi.gr.cslrpt.app.DynaItemDataInterface;
import com.kingdee.eas.fi.gr.cslrpt.app.DynaItemFillDataByAcctCash;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.gr.dynamic.fill.FormulaFilterInfo;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynaRptBasePointIndexHandle;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.RptCheckExpTank;
import com.kingdee.eas.fi.rpt.RptCheckExpression;
import com.kingdee.eas.fi.rpt.RptOperationSchemaComp;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.BoolExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.IntExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.NumberExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Point;
import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CslReportServiceFacadeControllerBean
extends AbstractCslReportServiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.CslReportServiceFacadeControllerBean");
    private static final String[] SORT_ORDER = new String[]{"asc", "desc"};

    @Override
    protected void _generateAdjustRpt(Context ctx, String cslReportId, OrgTreeInfo orgTreeInfo, boolean isCaliAdjust) throws BOSException, EASBizException {
        CslReportInfo info = this._getAfterAdjustReportCslReportInfo(ctx, cslReportId, orgTreeInfo, isCaliAdjust);
        CslReportFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
    }

    @Override
    protected CslReportInfo _getAdjustRpt(Context ctx, String cslReportId, OrgTreeInfo orgTreeInfo) throws BOSException, EASBizException {
        orgTreeInfo.put("isViewReport", (Object)true);
        return this._getAfterAdjustReportCslReportInfo(ctx, cslReportId, orgTreeInfo, false);
    }

    @Override
    protected CslReportInfo _getAfterAdjustReportCslReportInfo(Context ctx, String cslReportId, OrgTreeInfo orgTreeInfo, boolean isCaliAdjust) throws EASBizException, BOSException {
        RptOperationSchemaComp schema;
        String[] links;
        String adjustLink;
        boolean isSupport13Period = CslRptUtil.isSupport13Period(ctx);
        boolean isRefreshAdjustFormula = CslRptUtil.getCslParam(ctx, "KEY_CSLPARAM_REFRESHADJUSTFORMULA");
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)cslReportId));
        CslReportInfo info = CslReportFactory.getLocalInstance(ctx).getCslReportInfo((IObjectPK)pk, this.getSelector());
        info.setId(null);
        if (isCaliAdjust) {
            info.setAdjustStatus(AdjustStatusEnum.CALIADJUSTED);
        } else {
            info.setAdjustStatus(AdjustStatusEnum.ADJUSTED);
        }
        info.setAuditor(null);
        info.setAuditTime(null);
        info.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
        info.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        CslReportInfo sourceRpt = new CslReportInfo();
        sourceRpt.setId(BOSUuid.read((String)cslReportId));
        info.setSourceRpt(sourceRpt);
        int reprotType = info.getSourceType().getValue();
        boolean isDynamic = reprotType == 10;
        isDynamic = isDynamic || reprotType == 11;
        boolean bl = isDynamic = isDynamic || reprotType == 12;
        if (orgTreeInfo == null) {
            throw new BOSException("Data error: not found orgTreeInfo at server side!");
        }
        info.setOrgTree(orgTreeInfo);
        String strOrgNumber = orgTreeInfo.getNumber();
        PeriodCollection fiscalPeriods = null;
        boolean isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod(ctx);
        if (isMergeByFiscalPeriod) {
            fiscalPeriods = FiscalPeriodHelper.getPeriodCollection(ctx, orgTreeInfo);
        }
        RptSheetParamCollection paramCollection = info.getSheetParam();
        HashMap<String, String> commonSheets = new HashMap<String, String>(paramCollection.size());
        for (int i = 0; i < paramCollection.size(); ++i) {
            RptSheetParamInfo paramInfo = paramCollection.get(i);
            if (paramInfo.getReportClass().getValue() != 1) continue;
            commonSheets.put(paramInfo.getSheetID(), paramInfo.getSheetName());
        }
        Book book = null;
        try {
            book = info.getBook();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        boolean isLinkYTDAmount = false;
        boolean isLinkEndBalance = false;
        Map itemNumber_Dc = null;
        if (book.getUserObject("Link_Adjust_DataElement") != null && !StringUtils.isEmpty((String)(adjustLink = (String)book.getUserObject("Link_Adjust_DataElement").getValue())) && (links = adjustLink.trim().split(";")).length >= 2) {
            if (links[0].equals("Y")) {
                isLinkYTDAmount = true;
            }
            if (links[1].equals("Y")) {
                isLinkEndBalance = true;
            }
        }
        if (book.getUserObject("operationSchemas") != null && (schema = (RptOperationSchemaComp)book.getUserObject("operationSchemas").getValue()) != null && schema.getExpTank() != null && schema.getExpTank().getExpressions() != null) {
            RptCheckExpTank expTank = schema.getExpTank();
            Collection expressions = expTank.getExpressions();
            for (RptCheckExpression exp : expressions) {
                if (StringUtils.isEmpty((String)exp.getContent())) continue;
                String expression = exp.getContent().trim();
                StringBuffer content = new StringBuffer();
                try {
                    if (expression == null) continue;
                    String[] exps = expression.split("\\n+");
                    for (int i = 0; i < exps.length; ++i) {
                        expression = exps[i];
                        Expression parsedExpression = ExcelFormulaPaserHelper.parse((String)expression);
                        ExcelFormulaPaserHelper.walk((Expression)parsedExpression, (IExpressionHandler)new IExpressionHandler(){

                            public void handle(Expression expr) {
                                if (expr instanceof FunctionExpr) {
                                    FunctionExpr functionExpr = (FunctionExpr)expr;
                                    if ("csref".equalsIgnoreCase(functionExpr.funcionName)) {
                                        int size = functionExpr.parameters.size();
                                        for (int i = 0; i < size; ++i) {
                                            if (!(functionExpr.parameters.get(i) instanceof BoolExpr)) continue;
                                            BoolExpr bool = new BoolExpr(true);
                                            functionExpr.parameters.set(i, bool);
                                        }
                                    }
                                }
                            }
                        });
                        content.append(parsedExpression.toString()).append("\n");
                    }
                    exp.setContent(content.toString());
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        book.setCalculate(false);
        int sheetCount = book.getSheetCount();
        IFullOrgUnit iCompany = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        FullOrgUnitInfo companyInfo = iCompany.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getOrgUnit().getId()));
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyInfo scurrInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(info.getSourceCurrency().getId()));
        CurrencyInfo currInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(info.getCurrency().getId()));
        DynaEnumRptTypeEnum dynaRptType = info.getTemplate().getDynaRptType();
        for (int i = sheetCount - 1; i > -1; --i) {
            Sheet sheet = book.getSheet(i);
            DynaSumMethodEnum method = DynamicTemplateUtility.getSheetSumMethod((Sheet)sheet);
            if (!(method == null || reprotType != 11 && reprotType != 12 || dynaRptType == DynaEnumRptTypeEnum.FIXED && method == DynaSumMethodEnum.SUM_BY_TEMPLATE || method == DynaSumMethodEnum.SUM_BY_NAME)) {
                throw new ServerException(ServerException.ADJUST_MUST_BE_SUM_BYNAME);
            }
            if (sheet.getID().equals(sheet.getSheetName())) {
                logger.warn((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"168_CslReportServiceFacadeControllerBean", (Locale)ctx.getOriginLocale()));
                if (!commonSheets.containsValue(sheet.getID())) {
                    book.removeSheet(i);
                    continue;
                }
            } else if (!commonSheets.containsKey(sheet.getID())) {
                book.removeSheet(i);
                continue;
            }
            this.insertAdjustNotInReport(ctx, info, sheet);
            Sheet.ICellsIterator cellsIterator = sheet.getCellsIterator(0, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex(), true, true);
            while (cellsIterator.hasNext()) {
                String adjustData;
                Cell cell = cellsIterator.next();
                this.modifyCsrefFormula(cell);
                ItemFormula curFormula = UserObjectHelper.getItemFormula((Cell)cell);
                if (curFormula == null || StringUtils.isEmpty((String)curFormula.getItemNumber()) || StringUtils.isEmpty((String)curFormula.getDataElementNumber())) continue;
                if (isMergeByFiscalPeriod) {
                    FiscalPeriodHelper.getRptYearAndPeriod(fiscalPeriods, curFormula, info.getYear(), info.getPeriod(), info.getPeriodType(), isMergeByFiscalPeriod);
                } else {
                    RPTDate13Util.getRptYearAndPeriod(curFormula, info.getYear(), info.getPeriod(), info.getPeriodType(), isSupport13Period);
                }
                StringBuffer sbFormula = new StringBuffer();
                boolean need = true;
                if (cell.hasFormula()) {
                    if (!isRefreshAdjustFormula) {
                        String formula = cell.getFormula().toUpperCase();
                        need = this.needToGeneralFormula(need, formula);
                        if (formula.startsWith("=ACCTITEM") || cell.getFormula().startsWith("=DYITEM")) {
                            if (formula.startsWith("=ACCTITEM")) {
                                try {
                                    formula = cell.getFormula();
                                    Expression stmt = ExcelFormulaPaserHelper.parse((String)formula.substring(1, formula.length()));
                                    this.modifyAcctItem2AdjustedState(stmt);
                                    cell.setFormula("=" + stmt.toString());
                                }
                                catch (Exception e) {
                                    logger.error((Object)e);
                                }
                            }
                            need = false;
                        }
                        if (formula.startsWith("=CSREF")) {
                            cell.setFormula(cell.getFormula().replaceAll("(?i)FALSE", "TRUE"));
                        }
                    } else {
                        need = CslRptUtil.isRefreshFormula(cell.getFormula());
                    }
                }
                if (!need) continue;
                if (isDynamic) {
                    boolean overFormula;
                    boolean bl2 = overFormula = !StringUtils.isEmpty((String)curFormula.getDItemNumber());
                    if (cell.hasFormula()) {
                        cell.setFormula(null);
                    }
                    if (!overFormula) continue;
                    sbFormula.append("=DyItem(");
                    sbFormula.append("\"").append(strOrgNumber).append("\"");
                    sbFormula.append(",\"").append(companyInfo.getNumber()).append("\"");
                    sbFormula.append(",\"").append(scurrInfo.getNumber()).append("\"");
                    sbFormula.append(",\"").append(currInfo.getNumber()).append("\"");
                    sbFormula.append(",\"").append(curFormula.getItemNumber()).append("\"");
                    sbFormula.append(",\"").append(curFormula.getDItemNumber()).append("\"");
                    sbFormula.append(",\"").append(info.getPeriodType().getName()).append("\"");
                    sbFormula.append(",").append(curFormula.getYearOffSet());
                    sbFormula.append(",").append(curFormula.getPeriodOffSet());
                    sbFormula.append(",").append(curFormula.getPeriodOffSet());
                    sbFormula.append(",\"").append(info.getSourceType().getName()).append("\"");
                    sbFormula.append(",\"").append(curFormula.getDataElementNumber()).append("\"");
                    sbFormula.append(",\"").append(ValueTypeEnum.getEnum(curFormula.getValueType()).getName()).append("\"");
                    sbFormula.append(",true");
                    sbFormula.append(",false");
                    if (orgTreeInfo.get("isViewReport") != null || orgTreeInfo.get("isFromAdjustCompany") != null) {
                        sbFormula.append(",\"");
                        sbFormula.append("\",\"");
                        sbFormula.append("\",true)");
                    } else {
                        sbFormula.append(")");
                    }
                    Range range = sheet.getRange(cell);
                    range.setIgnoreProtected(true);
                    cell.setValue(Variant.nullVariant);
                    cell.setFormula(sbFormula.toString());
                    cell.setUserObject("0", null);
                    cell.setUserObject("1", null);
                    range.setIgnoreProtected(false);
                    continue;
                }
                if (this.isTotalItem(ctx, curFormula.getItemNumber())) continue;
                if (cell.hasFormula()) {
                    cell.setFormula(null);
                }
                sbFormula.append("=AcctItem(");
                sbFormula.append("\"" + strOrgNumber + "\",");
                sbFormula.append("\"" + companyInfo.getNumber() + "\",");
                sbFormula.append("\"" + scurrInfo.getNumber() + "\",");
                sbFormula.append("\"" + currInfo.getNumber() + "\",");
                sbFormula.append("\"" + curFormula.getItemNumber() + "\",");
                sbFormula.append("\"" + curFormula.getItemNumber() + "\",");
                sbFormula.append("\"" + info.getPeriodType().getName() + "\",");
                sbFormula.append(curFormula.getYearOffSet() + ",");
                sbFormula.append(curFormula.getPeriodOffSet() + ",");
                sbFormula.append(curFormula.getPeriodOffSet() + ",");
                sbFormula.append("\"" + info.getSourceType().getName() + "\",");
                sbFormula.append("\"" + curFormula.getDataElementNumber() + "\",");
                sbFormula.append("\"" + ValueTypeEnum.getEnum(curFormula.getValueType()).getName() + "\",");
                if (curFormula.getDataElementNumber().equals("YTDAMOUNT") && isLinkYTDAmount || curFormula.getDataElementNumber().equals("ENDBALANCE") && isLinkEndBalance) {
                    sbFormula.append("false,");
                } else {
                    sbFormula.append("true,");
                }
                if (orgTreeInfo.get("isViewReport") != null || orgTreeInfo.get("isFromAdjustCompany") != null) {
                    sbFormula.append("true,");
                } else {
                    sbFormula.append("false,");
                }
                sbFormula.append("\"").append(info.getDataCollectNumber()).append("\",");
                sbFormula.append((isCaliAdjust ? "true" : "false") + ")");
                if (curFormula.getDataElementNumber().equals("YTDAMOUNT") && isLinkYTDAmount) {
                    adjustData = this.getAdjustData(ctx, itemNumber_Dc, cslReportId, curFormula, info, "AMOUNT");
                    if (!StringUtils.isEmpty((String)adjustData)) {
                        sbFormula.append(adjustData);
                    }
                } else if (curFormula.getDataElementNumber().equals("ENDBALANCE") && isLinkEndBalance && !StringUtils.isEmpty((String)(adjustData = this.getAdjustData(ctx, itemNumber_Dc, cslReportId, curFormula, info, "ENDBALANCE")))) {
                    sbFormula.append(adjustData);
                }
                Range range = sheet.getRange(cell);
                range.setIgnoreProtected(true);
                range.setValue(Variant.nullVariant);
                range.setFormula(sbFormula.toString());
                range.setUserObject("0", null);
                range.setUserObject("1", null);
                range.setIgnoreProtected(false);
            }
            StyleAttributes protectStyle = Styles.getEmptySA();
            protectStyle.setLocked(true);
            Range r = sheet.getRange(0, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex());
            r.getStyle(Styles.getEmptySA(), protectStyle);
            r.setCellLocked(true);
            sheet.getSheetOption().getProtection(true).start("auto^Protection");
        }
        try {
            info.setBook(book);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        return info;
    }

    private boolean needToGeneralFormula(boolean need, String formula) {
        try {
            Expression expression = ExcelFormulaPaserHelper.parse((String)formula);
            if (expression instanceof IntExpr || expression instanceof NumberExpr) {
                need = true;
            } else if (expression instanceof BinaryOperationExpr) {
                Expression left = ((BinaryOperationExpr)expression).left;
                String leftFormula = left.toString();
                boolean leftB = this.needToGeneralFormula(need, leftFormula);
                Expression right = ((BinaryOperationExpr)expression).right;
                String rightFormula = right.toString();
                boolean rightB = this.needToGeneralFormula(need, rightFormula);
                need = leftB && rightB;
            } else if (expression instanceof UnaryOperationExpr) {
                Expression operand = ((UnaryOperationExpr)expression).operand;
                String operandFormula = operand.toString();
                need = this.needToGeneralFormula(need, operandFormula);
            } else if (expression instanceof FunctionExpr) {
                String expr = expression.toString();
                need = CslRptUtil.isDebarFormula(expr);
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
        return need;
    }

    private Expression modifyAcctItem2AdjustedState(Expression stmt) {
        if (stmt instanceof FunctionExpr) {
            this.doChangeAdjustedState(stmt);
        } else if (stmt instanceof BinaryOperationExpr) {
            Expression expr = this.modifyAcctItem2AdjustedState(((BinaryOperationExpr)stmt).left);
            if (expr == null) {
                return null;
            }
            ((BinaryOperationExpr)stmt).left = expr;
            expr = this.modifyAcctItem2AdjustedState(((BinaryOperationExpr)stmt).right);
            if (expr == null) {
                return null;
            }
            ((BinaryOperationExpr)stmt).right = expr;
        } else if (stmt instanceof UnaryOperationExpr) {
            Expression expr = this.modifyAcctItem2AdjustedState(((UnaryOperationExpr)stmt).operand);
            if (expr == null) {
                return null;
            }
            ((UnaryOperationExpr)stmt).operand = expr;
        }
        return stmt;
    }

    private Expression doChangeAdjustedState(Expression stmt) {
        FunctionExpr function = (FunctionExpr)stmt;
        String funName = function.funcionName;
        if (!funName.equalsIgnoreCase("AcctItem")) {
            return stmt;
        }
        if (function.parameters.size() > 13) {
            function.parameters.set(13, new BoolExpr(true));
        }
        return stmt;
    }

    /*
     * Unable to fully structure code
     */
    public void insertAdjustNotInReport(Context ctx, CslReportInfo info, Sheet sheet) throws BOSException, EASBizException {
        if (!CslRptUtil.isDynamicReport(info)) {
            return;
        }
        basePointList = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
        indexHandle = null;
        boforeSumFormulaCount = 0;
        for (j = basePointList.size() - 1; j >= 0; --j) {
            basePoint = (Point)basePointList.get(j);
            rptParm = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)basePoint);
            if (rptParm == null) continue;
            indexHandle = new DynaRptBasePointIndexHandle(rptParm, basePoint, sheet, true, true);
            boforeSumFormulaCount = indexHandle.getBeforeDynaItemSumRangeCount();
            if (!rptParm.isGrade()) {
                counter = 0;
                if (rptParm.getSpreadStyle() == 0) {
                    rowmax = basePoint.y + boforeSumFormulaCount + rptParm.getDefaultCounter();
                    for (rowindex = basePoint.y + boforeSumFormulaCount + 1; rowindex <= rowmax; ++rowindex) {
                        headCell = sheet.getCell(rowindex, basePoint.x + 1, true);
                        curFormula = UserObjectHelper.getItemFormula((Cell)headCell);
                        if (curFormula == null) continue;
                        ++counter;
                    }
                } else if (rptParm.getSpreadStyle() == 1) {
                    colmax = basePoint.x + boforeSumFormulaCount + rptParm.getDefaultCounter();
                    for (colindex = basePoint.x + boforeSumFormulaCount + 1; colindex <= colmax; ++colindex) {
                        headCell = sheet.getCell(basePoint.y + 1, colindex, true);
                        curFormula = UserObjectHelper.getItemFormula((Cell)headCell);
                        if (curFormula == null) continue;
                        ++counter;
                    }
                }
                if (counter > 0) {
                    rptParm.setDefaultCounter(counter);
                }
            }
            recordCount = rptParm.getDefaultCounter();
            companyCells = null;
            headCells = null;
            v0 = isVertical = rptParm.getSpreadStyle() == 0;
            if (isVertical) {
                headCells = sheet.getCellsIterator(basePoint.y, basePoint.x + 1, basePoint.y, sheet.getMaxColIndex(), false, true);
                companyCells = sheet.getCellsIterator(basePoint.y + 1 + boforeSumFormulaCount, basePoint.x + 1, basePoint.y + boforeSumFormulaCount + recordCount, basePoint.x + 1, false, true);
            } else {
                headCells = sheet.getCellsIterator(basePoint.y + 1, basePoint.x, sheet.getMaxRowIndex(), basePoint.x, false, true);
                companyCells = sheet.getCellsIterator(basePoint.y + 1, basePoint.x + 1 + boforeSumFormulaCount, basePoint.y + 1, basePoint.x + boforeSumFormulaCount + recordCount, false, true);
            }
            companyNotInSql = new StringBuffer();
            isFirstCompany = true;
            curLastLine = startRow = (isVertical != false ? basePoint.y : basePoint.x) + boforeSumFormulaCount;
            while (companyCells.hasNext()) {
                cell = companyCells.next();
                itemFormula = UserObjectHelper.getItemFormula((Cell)cell);
                if (itemFormula == null) continue;
                if ((isVertical != false ? cell.getRow() : cell.getCol()) > curLastLine) {
                    v1 = curLastLine = isVertical != false ? cell.getRow() : cell.getCol();
                }
                if (isFirstCompany) {
                    companyNotInSql.append("'").append(itemFormula.getDItemNumber()).append("'");
                    isFirstCompany = false;
                    continue;
                }
                companyNotInSql.append(", '").append(itemFormula.getDItemNumber()).append("'");
            }
            rptItemAndDataElementSql = new StringBuffer();
            isFirstHeadCell = true;
            while (headCells.hasNext() && (itemFormula = UserObjectHelper.getItemFormula((Cell)(cell = headCells.next()))) != null) {
                if (isFirstHeadCell) {
                    isFirstHeadCell = false;
                } else {
                    rptItemAndDataElementSql.append(" or ");
                }
                rptItemAndDataElementSql.append(" ( i.fnumber = '").append(itemFormula.getItemNumber());
                rptItemAndDataElementSql.append("' and el.fnumber = '").append(itemFormula.getDataElementNumber());
                rptItemAndDataElementSql.append("' ) \r\n");
            }
            if (rptItemAndDataElementSql.length() <= 0) continue;
            sql = new StringBuffer();
            sql.append(" select distinct d.fkeylongnumber, d.fkeyname from T_CSL_Adjust a \t\r\n");
            sql.append(" INNER JOIN t_Csl_Adjustentry e on e.fadjustid = a.fid\t\t\t\t\r\n");
            sql.append(" inner join T_CSL_AdjustDynamicItem d on d.fadjustentryid = e.fid\t\r\n");
            sql.append(" inner join t_csl_rptitem i on i.fid = d.frptitemid\t\t\t\t\r\n");
            sql.append(" inner join t_csl_dataelement el on el.finterseq = e.fdataelement\t\r\n");
            sql.append(" where a.FOrgBoundID = '").append(info.getOrgTree().getId().toString()).append("'");
            sql.append(" and a.fperiodtype = ").append(info.getPeriodType().getValue()).append(" \r\n");
            sql.append(" and a.fyear = ").append(info.getYear());
            sql.append(" and a.fperiod = ").append(info.getPeriod());
            sql.append(" and a.fdatacollectnumber = '").append(info.getDataCollectNumber()).append("' \r\n");
            sql.append(" and a.forgunit = '").append(info.getOrgUnit().getId().toString()).append("'\t\r\n");
            sql.append(" and a.FCheckedStatus = 2 \r\n");
            if (companyNotInSql != null && companyNotInSql.length() > 0) {
                sql.append(" and d.fkeylongnumber not in( ").append(companyNotInSql).append(" ) \r\n");
            }
            sql.append(" and ( ").append(rptItemAndDataElementSql).append(" ) \r\n ");
            sql.append(" and a.fcurrencyId='").append(info.getCurrency().getId().toString()).append("' \r\n");
            rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            newLineCounter = 0;
            lastLine = -1;
lbl111:
            // 3 sources

            try {
                while (rows.next()) {
                    block27: {
                        space = "";
                        levelTotal = rows.getString("fkeylongnumber").split("!").length;
                        for (level = 1; level < levelTotal; ++level) {
                            space = space + "  ";
                        }
                        if (rptParm.isGrade()) {
                            if (rptParm.getDynaItemSource() != 1) continue;
                            continue;
                        }
                        ++newLineCounter;
                        if (rptParm.getSpreadStyle() != 0) break block27;
                        lastLine = curLastLine + newLineCounter;
                        if (!this.isNullRowOrCol(sheet.getCellsIterator(lastLine, 0, lastLine, sheet.getMaxColIndex(), false, true))) {
                            sheet.getRowRange(lastLine, lastLine).insert();
                        }
                        sheet.getRange(lastLine, basePoint.x).setValue(new Variant((Object)(space + rows.getString("fkeyname"))));
                        for (col = basePoint.x + 1; col <= sheet.getMaxColIndex(); ++col) {
                            headCell = sheet.getCell(basePoint.y, col, false);
                            curFormula = UserObjectHelper.getItemFormula((Cell)headCell);
                            if (curFormula == null) continue;
                            newFormula = (ItemFormula)curFormula.clone();
                            newFormula.setDItemNumber(rows.getString("fkeylongnumber"));
                            ditem = newFormula.getExt("13");
                            strLst = ditem.split(",");
                            strLst[1] = rows.getString("fkeylongnumber");
                            ditem = strLst[0] + ",\"" + strLst[1] + "\"," + strLst[2] + "," + strLst[3] + "," + strLst[4] + "," + strLst[5];
                            newFormula.putExt("13", ditem);
                            cell = UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(lastLine, col));
                            UserObjectHelper.setItemFormula((Range)cell, (ItemFormula)newFormula);
                        }
                        ** GOTO lbl111
                    }
                    if (rptParm.getSpreadStyle() != 1) continue;
                    lastLine = curLastLine + newLineCounter;
                    if (!this.isNullRowOrCol(sheet.getCellsIterator(0, lastLine, sheet.getMaxRowIndex(), lastLine, false, true))) {
                        sheet.getColRange(lastLine, lastLine).insert();
                    }
                    sheet.getRange(basePoint.y, lastLine).setValue(new Variant((Object)(space + rows.getString("fkeyname"))));
                    for (row = basePoint.y + 1; row <= sheet.getMaxRowIndex(); ++row) {
                        headCell = sheet.getCell(row, basePoint.x, false);
                        curFormula = UserObjectHelper.getItemFormula((Cell)headCell);
                        if (curFormula == null) continue;
                        newFormula = (ItemFormula)curFormula.clone();
                        newFormula.setDItemNumber(rows.getString("fkeylongnumber"));
                        ditem = newFormula.getExt("13");
                        strLst = ditem.split(",");
                        strLst[1] = rows.getString("fkeylongnumber");
                        ditem = strLst[0] + ",\"" + strLst[1] + "\"," + strLst[2] + "," + strLst[3] + "," + strLst[4] + "," + strLst[5];
                        newFormula.putExt("13", ditem);
                        cell = UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(row, lastLine));
                        UserObjectHelper.setItemFormula((Range)cell, (ItemFormula)newFormula);
                    }
                    ** GOTO lbl111
                }
            }
            catch (SQLException e) {
                CslReportServiceFacadeControllerBean.logger.error((Object)"insertAdjustNotInReport_SQLException", (Throwable)e);
            }
            if (lastLine <= 0 || (size = lastLine - startRow) < (srcRow = rptParm.getDefaultCounter())) continue;
            DynamicTemplateUtility.autoAdjustSum((Sheet)sheet, (Point)basePoint, (int)size, (boolean)false);
            rptParm.setDefaultCounter(size);
            DynamicTemplateUtility.saveParametersToCell((Range)sheet.getRange(basePoint.y, basePoint.x), (DynaParameters)rptParm);
        }
    }

    private void modifyCsrefFormula(Cell range) {
        String formula = range.getFormula();
        if (formula.toUpperCase(Locale.ENGLISH).startsWith("=CSREF")) {
            String pattern = "CSREF\\([^\\s^\\)]{1,}\\)";
            Pattern patt = Pattern.compile(pattern, 2);
            Matcher matcher = patt.matcher(formula);
            while (matcher.find()) {
                String group1;
                int index;
                String group = matcher.group();
                String[] strs = group.split(",");
                if (strs.length == 8) {
                    index = group.lastIndexOf(",");
                    group1 = group.substring(0, index) + ",\"\",\"\",TRUE)";
                    group = group.replaceAll("\\(", "\\\\(");
                    group = group.replaceAll("\\)", "\\\\)");
                    formula = formula.replaceAll("(?i)" + group, group1);
                    continue;
                }
                if (strs.length == 10) {
                    index = group.lastIndexOf(",");
                    group1 = group.substring(0, index) + ",TRUE)";
                    group = group.replaceAll("\\(", "\\\\(");
                    group = group.replaceAll("\\)", "\\\\)");
                    formula = formula.replaceAll("(?i)" + group, group1);
                    continue;
                }
                if (strs.length != 11) continue;
                int lastIndex = group.lastIndexOf(",");
                int preIndex = group.substring(0, lastIndex).lastIndexOf(",");
                group1 = group.substring(0, preIndex) + ",TRUE";
                String group2 = group.substring(lastIndex, group.length());
                formula = "=" + group1 + group2;
            }
            range.setFormula(formula);
        }
    }

    @Override
    protected void _generateAdjustRpt(Context ctx, List cslReportIds, OrgTreeInfo orgTreeInfo, boolean isCaliAdjust) throws BOSException, EASBizException {
        for (String cslReportId : cslReportIds) {
            this._generateAdjustRpt(ctx, cslReportId, orgTreeInfo, isCaliAdjust);
        }
    }

    private Map getClient2DataTableFieldMap(Context ctx) {
        String lang = ctx.getLocale().getLanguage();
        HashMap<String, String> DataField_ObjectFied_Map = new HashMap<String, String>(8);
        DataField_ObjectFied_Map.put("orgUnit.number", "org.FNumber");
        DataField_ObjectFied_Map.put("company.name", "org.FName_" + lang);
        DataField_ObjectFied_Map.put("currency.name", "t4.FName_" + lang);
        DataField_ObjectFied_Map.put("sourceCurrency", "t7.FName_" + lang);
        DataField_ObjectFied_Map.put("template.name", "t6.FName");
        DataField_ObjectFied_Map.put("template.number", "t6.FNumber");
        return DataField_ObjectFied_Map;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected CslReportCollection _getAdjustSrcReports(Context ctx, Map cslParams, String companyId, boolean isCaliAdjust, Map sortMap, String dialogFilterString, String dialogSortString) throws BOSException {
        CslReportCollection collection = null;
        ArrayList<Object> params = new ArrayList<Object>(5);
        params.add(cslParams.get("KEY_CUR_ORGBOUND_ID"));
        params.add(cslParams.get("KEY_CUR_ORGBOUND_ID"));
        params.add(cslParams.get("Year"));
        params.add(cslParams.get("Period"));
        params.add(cslParams.get("PeriodType"));
        params.add(new Integer(0));
        params.add(new Integer(3));
        IRowSet rs = null;
        CslReportInfo info = null;
        String lang = ctx.getLocale().getLanguage();
        try {
            StringBuffer querySql = new StringBuffer();
            querySql.append("SELECT t1.fid,t6.FNumber,t1.fname,t1.fperiodType,t1.fyear,t1.fperiod").append("\r\n");
            querySql.append(",t1.FSourceCurrencyID,t7.FName_").append(lang).append(" as FSourceCurrencyName");
            querySql.append(",t1.FCurrencyID,t4.FName_").append(lang).append(" as FCurrencyName");
            querySql.append(",t1.FSourceType,");
            querySql.append("max(t8.Fid)");
            querySql.append(" as hasAdjustRpt , org.FID as orgfid, org.FName_l2 as orgName2, org.FName_l3 as orgName3, org.FName_l1  as orgName1 ").append("\r\n");
            querySql.append("FROM T_CSL_CslReport t1").append("\r\n");
            querySql.append("inner join T_Csl_rptReceived t2").append("\r\n");
            querySql.append("on t1.FId = t2.FReportId").append("\r\n");
            querySql.append("inner join t_rpt_rptsheetpara t3").append("\r\n");
            querySql.append("on t1.fid=t3.freportid and t3.freportclass=1").append("\r\n");
            querySql.append("inner join t_bd_currency t4").append("\r\n");
            querySql.append("on  t1.FCurrencyID=t4.fid").append("\r\n");
            querySql.append("inner join t_bd_currency t7").append("\r\n");
            querySql.append("on  t1.FSourceCurrencyID=t7.fid").append("\r\n");
            querySql.append("left join T_CSL_CslReport t5").append("\r\n");
            querySql.append("on t5.FSourceRptID = t1.FID").append("\r\n");
            if (isCaliAdjust) {
                querySql.append("and t5.FAdjustStatus = ").append(10).append("\r\n");
            } else {
                querySql.append("and t5.FAdjustStatus = ").append(1).append("\r\n");
            }
            querySql.append("and t5.FIsSaveAs = ").append(0).append("\r\n");
            querySql.append("  left join T_Csl_rptReceived t8 on t5.FId = t8.FReportId and t5.forgtreeid = t8.forgtreeid and t8.FOrgTreeId = ? \r\n");
            querySql.append("inner join t_rpt_template t6").append("\r\n");
            querySql.append("on  t6.FID=t1.ftemplateid").append("\r\n");
            querySql.append("inner join T_ORG_BaseUnit org ").append("\r\n");
            querySql.append("on  org.FID=t1.FOrgUnitID ").append("\r\n");
            querySql.append("WHERE t2.FOrgTreeId = ? ").append("\r\n");
            querySql.append("AND t1.fyear = ?").append("\r\n");
            querySql.append("AND t1.fperiod = ?").append("\r\n");
            querySql.append("AND t1.fperiodType =? ").append("\r\n");
            querySql.append("AND t1.fadjustStatus = ?").append("\r\n");
            querySql.append("AND t1.fcommittedStatus = ?").append("\r\n");
            querySql.append("AND t1.FSourceType in(").append(1);
            querySql.append(",").append(2);
            querySql.append(",").append(3);
            if (isCaliAdjust) {
                querySql.append(") ").append("\r\n");
            } else {
                querySql.append(",").append(10);
                querySql.append(",").append(11);
                querySql.append(",").append(12).append(") ").append("\r\n");
            }
            if (!StringUtils.isEmpty((String)companyId)) {
                querySql.append("AND t1.FOrgUnitID = ?").append("\r\n");
                params.add(companyId);
            } else {
                List companys = (List)cslParams.get("COMPANY_IDS");
                if (companys != null && companys.size() > 0) {
                    querySql.append("AND t1.FOrgUnitID in (").append("\r\n");
                    for (int i = 0; i < companys.size(); ++i) {
                        if (i != 0) {
                            querySql.append(',');
                        }
                        querySql.append('?');
                        params.add(companys.get(i));
                    }
                    querySql.append(')');
                }
            }
            String orgGroupID = (String)cslParams.get("KEY_CUR_ORGBOUNDGROUP_ID");
            String idFilter = CslRptUtil.getDataPermissionIDSQL(ctx, (IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), (IObjectPK)new ObjectUuidPK(orgGroupID), BOSObjectType.create((String)"B712EA2C"), "csl_indirpt_view");
            if (!StringUtils.isEmpty((String)idFilter)) {
                querySql.append(" AND t1.FID in ( ").append(idFilter).append(" ) ");
            }
            Map DataField_ObjectFied_Map = this.getClient2DataTableFieldMap(ctx);
            querySql.append(this.getFilterString(dialogFilterString, DataField_ObjectFied_Map));
            querySql.append(" and t1.fdataCollectNumber=? ");
            params.add(cslParams.get("dataCollectNumber"));
            querySql.append(" group by t1.fid,t6.FTemplateType,t6.FNumber,t6.FName").append("\r\n");
            querySql.append(",t1.fname,t1.fperiodType,t1.fyear,t1.fperiod").append("\r\n");
            querySql.append(",t1.FSourceCurrencyID,t7.FName_").append(lang);
            querySql.append(",t1.FCurrencyID,t4.FName_").append(lang).append(",t1.FSourceType,org.FID, org.FNumber,org.FName_l2, org.FName_l3, org.FName_l1");
            String orderByString = this.getSorterString(dialogSortString, DataField_ObjectFied_Map);
            if (!"".equals(orderByString)) {
                querySql.append(orderByString);
            } else if (sortMap != null && sortMap.size() > 0) {
                String first = (String)sortMap.get(new Integer(-1));
                sortMap.remove(new Integer(-1));
                int firstOrderIndex = (Integer)sortMap.get(first);
                sortMap.remove(first);
                HashMap<String, String> sortFiledMap = new HashMap<String, String>();
                sortFiledMap.put("id", "t1.fid");
                sortFiledMap.put("templateNumber", "t6.FNumber");
                sortFiledMap.put("name", "t1.fname");
                sortFiledMap.put("periodType", "t1.fperiodType");
                sortFiledMap.put("year", "t1.fyear");
                sortFiledMap.put("period", "t1.fperiod");
                sortFiledMap.put("rptSrcType", "t1.FSourceType");
                sortFiledMap.put("sourceCurrency", "t7.FName_" + lang);
                sortFiledMap.put("currency", "t4.FName_" + lang);
                querySql.append(" order by ").append(sortFiledMap.get(first)).append(" ").append(SORT_ORDER[firstOrderIndex]);
                Set keys = sortMap.keySet();
                for (Object column : keys) {
                    int sortDirIndex = (Integer)sortMap.get(column);
                    querySql.append(" , ").append(sortFiledMap.get(column)).append(" ").append(SORT_ORDER[sortDirIndex]);
                }
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])params.toArray());
            collection = new CslReportCollection();
            while (rs.next()) {
                info = new CslReportInfo();
                TemplateInfo template = new TemplateInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                template.setNumber(rs.getString("Fnumber"));
                info.setName(rs.getString("Fname"));
                info.setPeriodType(RptPeriodTypeEnum.getEnum((int)rs.getInt("fperiodType")));
                info.setYear(rs.getInt("fyear"));
                info.setPeriod(rs.getShort("fperiod"));
                CurrencyInfo currencyInfo = new CurrencyInfo();
                currencyInfo.put("id", (Object)rs.getString("FCurrencyID"));
                currencyInfo.put("name", (Object)rs.getString("FCurrencyName"));
                info.setCurrency(currencyInfo);
                CurrencyInfo sourceCurrencyInfo = new CurrencyInfo();
                sourceCurrencyInfo.put("id", (Object)rs.getString("FSourceCurrencyID"));
                sourceCurrencyInfo.put("name", (Object)rs.getString("FSourceCurrencyName"));
                info.setSourceCurrency(sourceCurrencyInfo);
                info.setSourceType(RptSrcTypeEnum.getEnum((int)rs.getInt("FSourceType")));
                info.setBoolean("hasAdjustRpt", rs.getString("hasAdjustRpt") != null);
                info.setTemplate(template);
                OrgUnitInfo org = new OrgUnitInfo();
                org.setId(BOSUuid.read((String)rs.getString("orgfid")));
                org.setName(rs.getString("orgName1"), new Locale("L1"));
                org.setName(rs.getString("orgName2"), new Locale("L2"));
                org.setName(rs.getString("orgName3"), new Locale("L3"));
                info.setOrgUnit(org);
                collection.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (EASBizException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return collection;
    }

    private String getFilterString(String filterString, Map DataField_ObjectFied_Map) {
        if (filterString == null || filterString.trim().length() == 0) {
            return "";
        }
        String result = filterString;
        Set keySet = DataField_ObjectFied_Map.keySet();
        for (String key : keySet) {
            result = result.replaceAll(key, (String)DataField_ObjectFied_Map.get(key));
        }
        return " And " + result;
    }

    private String getSorterString(String sorterString, Map DataField_ObjectFied_Map) {
        if (sorterString == null || sorterString.trim().length() == 0) {
            return "";
        }
        String result = sorterString;
        Set keySet = DataField_ObjectFied_Map.keySet();
        for (String key : keySet) {
            result = result.replaceAll(key, (String)DataField_ObjectFied_Map.get(key));
        }
        return " order by " + result;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("company.name");
        selector.add("currency.name");
        selector.add("currency.number");
        selector.add("orgTree.name");
        selector.add("orgUnit.name");
        selector.add("sheetParam.*");
        selector.add("template.dynaRptType");
        return selector;
    }

    private boolean isTotalItem(Context ctx, String strItemNumber) throws BOSException, EASBizException {
        IRPTItem rptItem = RPTItemFactory.getLocalInstance(ctx);
        return rptItem.exists("where isSumItem = 1 and number = '" + strItemNumber + "' and control<>38");
    }

    private String getAdjustData(Context ctx, Map itemNumber_Dc, String cslReportId, ItemFormula curFormula, CslReportInfo info, String linkItemNumber) throws BOSException, EASBizException {
        StringBuffer sbFormula = new StringBuffer();
        String dc = this.getItemDC(ctx, itemNumber_Dc, curFormula.getItemNumber(), cslReportId);
        if (!StringUtils.isEmpty((String)dc)) {
            if (dc.trim().equals("1")) {
                sbFormula.append("+AdjustData(");
                sbFormula.append("\"\",");
                sbFormula.append("\"\",");
                sbFormula.append("\"\",");
                sbFormula.append("\"\",");
                sbFormula.append("\"" + curFormula.getItemNumber() + "\",");
                sbFormula.append("\"" + curFormula.getItemNumber() + "\",");
                sbFormula.append("\"" + info.getPeriodType().getName() + "\",");
                sbFormula.append(curFormula.getYearOffSet() + ",");
                sbFormula.append("1,");
                sbFormula.append(curFormula.getPeriodOffSet() + ",");
                sbFormula.append("\"" + info.getSourceType().getName() + "\",");
                sbFormula.append("\"" + linkItemNumber + "\",");
                sbFormula.append("\"" + ValueTypeEnum.getEnum(curFormula.getValueType()).getName() + "\",");
                sbFormula.append("\"DEBIT\",");
                sbFormula.append("false,");
                sbFormula.append("\"\")");
                sbFormula.append("-AdjustData(");
                sbFormula.append("\"\",");
                sbFormula.append("\"\",");
                sbFormula.append("\"\",");
                sbFormula.append("\"\",");
                sbFormula.append("\"" + curFormula.getItemNumber() + "\",");
                sbFormula.append("\"" + curFormula.getItemNumber() + "\",");
                sbFormula.append("\"" + info.getPeriodType().getName() + "\",");
                sbFormula.append(curFormula.getYearOffSet() + ",");
                sbFormula.append("1,");
                sbFormula.append(curFormula.getPeriodOffSet() + ",");
                sbFormula.append("\"" + info.getSourceType().getName() + "\",");
                sbFormula.append("\"" + linkItemNumber + "\",");
                sbFormula.append("\"" + ValueTypeEnum.getEnum(curFormula.getValueType()).getName() + "\",");
                sbFormula.append("\"CREDIT\",");
                sbFormula.append("false,");
                sbFormula.append("\"\")");
            } else {
                sbFormula.append("+AdjustData(");
                sbFormula.append("\"\",");
                sbFormula.append("\"\",");
                sbFormula.append("\"\",");
                sbFormula.append("\"\",");
                sbFormula.append("\"" + curFormula.getItemNumber() + "\",");
                sbFormula.append("\"" + curFormula.getItemNumber() + "\",");
                sbFormula.append("\"" + info.getPeriodType().getName() + "\",");
                sbFormula.append(curFormula.getYearOffSet() + ",");
                sbFormula.append("1,");
                sbFormula.append(curFormula.getPeriodOffSet() + ",");
                sbFormula.append("\"" + info.getSourceType().getName() + "\",");
                sbFormula.append("\"" + linkItemNumber + "\",");
                sbFormula.append("\"" + ValueTypeEnum.getEnum(curFormula.getValueType()).getName() + "\",");
                sbFormula.append("\"CREDIT\",");
                sbFormula.append("false,");
                sbFormula.append("\"\")");
                sbFormula.append("-AdjustData(");
                sbFormula.append("\"\",");
                sbFormula.append("\"\",");
                sbFormula.append("\"\",");
                sbFormula.append("\"\",");
                sbFormula.append("\"" + curFormula.getItemNumber() + "\",");
                sbFormula.append("\"" + curFormula.getItemNumber() + "\",");
                sbFormula.append("\"" + info.getPeriodType().getName() + "\",");
                sbFormula.append(curFormula.getYearOffSet() + ",");
                sbFormula.append("1,");
                sbFormula.append(curFormula.getPeriodOffSet() + ",");
                sbFormula.append("\"" + info.getSourceType().getName() + "\",");
                sbFormula.append("\"" + linkItemNumber + "\",");
                sbFormula.append("\"" + ValueTypeEnum.getEnum(curFormula.getValueType()).getName() + "\",");
                sbFormula.append("\"DEBIT\",");
                sbFormula.append("false,");
                sbFormula.append("\"\")");
            }
        }
        return sbFormula.toString();
    }

    private String getItemDC(Context ctx, Map ItemNumber_DC, String ItemNumber, String reportid) throws BOSException, EASBizException {
        if (ItemNumber_DC == null || ItemNumber_DC.size() <= 0) {
            ItemNumber_DC = this.getItemNumber_DC(ctx, reportid);
        }
        if (ItemNumber_DC.containsKey(ItemNumber)) {
            return (String)ItemNumber_DC.get(ItemNumber);
        }
        RPTItemInfo itemInfo = RPTItemFactory.getLocalInstance(ctx).getRPTItemInfo("select number,dc where number='" + ItemNumber + "'");
        if (itemInfo != null) {
            return itemInfo.getString("dc");
        }
        return null;
    }

    private Map getItemNumber_DC(Context ctx, String reportid) throws BOSException, EASBizException {
        HashMap<String, String> ItemNumber_DC = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select fnumber,fdc from t_csl_rptitem item where fnumber in(");
        sql.append("select distinct fitemnumber from t_csl_templetitemlist itemList ");
        sql.append("INNER JOIN t_csl_cslreport report on report.ftemplateid=itemList.ftemplateid and  report.fid='").append(reportid).append("'");
        sql.append("INNER JOIN t_csl_dataelement dataElement on dataElement.finterseq=itemList.fdataelement ");
        sql.append(" and dataElement.fnumber in('").append("YTDAMOUNT").append("','").append("ENDBALANCE").append("')");
        sql.append(")");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rows.next()) {
                ItemNumber_DC.put(rows.getString("fnumber"), rows.getString("fdc"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ItemNumber_DC;
    }

    @Override
    protected Map _getDynItemData(Context ctx, Map paramMap) throws BOSException, EASBizException {
        if (paramMap.get("isMulti") != null && ((Boolean)paramMap.get("isMulti")).booleanValue()) {
            return this.getMultiDynaItemData(ctx, paramMap);
        }
        Object isInterAndExch = paramMap.get("isInterAndExch");
        if (isInterAndExch != null && ((Boolean)isInterAndExch).booleanValue()) {
            return this.getInterAndExchDynaCompany(ctx, paramMap);
        }
        return this.getSingleDynaItemData(ctx, paramMap);
    }

    private Map getMultiDynaItemData(Context ctx, Map paramMap) throws BOSException, EASBizException {
        Map formulaFilters = (Map)paramMap.get("formulaFilter");
        Map asstActTypeAttribeAndGroupMap = (Map)paramMap.get("asstActTypeAttribeAndGroupMap");
        List asstActTypeList = (List)paramMap.get("asstActTypeList");
        Map useredAsstActTypes = (Map)paramMap.get("useredTypes");
        boolean isIncludingUnposted = Boolean.valueOf(paramMap.get("isIncludingUnposted").toString());
        FullOrgUnitInfo fullOrgUnitInfo = (FullOrgUnitInfo)paramMap.get("currentUnit");
        CompanyOrgUnitInfo orgUnit = this.getCompanyInfo(ctx, fullOrgUnitInfo);
        if (orgUnit != null && formulaFilters != null && !formulaFilters.isEmpty()) {
            DynItemFillData fillData = null;
            List formulaFilterList = null;
            OneToManyMap fillItemMap = new OneToManyMap();
            Map tmpMap = null;
            List tmpList = null;
            for (String tableName : formulaFilters.keySet()) {
                formulaFilterList = (List)formulaFilters.get(tableName);
                fillData = new DynItemFillData(ctx, formulaFilterList, asstActTypeList, useredAsstActTypes, orgUnit, tableName, asstActTypeAttribeAndGroupMap);
                tmpMap = fillData.getMultiFillDate();
                for (Object obj : tmpMap.keySet()) {
                    if (!(tmpMap.get(obj) instanceof List)) continue;
                    tmpList = (List)tmpMap.get(obj);
                    for (Object obj2 : tmpList) {
                        fillItemMap.put(obj, obj2);
                    }
                }
                tmpMap.clear();
            }
            return fillItemMap;
        }
        return null;
    }

    private Map getSingleDynaItemData(Context ctx, Map paramMap) {
        HashMap<String, Serializable> returnDataMap = new HashMap<String, Serializable>();
        try {
            Map acctFormulasFilter = (Map)paramMap.get("formulaFilter");
            Map acctCashFormulasFilter = (Map)paramMap.get("acctCashFormulaFilter");
            String dynItemSql = (String)paramMap.get("dynItemSql");
            String basePointAsstActNumber = (String)paramMap.get("basePointAsstActNumber");
            boolean isIncludingUnposted = (Boolean)paramMap.get("isIncludingUnposted");
            FullOrgUnitInfo fullOrgUnitInfo = (FullOrgUnitInfo)paramMap.get("currentUnit");
            HashSet<String> asstActTypes = new HashSet<String>();
            asstActTypes.addAll(acctFormulasFilter.keySet());
            asstActTypes.addAll(acctCashFormulasFilter.keySet());
            asstActTypes.add(basePointAsstActNumber);
            Map<String, AsstActTypeInfo> asstActTypeMap = this.initAsstActTypes(ctx, asstActTypes);
            CompanyOrgUnitInfo orgUnit = this.getCompanyInfo(ctx, fullOrgUnitInfo);
            if (orgUnit != null) {
                Set<String> fillItemSet = new HashSet<String>();
                fillItemSet.addAll(this.getSingleDynaItemDataId(ctx, acctFormulasFilter, asstActTypeMap, orgUnit, basePointAsstActNumber, isIncludingUnposted, FormulaType.acct, paramMap));
                fillItemSet.addAll(this.getSingleDynaItemDataId(ctx, acctCashFormulasFilter, asstActTypeMap, orgUnit, basePointAsstActNumber, isIncludingUnposted, FormulaType.acctcash, paramMap));
                if (!fillItemSet.isEmpty()) {
                    fillItemSet = this.filterDynaItemData(ctx, fillItemSet, asstActTypeMap.get(basePointAsstActNumber), dynItemSql);
                }
                returnDataMap.put("fillItemSet", (Serializable)((Object)fillItemSet));
                returnDataMap.put("isExecuteError", Boolean.valueOf(false));
            }
        }
        catch (Exception e) {
            returnDataMap.put("isExecuteError", new Boolean(true));
            returnDataMap.put("Exception", e);
            logger.error((Object)"getDynItemData", (Throwable)e);
        }
        return returnDataMap;
    }

    private Set<String> getSingleDynaItemDataId(Context ctx, Map<String, Map<String, List<FormulaFilterInfo>>> formulasFilterMap, Map<String, AsstActTypeInfo> asstActTypeMap, CompanyOrgUnitInfo orgUnit, String basePointAsstActNumber, boolean isIncludingUnposted, FormulaType type, Map paramMap) throws Exception {
        HashSet<String> basePointTypeIds = new HashSet<String>();
        if (!formulasFilterMap.isEmpty()) {
            String balType = (String)paramMap.get("balType");
            for (Map.Entry<String, Map<String, List<FormulaFilterInfo>>> entryMap : formulasFilterMap.entrySet()) {
                String asstTypeNumber = entryMap.getKey();
                AsstActTypeInfo asstActTypeInfo = asstActTypeMap.get(asstTypeNumber);
                Map<String, List<FormulaFilterInfo>> FilterMap = entryMap.getValue();
                HashSet<String> ids = new HashSet<String>();
                for (Map.Entry<String, List<FormulaFilterInfo>> entryFilter : FilterMap.entrySet()) {
                    String balTableName = entryFilter.getKey();
                    List<FormulaFilterInfo> Filters = entryFilter.getValue();
                    boolean isExecuteError = false;
                    Object exception = null;
                    DynaItemDataInterface fillData = null;
                    if (type.equals((Object)FormulaType.acct)) {
                        fillData = new DynItemFillData(ctx, Filters, null, asstActTypeInfo.getMappingFieldName(), orgUnit, balTableName, balType);
                    } else if (type.equals((Object)FormulaType.acctcash)) {
                        fillData = new DynaItemFillDataByAcctCash(ctx, Filters, null, asstActTypeInfo.getMappingFieldName(), orgUnit, balTableName.equals("1"), isIncludingUnposted);
                    }
                    if (fillData == null) continue;
                    fillData.createFillDate();
                    if (fillData.isExecuteError()) {
                        throw fillData.getException();
                    }
                    if (fillData.getFillItemSet() == null || fillData.getFillItemSet().isEmpty()) continue;
                    ids.addAll(fillData.getFillItemSet());
                }
                if (ids.isEmpty()) continue;
                basePointTypeIds.addAll(this.changeAsstActType(ctx, ids, asstActTypeMap, basePointAsstActNumber, asstTypeNumber));
            }
        }
        return basePointTypeIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> filterDynaItemData(Context ctx, Set<String> ids, AsstActTypeInfo asstActTypeInfo, String dynItemSql) throws Exception {
        if (!ids.isEmpty()) {
            boolean isDyAutoFillByFilter = true;
            try {
                isDyAutoFillByFilter = !CslRptUtil.getCslParam(ctx, "ISDYAUTOFILLBYNOTFILTER");
            }
            catch (Exception e) {
                logger.error((Object)"getCslParam error", (Throwable)e);
                isDyAutoFillByFilter = true;
            }
            if (isDyAutoFillByFilter) {
                DynItemFillSqlParse sqlParse = new DynItemFillSqlParse(dynItemSql);
                sqlParse.parseSql();
                String bodySql = sqlParse.getOtherExcludeorder();
                String curIdStrs = null;
                ParamTempTblService service = null;
                try {
                    if (ids.size() < 50) {
                        curIdStrs = CslRptUtil.changeIdSet2String(ids);
                    } else {
                        TableInfo table = new TableInfo("T_CSL_Ids");
                        table.addColumn(new ColumnInfo("FId", "varchar(44)"));
                        service = ParamTempTblService.getInstance(ctx, table, ids, null);
                        curIdStrs = "select fid from " + service.getTmpTableName();
                    }
                    StringBuffer sql = new StringBuffer();
                    sql.append(" select distinct baseAsst.fid fid from ").append(asstActTypeInfo.getRealtionDataObject()).append(" baseAsst \n");
                    sql.append(" inner join (").append(bodySql).append(") fillItemTbl on fillItemTbl.id=baseAsst.fid  \n");
                    sql.append(" where baseAsst.fid in (").append(curIdStrs).append(")  \n");
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    HashSet<String> curIds = new HashSet<String>();
                    while (rowSet.next()) {
                        curIds.add(rowSet.getString("fid"));
                    }
                    HashSet<String> hashSet = curIds;
                    return hashSet;
                }
                finally {
                    if (service != null && !DebugLogger.isDebug) {
                        service.release();
                    }
                }
            }
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> changeAsstActType(Context ctx, Set<String> ids, Map<String, AsstActTypeInfo> asstActTypeMap, String basePointAsstActNumber, String curAsstActNumber) throws Exception {
        if (!basePointAsstActNumber.equals(curAsstActNumber)) {
            String curIdStrs = null;
            ParamTempTblService service = null;
            try {
                if (ids.size() < 50) {
                    curIdStrs = CslRptUtil.changeIdSet2String(ids);
                } else {
                    TableInfo table = new TableInfo("T_CSL_Ids");
                    table.addColumn(new ColumnInfo("FId", "varchar(44)"));
                    service = ParamTempTblService.getInstance(ctx, table, ids, null);
                    curIdStrs = "select fid from " + service.getTmpTableName();
                }
                StringBuffer sql = new StringBuffer();
                sql.append(" select baseAsst.fid fid from ").append(asstActTypeMap.get(basePointAsstActNumber).getRealtionDataObject()).append(" baseAsst \n");
                sql.append(" inner join ").append(asstActTypeMap.get(curAsstActNumber).getRealtionDataObject()).append(" asst on asst.fnumber=baseAsst.fnumber \n");
                sql.append(" where asst.fid in (").append(curIdStrs).append(")");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                HashSet<String> changedIds = new HashSet<String>();
                while (rowSet.next()) {
                    changedIds.add(rowSet.getString("fid"));
                }
                HashSet<String> hashSet = changedIds;
                return hashSet;
            }
            finally {
                if (service != null && !DebugLogger.isDebug) {
                    service.release();
                }
            }
        }
        return ids;
    }

    private Map<String, AsstActTypeInfo> initAsstActTypes(Context ctx, Set<String> asstActTypes) throws Exception {
        if (!asstActTypes.isEmpty()) {
            IAsstActType iType = AsstActTypeFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("number"));
            view.getSelector().add(new SelectorItemInfo("mappingfieldname"));
            view.getSelector().add(new SelectorItemInfo("realtionDataObject"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", asstActTypes, CompareType.INCLUDE));
            view.setFilter(filter);
            AsstActTypeCollection actTypeColl = iType.getAsstActTypeCollection(view);
            HashMap<String, AsstActTypeInfo> asstActTypeMap = new HashMap<String, AsstActTypeInfo>();
            for (int i = 0; i < actTypeColl.size(); ++i) {
                asstActTypeMap.put(actTypeColl.get(i).getNumber(), actTypeColl.get(i));
            }
            return asstActTypeMap;
        }
        return null;
    }

    private Map getInterAndExchDynaCompany(Context ctx, Map paramMap) {
        HashMap<String, Object> returnDataMap = new HashMap<String, Object>();
        try {
            Map acctFormulaFilter = (Map)paramMap.get("acctFormulaFilter");
            Map acctCashFormulaFilter = (Map)paramMap.get("acctCashFormulaFilter");
            FullOrgUnitInfo fullOrgUnitInfo = (FullOrgUnitInfo)paramMap.get("currentUnit");
            boolean isGroupByFormula = paramMap.get("isGroupByFormula") == null ? false : (Boolean)paramMap.get("isGroupByFormula");
            boolean isQueryOwnerCompany = paramMap.get("isQueryOwnerCompany") == null ? false : (Boolean)paramMap.get("isQueryOwnerCompany");
            boolean isIncludingUnposted = (Boolean)paramMap.get("isIncludingUnposted");
            CompanyOrgUnitInfo orgUnit = this.getCompanyInfo(ctx, fullOrgUnitInfo);
            if (orgUnit != null) {
                Object companyIdSet;
                boolean isExecuteError;
                HashMap<String, AsstActTypeInfo> asstActTypeMap = new HashMap<String, AsstActTypeInfo>();
                HashSet<String> fillCompanyIdSet = new HashSet<String>();
                HashMap<String, Set<String>> fillItemMap = new HashMap<String, Set<String>>();
                boolean isHasGetData = false;
                if (acctFormulaFilter != null && !acctFormulaFilter.isEmpty()) {
                    for (String tableName : acctFormulaFilter.keySet()) {
                        Map attribute_formulaFilterMap = (Map)acctFormulaFilter.get(tableName);
                        for (String attribute : attribute_formulaFilterMap.keySet()) {
                            isHasGetData = true;
                            DynItemFillData fillData = null;
                            fillData = isQueryOwnerCompany ? new DynItemFillData(ctx, (List)attribute_formulaFilterMap.get(attribute), null, "F" + attribute + "id", orgUnit, tableName, true, attribute) : (isGroupByFormula ? new DynItemFillData(ctx, (List)attribute_formulaFilterMap.get(attribute), null, "F" + attribute + "id", orgUnit, tableName, true) : new DynItemFillData(ctx, (List)attribute_formulaFilterMap.get(attribute), null, "F" + attribute + "id", orgUnit, tableName, null));
                            fillData.createFillDate();
                            isExecuteError = fillData.isExecuteError();
                            if (isExecuteError) {
                                returnDataMap.put("isExecuteError", isExecuteError);
                                if (fillData.getException() != null) {
                                    returnDataMap.put("Exception", fillData.getException());
                                }
                                return returnDataMap;
                            }
                            if (isQueryOwnerCompany) {
                                if (fillData.getFillItemMap() == null || fillData.getFillItemMap().isEmpty()) continue;
                                fillItemMap.putAll(fillData.getFillItemMap());
                                continue;
                            }
                            companyIdSet = this.getCompanySet(ctx, fillData, attribute, asstActTypeMap, isGroupByFormula);
                            if (companyIdSet == null) continue;
                            if (!isGroupByFormula) {
                                fillCompanyIdSet.addAll((Set)companyIdSet);
                                continue;
                            }
                            this.combineMap(fillItemMap, (Map)companyIdSet);
                        }
                    }
                }
                if (acctCashFormulaFilter != null && !acctCashFormulaFilter.isEmpty()) {
                    DynaItemFillDataByAcctCash acctCashHandle = null;
                    for (String acctCashType : acctCashFormulaFilter.keySet()) {
                        Map attribute_formulaFilterMap = (Map)acctCashFormulaFilter.get(acctCashType);
                        for (String attribute : attribute_formulaFilterMap.keySet()) {
                            isHasGetData = true;
                            acctCashHandle = isQueryOwnerCompany ? new DynaItemFillDataByAcctCash(ctx, (List)attribute_formulaFilterMap.get(attribute), null, "F" + attribute + "id", orgUnit, acctCashType.equals("1"), isIncludingUnposted, null, isQueryOwnerCompany, attribute) : (isGroupByFormula ? new DynaItemFillDataByAcctCash(ctx, (List)attribute_formulaFilterMap.get(attribute), null, "F" + attribute + "id", orgUnit, acctCashType.equals("1"), isIncludingUnposted, null, isGroupByFormula) : new DynaItemFillDataByAcctCash(ctx, (List)attribute_formulaFilterMap.get(attribute), null, "F" + attribute + "id", orgUnit, acctCashType.equals("1"), isIncludingUnposted));
                            acctCashHandle.createFillDate();
                            isExecuteError = acctCashHandle.isExecuteError();
                            if (isExecuteError) {
                                returnDataMap.put("isExecuteError", isExecuteError);
                                if (acctCashHandle.getException() != null) {
                                    returnDataMap.put("Exception", acctCashHandle.getException());
                                }
                                return returnDataMap;
                            }
                            if (isQueryOwnerCompany) {
                                if (acctCashHandle.getFillItemMap() == null || acctCashHandle.getFillItemMap().isEmpty()) continue;
                                fillItemMap.putAll(acctCashHandle.getFillItemMap());
                                continue;
                            }
                            companyIdSet = this.getCompanySet(ctx, acctCashHandle, attribute, asstActTypeMap, isGroupByFormula);
                            if (companyIdSet == null) continue;
                            if (!isGroupByFormula) {
                                fillCompanyIdSet.addAll((Set)companyIdSet);
                                continue;
                            }
                            this.combineMap(fillItemMap, (Map)companyIdSet);
                        }
                    }
                }
                if (isGroupByFormula || isQueryOwnerCompany) {
                    returnDataMap.put("fillItemSet", fillItemMap);
                } else {
                    Object[] companyInfos = null;
                    if (isHasGetData) {
                        companyInfos = this.getCompanyInfos(ctx, fillCompanyIdSet, (String)paramMap.get("orgTreeId"));
                    }
                    returnDataMap.put("fillItemSet", companyInfos);
                }
                returnDataMap.put("isExecuteError", false);
            }
        }
        catch (Exception e) {
            returnDataMap.put("isExecuteError", new Boolean(true));
            returnDataMap.put("Exception", e);
            logger.error((Object)"getDynItemData", (Throwable)e);
        }
        return returnDataMap;
    }

    private void combineMap(Map<String, Set<String>> targetMap, Map<String, Set<String>> srcMap) {
        if (srcMap != null && !srcMap.isEmpty()) {
            if (targetMap.isEmpty()) {
                targetMap.putAll(srcMap);
            } else {
                for (String mapKey : srcMap.keySet()) {
                    Set<String> values = targetMap.get(mapKey);
                    if (values == null) {
                        targetMap.put(mapKey, srcMap.get(mapKey));
                        continue;
                    }
                    values.addAll((Collection<String>)srcMap.get(mapKey));
                }
            }
        }
    }

    private CompanyOrgUnitInfo getCompanyInfo(Context ctx, FullOrgUnitInfo fullOrgUnitInfo) throws BOSException, EASBizException {
        CompanyOrgUnitCollection col;
        CompanyOrgUnitInfo orgUnit = null;
        if (fullOrgUnitInfo.getId() != null && (orgUnit = MultOrgUnitHelper.getInstance().getDelegateCompany(OrgType.NONE, fullOrgUnitInfo.getId().toString(), ctx)) != null && (StringUtils.isEmpty((String)orgUnit.getLongNumber()) || StringUtils.isEmpty((String)orgUnit.getNumber()) || !orgUnit.containsKey("isBizUnit") || !orgUnit.containsKey("isProfitOrgUnit")) && (col = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection("select id,number,name,longnumber,isBizUnit,isProfitOrgUnit where id='" + fullOrgUnitInfo.getId().toString() + "'")) != null && col.size() > 0) {
            orgUnit = col.get(0);
        }
        return orgUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getCompanyInfos(Context ctx, Set<String> ids, String orgTreeId) throws Exception {
        if (ids == null || ids.isEmpty()) {
            return new Object[0];
        }
        String curIdStrs = null;
        ParamTempTblService service = null;
        try {
            if (ids.size() < 50) {
                curIdStrs = CslRptUtil.changeIdSet2String(ids);
            } else {
                TableInfo table = new TableInfo("T_CSL_Ids");
                table.addColumn(new ColumnInfo("FId", "varchar(44)"));
                service = ParamTempTblService.getInstance(ctx, table, ids, null);
                curIdStrs = "select fid from " + service.getTmpTableName();
            }
            StringBuffer sql = new StringBuffer();
            sql.append("select company.fid,company.fnumber,company.fname_").append(ctx.getLocale()).append(" fname from t_org_baseunit company");
            if (!StringUtils.isEmpty((String)orgTreeId)) {
                sql.append(" inner join t_org_structure stru on stru.funitid=company.fid ");
            } else {
                sql.append(" inner join T_ORG_OUPartFI partFI on partFI.funitid=company.fid and partFI.fisBizUnit=1 and partFI.fisSealUp=0 ");
            }
            sql.append(" where company.FISASSISTANTORG = 0 and company.fid in(").append(curIdStrs).append(")");
            if (!StringUtils.isEmpty((String)orgTreeId)) {
                sql.append(" and stru.ftreeid='").append(orgTreeId).append("' ");
            }
            sql.append(" order by fnumber ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            ArrayList<FullOrgUnitInfo> orgUnits = new ArrayList<FullOrgUnitInfo>();
            while (rowSet.next()) {
                FullOrgUnitInfo info = new FullOrgUnitInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("fid")));
                info.setNumber(rowSet.getString("fnumber"));
                info.setName(rowSet.getString("fname"));
                orgUnits.add(info);
            }
            Object[] objectArray = orgUnits.toArray();
            return objectArray;
        }
        finally {
            if (service != null && !DebugLogger.isDebug) {
                service.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getCompanySet(Context ctx, DynaItemDataInterface dynaitemData, String attribute, Map<String, AsstActTypeInfo> asstActTypeMap, boolean isGroupByFormula) throws Exception {
        Set<String> ids = null;
        if (isGroupByFormula) {
            Map<String, Set<String>> fillItemMap = dynaitemData.getFillItemMap();
            if (fillItemMap != null && !fillItemMap.isEmpty()) {
                ids = new HashSet<String>();
                for (Set<String> items : fillItemMap.values()) {
                    ids.addAll(items);
                }
            }
        } else {
            ids = dynaitemData.getFillItemSet();
        }
        if (ids == null || ids.isEmpty()) {
            return ids;
        }
        String tableName = null;
        String field = null;
        if ("customer".equalsIgnoreCase(attribute)) {
            tableName = "t_bd_customer";
            field = "finternalCompanyid";
        } else if ("provider".equalsIgnoreCase(attribute)) {
            tableName = "t_bd_supplier";
            field = "finternalCompanyid";
        } else if (!"companyOrg".equals(attribute) && !asstActTypeMap.containsKey(attribute)) {
            CoreBaseCollection coll = AsstActTypeFactory.getLocalInstance((Context)ctx).getCollection(" select realtionDataObject where asstHGAttribute='" + attribute + "'");
            asstActTypeMap.put(attribute, coll != null && !coll.isEmpty() ? (AsstActTypeInfo)coll.get(0) : null);
        }
        if (tableName != null || asstActTypeMap.containsKey(attribute)) {
            String curIdStrs = null;
            ParamTempTblService service = null;
            try {
                if (ids.size() < 50) {
                    curIdStrs = CslRptUtil.changeIdSet2String(ids);
                } else {
                    TableInfo table = new TableInfo("T_CSL_Ids");
                    table.addColumn(new ColumnInfo("FId", "varchar(44)"));
                    service = ParamTempTblService.getInstance(ctx, table, ids, null);
                    curIdStrs = "select fid from " + service.getTmpTableName();
                }
                StringBuffer sql = new StringBuffer();
                if (field != null) {
                    sql.append(" select distinct case when asstType.").append(field).append(" is null then (case when company.fid is null then profitcenter.fid else company.fid end) ").append(" else asstType.").append(field).append(" end as fid ");
                } else {
                    sql.append(" select distinct case when company.fid is null then profitcenter.fid else company.fid end as fid  ");
                }
                if (isGroupByFormula) {
                    sql.append(",asstType.fid fsrcId");
                }
                sql.append(" from ").append(tableName == null ? asstActTypeMap.get(attribute).getRealtionDataObject() : tableName).append(" asstType ");
                sql.append(" left join t_org_profitcenter profitcenter on profitcenter.fnumber=asstType.fnumber ");
                sql.append(" left join t_org_company company on company.fnumber=asstType.fnumber ");
                sql.append(" where asstType.fid in(").append(curIdStrs).append(")");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                HashSet<String> companyIds = new HashSet<String>();
                HashMap<String, String> companyMap = new HashMap<String, String>();
                while (rowSet.next()) {
                    String id = rowSet.getString("fid");
                    if (StringUtils.isEmpty((String)id)) continue;
                    if (isGroupByFormula) {
                        companyMap.put(rowSet.getString("fsrcId"), id);
                        continue;
                    }
                    companyIds.add(id);
                }
                if (isGroupByFormula) {
                    Map<String, Set<String>> fillItemMap = dynaitemData.getFillItemMap();
                    HashMap<String, HashSet<String>> result = new HashMap<String, HashSet<String>>();
                    for (String formulaId : fillItemMap.keySet()) {
                        for (String curCompany : fillItemMap.get(formulaId)) {
                            String id = (String)companyMap.get(curCompany);
                            if (id == null) continue;
                            HashSet<String> companys = (HashSet<String>)result.get(formulaId);
                            if (companys == null) {
                                companys = new HashSet<String>();
                                result.put(formulaId, companys);
                            }
                            companys.add(id);
                        }
                    }
                    companyMap.clear();
                    HashMap<String, HashSet<String>> hashMap = result;
                    return hashMap;
                }
                HashSet<String> hashSet = companyIds;
                return hashSet;
            }
            finally {
                if (service != null && !DebugLogger.isDebug) {
                    service.release();
                }
            }
        }
        return isGroupByFormula ? dynaitemData.getFillItemMap() : ids;
    }

    private boolean isNullRowOrCol(Sheet.ICellsIterator cells) {
        while (cells.hasNext()) {
            Cell cell = cells.next();
            if (cell.getValue() == null && cell.getFormula() == null && cell.getUserObjectValue("ITEM") == null) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean _updateUnionVersionData(Context ctx, String oldOrgTreeId, String newOrgTreeId, Timestamp startDate, IObjectCollection periods, boolean isMergeByFiscalPeriod) throws BOSException, EASBizException {
        String key = oldOrgTreeId + "1";
        try {
            UnionVersionUtil.updateData(ctx, oldOrgTreeId, newOrgTreeId, startDate, (PeriodCollection)periods, isMergeByFiscalPeriod);
            UnionVersionUtil.repairRptReceivedData(ctx, newOrgTreeId);
            UnionVersionUtil.repairDataAfterVersioning(ctx, newOrgTreeId, startDate, (PeriodCollection)periods, isMergeByFiscalPeriod, 1);
            while (!UnionVersionUtil.UnionVersionThreadMap.containsKey(key)) {
                Thread.sleep(30L);
            }
            boolean isVersionSuccess = (Boolean)UnionVersionUtil.UnionVersionThreadMap.get(key);
            if (!isVersionSuccess) {
                this.setRollbackOnly();
            }
        }
        catch (Exception e) {
            logger.error((Object)"_updateUnionVersionData error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            UnionVersionUtil.UnionVersionThreadMap.remove(key);
        }
        return true;
    }

    protected Book _getAfterAdjustReportBook(Context ctx, String cslReportId, OrgTreeInfo orgTreeInfo, boolean isCaliAdjust) throws BOSException, EASBizException {
        CslReportInfo cslReportInfo = this._getAfterAdjustReportCslReportInfo(ctx, cslReportId, orgTreeInfo, isCaliAdjust);
        Book book = null;
        try {
            book = cslReportInfo.getBook();
        }
        catch (Exception e) {
            logger.error((Object)"get After Adjust Report Book error", (Throwable)e);
        }
        return book;
    }

    private static enum FormulaType {
        acct,
        acctcash;

    }
}

