/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DebitOrCreditEnum;
import com.kingdee.eas.fi.gr.cslrpt.DynaItemElimEntryCondition;
import com.kingdee.eas.fi.gr.cslrpt.DynamicItemBean;
import com.kingdee.eas.fi.gr.cslrpt.ElimDynaItemEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimDynaItemEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.IElimDynaItemEntry;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractElimDynaItemEntryControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.util.TemplateDispenseNewUtil;
import com.kingdee.eas.fi.newrpt.util.TemplateItemListNewUtil;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class ElimDynaItemEntryControllerBean
extends AbstractElimDynaItemEntryControllerBean {
    private static final Logger logger = CoreUIObject.getLogger(ElimDynaItemEntryControllerBean.class);

    @Override
    protected List _getExistsDyItemElimns(Context ctx, Map cslParams, String elemTypes, String elimId) throws BOSException {
        if (cslParams == null || cslParams.isEmpty()) {
            return new ArrayList();
        }
        boolean isQueryBudget = false;
        if (cslParams.get("ISQUERYBUDGET") != null) {
            isQueryBudget = (Boolean)cslParams.get("ISQUERYBUDGET");
        }
        if (cslParams.containsKey("EntriesIds")) {
            if ((Set)cslParams.get("EntriesIds") != null && !((Set)cslParams.get("EntriesIds")).isEmpty()) {
                return this.getExistsDyitemElimnByEntrieID(ctx, null, isQueryBudget, (Set)cslParams.get("EntriesIds"), cslParams);
            }
            return new ArrayList(1);
        }
        ArrayList<String> elimEntryIds = new ArrayList<String>();
        Set templateIds = this.getDispenseTemplates(ctx, cslParams);
        if (templateIds == null || templateIds.isEmpty()) {
            return elimEntryIds;
        }
        String templateItemListTable = TemplateItemListNewUtil.getTemplateItemListTableName((Context)ctx, (Set)templateIds, (String)TemplateItemListNewUtil.templateItemList);
        ArrayList<String> params = new ArrayList<String>();
        String orgBoundId = (String)cslParams.get("KEY_CUR_ORGBOUND_ID");
        String orgGroupId = (String)cslParams.get("KEY_CUR_ORGBOUNDGROUP_ID");
        StringBuffer querySql = new StringBuffer("select t2.FID\tas FID\n");
        querySql.append(" from T_CSL_Elimination t1\t\n");
        querySql.append(" inner join T_CSL_EliminationEntry t2 on t2.FEliminationID=t1.FID\t\n");
        querySql.append(" inner join T_CSL_RptItem t3 on t3.FID=t2.FItemID\t\n");
        querySql.append(" inner join ").append(templateItemListTable).append(" t4\t\n");
        querySql.append(" on t1.FValueType=t4.FValueType\t\n");
        querySql.append(" and t3.FNumber=t4.FItemNumber\t\n");
        querySql.append(" and t2.FDataElement=t4.FDataElement\t\n");
        querySql.append(" where t1.FOrgBoundID= ?\t\t\t\t\n");
        querySql.append(" and t1.FOrgUnit= ?\t\t\t\t\t\n");
        querySql.append(" and t1.FYear= ? \t\t\t\t\t\t\n");
        querySql.append(" and t1.FPeriod= ? \t\t\t\t\t\n");
        querySql.append(" and t1.FPeriodType= ?     \t\t\t\n");
        querySql.append(" and (t4.FKeyNumber is null or t4.FKeyNumber='' or t4.FKeyNumber='NULL') \n");
        querySql.append(" and t4.ftemplateid in(").append(CslRptUtil.AryToItemString(templateIds)).append(")        \n");
        params.add(orgBoundId);
        params.add(orgGroupId);
        params.add((String)cslParams.get("Year"));
        params.add((String)cslParams.get("Period"));
        params.add((String)cslParams.get("PeriodType"));
        querySql.append(" union  select t2.FID\tas FID \n").append(" from T_CSL_Elimination t1\t\n").append(" inner join T_CSL_EliminationEntry t2 on t2.FEliminationID=t1.FID\t\n").append(" inner join T_CSL_RptItem t3 on t3.FID=t2.FItemID \n").append(" inner join t_csl_DynaItem2ElimItem dy2e on dy2e.FElimItemID=t3.FID   \t\n").append(" inner join T_CSL_RptItem rptitem2 on rptitem2.FID=dy2e.FDynaItemID\t\n").append(" inner join ").append(templateItemListTable).append(" t4 on  t1.FValueType=t4.FValueType\t\n").append(" and rptitem2.FNumber=t4.FItemNumber\t\n").append(" and t2.FDataElement=t4.FDataElement\t\n").append(" where t1.FOrgBoundID= ?\t\t\t\t\n").append(" and t1.FOrgUnit= ?\t\t\t\t\t\n").append(" and t1.FYear= ? \t\t\t\t\t\t\n").append(" and t1.FPeriod= ? \t\t\t\t\t\n").append(" and t1.FPeriodType= ?\t\t\t\t\t\n").append(" and CHARINDEX('=DITEM', upper(t4.FItemFormula))>0\t\n").append(" and t4.ftemplateid in(").append(CslRptUtil.AryToItemString(templateIds)).append(")        \n");
        params.add(orgBoundId);
        params.add(orgGroupId);
        params.add((String)cslParams.get("Year"));
        params.add((String)cslParams.get("Period"));
        params.add((String)cslParams.get("PeriodType"));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])params.toArray());
        try {
            while (rowSet.next()) {
                elimEntryIds.add(rowSet.getString(1));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return elimEntryIds;
    }

    private Set getDispenseTemplates(Context ctx, Map cslParams) throws BOSException {
        HashSet<String> templateIds = new HashSet<String>();
        ArrayList<String> params = new ArrayList<String>();
        String orgBoundId = (String)cslParams.get("KEY_CUR_ORGBOUND_ID");
        String orgGroupId = (String)cslParams.get("KEY_CUR_ORGBOUNDGROUP_ID");
        StringBuffer querySql = new StringBuffer("SELECT DISTINCT T6.FID\tAS FID ");
        querySql.append(" FROM  ").append(TemplateDispenseNewUtil.getDisTable((Context)ctx, (String)orgBoundId)).append(" T5 ");
        querySql.append(" INNER JOIN  T_RPT_TEMPLATE T6 ");
        querySql.append(" ON T6.FID = T5.FDISPENSESRCID ");
        querySql.append(" INNER JOIN (SELECT DISTINCT T1.FORGBOUNDID, T2.FCOMPANYID ");
        querySql.append(" FROM T_CSL_ELIMINATION T1 ");
        querySql.append(" INNER JOIN T_CSL_ELIMINATIONENTRY T2 ");
        querySql.append(" ON T2.FELIMINATIONID = T1.FID ");
        querySql.append(" WHERE T1.FORGBOUNDID = ? ");
        querySql.append(" AND T1.FORGUNIT = ? AND T1.FYEAR = ? AND T1.FPERIOD = ? ");
        querySql.append(" AND T1.FPERIODTYPE = ?) TMP ON TMP.FORGBOUNDID = T5.FORGBOUNDID ");
        querySql.append(" WHERE T5.FORGBOUNDID = ? ");
        querySql.append(" AND T6.FPERIODTYPE = ? ");
        querySql.append(" AND T6.FVERSIONSTATUS = 1");
        querySql.append(" AND T6.FTEMPLATETYPE IN (10, 11, 12, 13) ");
        querySql.append(" AND (TMP.FCOMPANYID = T5.FCOMPANYID OR (TMP.FCOMPANYID IS NULL)) ");
        params.add(orgBoundId);
        params.add(orgGroupId);
        params.add((String)cslParams.get("Year"));
        params.add((String)cslParams.get("Period"));
        params.add((String)cslParams.get("PeriodType"));
        params.add(orgBoundId);
        params.add((String)cslParams.get("PeriodType"));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])params.toArray());
        try {
            while (rowSet.next()) {
                templateIds.add(rowSet.getString(1));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return templateIds;
    }

    @Override
    protected void _saveDynamicElimnItems(Context ctx, List dynamicElimnItems) throws BOSException {
        ElimDynaItemEntryInfo ei = (ElimDynaItemEntryInfo)dynamicElimnItems.get(0);
        String eliminationEntryId = ei.getEliminationEntry().getId().toString();
        this._deleteDyItemsByElimEntryId(ctx, eliminationEntryId);
        try {
            IElimDynaItemEntry itemEntry = ElimDynaItemEntryFactory.getLocalInstance(ctx);
            for (ElimDynaItemEntryInfo entryInfo : dynamicElimnItems) {
                itemEntry.submit((CoreBaseInfo)entryInfo);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"saveDynamicElimnItems_EASBizException", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Map _getAsstActTypeNumbers(Context ctx, Map cslParams, int eleminationType) throws BOSException {
        if (cslParams == null || cslParams.isEmpty()) {
            return null;
        }
        HashMap<String, String> asstActTypeNumbers = new HashMap<String, String>();
        String orgBoundId = (String)cslParams.get("KEY_CUR_ORGBOUND_ID");
        String orgGroupId = (String)cslParams.get("KEY_CUR_ORGBOUNDGROUP_ID");
        String templateTable = null;
        TempTablePool tmpTablePool = null;
        try {
            SQLBuilder querySql = new SQLBuilder();
            String dispenseTable = TemplateDispenseNewUtil.getDisTable((Context)ctx, (String)orgBoundId);
            OrgStructureInfo orgStructureInfo = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo("select longNumber where tree.id='" + orgBoundId + "' and unit.id='" + orgGroupId + "'");
            tmpTablePool = TempTablePool.getInstance((Context)ctx);
            templateTable = tmpTablePool.createTempTable("create table t_csl_templateTable(fid varchar(44))");
            querySql.append(" insert into ").append(templateTable).append("(fid) ");
            querySql.append(" select mainTmp.fid from t_rpt_template mainTmp ");
            querySql.append(" inner join ( ");
            querySql.append(" \tselect max(tmp.fauditedtime) fauditedtime, tmp.fgroup ");
            querySql.append(" \tfrom ").append(dispenseTable).append(" dis ");
            querySql.append(" \tinner join t_rpt_template tmp on tmp.fid=dis.fdispensesrcid ");
            querySql.append(" \twhere dis.forgboundid=?", (Object)orgBoundId).append(" and tmp.ftemplateType in (10,11,12,13) and tmp.fisfreezed=0 ");
            querySql.append("\tand tmp.fperiodtype=? ", cslParams.get("PeriodType"));
            querySql.append(" \tand dis.fcompanyid in(select funitid from t_org_structure where ftreeid=? ", (Object)orgBoundId);
            querySql.append(" \tand (flongnumber like '").append(orgStructureInfo.getLongNumber()).append("!%'  or funitid=? ))", (Object)orgGroupId);
            querySql.append(" \tgroup by tmp.fgroup ");
            querySql.append(" ) subTmp on subTmp.fgroup=mainTmp.fgroup and subTmp.fauditedtime=mainTmp.fauditedtime ");
            DbUtil.execute((Context)ctx, (String)querySql.getSQL(), (Object[])querySql.getParams());
            querySql.reset();
            Object entryIdsInStr = cslParams.get("entryIdsInStr");
            querySql.append(" select distinct FItemID,FDataElement,FAsstActTypeNumber,fauditedtime from (");
            querySql.append("select t1.FItemID,t1.FDataElement,t4.FAsstActTypeNumber,max(tmp.fauditedtime) fauditedtime\t\n");
            querySql.append(" from (select a1.FOrgBoundID as FOrgBoundId,a2.FItemID AS FItemID, \n");
            querySql.append(" a2.FDataElement as FDataElement,a2.FCompanyID as FCompanyId, \n");
            querySql.append(" a1.FValueType as FValueType,a1.fperiodtype as fperiodtype \n");
            querySql.append(" FROM T_CSL_Elimination a1 \n");
            querySql.append(" inner join T_CSL_EliminationEntry a2 on a2.FEliminationID=a1.FID \n");
            querySql.append(" where a1.FOrgBoundID='").append(orgBoundId).append("'\t\n");
            querySql.append(" and a1.FOrgUnit='").append(orgGroupId).append("'\t\n");
            querySql.append(" and a1.FYear=").append(cslParams.get("Year"));
            querySql.append(" and a1.FPeriod=").append(cslParams.get("Period"));
            querySql.append(" and a1.FPeriodType=").append(cslParams.get("PeriodType")).append("\n");
            if (entryIdsInStr != null) {
                querySql.append(" and a2.fid in (").append(entryIdsInStr).append(") \n");
            } else if (this.isCheckPlatForm(cslParams)) {
                querySql.append(" and a1.FElimDataSource=").append((Object)(this.isCheckPlatForm(cslParams) ? 1 : 0)).append("\n");
            }
            querySql.append(" UNION ALL \n");
            querySql.append(" select a1.FOrgBoundID as FOrgBoundId,a0.FDynaItemID AS FItemID, \n");
            querySql.append(" a2.FDataElement AS FDataElement,a2.FCompanyID as FCompanyId, \n");
            querySql.append(" a1.FValueType as FValueType,a1.fperiodtype as fperiodtype \n");
            querySql.append(" FROM  T_CSL_Elimination a1 \n");
            querySql.append(" inner join T_CSL_EliminationEntry a2 on a2.FEliminationID=a1.FID \n");
            querySql.append(" inner join t_csl_dynaitem2elimitem a0 on a0.FElimItemID=a2.FItemID \n");
            querySql.append(" where a1.FOrgBoundID='").append(orgBoundId).append("'\t\n");
            querySql.append(" and a1.FOrgUnit='").append(orgGroupId).append("'\t\n");
            querySql.append(" and a1.FYear=").append(cslParams.get("Year"));
            querySql.append(" and a1.FPeriod=").append(cslParams.get("Period"));
            querySql.append(" and a1.FPeriodType=").append(cslParams.get("PeriodType")).append("\n");
            if (entryIdsInStr != null) {
                querySql.append(" and a2.fid in (").append(entryIdsInStr).append(") \n");
            } else if (this.isCheckPlatForm(cslParams)) {
                querySql.append(" and a1.FElimDataSource=").append((Object)(this.isCheckPlatForm(cslParams) ? 1 : 0)).append("\n");
            }
            querySql.append(" ) t1 \n");
            querySql.append(" inner join T_CSL_RptItem t3 on t3.FID=t1.FItemID \n");
            querySql.append(" inner join T_CSL_TempletItemList t4 \n");
            querySql.append(" on t1.FValueType=t4.FValueType \n");
            querySql.append(" and t3.FNumber=t4.FItemNumber \n");
            querySql.append(" and t1.FDataElement=t4.FDataElement \n");
            querySql.append(" inner join t_rpt_template tmp on tmp.fid=t4.ftemplateid ");
            querySql.append(" where t4.ftemplateid in(select fid from ").append(templateTable).append(") \n");
            querySql.append(" and (t4.FKeyNumber is null or t4.FKeyNumber='') ");
            querySql.append(" group by t1.FItemID,t1.FDataElement,t4.FAsstActTypeNumber) tmpTable order by fauditedtime ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            while (rowSet.next()) {
                asstActTypeNumbers.put(rowSet.getString(1) + rowSet.getString(2), rowSet.getString(3));
            }
            if (templateTable == null || tmpTablePool == null || DebugLogger.isDebug) return asstActTypeNumbers;
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (templateTable == null || tmpTablePool == null || DebugLogger.isDebug) throw throwable;
                tmpTablePool.releaseTable(templateTable);
                throw throwable;
            }
        }
        tmpTablePool.releaseTable(templateTable);
        return asstActTypeNumbers;
    }

    @Override
    protected List _getDynamicElimnItems(Context ctx, Map cslParam, String eliminationEntryId) throws BOSException {
        String orgTreeId = (String)cslParam.get("KEY_CUR_ORGBOUND_ID");
        String orgGroupId = (String)cslParam.get("KEY_CUR_ORGBOUNDGROUP_ID");
        ArrayList<Object> params = new ArrayList<Object>();
        String companyId = null;
        String rptItemNumber = (String)cslParam.get("RptItemNumber");
        int valueType = -1;
        int year = -1;
        int period = -1;
        StringBuffer querySql = new StringBuffer();
        querySql.append("select t2.FCompanyID, t1.fvaluetype as fvaluetype ").append("\r\n");
        querySql.append(",t1.fyear as year,t1.fperiod as period").append("\r\n");
        querySql.append("from T_CSL_Elimination t1").append("\r\n");
        querySql.append("inner join T_CSL_EliminationEntry t2").append("\r\n");
        querySql.append("on t1.fid=t2.FEliminationID").append("\r\n");
        querySql.append("where t2.fid='").append(eliminationEntryId).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        try {
            if (rowSet.next()) {
                companyId = rowSet.getString(1);
                valueType = rowSet.getInt("fvaluetype");
                year = rowSet.getInt("year");
                period = rowSet.getInt("period");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"paramsQuery_SQLException", (Throwable)e);
        }
        ArrayList<DynamicItemBean> dynamicItems = new ArrayList<DynamicItemBean>(100);
        querySql.setLength(0);
        querySql.append(" select FLongNumber from T_ORG_Structure");
        querySql.append(" where FTreeId = '").append(orgTreeId).append("'");
        querySql.append(" and FUnitID = '").append(orgGroupId).append("'");
        String structLongNumber = null;
        rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        try {
            if (rowSet.next()) {
                structLongNumber = rowSet.getString(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"structLongNumber_SQLException", (Throwable)e);
        }
        querySql.setLength(0);
        querySql.append(" select t6.FKeyNumber,t6.FKeyName\t\n");
        querySql.append(" from T_ORG_Structure t1\t\n");
        querySql.append(" inner join T_ORG_BaseUnit t3\t\n");
        querySql.append(" on t1.FUnitID=t3.FID\t\n");
        querySql.append(" inner join t_csl_CslReport t4\t\n");
        querySql.append(" on t4.FOrgUnitID=t3.FID and t4.FSourceType=10\t\n");
        querySql.append(" inner join T_CSL_DynaItemData t5\t\n");
        querySql.append(" on t5.FReportID=t4.FID\t\n");
        querySql.append(" inner join T_CSL_DynaItemDataEntry t6\t\n");
        querySql.append(" on t5.FID=t6.FItemDataID\t\n");
        querySql.append(" where t1.FIsLeaf = 1\t\n");
        querySql.append(" and t1.FTreeID = ?\t\n");
        params.add(orgTreeId);
        querySql.append(" and t1.FLongNumber like ?\t\n");
        params.add(structLongNumber + "%");
        if (companyId != null) {
            querySql.append(" and t3.FID = ?\t\n");
            params.add(companyId);
        }
        querySql.append(" and t5.FCommitStatus = ?\t\n");
        params.add(3);
        querySql.append(" and t6.FItemID = ?\t\n");
        params.add(rptItemNumber);
        querySql.append(" and t6.fvaluetype = ?\t\n");
        params.add(valueType);
        querySql.append(" and t6.FYear = ?").append("\r\n");
        querySql.append(" and t6.FPeriod = ?").append("\r\n");
        params.add(year);
        params.add(period);
        querySql.append(" group by t6.FKeyNumber,t6.FKeyName\t\n");
        querySql.append(" order by count(t6.FKeyName) desc,t6.FKeyNumber\t\n");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])params.toArray());
        try {
            while (rowSet.next()) {
                DynamicItemBean dItem = new DynamicItemBean(rowSet.getString(1), rowSet.getString(2));
                dynamicItems.add(dItem);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"DynamicItemBean_SQLException", (Throwable)e);
        }
        return dynamicItems;
    }

    @Override
    protected void _deleteDyItemsByElimId(Context ctx, String eliminationId) throws BOSException {
        StringBuffer dcSql = new StringBuffer();
        dcSql.append("delete from T_CSL_ElimDynaItemEntry").append("\r\n");
        dcSql.append("where feliminationentryid in").append("\r\n");
        dcSql.append("(").append("\r\n");
        dcSql.append(" select fid from T_CSL_EliminationEntry").append("\r\n");
        dcSql.append(" where feliminationid = ?").append("\r\n");
        dcSql.append(")");
        DbUtil.execute((Context)ctx, (String)dcSql.toString(), (Object[])new Object[]{eliminationId});
    }

    @Override
    protected void _deleteDyItemsByElimEntryId(Context ctx, String eliminationEntryId) throws BOSException {
        StringBuffer dcSql = new StringBuffer();
        dcSql.append("delete from T_CSL_ElimDynaItemEntry");
        dcSql.append(" where FEliminationEntryID='").append(eliminationEntryId).append("'");
        DbUtil.execute((Context)ctx, (String)dcSql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getExistsDyitemElimnByEntrieID(Context ctx, String elimEntryIds, boolean isQueryBudget, Set EntryIds, Map cslParams) throws BOSException {
        String tmpTable = null;
        boolean setHasData = EntryIds != null && EntryIds.size() > 0;
        ParamTempTblService srv = null;
        if (setHasData) {
            TableInfo table = new TableInfo("T_TMPL_ENTRYID");
            table.addColumn("FENTRYID");
            srv = new ParamTempTblService(ctx, table, EntryIds, null);
            tmpTable = srv.getTmpTableName();
        }
        String orgTreeId = (String)cslParams.get("KEY_CUR_ORGBOUND_ID");
        String disTbl = "T_CSL_TempletDispense";
        if (!StringUtils.isEmpty((String)orgTreeId)) {
            disTbl = TemplateDispenseNewUtil.getDisTable((Context)ctx, (String)orgTreeId);
        }
        StringBuffer querySql = new StringBuffer("select distinct t2.FID\tas FID \n");
        if (isQueryBudget) {
            querySql.append(" from T_CSL_HisElimination t1\t\n");
            querySql.append(" inner join T_CSL_HisEliminationEntry t2 on t2.FEliminationID=t1.FID\t\n");
        } else {
            querySql.append(" from T_CSL_Elimination t1\t\n");
            querySql.append(" inner join T_CSL_EliminationEntry t2 on t2.FEliminationID=t1.FID\t\n");
        }
        if (setHasData) {
            querySql.append(" inner join ").append(tmpTable).append(" tmpTable").append(" on tmpTable.FENTRYID = t2.FID \n");
        }
        querySql.append(" inner join T_CSL_RptItem t3 on t3.FID=t2.FItemID\t\n");
        querySql.append(" inner join ").append(disTbl).append(" t5\t\n");
        querySql.append(" on t1.FOrgBoundID=t5.forgboundid\t\n");
        querySql.append(" and (t2.fcompanyid=t5.fcompanyid or t2.fcompanyid is null)\t\n");
        querySql.append(" inner join t_Rpt_Template t6\t\n");
        querySql.append(" on t6.fid=t5.fdispensesrcid and t6.fperiodtype=t1.fperiodtype\t\n");
        querySql.append(" and t6.fversionstatus=").append(1).append("\n");
        querySql.append(" inner join T_CSL_TempletItemList t4\t\n");
        querySql.append(" on t4.ftemplateid=t6.fid and t1.FValueType=t4.FValueType\t\n");
        querySql.append(" and t3.FNumber=t4.FItemNumber\t\n");
        querySql.append(" and t2.FDataElement=t4.FDataElement\t\n");
        ArrayList<String> params = new ArrayList<String>();
        if (!setHasData) {
            querySql.append(" where  t2.FID = ? ");
            querySql.append(" and t6.ftemplateType in (10,11,12,13) \t\t\t\t\t\t\n");
            params.add(elimEntryIds);
        } else {
            querySql.append(" where t6.ftemplateType in (10,11,12,13) \t\t\t\t\t\t\n");
        }
        querySql.append(" and (t4.FKeyNumber is null or t4.FKeyNumber=''  or t4.FKeyNumber='NULL' ) \n");
        querySql.append(" union  select t2.FID\tas FID \n");
        if (isQueryBudget) {
            querySql.append(" from T_CSL_HisElimination t1\t\n").append(" inner join T_CSL_HisEliminationEntry t2 on t2.FEliminationID=t1.FID\t\n");
        } else {
            querySql.append(" from T_CSL_Elimination t1\t\n").append(" inner join T_CSL_EliminationEntry t2 on t2.FEliminationID=t1.FID\t\n");
        }
        if (setHasData) {
            querySql.append(" inner join ").append(tmpTable).append(" tmpTable").append(" on tmpTable.FENTRYID = t2.FID \n");
        }
        querySql.append(" inner join T_CSL_RptItem t3 on t3.FID=t2.FItemID \n").append(" inner join t_csl_DynaItem2ElimItem dy2e on dy2e.FElimItemID=t3.FID   \t\n").append(" inner join T_CSL_RptItem rptitem2 on rptitem2.FID=dy2e.FDynaItemID\t\n").append(" inner join ").append(disTbl).append(" t5\t\t\n").append(" on t1.FOrgBoundID=t5.forgboundid and (t2.fcompanyid=t5.fcompanyid or t2.fcompanyid is null)\t\n").append(" inner join t_Rpt_Template t6 on t6.fid=t5.fdispensesrcid and t6.fperiodtype=t1.fperiodtype and t6.fversionstatus=1 \n").append(" inner join T_CSL_TempletItemList t4 on t4.ftemplateid=t6.fid and t1.FValueType=t4.FValueType\t\n").append(" and rptitem2.FNumber=t4.FItemNumber\t\n").append(" and t2.FDataElement=t4.FDataElement\t\n");
        if (!setHasData) {
            querySql.append(" where t2.fid = ? ");
            querySql.append(" and t6.ftemplateType in (10,11,12,13) \t\t\t\t\t\n");
            params.add(elimEntryIds);
        } else {
            querySql.append(" where t6.ftemplateType in (10,11,12,13) \t\t\t\t\t\n");
        }
        querySql.append(" and CHARINDEX('=DITEM', upper(t4.FItemFormula))>0\t\n");
        IRowSet rowSet = null;
        rowSet = params.isEmpty() ? DbUtil.executeQuery((Context)ctx, (String)querySql.toString()) : DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])params.toArray());
        HashSet<String> set = new HashSet<String>();
        try {
            while (rowSet.next()) {
                set.add(rowSet.getString(1));
            }
        }
        catch (SQLException e) {
            set = new HashSet(0);
        }
        finally {
            if (setHasData) {
                srv.release();
            }
        }
        return new ArrayList(set);
    }

    @Override
    public boolean _isExistsDyitemElimnByEntrieID(Context ctx, Map cslParams) throws BOSException {
        String elimEntryId;
        List l;
        if (cslParams == null || cslParams.isEmpty() || cslParams.get("entryId") == null) {
            return false;
        }
        boolean isQueryBudget = false;
        if (cslParams.get("ISQUERYBUDGET") != null) {
            isQueryBudget = (Boolean)cslParams.get("ISQUERYBUDGET");
        }
        return !(l = this.getExistsDyitemElimnByEntrieID(ctx, elimEntryId = (String)cslParams.get("entryId"), isQueryBudget, null, cslParams)).isEmpty();
    }

    private Set buildElimDynaItemEntry(Context ctx, Map buildParams) throws BOSException, EASBizException {
        Map asstActTypeNumbers = (Map)buildParams.get("asstActTypeNumbers");
        Map company2ter = (Map)buildParams.get("company2ter");
        Map compareMap = (Map)buildParams.get("compareMap");
        List entryids = (List)buildParams.get("entryids");
        Map rowMap = (Map)buildParams.get("rowmap");
        TreeSet<String> addnumberset = new TreeSet<String>();
        HashSet accnumber = new HashSet();
        CoreBaseCollection addinfolist = this.getAddInfoCollection(buildParams, asstActTypeNumbers, accnumber);
        CoreBaseCollection addinfolist1 = new CoreBaseCollection();
        CustomerCollection customer = null;
        SupplierCollection supplier = null;
        Map customerCsspCache = null;
        Map supplierCsspCache = null;
        HashMap numberAcctHG = this.getNumberAcctHG(ctx, accnumber);
        for (int j = 0; j < addinfolist.size(); ++j) {
            ElimDynaItemEntryInfo dynaentryinfo = (ElimDynaItemEntryInfo)addinfolist.get(j);
            String actTypeNumber = (String)asstActTypeNumbers.get(dynaentryinfo.getRptItem().getId().toString() + dynaentryinfo.getEliminationEntry().getDataElement());
            EliminationEntryInfo entryinfo = dynaentryinfo.getEliminationEntry();
            String eliminationid = entryinfo.getElimination().getId().toString();
            String companyid = entryinfo.getCompany().getId().toString();
            if (numberAcctHG.containsKey(actTypeNumber) && numberAcctHG.get(actTypeNumber) != null) {
                int i;
                String mappingFieldName = (String)numberAcctHG.get(actTypeNumber);
                FullOrgUnitInfo orginfo = null;
                Set set = (Set)company2ter.get(eliminationid);
                Object[] object = set.toArray();
                if (compareMap.containsKey(eliminationid)) {
                    int compareValue = (Integer)compareMap.get(eliminationid);
                    if (compareValue == 2) {
                        orginfo = (FullOrgUnitInfo)object[0];
                        if (orginfo.getId().toString().equals(companyid) && object.length > 1) {
                            orginfo = (FullOrgUnitInfo)object[1];
                        }
                    } else {
                        if (compareValue == 1) continue;
                        orginfo = (FullOrgUnitInfo)object[0];
                    }
                } else if (object.length == 2 && (orginfo = (FullOrgUnitInfo)object[0]).getId().toString().equals(companyid)) {
                    orginfo = (FullOrgUnitInfo)object[1];
                }
                if (orginfo == null) continue;
                if (mappingFieldName.equals("customer")) {
                    if (customerCsspCache == null) {
                        EntityViewInfo view = this.getEntityViewInfo(company2ter, "internalCustomerType");
                        customer = this.getCustomerCollection(ctx, view);
                        customerCsspCache = this.getCsspCacheMap(ctx, mappingFieldName, (IObjectCollection)customer);
                    }
                    if (customer != null && customer.size() > 0) {
                        for (i = 0; i < customer.size(); ++i) {
                            CustomerInfo custom = customer.get(i);
                            if ((custom.getInternalCompany() == null || !orginfo.getId().toString().equals(custom.getInternalCompany().getId().toString())) && (custom.getInternalProfitCenter() == null || !orginfo.getId().toString().equals(custom.getInternalProfitCenter().getId().toString()))) continue;
                            this.constructElimDynaItemEntryInfo(dynaentryinfo, customerCsspCache, (DataBaseInfo)custom);
                        }
                    }
                } else if (mappingFieldName.equals("provider")) {
                    if (supplierCsspCache == null) {
                        EntityViewInfo view = this.getEntityViewInfo(company2ter, "internalSupplierType");
                        supplier = this.getSupplierCollection(ctx, view);
                        supplierCsspCache = this.getCsspCacheMap(ctx, mappingFieldName, (IObjectCollection)supplier);
                    }
                    if (supplier != null && supplier.size() > 0) {
                        for (i = 0; i < supplier.size(); ++i) {
                            SupplierInfo supplierinfo = supplier.get(i);
                            if ((supplierinfo.getInternalCompany() == null || !orginfo.getId().toString().equals(supplierinfo.getInternalCompany().getId().toString())) && (supplierinfo.getInternalProfitCenter() == null || !orginfo.getId().toString().equals(supplierinfo.getInternalProfitCenter().getId().toString()))) continue;
                            this.constructElimDynaItemEntryInfo(dynaentryinfo, supplierCsspCache, (DataBaseInfo)supplierinfo);
                        }
                    }
                } else if ((mappingFieldName.equals("companyOrg") || "profitOrg".equals(mappingFieldName) || "costOrg".equals(mappingFieldName)) && orginfo != null) {
                    String longNumber;
                    String string = longNumber = orginfo.getLongNumber() == null ? orginfo.getNumber() : orginfo.getLongNumber();
                    if (mappingFieldName.equals("companyOrg") && !StringUtils.isEmpty((String)orginfo.getString("companyLongNumber"))) {
                        longNumber = orginfo.getString("companyLongNumber");
                    }
                    if (mappingFieldName.equals("profitOrg") && !StringUtils.isEmpty((String)orginfo.getString("profitLongNumber"))) {
                        longNumber = orginfo.getString("profitLongNumber");
                    }
                    if (mappingFieldName.equals("costOrg") && !StringUtils.isEmpty((String)orginfo.getString("costLongNumber"))) {
                        longNumber = orginfo.getString("costLongNumber");
                    }
                    dynaentryinfo.setKeyNumber(orginfo.getNumber());
                    dynaentryinfo.setKeyLongNumber(longNumber);
                    dynaentryinfo.setKeyName(orginfo.getName());
                }
                if (StringUtil.isEmpty((String)dynaentryinfo.getKeyNumber())) continue;
                addinfolist1.add(addinfolist.get(j));
            } else {
                FullOrgUnitInfo orginfo = null;
                Set set = (Set)company2ter.get(eliminationid);
                Object[] object = set.toArray();
                if (object.length != 2) continue;
                HashMap cslParams = new HashMap();
                cslParams.put("KEY_CUR_ORGBOUND_ID", buildParams.get("KEY_CUR_ORGBOUND_ID"));
                cslParams.put("KEY_CUR_ORGBOUNDGROUP_ID", buildParams.get("KEY_CUR_ORGBOUNDGROUP_ID"));
                if (StringUtils.isEmpty((String)dynaentryinfo.getRptItem().getNumber())) {
                    RPTItemInfo rptItemInfo = RPTItemFactory.getLocalInstance(ctx).getRPTItemInfo("select number where id='" + dynaentryinfo.getRptItem().getId().toString() + "'");
                    cslParams.put("RptItemNumber", rptItemInfo.getNumber());
                } else {
                    cslParams.put("RptItemNumber", dynaentryinfo.getRptItem().getNumber());
                }
                List dynamicItems = this.getDynamicHandElimnItems(ctx, cslParams, entryinfo.getId().toString());
                if (dynamicItems.size() <= 0) continue;
                String paramStr = CslRptUtil.AryToItemString(set);
                StringBuffer oql = new StringBuffer();
                oql.append("select number,longnumber,name,simpleName,englishName where simpleName in(").append(paramStr).append(")");
                oql.append(" or name").append(" in (").append(paramStr).append(")");
                oql.append(" or englishName").append(" in (").append(paramStr).append(")");
                FullOrgUnitCollection orgUnits = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(oql.toString());
                if (orgUnits.size() != 2) continue;
                orginfo = orgUnits.get(0);
                if (orginfo.getId().toString().equals(companyid)) {
                    orginfo = orgUnits.get(1);
                }
                boolean isFound = false;
                int size = dynamicItems.size();
                for (int i = 0; i < size; ++i) {
                    DynamicItemBean dItem = (DynamicItemBean)dynamicItems.get(i);
                    if (!dItem.getLongNumber().endsWith(orginfo.getNumber()) && !dItem.getLongNumber().endsWith(orginfo.getName()) && (orginfo.getSimpleName() == null || !dItem.getLongNumber().endsWith(orginfo.getSimpleName())) && (orginfo.getEnglishName() == null || !dItem.getLongNumber().endsWith(orginfo.getEnglishName()))) continue;
                    String longNumber = orginfo.getLongNumber() == null ? orginfo.getNumber() : orginfo.getLongNumber();
                    dynaentryinfo.setKeyNumber(orginfo.getNumber());
                    dynaentryinfo.setKeyLongNumber(longNumber);
                    dynaentryinfo.setKeyName(orginfo.getName());
                    addinfolist1.add(addinfolist.get(j));
                    isFound = true;
                    break;
                }
                if (!isFound) continue;
            }
            String number = entryinfo.getElimination().getNumber();
            Integer rowNumber = (Integer)rowMap.get(entryinfo.getId().toString());
            addnumberset.add(number + "_" + rowNumber);
        }
        String idscod = this.getidsstring(entryids);
        StringBuffer deleteSql = new StringBuffer();
        deleteSql.append("delete from T_CSL_ElimDynaItemEntry ").append("\r\n");
        deleteSql.append("where feliminationentryid in").append("\r\n");
        if (idscod != null) {
            deleteSql.append("(").append(idscod.toString()).append(")");
        } else {
            deleteSql.append("('')");
        }
        DbUtil.execute((Context)ctx, (String)deleteSql.toString());
        ElimDynaItemEntryFactory.getLocalInstance(ctx).saveBatchData(addinfolist1);
        return addnumberset;
    }

    protected List getDynamicHandElimnItems(Context ctx, Map cslParam, String eliminationEntryId) throws BOSException {
        String orgTreeId = (String)cslParam.get("KEY_CUR_ORGBOUND_ID");
        String orgGroupId = (String)cslParam.get("KEY_CUR_ORGBOUNDGROUP_ID");
        ArrayList<Object> params = new ArrayList<Object>();
        Object companyId = null;
        String rptItemNumber = (String)cslParam.get("RptItemNumber");
        int valueType = -1;
        int year = -1;
        int period = -1;
        StringBuffer querySql = new StringBuffer();
        querySql.append("select t2.FCompanyID, t1.fvaluetype as fvaluetype ").append("\r\n");
        querySql.append(",t1.fyear as year,t1.fperiod as period").append("\r\n");
        querySql.append("from T_CSL_Elimination t1").append("\r\n");
        querySql.append("inner join T_CSL_EliminationEntry t2").append("\r\n");
        querySql.append("on t1.fid=t2.FEliminationID").append("\r\n");
        querySql.append("where t2.fid='").append(eliminationEntryId).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        try {
            if (rowSet.next()) {
                valueType = rowSet.getInt("fvaluetype");
                year = rowSet.getInt("year");
                period = rowSet.getInt("period");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"paramsQuery_SQLException", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        ArrayList<DynamicItemBean> dynamicItems = new ArrayList<DynamicItemBean>(100);
        querySql.setLength(0);
        querySql.append(" select FLongNumber from T_ORG_Structure");
        querySql.append(" where FTreeId = '").append(orgTreeId).append("'");
        querySql.append(" and FUnitID = '").append(orgGroupId).append("'");
        String structLongNumber = null;
        rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        try {
            if (rowSet.next()) {
                structLongNumber = rowSet.getString(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"structLongNumber_SQLException", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        querySql.setLength(0);
        querySql.append(" select t6.FKeyNumber,t6.FKeyName\t\n");
        querySql.append(" from T_ORG_Structure t1\t\n");
        querySql.append(" inner join T_ORG_BaseUnit t3\t\n");
        querySql.append(" on t1.FUnitID=t3.FID\t\n");
        querySql.append(" inner join t_csl_CslReport t4\t\n");
        querySql.append(" on t4.FOrgUnitID=t3.FID \n");
        querySql.append(" inner join T_CSL_DynaItemData t5\t\n");
        querySql.append(" on t5.FReportID=t4.FID\t\n");
        querySql.append(" inner join T_CSL_DynaItemDataEntry t6\t\n");
        querySql.append(" on t5.FID=t6.FItemDataID\t\n");
        querySql.append(" where t1.FTreeID = ?\t\n");
        params.add(orgTreeId);
        querySql.append(" and t1.FLongNumber like ?\t\n");
        params.add(structLongNumber + "%");
        querySql.append(" and t5.FCommitStatus = ?\t\n");
        params.add(3);
        querySql.append(" and t6.FItemID = ?\t\n");
        params.add(rptItemNumber);
        querySql.append(" and t6.fvaluetype = ?\t\n");
        params.add(valueType);
        querySql.append(" and t6.FYear = ?").append("\r\n");
        querySql.append(" and t6.FPeriod = ?").append("\r\n");
        params.add(year);
        params.add(period);
        querySql.append(" group by t6.FKeyNumber,t6.FKeyName\t\n");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])params.toArray());
        try {
            while (rowSet.next()) {
                DynamicItemBean dItem = new DynamicItemBean(rowSet.getString(1), rowSet.getString(2));
                dynamicItems.add(dItem);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"DynamicItemBean_SQLException", (Throwable)e);
        }
        return dynamicItems;
    }

    private Map getCsspCacheMap(Context ctx, String mappingFieldName, IObjectCollection dataBaseColl) throws BOSException {
        if (dataBaseColl == null || dataBaseColl.isEmpty()) {
            return new HashMap(2);
        }
        DataBaseInfo obj2 = null;
        HashSet<String> browseGroupIdSet = new HashSet<String>();
        for (DataBaseInfo obj2 : dataBaseColl) {
            browseGroupIdSet.add(((DataBaseInfo)obj2.get("browseGroup")).getId().toString());
        }
        StringBuffer oql = new StringBuffer(200);
        oql.append("select id, number, name, longNumber");
        oql.append(" where id in (").append(CslRptUtil.changeIdSet2String(browseGroupIdSet)).append(')');
        oql.append(" and deletedStatus = 1");
        if (mappingFieldName.equals("customer")) {
            oql.append(" and groupStandard.type in (0, 1)");
        } else if (mappingFieldName.equals("provider")) {
            oql.append(" and groupStandard.type in (0, 2)");
        }
        DataBaseCollection col = CSSPGroupFactory.getLocalInstance((Context)ctx).getDataBaseCollection(oql.toString());
        HashMap<String, DataBaseInfo> csspCache = new HashMap<String, DataBaseInfo>(col.size());
        DataBaseInfo group = null;
        for (int i = 0; i < col.size(); ++i) {
            group = col.get(i);
            csspCache.put(group.getId().toString(), group);
        }
        return csspCache;
    }

    private void constructElimDynaItemEntryInfo(ElimDynaItemEntryInfo dynaentryinfo, Map csspCache, DataBaseInfo obj) throws EASBizException, BOSException {
        DataBaseInfo group = (DataBaseInfo)obj.get("browseGroup");
        if (group == null) {
            return;
        }
        dynaentryinfo.setKeyName(obj.getName());
        String number = obj.getNumber();
        dynaentryinfo.setKeyNumber(number);
        String longNumber = null;
        if (group != null) {
            group = (DataBaseInfo)csspCache.get(group.getId().toString());
            longNumber = (String)group.get("longNumber") + "!" + number;
        } else {
            longNumber = number;
        }
        dynaentryinfo.setKeyLongNumber(longNumber);
    }

    private SupplierCollection getSupplierCollection(Context ctx, EntityViewInfo view) throws BOSException {
        return SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollection(view);
    }

    private CustomerCollection getCustomerCollection(Context ctx, EntityViewInfo view) throws BOSException {
        return CustomerFactory.getLocalInstance((Context)ctx).getCustomerCollection(view);
    }

    private EntityViewInfo getEntityViewInfo(Map company2ter, String internalCompanyType) {
        HashSet<String> company = new HashSet<String>();
        for (String elimid : company2ter.keySet()) {
            Set set = (Set)company2ter.get(elimid);
            Object[] object = set.toArray();
            for (int i = 0; i < object.length; ++i) {
                if (object[i] == null || ((FullOrgUnitInfo)object[i]).getId() == null) continue;
                String companyid = ((FullOrgUnitInfo)object[i]).getId().toString();
                company.add(companyid);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(internalCompanyType, (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("internalCompany.id", company, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo(internalCompanyType, (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("internalProfitCenter.id", company, CompareType.INCLUDE));
        filter.setMaskString("((#0 and #1) or (#2 and #3))");
        view.setFilter(filter);
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("browseGroup"));
        return view;
    }

    private CoreBaseCollection getAddInfoCollection(Map buildParams, Map asstActTypeNumbers, HashSet accnumber) {
        Map entry2value = (Map)buildParams.get("entry2value");
        Map item2dynaitem = (Map)buildParams.get("item2dynaitem");
        CoreBaseCollection addInfoColl = new CoreBaseCollection();
        for (String entryid : entry2value.keySet()) {
            EliminationEntryInfo entryinfo = (EliminationEntryInfo)entry2value.get(entryid);
            ElimDynaItemEntryInfo dynaentryinfo = new ElimDynaItemEntryInfo();
            String itemId = entryinfo.getItem().getId().toString();
            DebitOrCreditEnum itemDC = entryinfo.getItem().getDc();
            dynaentryinfo.setId(BOSUuid.create((BOSObjectType)dynaentryinfo.getBOSType()));
            dynaentryinfo.setEliminationEntry(entryinfo);
            if (entryinfo.getDebit() != null) {
                if (itemDC != null && itemDC.equals((Object)DebitOrCreditEnum.DEBIT)) {
                    dynaentryinfo.setValue(entryinfo.getDebit());
                } else {
                    dynaentryinfo.setValue(entryinfo.getDebit().negate());
                }
            } else if (itemDC != null && itemDC.equals((Object)DebitOrCreditEnum.CREDIT)) {
                dynaentryinfo.setValue(entryinfo.getCredit());
            } else {
                dynaentryinfo.setValue(entryinfo.getCredit().negate());
            }
            for (RPTItemInfo iteminfo : item2dynaitem.keySet()) {
                if (!iteminfo.getId().toString().equals(itemId)) continue;
                RPTItemInfo dynaitem = (RPTItemInfo)item2dynaitem.get(iteminfo);
                if (dynaitem != null) {
                    dynaentryinfo.setRptItem(dynaitem);
                    continue;
                }
                dynaentryinfo.setRptItem(iteminfo);
            }
            if (dynaentryinfo.getRptItem() == null) {
                RPTItemInfo iteminfo = new RPTItemInfo();
                iteminfo.setId(BOSUuid.read((String)itemId));
                dynaentryinfo.setRptItem(iteminfo);
            }
            String actTypeNumber = (String)asstActTypeNumbers.get(dynaentryinfo.getRptItem().getId().toString() + dynaentryinfo.getEliminationEntry().getDataElement());
            accnumber.add(actTypeNumber);
            addInfoColl.add((CoreBaseInfo)dynaentryinfo);
        }
        return addInfoColl;
    }

    protected Map getElimDynaItem(Context ctx, List entryids) throws BOSException {
        HashMap<RPTItemInfo, RPTItemInfo> itemtodynaitem = new HashMap<RPTItemInfo, RPTItemInfo>();
        StringBuffer dcSql = new StringBuffer();
        dcSql.append("select  rpt.fid as itemid,dynarpt.fid as dynaitemid, \n");
        dcSql.append("rpt.fnumber as number,dynarpt.fnumber as dynanumber,\n");
        dcSql.append("rpt.fname_" + ctx.getLocale() + " as name,dynarpt.fname_" + ctx.getLocale() + " as dynaname  \n");
        dcSql.append("from T_CSL_DynaItem2ElimItem as dynaItem inner  join T_CSL_RptItem as rpt on dynaItem.FElimItemID=rpt.fid \n");
        dcSql.append("inner  join T_CSL_RptItem as dynarpt on dynaItem.FDynaItemID=dynarpt.fid \n");
        dcSql.append(" order by number,dynanumber \n");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)dcSql.toString());
            HashSet<String> set = new HashSet<String>();
            while (rowSet.next()) {
                String itemid = rowSet.getString("itemid");
                if (set.contains(itemid)) continue;
                set.add(itemid);
                String dynaitemid = rowSet.getString("dynaitemid");
                RPTItemInfo item = new RPTItemInfo();
                item.setId(BOSUuid.read((String)itemid));
                item.setNumber(rowSet.getString("number"));
                item.setName(rowSet.getString("name"));
                RPTItemInfo dynaitem = new RPTItemInfo();
                if (!StringUtil.isEmpty((String)dynaitemid)) {
                    dynaitem.setId(BOSUuid.read((String)dynaitemid));
                    dynaitem.setNumber(rowSet.getString("dynanumber"));
                    dynaitem.setName(rowSet.getString("dynaname"));
                } else {
                    dynaitem = null;
                }
                itemtodynaitem.put(item, dynaitem);
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        return itemtodynaitem;
    }

    private String getGenautodynaElimsql(Context ctx, String entryidsInStr, DynaItemElimEntryCondition.QueryAuditStatEnum state) {
        StringBuffer dcSql = new StringBuffer();
        dcSql.append("select rpt.FID as ItemID,rpt.fDC as ItemDC,eliminationentry.fcompanyID as CompanyID,org.fname_" + ctx.getLocale() + " as  Companyname, \n");
        dcSql.append("org.fnumber as Companynumber ,org.flongnumber as CompanyLongNumber,");
        dcSql.append("eliminationentry.FDebit as Debit,eliminationentry.FCredit as  Credit, \n");
        dcSql.append("elimination.fid as id,elimination.fnumber as number,eliminationentry.fid as entryid, \n");
        dcSql.append("eliminationentry.fseq as entryseq,companyOrg.FlongNumber as companyLongNumber2 \n");
        dcSql.append(",profitOrg.FlongNumber as profitLongNumber,costOrg.FlongNumber as costLongNumber,eliminationentry.fdataElement,elimination.felimdatasource \n");
        dcSql.append("from T_CSL_EliminationEntry as eliminationentry \n");
        dcSql.append(" inner join T_CSL_Elimination as elimination\t\n");
        dcSql.append(" on eliminationentry.FEliminationID=elimination.FID\t\n");
        dcSql.append("inner join T_ORG_BaseUnit as org on eliminationentry.FCompanyID=org.fid \n");
        dcSql.append("left join t_org_company as companyOrg on eliminationentry.FCompanyID=companyOrg.fid \n");
        dcSql.append("left join t_org_profitcenter as profitOrg on eliminationentry.FCompanyID=profitOrg.fid \n");
        dcSql.append("left join t_org_costcenter as costOrg on eliminationentry.FCompanyID=costOrg.fid \n");
        dcSql.append(" inner join T_CSL_RptItem as rpt\t\n");
        dcSql.append(" on eliminationentry.FItemID=rpt.FID\t\n");
        dcSql.append(" where eliminationentry.fcompanyID is not null \n");
        if (DynaItemElimEntryCondition.QueryAuditStatEnum.AllStat != state) {
            dcSql.append(" and elimination.FCheckedStatus=1 ");
        }
        dcSql.append(" and eliminationentry.FEliminationID in ( \n");
        dcSql.append("select  DISTINCT elim.fid as fid  \n");
        dcSql.append("from T_CSL_EliminationEntry as elimentry inner join T_CSL_Elimination as elim   \n");
        dcSql.append("on elim.fid=elimentry.FEliminationID \n");
        dcSql.append("where elimentry.FCompanyID is not null \n");
        if (entryidsInStr != null) {
            dcSql.append(" and elimentry.fid in ");
            dcSql.append("(").append(entryidsInStr).append(")\n");
        }
        dcSql.append(") \n");
        dcSql.append(" order by elimination.fnumber,eliminationentry.fseq \n");
        return dcSql.toString();
    }

    private String getidsstring(List entryids) {
        return CslRptUtil.changeIdList2String(entryids);
    }

    @Override
    protected Set _generateautodynamicElimination(Context ctx, List entryids, Map cslParams) throws BOSException, EASBizException {
        Map asstActTypeNumbers;
        ctx.getLocale().toString();
        ElimTypeEnum eleminationType = (ElimTypeEnum)((Object)cslParams.get("type"));
        ElimTypeEnum[] elimTypes = (ElimTypeEnum[])cslParams.get("elimType");
        Map rowmap = (Map)cslParams.get("rowmap");
        HashMap<String, HashSet> companytoter = new HashMap<String, HashSet>();
        HashMap<String, EliminationEntryInfo> entrytovalue = new HashMap<String, EliminationEntryInfo>();
        Map itemtodynaitem = this.getElimDynaItem(ctx, entryids);
        OneToManyMap elimIdMap = new OneToManyMap();
        ParamTempTblService service = null;
        try {
            String entryidsInStr = null;
            if (entryids != null && entryids.size() > 50) {
                service = ParamTempTblService.getDefaultInstance(ctx, entryids, null);
                entryidsInStr = "select id from " + service.getTmpTableName();
            } else {
                entryidsInStr = this.getidsstring(entryids);
            }
            String dcSql = this.getGenautodynaElimsql(ctx, entryidsInStr, (DynaItemElimEntryCondition.QueryAuditStatEnum)((Object)cslParams.get("state")));
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)dcSql.toString());
            if (rowSet.size() > 0) {
                if (!StringUtils.isEmpty((String)entryidsInStr)) {
                    cslParams.put("entryIdsInStr", entryidsInStr);
                }
                asstActTypeNumbers = this._getAsstActTypeNumbers(ctx, cslParams, eleminationType.getValue());
            } else {
                HashSet hashSet = new HashSet();
                return hashSet;
            }
            while (rowSet.next()) {
                HashSet set;
                String id = rowSet.getString("id");
                elimIdMap.put(rowSet.getInt("felimdatasource"), id);
                String companyid = rowSet.getString("CompanyID");
                String entryid = rowSet.getString("entryid");
                if (entryids.contains(entryid)) {
                    HashSet set2;
                    if (entrytovalue.containsKey(entryid)) continue;
                    EliminationEntryInfo info = new EliminationEntryInfo();
                    FullOrgUnitInfo company = new FullOrgUnitInfo();
                    EliminationInfo eliminfo = new EliminationInfo();
                    RPTItemInfo rpt = new RPTItemInfo();
                    eliminfo.setNumber(rowSet.getString("number"));
                    eliminfo.setId(BOSUuid.read((String)id));
                    rpt.setId(BOSUuid.read((String)rowSet.getString("ItemID")));
                    rpt.setDc(DebitOrCreditEnum.getEnum(rowSet.getInt("ItemDC")));
                    company.setId(BOSUuid.read((String)companyid));
                    company.setName(rowSet.getString("Companyname"));
                    company.setNumber(rowSet.getString("Companynumber"));
                    company.setLongNumber(rowSet.getString("CompanyLongNumber"));
                    if (!StringUtils.isEmpty((String)rowSet.getString("companyLongNumber2"))) {
                        company.put("companyLongNumber", (Object)rowSet.getString("companyLongNumber2"));
                    }
                    if (!StringUtils.isEmpty((String)rowSet.getString("profitLongNumber"))) {
                        company.put("profitLongNumber", (Object)rowSet.getString("profitLongNumber"));
                    }
                    if (!StringUtils.isEmpty((String)rowSet.getString("costLongNumber"))) {
                        company.put("costLongNumber", (Object)rowSet.getString("costLongNumber"));
                    }
                    if (companytoter.containsKey(id)) {
                        set2 = (HashSet)companytoter.get(id);
                        set2.add(company);
                    } else {
                        set2 = new HashSet();
                        set2.add(company);
                        companytoter.put(id, set2);
                    }
                    info.setId(BOSUuid.read((String)entryid));
                    info.setCompany(company);
                    info.setItem(rpt);
                    info.setElimination(eliminfo);
                    info.setDataElement(rowSet.getInt("fdataElement"));
                    info.setSeq(rowSet.getInt("entryseq"));
                    info.setDebit(rowSet.getBigDecimal("Debit"));
                    info.setCredit(rowSet.getBigDecimal("Credit"));
                    entrytovalue.put(entryid, info);
                    continue;
                }
                FullOrgUnitInfo company = new FullOrgUnitInfo();
                company.setId(BOSUuid.read((String)companyid));
                company.setName(rowSet.getString("Companyname"));
                company.setNumber(rowSet.getString("Companynumber"));
                company.setLongNumber(rowSet.getString("CompanyLongNumber"));
                if (!StringUtils.isEmpty((String)rowSet.getString("companyLongNumber2"))) {
                    company.put("companyLongNumber", (Object)rowSet.getString("companyLongNumber2"));
                }
                if (!StringUtils.isEmpty((String)rowSet.getString("profitLongNumber"))) {
                    company.put("profitLongNumber", (Object)rowSet.getString("profitLongNumber"));
                }
                if (!StringUtils.isEmpty((String)rowSet.getString("costLongNumber"))) {
                    company.put("costLongNumber", (Object)rowSet.getString("costLongNumber"));
                }
                if (companytoter.containsKey(id)) {
                    set = (HashSet)companytoter.get(id);
                    set.add(company);
                    continue;
                }
                set = new HashSet();
                set.add(company);
                companytoter.put(id, set);
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        finally {
            if (service != null && !DebugLogger.isDebug) {
                service.release();
            }
        }
        HashMap compareMap = new HashMap();
        for (int i = 0; i < elimTypes.length; ++i) {
            if (!ElimTypeEnum.ComeAndGo.equals((Object)elimTypes[i]) && !ElimTypeEnum.exchange.equals((Object)elimTypes[i])) continue;
            compareMap.putAll(this.getElimCompareInfo(ctx, (Map)elimIdMap, elimTypes[i], cslParams));
        }
        HashMap<String, Object> buildParams = new HashMap<String, Object>();
        buildParams.put("entry2value", entrytovalue);
        buildParams.put("asstActTypeNumbers", asstActTypeNumbers);
        buildParams.put("item2dynaitem", itemtodynaitem);
        buildParams.put("company2ter", companytoter);
        buildParams.put("compareMap", compareMap);
        buildParams.put("entryids", entryids);
        buildParams.put("rowmap", rowmap);
        buildParams.put("KEY_CUR_ORGBOUND_ID", cslParams.get("KEY_CUR_ORGBOUND_ID"));
        buildParams.put("KEY_CUR_ORGBOUNDGROUP_ID", cslParams.get("KEY_CUR_ORGBOUNDGROUP_ID"));
        Set set = this.buildElimDynaItemEntry(ctx, buildParams);
        return set;
    }

    private Map getElimCompareInfo(Context ctx, Map elimIdMap, ElimTypeEnum elimType, Map cslParams) {
        SQLBuilder builder = new SQLBuilder();
        int NO_WAY = 0;
        int ONE_WAY = 1;
        int TWO_WAY = 2;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Object dataSource : elimIdMap.keySet()) {
            boolean isCheckPlatForm = 1 == (Integer)dataSource;
            List elimIdList = (List)elimIdMap.get(dataSource);
            String checkageTabName = "t_csl_interdatacheckage";
            String checkEntryTabName = "t_csl_datacheckageentry";
            if (ElimTypeEnum.exchange.equals((Object)elimType)) {
                checkageTabName = "t_csl_exchcheckage";
                checkEntryTabName = "t_csl_exchcheckageentry";
            }
            builder.reset();
            builder.append("select distinct entry.FCOMPANYID as comapnyId, entry.FTARGETCOMPANYID as targetCompanyId, elim.fid as elimId, elim.fnumber from t_csl_elimination elim ");
            if (isCheckPlatForm) {
                builder.append(" inner join t_csl_eliminationentry elimEntry on elim.fid = elimEntry.FELIMINATIONID ");
                builder.append(" inner join t_csl_checkagebillrelatelim rela on elimentry.fid=rela.FElimEntryId ");
                builder.append(" inner join t_csl_checkagebill entry on entry.fid= rela.fcheckagebillid ");
                builder.append("where elim.fid in ( ");
                builder.append(CslRptUtil.changeIdList2String(elimIdList)).append(") ");
            } else {
                builder.append("join t_csl_elimrecord  rec on elim.fid = rec.FELIMINATIONID ");
                builder.append("join ").append(checkageTabName);
                builder.append("  checkage on checkage.fid = rec.FCHECKAGEDATAID ");
                builder.append("join ").append(checkEntryTabName);
                builder.append(" entry on entry.FCHECKAGEID  = checkage.fid ");
                builder.append("where elim.fid in ( ");
                builder.append(CslRptUtil.changeIdList2String(elimIdList)).append(") ");
                builder.append("and (entry.FVALICREDIT <>0 or entry.FVALIDEBIT <>0)");
            }
            builder.append("order by elim.fnumber ");
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)builder.toString());
                while (rowSet.next()) {
                    String comapnyId = rowSet.getString("comapnyId");
                    String targetCompanyId = rowSet.getString("targetCompanyId");
                    String elimId = rowSet.getString("elimId");
                    if (StringUtils.isEmpty((String)comapnyId) || StringUtils.isEmpty((String)targetCompanyId)) continue;
                    if (comapnyId.equals(targetCompanyId)) {
                        map.put(elimId, NO_WAY);
                        continue;
                    }
                    if (map.containsKey(elimId)) {
                        map.put(elimId, TWO_WAY);
                        continue;
                    }
                    map.put(elimId, ONE_WAY);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    private HashMap getNumberAcctHG(Context ctx, HashSet selectedItemNumber) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)selectedItemNumber, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("asstHGAttribute"));
        CoreBaseCollection coll = AsstActTypeFactory.getLocalInstance((Context)ctx).getCollection(view);
        HashMap<String, String> numberset = new HashMap<String, String>();
        for (int i = 0; i < coll.size(); ++i) {
            AsstActTypeInfo info = (AsstActTypeInfo)coll.get(i);
            String number = info.getNumber();
            String asstHGAttribute = info.getAsstHGAttribute();
            numberset.put(number, asstHGAttribute);
        }
        return numberset;
    }

    @Override
    protected Map _generateDynaItemElimByGivenElimType(Context ctx, Map paramsMap) throws BOSException, EASBizException {
        HashMap<String, Set> result = new HashMap<String, Set>();
        DynaItemElimEntryCondition condition = (DynaItemElimEntryCondition)paramsMap.get("queryCondition");
        Map<String, Object> rest = this.contructEntryIdToSequence(ctx, condition, paramsMap.get("isCheckPlatForm") == null ? null : Boolean.valueOf(this.isCheckPlatForm(paramsMap)));
        if (((List)rest.get("entryIDs")).size() > 0) {
            paramsMap = this.sugerMapParam(paramsMap, (Map)rest.get("rowMap"));
            Set successMsg = this._generateautodynamicElimination(ctx, (List)rest.get("entryIDs"), paramsMap);
            result.put("result", successMsg);
        }
        return result;
    }

    private boolean isCheckPlatForm(Map paramsMap) {
        boolean isCheckPlatForm = false;
        Object curObjct = paramsMap.get("isCheckPlatForm");
        if (curObjct != null) {
            isCheckPlatForm = (Boolean)curObjct;
        }
        return isCheckPlatForm;
    }

    private Map<Object, Object> sugerMapParam(Map paramsMap, Map<String, Integer> rowMap) {
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        DynaItemElimEntryCondition condition = (DynaItemElimEntryCondition)paramsMap.get("queryCondition");
        params.put("KEY_CUR_ORGBOUND_ID", condition.getTreeid());
        params.put("KEY_CUR_ORGBOUNDGROUP_ID", condition.getOrgUnitId());
        params.put("Year", new Integer(condition.getYear()));
        params.put("Period", new Integer(condition.getPeriod()));
        params.put("PeriodType", new Integer(condition.getPeriodType()));
        params.put("elimType", condition.getElimTypes());
        params.put("type", (Object)ElimTypeEnum.ComeAndGo);
        params.put("rowmap", rowMap);
        params.put("state", (Object)condition.getState());
        params.put("isCheckPlatForm", condition.isCheckPlatform());
        return params;
    }

    private Map<String, Object> contructEntryIdToSequence(Context ctx, DynaItemElimEntryCondition condition, Boolean isCheckPlatForm) throws BOSException, EASBizException {
        HashMap<String, Integer> rowMap = new HashMap<String, Integer>();
        ArrayList<String> entryIDs = new ArrayList<String>();
        HashMap<String, Object> rest = new HashMap<String, Object>();
        rest.put("entryIDs", entryIDs);
        rest.put("rowMap", rowMap);
        ElimTypeEnum[] elimTypeArr = condition.getElimTypes();
        if (elimTypeArr != null) {
            ParamTempTblService service = null;
            try {
                SQLBuilder builder = new SQLBuilder();
                builder.append(" SELECT entry.Fid,entry.Fseq From T_CSL_Elimination e \n").append(" JOIN T_CSL_EliminationEntry entry ON e.Fid = entry.fEliminationId \n").append(" JOIN T_ORG_Tree tree ON tree.FId = e.FOrgBoundId   \n").append(" JOIN T_ORG_BaseUnit unit ON unit.FId = e.ForgUnit  \n");
                if (condition.getElimIds() != null && !condition.getElimIds().isEmpty()) {
                    String inStr = null;
                    if (condition.getElimIds().size() > 30) {
                        service = ParamTempTblService.getDefaultInstance(ctx, condition.getElimIds(), null);
                        inStr = "select id from " + service.getTmpTableName();
                    } else {
                        inStr = CslRptUtil.collection2String(condition.getElimIds(), ",", true);
                    }
                    builder.append(" where e.fid in(").append(inStr).append(")");
                } else {
                    builder.append(" WHERE ").append(" tree.FId = ?", (Object)condition.getTreeid()).append(" AND unit.FId = ? ", (Object)condition.getOrgUnitId()).append(" AND e.Fyear = ? ", (Object)condition.getYear()).append(" AND e.FPeriod = ? ", (Object)condition.getPeriod()).append(" AND e.FPeriodType = ? ", (Object)condition.getPeriodType()).append(" AND e.FElimType in", (Object[])condition.getElimTypes());
                    if (condition.getState() != DynaItemElimEntryCondition.QueryAuditStatEnum.AllStat) {
                        builder.append(" AND e.FcheckedStatus = ? ", (Object)condition.getState().getVal());
                    }
                    if (isCheckPlatForm != null) {
                        builder.append(" and e.FElimDataSource=? ", (Object)(isCheckPlatForm != false ? 1 : 0));
                    }
                }
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)builder.getSQL(), (Object[])builder.getParams());
                while (rs.next()) {
                    rowMap.put(rs.getString(1), rs.getInt(2));
                    entryIDs.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                if (service != null && !DebugLogger.isDebug) {
                    service.release();
                }
            }
        }
        return rest;
    }

    @Override
    protected List _getExistDyItemEntryIds(Context ctx, String elimId) throws BOSException {
        ArrayList<String> elimEntryIds = new ArrayList<String>();
        StringBuffer sql = new StringBuffer("select dyEntry.FEliminationEntryID from t_csl_elimDynaItemEntry dyEntry ");
        sql.append("join t_csl_eliminationEntry elimEntry on dyEntry.FEliminationEntryID=elimEntry.fid ");
        sql.append("join t_csl_elimination elim on elimEntry.FEliminationID=elim.fid ");
        sql.append(" where elim.fid=?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{elimId});
        try {
            while (rs.next()) {
                String elimEntryId = rs.getString(1);
                if (elimEntryIds.contains(elimEntryId)) continue;
                elimEntryIds.add(elimEntryId);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return elimEntryIds;
    }

    @Override
    protected void _deleteDyItemByElimEntries(Context ctx, List elimEnties) throws BOSException {
        StringBuffer delSql = new StringBuffer("delete from t_csl_elimDynaItemEntry where FEliminationEntryID in (");
        String idsStr = this.getidsstring(elimEnties);
        delSql.append(idsStr);
        delSql.append(")");
        DbUtil.execute((Context)ctx, (String)delSql.toString());
    }
}

