/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationItemMapFactory;
import com.kingdee.eas.fi.gr.cslrpt.IEliminationItemMap;
import com.kingdee.eas.fi.gr.cslrpt.IsCitedByLaterEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractElimTempletControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.SundryException;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ElimTempletControllerBean
extends AbstractElimTempletControllerBean {
    @Override
    protected boolean _checkIsUsed(Context ctx, ElimTempletInfo templet) throws BOSException {
        return false;
    }

    protected boolean _checkLineExist(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return false;
    }

    protected SystemEnum _getOwnedSys(Context ctx) throws BOSException, EASBizException {
        return SystemEnum.CORPORATIONMANAGEMENT;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ElimTempletInfo info = (ElimTempletInfo)model;
        info.setCU(super.getCU(ctx, (ObjectBaseInfo)info));
        ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
        if (info.getElimType().equals((Object)ElimTypeEnum.General)) {
            this.addnewGnl(ctx);
        } else if (info.getElimType().equals((Object)ElimTypeEnum.ComeAndGo)) {
            this.addnewCAG(ctx);
        } else if (info.getElimType().equals((Object)ElimTypeEnum.exchange)) {
            this.addnewExchange(ctx);
        } else {
            this.addnewInvest(ctx);
        }
        this.addnewCheck(ctx, (ElimTempletInfo)model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ElimTempletInfo info = (ElimTempletInfo)model;
        info.setCU(super.getCU(ctx, (ObjectBaseInfo)info));
        ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
        if (info.getElimType().equals((Object)ElimTypeEnum.General)) {
            this.addnewGnl(ctx);
        } else if (info.getElimType().equals((Object)ElimTypeEnum.ComeAndGo)) {
            this.addnewCAG(ctx);
        } else if (info.getElimType().equals((Object)ElimTypeEnum.exchange)) {
            this.addnewExchange(ctx);
        } else {
            this.addnewInvest(ctx);
        }
        this.addnewCheck(ctx, (ElimTempletInfo)model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ElimTempletInfo info = (ElimTempletInfo)model;
        ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
        if (info.getElimType().equals((Object)ElimTypeEnum.General)) {
            this.updateGnl(ctx);
        } else if (info.getElimType().equals((Object)ElimTypeEnum.ComeAndGo)) {
            this.updateCAG(ctx);
        } else if (info.getElimType().equals((Object)ElimTypeEnum.exchange)) {
            this.updateExchange(ctx);
        } else {
            this.updateInvest(ctx);
        }
        this.updateCheck(ctx, pk, model);
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ElimTypeEnum elimType = this.getElimType(ctx, pk);
        ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
        if (elimType.equals((Object)ElimTypeEnum.General)) {
            this.updateGnl(ctx);
        } else if (elimType.equals((Object)ElimTypeEnum.ComeAndGo)) {
            this.updateCAG(ctx);
        } else if (elimType.equals((Object)ElimTypeEnum.exchange)) {
            this.updateExchange(ctx);
        } else {
            this.updateInvest(ctx);
        }
        this.deleteCheck(ctx, pk);
        IEliminationItemMap elimItemMap = EliminationItemMapFactory.getLocalInstance(ctx);
        elimItemMap.deleteALLElimItems(pk.toString());
        super._delete(ctx, pk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ElimTypeEnum getElimType(Context ctx, IObjectPK pk) throws BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("elimType");
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            ElimTypeEnum elimTypeEnum = ((ElimTempletInfo)this.getDAO(ctx, cn).getValue(pk, selector)).getElimType();
            return elimTypeEnum;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ElimTempletInfo info = (ElimTempletInfo)model;
        ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
        if (info.getElimType().equals((Object)ElimTypeEnum.General)) {
            this.passAuditGnl(ctx);
        } else if (info.getElimType().equals((Object)ElimTypeEnum.ComeAndGo)) {
            this.passAuditCAG(ctx);
        } else if (info.getElimType().equals((Object)ElimTypeEnum.exchange)) {
            this.passAuditExchange(ctx);
        } else {
            this.passAuditInvest(ctx);
        }
        this.passAuditLog(ctx, pk);
        super._passAudit(ctx, pk, model);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ElimTempletInfo info = (ElimTempletInfo)model;
        ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
        if (info.getElimType().equals((Object)ElimTypeEnum.General)) {
            this.unpassAuditGnl(ctx);
        } else if (info.getElimType().equals((Object)ElimTypeEnum.ComeAndGo)) {
            this.unpassAuditCAG(ctx);
        } else if (info.getElimType().equals((Object)ElimTypeEnum.exchange)) {
            this.unpassAuditExchange(ctx);
        } else {
            this.unpassAuditInvest(ctx);
        }
        this.unpassAuditLog(ctx, pk);
        super._unpassAudit(ctx, pk, model);
    }

    private void addnewCheck(Context ctx, ElimTempletInfo model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, null, (IObjectValue)model);
        this.checkRptItemBlankAndDup(ctx, (IObjectValue)model);
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ElimTempletInfo billBaseInfo = (ElimTempletInfo)model;
        EntityViewInfo view = this.buildIsNumExistView(billBaseInfo);
        ElimTempletCollection elimTempletCollection = this.getElimTempletCollection(ctx, view);
        if (elimTempletCollection.size() > 0) {
            ElimTempletInfo infoInDB = elimTempletCollection.get(0);
            throw new SundryException(SundryException.NUMEXISTINORG, new Object[]{infoInDB.getNumber(), infoInDB.getTrackRecordCreator().getName()});
        }
        return true;
    }

    private EntityViewInfo buildIsNumExistView(ElimTempletInfo billBaseInfo) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem1 = new FilterItemInfo("number", (Object)billBaseInfo.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem1);
        FilterItemInfo filterItem2 = new FilterItemInfo("elimType", (Object)new Integer(billBaseInfo.getElimType().getValue()), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem2);
        if (billBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)billBaseInfo.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.setMaskString("#0 and #1");
        }
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("trackRecordCreator.name"));
        coll.add(new SelectorItemInfo("number"));
        view.setFilter(filter);
        view.setSelector(coll);
        return view;
    }

    private void updateCheck(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, null, model);
        this.checkRptItemBlankAndDup(ctx, model);
    }

    private void deleteCheck(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        ElimTempletInfo info = this.getElimTempletInfo(ctx, pk);
        if (info.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
            throw new AdjustException(AdjustException.HAVE_AUDITED);
        }
    }

    private void checkRptItemBlankAndDup(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ElimTempletInfo info = (ElimTempletInfo)model;
        if (info.getEntries() != null && info.getEntries().size() > 0) {
            ElimTempletEntryCollection entry = info.getEntries();
            ArrayList<String> list = this.getRptItemOfGroup(ctx, info);
            if (list == null) {
                list = new ArrayList<String>();
            }
            String keyElim = "GR_CSL_AllowElimRRTM";
            Object value = CslRptUtil.getParamValue(ctx, null, keyElim);
            for (int i = 0; i < entry.size(); ++i) {
                ElimTempletEntryInfo lineInfo = entry.get(i);
                RPTItemInfo item = lineInfo.getItem();
                if (item != null && item.getNumber() != null) {
                    boolean isGeneral;
                    String itemNumber = item.getNumber();
                    String itemId = item.getId().toString();
                    int dateElement = lineInfo.getDataElement();
                    String key = itemId + "@@@" + dateElement;
                    boolean bl = isGeneral = info.getElimType().getValue() == 2;
                    if (("false".equals(value) || !isGeneral) && list.contains(key)) {
                        throw new AdjustException(AdjustException.ELIMCAG_RPTITEM_DUP, new Object[]{itemNumber, DataElementProvider.getDataElementName(ctx, dateElement)});
                    }
                    list.add(key);
                    continue;
                }
                if (item != null) continue;
                throw new AdjustException(AdjustException.RPTITEM_BLANK, new Object[]{new Integer(i + 1)});
            }
        }
    }

    private ArrayList getRptItemOfGroup(Context ctx, ElimTempletInfo info) throws BOSException {
        if (info.getElimGroup() != null) {
            String elimGroupId = info.getElimGroup().getId().toString();
            StringBuffer sbSQL = new StringBuffer(" SELECT DISTINCT b.FItemID, b.FDataElement \r\n");
            sbSQL.append(" FROM T_CSL_ElimTemplet a RIGHT OUTER JOIN  \r\n");
            sbSQL.append(" T_CSL_ElimTempletEntry b ON a.FID = b.FTempletID \r\n");
            sbSQL.append(" WHERE a.FElimGroupID = ?  \r\n");
            Object[] params = null;
            if (info.getId() != null) {
                sbSQL.append(" and a.fid != ? ");
                params = new Object[]{elimGroupId, info.getId().toString()};
            } else {
                params = new Object[]{elimGroupId};
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])params);
            ArrayList<String> itemIds = new ArrayList<String>();
            try {
                while (rs.next()) {
                    itemIds.add(rs.getString("FItemId") + "@@@" + rs.getInt("FDataElement"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            return itemIds;
        }
        return null;
    }

    @Override
    protected void _addnewGnl(Context ctx) throws BOSException {
    }

    @Override
    protected void _addnewCAG(Context ctx) throws BOSException {
    }

    @Override
    protected void _updateGnl(Context ctx) throws BOSException {
    }

    @Override
    protected void _updateCAG(Context ctx) throws BOSException {
    }

    @Override
    protected void _deleteGnl(Context ctx) throws BOSException {
    }

    @Override
    protected void _deleteCAG(Context ctx) throws BOSException {
    }

    @Override
    protected void _passAuditGnl(Context ctx) throws BOSException {
    }

    @Override
    protected void _passAuditCAG(Context ctx) throws BOSException {
    }

    @Override
    protected void _unpassAuditGnl(Context ctx) throws BOSException {
    }

    @Override
    protected void _unpassAuditCAG(Context ctx) throws BOSException {
    }

    @Override
    protected void _addnewExchange(Context ctx) throws BOSException {
    }

    @Override
    protected void _addnewInvest(Context ctx) throws BOSException {
    }

    @Override
    protected void _updateExchange(Context ctx) throws BOSException {
    }

    @Override
    protected void _updateInvest(Context ctx) throws BOSException {
    }

    @Override
    protected void _deleteExchange(Context ctx) throws BOSException {
    }

    @Override
    protected void _deleteInvest(Context ctx) throws BOSException {
    }

    @Override
    protected void _passAuditExchange(Context ctx) throws BOSException {
    }

    @Override
    protected void _passAuditInvest(Context ctx) throws BOSException {
    }

    @Override
    protected void _unpassAuditExchange(Context ctx) throws BOSException {
    }

    @Override
    protected void _unpassAuditInvest(Context ctx) throws BOSException {
    }

    @Override
    protected void _forbidCitedByLater(Context ctx, List list, IsCitedByLaterEnum isCited) throws BOSException, EASBizException {
        Iterator iter = list.iterator();
        ElimTempletInfo info = null;
        while (iter.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)iter.next().toString()));
            info = this.getElimTempletInfo(ctx, (IObjectPK)pk);
            info.setIsCitedByLater(isCited);
            this._update(ctx, (IObjectPK)pk, (IObjectValue)info);
        }
    }

    @Override
    protected void _passAuditLog(Context ctx, IObjectPK pk) throws BOSException {
    }

    @Override
    protected void _unpassAuditLog(Context ctx, IObjectPK pk) throws BOSException {
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ElimTempletInfo elimTempInfo = (ElimTempletInfo)model;
        String elimTemplateid = "";
        if (elimTempInfo.getId() != null) {
            elimTemplateid = elimTempInfo.getId().toString();
        }
        ElimTempletEntryCollection entryCollent = elimTempInfo.getEntries();
        ArrayList<String> itemList = new ArrayList<String>();
        ArrayList<String> itemNoDupList = new ArrayList<String>();
        boolean isItemDup = false;
        for (int i = 0; i < entryCollent.size(); ++i) {
            ElimTempletEntryInfo lineInfo = entryCollent.get(i);
            RPTItemInfo item = lineInfo.getItem();
            DataSrcTypeEnum srcType = lineInfo.getDataSrcType();
            if (srcType != null && srcType.getValue() == 2 && item != null && !"".equals(elimTemplateid)) {
                StringBuffer dcSql = new StringBuffer();
                dcSql.append("select fid  from T_CSL_EliminationItemMap");
                dcSql.append(" where FElimTempleID='").append(elimTemplateid).append("'");
                dcSql.append(" and ( FSelfRptItemID='").append(item.getId().toString()).append("'");
                dcSql.append(" or FOtherRptItemID='").append(item.getId().toString()).append("'");
                dcSql.append(")");
                IRowSet rs = null;
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)dcSql.toString());
                    if (rs.next()) {
                        throw new AdjustException(AdjustException.ELIMITEMDATASRCISDIFF);
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
            if (item == null || item.getNumber() == null) continue;
            String itemId = item.getId().toString();
            if (itemList.contains(itemId)) {
                isItemDup = true;
                itemNoDupList.add(itemId);
                continue;
            }
            itemList.add(itemId);
        }
        if (!"".equals(elimTemplateid) && itemNoDupList.size() > 0 && isItemDup) {
            StringBuffer listToString = new StringBuffer();
            for (int i = 0; i < itemNoDupList.size(); ++i) {
                if (i == itemNoDupList.size() - 1) {
                    listToString.append("'").append(itemNoDupList.get(i)).append("'");
                    continue;
                }
                listToString.append("'").append(itemNoDupList.get(i)).append("'").append(",");
            }
            StringBuffer dcSql = new StringBuffer();
            dcSql.append("select fid  from T_CSL_EliminationItemMap");
            dcSql.append(" where FElimTempleID='").append(elimTemplateid).append("'");
            dcSql.append(" and ( FSelfRptItemID in (").append(listToString).append(")");
            dcSql.append(" or FOtherRptItemID in (").append(listToString).append(")");
            dcSql.append(")");
            IRowSet rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)dcSql.toString());
                if (rs.next() && isItemDup) {
                    throw new AdjustException(AdjustException.ELIMITEMDUPANDMAP);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        IObjectPK pk = super._submit(ctx, model);
        IEliminationItemMap elimItemMap = EliminationItemMapFactory.getLocalInstance(ctx);
        elimItemMap.deleteNoExistItemMap(pk.toString(), itemList);
        return pk;
    }

    @Override
    protected ElimTempletCollection _getElimTemplateByTreeAndCompany(Context ctx, String companyId, String orgTreeId, int sourceType, int checkedStatus, int elimType) throws BOSException {
        StringBuffer sql = new StringBuffer("select distinct elimTemp.fid id,elimTemp.fnumber number,elimTemp.fname");
        sql.append(" name from T_CSL_ElimTemplet elimTemp join T_CSL_TempletDispense dispense on ");
        sql.append(" elimTemp.FElimGroupID=dispense.FDispenseSrcID ");
        sql.append(" and dispense.FCompanyID='").append(companyId).append("' ");
        sql.append(" and dispense.FOrgBoundID='").append(orgTreeId).append("' ");
        sql.append(" and dispense.FSourceType=").append(sourceType);
        sql.append(" where elimTemp.FCheckedStatus=").append(checkedStatus);
        sql.append(" and elimTemp.FElimType=").append(elimType);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ElimTempletCollection elimTempletCollection = new ElimTempletCollection();
        try {
            while (rs.next()) {
                ElimTempletInfo info = new ElimTempletInfo();
                info.setId(BOSUuid.read((String)rs.getString("id")));
                info.setName(rs.getString("name"));
                info.setNumber(rs.getString("number"));
                elimTempletCollection.add(info);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return elimTempletCollection;
    }
}

