/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorResultProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.framework.cache.service.ehcache.MapCacheUtil;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AcctItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.ArchivedStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CopyCSLHisDataResultStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.DebitOrCreditEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimDataSourceEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimDynaItemEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimDynaItemEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimImportBasicTreeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimRelaOrgTreeCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimRelaOrgTreeFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimRelaOrgTreeInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.HandleModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.IElimRelaOrgTree;
import com.kingdee.eas.fi.gr.cslrpt.IElimTemplet;
import com.kingdee.eas.fi.gr.cslrpt.IElimination;
import com.kingdee.eas.fi.gr.cslrpt.IInterCheck;
import com.kingdee.eas.fi.gr.cslrpt.InterCheckFactory;
import com.kingdee.eas.fi.gr.cslrpt.IsCitedByLaterEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTEffectItemEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemControlEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.RptItemRelationshipFactory;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractEliminationControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.app.CslElimUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.EliminateUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslOrgTreeUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.gr.fast.FastMergeExecSelector;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateTypeInfo;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EliminationControllerBean
extends AbstractEliminationControllerBean {
    private static final long serialVersionUID = 71871466017911649L;
    private boolean hasCodeRule = false;
    private Book book = null;
    private static final String SPLIT = "!";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.EliminationControllerBean");

    private void initCodeRule(Context ctx) throws EASBizException, BOSException {
        this.hasCodeRule = CSLServerHelper.isHasCodingRuleByOrg(ctx, (IObjectValue)new EliminationInfo(), CSLServerHelper.getRootOrgIDForRootCU(ctx));
    }

    protected boolean _checkLineExist(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return false;
    }

    protected SystemEnum _getOwnedSys(Context ctx) throws BOSException, EASBizException {
        return SystemEnum.CORPORATIONMANAGEMENT;
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk, IObjectValue eliminationInfo, IObjectPK userPK) throws EASBizException, BOSException {
        EliminationInfo info = (EliminationInfo)eliminationInfo;
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (info.getElimType().equals((Object)ElimTypeEnum.General)) {
            this.auditHand(ctx);
        } else {
            this.auditAuto(ctx);
        }
        this.auditLog(ctx, (IObjectValue)info);
        if (info.getId() == null || !this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))) {
            throw new AdjustException(AdjustException.ELIMINATION_NOT_EXIST);
        }
        info.setAuditor(user);
        info.setAuditDate(new Timestamp(System.currentTimeMillis()));
        this._passAudit(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk, IObjectValue eliminationInfo, IObjectPK userPK) throws EASBizException, BOSException {
        EliminationInfo info = (EliminationInfo)eliminationInfo;
        if (info.getElimType().equals((Object)ElimTypeEnum.General)) {
            this.unAuditHand(ctx);
        } else {
            this.unAuditAuto(ctx);
        }
        this.unAuditLog(ctx, (IObjectValue)info);
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from t_csl_elimination where fsrccopyelimid = ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pk.toString()});
        if (rs.size() > 0) {
            throw new AdjustException(new NumericExceptionSubItem("wk001", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.AdjElimCtrlResource", (String)"Had_LaterData", (Locale)ctx.getLocale())));
        }
        info.setAuditor(null);
        info.setAuditDate(null);
        this._unpassAudit(ctx, pk, (IObjectValue)info);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, (EliminationInfo)model);
        this.doSpecialRptItem(ctx, model);
        this.setInvAndTargetCompanyEntryInfo((EliminationInfo)model);
        this.handleAmountPrecision(ctx, model);
        return super._addnew(ctx, model);
    }

    private void handleAmountPrecision(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EliminationEntryCollection entryCol;
        if (model == null) {
            return;
        }
        EliminationInfo info = (EliminationInfo)model;
        int precision = 2;
        if (info.getCurrency() != null) {
            CurrencyInfo currencyInfo;
            if (info.getCurrency().getPrecision() > 0) {
                precision = info.getCurrency().getPrecision();
            } else if (info.getCurrency().getId() != null && (currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectStringPK(info.getCurrency().getId().toString()))) != null) {
                precision = currencyInfo.getPrecision();
            }
        }
        if ((entryCol = info.getEntries()) == null || entryCol.size() == 0) {
            return;
        }
        Iterator it = entryCol.iterator();
        while (it.hasNext()) {
            EliminationEntryInfo entryInfo = (EliminationEntryInfo)it.next();
            this.handleAmountPrecisionForEntry(entryInfo, precision);
        }
    }

    private void handleAmountPrecisionForEntry(EliminationEntryInfo entryInfo, int precision) {
        BigDecimal Zero = new BigDecimal("0");
        BigDecimal Debit = null;
        BigDecimal Credit = null;
        Debit = entryInfo.getDebit();
        Credit = entryInfo.getCredit();
        if (Debit != null && !Debit.equals(Zero)) {
            Debit = Debit.setScale(precision, 4);
            entryInfo.setDebit(Debit);
        }
        if (Credit != null && !Credit.equals(Zero)) {
            Credit = Credit.setScale(precision, 4);
            entryInfo.setCredit(Credit);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateCheck(ctx, pk, model);
        this.updateHandleMode(ctx, model);
        this.handleAmountPrecision(ctx, model);
        super._update(ctx, pk, model);
    }

    private void updateHandleMode(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EliminationInfo info = (EliminationInfo)model;
        boolean isDiff = false;
        if (info.getSrcCopyElim() != null) {
            int preSize;
            ArrayList<String> entries = new ArrayList<String>();
            StringBuffer en = new StringBuffer();
            String currency = info.getCurrency().getId().toString();
            String SrcCurrency = info.getSourceCurrency().getId().toString();
            if (info.getEntries() != null && info.getEntries().size() > 0) {
                EliminationEntryCollection entry = info.getEntries();
                EliminationEntryInfo lineInfo = null;
                for (int i = 0; i < entry.size(); ++i) {
                    en = new StringBuffer();
                    lineInfo = entry.get(i);
                    String company = null;
                    if (lineInfo.getCompany() != null && lineInfo.getCompany().getId() != null) {
                        company = lineInfo.getCompany().getId().toString();
                    }
                    String summary = lineInfo.getSummary();
                    String Item = lineInfo.getItem().getId().toString();
                    String dataElement = String.valueOf(lineInfo.getDataElement());
                    String debit = null;
                    String credit = null;
                    if (lineInfo.getDebit() != null) {
                        debit = lineInfo.getDebit().toString();
                    }
                    if (lineInfo.getCredit() != null) {
                        credit = lineInfo.getCredit().toString();
                    }
                    en.append(currency + "_" + SrcCurrency + "_" + company + "_" + summary + "_" + Item + "_" + dataElement + "_" + debit + "_" + credit);
                    entries.add(en.toString());
                }
            }
            ArrayList<String> preEntries = new ArrayList<String>();
            StringBuffer preEn = new StringBuffer();
            String srcCopyElimId = info.getSrcCopyElim().getId().toString();
            StringBuffer querySql = new StringBuffer();
            querySql.append("select elim.fcurrencyid,elim.fsourcecurrencyid,en.fcompanyid,en.fsummary,en.fitemid,en.fdataelement,en.fdebit,en.fcredit \n");
            querySql.append("  from t_csl_eliminationentry en \n");
            querySql.append("  inner join t_csl_elimination elim on elim.fid = en.feliminationid \n");
            querySql.append(" where elim.fid = '").append(srcCopyElimId).append("' \n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            try {
                while (rs.next()) {
                    preEn = new StringBuffer();
                    preEn.append(rs.getString(1) + "_");
                    preEn.append(rs.getString(2) + "_");
                    preEn.append(rs.getString(3) + "_");
                    preEn.append(rs.getString(4) + "_");
                    preEn.append(rs.getString(5) + "_");
                    preEn.append(rs.getString(6) + "_");
                    preEn.append(rs.getString(7) + "_");
                    preEn.append(rs.getString(8));
                    preEntries.add(preEn.toString());
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            int size = entries.size();
            if (size != (preSize = preEntries.size())) {
                isDiff = true;
            } else {
                String temp = null;
                for (int i = 0; i < size; ++i) {
                    temp = (String)entries.get(i);
                    if (preEntries.contains(temp)) continue;
                    isDiff = true;
                    break;
                }
            }
        }
        if (isDiff) {
            info.setHandleMode(HandleModeEnum.MODIFY);
        }
    }

    private void addnewCheck(Context ctx, EliminationInfo model) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)model.getNumber())) {
            this.initCodeRule(ctx);
            if (!this.hasCodeRule) {
                this.checkNumberBlank(model);
            }
        } else if (model.getNumber().startsWith("AUTO_")) {
            this.initCodeRule(ctx);
            if (this.hasCodeRule) {
                throw new AdjustException(AdjustException.CODERULE_STARTWITH_AUTO);
            }
        }
        this._checkNumberDup(ctx, null, (IObjectValue)model);
        this.checkRptItemBlankAndDup(ctx, (IObjectValue)model);
        this.checkDebitEqlCredit(ctx, (IObjectValue)model);
    }

    private void updateCheck(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        EliminationInfo info = (EliminationInfo)model;
        if (StringUtils.isEmpty((String)info.getNumber())) {
            this.initCodeRule(ctx);
            if (!this.hasCodeRule) {
                this.checkNumberBlank(info);
            }
        }
        this._checkNumberDup(ctx, null, model);
        this.checkRptItemBlankAndDup(ctx, model);
        this.checkDebitEqlCredit(ctx, model);
    }

    private void deleteCheck(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        EliminationInfo info = this.getEliminationInfo(ctx, pk);
        if (info.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
            throw new AdjustException(AdjustException.HAVE_AUDITED);
        }
    }

    private void checkRptItemBlankAndDup(Context ctx, IObjectValue model) throws EASBizException {
        EliminationInfo info = (EliminationInfo)model;
        EliminationEntryCollection entry = info.getEntries();
        int entrySize = 0;
        if (entry != null) {
            entrySize = entry.size();
        }
        if (entry != null && entrySize > 0) {
            try {
                this.fixRptItemNumber(ctx, info);
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
            ArrayList<String> list = new ArrayList<String>(entrySize);
            EliminationEntryInfo lineInfo = null;
            RPTItemInfo item = null;
            FullOrgUnitInfo company = null;
            String itemNumber = null;
            String companyNumber = null;
            int dataElement = 0;
            String mixNumber = null;
            boolean isVisible = true;
            String keyElim = "GR_CSL_AllowElimRRTM";
            Object value = null;
            try {
                value = CslRptUtil.getParamValue(ctx, null, keyElim);
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
            for (int i = 0; i < entrySize; ++i) {
                lineInfo = entry.get(i);
                item = lineInfo.getItem();
                company = lineInfo.getCompany();
                isVisible = lineInfo.isIsVisible();
                if (item != null && item.getNumber() != null && company != null && company.getNumber() != null && isVisible) {
                    itemNumber = item.getNumber();
                    companyNumber = company.getNumber();
                    dataElement = lineInfo.getDataElement();
                    mixNumber = itemNumber + companyNumber + dataElement;
                    if ("false".equals(value) && list.contains(mixNumber)) {
                        ArrayList<String> exParam = new ArrayList<String>(3);
                        exParam.add(company.getName());
                        exParam.add(item.getNumber());
                        exParam.add(DataElementProvider.getDataElementName(ctx, lineInfo.getDataElement()));
                        throw new AdjustException(AdjustException.RPTITEMANDCOMPANY_DUP, exParam.toArray());
                    }
                    list.add(mixNumber);
                    continue;
                }
                if (item != null) continue;
                throw new AdjustException(AdjustException.RPTITEM_BLANK);
            }
        }
    }

    private boolean checkDebitEqlCredit(Context ctx, IObjectValue model) throws EASBizException {
        BigDecimal debitTotal = new BigDecimal("0");
        BigDecimal creditTotal = new BigDecimal("0");
        EliminationInfo info = (EliminationInfo)model;
        EliminationEntryCollection entry = info.getEntries();
        int entrySize = 0;
        if (entry != null) {
            entrySize = entry.size();
        }
        EliminationEntryInfo lineInfo = null;
        if (entry != null && entrySize > 0) {
            for (int i = 0; i < entrySize; ++i) {
                lineInfo = entry.get(i);
                String summary = lineInfo.getSummary();
                if (summary != null && summary.length() > 1000) {
                    throw new EASBizException(new NumericExceptionSubItem("001", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"92_AdjustControllerBean", (Locale)ctx.getOriginLocale())));
                }
                if (lineInfo.getDebit() != null && lineInfo.isIsVisible()) {
                    debitTotal = debitTotal.add(lineInfo.getDebit());
                }
                if (lineInfo.getCredit() == null || !lineInfo.isIsVisible()) continue;
                creditTotal = creditTotal.add(lineInfo.getCredit());
            }
            if (debitTotal.compareTo(creditTotal) != 0) {
                return false;
            }
        }
        return true;
    }

    private void doSpecialRptItem(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        int j;
        EliminationInfo info = (EliminationInfo)model;
        EliminationEntryCollection entry = info.getEntries();
        int entrySize = 0;
        if (entry != null) {
            entrySize = entry.size();
        }
        EliminationEntryInfo lineInfo = null;
        ArrayList<EliminationEntryInfo> list = new ArrayList<EliminationEntryInfo>();
        ArrayList<Object> comapanyList = new ArrayList<Object>();
        HashMap<BOSUuid, String> map = new HashMap<BOSUuid, String>();
        if (entry != null && entrySize > 0) {
            for (int i = 0; i < entrySize; ++i) {
                lineInfo = entry.get(i);
                if (!lineInfo.isIsVisible()) {
                    list.add(lineInfo);
                }
                if (lineInfo.getCompany() != null && lineInfo.getCompany().getId() != null && !map.containsKey(lineInfo.getCompany().getId())) {
                    comapanyList.add(lineInfo.getCompany());
                    map.put(lineInfo.getCompany().getId(), "a");
                }
                if (lineInfo.getCompany() != null && lineInfo.getCompany().getId() != null || comapanyList.contains("")) continue;
                comapanyList.add("");
            }
        }
        int maxSeq = 1;
        int n = list.size();
        for (j = 0; j < n; ++j) {
            info.getEntries().removeObject((IObjectValue)((EliminationEntryInfo)list.get(j)));
            maxSeq = j + 2;
        }
        n = info.getEntries().size();
        for (j = 0; j < n; ++j) {
            info.getEntries().get(j).setSeq(j + 1);
        }
        if (info.getEntries().size() == 0) {
            throw new AdjustException(AdjustException.LINE_NOT_EXIST);
        }
        entry = info.getEntries();
        int seq = entry.size();
        List<EliminationEntryInfo> entryColl2 = this.doParentItems(ctx, info, true);
        RptItemRelationshipFactory.getLocalInstance(ctx).autoCreateRelationshipItems(info);
        List<EliminationEntryInfo> entryColl1 = this.doLostProfitItem(ctx, info, comapanyList);
        EliminationEntryCollection collection = info.getEntries();
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            EliminationEntryInfo eliminationEntryinfo = (EliminationEntryInfo)it.next();
            if (eliminationEntryinfo == null || eliminationEntryinfo.isIsVisible()) continue;
            entryColl1.add(eliminationEntryinfo);
            it.remove();
        }
        Collections.sort(entryColl1, new Comparator<EliminationEntryInfo>(){

            @Override
            public int compare(EliminationEntryInfo o1, EliminationEntryInfo o2) {
                if (o1.getCompany() == null && o2.getCompany() == null) {
                    return 0;
                }
                if (o1.getCompany() == null) {
                    return -1;
                }
                if (o2.getCompany() == null) {
                    return 1;
                }
                String v1 = o1.getCompany().getNumber();
                String v2 = o2.getCompany().getNumber();
                return v1 == null ? -1 : v1.compareTo(v2);
            }
        });
        for (int i = 0; i < entryColl1.size(); ++i) {
            EliminationEntryInfo enrtyInfo = entryColl1.get(i);
            enrtyInfo.setSeq(++seq);
            info.getEntries().add(enrtyInfo);
        }
    }

    private List<EliminationEntryInfo> doLostProfitItem(Context ctx, EliminationInfo info, ArrayList comapanyList) throws BOSException, EASBizException {
        int precision;
        EliminationEntryCollection entry = info.getEntries();
        ArrayList<EliminationEntryInfo> coll = new ArrayList<EliminationEntryInfo>();
        int entrySize = 0;
        if (entry != null) {
            entrySize = entry.size();
        }
        if ((precision = info.getCurrency().getPrecision()) == 0) {
            ObjectUuidPK pk = new ObjectUuidPK(info.getCurrency().getId());
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)pk);
            precision = currencyInfo.getPrecision();
        }
        HashMap<String, RPTItemInfo> itemMap = new HashMap<String, RPTItemInfo>();
        if (entry != null && entrySize > 0) {
            for (int j = 0; j < comapanyList.size(); ++j) {
                EliminationEntryInfo lineInfo;
                BigDecimal debitTotal = new BigDecimal("0");
                BigDecimal creditTotal = new BigDecimal("0");
                BigDecimal debitTotalOverSea = new BigDecimal("0");
                BigDecimal creditTotalOverSea = new BigDecimal("0");
                int maxSeqNumber = 0;
                for (int i = 0; i < entrySize; ++i) {
                    boolean isDoSpecialSummay;
                    lineInfo = entry.get(i);
                    String id = comapanyList.get(j).equals("") || ((FullOrgUnitInfo)comapanyList.get(j)).getId() == null ? "" : ((FullOrgUnitInfo)comapanyList.get(j)).getId().toString();
                    RPTItemInfo item = lineInfo.getItem();
                    String itemId = item.getId().toString();
                    if (itemMap.containsKey(itemId)) {
                        item = (RPTItemInfo)itemMap.get(itemId);
                    } else {
                        item = RPTItemFactory.getLocalInstance(ctx).getRPTItemInfo((IObjectPK)new ObjectStringPK(item.getId().toString()));
                        itemMap.put(itemId, item);
                    }
                    String summay = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AdjustBAutoCreate", (Locale)ctx.getOriginLocale()) + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"94_AdjustControllerBean", (Locale)ctx.getOriginLocale());
                    boolean bl = isDoSpecialSummay = lineInfo.getSummary() == null || !lineInfo.getSummary().startsWith(summay) && !lineInfo.getSummary().startsWith(summay + " *");
                    if (item.isIsProfitAndLosses() && lineInfo.getDataElement() == 3 && id.equals(lineInfo.getCompany() == null || lineInfo.getCompany().getId() == null ? "" : lineInfo.getCompany().getId().toString()) && isDoSpecialSummay && !lineInfo.getBoolean("isAutoCreateParentItem")) {
                        this.handleAmountPrecisionForEntry(lineInfo, precision);
                        if (RPTEffectItemEnum.UNSHARED_PROFIT.equals((Object)item.getEffectItem())) {
                            if (lineInfo.getDebit() != null) {
                                debitTotal = debitTotal.add(lineInfo.getDebit());
                            }
                            if (lineInfo.getCredit() != null) {
                                creditTotal = creditTotal.add(lineInfo.getCredit());
                            }
                        } else if (RPTEffectItemEnum.OVERSEAUNSHARED_PROFIT.equals((Object)item.getEffectItem())) {
                            if (lineInfo.getDebit() != null) {
                                debitTotalOverSea = debitTotalOverSea.add(lineInfo.getDebit());
                            }
                            if (lineInfo.getCredit() != null) {
                                creditTotalOverSea = creditTotalOverSea.add(lineInfo.getCredit());
                            }
                        }
                    }
                    if (lineInfo.getSeq() <= maxSeqNumber) continue;
                    maxSeqNumber = lineInfo.getSeq();
                }
                lineInfo = entry.get(entrySize - 1);
                ++maxSeqNumber;
                if (debitTotal.compareTo(creditTotal) != 0) {
                    EliminationEntryInfo enrtyInfo = this.addEliminationEntry(ctx, info, debitTotal, creditTotal, maxSeqNumber, j, comapanyList, false);
                    coll.add(enrtyInfo);
                }
                if (debitTotalOverSea.compareTo(creditTotalOverSea) == 0) continue;
                if (debitTotal.compareTo(creditTotal) != 0) {
                    ++maxSeqNumber;
                }
                EliminationEntryInfo enrtyInfo = this.addEliminationEntry(ctx, info, debitTotalOverSea, creditTotalOverSea, maxSeqNumber, j, comapanyList, true);
                coll.add(enrtyInfo);
            }
        }
        return coll;
    }

    private Map fixRptItemNumber(Context ctx, EliminationInfo eliminationInfo) throws BOSException {
        HashMap<String, String> idAndNumber = new HashMap<String, String>();
        StringBuffer ids = new StringBuffer();
        EliminationEntryCollection entries = eliminationInfo.getEntries();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            EliminationEntryInfo adjustEntry = (EliminationEntryInfo)iter.next();
            if (adjustEntry.getItem() == null) continue;
            String id = adjustEntry.getItem().getId().toString();
            if (ids.length() == 0) {
                ids.append("'").append(id).append("'");
                continue;
            }
            ids.append(",'").append(id).append("'");
        }
        if (ids.length() > 0) {
            StringBuffer querySql = new StringBuffer();
            querySql.append("select FID,FNumber from t_csl_RptItem").append("\r\n");
            querySql.append("where FID in(").append(ids.toString()).append(")");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            try {
                while (rowSet.next()) {
                    idAndNumber.put(rowSet.getString(1), rowSet.getString(2));
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (!idAndNumber.isEmpty()) {
            iter = entries.iterator();
            while (iter.hasNext()) {
                RPTItemInfo item = ((EliminationEntryInfo)iter.next()).getItem();
                if (item == null || StringUtils.isEmpty((String)item.getNumber())) continue;
                item.setNumber((String)idAndNumber.get(item.getId().toString()));
            }
        }
        return idAndNumber;
    }

    private List getParentNumbers(String number) {
        if (number.indexOf(46) == -1) {
            return null;
        }
        ArrayList<String> numbers = new ArrayList<String>();
        int end = number.length();
        while ((end = number.lastIndexOf(46, end)) > 0) {
            numbers.add(number.substring(0, end));
            --end;
        }
        return numbers;
    }

    private List<EliminationEntryInfo> doParentItems(Context ctx, EliminationInfo info, boolean reSetSeq) throws BOSException, EASBizException {
        ArrayList<EliminationEntryInfo> entryColl = new ArrayList<EliminationEntryInfo>();
        EliminationEntryCollection entries = info.getEntries();
        this.fixRptItemNumber(ctx, info);
        HashMap<String, EliminationEntryInfo> autoAdjustData = new HashMap<String, EliminationEntryInfo>();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            String number;
            EliminationEntryInfo entryInfo = (EliminationEntryInfo)iter.next();
            if (!entryInfo.isIsVisible() || (number = entryInfo.getItem().getNumber()) == null) continue;
            List parentNumbers = this.getParentNumbers(number);
            for (int index = 0; parentNumbers != null && index < parentNumbers.size(); ++index) {
                EliminationEntryInfo entry;
                String pnumber = (String)parentNumbers.get(index);
                RPTItemInfo parentItemInfo = RPTItemFactory.getLocalInstance(ctx).getRPTItemInfo("select * where number ='" + pnumber + "'");
                String key = pnumber + ", " + entryInfo.getDataElement();
                if (entryInfo.getCompany() != null) {
                    key = key + ", " + entryInfo.getCompany().getNumber();
                }
                if ((entry = (EliminationEntryInfo)autoAdjustData.get(key)) == null) {
                    entry = new EliminationEntryInfo();
                    entry.setElimination(entryInfo.getElimination());
                    entry.setItem(parentItemInfo);
                    entry.setSummary(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AdjustBAutoCreate", (Locale)ctx.getOriginLocale()) + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"94_AdjustControllerBean", (Locale)ctx.getOriginLocale()));
                    entry.setDataElement(entryInfo.getDataElement());
                    entry.setCompany(entryInfo.getCompany());
                    entry.setIsVisible(false);
                    autoAdjustData.put(key, entry);
                } else if (entry.getSummary().lastIndexOf(42) == -1) {
                    entry.setSummary(entry.getSummary() + " *");
                }
                if (entryInfo.getDebit() != null) {
                    if (entry.getDebit() == null) {
                        entry.setDebit(entryInfo.getDebit());
                    } else {
                        entry.setDebit(entry.getDebit().add(entryInfo.getDebit()));
                    }
                }
                if (entryInfo.getCredit() == null) continue;
                if (entry.getCredit() == null) {
                    entry.setCredit(entryInfo.getCredit());
                    continue;
                }
                entry.setCredit(entry.getCredit().add(entryInfo.getCredit()));
            }
        }
        int maxSeq = entries.size() + 1;
        for (Map.Entry entry : autoAdjustData.entrySet()) {
            EliminationEntryInfo eliminationEntry = (EliminationEntryInfo)entry.getValue();
            if (eliminationEntry.getDebit() != null && eliminationEntry.getCredit() != null) {
                if (eliminationEntry.getDebit().compareTo(eliminationEntry.getCredit()) > 0) {
                    eliminationEntry.setDebit(eliminationEntry.getDebit().subtract(eliminationEntry.getCredit()));
                    eliminationEntry.setCredit(null);
                } else {
                    if (eliminationEntry.getDebit().compareTo(eliminationEntry.getCredit()) >= 0) continue;
                    eliminationEntry.setCredit(eliminationEntry.getCredit().subtract(eliminationEntry.getDebit()));
                    eliminationEntry.setDebit(null);
                }
            }
            eliminationEntry.setSeq(maxSeq++);
            entries.add(eliminationEntry);
            if (reSetSeq) {
                entryColl.add(eliminationEntry);
                continue;
            }
            eliminationEntry.setSeq(maxSeq++);
        }
        autoAdjustData.clear();
        autoAdjustData = null;
        return entryColl;
    }

    private RPTItemInfo getUnAssignRptItemId(Context ctx, boolean isOverSea) throws BOSException, EASBizException {
        String ControlEnumAlias = "";
        int ControlEnumValues = 1;
        if (!isOverSea) {
            ControlEnumAlias = RPTItemControlEnum.UNSHARED_PROFIT.getAlias();
            ControlEnumValues = 27;
        } else {
            ControlEnumAlias = RPTItemControlEnum.OVERSEAUNSHARED_PROFIT.getAlias();
            ControlEnumValues = 28;
        }
        String oql = "SELECT id, number WHERE isFreezed = 0 and control = " + ControlEnumValues;
        RPTItemCollection items = RPTItemFactory.getLocalInstance(ctx).getRPTItemCollection(oql);
        if (items != null && items.size() > 0) {
            return items.get(0);
        }
        throw new AdjustException(AdjustException.UN_EXIST_UNSHARED_RPTITEM, new Object[]{ControlEnumAlias});
    }

    private RPTItemInfo getUnAllotRptItemId(Context ctx) throws BOSException, EASBizException {
        String oql = "SELECT id,number WHERE isFreezed = 0 and control = 10";
        RPTItemCollection items = RPTItemFactory.getLocalInstance(ctx).getRPTItemCollection(oql);
        if (items != null && items.size() > 0) {
            return items.get(0);
        }
        throw new AdjustException(AdjustException.UN_EXIST_UNSHARED_RPTITEM, new Object[]{RPTItemControlEnum.UNALLOTGAIN_SYEAR.getAlias()});
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        EliminationInfo info = (EliminationInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem0 = new FilterItemInfo("number", (Object)info.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem0);
        FilterItemInfo filterItem1 = new FilterItemInfo("orgBound.id", (Object)info.getOrgBound().getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem1);
        FilterItemInfo filterItem2 = new FilterItemInfo("periodType", (Object)new Integer(info.getPeriodType().getValue()), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem2);
        FilterItemInfo filterItem3 = new FilterItemInfo("year", (Object)new Integer(info.getYear()), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem3);
        FilterItemInfo filterItem4 = new FilterItemInfo("period", (Object)new Integer(info.getPeriod()), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem4);
        FilterItemInfo filterItem5 = new FilterItemInfo("orgUnit.id", (Object)info.getOrgUnit().getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem5);
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and #6 ");
        } else {
            filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 ");
        }
        boolean exist = this.exists(ctx, filter);
        if (exist) {
            throw new AdjustException(AdjustException.ELIMNUMBER_DUP, new Object[]{info.getNumber()});
        }
        return true;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String strOrgID;
        EliminationInfo info = (EliminationInfo)model;
        if (StringUtils.isEmpty((String)info.getNumber()) && (strOrgID = CSLServerHelper.getRootOrgIDForRootCU(ctx)) != null && CSLServerHelper.isHasCodingRuleByOrg(ctx, (IObjectValue)info, strOrgID)) {
            String number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)info, strOrgID);
            info.setNumber(number);
        }
        return super._save(ctx, (IObjectValue)info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String strOrgID;
        EliminationInfo info = (EliminationInfo)model;
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        if (StringUtils.isEmpty((String)info.getNumber()) && (strOrgID = CSLServerHelper.getRootOrgIDForRootCU(ctx)) != null && CSLServerHelper.isHasCodingRuleByOrg(ctx, (IObjectValue)info, strOrgID)) {
            String number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)info, strOrgID);
            info.setNumber(number);
        }
        if (info.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))) {
            this.doSpecialRptItem(ctx, model);
        }
        this.setInvAndTargetCompanyEntryInfo(info);
        return super._submit(ctx, (IObjectValue)info);
    }

    public Result submit(Context ctx, CoreBaseCollection colls) throws BOSException, EASBizException {
        Result rt = null;
        try {
            NewRptUtil.catchItemRelationshipMap((Context)ctx, (int)3);
            rt = super.submit(ctx, colls);
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            NewRptUtil.clearItemRelationshipMapCatch((int)3);
        }
        return rt;
    }

    private void setInvAndTargetCompanyEntryInfo(EliminationInfo info) {
        if (info != null && (ElimTypeEnum.Main_Invest_New.equals((Object)info.getElimType()) || ElimTypeEnum.HK_COST.equals((Object)info.getElimType()) || ElimTypeEnum.MAIN_COST.equals((Object)info.getElimType()) || ElimTypeEnum.MAIN_INVEST.equals((Object)info.getElimType()) || ElimTypeEnum.General.equals((Object)info.getElimType()))) {
            EliminationEntryInfo entryInfo = this.getInvAndTargetCompanyEntryInfo(info);
            if (entryInfo == null) {
                return;
            }
            for (int i = 0; i < info.getEntries().size(); ++i) {
                EliminationEntryInfo eliminationEntryInfo = info.getEntries().get(i);
                if (eliminationEntryInfo.getInvCompany() == null && entryInfo.getInvCompany() != null) {
                    eliminationEntryInfo.setInvCompany(entryInfo.getInvCompany());
                }
                if (eliminationEntryInfo.getTargetCompany() != null || entryInfo.getTargetCompany() == null) continue;
                eliminationEntryInfo.setTargetCompany(entryInfo.getTargetCompany());
            }
        }
    }

    private EliminationEntryInfo getInvAndTargetCompanyEntryInfo(EliminationInfo info) {
        EliminationEntryInfo entryInfo = null;
        for (int i = 0; i < info.getEntries().size(); ++i) {
            entryInfo = info.getEntries().get(i);
            if (entryInfo.getInvCompany() == null && entryInfo.getTargetCompany() == null) continue;
            return entryInfo;
        }
        return null;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EliminationInfo info = this.getEliminationInfo(ctx, pk, this.getSelectors());
        if (info.getElimType().equals((Object)ElimTypeEnum.General)) {
            this.deleteHand(ctx);
        } else {
            this.deleteAuto(ctx);
        }
        this.deleteCheck(ctx, pk);
        String strOrgID = CSLServerHelper.getRootOrgIDForRootCU(ctx);
        this.initCodeRule(ctx);
        if (this.hasCodeRule && strOrgID != null && CodingRuleManagerFactory.getLocalInstance((Context)ctx).isUseIntermitNumber((IObjectValue)info, strOrgID)) {
            CodingRuleManagerFactory.getLocalInstance((Context)ctx).recycleNumber((IObjectValue)info, strOrgID, info.getNumber());
        }
        IInterCheck iInterCheck = InterCheckFactory.getLocalInstance(ctx);
        iInterCheck.deleteElimRecord(pk.toString());
        ElimDynaItemEntryFactory.getLocalInstance(ctx).deleteDyItemsByElimId(pk.toString());
        AccountCheckUtil.deleteElimCheckageBillLink((Context)ctx, (String)("'" + pk.toString() + "'"));
        super._delete(ctx, pk);
        this.deleteElimRelaOrgTree(ctx, info);
    }

    private void deleteElimRelaOrgTree(Context ctx, EliminationInfo info) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_CSL_ElimRelaOrgTree where FCurrentElimId ='").append(info.getId().toString()).append("'");
        sql.append(" and FOrgTreeId ='").append(info.getOrgBound().getId().toString()).append("'");
        sql.append(" and (FRecordType=").append(1);
        sql.append(" or FRecordType = ").append(3);
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entries.debit"));
        sic.add(new SelectorItemInfo("entries.credit"));
        sic.add(new SelectorItemInfo("entries.summary"));
        sic.add(new SelectorItemInfo("entries.item"));
        sic.add(new SelectorItemInfo("entries.item.name"));
        sic.add(new SelectorItemInfo("entries.company.name"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("valueType"));
        sic.add(new SelectorItemInfo("date"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("dataElement"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("entries.item.*"));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("CheckedStatus"));
        sic.add(new SelectorItemInfo("archivedStatus"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("orgBound.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("elimType"));
        return sic;
    }

    private SelectorItemCollection getSelectors1() {
        return new FastMergeExecSelector().getElimSelectors();
    }

    private void checkNumberBlank(EliminationInfo info) throws EASBizException {
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new AdjustException(AdjustException.NUMBER_CANNOT_BLANK);
        }
    }

    @Override
    protected void _deleteHand(Context ctx) throws BOSException {
    }

    @Override
    protected void _deleteAuto(Context ctx) throws BOSException {
    }

    @Override
    protected void _auditHand(Context ctx) throws BOSException {
    }

    @Override
    protected void _auditAuto(Context ctx) throws BOSException {
    }

    @Override
    protected void _unAuditHand(Context ctx) throws BOSException {
    }

    @Override
    protected void _unAuditAuto(Context ctx) throws BOSException {
    }

    @Override
    protected void _submitWF(Context ctx, IObjectPK pk) throws BOSException {
    }

    private String getCurrentMaxNumber(Context ctx, String orgTreeId, int periodType, int year, int period, String tableName) throws BOSException {
        BigDecimal number = new BigDecimal("0");
        StringBuffer sbSQL = new StringBuffer(" SELECT Replace(fnumber,'AUTO_','') As Fnumber From \r\n");
        sbSQL.append(tableName).append(" a  \r\n");
        sbSQL.append("  WHERE a.fOrgBoundId = '").append(orgTreeId).append("' \r\n");
        sbSQL.append("  and a.fyear = ").append(year).append(" \r\n");
        sbSQL.append("  and a.fperiod = ").append(period).append(" \r\n");
        sbSQL.append("  and a.fperiodType = ").append(periodType).append(" \r\n");
        sbSQL.append("  and a.fNumber like 'AUTO\\_%' escape '\\' \r\n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            String tempNumber = "";
            BigDecimal curNumber = null;
            while (rs.next()) {
                tempNumber = rs.getString("Fnumber");
                if (StringUtils.isEmpty((String)tempNumber) || !tempNumber.matches("[0-9]{" + tempNumber.length() + "}") || number.compareTo(curNumber = new BigDecimal(tempNumber)) >= 0) continue;
                number = curNumber;
            }
            if (number != null) {
                number = number.add(new BigDecimal("1"));
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        StringBuffer ret = new StringBuffer("AUTO_");
        int n = 8 - number.toString().length();
        for (int i = 0; i < n; ++i) {
            ret.append("0");
        }
        ret.append(number);
        return ret.toString();
    }

    private boolean generateElimForCodingRule(Context ctx, int year, int period, OrgTreeInfo orgTreeInfo, OrgUnitInfo orgUnitInfo) throws BOSException, EASBizException {
        EliminationInfo elim = new EliminationInfo();
        elim.setOrgBound(orgTreeInfo);
        elim.setOrgUnit(orgUnitInfo);
        return CSLServerHelper.isHasCodingRuleByOrg(ctx, (IObjectValue)elim, CSLServerHelper.getRootOrgIDForRootCU(ctx));
    }

    @Override
    protected Map _copyHisData(Context ctx, RptProperties params) throws BOSException, EASBizException {
        BOSObjectType bosType = new ElimDynaItemEntryInfo().getBOSType();
        HashMap entryIds = new HashMap();
        int periodType = params.getInt("periodType");
        int year = params.getInt("year");
        int period = params.getInt("period");
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        Timestamp time = new Timestamp(System.currentTimeMillis());
        int resultStatus = 0;
        if (params.getObject("resultStatus") != null) {
            resultStatus = ((CopyCSLHisDataResultStatusEnum)((Object)params.getObject("resultStatus"))).getValue();
        }
        Map toCopyNewUnit = (Map)params.getObject("toCopyNewUnit");
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)params.getObject("KEY_ORGTREE_INFO");
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)params.getObject("KEY_ORGUNIT_INFO");
        boolean isSynBasicScopeData = params.getBoolean("isSynBasicScopeData");
        boolean isByOrdinal = params.getBoolean("isByOrdinal");
        boolean isBasic = "yes".equals(params.getObject("basic"));
        String displayTypeId = params.getString("displayTypeId");
        ElimImportBasicTreeEnum elimImportbasicType = (ElimImportBasicTreeEnum)((Object)params.getObject("elimImportbasicType"));
        boolean isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod(ctx);
        PeriodCollection periods = null;
        if (this.isMergeByFiscalPeriod(isMergeByFiscalPeriod, RptPeriodTypeEnum.getEnum((int)periodType))) {
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, orgTreeInfo);
        }
        boolean hasCodeRule = this.generateElimForCodingRule(ctx, year, period, orgTreeInfo, orgUnitInfo);
        ArrayList<EliminationInfo> oldInfoList = new ArrayList<EliminationInfo>();
        ArrayList list = (ArrayList)params.getObject("list");
        List companyIds = (List)params.getObject("companyIds");
        boolean isSunElimination = params.getBoolean("isSunElimination");
        boolean isImport = params.getBoolean("isImport");
        ElimRelaOrgTreeCollection elimRelaCol = (ElimRelaOrgTreeCollection)((Object)params.getObject("elimRelaCol"));
        RPTItemInfo unAllotGainYearItem = null;
        Map mapAdjust = null;
        Map mapAllLongNumbers = null;
        Map mapElimIdLongNumbers = null;
        if (!isSunElimination && isImport) {
            mapAdjust = this.getMapElimination(ctx, list, params);
        } else if (isSynBasicScopeData) {
            ArrayList targetList = (ArrayList)params.getObject("targetEliminationIds");
            mapAdjust = this.getMapElimination(ctx, targetList, params);
        }
        if (!isSunElimination && isImport || isSynBasicScopeData) {
            this.deleteBatchData(ctx, (IObjectPK[])mapAdjust.get("deletePks"));
            mapAllLongNumbers = this.getAllLongNumberByOrgBound(ctx, params);
            mapElimIdLongNumbers = this.getLongNumberByElimID(ctx, list, params);
        }
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        EliminationCollection eliminationCollection = this.getSourceEliminationCollection(ctx, list);
        ArrayList currencyList = new ArrayList();
        boolean bResult = true;
        String strLongNumber = null;
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        ArrayList<String> listResult = new ArrayList<String>();
        Object oParamValue = this.getParamValue(ctx);
        int iSize = eliminationCollection.size();
        for (int j = 0; j < iSize; ++j) {
            EliminationInfo info = eliminationCollection.get(j);
            bResult = this.multiElimInfo(ctx, info, params, companyIds, currencyList, unAllotGainYearItem, bResult, oParamValue);
            if ((!isSunElimination && isImport || isSynBasicScopeData) && elimImportbasicType.equals((Object)ElimImportBasicTreeEnum.AllCompanyInOrgnizeImport) && isByOrdinal) {
                strLongNumber = this.getCommonLongNumber(info, mapElimIdLongNumbers);
                bResult = this.setOrgUnitFromMap(info, mapAllLongNumbers, strLongNumber, bResult);
            } else if ((!isSunElimination && isImport || isSynBasicScopeData) && elimImportbasicType.equals((Object)ElimImportBasicTreeEnum.RelatedCompanyImport) && isByOrdinal) {
                this.addEliminationInfo(info, mapElimIdLongNumbers, mapAllLongNumbers, bResult, oldInfoList);
                bResult = false;
            }
            if (bResult) {
                oldInfoList.add(info);
                listResult.add(info.getNumber());
            }
            bResult = true;
        }
        ArrayList newInfoList = new ArrayList(oldInfoList.size());
        HashMap map = new HashMap();
        if (isSunElimination) {
            newInfoList = this.doSumEliminationByCurrency(ctx, oldInfoList, currencyList, isImport, map);
        } else {
            this.doGenerationElimInfo(newInfoList, oldInfoList, params, user, time, orgUnitInfo, bosType, entryIds, resultStatus, toCopyNewUnit);
        }
        StringBuffer msg = new StringBuffer();
        IElimination ielimination = EliminationFactory.getLocalInstance(ctx);
        String[] numbers = null;
        ArrayList<String> codeRuleNumbers = new ArrayList<String>();
        if (isImport && hasCodeRule) {
            HashMap<String, Object> mapParams = new HashMap<String, Object>(5);
            mapParams.put("KEY_ORGTREE_INFO", orgTreeInfo);
            mapParams.put("KEY_ORGUNIT_INFO", orgUnitInfo);
            mapParams.put("Year", year);
            mapParams.put("Period", period);
            mapParams.put("PeriodType", periodType);
            numbers = CslElimUtil.getBatchNumber(ctx, mapParams, newInfoList.size());
            codeRuleNumbers.addAll(Arrays.asList(numbers));
        }
        TemplateTypeInfo newTemplateTypeInfo = null;
        if (!StringUtils.isEmpty((String)displayTypeId)) {
            newTemplateTypeInfo = new TemplateTypeInfo();
            newTemplateTypeInfo.setId(BOSUuid.read((String)displayTypeId));
        }
        for (int i = 0; i < newInfoList.size(); ++i) {
            EliminationInfo newInfo = (EliminationInfo)newInfoList.get(i);
            if (isBasic && newTemplateTypeInfo != null) {
                newInfo.setDisplayTemplateType(newTemplateTypeInfo);
            }
            this.setEliminationInfo(newInfo, params, user, time, isMergeByFiscalPeriod, periods);
            ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
            String oldId = newInfo.getId().toString();
            String oldNumber = newInfo.getNumber();
            if (!isSunElimination && isImport || isSynBasicScopeData) {
                newInfo = this.generateEliminationInfo(ctx, newInfo, mapAdjust, hasCodeRule, params);
            } else {
                newInfo.setOrgBound(orgTreeInfo);
                this.setCopyData(params, newInfo, orgUnitInfo, user, time);
            }
            String strhasCodRule = params.getString("isHaseCodeRule");
            if (null == strhasCodRule || !strhasCodRule.equals("notNeedCodeRule")) {
                if (!codeRuleNumbers.isEmpty() && codeRuleNumbers.get(0) != null) {
                    newInfo.setNumber((String)codeRuleNumbers.get(0));
                } else {
                    this.setCodingRuleNumber(ctx, newInfo, hasCodeRule, params);
                }
            }
            if (isImport) {
                try {
                    this.addnewCheck(ctx, newInfo);
                }
                catch (Exception ex) {
                    msg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"entryImportTitle", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{oldNumber})).append("<br/>");
                    msg.append(ex.getMessage()).append("<br/>");
                    this.removeEntryIds(entryIds, newInfo);
                    continue;
                }
            }
            EliminationInfo oldInfo = new EliminationInfo();
            oldInfo.setId(newInfo.getId());
            newInfo.setSourceElimination(oldInfo);
            newInfo.setId(null);
            if (newInfo.getElimType() == null) {
                newInfo.setElimType(ElimTypeEnum.General);
            }
            IObjectPK pk = ielimination.addnew((CoreBaseInfo)newInfo);
            if (!codeRuleNumbers.isEmpty()) {
                codeRuleNumbers.remove(newInfo.getNumber());
            }
            String[] attachIDs = asm.getAttachmentIDsByBoID(oldId);
            asm.addAssociations(pk.toString(), attachIDs);
            if (isSunElimination) {
                List idList = (List)map.get(newInfo.getCurrency().getId().toString());
                for (int j = 0; idList != null && j < idList.size(); ++j) {
                    this.addNewElimRelaOrgTree(ctx, elimRelaCol, idList.get(j).toString(), pk.toString());
                }
                continue;
            }
            this.addNewElimRelaOrgTree(ctx, elimRelaCol, oldId, pk.toString());
        }
        CslRptUtil.copyDynamicItem(ctx, entryIds, false);
        StringBuffer buffer = new StringBuffer(5);
        buffer.append(newInfoList.size());
        mapResult.put("iSuccessCount", buffer.toString());
        mapResult.put("successRecord", listResult);
        if (isImport) {
            mapResult.put("message", msg.toString());
        }
        return mapResult;
    }

    private void removeEntryIds(Map entryIds, EliminationInfo newInfo) {
        for (int j = 0; j < newInfo.getEntries().size(); ++j) {
            EliminationEntryInfo entryInfo = newInfo.getEntries().get(j);
            String newEntryId = entryInfo.getId().toString();
            Iterator it = entryIds.keySet().iterator();
            boolean isRemoved = false;
            String oldEntryId = null;
            while (it.hasNext()) {
                oldEntryId = String.valueOf(it.next());
                String entryId = String.valueOf(entryIds.get(oldEntryId));
                if (!newEntryId.equals(entryId)) continue;
                isRemoved = true;
            }
            if (!isRemoved) continue;
            entryIds.remove(oldEntryId);
        }
    }

    private void setCopyData(RptProperties params, EliminationInfo newInfo, OrgUnitInfo orgUnitInfo, UserInfo user, Timestamp time) {
        Map toCopyNewUnit = (Map)params.getObject("toCopyNewUnit");
        int resultStatus = 0;
        if (params.getObject("resultStatus") != null) {
            resultStatus = ((CopyCSLHisDataResultStatusEnum)((Object)params.getObject("resultStatus"))).getValue();
        }
        if (resultStatus == 1 && newInfo.getCheckedStatus().getValue() == 2) {
            newInfo.setAuditDate(time);
            newInfo.setAuditor(user);
            newInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
        } else {
            newInfo.setAuditDate(null);
            newInfo.setAuditor(null);
            newInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        }
        if (toCopyNewUnit != null && toCopyNewUnit.size() > 0) {
            String unitid = (String)toCopyNewUnit.get(newInfo.getId().toString());
            if (unitid != null) {
                OrgUnitInfo info = new OrgUnitInfo();
                info.setId(BOSUuid.read((String)unitid));
                newInfo.setOrgUnit(info);
            }
        } else {
            newInfo.setOrgUnit(orgUnitInfo);
        }
    }

    private Object getParamValue(Context ctx) {
        String keyElim = "GR_CSL_AllowElimRRTM";
        Object value = null;
        try {
            value = CslRptUtil.getParamValue(ctx, null, keyElim);
        }
        catch (Exception e) {
            return null;
        }
        return value;
    }

    private void setCodingRuleNumber(Context ctx, EliminationInfo newInfo, boolean hasCodeRule, RptProperties params) throws BOSException, EASBizException {
        int periodType = params.getInt("periodType");
        String treeId = params.getString("treeId");
        int year = params.getInt("year");
        int period = params.getInt("period");
        String strOrgID = CSLServerHelper.getRootOrgIDForRootCU(ctx);
        boolean isSynBasicScopeData = params.getBoolean("isSynBasicScopeData");
        boolean isSunElimination = params.getBoolean("isSunElimination");
        boolean isImport = params.getBoolean("isImport");
        String currentNumber = null;
        if (!isSynBasicScopeData && strOrgID != null && hasCodeRule) {
            currentNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)newInfo, strOrgID);
            newInfo.setNumber(currentNumber);
        } else if (!isImport || isImport && isSunElimination) {
            currentNumber = this.getCurrentMaxNumber(ctx, treeId, periodType, year, period, "T_CSL_Elimination");
            newInfo.setNumber(currentNumber);
        }
    }

    private EliminationInfo generateEliminationInfo(Context ctx, EliminationInfo newInfo, Map mapAdjust, boolean hasCodeRule, RptProperties params) {
        if (null == mapAdjust) {
            return newInfo;
        }
        boolean isSynBasicScopeData = params.getBoolean("isSynBasicScopeData");
        EliminationInfo targetEliminationInfo = (EliminationInfo)mapAdjust.get(newInfo.getId());
        if (null != targetEliminationInfo) {
            newInfo.setOrgBound(targetEliminationInfo.getOrgBound());
            this.setOrgUnit(newInfo, targetEliminationInfo, params);
            if (!hasCodeRule || isSynBasicScopeData) {
                newInfo.setNumber(targetEliminationInfo.getNumber());
                params.setString("isHaseCodeRule", "notNeedCodeRule");
            }
        } else {
            OrgTreeInfo orgTreeInfo = (OrgTreeInfo)params.getObject("KEY_ORGTREE_INFO");
            newInfo.setOrgBound(orgTreeInfo);
            this.setOrgUnit(newInfo, targetEliminationInfo, params);
        }
        if (isSynBasicScopeData && newInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
            newInfo.setAuditDate(new Timestamp(System.currentTimeMillis()));
            newInfo.setAuditor((UserInfo)ctx.get((Object)"UserInfo"));
        } else {
            newInfo.setAuditor(null);
            newInfo.setAuditDate(null);
            newInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        }
        newInfo.setSourceElimination((EliminationInfo)newInfo.clone());
        return newInfo;
    }

    private void setOrgUnit(EliminationInfo info, EliminationInfo targetInfo, RptProperties params) {
        boolean isByOrdinal = params.getBoolean("isByOrdinal");
        ElimImportBasicTreeEnum elimImportbasicType = (ElimImportBasicTreeEnum)((Object)params.getObject("elimImportbasicType"));
        if (!isByOrdinal && null != targetInfo) {
            info.setOrgUnit(targetInfo.getOrgUnit());
        } else if (!elimImportbasicType.equals((Object)ElimImportBasicTreeEnum.AllCompanyInOrgnizeImport) && !elimImportbasicType.equals((Object)ElimImportBasicTreeEnum.RelatedCompanyImport) || !isByOrdinal) {
            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)params.getObject("KEY_ORGUNIT_INFO");
            info.setOrgUnit(orgUnitInfo);
        }
    }

    private void addEliminationInfo(EliminationInfo info, Map mapElimIdLongNumbers, Map mapAllLongNumbers, boolean bResult, ArrayList oldInfoList) {
        if (null == mapElimIdLongNumbers || mapElimIdLongNumbers.size() == 0) {
            return;
        }
        EliminationEntryCollection entryCollection = info.getEntries();
        HashMap<String, EliminationInfo> entryEliminationMap = new HashMap<String, EliminationInfo>();
        String strLongNumber = null;
        EliminationInfo newElimInfo = null;
        int iLength = entryCollection.size();
        for (int i = 0; i < iLength; ++i) {
            if (null == mapElimIdLongNumbers.get(entryCollection.get(i).getId().toString())) continue;
            strLongNumber = mapElimIdLongNumbers.get(entryCollection.get(i).getId().toString()).toString();
            if (strLongNumber.lastIndexOf(SPLIT) > 0) {
                strLongNumber = strLongNumber.substring(0, strLongNumber.lastIndexOf(SPLIT));
            }
            if (entryEliminationMap.containsKey(strLongNumber)) {
                newElimInfo = (EliminationInfo)entryEliminationMap.get(strLongNumber);
                newElimInfo.getEntries().add(entryCollection.get(i));
                continue;
            }
            newElimInfo = new EliminationInfo();
            this.generateElimnationInfo(newElimInfo, info);
            newElimInfo.getEntries().add(entryCollection.get(i));
            entryEliminationMap.put(strLongNumber, newElimInfo);
            bResult = this.setOrgUnitFromMap(newElimInfo, mapAllLongNumbers, strLongNumber, bResult);
            if (!bResult) continue;
            oldInfoList.add(newElimInfo);
        }
    }

    private void generateElimnationInfo(EliminationInfo newData, EliminationInfo oldData) {
        newData.setId(oldData.getId());
        if (oldData.getDisplayTemplateType() != null) {
            newData.setDisplayTemplateType(oldData.getDisplayTemplateType());
        }
        newData.setCurrency(oldData.getCurrency());
        newData.setSourceCurrency(oldData.getSourceCurrency());
        newData.setValueType(oldData.getValueType());
        newData.setDataCollect(oldData.getDataCollect());
        newData.setDataCollectNumber(oldData.getDataCollectNumber());
        newData.setIsFixed(oldData.getIsFixed());
        newData.setRemark(oldData.getRemark());
        newData.setNumber(oldData.getNumber());
        newData.setCustomNumber(oldData.getCustomNumber());
        newData.setCheckedStatus(oldData.getCheckedStatus());
        newData.setOrgUnit(oldData.getOrgUnit());
        newData.setEliminationMode(oldData.getEliminationMode());
    }

    private boolean setOrgUnitFromMap(EliminationInfo info, Map mapAllLongNumbers, String strLongNumber, boolean bResult) {
        if (null != mapAllLongNumbers.get(strLongNumber)) {
            OrgUnitInfo orgUnitInfo = new OrgUnitInfo();
            orgUnitInfo.setId(BOSUuid.read((String)mapAllLongNumbers.get(strLongNumber).toString()));
            info.setOrgUnit(orgUnitInfo);
            bResult = true;
        } else {
            bResult = false;
        }
        return bResult;
    }

    private String getCommonLongNumber(EliminationInfo elimInfo, Map mapLongNumbers) {
        EliminationEntryCollection entryCollection = elimInfo.getEntries();
        int iSize = entryCollection.size();
        if (null == entryCollection || iSize == 0 || mapLongNumbers.size() == 0) {
            return null;
        }
        String strFlagLongNumber = null;
        String strCompareNumber = null;
        boolean bResult = false;
        strFlagLongNumber = mapLongNumbers.get(entryCollection.get(0).getId().toString()).toString();
        if (strFlagLongNumber.indexOf(SPLIT) < 0) {
            return strFlagLongNumber;
        }
        if (iSize == 1) {
            return strFlagLongNumber.substring(0, strFlagLongNumber.lastIndexOf(SPLIT));
        }
        int iLength = strFlagLongNumber.split(SPLIT).length - 1;
        for (int i = 0; i < iLength; ++i) {
            strFlagLongNumber = strFlagLongNumber.substring(0, strFlagLongNumber.lastIndexOf(SPLIT));
            for (int j = 1; j < iSize; ++j) {
                strCompareNumber = mapLongNumbers.get(entryCollection.get(j).getId().toString()).toString();
                if (!strCompareNumber.startsWith(strFlagLongNumber)) {
                    bResult = false;
                    break;
                }
                bResult = true;
            }
            if (!bResult) continue;
            return strFlagLongNumber;
        }
        return null;
    }

    private Map getAllLongNumberByOrgBound(Context ctx, RptProperties params) throws BOSException {
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)params.getObject("KEY_ORGTREE_INFO");
        String orgTreeID = orgTreeInfo.getId().toString();
        StringBuffer sbBuffer = new StringBuffer(512);
        sbBuffer.append(" select distinct baseunit.FID  as unitId,structure.FLongNumber as longNumber from T_ORG_Structure structure ");
        sbBuffer.append(" inner join T_ORG_TREE tree on tree.FID = structure.FTreeId ");
        sbBuffer.append(" inner join T_ORG_BASEUNIT baseunit on baseunit.FID = structure.FUnitId ");
        sbBuffer.append(" where structure.FTreeId = ?    ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbBuffer.toString(), (Object[])new Object[]{orgTreeID});
        HashMap<String, String> map = new HashMap<String, String>(rs.size());
        try {
            while (rs.next()) {
                map.put(rs.getString("longNumber"), rs.getString("unitId"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return map;
    }

    private Map getLongNumberByElimID(Context ctx, ArrayList list, RptProperties params) throws BOSException {
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)params.getObject("KEY_ORGTREE_INFO");
        String orgTreeID = orgTreeInfo.getId().toString();
        StringBuffer sbBuffer = new StringBuffer(512);
        sbBuffer.append("  select structure.FLongNumber as longNumber, entryElim.FID as entryElimID from T_CSL_EliminationEntry entryElim ");
        sbBuffer.append("  inner join T_ORG_Structure structure on  entryElim.FcompanyID = structure.FUnitId ");
        sbBuffer.append("  and structure.FTreeId = ?  and entryElim.FEliminationID in ( ");
        int iSize = list.size() - 1;
        for (int i = 0; i < iSize; ++i) {
            sbBuffer.append("'" + list.get(i) + "',");
        }
        sbBuffer.append("'" + list.get(list.size() - 1) + "')");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbBuffer.toString(), (Object[])new Object[]{orgTreeID});
        HashMap<String, String> map = new HashMap<String, String>(rs.size());
        try {
            while (rs.next()) {
                map.put(rs.getString("entryElimID"), rs.getString("longNumber"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return map;
    }

    private Map getMapElimination(Context ctx, List listId, RptProperties params) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = this.getEntityViewInfo(listId, params);
        EliminationCollection collection = EliminationFactory.getLocalInstance(ctx).getEliminationCollection(entityViewInfo);
        int iSize = collection.size();
        HashMap<Object, Object> mapAdjust = new HashMap<Object, Object>(iSize);
        IObjectPK[] deletePKs = new IObjectPK[iSize];
        for (int i = 0; i < iSize; ++i) {
            EliminationInfo eliminationInfo = collection.get(i);
            mapAdjust.put(eliminationInfo.getSourceElimination().getId(), eliminationInfo);
            deletePKs[i] = new ObjectUuidPK(eliminationInfo.getId());
            AttachmentManagerFactory.getServerManager((Context)ctx).deleteAttachemtsByBoID(eliminationInfo.getId().toString());
        }
        mapAdjust.put("deletePks", deletePKs);
        return mapAdjust;
    }

    private EntityViewInfo getEntityViewInfo(List listId, RptProperties rptProperties) {
        Set setIds = this.getSet(listId);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        boolean isSynBasicScopeData = rptProperties.getBoolean("isSynBasicScopeData");
        if (isSynBasicScopeData) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)setIds, CompareType.INCLUDE));
            filter.setMaskString("#0");
        } else {
            String year = rptProperties.getObject("year").toString();
            String period = rptProperties.getObject("period").toString();
            String periodType = rptProperties.getObject("periodType").toString();
            OrgTreeInfo orgTreeInfo = (OrgTreeInfo)rptProperties.getObject("KEY_ORGTREE_INFO");
            String orgTreeID = orgTreeInfo.getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)period, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodType, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("year", (Object)year, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("orgBound", (Object)orgTreeID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("sourceElimination.id", (Object)setIds, CompareType.INCLUDE));
            filter.setMaskString("#0 and #1 and #2 and #3 and #4");
        }
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("orgBound"));
        selector.add(new SelectorItemInfo("orgUnit"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("sourceElimination.id"));
        return viewInfo;
    }

    private void setEliminationInfo(EliminationInfo newInfo, RptProperties params, UserInfo user, Timestamp time, boolean isMergeByFiscalPeriod, PeriodCollection periods) throws BOSException, EASBizException {
        int periodType = params.getInt("periodType");
        int year = params.getInt("year");
        int period = params.getInt("period");
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)params.getObject("KEY_ORGTREE_INFO");
        DataCollectInfo dataCollect = (DataCollectInfo)params.getObject("dataCollect");
        newInfo.setYear(year);
        newInfo.setPeriod(period);
        newInfo.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
        newInfo.setOrgBound(orgTreeInfo);
        newInfo.setIsCitedByLater(IsCitedByLaterEnum.ISTRUE);
        newInfo.setCreator(user);
        newInfo.setCreateTime(time);
        newInfo.setDataCollect(dataCollect);
        newInfo.setDataCollectNumber(dataCollect.getNumber());
        try {
            newInfo.setDate(FiscalPeriodHelper.getPeriodLastDate(periods, year, period, RptPeriodTypeEnum.getEnum((int)periodType), isMergeByFiscalPeriod));
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            newInfo.setDate(RPTDate13Util.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType)));
        }
    }

    private EliminationCollection getSourceEliminationCollection(Context ctx, List listId) throws BOSException, EASBizException {
        Set setIds = this.getSet(listId);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)setIds, CompareType.INCLUDE));
        filter.setMaskString("#0");
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.item"));
        sic.add(new SelectorItemInfo("entries.item.number"));
        sic.add(new SelectorItemInfo("entries.item.name"));
        sic.add(new SelectorItemInfo("entries.company.name"));
        sic.add(new SelectorItemInfo("entries.company.number"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("dataCollect.name"));
        sic.add(new SelectorItemInfo("dataCollectNumber"));
        sic.add(new SelectorItemInfo("orgBound.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("eliminationMode.name"));
        sic.add(new SelectorItemInfo("eliminationMode.id"));
        viewInfo.getSorter().clear();
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        viewInfo.getSorter().add(new SorterItemInfo("entries.seq"));
        EliminationCollection collection = EliminationFactory.getLocalInstance(ctx).getEliminationCollection(viewInfo);
        return collection;
    }

    private Set getSet(List listId) {
        int iSize = listId.size();
        HashSet setIds = new HashSet(iSize);
        for (int i = 0; i < iSize; ++i) {
            setIds.add(listId.get(i));
        }
        return setIds;
    }

    private void doGenerationElimInfo(ArrayList newInfoList, ArrayList oldInfoList, RptProperties params, UserInfo user, Timestamp time, OrgUnitInfo orgUnitInfo, BOSObjectType bosType, Map entryIds, int resultStatus, Map toCopyNewUnit) {
        int iSize = oldInfoList.size();
        for (int i = 0; i < iSize; ++i) {
            EliminationInfo newData = new EliminationInfo();
            newInfoList.add(newData);
            EliminationInfo oldData = (EliminationInfo)oldInfoList.get(i);
            newData.setId(oldData.getId());
            if (oldData.getDisplayTemplateType() != null) {
                newData.setDisplayTemplateType(oldData.getDisplayTemplateType());
            }
            newData.setCurrency(oldData.getCurrency());
            newData.setSourceCurrency(oldData.getSourceCurrency());
            newData.setValueType(oldData.getValueType());
            newData.setDataCollect(oldData.getDataCollect());
            newData.setDataCollectNumber(oldData.getDataCollectNumber());
            newData.setNumber(oldData.getNumber());
            newData.setOrgUnit(oldData.getOrgUnit());
            newData.setIsFixed(oldData.getIsFixed());
            newData.setRemark(oldData.getRemark());
            BOSUuid bosUuid = null;
            for (int j = 0; j < oldData.getEntries().size(); ++j) {
                EliminationEntryInfo entryInfo = oldData.getEntries().get(j);
                bosUuid = BOSUuid.create((BOSObjectType)bosType);
                entryIds.put(entryInfo.getId().toString(), bosUuid.toString());
                entryInfo.setId(bosUuid);
                newData.getEntries().add(entryInfo);
            }
            newData.setEliminationMode(oldData.getEliminationMode());
            newData.setCustomNumber(oldData.getCustomNumber());
            newData.setCheckedStatus(oldData.getCheckedStatus());
            newData.setInvestNewType(oldData.getInvestNewType());
            newData.setElimType(oldData.getElimType());
        }
    }

    private String getMergeKey(EliminationInfo info) {
        StringBuffer mergeKey = new StringBuffer();
        return mergeKey.append(info.getCurrency().getId().toString()).append("@@@").append(info.getSourceCurrency().getId().toString()).append("@@@").append(info.getValueType().getValue()).append("@@@").append(info.getElimType().getValue()).append("@@@").append(info.getInvestNewType() != null ? Integer.valueOf(info.getInvestNewType().getValue()) : "").toString();
    }

    private boolean multiElimInfo(Context ctx, EliminationInfo info, RptProperties params, List companyIds, ArrayList currencyList, RPTItemInfo unAllotGainYearItem, boolean bResult, Object oParamValue) throws BOSException, EASBizException {
        int year = params.getInt("year");
        boolean isInitYearProfit = params.getBoolean("isInitYearProfit");
        boolean isAllCompanyImport = params.getBoolean("isAllCompanyImport");
        boolean isSynBasicScopeData = params.getBoolean("isSynBasicScopeData");
        boolean isByOrdinal = params.getBoolean("isByOrdinal");
        String conmpanyId = null;
        ElimImportBasicTreeEnum elimImportbasicType = (ElimImportBasicTreeEnum)((Object)params.getObject("elimImportbasicType"));
        String mergeKey = this.getMergeKey(info);
        if (!currencyList.contains(mergeKey)) {
            currencyList.add(mergeKey.toString());
        }
        EliminationEntryCollection col = info.getEntries();
        int iEntrySize = col.size();
        int iCount = 0;
        BigDecimal bCredit = BigDecimal.valueOf(0L);
        BigDecimal bDebit = BigDecimal.valueOf(0L);
        Object entryInfo = null;
        int iHiddleCount = 0;
        ArrayList<EliminationEntryInfo> lstRemove = new ArrayList<EliminationEntryInfo>();
        ArrayList<String> lstRepatNumber = new ArrayList<String>();
        ArrayList<EliminationEntryInfo> lstEntry = new ArrayList<EliminationEntryInfo>();
        HashMap<String, BigDecimal> mapMoney = new HashMap<String, BigDecimal>();
        String[] strArgs = null;
        for (int i = iEntrySize - 1; i >= 0; --i) {
            EliminationEntryInfo lineInfo = col.get(i);
            FullOrgUnitInfo company = lineInfo.getCompany();
            if (isInitYearProfit && info.getYear() < year) {
                ObjectUuidPK itemPk = new ObjectUuidPK(lineInfo.getItem().getId());
                RPTItemInfo itemInfo = RPTItemFactory.getLocalInstance(ctx).getRPTItemInfo((IObjectPK)itemPk);
                if (itemInfo.isIsProfitAndLosses() && lineInfo.getDataElement() == 3 && lineInfo.isIsVisible()) {
                    if (unAllotGainYearItem == null) {
                        unAllotGainYearItem = this.getUnAllotRptItemId(ctx);
                    }
                    lineInfo.setItem(unAllotGainYearItem);
                    lineInfo.setDataElement(5);
                    strArgs = this.getArgsNumber(itemInfo, company);
                    if ("false".equals(oParamValue)) {
                        if (lstRepatNumber.contains(strArgs[0])) {
                            if (null != mapMoney && mapMoney.size() != 0) {
                                BigDecimal bigDecimal = bDebit = null == (BigDecimal)mapMoney.get(strArgs[0]) ? new BigDecimal(0) : (BigDecimal)mapMoney.get(strArgs[0]);
                                if (null != lineInfo.getDebit()) {
                                    bDebit = bDebit.add(lineInfo.getDebit());
                                    mapMoney.put(strArgs[0], bDebit);
                                }
                                BigDecimal bigDecimal2 = bCredit = null == (BigDecimal)mapMoney.get(strArgs[1]) ? new BigDecimal(0) : (BigDecimal)mapMoney.get(strArgs[1]);
                                if (null != lineInfo.getCredit()) {
                                    bCredit = bCredit.add(lineInfo.getCredit());
                                    mapMoney.put(strArgs[1], bCredit);
                                }
                            }
                            lstRemove.add(lineInfo);
                        } else {
                            if (null != lineInfo.getDebit()) {
                                mapMoney.put(strArgs[0], lineInfo.getDebit());
                            }
                            if (null != lineInfo.getCredit()) {
                                mapMoney.put(strArgs[1], lineInfo.getCredit());
                            }
                            lstEntry.add(lineInfo);
                            lstRepatNumber.add(strArgs[0]);
                        }
                    }
                } else if (!lineInfo.isIsVisible()) {
                    ++iHiddleCount;
                }
            }
            if (isSynBasicScopeData) {
                if (elimImportbasicType.equals((Object)ElimImportBasicTreeEnum.RelatedCompanyImport)) {
                    if (company == null || company.getId() == null) {
                        col.removeObject(i);
                        ++iCount;
                    } else {
                        conmpanyId = company.getId().toString();
                        if (!companyIds.contains(conmpanyId)) {
                            col.removeObject(i);
                            ++iCount;
                        }
                    }
                    if (iCount != iEntrySize) continue;
                    bResult = false;
                    continue;
                }
                if (elimImportbasicType.equals((Object)ElimImportBasicTreeEnum.AllCompanyImport)) {
                    if (company != null && company.getId() != null) {
                        conmpanyId = company.getId().toString();
                        if (!companyIds.contains(conmpanyId)) continue;
                        bResult = true;
                        break;
                    }
                    bResult = false;
                    continue;
                }
                if (!elimImportbasicType.equals((Object)ElimImportBasicTreeEnum.AllCompanyInOrgnizeImport) || isByOrdinal) continue;
                if (company == null || company.getId() == null) {
                    bResult = false;
                    break;
                }
                conmpanyId = company.getId().toString();
                if (companyIds.contains(conmpanyId)) continue;
                bResult = false;
                break;
            }
            if (isAllCompanyImport || companyIds == null) continue;
            if (lineInfo.getCompany() == null || lineInfo.getCompany().getId() == null) {
                col.removeObject(i);
                continue;
            }
            String companyId = lineInfo.getCompany().getId().toString();
            if (companyIds.contains(companyId)) continue;
            col.removeObject(i);
        }
        if (isInitYearProfit && info.getYear() < year && "false".equals(oParamValue)) {
            bResult = this.multiEliminationEntryInfo(lstEntry, info, mapMoney, lstRemove, iHiddleCount, bResult);
        }
        return bResult;
    }

    private String[] getArgsNumber(RPTItemInfo itemInfo, FullOrgUnitInfo company) {
        String[] strArgsNumber = new String[2];
        if (itemInfo != null && itemInfo.getNumber() != null && company != null && company.getNumber() != null) {
            StringBuffer sbBuffer = new StringBuffer();
            String companyNumber = company.getNumber();
            sbBuffer.append(companyNumber);
            strArgsNumber[0] = sbBuffer.toString();
            sbBuffer.append("Credit");
            strArgsNumber[1] = sbBuffer.toString();
        }
        return strArgsNumber;
    }

    private boolean multiEliminationEntryInfo(List lstEntry, EliminationInfo info, Map mapMoney, List lstRemove, int iHiddleCount, boolean bResult) {
        if (null == lstEntry || lstEntry.size() == 0) {
            return bResult;
        }
        EliminationEntryInfo entryInfo = null;
        EliminationEntryCollection col = null;
        col = info.getEntries();
        FullOrgUnitInfo company = null;
        RPTItemInfo item = null;
        BigDecimal bDebit = null;
        BigDecimal bCredit = null;
        String[] strArgs = null;
        int iSize = lstEntry.size();
        for (int i = 0; i < iSize; ++i) {
            entryInfo = (EliminationEntryInfo)lstEntry.get(i);
            item = entryInfo.getItem();
            strArgs = this.getArgsNumber(item, company = entryInfo.getCompany());
            bDebit = null == (BigDecimal)mapMoney.get(strArgs[0]) ? new BigDecimal(0) : (BigDecimal)mapMoney.get(strArgs[0]);
            BigDecimal bigDecimal = bCredit = null == (BigDecimal)mapMoney.get(strArgs[1]) ? new BigDecimal(0) : (BigDecimal)mapMoney.get(strArgs[1]);
            if (item.getDc().equals((Object)DebitOrCreditEnum.CREDIT)) {
                entryInfo.setDebit(bDebit.subtract(bCredit));
                entryInfo.setCredit(null);
                continue;
            }
            entryInfo.setCredit(bCredit.subtract(bDebit));
            entryInfo.setDebit(null);
        }
        this.removeCreditAndDebitIsZero(lstRemove, info);
        this.removeEntry(lstRemove, col);
        if (null == col || col.size() == 0 || col.size() == iHiddleCount) {
            bResult = false;
        }
        return bResult;
    }

    private void removeCreditAndDebitIsZero(List lstDeleteEntry, EliminationInfo info) {
        EliminationEntryCollection entriesCollection = info.getEntries();
        EliminationEntryInfo entryInfo = null;
        int iSize = entriesCollection.size();
        for (int i = 0; i < iSize; ++i) {
            entryInfo = entriesCollection.get(i);
            this.convertZeroToNull(entryInfo);
            if (null != entryInfo.getCredit() || null != entryInfo.getDebit()) continue;
            lstDeleteEntry.add(entriesCollection.get(i));
        }
    }

    private void convertZeroToNull(EliminationEntryInfo entryInfo) {
        int iResult = 0;
        if (null != entryInfo.getCredit() && iResult == BigDecimal.valueOf(0L).compareTo(entryInfo.getCredit())) {
            entryInfo.setCredit(null);
        }
        if (null != entryInfo.getDebit() && iResult == BigDecimal.valueOf(0L).compareTo(entryInfo.getDebit())) {
            entryInfo.setDebit(null);
        }
    }

    private void removeEntry(List lstDeleteEntry, EliminationEntryCollection entry) {
        if (null != lstDeleteEntry && lstDeleteEntry.size() != 0) {
            int iSize = lstDeleteEntry.size();
            for (int i = 0; i < iSize; ++i) {
                entry.remove((EliminationEntryInfo)lstDeleteEntry.get(i));
            }
        }
    }

    private ArrayList doSumEliminationByCurrency(Context ctx, ArrayList eliminationList, ArrayList currencyList, boolean isImport, Map currency2OldID) throws BOSException, EASBizException {
        ArrayList<EliminationInfo> rtEliminationList = new ArrayList<EliminationInfo>();
        BigDecimal zeroValue = new BigDecimal("0");
        HashMap<String, EliminationInfo> currencyTable = new HashMap<String, EliminationInfo>();
        StringBuffer itemDataElementValueTypePK = new StringBuffer();
        for (int j = 0; j < currencyList.size(); ++j) {
            String[] splitArr = ((String)currencyList.get(j)).split("@@@");
            String currencyId = splitArr[0];
            String sourceCurrencyId = splitArr[1];
            String valueType = splitArr[2];
            String elimType = splitArr[3];
            String investNewType = splitArr.length > 4 ? splitArr[4] : "";
            EliminationInfo newInfo = new EliminationInfo();
            HashMap<String, EliminationEntryInfo> itemDataElementValueType = new HashMap<String, EliminationEntryInfo>();
            for (int k = 0; k < eliminationList.size(); ++k) {
                EliminationInfo oldInfo = null;
                oldInfo = (EliminationInfo)eliminationList.get(k);
                if (!currencyId.equals(oldInfo.getCurrency().getId().toString()) || !sourceCurrencyId.equals(oldInfo.getSourceCurrency().getId().toString()) || !valueType.equals(oldInfo.getValueType().getValue() + "") || !elimType.equals(oldInfo.getElimType().getValue() + "") || !investNewType.equals(oldInfo.getInvestNewType() != null ? oldInfo.getInvestNewType().getValue() + "" : "")) continue;
                if (currency2OldID.get(oldInfo.getCurrency().getId().toString()) == null) {
                    ArrayList<BOSUuid> listID = new ArrayList<BOSUuid>();
                    listID.add(oldInfo.getId());
                    currency2OldID.put(oldInfo.getCurrency().getId().toString(), listID);
                } else {
                    ((List)currency2OldID.get(oldInfo.getCurrency().getId().toString())).add(oldInfo.getId());
                }
                newInfo.setId(oldInfo.getId());
                newInfo.setCurrency(oldInfo.getCurrency());
                newInfo.setSourceCurrency(oldInfo.getSourceCurrency());
                newInfo.setValueType(oldInfo.getValueType());
                newInfo.setCustomNumber(null);
                EliminationEntryCollection entry = oldInfo.getEntries();
                int entrySize = 0;
                if (entry != null) {
                    entrySize = entry.size();
                }
                if (entry == null || entrySize <= 0) continue;
                for (int i = 0; i < entry.size(); ++i) {
                    EliminationEntryInfo anotherLineInfo;
                    EliminationEntryInfo lineInfo = entry.get(i);
                    if ((lineInfo.getCompany() == null || lineInfo.getCompany().getId() == null) && isImport) continue;
                    BigDecimal debitTotal = new BigDecimal("0");
                    BigDecimal creditTotal = new BigDecimal("0");
                    BigDecimal resultTotal = null;
                    String itemId = lineInfo.getItem().getId().toString();
                    itemDataElementValueTypePK.setLength(0);
                    itemDataElementValueTypePK.append(itemId).append("@@@").append(lineInfo.getDataElement()).append("@@@").append(oldInfo.getValueType().getValue()).append("@@@").append(lineInfo.isIsVisible()).append("@@@").append(lineInfo.getCompany() == null ? "" : lineInfo.getCompany().getId().toString()).append("@@@").append(lineInfo.getInvCompany() == null ? "" : lineInfo.getInvCompany().getId().toString()).append("@@@").append(lineInfo.getTargetCompany() == null ? "" : lineInfo.getTargetCompany().getId().toString());
                    if (!itemDataElementValueType.containsKey(itemDataElementValueTypePK.toString())) {
                        anotherLineInfo = new EliminationEntryInfo();
                        anotherLineInfo.setIsVisible(lineInfo.isIsVisible());
                        anotherLineInfo.setDataElement(lineInfo.getDataElement());
                        anotherLineInfo.setItem(lineInfo.getItem());
                        anotherLineInfo.setElimination(oldInfo);
                        anotherLineInfo.setCompany(lineInfo.getCompany());
                        anotherLineInfo.setInvCompany(lineInfo.getInvCompany());
                        anotherLineInfo.setTargetCompany(lineInfo.getTargetCompany());
                        anotherLineInfo.setSummary(lineInfo.getSummary());
                        anotherLineInfo.setDebit(lineInfo.getDebit());
                        anotherLineInfo.setCredit(lineInfo.getCredit());
                        itemDataElementValueType.put(itemDataElementValueTypePK.toString(), anotherLineInfo);
                        continue;
                    }
                    anotherLineInfo = (EliminationEntryInfo)itemDataElementValueType.get(itemDataElementValueTypePK.toString());
                    if (anotherLineInfo.getDebit() != null || lineInfo.getDebit() != null) {
                        debitTotal = anotherLineInfo.getDebit();
                        if (debitTotal == null) {
                            debitTotal = zeroValue;
                        }
                        debitTotal = debitTotal.add(lineInfo.getDebit() == null ? zeroValue : lineInfo.getDebit());
                    }
                    if (anotherLineInfo.getCredit() != null || lineInfo.getCredit() != null) {
                        creditTotal = anotherLineInfo.getCredit();
                        if (creditTotal == null) {
                            creditTotal = zeroValue;
                        }
                        creditTotal = creditTotal.add(lineInfo.getCredit() == null ? zeroValue : lineInfo.getCredit());
                    }
                    if ((resultTotal = debitTotal.subtract(creditTotal)).compareTo(zeroValue) >= 0) {
                        anotherLineInfo.setDebit(resultTotal);
                        anotherLineInfo.setCredit(zeroValue);
                    }
                    if (resultTotal.compareTo(zeroValue) < 0) {
                        anotherLineInfo.setCredit(resultTotal.abs());
                        anotherLineInfo.setDebit(zeroValue);
                    }
                    itemDataElementValueType.put(itemDataElementValueTypePK.toString(), anotherLineInfo);
                }
            }
            Set keySet = itemDataElementValueType.keySet();
            int seq = 0;
            Iterator it = keySet.iterator();
            while (it.hasNext()) {
                ++seq;
                String key = (String)it.next();
                EliminationEntryInfo element = (EliminationEntryInfo)itemDataElementValueType.get(key);
                if (element == null) continue;
                element.setSeq(seq);
                if ((element.getCredit() == null || element.getCredit().compareTo(zeroValue) == 0) && (element.getDebit() == null || element.getDebit().compareTo(zeroValue) == 0)) continue;
                element.setElimination(newInfo);
                if (element.getCredit() != null && element.getCredit().compareTo(zeroValue) == 0) {
                    element.setCredit(null);
                }
                if (element.getDebit() != null && element.getDebit().compareTo(zeroValue) == 0) {
                    element.setDebit(null);
                }
                newInfo.getEntries().add(element);
            }
            if (newInfo.getEntries() == null || newInfo.getEntries().size() <= 0) continue;
            currencyTable.put(currencyId + sourceCurrencyId + valueType + elimType + investNewType, newInfo);
        }
        Set currencyKeySet = currencyTable.keySet();
        for (String key : currencyKeySet) {
            EliminationInfo element = (EliminationInfo)currencyTable.get(key);
            rtEliminationList.add(element);
        }
        return rtEliminationList;
    }

    @Override
    protected int _removeBatch(Context ctx, ArrayList list) throws BOSException, EASBizException {
        int i;
        IInterCheck iInterCheck = InterCheckFactory.getLocalInstance(ctx);
        EnactmentServiceProxy iEnactmentService = new EnactmentServiceProxy();
        StringBuffer ids = new StringBuffer();
        String[] numbers = new String[list.size()];
        CoreBaseInfo[] elims = new CoreBaseInfo[list.size()];
        int n = list.size();
        for (int i2 = 0; i2 < n; ++i2) {
            ids.append("'").append((String)list.get(i2)).append("'");
            if (i2 != n - 1) {
                ids.append(",");
            }
            String id = list.get(i2).toString();
            EliminationInfo info = EliminationFactory.getLocalInstance(ctx).getEliminationInfo("select id,orgBound.id,number where id='" + id + "'");
            numbers[i2] = info.getNumber();
            elims[i2] = info;
            this.deleteElimRelaOrgTree(ctx, info);
        }
        StringBuffer auditSQL = new StringBuffer(" select fid from T_CSL_Elimination \r\n");
        auditSQL.append(" where FCheckedStatus = ").append(2).append(" and FID in (");
        auditSQL.append(ids).append(") \r\n");
        auditSQL.append(" and FConvertBeforeId is null");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)auditSQL.toString());
        try {
            if (rs.next()) {
                throw new AdjustException(AdjustException.CANNOT_DELETE_AUDIT);
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        int n2 = list.size();
        for (i = 0; i < n2; ++i) {
            AssignmentInfo[] assignments = iEnactmentService.checkAssignmentInfos((String)list.get(i), ctx.getCaller().toString());
            boolean isInWorkflow = false;
            isInWorkflow = assignments != null && assignments.length != 0;
            if (!isInWorkflow) continue;
            throw new AdjustException(AdjustException.CANNOT_DELETE_INWORKFLOW);
        }
        n2 = list.size();
        for (i = 0; i < n2; ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)list.get(i))));
            iInterCheck.deleteElimRecord(pk.toString());
        }
        if (EliminateUtil.isNeedRecyleNumber(ctx)) {
            EliminationInfo info = this.getEliminationInfo(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)((String)list.get(0)))), this.getSelectors());
            EliminateUtil.batchRecyleNumber(ctx, info, numbers);
        }
        AccountCheckUtil.deleteElimCheckageBillLink((Context)ctx, (String)ids.toString());
        StringBuffer deleteSQL = new StringBuffer(" delete from T_CSL_EliminationEntry \r\n");
        deleteSQL.append(" where FEliminationID in (");
        deleteSQL.append(ids).append(") \r\n");
        DbUtil.execute((Context)ctx, (String)deleteSQL.toString());
        StringBuffer deleteHeadSQL = new StringBuffer(" delete from T_CSL_Elimination \r\n");
        deleteHeadSQL.append(" where FID in (");
        deleteHeadSQL.append(ids).append(") \r\n");
        DbUtil.execute((Context)ctx, (String)deleteHeadSQL.toString());
        ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
        this.batchRemoveForLog(ctx, elims);
        return list.size();
    }

    @Override
    protected void _forbidCitedByLater(Context ctx, List list, IsCitedByLaterEnum isCited) throws BOSException, EASBizException {
        Iterator iter = list.iterator();
        EliminationInfo info = null;
        while (iter.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)iter.next().toString()));
            info = this.getEliminationInfo(ctx, (IObjectPK)pk);
            info.setIsCitedByLater(isCited);
            this._update(ctx, (IObjectPK)pk, (IObjectValue)info);
        }
    }

    @Override
    protected void _auditLog(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _unAuditLog(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected IRowSet _getAllElimByOrgUnit(Context ctx, Map param) throws BOSException, EASBizException {
        Integer year = (Integer)param.get("year");
        Integer period = (Integer)param.get("period");
        Integer periodType = (Integer)param.get("periodType");
        String basicTree = param.get("orgBound.id").toString();
        OrgUnitInfo unit = (OrgUnitInfo)param.get("orgUnitInfo");
        IRowSet rss = this._getElimCountByOrgUnit(ctx, param);
        StringBuffer elimIds = new StringBuffer();
        String elimId = null;
        if (rss != null) {
            try {
                while (rss.next()) {
                    int countActual;
                    elimId = rss.getString("fid");
                    int count = rss.getInt("entryCount");
                    IRowSet elimIdRs = DbUtil.executeQuery((Context)ctx, (String)("select count(*) as count from t_csl_eliminationentry \t\t\twhere feliminationid ='" + elimId + "' and FCompanyID is not null"));
                    if (elimIdRs == null || !elimIdRs.next() || (countActual = elimIdRs.getInt("count")) != count) continue;
                    elimIds.append("'").append(elimId).append("'").append(",");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        if (elimIds.length() > 0) {
            elimIds.deleteCharAt(elimIds.length() - 1);
        } else if (elimIds.length() == 0) {
            elimIds.append("''");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select flongnumber from t_org_structure where funitid='").append(unit.getId().toString()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        String longNumber = null;
        if (rs != null) {
            try {
                if (rs.next()) {
                    longNumber = rs.getString("flongnumber");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        sql.append("select distinct e.fid as fid,s.flongnumber as flongnumber from t_csl_elimination e inner join t_csl_eliminationentry en \r\n");
        sql.append(" on e.fid=en.FEliminationID \r\n");
        sql.append(" inner join t_org_baseunit b on en.fcompanyid = b.fid inner join t_org_structure s on b.fid=s.funitid \r\n");
        sql.append(" where s.flongnumber like '").append(longNumber).append("!%").append("'");
        sql.append(" and e.fid in (").append(elimIds.toString()).append(")");
        sql.append(" and e.fyear =").append(year).append(" and e.fperiod=").append(period);
        sql.append(" and e.fperiodType=").append(periodType);
        sql.append(" and e.FOrgBoundID in (").append(basicTree).append(")");
        sql.append(" order by e.fid asc");
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs1;
    }

    @Override
    protected IRowSet _getElimCountByOrgUnit(Context ctx, Map param) throws BOSException, EASBizException {
        Integer year = (Integer)param.get("year");
        Integer period = (Integer)param.get("period");
        Integer periodType = (Integer)param.get("periodType");
        String basicTree = param.get("orgBound.id").toString();
        OrgUnitInfo unit = (OrgUnitInfo)param.get("orgUnitInfo");
        StringBuffer sql = new StringBuffer();
        sql.append("select flongnumber from t_org_structure where funitid='").append(unit.getId().toString()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        String longNumber = null;
        if (rs != null) {
            try {
                if (rs.next()) {
                    longNumber = rs.getString("flongnumber");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        sql.append("select e.fid as fid,count(distinct en.fid) as entryCount from t_csl_elimination e inner join t_csl_eliminationentry en \r\n");
        sql.append(" on e.fid=en.FEliminationID \r\n");
        sql.append(" inner join t_org_baseunit b on en.fcompanyid = b.fid inner join t_org_structure s on b.fid=s.funitid \r\n");
        sql.append(" where s.flongnumber like '").append(longNumber).append("!%").append("'");
        sql.append(" and e.fyear =").append(year).append(" and e.fperiod=").append(period);
        sql.append(" and e.fperiodType=").append(periodType);
        sql.append(" and e.FOrgBoundID in (").append(basicTree).append(")");
        sql.append(" group by e.fid ");
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs1;
    }

    @Override
    protected List _getElimId(Context ctx, Map param) throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer s = new StringBuffer();
        Integer year = (Integer)param.get("year");
        Integer period = (Integer)param.get("period");
        Integer periodType = (Integer)param.get("periodType");
        String basicTree = param.get("orgBound.id").toString();
        String companyid = param.get("entries.company.id").toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select e.fid as fid from t_csl_elimination e inner join t_csl_eliminationentry en on e.fid=en.FEliminationID ");
        sql.append(" where e.fyear =").append(year).append(" and e.fperiod=").append(period);
        sql.append(" and e.fperiodType=").append(periodType);
        sql.append(" and e.FOrgBoundID in (").append(basicTree).append(")");
        sql.append(" and en.FCompanyID in (").append(StringUtils.isEmpty((String)companyid) ? "''" : companyid).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs != null) {
            try {
                while (rs.next()) {
                    String id = rs.getString("fid");
                    if (!list.contains(id)) {
                        list.add(id);
                    }
                    s.append("'").append(id).append("'").append(",");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        if (s.length() > 0) {
            s.deleteCharAt(s.length() - 1);
            sql = new StringBuffer();
            sql.append("select e.fid from t_csl_elimination e inner join T_CSL_ElimRelaOrgTree t on e.fid=t.FElimId where ");
            sql.append(" e.fid in (").append(s.toString()).append(")");
            sql.append(" and e.FOrgBoundID  = ").append(basicTree);
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            ArrayList<String> listRela = new ArrayList<String>();
            if (rs != null) {
                try {
                    while (rs.next()) {
                        String id = rs.getString("fid");
                        listRela.add(id);
                        if (!list.contains(id)) continue;
                        list.remove(id);
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
            for (int i = 0; i < listRela.size(); ++i) {
                if (list.contains(listRela.get(i))) continue;
                list.add((String)listRela.get(i));
            }
        }
        return list;
    }

    @Override
    protected Map _eliminationListInit(Context ctx, Map params) throws BOSException, EASBizException {
        List existDyItemEntries = ElimDynaItemEntryFactory.getLocalInstance(ctx).getExistsDyItemElimns(params, null, null);
        IOrgTree iOrgTree = OrgTreeFactory.getLocalInstance((Context)ctx);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (iOrgTree.exists("SELECT id WHERE basic = 1 and type = 8 and status = 1") && !iOrgTree.exists("SELECT id WHERE id = '" + params.get("KEY_CUR_ORGBOUND_ID") + "' and basic = 1 ")) {
            result.put("IsNotBaseOrgTree", Boolean.TRUE);
        } else {
            result.put("IsNotBaseOrgTree", Boolean.FALSE);
        }
        result.put("existDyItemEntries", existDyItemEntries);
        return result;
    }

    @Override
    protected List _getCurChildCompanyFromCurTree(Context ctx, Map param) throws BOSException, EASBizException {
        OrgUnitInfo unit = (OrgUnitInfo)param.get("orgUnitInfo");
        OrgTreeInfo curTreeInfo = (OrgTreeInfo)param.get("curTreeInfo");
        StringBuffer sql = new StringBuffer();
        String longNumber = null;
        ArrayList<String> curCompanyIds = new ArrayList<String>();
        sql.append(" select flongnumber from t_org_structure s where funitid='").append(unit.getId().toString()).append("'");
        sql.append(" and ftreeid='").append(curTreeInfo.getId().toString()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs != null) {
            try {
                if (rs.next()) {
                    longNumber = rs.getString("flongnumber");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        sql = new StringBuffer();
        sql.append(" select funitid from t_org_structure where flongnumber like '").append(longNumber).append("!%").append("'");
        sql.append(" and ftreeid='").append(curTreeInfo.getId().toString()).append("'");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs != null) {
            try {
                while (rs.next()) {
                    String funitid = rs.getString("funitid");
                    if (curCompanyIds.contains(funitid)) continue;
                    curCompanyIds.add(funitid);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return curCompanyIds;
    }

    @Override
    protected List _getEliminationIdBySql(Context ctx, String sql) throws BOSException {
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> result = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                String id = rowSet.getString(1);
                if (result.contains(id)) continue;
                result.add(id);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    private void addNewElimRelaOrgTree(Context ctx, ElimRelaOrgTreeCollection elimRelaCol, String oldId, String newId) throws BOSException, EASBizException {
        IElimRelaOrgTree iElimRela = ElimRelaOrgTreeFactory.getLocalInstance(ctx);
        if (elimRelaCol != null && elimRelaCol.size() > 0) {
            int size = elimRelaCol.size();
            for (int i = 0; i < size; ++i) {
                ElimRelaOrgTreeInfo info = elimRelaCol.get(i);
                if (!info.getElimId().equals(oldId)) continue;
                info.setCurrentElimId(newId);
                iElimRela.addnew(info);
            }
        }
    }

    @Override
    protected Map _getPermissionUnion(Context ctx, Map param) throws BOSException, EASBizException {
        String treeId = (String)param.get("treeId");
        if (StringUtils.isEmpty((String)treeId)) {
            return new HashMap(2);
        }
        HashMap map = new HashMap(2);
        IObjectPK userPk = ctx.getCaller();
        Map units = PermissionFactory.getLocalInstance((Context)ctx).getUnionUnits(userPk, (IObjectPK)new ObjectUuidPK(treeId));
        map.put(treeId, new HashSet(units.keySet()));
        return map;
    }

    @Override
    protected Map _getSubordinate(Context ctx, Map param) throws BOSException, EASBizException {
        String treeId = (String)param.get("treeId");
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        IRowSet result = null;
        if (treeId == null) {
            return resultMap;
        }
        StringBuffer s = new StringBuffer(80);
        s.append(" SELECT S.FID AS ID,S.FUNITID AS UNITID,S.FLONGNUMBER AS LONGNUMBER,");
        s.append(" S.FPARENTID AS PARENTID FROM T_ORG_STRUCTURE S ");
        s.append(" WHERE S.FTREEID = ? ");
        s.append(" ORDER BY FLONGNUMBER ASC");
        result = DbUtil.executeQuery((Context)ctx, (String)s.toString(), (Object[])new Object[]{treeId});
        OrgStructureCollection col = new OrgStructureCollection();
        HashMap<String, String> unitMap = new HashMap<String, String>();
        HashMap<String, String> idMap = new HashMap<String, String>();
        if (result != null && result.size() > 0) {
            try {
                while (result.next()) {
                    String unitId = result.getString("UNITID");
                    String id = result.getString("ID");
                    String parentId = result.getString("PARENTID");
                    OrgStructureInfo stru = new OrgStructureInfo();
                    FullOrgUnitInfo fullOrgUnit = new FullOrgUnitInfo();
                    fullOrgUnit.setId(BOSUuid.read((String)unitId));
                    stru.setUnit(fullOrgUnit);
                    stru.setId(BOSUuid.read((String)id));
                    OrgStructureInfo parent = new OrgStructureInfo();
                    if (parentId != null) {
                        parent.setId(BOSUuid.read((String)parentId));
                    }
                    stru.setParent(parent);
                    col.add(stru);
                    unitMap.put(unitId, id);
                    idMap.put(id, unitId);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        resultMap.put("rs", col);
        resultMap.put("unitMap", unitMap);
        resultMap.put("idMap", idMap);
        return resultMap;
    }

    @Override
    protected int _auditBatch(Context ctx, List list, boolean isAudit) throws BOSException, EASBizException {
        IElimination IE = EliminationFactory.getLocalInstance(ctx);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)list.get(i))));
            EliminationInfo info = IE.getEliminationInfo((IObjectPK)pk);
            if (info.getCheckedStatus() == CheckedStatusEnum.AUDITED) {
                throw new AdjustException(AdjustException.EXIST_AUDITED_DATA);
            }
            IE.audit((IObjectPK)pk, info, null);
        }
        return 0;
    }

    @Override
    protected ElimTempletCollection _getCurrentEliminationTemplate(Context ctx, Map map) throws BOSException, EASBizException {
        ElimTempletCollection templetCollection = null;
        StringBuffer querySql = new StringBuffer();
        String orgUnitID = null;
        String orgBoundId = null;
        if (map != null) {
            if (map.get("orgUnitID") != null) {
                orgUnitID = (String)map.get("orgUnitID");
            }
            if (map.get("orgBoundId") != null) {
                orgBoundId = (String)map.get("orgBoundId");
            }
        }
        querySql.append("select FDispenseSrcID from T_CSL_AdjustAndElimDispense ").append("\r\n");
        querySql.append(" where FSourceType = 2 ").append("\r\n");
        if (orgUnitID != null) {
            querySql.append("and FCompanyID = '").append(orgUnitID).append("'").append("\r\n");
        }
        if (orgBoundId != null) {
            querySql.append(" and FOrgBoundID = '").append(orgBoundId).append("'").append("\r\n");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        StringBuffer bf = new StringBuffer();
        try {
            while (rs.next()) {
                bf.append("'" + rs.getString("FDispenseSrcID") + "',");
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        if (0 < rs.size()) {
            bf.deleteCharAt(bf.lastIndexOf(","));
            StringBuffer osql = new StringBuffer();
            osql.append("select id,number,name,eliminationMode.id,eliminationMode.name,isCitedByLater,entries.summary,entries.DC,entries.item,").append("\r\n");
            osql.append(" entries.item.name,entries.debitFormula,entries.creditFormula,entries.dataElement,elimType,valueType,entries.item.*,entries.dataSrcType").append("\r\n");
            osql.append(" where checkedstatus = '").append(2).append("'").append("\r\n");
            osql.append(" and elimtype = '").append(2).append("'").append("\r\n");
            osql.append(" and id in (").append(bf.toString()).append(")").append("\r\n");
            osql.append(" order by number asc ").append("\r\n");
            IElimTemplet iElimTemplet = ElimTempletFactory.getLocalInstance(ctx);
            templetCollection = iElimTemplet.getElimTempletCollection(osql.toString());
        }
        return templetCollection;
    }

    @Override
    protected int _doTemplateBatchImportElimRecords(Context ctx, List idList, Map valueMap) throws BOSException, EASBizException {
        int successCount = 0;
        OrgTreeInfo orgTreeInfo = null;
        FullOrgUnitInfo orgUnitInfo = null;
        FullOrgUnitInfo fullOrgUnit = null;
        CompanyOrgUnitInfo companyOrgUnit = null;
        CurrencyInfo sourceCurrency = null;
        CurrencyInfo currency = null;
        Date bizDate = null;
        Timestamp createTime = null;
        int periodType = -1;
        int year = -1;
        int period = -1;
        TemplateTypeInfo displayType = null;
        HashMap entryCompanyMap = null;
        String mnsRptGenerate = null;
        boolean param = false;
        if (valueMap != null) {
            if (valueMap.get("orgTreeInfo") != null) {
                orgTreeInfo = (OrgTreeInfo)valueMap.get("orgTreeInfo");
            }
            if (valueMap.get("fullOrgUnit") != null) {
                orgUnitInfo = fullOrgUnit = (FullOrgUnitInfo)valueMap.get("fullOrgUnit");
            }
            if (valueMap.get("companyOrgUnit") != null) {
                companyOrgUnit = (CompanyOrgUnitInfo)valueMap.get("companyOrgUnit");
                orgUnitInfo = companyOrgUnit;
            }
            if (valueMap.get("sourceCurrency") != null) {
                sourceCurrency = (CurrencyInfo)valueMap.get("sourceCurrency");
            }
            if (valueMap.get("currency") != null) {
                currency = (CurrencyInfo)valueMap.get("currency");
            }
            if (valueMap.get("dateBizDate") != null) {
                bizDate = (Date)valueMap.get("dateBizDate");
            }
            if (valueMap.get("dateCreateTime") != null) {
                createTime = new Timestamp(((Date)valueMap.get("dateCreateTime")).getTime());
            }
            if (valueMap.get("periodType") != null) {
                periodType = (Integer)valueMap.get("periodType");
            }
            if (valueMap.get("year") != null) {
                year = (Integer)valueMap.get("year");
            }
            if (valueMap.get("period") != null) {
                period = (Integer)valueMap.get("period");
            }
            if (valueMap.get("entryCompanyMap") != null) {
                entryCompanyMap = (HashMap)valueMap.get("entryCompanyMap");
            }
            if (valueMap.get("displayType") != null) {
                displayType = (TemplateTypeInfo)valueMap.get("displayType");
            }
            if (valueMap.get("csl_Rpt_Generate_Entry") != null) {
                mnsRptGenerate = String.valueOf(valueMap.get("csl_Rpt_Generate_Entry"));
            }
            if (valueMap.get("GR_CSL_DCBalance") != null) {
                param = Boolean.valueOf(valueMap.get("GR_CSL_DCBalance").toString());
            }
        }
        EliminationInfo elim = new EliminationInfo();
        elim.setOrgBound(orgTreeInfo);
        if (fullOrgUnit != null) {
            elim.setOrgUnit(fullOrgUnit);
        } else if (companyOrgUnit != null) {
            elim.setOrgUnit((OrgUnitInfo)companyOrgUnit);
        }
        IElimTemplet iElimTemplet = ElimTempletFactory.getLocalInstance(ctx);
        ElimTempletInfo templateInfo = null;
        ElimTempletCollection tempCol = null;
        ElimTempletEntryCollection templeEntryCollection = null;
        String templateId = null;
        EliminationCollection elimCollection = null;
        EliminationInfo elimInfo = null;
        int rowIndex = 0;
        if (idList != null && idList.size() > 0) {
            int i;
            Sheet sheet = null;
            try {
                sheet = this.initBook(ctx, (OrgUnitInfo)orgUnitInfo, orgTreeInfo, year, (short)period, RptPeriodTypeEnum.getEnum((int)periodType), currency);
            }
            catch (Exception e) {
                logger.error((Object)"initBook error.", (Throwable)e);
            }
            if (sheet == null) {
                throw new BOSException("sheet is null.");
            }
            elimCollection = new EliminationCollection();
            HashMap<String, ElimTempletInfo> templateMap = new HashMap<String, ElimTempletInfo>();
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("entries.*"));
            selector.add(new SelectorItemInfo("entries.item.id"));
            selector.add(new SelectorItemInfo("entries.item.number"));
            selector.add(new SelectorItemInfo("entries.item.isProfitAndLosses"));
            selector.add(new SelectorItemInfo("entries.company.number"));
            selector.add(new SelectorItemInfo("eliminationMode.id"));
            view.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("", new HashSet(idList), CompareType.INCLUDE));
            tempCol = iElimTemplet.getElimTempletCollection(view);
            int size = tempCol.size();
            for (i = 0; i < size; ++i) {
                ElimTempletInfo templet = tempCol.get(i);
                templateMap.put(templet.getId().toString(), templet);
            }
            for (i = 0; i < idList.size(); ++i) {
                templateId = (String)idList.get(i);
                templateInfo = (ElimTempletInfo)templateMap.get(templateId);
                if (templateInfo == null) continue;
                elimInfo = new EliminationInfo();
                elimInfo.setId(null);
                elimInfo.setNumber(null);
                elimInfo.setOrgBound(orgTreeInfo);
                if (fullOrgUnit != null) {
                    elimInfo.setOrgUnit(fullOrgUnit);
                } else if (companyOrgUnit != null) {
                    elimInfo.setOrgUnit((OrgUnitInfo)companyOrgUnit);
                }
                elimInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                elimInfo.setCreateTime(createTime);
                elimInfo.setDate(bizDate);
                elimInfo.setSourceCurrency(sourceCurrency);
                elimInfo.setCurrency(currency);
                elimInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
                if (mnsRptGenerate != null && mnsRptGenerate.equals("csl_Rpt_Generate_Entry")) {
                    elimInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
                    elimInfo.setTempletID(templateId);
                    elimInfo.setAuditor((UserInfo)ctx.get((Object)"UserInfo"));
                    elimInfo.setAuditDate(new Timestamp(System.currentTimeMillis()));
                } else {
                    elimInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
                }
                elimInfo.setElimType(ElimTypeEnum.General);
                elimInfo.setValueType(templateInfo.getValueType());
                elimInfo.setIsCitedByLater(templateInfo.getIsCitedByLater());
                elimInfo.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
                elimInfo.setYear(year);
                elimInfo.setPeriod(period);
                elimInfo.setDisplayTemplateType(displayType);
                elimInfo.setEliminationMode(templateInfo.getEliminationMode());
                templeEntryCollection = templateInfo.getEntries();
                if (templeEntryCollection != null && templeEntryCollection.size() > 0) {
                    EliminationEntryInfo elimEntryInfo = null;
                    for (int j = 0; j < templeEntryCollection.size(); ++j) {
                        elimEntryInfo = new EliminationEntryInfo();
                        elimEntryInfo.setId(null);
                        if (mnsRptGenerate != null && mnsRptGenerate.equals("csl_Rpt_Generate_Entry")) {
                            elimEntryInfo.setCompany(fullOrgUnit);
                        } else if (entryCompanyMap != null) {
                            elimEntryInfo.setCompany((FullOrgUnitInfo)entryCompanyMap.get(templeEntryCollection.get(j).getId().toString()));
                        }
                        elimEntryInfo.setItem(templeEntryCollection.get(j).getItem());
                        elimEntryInfo.setSummary(templeEntryCollection.get(j).getSummary());
                        elimEntryInfo.setDataElement(templeEntryCollection.get(j).getDataElement());
                        elimEntryInfo.setIsVisible(true);
                        elimInfo.getEntries().add(elimEntryInfo);
                        Cell cell = null;
                        if (templeEntryCollection.get(j).getDebitFormula() != null) {
                            cell = sheet.getCell(rowIndex, 0, true);
                            cell.setFormula("=" + templeEntryCollection.get(j).getDebitFormula());
                        } else {
                            cell = sheet.getCell(rowIndex, 0, true);
                            cell.setFormula(null);
                            cell.setValue(Variant.nullVariant);
                        }
                        if (templeEntryCollection.get(j).getCreditFormula() != null) {
                            cell = sheet.getCell(rowIndex, 1, true);
                            cell.setFormula("=" + templeEntryCollection.get(j).getCreditFormula());
                        } else {
                            cell = sheet.getCell(rowIndex, 1, true);
                            cell.setFormula(null);
                            cell.setValue(Variant.nullVariant);
                        }
                        ++rowIndex;
                    }
                }
                elimCollection.add(elimInfo);
            }
        }
        if (elimCollection != null) {
            Object[][] values = this.getCalcValues(rowIndex);
            UserInfo currentUser = ContextUtil.getCurrentUserInfo((Context)ctx);
            rowIndex = 0;
            int size = elimCollection.size();
            String[] numbers = CslElimUtil.getBatchNumber(ctx, orgTreeInfo == null ? null : orgTreeInfo.getId().toString(), year, period, periodType, size, orgTreeInfo, (OrgUnitInfo)orgUnitInfo);
            Connection cn = null;
            try {
                cn = EJBFactory.getConnection((Context)ctx);
                IORMappingDAO iORMapping = ORMappingDAO.getInstance((BOSObjectType)new EliminationInfo().getBOSType(), (Context)ctx, (Connection)cn);
                for (int i = 0; i < size; ++i) {
                    int k;
                    EliminationEntryCollection elimEntryCollection = elimCollection.get(i).getEntries();
                    int entrySize = elimEntryCollection.size();
                    ArrayList<EliminationEntryInfo> allEmptyEntryList = new ArrayList<EliminationEntryInfo>();
                    BigDecimal debitSum = new BigDecimal(0.0);
                    BigDecimal creditSum = new BigDecimal(0.0);
                    ArrayList<EliminationEntryInfo> allZeroEntryList = new ArrayList<EliminationEntryInfo>();
                    BigDecimal zero = new BigDecimal("0");
                    for (k = 0; k < entrySize; ++k) {
                        if (values[rowIndex][0] instanceof Number) {
                            elimEntryCollection.get(k).setDebit((BigDecimal)values[rowIndex][0]);
                            debitSum = debitSum.add((BigDecimal)values[rowIndex][0]);
                        }
                        if (values[rowIndex][1] instanceof Number) {
                            elimEntryCollection.get(k).setCredit((BigDecimal)values[rowIndex][1]);
                            creditSum = creditSum.add((BigDecimal)values[rowIndex][1]);
                        }
                        BigDecimal debit = elimEntryCollection.get(k).getDebit();
                        BigDecimal credit = elimEntryCollection.get(k).getCredit();
                        if (debit == null && credit == null) {
                            allEmptyEntryList.add(elimEntryCollection.get(k));
                        }
                        if (debit != null && debit.compareTo(zero) == 0 || credit != null && credit.compareTo(zero) == 0) {
                            allZeroEntryList.add(elimEntryCollection.get(k));
                        }
                        ++rowIndex;
                    }
                    if (allEmptyEntryList.size() == entrySize && allZeroEntryList.size() == entrySize && allEmptyEntryList.size() + allZeroEntryList.size() == entrySize || param && debitSum.compareTo(creditSum) != 0 && mnsRptGenerate != null && mnsRptGenerate.equals("csl_Rpt_Generate_Entry")) continue;
                    for (k = 0; k < allEmptyEntryList.size(); ++k) {
                        if (!elimEntryCollection.contains((EliminationEntryInfo)allEmptyEntryList.get(k))) continue;
                        elimEntryCollection.removeObject((IObjectValue)((EliminationEntryInfo)allEmptyEntryList.get(k)));
                    }
                    for (k = 0; k < allZeroEntryList.size(); ++k) {
                        if (!elimEntryCollection.contains((EliminationEntryInfo)allZeroEntryList.get(k))) continue;
                        elimEntryCollection.removeObject((IObjectValue)((EliminationEntryInfo)allZeroEntryList.get(k)));
                    }
                    elimCollection.get(i).setNumber(numbers[i]);
                    elimCollection.get(i).setCreator(currentUser);
                    elimCollection.get(i).setCreateTime(new Timestamp(new Date().getTime()));
                    if (elimEntryCollection.size() <= 0) continue;
                    this.addnew(ctx, (CoreBaseInfo)elimCollection.get(i));
                    ++successCount;
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            finally {
                SQLUtils.cleanup((Connection)cn);
            }
        }
        return successCount;
    }

    private Sheet initBook(final Context ctx, final OrgUnitInfo orgUnitInfo, final OrgTreeInfo orgTreeInfo, final int year, final short period, final RptPeriodTypeEnum periodType, final CurrencyInfo currency) throws Exception {
        if (this.book == null) {
            this.book = Book.Manager.getNewBook((String)"Sheet1", (int)1);
            this.book.setCalculate(false);
        }
        Sheet sheet = this.book.getSheet(0);
        FormulaDefinition.registerFormulaToBook((Book)this.book, (ICalculateContextProvider)new ICalculateContextProvider(){
            private static final long serialVersionUID = 2342600610859269292L;

            public IErrorProvider getErrorProvider() {
                return null;
            }

            public IErrorResultProvider getErrorResultProvider() {
                return null;
            }

            public IReportPropertyAdapter getReportAdapter() {
                CslReportInfo cslReport = new CslReportInfo();
                cslReport.setOrgTree(orgTreeInfo);
                cslReport.setOrgUnit(orgUnitInfo);
                cslReport.setYear(year);
                cslReport.setPeriod(period);
                cslReport.setPeriodType(periodType);
                cslReport.setCurrency(currency);
                cslReport.setSourceType(RptSrcTypeEnum.CONSOLIDATION);
                CSLPropertyAdapter adapter = new CSLPropertyAdapter(cslReport, ctx);
                return adapter;
            }

            public ReportVariables getReportVariables() {
                return new ReportVariables();
            }

            public Context getServerContext() {
                return ctx;
            }
        });
        return sheet;
    }

    private Object[][] getCalcValues(int entrySize) {
        this.book.calc();
        Sheet sheet = this.book.getSheet(0);
        Cell cell = null;
        Object[][] values = new Object[entrySize][2];
        for (int i = 0; i < entrySize; ++i) {
            cell = sheet.getCell(i, 0, false);
            if (cell != null && cell.getValue() != null) {
                values[i][0] = cell.getValue().getValue();
            }
            if ((cell = sheet.getCell(i, 1, false)) == null || cell.getValue() == null) continue;
            values[i][1] = cell.getValue().getValue();
        }
        return values;
    }

    @Override
    protected int _copyFixedElimData(Context ctx, RptProperties params) throws BOSException, EASBizException {
        DataCollectInfo dataColInfo = (DataCollectInfo)params.getObject("dataCollect");
        int periodType = params.getInt("periodType");
        String treeId = params.getString("treeId");
        String orgUnitId = params.getString("orgUnitId");
        int year = params.getInt("year");
        int period = params.getInt("period");
        Map map = this.getNumber(ctx, orgUnitId, treeId);
        String treeNumber = (String)map.get("treeNumber");
        String unitNumber = (String)map.get("unitNumber");
        int[] pre = null;
        boolean isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod(ctx);
        PeriodCollection periods = null;
        if (this.isMergeByFiscalPeriod(isMergeByFiscalPeriod, RptPeriodTypeEnum.getEnum((int)periodType))) {
            OrgTreeInfo orgTree = new OrgTreeInfo();
            orgTree.setId(BOSUuid.read((String)treeId));
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, orgTree);
        }
        pre = FiscalPeriodHelper.getPrevYearAndPeriod(periods, year, period, RptPeriodTypeEnum.getEnum((int)periodType), isMergeByFiscalPeriod, CslRptUtil.isSupport13Period(ctx));
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> preTree = new ArrayList<String>();
        String tree = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select TPreElim.fid fid, tree.fid tree from T_CSL_Elimination TPreElim ");
        sql.append(" inner join T_ORG_Structure str on str.FUnitID = TPreElim.ForgUnit ");
        sql.append(" inner join T_ORG_Tree tree on tree.FID = TPreElim.FOrgBoundID ");
        sql.append(" where TPreElim.FisFixed = 1");
        sql.append(" and str.FlongNumber = ?");
        sql.append(" and tree.Fnumber = ?");
        sql.append(" and TPreElim.Fyear = ? and TPreElim.Fperiod= ? ");
        sql.append(" and TPreElim.FperiodType = ?");
        sql.append(" and TPreElim.FDataCollectID = ? ");
        Object[] param = new Object[]{unitNumber, treeNumber, new Integer(pre[0]), new Integer(pre[1]), new Integer(periodType), dataColInfo.getId().toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        try {
            while (rs.next()) {
                list.add(rs.getString("fid"));
                tree = rs.getString("tree");
                if (preTree.contains(tree)) continue;
                preTree.add(tree);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (preTree.size() != 0) {
            sql = new StringBuffer();
            sql.append("select unit.Fid fid,str.flongnumber  from t_org_baseunit unit ");
            sql.append(" inner join t_org_structure str on str.funitid = unit.fid");
            sql.append(" where str.ftreeid = ? and str.flongNumber like ?");
            String preTreeId = (String)preTree.get(0);
            IRowSet preIds = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{preTreeId, unitNumber + "!%"});
            HashMap<String, String> preCompany = new HashMap<String, String>();
            try {
                while (preIds.next()) {
                    preCompany.put(preIds.getString("fid"), preIds.getString("flongNumber"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            sql = new StringBuffer();
            sql.append("select unit.Fid fid,str.flongnumber  from t_org_baseunit unit ");
            sql.append(" inner join t_org_structure str on str.funitid = unit.fid");
            sql.append(" where str.ftreeid = ? and str.flongNumber like ?");
            IRowSet ids = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{treeId, unitNumber + "!%"});
            ArrayList<String> companyIds = new ArrayList<String>();
            HashMap<String, String> curCompany = new HashMap<String, String>();
            try {
                while (ids.next()) {
                    companyIds.add(ids.getString("fid"));
                    curCompany.put(ids.getString("fid"), ids.getString("flongNumber"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            EliminationInfo info = null;
            boolean isAllCompanyImport = true;
            for (int i = list.size() - 1; i >= 0; --i) {
                String id = (String)list.get(i);
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
                info = this.getEliminationInfo(ctx, (IObjectPK)pk);
                if (info == null) continue;
                boolean isExist = true;
                EliminationEntryCollection col = info.getEntries();
                for (int j = col.size() - 1; j >= 0; --j) {
                    String preCompanyNumber;
                    EliminationEntryInfo lineInfo = col.get(j);
                    if (!isAllCompanyImport || companyIds == null || lineInfo.getCompany() == null || lineInfo.getCompany().getId() == null) continue;
                    String companyId = lineInfo.getCompany().getId().toString();
                    if (!companyIds.contains(companyId)) {
                        isExist = false;
                        break;
                    }
                    String curCompanyNumber = (String)curCompany.get(companyId);
                    if (curCompanyNumber.equals(preCompanyNumber = (String)preCompany.get(companyId))) continue;
                    isExist = false;
                    break;
                }
                if (isExist) continue;
                list.remove(i);
            }
        }
        if (list.size() == 0) {
            throw new AdjustException(AdjustException.FIXLINE_NOT_EXIST);
        }
        params.setObject("list", list);
        params.setBoolean("isSunElimination", false);
        params.setBoolean("isInitYearProfit", false);
        Map mapResult = this.copyHisData(ctx, params);
        int iSuccessCount = 0;
        if (null != mapResult.get("iSuccessCount")) {
            iSuccessCount = Integer.parseInt((String)mapResult.get("iSuccessCount"));
        }
        return iSuccessCount;
    }

    @Override
    protected boolean _isHaveFixedElimData(Context ctx, RptProperties params) throws BOSException, EASBizException {
        DataCollectInfo dataColInfo = (DataCollectInfo)params.getObject("dataCollect");
        int periodType = params.getInt("periodType");
        String treeId = params.getString("treeId");
        String orgUnitId = params.getString("orgUnitId");
        int year = params.getInt("year");
        int period = params.getInt("period");
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid from T_CSL_Elimination ");
        sql.append(" where FisFixed = 1");
        sql.append(" and FOrgBoundID = '" + treeId + "'");
        sql.append(" and FOrgUnit = '" + orgUnitId + "'");
        sql.append(" and Fyear = " + year + " and Fperiod=" + period);
        sql.append(" and FperiodType = " + periodType);
        sql.append(" and FDataCollectID = '" + dataColInfo.getId().toString() + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs.size() > 0;
    }

    private Map getNumber(Context ctx, String orgUnitId, String orgTreeId) throws BOSException {
        HashMap<String, String> numbers = new HashMap<String, String>();
        String sql = "select fnumber from t_org_tree where fid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgTreeId});
        try {
            while (rs.next()) {
                String treeNumber = rs.getString("fnumber");
                numbers.put("treeNumber", treeNumber);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        String newSql = "select flongnumber from T_ORG_Structure where funitid = ?";
        IRowSet newrs = DbUtil.executeQuery((Context)ctx, (String)newSql, (Object[])new Object[]{orgUnitId});
        try {
            while (newrs.next()) {
                String unitNumber = newrs.getString("flongnumber");
                numbers.put("unitNumber", unitNumber);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return numbers;
    }

    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        if (EliminateUtil.isNeedRecyleNumber(ctx)) {
            EliminationCollection elimCol = this.getEliminationCollection(ctx, oql);
            EliminationInfo info = null;
            String[] numbers = new String[elimCol.size()];
            int size = elimCol.size();
            for (int i = 0; i < size; ++i) {
                info = elimCol.get(i);
                numbers[i] = info.getNumber();
            }
            EliminateUtil.batchRecyleNumber(ctx, info, numbers);
        }
        return super._delete(ctx, oql);
    }

    private EliminationEntryInfo addEliminationEntry(Context ctx, EliminationInfo info, BigDecimal debitTotal, BigDecimal creditTotal, int seq, int j, ArrayList comapanyList, boolean isOverSer) throws BOSException, EASBizException {
        BigDecimal resultTotal = null;
        BigDecimal zeroValue = new BigDecimal("0");
        EliminationEntryInfo anotherLineInfo = new EliminationEntryInfo();
        anotherLineInfo.setSeq(seq);
        anotherLineInfo.setIsVisible(false);
        anotherLineInfo.setDataElement(4);
        anotherLineInfo.setItem(this.getUnAssignRptItemId(ctx, isOverSer));
        anotherLineInfo.setElimination(info);
        if (!"".equals(comapanyList.get(j).toString())) {
            anotherLineInfo.setCompany((FullOrgUnitInfo)comapanyList.get(j));
        } else {
            anotherLineInfo.setCompany(null);
        }
        anotherLineInfo.setSummary(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"Elim_Auto_Summary", (Locale)ctx.getOriginLocale()));
        resultTotal = debitTotal.subtract(creditTotal);
        if (resultTotal.compareTo(zeroValue) > 0) {
            anotherLineInfo.setDebit(resultTotal);
            anotherLineInfo.setCredit(null);
        }
        if (resultTotal.compareTo(zeroValue) < 0) {
            anotherLineInfo.setCredit(resultTotal.abs());
            anotherLineInfo.setDebit(null);
        }
        return anotherLineInfo;
    }

    private boolean isMergeByFiscalPeriod(boolean isMergeByFiscalPeriod, RptPeriodTypeEnum periodType) {
        return FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodType);
    }

    @Override
    protected Map _synBasicScopeData(Context ctx, RptProperties rptProperties) throws BOSException, EASBizException {
        String orgTreeID;
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)rptProperties.getObject("KEY_ORGTREE_INFO");
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)rptProperties.getObject("KEY_ORGUNIT_INFO");
        String orgUnitID = orgUnitInfo.getId().toString();
        OrgStructureCollection orgStructureCollection = this.getOrgStructureCollection(ctx, orgUnitID, orgTreeID = orgTreeInfo.getId().toString());
        if (null == orgStructureCollection || orgStructureCollection.size() == 0) {
            return null;
        }
        String strLongNumber = orgStructureCollection.get(0).getLongNumber() + "%";
        IRowSet rs = this.getSourceEliminationInfo(ctx, rptProperties, orgUnitID, orgTreeID, strLongNumber);
        ArrayList<String> sourceEliminationIds = new ArrayList<String>();
        ArrayList<String> targetEliminationIds = new ArrayList<String>();
        try {
            while (rs.next()) {
                sourceEliminationIds.add(rs.getString("sourceEliminationID"));
                targetEliminationIds.add(rs.getString("ID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        if (null == sourceEliminationIds || sourceEliminationIds.size() == 0) {
            map.put("notDataNeedSyn", "notDataNeedSyn");
            return map;
        }
        List lstComanyIds = this.getAllCompanyIds(ctx, strLongNumber, orgTreeID);
        rptProperties.setObject("list", sourceEliminationIds);
        rptProperties.setObject("targetEliminationIds", targetEliminationIds);
        rptProperties.setBoolean("isSynBasicScopeData", true);
        rptProperties.setObject("companyIds", lstComanyIds);
        this._copyHisData(ctx, rptProperties);
        map.put("synSuccess", "synSuccess");
        return map;
    }

    private IRowSet getSourceEliminationInfo(Context ctx, RptProperties rptProperties, String orgUnitID, String orgTreeID, String strLongNumber) throws BOSException, EASBizException {
        String year = rptProperties.getObject("year").toString();
        String period = rptProperties.getObject("period").toString();
        String periodType = rptProperties.getObject("periodType").toString();
        StringBuffer sql = new StringBuffer(300);
        sql.append(" select t1.FsourceEliminationID as sourceEliminationID , t1.Fid as ID from T_CSL_Elimination t1 inner join T_ORG_Structure t2 ");
        sql.append(" on t1.FOrgUnit = t2.FUnitId  ");
        sql.append(" and t1.FOrgBoundID = t2.FTreeId ");
        sql.append(" where t1.FCheckedStatus=1 and t1.FOrgBoundID = ? and t2.FLongNumber like ? and t1.Fyear = ? and t1.Fperiod = ? and t1.FPeriodType = ? ");
        sql.append(" and  t1.FsourceEliminationID is not null  ");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgTreeID, strLongNumber, year, period, periodType});
    }

    private List getAllCompanyIds(Context ctx, String strLongNumber, String orgTreeID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer(100);
        sql.append(" select funitid ID from t_org_structure where flongnumber like ? ");
        sql.append(" and ftreeid= ?  ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{strLongNumber, orgTreeID});
        return this.getListIds(rs);
    }

    private List getListIds(IRowSet rs) throws BOSException, EASBizException {
        ArrayList<String> lstIds = new ArrayList<String>();
        try {
            while (rs.next()) {
                lstIds.add(rs.getString("ID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return lstIds;
    }

    private OrgStructureCollection getOrgStructureCollection(Context ctx, String orgUnitID, String orgTreeID) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)orgTreeID));
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)orgUnitID));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        OrgStructureCollection orgStructureCollection = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection(view);
        return orgStructureCollection;
    }

    private List getOrgStructureChildCompany(Context ctx, String orgUnitId, String orgTreeId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer(100);
        sql.append(" select s1.funitid as ID from t_org_structure s1 ");
        sql.append(" inner join t_org_structure s2 on s1.FParentID = s2.fid   ");
        sql.append(" where s2.FTreeId = ?  AND s2.FUnitId = ?   ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgTreeId, orgUnitId});
        List companyIdsByOrdinal = this.getListIds(rs);
        return companyIdsByOrdinal;
    }

    @Override
    protected Map _autoGenerateElim(Context ctx, Map mapParams) throws BOSException, EASBizException {
        ElimTempletCollection templetCollection;
        HashMap<String, String> parMap = new HashMap<String, String>();
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)mapParams.get("orgTreeInfo");
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)mapParams.get("KeyOrgUnit");
        CurrencyInfo sourceCurrencyInfo = (CurrencyInfo)mapParams.get("sourceCurrency");
        CurrencyInfo currencyInfo = (CurrencyInfo)mapParams.get("currency");
        if (null != orgTreeInfo && null != orgUnitInfo) {
            parMap.put("orgBoundId", orgTreeInfo.getId().toString());
            parMap.put("orgUnitID", orgUnitInfo.getId().toString());
            parMap.put("currency", currencyInfo.getId().toString());
            parMap.put("sourceCurrency", sourceCurrencyInfo.getId().toString());
            parMap.put("year", (String)mapParams.get("year"));
            parMap.put("period", (String)mapParams.get("period"));
        }
        if (null == (templetCollection = this.getCurrentEliminationTemplate(ctx, parMap)) || templetCollection.size() == 0) {
            return null;
        }
        List lstTempleteIds = this.generateTempParams(templetCollection);
        int successCount = 0;
        if (null != lstTempleteIds && lstTempleteIds.size() > 0) {
            this.removeExitElimTempletID(ctx, lstTempleteIds, parMap);
            successCount = this.doTemplateBatchImportElimRecords(ctx, lstTempleteIds, mapParams);
        }
        HashMap<String, Integer> mapResult = new HashMap<String, Integer>(1);
        mapResult.put("successCount", new Integer(successCount));
        return mapResult;
    }

    public List generateTempParams(ElimTempletCollection templetCollection) {
        ElimTempletInfo templetInfo = null;
        Object entryColl = null;
        Object elimTempEntryInfo = null;
        Object acctItemFormula = null;
        ArrayList<String> lstTempParams = new ArrayList<String>();
        String templetID = null;
        int iSize = templetCollection.size();
        for (int i = 0; i < iSize; ++i) {
            templetInfo = templetCollection.get(i);
            templetID = templetInfo.getId().toString();
            lstTempParams.add(templetID);
        }
        return lstTempParams;
    }

    private void generateTempIds(Set setIDs, Map mapTempParams, List lstTempParams, AcctItemFormula acctItemFormula, String templetID) {
        StringBuffer sbTempParams = new StringBuffer();
        String itemNumberStart = acctItemFormula.getItemNumberStart();
        if (null != acctItemFormula.getItemNumberStart() && null != acctItemFormula.getDataElement() && null != acctItemFormula.getMoney()) {
            if (null == itemNumberStart) {
                itemNumberStart = acctItemFormula.getItemNumberEnd();
            }
            sbTempParams.append(acctItemFormula.getItemNumberStart()).append(acctItemFormula.getDataElement()).append(acctItemFormula.getMoney());
        }
        if (null != lstTempParams && lstTempParams.contains(sbTempParams.toString())) {
            setIDs = (HashSet)mapTempParams.get(sbTempParams.toString());
            setIDs.add(templetID);
            mapTempParams.put(sbTempParams.toString(), setIDs);
        } else {
            setIDs.add(templetID);
            mapTempParams.put(sbTempParams.toString(), setIDs);
            lstTempParams.add(sbTempParams.toString());
        }
    }

    private void deleteElim(Context ctx, List lstIDs) throws BOSException {
        if (null != lstIDs && lstIDs.size() > 0) {
            IObjectPK[] deletePKs = new IObjectPK[lstIDs.size()];
            int iSize = lstIDs.size();
            for (int i = 0; i < iSize; ++i) {
                deletePKs[i] = new ObjectUuidPK(BOSUuid.read((String)lstIDs.get(i).toString()));
            }
            try {
                this.deleteBatchData(ctx, deletePKs);
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void removeExitElimTempletID(Context ctx, List lstTempIDs, Map mapOrgAndUnit) throws BOSException {
        StringBuffer sbSql = new StringBuffer();
        sbSql.append(" select FTempletID from T_CSL_Elimination ");
        sbSql.append("  where FOrgBoundID='").append(mapOrgAndUnit.get("orgBoundId")).append("' ");
        sbSql.append("  and FOrgUnit='").append(mapOrgAndUnit.get("orgUnitID")).append("' ");
        sbSql.append("  and FCurrencyID='").append(mapOrgAndUnit.get("currency")).append("' ");
        sbSql.append("  and FSourceCurrencyID='").append(mapOrgAndUnit.get("sourceCurrency")).append("' ");
        sbSql.append("  and Fyear=").append(mapOrgAndUnit.get("year"));
        sbSql.append("  and Fperiod=").append(mapOrgAndUnit.get("period"));
        ArrayList exitTempletID = new ArrayList();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString());
        try {
            while (rs.next()) {
                lstTempIDs.remove(rs.getString("FTempletID"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private List getListIds(List lstTempleteIds) {
        ArrayList<String> lstIds = new ArrayList<String>();
        String strId = null;
        int iSize = lstTempleteIds.size();
        for (int i = 0; i < iSize; ++i) {
            strId = lstTempleteIds.get(i).toString();
            if (lstIds.contains(strId = strId.substring(1, strId.length() - 1))) continue;
            lstIds.add(strId);
        }
        return lstIds;
    }

    private List generateListTempIds(Map mapTempParams, List lstTempParams, List lstParams) {
        ArrayList lstTempleteIds = new ArrayList();
        String strKey = null;
        if (null != lstParams && lstParams.size() > 0) {
            int iLstParamSize = lstParams.size();
            for (int i = 0; i < iLstParamSize; ++i) {
                strKey = lstParams.get(i).toString();
                if (!lstTempParams.contains(strKey)) continue;
                lstTempleteIds.add(mapTempParams.get(strKey));
            }
        }
        return lstTempleteIds;
    }

    @Override
    protected IRowSet _getElimRecordBySourceBound(Context ctx, int period, int year, int periodType, String sourceTreeId, String importTreeId, String orgUnitId, boolean isForBugetBound, String elimModeIds) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select s2.funitid as FCompanyId from t_org_structure s1 ");
        sql.append(" inner join t_org_structure s2 on s1.ftreeid = s2.ftreeid ");
        sql.append(" and charindex(s1.flongnumber||'!', s2.flongnumber)=1 ");
        sql.append(" where s1.ftreeid = '" + importTreeId + "' and s1.funitid = '" + orgUnitId + "' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean[] values = CSLParamUtil.batchGetParam(ctx, new String[]{"GR_CSL_AdjustRPTMDisplayByOrg", "GR_CSL_MergeByFiscalPeriod", "GR_CSL_SupportOtherDS"});
        boolean isDisplayAdjustRPTMByOrg = values[0];
        boolean isMergeByFiscalPeriod = values[1];
        boolean isSupportOtherDS = values[2];
        StringBuffer bf = new StringBuffer("");
        try {
            Set orgIDSet = null;
            if (isDisplayAdjustRPTMByOrg) {
                orgIDSet = CslOrgTreeUtil.getPermOrgUnitSetForServer(ctx, importTreeId, orgUnitId, ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString());
            }
            while (rs.next()) {
                if (isDisplayAdjustRPTMByOrg && orgIDSet != null) {
                    if (!orgIDSet.contains(rs.getString("FCompanyId"))) continue;
                    bf.append("'" + rs.getString("FCompanyId") + "',");
                    continue;
                }
                bf.append("'" + rs.getString("FCompanyId") + "',");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (0 < rs.size()) {
            bf.deleteCharAt(bf.lastIndexOf(","));
        }
        DataCollectInfo dataCollectInfo = new DataCollectInfo();
        dataCollectInfo.setNumber("BUDGETDATA");
        boolean hasBudgetedPermission = false;
        boolean hasACPermission = true;
        if (isSupportOtherDS) {
            hasBudgetedPermission = CSLPermissionUtil.hasDataCollectPermission(ctx, ctx.getCaller().toString(), dataCollectInfo, isSupportOtherDS);
            dataCollectInfo.setNumber("ACTUALDATA");
            hasACPermission = CSLPermissionUtil.hasDataCollectPermission(ctx, ctx.getCaller().toString(), dataCollectInfo, isSupportOtherDS);
        }
        StringBuffer querySql = new StringBuffer();
        querySql.append("SELECT T0.FID ID, T0.FNUMBER NUMBER, T0.FYEAR YEAR, T0.FPERIOD PERIOD, T0.FCURRENCYID CURRENCYID, T0.FVALUETYPE VALUETYPE,");
        querySql.append("T2.FNUMBER ITEM, T1.FDEBIT DEBIT, T1.FCREDIT CREDIT,T1.FDATAELEMENT DATAELEMENT,T3.FNUMBER DATAELEMENTNUMBER ");
        querySql.append(" FROM T_CSL_ELIMINATION T0 ");
        querySql.append(" INNER JOIN T_CSL_ELIMINATIONENTRY T1 ON T0.FID = T1.FELIMINATIONID");
        querySql.append(" INNER JOIN T_CSL_RPTITEM T2 ON T2.FID = T1.FITEMID");
        querySql.append(" INNER JOIN t_csl_dataelement T3 ON T3.finterseq = T1.FDATAELEMENT");
        querySql.append(" WHERE T0.FYEAR =").append(year);
        querySql.append(" AND T0.FPERIOD =").append(period);
        querySql.append(" AND T0.FPERIODTYPE =").append(periodType);
        querySql.append(" AND T0.FORGBOUNDID ='").append(sourceTreeId).append("'");
        querySql.append(" AND T0.FCHECKEDSTATUS =").append(2);
        if (!StringUtils.isEmpty((String)elimModeIds)) {
            querySql.append(" AND T0.FELIMINATIONMODEID IN(").append(elimModeIds).append(")");
        }
        if (!StringUtils.isEmpty((String)bf.toString())) {
            querySql.append(" AND T1.FCOMPANYID IN (").append(bf.toString()).append(")");
        }
        if (!hasBudgetedPermission) {
            querySql.append(" AND T0.FDATACOLLECTNUMBER <>'").append("BUDGETDATA").append("'");
        }
        if (!hasACPermission) {
            querySql.append(" AND T0.FDATACOLLECTNUMBER <>'").append("ACTUALDATA").append("'");
        }
        querySql.append(" ORDER BY FItemID");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        return iRowSet;
    }

    @Override
    protected List _getChechDataIds(Context ctx, List ids) throws BOSException {
        ArrayList checkageDataIds = new ArrayList();
        HashMap<String, String> rsTemp = new HashMap<String, String>();
        int size = ids.size();
        if (size == 0) {
            return checkageDataIds;
        }
        StringBuffer selectSql = new StringBuffer("select FCheckageDataID,FEliminationID from t_csl_Elimrecord where FEliminationID in(");
        for (int i = 0; i < size; ++i) {
            selectSql.append("'");
            selectSql.append(ids.get(i));
            selectSql.append("'");
            if (i == size - 1) continue;
            selectSql.append(",");
        }
        selectSql.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        try {
            while (rs.next()) {
                rsTemp.put(rs.getString("FEliminationID"), rs.getString("FCheckageDataID"));
            }
            for (int i = 0; i < size; ++i) {
                String elimId = (String)ids.get(i);
                if (StringUtils.isEmpty((String)((String)rsTemp.get(elimId)))) continue;
                checkageDataIds.add(rsTemp.get(elimId));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return checkageDataIds;
    }

    @Override
    protected Map _batchAuditOrUnAudit(Context ctx, List elimIDs, CheckedStatusEnum auditStatus) throws BOSException, EASBizException {
        HashMap<String, Object> chkRst = new HashMap<String, Object>();
        if (elimIDs != null && elimIDs.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("orgUnit.name"));
            selector.add(new SelectorItemInfo("entries.*"));
            selector.add(new SelectorItemInfo("entries.item.number"));
            selector.add(new SelectorItemInfo("entries.company.number"));
            selector.add(new SelectorItemInfo("entries.company.name"));
            view.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItemInfo = new FilterItemInfo("id", new HashSet(elimIDs), CompareType.INCLUDE);
            filter.getFilterItems().add(filterItemInfo);
            view.setFilter(filter);
            long starttime = System.currentTimeMillis();
            EliminationCollection col = this.getEliminationCollection(ctx, view);
            long spantime = System.currentTimeMillis() - starttime;
            System.out.println("getelimDataSpan:" + spantime);
            starttime = System.currentTimeMillis();
            if (CheckedStatusEnum.AUDITED.equals((Object)auditStatus)) {
                this.doAuditRecord(ctx, col, chkRst);
            } else {
                this.doUnAuditRecord(ctx, col, chkRst);
            }
            spantime = System.currentTimeMillis() - starttime;
            System.out.println("handleElimDataSpan:" + spantime);
        }
        return chkRst;
    }

    private void doAuditRecord(Context ctx, EliminationCollection col, Map<String, Object> chkRst) throws BOSException, EASBizException {
        boolean param = Boolean.valueOf(ParamManager.getParamValue((Context)ctx, null, (String)"GR_CSL_DCBalance"));
        ArrayList<String> NoBalanceEntryIDList = new ArrayList<String>();
        String errMsg = null;
        ArrayList<String> auditedList = new ArrayList<String>();
        HashSet<String> successIDs = new HashSet<String>();
        ArrayList<Object[]> params = new ArrayList<Object[]>(col.size());
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        String updateSql = "update t_csl_elimination set FCHECKEDSTATUS = ? ,FAUDITORID = ?,FAUDITDATE = ? where FID = ? ";
        ArrayList<IObjectPK> logPks = new ArrayList<IObjectPK>();
        String msg = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            EliminationInfo info = col.get(i);
            if (info.getCheckedStatus() == CheckedStatusEnum.AUDITED) {
                auditedList.add(info.getNumber());
                continue;
            }
            if (param) {
                BigDecimal debitSum = new BigDecimal(0.0);
                BigDecimal creditSum = new BigDecimal(0.0);
                BigDecimal zero = new BigDecimal(0.0);
                EliminationEntryCollection eliminationEntryColl = info.getEntries();
                EliminationEntryInfo eliminationEntryInfo = null;
                for (int k = 0; eliminationEntryColl != null && k < eliminationEntryColl.size(); ++k) {
                    eliminationEntryInfo = eliminationEntryColl.get(k);
                    if (!eliminationEntryInfo.isIsVisible()) continue;
                    if (eliminationEntryInfo.getDebit() != null && eliminationEntryInfo.getDebit().compareTo(zero) != 0) {
                        debitSum = debitSum.add(eliminationEntryInfo.getDebit());
                        continue;
                    }
                    if (eliminationEntryInfo.getCredit() == null || eliminationEntryInfo.getCredit().compareTo(zero) == 0) continue;
                    creditSum = creditSum.add(eliminationEntryInfo.getCredit());
                }
                if (debitSum.compareTo(creditSum) != 0) {
                    boolean isCheckPlatform = ElimDataSourceEnum.checkagePlatform.equals((Object)info.getElimDataSource());
                    if (msg == null) {
                        msg = isCheckPlatform ? ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"455NoBalance", (Locale)ctx.getLocale()) : ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"8_AdjustListUI", (Locale)ctx.getLocale());
                    }
                    errMsg = isCheckPlatform ? MessageFormat.format(msg, info.getOrgUnit().getName(), info.getNumber(), debitSum, creditSum) : MessageFormat.format(msg, info.getNumber(), debitSum, creditSum);
                    NoBalanceEntryIDList.add(errMsg);
                    continue;
                }
            }
            params.add(new Object[]{CheckedStatusEnum.AUDITED.getValue(), user.getId().toString(), new Timestamp(System.currentTimeMillis()), info.getId().toString()});
            successIDs.add(info.getId().toString());
            String logName = info.getNumber();
            IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"doAuditRecord", (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId()), (String)logName, (String)"csl_elivoucher_approve");
            logPks.add(logPk);
        }
        if (params.size() > 0) {
            Object[][] objectParams = new Object[params.size()][];
            for (int i = 0; i < params.size(); ++i) {
                objectParams[i] = (Object[])params.get(i);
            }
            CslRptUtil.batchExecute(ctx, updateSql, objectParams);
        }
        chkRst.put("auditedList", auditedList);
        chkRst.put("NoBalanceEntryIDList", NoBalanceEntryIDList);
        chkRst.put("successIDs", successIDs);
        if (logPks.size() > 0) {
            for (IObjectPK logPk : logPks) {
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
            }
        }
    }

    private void doUnAuditRecord(Context ctx, EliminationCollection col, Map<String, Object> chkRst) throws BOSException, EASBizException {
        HashSet<String> successIDs = new HashSet<String>();
        ArrayList<String> unAuditList = new ArrayList<String>();
        ArrayList<String> alreadyArchiverd = new ArrayList<String>();
        ArrayList<String> isParamTrue = new ArrayList<String>();
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        boolean canUnAuditCheck = CslRptUtil.canUnAuditCheck(ctx);
        ArrayList<Object[]> params = new ArrayList<Object[]>(col.size());
        String updateSql = "update t_csl_elimination set FCHECKEDSTATUS = ? ,FAUDITORID = ?,FAUDITDATE = ? where FID = ? ";
        ArrayList<IObjectPK> logPks = new ArrayList<IObjectPK>();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            EliminationInfo info = col.get(i);
            if (info.getCheckedStatus().equals((Object)CheckedStatusEnum.UNAUDITED)) {
                unAuditList.add(info.getNumber());
                continue;
            }
            if (info.getArchivedStatus().equals((Object)ArchivedStatusEnum.ARCHIVED)) {
                alreadyArchiverd.add(info.getNumber());
                continue;
            }
            if (!user.getId().equals((Object)info.getAuditor().getId()) && canUnAuditCheck) {
                isParamTrue.add(info.getNumber());
                continue;
            }
            params.add(new Object[]{CheckedStatusEnum.UNAUDITED.getValue(), null, null, info.getId().toString()});
            successIDs.add(info.getId().toString());
            String logName = info.getNumber();
            IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"doUnAuditRecord", (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId()), (String)logName, (String)"csl_elivoucher_unapprove");
            logPks.add(logPk);
        }
        if (params.size() > 0) {
            Object[][] objectParams = new Object[params.size()][];
            for (int i = 0; i < params.size(); ++i) {
                objectParams[i] = (Object[])params.get(i);
            }
            CslRptUtil.batchExecute(ctx, updateSql, objectParams);
        }
        chkRst.put("unAuditList", unAuditList);
        chkRst.put("alreadyArchiverd", alreadyArchiverd);
        chkRst.put("isParamTrue", isParamTrue);
        chkRst.put("successIDs", successIDs);
        if (logPks.size() > 0) {
            for (IObjectPK logPk : logPks) {
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
            }
        }
    }

    @Override
    protected IObjectPK _addnewHand(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        EliminationInfo info = (EliminationInfo)model;
        this.addnewCheck(ctx, info);
        this.doParentItems(ctx, info, false);
        RptItemRelationshipFactory.getLocalInstance(ctx).autoCreateRelationshipItems(info);
        this.handleAmountPrecision(ctx, (IObjectValue)model);
        return super._addnew(ctx, (IObjectValue)model);
    }

    @Override
    protected void _batchSubmitDataAndDoSpecialRptItem(Context ctx, CoreBaseCollection eliminationCollection) throws BOSException, EASBizException {
        for (int i = 0; i < eliminationCollection.size(); ++i) {
            this.beforeAddNewPreData(ctx, (IObjectValue)eliminationCollection.get(i));
        }
        EliminationFactory.getLocalInstance(ctx).submitBatchData(eliminationCollection);
    }

    private void beforeAddNewPreData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, (EliminationInfo)model);
        this.doSpecialRptItem(ctx, model);
        this.setInvAndTargetCompanyEntryInfo((EliminationInfo)model);
        this.handleAmountPrecision(ctx, model);
    }

    @Override
    protected void _removeCache(Context ctx) throws BOSException {
        CustomCacheService customCacheService = new CustomCacheService("permission.orgPerm");
        String key = ctx.getCaller().toString();
        StringBuffer cacheType = new StringBuffer();
        cacheType.append(ConfigMDUtil.getAIS()).append("#").append("permission.orgPerm");
        key = key + MapCacheUtil.getInstance().getMapFlag(cacheType.toString(), key) + "csl_elivoucher_list";
        customCacheService.remove(key);
    }

    @Override
    protected void _batchGenarateElimnationByTemplate(Context ctx, Map params) throws BOSException, EASBizException {
        EliminationCollection elims = (EliminationCollection)((Object)params.get("elims"));
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)params.get("orgTree");
        int year = (Integer)params.get("year");
        int period = (Integer)params.get("period");
        int periodType = (Integer)params.get("periodType");
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)params.get("orgUnit");
        int size = elims.size();
        String[] numbers = CslElimUtil.getBatchNumber(ctx, orgTreeInfo == null ? null : orgTreeInfo.getId().toString(), year, period, periodType, size, orgTreeInfo, orgUnitInfo);
        for (int i = 0; i < size; ++i) {
            String number = numbers[i];
            EliminationInfo elim = elims.get(i);
            elim.setNumber(number);
            this.addnew(ctx, (CoreBaseInfo)elim);
        }
    }
}

