/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimDynaItemEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimRelaOrgTreeCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimRelaOrgTreeFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimRelaOrgTreeInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IElimRelaOrgTree;
import com.kingdee.eas.fi.gr.cslrpt.IElimination;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.IsCitedByLaterEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemControlEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.gr.fast.FastMergeExecSelector;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EliminationEntryCopy {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.EliminationEntryCopy");
    private IElimination iElimination;

    public List<IObjectPK> copyFixedElimData(Context ctx, RptProperties params) throws BOSException, EASBizException {
        DataCollectInfo dataColInfo = (DataCollectInfo)params.getObject("dataCollect");
        int periodType = params.getInt("periodType");
        String treeId = params.getString("treeId");
        String orgUnitId = params.getString("orgUnitId");
        int year = params.getInt("year");
        int period = params.getInt("period");
        Map map = this.getNumber(ctx, orgUnitId, treeId);
        String treeNumber = (String)map.get("treeNumber");
        String unitNumber = (String)map.get("unitNumber");
        int[] pre = null;
        boolean isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod(ctx);
        PeriodCollection periods = null;
        if (this.isMergeByFiscalPeriod(isMergeByFiscalPeriod, RptPeriodTypeEnum.getEnum((int)periodType))) {
            OrgTreeInfo orgTree = new OrgTreeInfo();
            orgTree.setId(BOSUuid.read((String)treeId));
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, orgTree);
        }
        pre = FiscalPeriodHelper.getPrevYearAndPeriod(periods, year, period, RptPeriodTypeEnum.getEnum((int)periodType), isMergeByFiscalPeriod, CslRptUtil.isSupport13Period(ctx));
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> preTree = new ArrayList<String>();
        String tree = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select TPreElim.fid fid, tree.fid tree from T_CSL_Elimination TPreElim ");
        sql.append(" inner join T_ORG_Structure str on str.FUnitID = TPreElim.ForgUnit ");
        sql.append(" inner join T_ORG_Tree tree on tree.FID = TPreElim.FOrgBoundID ");
        sql.append(" where TPreElim.FisFixed = 1");
        sql.append(" and str.FlongNumber = ?");
        sql.append(" and tree.Fnumber = ?");
        sql.append(" and TPreElim.Fyear = ? and TPreElim.Fperiod= ? ");
        sql.append(" and TPreElim.FperiodType = ?");
        sql.append(" and TPreElim.FDataCollectID = ? ");
        Object[] param = new Object[]{unitNumber, treeNumber, new Integer(pre[0]), new Integer(pre[1]), new Integer(periodType), dataColInfo.getId().toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        try {
            while (rs.next()) {
                list.add(rs.getString("fid"));
                tree = rs.getString("tree");
                if (preTree.contains(tree)) continue;
                preTree.add(tree);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (preTree.size() != 0) {
            sql = new StringBuffer();
            sql.append("select unit.Fid fid,str.flongnumber  from t_org_baseunit unit ");
            sql.append(" inner join t_org_structure str on str.funitid = unit.fid");
            sql.append(" where str.ftreeid = ? and str.flongNumber like ?");
            String preTreeId = (String)preTree.get(0);
            IRowSet preIds = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{preTreeId, unitNumber + "!%"});
            HashMap<String, String> preCompany = new HashMap<String, String>();
            try {
                while (preIds.next()) {
                    preCompany.put(preIds.getString("fid"), preIds.getString("flongNumber"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            sql = new StringBuffer();
            sql.append("select unit.Fid fid,str.flongnumber  from t_org_baseunit unit ");
            sql.append(" inner join t_org_structure str on str.funitid = unit.fid");
            sql.append(" where str.ftreeid = ? and str.flongNumber like ?");
            IRowSet ids = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{treeId, unitNumber + "!%"});
            ArrayList<String> companyIds = new ArrayList<String>();
            HashMap<String, String> curCompany = new HashMap<String, String>();
            try {
                while (ids.next()) {
                    companyIds.add(ids.getString("fid"));
                    curCompany.put(ids.getString("fid"), ids.getString("flongNumber"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            EliminationInfo info = null;
            boolean isAllCompanyImport = true;
            this.initIElimination(ctx);
            for (int i = list.size() - 1; i >= 0; --i) {
                String id = (String)list.get(i);
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
                info = this.iElimination.getEliminationInfo((IObjectPK)pk);
                if (info == null) continue;
                boolean isExist = true;
                EliminationEntryCollection col = info.getEntries();
                for (int j = col.size() - 1; j >= 0; --j) {
                    String preCompanyNumber;
                    EliminationEntryInfo lineInfo = col.get(j);
                    if (!isAllCompanyImport || companyIds == null || lineInfo.getCompany() == null) continue;
                    String companyId = lineInfo.getCompany().getId().toString();
                    if (!companyIds.contains(companyId)) {
                        isExist = false;
                        break;
                    }
                    String curCompanyNumber = (String)curCompany.get(companyId);
                    if (curCompanyNumber.equals(preCompanyNumber = (String)preCompany.get(companyId))) continue;
                    isExist = false;
                    break;
                }
                if (isExist) continue;
                list.remove(i);
            }
        }
        if (list.size() == 0) {
            throw new AdjustException(AdjustException.FIXLINE_NOT_EXIST);
        }
        params.setObject("list", list);
        params.setBoolean("isSunElimination", false);
        params.setBoolean("isInitYearProfit", false);
        return this.copyHisData(ctx, params);
    }

    public List<IObjectPK> importFromBaseOrgBound(Context ctx, RptProperties params) throws BOSException, EASBizException {
        DataCollectInfo dataColInfo = (DataCollectInfo)params.getObject("dataCollect");
        int periodType = params.getInt("periodType");
        String treeId = params.getString("treeId");
        String orgUnitId = params.getString("orgUnitId");
        int year = params.getInt("year");
        int period = params.getInt("period");
        Map map = this.getNumber(ctx, orgUnitId, treeId);
        String treeNumber = (String)map.get("treeNumber");
        String unitNumber = (String)map.get("unitNumber");
        int[] pre = null;
        boolean isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod(ctx);
        PeriodCollection periods = null;
        if (this.isMergeByFiscalPeriod(isMergeByFiscalPeriod, RptPeriodTypeEnum.getEnum((int)periodType))) {
            OrgTreeInfo orgTree = new OrgTreeInfo();
            orgTree.setId(BOSUuid.read((String)treeId));
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, orgTree);
        }
        pre = FiscalPeriodHelper.getPrevYearAndPeriod(periods, year, period, RptPeriodTypeEnum.getEnum((int)periodType), isMergeByFiscalPeriod, CslRptUtil.isSupport13Period(ctx));
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> preTree = new ArrayList<String>();
        String tree = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select TPreElim.fid fid, tree.fid tree from T_CSL_Elimination TPreElim ");
        sql.append(" inner join T_ORG_Structure str on str.FUnitID = TPreElim.ForgUnit ");
        sql.append(" inner join T_ORG_Tree tree on tree.FID = TPreElim.FOrgBoundID ");
        sql.append(" where TPreElim.FisFixed = 1");
        sql.append(" and str.FlongNumber = ?");
        sql.append(" and tree.Fnumber = ?");
        sql.append(" and TPreElim.Fyear = ? and TPreElim.Fperiod= ? ");
        sql.append(" and TPreElim.FperiodType = ?");
        sql.append(" and TPreElim.FDataCollectID = ? ");
        Object[] param = new Object[]{unitNumber, treeNumber, new Integer(pre[0]), new Integer(pre[1]), new Integer(periodType), dataColInfo.getId().toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        try {
            while (rs.next()) {
                list.add(rs.getString("fid"));
                tree = rs.getString("tree");
                if (preTree.contains(tree)) continue;
                preTree.add(tree);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (preTree.size() != 0) {
            sql = new StringBuffer();
            sql.append("select unit.Fid fid,str.flongnumber  from t_org_baseunit unit ");
            sql.append(" inner join t_org_structure str on str.funitid = unit.fid");
            sql.append(" where str.ftreeid = ? and str.flongNumber like ?");
            String preTreeId = (String)preTree.get(0);
            IRowSet preIds = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{preTreeId, unitNumber + "!%"});
            HashMap<String, String> preCompany = new HashMap<String, String>();
            try {
                while (preIds.next()) {
                    preCompany.put(preIds.getString("fid"), preIds.getString("flongNumber"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            sql = new StringBuffer();
            sql.append("select unit.Fid fid,str.flongnumber  from t_org_baseunit unit ");
            sql.append(" inner join t_org_structure str on str.funitid = unit.fid");
            sql.append(" where str.ftreeid = ? and str.flongNumber like ?");
            IRowSet ids = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{treeId, unitNumber + "!%"});
            ArrayList<String> companyIds = new ArrayList<String>();
            HashMap<String, String> curCompany = new HashMap<String, String>();
            try {
                while (ids.next()) {
                    companyIds.add(ids.getString("fid"));
                    curCompany.put(ids.getString("fid"), ids.getString("flongNumber"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            EliminationInfo info = null;
            boolean isAllCompanyImport = true;
            this.initIElimination(ctx);
            for (int i = list.size() - 1; i >= 0; --i) {
                String id = (String)list.get(i);
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
                info = this.iElimination.getEliminationInfo((IObjectPK)pk);
                if (info == null) continue;
                boolean isExist = true;
                EliminationEntryCollection col = info.getEntries();
                for (int j = col.size() - 1; j >= 0; --j) {
                    String preCompanyNumber;
                    EliminationEntryInfo lineInfo = col.get(j);
                    if (!isAllCompanyImport || companyIds == null || lineInfo.getCompany() == null) continue;
                    String companyId = lineInfo.getCompany().getId().toString();
                    if (!companyIds.contains(companyId)) {
                        isExist = false;
                        break;
                    }
                    String curCompanyNumber = (String)curCompany.get(companyId);
                    if (curCompanyNumber.equals(preCompanyNumber = (String)preCompany.get(companyId))) continue;
                    isExist = false;
                    break;
                }
                if (isExist) continue;
                list.remove(i);
            }
        }
        if (list.size() == 0) {
            throw new AdjustException(AdjustException.FIXLINE_NOT_EXIST);
        }
        params.setObject("list", list);
        params.setBoolean("isSunElimination", false);
        params.setBoolean("isInitYearProfit", false);
        return this.copyHisData(ctx, params);
    }

    public List<IObjectPK> copyHisData(Context ctx, RptProperties params) throws BOSException, EASBizException {
        BOSObjectType bosType = new ElimDynaItemEntryInfo().getBOSType();
        HashMap<String, String> entryIds = new HashMap<String, String>();
        BOSUuid bosUuid = null;
        DataCollectInfo dataCollect = (DataCollectInfo)params.getObject("dataCollect");
        int periodType = params.getInt("periodType");
        String treeId = params.getString("treeId");
        int year = params.getInt("year");
        int period = params.getInt("period");
        boolean isAllCompanyImport = params.getBoolean("isAllCompanyImport");
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        EliminationInfo elim = new EliminationInfo();
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)params.getObject("KEY_ORGTREE_INFO");
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)params.getObject("KEY_ORGUNIT_INFO");
        elim.setOrgBound(orgTreeInfo);
        elim.setOrgUnit(orgUnitInfo);
        elim.setYear(year);
        elim.setPeriod(period);
        boolean isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod(ctx);
        PeriodCollection periods = null;
        if (this.isMergeByFiscalPeriod(isMergeByFiscalPeriod, RptPeriodTypeEnum.getEnum((int)periodType))) {
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, orgTreeInfo);
        }
        boolean hasCodeRule = CSLServerHelper.isHasCodingRuleByOrg(ctx, (IObjectValue)elim, CSLServerHelper.getRootOrgIDForRootCU(ctx));
        String strOrgID = CSLServerHelper.getRootOrgIDForRootCU(ctx);
        String currentNumber = "";
        ArrayList<EliminationInfo> oldInfoList = new ArrayList<EliminationInfo>();
        ArrayList list = (ArrayList)params.getObject("list");
        this.reSetCopyList(ctx, orgTreeInfo.getId().toString(), orgUnitInfo.getId().toString(), periodType, year, period, list);
        List companyIds = (List)params.getObject("companyIds");
        boolean isSunElimination = params.getBoolean("isSunElimination");
        boolean isInitYearProfit = params.getBoolean("isInitYearProfit");
        boolean isImport = params.getBoolean("isImport");
        ElimRelaOrgTreeCollection elimRelaCol = (ElimRelaOrgTreeCollection)((Object)params.getObject("elimRelaCol"));
        RPTItemInfo unAllotGainYearItem = null;
        ArrayList<String> currencyList = new ArrayList<String>();
        IRPTItem iItem = RPTItemFactory.getLocalInstance(ctx);
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        this.initIElimination(ctx);
        for (int j = 0; j < list.size(); ++j) {
            String id = (String)list.get(j);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            EliminationInfo info = this.iElimination.getEliminationInfo((IObjectPK)pk, new FastMergeExecSelector().getElimSelectors());
            if (!currencyList.contains(info.getCurrency().getId().toString() + "@@@" + info.getSourceCurrency().getId().toString() + "@@@" + info.getValueType().getValue())) {
                currencyList.add(info.getCurrency().getId().toString() + "@@@" + info.getSourceCurrency().getId().toString() + "@@@" + info.getValueType().getValue());
            }
            EliminationEntryCollection col = info.getEntries();
            for (int i = col.size() - 1; i >= 0; --i) {
                ObjectUuidPK itemPk;
                RPTItemInfo itemInfo;
                EliminationEntryInfo lineInfo = col.get(i);
                if (!isAllCompanyImport && companyIds != null) {
                    if (lineInfo.getCompany() == null) {
                        col.removeObject(i);
                    } else {
                        String companyId = lineInfo.getCompany().getId().toString();
                        if (!companyIds.contains(companyId)) {
                            col.removeObject(i);
                        }
                    }
                }
                if (lineInfo.getCompany() != null || isImport) {
                    // empty if block
                }
                if (!isInitYearProfit || info.getYear() >= year || !(itemInfo = iItem.getRPTItemInfo((IObjectPK)(itemPk = new ObjectUuidPK(lineInfo.getItem().getId())))).isIsProfitAndLosses() || lineInfo.getDataElement() != 3) continue;
                if (unAllotGainYearItem == null) {
                    unAllotGainYearItem = this.getUnAllotRptItemId(ctx);
                }
                lineInfo.setItem(unAllotGainYearItem);
                lineInfo.setDataElement(5);
            }
            oldInfoList.add(info);
        }
        ArrayList newInfoList = null;
        ArrayList<IObjectPK> pks = new ArrayList<IObjectPK>();
        HashMap map = new HashMap();
        if (isSunElimination) {
            newInfoList = this.doSumEliminationByCurrency(ctx, oldInfoList, currencyList, isImport, map);
        } else {
            newInfoList = new ArrayList(oldInfoList.size());
            for (int i = 0; i < oldInfoList.size(); ++i) {
                EliminationInfo newData = new EliminationInfo();
                newInfoList.add(newData);
                EliminationInfo oldData = (EliminationInfo)oldInfoList.get(i);
                newData.setId(oldData.getId());
                if (oldData.getDisplayTemplateType() != null) {
                    newData.setDisplayTemplateType(oldData.getDisplayTemplateType());
                }
                newData.setCurrency(oldData.getCurrency());
                newData.setSourceCurrency(oldData.getSourceCurrency());
                newData.setValueType(oldData.getValueType());
                newData.setDataCollect(oldData.getDataCollect());
                newData.setDataCollectNumber(oldData.getDataCollectNumber());
                newData.setIsFixed(oldData.getIsFixed());
                newData.setEliminationMode(oldData.getEliminationMode());
                String resPath = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
                if (params.getObject("basic") != null && params.getObject("basic").equals("yes")) {
                    if (!StringUtils.isEmpty((String)oldData.getRemark())) {
                        resPath = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
                        newData.setRemark(oldData.getRemark() + "(" + EASResource.getString((String)resPath, (String)"entryremark") + oldData.getNumber() + ")");
                    } else {
                        newData.setRemark("(" + EASResource.getString((String)resPath, (String)"entryremark") + oldData.getNumber() + ")");
                    }
                } else {
                    newData.setRemark(oldData.getRemark());
                }
                for (int j = 0; j < oldData.getEntries().size(); ++j) {
                    EliminationEntryInfo entryInfo = oldData.getEntries().get(j);
                    bosUuid = BOSUuid.create((BOSObjectType)bosType);
                    entryIds.put(entryInfo.getId().toString(), bosUuid.toString());
                    entryInfo.setId(bosUuid);
                    newData.getEntries().add(entryInfo);
                }
            }
        }
        this.initIElimination(ctx);
        for (int i = 0; i < newInfoList.size(); ++i) {
            EliminationInfo newInfo = (EliminationInfo)newInfoList.get(i);
            currentNumber = strOrgID != null && hasCodeRule ? CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)elim, strOrgID) : this.getCurrentMaxNumber(ctx, treeId, periodType, year, period, "T_CSL_Elimination");
            newInfo.setYear(year);
            newInfo.setPeriod(period);
            newInfo.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
            newInfo.setOrgBound(orgTreeInfo);
            newInfo.setOrgUnit(orgUnitInfo);
            newInfo.setAuditDate(null);
            newInfo.setAuditor(null);
            newInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
            newInfo.setIsCitedByLater(IsCitedByLaterEnum.ISTRUE);
            newInfo.setCreator(user);
            newInfo.setCreateTime(time);
            newInfo.setNumber(currentNumber);
            try {
                newInfo.setDate(FiscalPeriodHelper.getPeriodLastDate(periods, year, period, RptPeriodTypeEnum.getEnum((int)periodType), isMergeByFiscalPeriod));
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                newInfo.setDate(RPTDate13Util.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType)));
            }
            ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
            String oldId = newInfo.getId().toString();
            EliminationInfo oldInfo = new EliminationInfo();
            oldInfo.setId(newInfo.getId());
            newInfo.setSourceElimination(oldInfo);
            newInfo.setId(null);
            newInfo.setDataCollect(dataCollect);
            newInfo.setDataCollectNumber(dataCollect.getNumber());
            IObjectPK pk = this.iElimination.addnew((CoreBaseInfo)newInfo);
            pks.add(pk);
            String[] attachIDs = asm.getAttachmentIDsByBoID(oldId);
            asm.addAssociations(pk.toString(), attachIDs);
            if (isSunElimination) {
                List idList = (List)map.get(newInfo.getCurrency().getId().toString());
                for (int j = 0; idList != null && j < idList.size(); ++j) {
                    this.addNewElimRelaOrgTree(ctx, elimRelaCol, idList.get(j).toString(), pk.toString());
                }
                continue;
            }
            this.addNewElimRelaOrgTree(ctx, elimRelaCol, oldId, pk.toString());
        }
        CslRptUtil.copyDynamicItem(ctx, entryIds, false);
        return pks;
    }

    private Map getNumber(Context ctx, String orgUnitId, String orgTreeId) throws BOSException {
        HashMap<String, String> numbers = new HashMap<String, String>();
        String sql = "select fnumber from t_org_tree where fid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgTreeId});
        try {
            while (rs.next()) {
                String treeNumber = rs.getString("fnumber");
                numbers.put("treeNumber", treeNumber);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        String newSql = "select flongnumber from T_ORG_Structure where funitid = ?";
        IRowSet newrs = DbUtil.executeQuery((Context)ctx, (String)newSql, (Object[])new Object[]{orgUnitId});
        try {
            while (newrs.next()) {
                String unitNumber = newrs.getString("flongnumber");
                numbers.put("unitNumber", unitNumber);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return numbers;
    }

    private boolean isMergeByFiscalPeriod(boolean isMergeByFiscalPeriod, RptPeriodTypeEnum periodType) {
        return FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodType);
    }

    private RPTItemInfo getUnAllotRptItemId(Context ctx) throws BOSException, EASBizException {
        String oql = "SELECT id,number WHERE isFreezed = 0 and control = 10";
        RPTItemCollection items = RPTItemFactory.getLocalInstance(ctx).getRPTItemCollection(oql);
        if (items != null && items.size() > 0) {
            return items.get(0);
        }
        throw new AdjustException(AdjustException.UN_EXIST_UNSHARED_RPTITEM, new Object[]{RPTItemControlEnum.UNALLOTGAIN_SYEAR.getAlias()});
    }

    private ArrayList doSumEliminationByCurrency(Context ctx, ArrayList eliminationList, ArrayList currencyList, boolean isImport, Map currency2OldID) throws BOSException, EASBizException {
        ArrayList<EliminationInfo> rtEliminationList = new ArrayList<EliminationInfo>();
        BigDecimal zeroValue = new BigDecimal("0");
        HashMap<String, EliminationInfo> currencyTable = new HashMap<String, EliminationInfo>();
        for (int j = 0; j < currencyList.size(); ++j) {
            String currencyId = ((String)currencyList.get(j)).split("@@@")[0];
            String sourceCurrencyId = ((String)currencyList.get(j)).split("@@@")[1];
            String valueType = ((String)currencyList.get(j)).split("@@@")[2];
            EliminationInfo newInfo = new EliminationInfo();
            HashMap<String, EliminationEntryInfo> itemDataElementValueType = new HashMap<String, EliminationEntryInfo>();
            for (int k = 0; k < eliminationList.size(); ++k) {
                EliminationInfo oldInfo = null;
                oldInfo = (EliminationInfo)eliminationList.get(k);
                if (!currencyId.equals(oldInfo.getCurrency().getId().toString()) || !sourceCurrencyId.equals(oldInfo.getSourceCurrency().getId().toString()) || !valueType.equals(oldInfo.getValueType().getValue() + "")) continue;
                if (currency2OldID.get(oldInfo.getCurrency().getId().toString()) == null) {
                    ArrayList<BOSUuid> listID = new ArrayList<BOSUuid>();
                    listID.add(oldInfo.getId());
                    currency2OldID.put(oldInfo.getCurrency().getId().toString(), listID);
                } else {
                    ((List)currency2OldID.get(oldInfo.getCurrency().getId().toString())).add(oldInfo.getId());
                }
                newInfo.setId(oldInfo.getId());
                newInfo.setCurrency(oldInfo.getCurrency());
                newInfo.setSourceCurrency(oldInfo.getSourceCurrency());
                newInfo.setValueType(oldInfo.getValueType());
                EliminationEntryCollection entry = oldInfo.getEntries();
                int entrySize = 0;
                if (entry != null) {
                    entrySize = entry.size();
                }
                if (entry == null || entrySize <= 0) continue;
                for (int i = 0; i < entry.size(); ++i) {
                    EliminationEntryInfo anotherLineInfo;
                    EliminationEntryInfo lineInfo = entry.get(i);
                    if (lineInfo.getCompany() == null && isImport) continue;
                    BigDecimal debitTotal = new BigDecimal("0");
                    BigDecimal creditTotal = new BigDecimal("0");
                    BigDecimal resultTotal = null;
                    String itemId = lineInfo.getItem().getId().toString();
                    String itemDataElementValueTypePK = itemId + "@@@" + lineInfo.getDataElement() + "@@@" + oldInfo.getValueType().getValue() + "@@@" + lineInfo.isIsVisible() + "@@@" + (lineInfo.getCompany() == null ? "" : lineInfo.getCompany().getId().toString());
                    if (!itemDataElementValueType.containsKey(itemDataElementValueTypePK)) {
                        anotherLineInfo = new EliminationEntryInfo();
                        anotherLineInfo.setIsVisible(lineInfo.isIsVisible());
                        anotherLineInfo.setDataElement(lineInfo.getDataElement());
                        anotherLineInfo.setItem(lineInfo.getItem());
                        anotherLineInfo.setElimination(oldInfo);
                        anotherLineInfo.setCompany(lineInfo.getCompany());
                        anotherLineInfo.setSummary(lineInfo.getSummary());
                        anotherLineInfo.setDebit(lineInfo.getDebit());
                        anotherLineInfo.setCredit(lineInfo.getCredit());
                        itemDataElementValueType.put(itemDataElementValueTypePK, anotherLineInfo);
                        continue;
                    }
                    anotherLineInfo = (EliminationEntryInfo)itemDataElementValueType.get(itemDataElementValueTypePK);
                    if (anotherLineInfo.getDebit() != null || lineInfo.getDebit() != null) {
                        debitTotal = anotherLineInfo.getDebit();
                        if (debitTotal == null) {
                            debitTotal = zeroValue;
                        }
                        debitTotal = debitTotal.add(lineInfo.getDebit() == null ? zeroValue : lineInfo.getDebit());
                    }
                    if (anotherLineInfo.getCredit() != null || lineInfo.getCredit() != null) {
                        creditTotal = anotherLineInfo.getCredit();
                        if (creditTotal == null) {
                            creditTotal = zeroValue;
                        }
                        creditTotal = creditTotal.add(lineInfo.getCredit() == null ? zeroValue : lineInfo.getCredit());
                    }
                    if ((resultTotal = debitTotal.subtract(creditTotal)).compareTo(zeroValue) >= 0) {
                        anotherLineInfo.setDebit(resultTotal);
                        anotherLineInfo.setCredit(zeroValue);
                    }
                    if (resultTotal.compareTo(zeroValue) < 0) {
                        anotherLineInfo.setCredit(resultTotal.abs());
                        anotherLineInfo.setDebit(zeroValue);
                    }
                    itemDataElementValueType.put(itemDataElementValueTypePK, anotherLineInfo);
                }
            }
            Set keySet = itemDataElementValueType.keySet();
            int seq = 0;
            Iterator it = keySet.iterator();
            while (it.hasNext()) {
                ++seq;
                String key = (String)it.next();
                EliminationEntryInfo element = (EliminationEntryInfo)itemDataElementValueType.get(key);
                if (element == null) continue;
                element.setSeq(seq);
                if ((element.getCredit() == null || element.getCredit().compareTo(zeroValue) == 0) && (element.getDebit() == null || element.getDebit().compareTo(zeroValue) == 0)) continue;
                element.setElimination(newInfo);
                newInfo.getEntries().add(element);
            }
            if (newInfo.getEntries() == null || newInfo.getEntries().size() <= 0) continue;
            currencyTable.put(currencyId + sourceCurrencyId + valueType, newInfo);
        }
        Set currencyKeySet = currencyTable.keySet();
        for (String key : currencyKeySet) {
            EliminationInfo element = (EliminationInfo)currencyTable.get(key);
            rtEliminationList.add(element);
        }
        return rtEliminationList;
    }

    private String getCurrentMaxNumber(Context ctx, String orgTreeId, int periodType, int year, int period, String tableName) throws BOSException {
        BigDecimal number = new BigDecimal("1");
        StringBuffer sbSQL = new StringBuffer(" SELECT Replace(fnumber,'AUTO_','') As Fnumber From \r\n");
        sbSQL.append(tableName).append(" a  \r\n");
        sbSQL.append("  WHERE a.fOrgBoundId = '").append(orgTreeId).append("' \r\n");
        sbSQL.append("  and a.fyear = ").append(year).append(" \r\n");
        sbSQL.append("  and a.fperiod = ").append(period).append(" \r\n");
        sbSQL.append("  and a.fperiodType = ").append(periodType).append(" \r\n");
        sbSQL.append("  and a.fNumber like 'AUTO\\_%' escape '\\' \r\n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            String tempNumber = "";
            BigDecimal curNumber = null;
            while (rs.next()) {
                tempNumber = rs.getString("Fnumber");
                if (StringUtils.isEmpty((String)tempNumber) || !tempNumber.matches("[0-9]{" + tempNumber.length() + "}") || number.compareTo(curNumber = new BigDecimal(tempNumber)) >= 0) continue;
                number = curNumber;
            }
            if (number != null) {
                number = number.add(new BigDecimal("1"));
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        StringBuffer ret = new StringBuffer("AUTO_");
        int n = 8 - number.toString().length();
        for (int i = 0; i < n; ++i) {
            ret.append("0");
        }
        ret.append(number);
        return ret.toString();
    }

    private void addNewElimRelaOrgTree(Context ctx, ElimRelaOrgTreeCollection elimRelaCol, String oldId, String newId) throws BOSException, EASBizException {
        IElimRelaOrgTree iElimRela = ElimRelaOrgTreeFactory.getLocalInstance(ctx);
        if (elimRelaCol != null && elimRelaCol.size() > 0) {
            int size = elimRelaCol.size();
            for (int i = 0; i < size; ++i) {
                ElimRelaOrgTreeInfo info = elimRelaCol.get(i);
                if (!info.getElimId().equals(oldId)) continue;
                info.setCurrentElimId(newId);
                iElimRela.addnew(info);
            }
        }
    }

    private void initIElimination(Context ctx) throws BOSException, EASBizException {
        if (this.iElimination == null) {
            this.iElimination = EliminationFactory.getLocalInstance(ctx);
        }
    }

    private void reSetCopyList(Context ctx, String orgTreeId, String orgUnitId, int periodType, int year, int period, List list) throws BOSException, EASBizException {
        for (int i = list.size() - 1; i >= 0; --i) {
            String id = (String)list.get(i);
            boolean hadCopyBySourceAdjustId = EliminationFactory.getLocalInstance(ctx).exists("select 1 where sourceElimination.id ='" + id + "' and checkedStatus=2 and orgBound.id = '" + orgTreeId + "' and periodType = " + periodType + " and year = " + year + " and period = " + period + " and orgUnit.id = '" + orgUnitId + "'");
            if (hadCopyBySourceAdjustId) {
                list.remove(i);
                continue;
            }
            StringBuffer strSQL = new StringBuffer();
            ArrayList<Object> params = new ArrayList<Object>();
            strSQL.append(" delete from t_csl_elimination where ");
            strSQL.append(" fSourceEliminationid = ? ");
            params.add(id);
            strSQL.append(" and fCheckedStatus = 1 ");
            strSQL.append(" and fOrgBoundId = ? ");
            params.add(orgTreeId);
            strSQL.append(" and fPeriodType = ? ");
            params.add(periodType);
            strSQL.append(" and fYear = ? ");
            params.add(year);
            strSQL.append(" and fPeriod = ? ");
            params.add(period);
            strSQL.append(" and fOrgUnit = ? ");
            params.add(orgUnitId);
            DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])params.toArray());
        }
    }
}

