/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.EliminationItemMapFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationItemMapInfo;
import com.kingdee.eas.fi.gr.cslrpt.IEliminationItemMap;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractEliminationItemMapControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EliminationItemMapControllerBean
extends AbstractEliminationItemMapControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.EliminationItemMapControllerBean");

    @Override
    protected void _saveElimItemMapItems(Context ctx, List elimItemMapList) throws BOSException {
        String elimTemplateid = "";
        if (elimItemMapList.size() > 0) {
            EliminationItemMapInfo elimItemMap = (EliminationItemMapInfo)elimItemMapList.get(0);
            elimTemplateid = elimItemMap.getElimTemple().getId().toString();
        }
        this._deleteALLElimItems(ctx, elimTemplateid);
        try {
            IEliminationItemMap itemMapEntry = EliminationItemMapFactory.getLocalInstance(ctx);
            for (EliminationItemMapInfo entryInfo : elimItemMapList) {
                if (entryInfo.getSelfCompanyTtem() == null || entryInfo.getOtherCompanyTtem() == null) {
                    return;
                }
                itemMapEntry.submit((CoreBaseInfo)entryInfo);
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _deleteALLElimItems(Context ctx, String elimTemplateid) throws BOSException {
        StringBuffer dcSql = new StringBuffer();
        dcSql.append("delete from T_CSL_EliminationItemMap");
        dcSql.append(" where FElimTempleID='").append(elimTemplateid).append("'");
        DbUtil.execute((Context)ctx, (String)dcSql.toString());
    }

    @Override
    protected void _deleteNoExistItemMap(Context ctx, String elimTemplateid, List entryItemList) throws BOSException {
        StringBuffer querySql = new StringBuffer();
        querySql.append("select FSelfRptItemID,FOtherRptItemID  from T_CSL_EliminationItemMap");
        querySql.append("  where FElimTempleID='").append(elimTemplateid).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        try {
            while (rowSet.next()) {
                String selfRptItemID = rowSet.getString(1);
                String otherRptItemID = rowSet.getString(2);
                if (entryItemList.contains(selfRptItemID) && entryItemList.contains(otherRptItemID)) continue;
                StringBuffer dcSql = new StringBuffer();
                dcSql.append("delete from T_CSL_EliminationItemMap");
                dcSql.append(" where FElimTempleID='").append(elimTemplateid).append("'");
                dcSql.append(" and FSelfRptItemID='").append(selfRptItemID).append("'");
                DbUtil.execute((Context)ctx, (String)dcSql.toString());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    protected Map _getBatchItemMapByTempleIds(Context ctx, List templateIdList) throws BOSException {
        HashMap<String, CoreBaseCollection> itemRelaMap = new HashMap<String, CoreBaseCollection>();
        if (templateIdList == null || templateIdList.size() == 0) {
            return itemRelaMap;
        }
        StringBuffer sbSQL = new StringBuffer("select selfCompanyTtem.fId selfitemFid, selfCompanyTtem.fnumber selfitemFFnumber, \r\n");
        sbSQL.append("otherCompanyTtem.fId otheritemFId, otherCompanyTtem.fnumber otherItemFnumber, felimTempleid \r\n");
        sbSQL.append(" from T_CSL_EliminationItemMap itemmap \r\n");
        sbSQL.append("  inner join T_csl_rptitem selfCompanyTtem on itemmap.fselfrptitemid=selfCompanyTtem.fid  \r\n");
        sbSQL.append("   inner join T_csl_rptitem otherCompanyTtem on itemmap.fotherrptitemid=otherCompanyTtem.fid \r\n ");
        sbSQL.append("  where felimTempleid in (");
        sbSQL.append(CslRptUtil.AryToItemString(templateIdList));
        sbSQL.append(" ) order by itemmap.felimTempleid,itemmap.fseq");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            CoreBaseCollection itemMapColl = new CoreBaseCollection();
            String tempIdCurr = "";
            while (rs.next()) {
                String tempId = rs.getString("felimTempleid");
                if (!tempIdCurr.equals(tempId)) {
                    itemMapColl = new CoreBaseCollection();
                    tempIdCurr = tempId;
                }
                if (!itemRelaMap.containsKey(tempId)) {
                    itemRelaMap.put(tempId, itemMapColl);
                }
                EliminationItemMapInfo info = new EliminationItemMapInfo();
                RPTItemInfo selfItemInfo = new RPTItemInfo();
                selfItemInfo.setNumber(rs.getString("selfitemFFnumber"));
                selfItemInfo.setId(BOSUuid.read((String)rs.getString("selfitemFid")));
                info.setSelfCompanyTtem(selfItemInfo);
                RPTItemInfo otherItemInfo = new RPTItemInfo();
                otherItemInfo.setNumber(rs.getString("otherItemFnumber"));
                otherItemInfo.setId(BOSUuid.read((String)rs.getString("otheritemFId")));
                info.setOtherCompanyTtem(otherItemInfo);
                itemMapColl.add((CoreBaseInfo)info);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return itemRelaMap;
    }
}

