/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.Checkage;
import com.kingdee.eas.fi.gr.cslrpt.CheckageConfirmEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.DiffHandleStrategy;
import com.kingdee.eas.fi.gr.cslrpt.DiffModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationItemMapFactory;
import com.kingdee.eas.fi.gr.cslrpt.ExchCheckageFactory;
import com.kingdee.eas.fi.gr.cslrpt.IElimTemplet;
import com.kingdee.eas.fi.gr.cslrpt.IElimination;
import com.kingdee.eas.fi.gr.cslrpt.InterCheckException;
import com.kingdee.eas.fi.gr.cslrpt.InterDataCheckageFactory;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractInterCheckControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.app.CslElimUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.innertrade.AuditOperator;
import com.kingdee.eas.fi.gr.cslrpt.app.innertrade.InterExchReportValChgChecker;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.LimitAmountInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.cslrpt.util.RelatingAdjustElimHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.samecontrol.SameControlUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InterCheckControllerBean
extends AbstractInterCheckControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.InterCheckControllerBean");
    public static final int HASHMAP_MAXSIZE = 1000;
    public static final String CHECK_BOSTYPE = "89506799";
    public static final String CHECK_ENTRY_BOSTYPE = "2043400D";
    public static final String ELIMRECORD_BOSTYPE = "419657E0";
    public static final String ELIMINATION_ENTRY_BOSTYPE = "091F8191";
    public static final String ELIMINATION_BOSTYPE = "C1258B61";
    public static final String BASEUNIT_TBNAME = "T_ORG_BaseUnit";
    public static final String ORG_STRUCTURE_TBNAME = "T_ORG_Structure";
    public static final String ELIMTEMPLET_GROUP_TBNAME = "T_CSL_ElimTempletGroup";
    public static final String TEMPLET_DISPENSE_TBNAME = "T_CSL_TempletDispense";
    public static final String ELIMTEMPLET_TBNAME = "T_CSL_ElimTemplet";
    public static final String ELIMTEMPLET_ENTRY_TBNAME = "T_CSL_elimtempletentry";

    @Override
    protected void _checkData(Context ctx, String orgTree, RptPeriodTypeEnum rptPeriodType, int curYear, int curPeriod, ElimTypeEnum elimType) throws BOSException, EASBizException {
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("orgTreeId", orgTree);
        param.put("periodType", new Integer(rptPeriodType.getValue()));
        param.put("year", new Integer(curYear));
        param.put("period", new Integer(curPeriod));
        param.put("elimType", (Object)elimType);
        param.put("mergeType", Integer.valueOf("0"));
        checkageManager manager = new checkageManager(ctx, param);
        manager.buildCheckage();
        manager.deleteCheckData();
        manager.executeInsert();
        manager.updateItemDataTable(param);
    }

    private ArrayList findTempletIds(Context ctx, String curOrgTreeId, String curOrgUnit, ElimTypeEnum elimType) throws BOSException {
        StringBuffer sbSql = new StringBuffer(" select fid from ");
        sbSql.append(ELIMTEMPLET_TBNAME).append(" where FCheckedStatus=");
        sbSql.append(2);
        if (ElimTypeEnum.InterAndExch.equals((Object)elimType)) {
            sbSql.append(" and FElimType in(").append(1).append(",").append(3).append(")");
        } else {
            sbSql.append(" and FElimType=").append(elimType.getValue());
        }
        sbSql.append(" and felimGroupId in (select fid from ");
        sbSql.append(ELIMTEMPLET_GROUP_TBNAME);
        sbSql.append(" where fid in (select fdispensesrcid from ");
        sbSql.append(TEMPLET_DISPENSE_TBNAME);
        sbSql.append(" where forgBoundID = ? and fcompanyId = ? and fsourceType = 2))");
        ArrayList<String> templetIds = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])new Object[]{curOrgTreeId, curOrgUnit});
            templetIds = new ArrayList<String>();
            while (rs.next()) {
                templetIds.add(rs.getString("fid"));
            }
        }
        catch (SQLException exc) {
            throw new BOSException("Sql execute exception : " + sbSql.toString(), (Throwable)exc);
        }
        return templetIds;
    }

    @Override
    protected void _deleteElimRecord(Context ctx, String eliminationId) throws BOSException {
        SQLBuilder builder = new SQLBuilder();
        builder.append(" DELETE FROM T_CSL_ElimRecord ");
        builder.append("  WHERE FEliminationId = ?", (Object)eliminationId);
        DbUtil.execute((Context)ctx, (String)builder.getSQL(), (Object[])builder.getParams());
    }

    private Set findComIdsOfCurOrgUnit(Context ctx, String orgBoundId, String curOrgUnitId, RptPeriodTypeEnum rptPeriodType, int curYear, int curPeriod, ElimTypeEnum elimType) throws BOSException {
        HashSet<String> companyIds = null;
        try {
            String longNumber = null;
            String orgTreeNumber = null;
            String orgUnitNumber = null;
            IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)" select struct.FLongNumber,struct.FLevel,tree.fnumber treeNumber,unit.fnumber unitNumber From t_org_structure struct inner join t_org_baseunit unit on unit.fid=struct.funitid inner join t_org_tree tree on tree.fid=struct.ftreeid where struct.ftreeid = ? and struct.funitid = ?", (Object[])new Object[]{orgBoundId, curOrgUnitId});
            if (rsTemp.next()) {
                longNumber = rsTemp.getString("FLongNumber");
                orgTreeNumber = rsTemp.getString("treeNumber");
                orgUnitNumber = rsTemp.getString("unitNumber");
            }
            Set[] disposeCompanys = null;
            if (ElimTypeEnum.exchange.equals((Object)elimType)) {
                disposeCompanys = SameControlUtil.getCurPeriodDisposalCompanysForElim((Context)ctx, (String)orgTreeNumber, (String)orgUnitNumber, (int)curYear, (int)curPeriod, (int)rptPeriodType.getValue(), (String)orgBoundId, (boolean)false);
            }
            longNumber = longNumber + "!" + "%";
            StringBuffer sbSql = new StringBuffer(" select fid from ");
            sbSql = sbSql.append(BASEUNIT_TBNAME).append("\r\n where fid in (select funitid from  \r\n").append(ORG_STRUCTURE_TBNAME).append(" where FTreeID = ? and flongNumber like ? and FIsLeaf = 1) and fisgrouping = 0 \r\n");
            Object[] object = new Object[]{orgBoundId, longNumber};
            IRowSet rs_1 = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])object);
            companyIds = new HashSet<String>();
            while (rs_1.next()) {
                companyIds.add(rs_1.getString("fid"));
            }
            if (disposeCompanys != null && !disposeCompanys[1].isEmpty()) {
                for (Object company : disposeCompanys[1]) {
                    companyIds.add(((FullOrgUnitInfo)company).getId().toString());
                }
            }
        }
        catch (SQLException exc) {
            throw new BOSException("Sql execute exception : when find company of curOrgUnit", (Throwable)exc);
        }
        return companyIds;
    }

    private String getInSQL_ComOfCurOrgUnit(Context ctx, String orgBoundId, String curOrgUnitId, RptPeriodTypeEnum rptPeriodType, int curYear, int curPeriod, ElimTypeEnum elimType) throws BOSException {
        Set companyIds = this.findComIdsOfCurOrgUnit(ctx, orgBoundId, curOrgUnitId, rptPeriodType, curYear, curPeriod, elimType);
        String inCompanyIds = null;
        if (companyIds != null && companyIds.size() > 0) {
            StringBuffer sbCompanyIds = new StringBuffer("(");
            sbCompanyIds.append(CslRptUtil.collection2String(companyIds, ",", true));
            sbCompanyIds.append(")");
            inCompanyIds = sbCompanyIds.toString();
        }
        return inCompanyIds;
    }

    @Override
    protected boolean _haveTemplets(Context ctx, String orgTreeId, String unitId, ElimTypeEnum elimType) throws BOSException {
        ArrayList list;
        if (StringUtils.isEmpty((String)unitId)) {
            unitId = this.getUnitIdByLoginOrg(ctx, orgTreeId);
        }
        return (list = this.findTempletIds(ctx, orgTreeId, unitId, elimType)) != null && list.size() != 0;
    }

    private String getUnitIdByLoginOrg(Context ctx, String treeId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("parent.unit.id"));
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("tree.id", (Object)treeId);
        filter.appendFilterItem("unit.id", (Object)ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString());
        view.setFilter(filter);
        OrgStructureCollection col = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection(view);
        if (col == null || col.size() <= 0) {
            return null;
        }
        return col.get(0).getParent().getUnit().getId().toString();
    }

    private String getCurrentMaxNumber(Context ctx, String orgTreeId, int periodType, int year, int period, String tableName) throws BOSException {
        BigDecimal number = new BigDecimal("1");
        StringBuffer sbSQL = new StringBuffer(" SELECT Round(Max(to_int(Replace(fnumber,'AUTO_',''))),0) As Fmaxnumber From \r\n");
        sbSQL.append(tableName).append(" a  \r\n");
        sbSQL.append("\tWHERE a.fOrgBoundId = '").append(orgTreeId).append("' \r\n");
        sbSQL.append("  and a.fyear = ").append(year).append(" \r\n");
        sbSQL.append("  and a.fperiod = ").append(period).append(" \r\n");
        sbSQL.append("  and a.fperiodType = ").append(periodType).append(" \r\n");
        sbSQL.append("  and a.fNumber like N'AUTO\\_%' escape '\\' \r\n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            if (rs.next() && rs.getBigDecimal("Fmaxnumber") != null) {
                number = rs.getBigDecimal("Fmaxnumber").add(new BigDecimal("1"));
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        StringBuffer ret = new StringBuffer("AUTO_");
        int n = 8 - number.toString().length();
        for (int i = 0; i < n; ++i) {
            ret.append("0");
        }
        ret.append(number);
        return ret.toString();
    }

    private StringBuffer generateElimNumber(Context ctx, String orgTreeId, int periodType, int year, int period, OrgTreeInfo orgTreeInfo, OrgUnitInfo orgUnitInfo) throws CodingRuleException, EASBizException, BOSException {
        StringBuffer elimNumber = new StringBuffer();
        EliminationInfo elim = new EliminationInfo();
        elim.setOrgBound(orgTreeInfo);
        elim.setOrgUnit(orgUnitInfo);
        elim.setYear(year);
        elim.setPeriod(period);
        boolean hasCodeRule = CSLServerHelper.isHasCodingRuleByOrg(ctx, (IObjectValue)elim, CSLServerHelper.getRootOrgIDForRootCU(ctx));
        String strOrgID = CSLServerHelper.getRootOrgIDForRootCU(ctx);
        String currentNumber = "";
        if (strOrgID != null && hasCodeRule) {
            currentNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)elim, strOrgID);
            elimNumber.append(currentNumber);
        } else {
            elimNumber.append(this.getCurrentMaxNumber(ctx, orgTreeId, periodType, year, period, "T_CSL_Elimination"));
        }
        return elimNumber;
    }

    @Override
    protected void _createElimAndRecord(Context ctx, String orgTreeId, int periodType, int year, int period, String sourceCurrencyId, String currencyId, String templetId, String eliminationId, String orgUnitId, int isCitedByLater, Timestamp elimDate, ElimTypeEnum elimType, String displayTypeId, OrgTreeInfo orgTreeInfo, OrgUnitInfo orgUnitInfo) throws BOSException, EASBizException {
        this.createElimination(ctx, orgTreeId, periodType, year, period, sourceCurrencyId, currencyId, templetId, eliminationId, orgUnitId, isCitedByLater, elimDate, elimType, false, null, displayTypeId, null, orgTreeInfo, orgUnitInfo, null);
    }

    @Override
    protected void _createElimination(Context ctx, Map param) throws BOSException, EASBizException {
        this.createElimination(ctx, (String)param.get("orgBoundId"), (Integer)param.get("periodType"), (Integer)param.get("year"), (Integer)param.get("period"), (String)param.get("sourceCurrencyId"), (String)param.get("currencyId"), (String)param.get("templetId"), (String)param.get("eliminationId"), (String)param.get("orgUnitId"), (Integer)param.get("isCitedByLater"), (Timestamp)param.get("elimDate"), (ElimTypeEnum)((Object)param.get("elimType")), (Boolean)param.get("isByCompany"), (String)param.get("basicTreeId"), (String)param.get("displayTypeId"), (DataCollectInfo)param.get("dataCollect"), (OrgTreeInfo)param.get("KEY_ORGTREE_INFO"), (OrgUnitInfo)param.get("KEY_ORGUNIT_INFO"), param.containsKey("number") ? (String)param.get("number") : null);
    }

    @Override
    protected String _getBasicTree(Context ctx, Date date) throws BOSException, EASBizException {
        String sql = "select fid from t_org_tree where ftype=8 and fisbasic = 1 and fisforbudget = 0  and fstartdate <= To_date('" + new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(date) + "') and Isnull(fenddate, To_date('2099-1-1')) >= To_date('" + new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(date) + "')";
        IRowSet rs = null;
        String ret = "";
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                ret = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ret;
    }

    @Override
    protected IRowSet _sumCheckRecord(Context ctx, String orgBoundId, int periodType, int year, int period, String orgUnitId, ElimTypeEnum elimType) throws BOSException, EASBizException {
        return this.sumElimination(ctx, orgBoundId, periodType, year, period, orgUnitId, elimType, false, null, null);
    }

    @Override
    protected IRowSet _sumElimination(Context ctx, Map param) throws BOSException, EASBizException {
        return this.sumElimination(ctx, (String)param.get("orgBoundId"), (Integer)param.get("periodType"), (Integer)param.get("year"), (Integer)param.get("period"), (String)param.get("orgUnitId"), (ElimTypeEnum)((Object)param.get("elimType")), (Boolean)param.get("isByCompany"), (String)param.get("basicTreeId"), (String)param.get("dataCollectNumber"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRowSet sumElimination(Context ctx, String orgBoundId, int periodType, int year, int period, String orgUnitId, ElimTypeEnum elimType, boolean isByCompany, String basicTreeId, String dataCollectNumber) throws BOSException, SQLDataException, EASBizException {
        String longNumber = null;
        String orgTreeNumber = null;
        String orgUnitNumber = null;
        int level = -1;
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)" select struct.FLongNumber,struct.FLevel,tree.fnumber treeNumber,unit.fnumber unitNumber From t_org_structure struct inner join t_org_baseunit unit on unit.fid=struct.funitid inner join t_org_tree tree on tree.fid=struct.ftreeid where struct.ftreeid = ? and struct.funitid = ?", (Object[])new Object[]{orgBoundId, orgUnitId});
        try {
            while (rsTemp.next()) {
                longNumber = rsTemp.getString("FLongNumber");
                orgTreeNumber = rsTemp.getString("treeNumber");
                orgUnitNumber = rsTemp.getString("unitNumber");
                level = rsTemp.getInt("FLevel");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        String elimOrgUnitsTable = SameControlUtil.getElimOrgUnitsTable((Context)ctx, (String)orgBoundId, (String)orgUnitId, (String)longNumber, (String)orgUnitNumber, (String)orgTreeNumber, (int)year, (int)period, (int)periodType, (int)level, (ElimTypeEnum)elimType, (int)0);
        try {
            StringBuffer sbSQL = null;
            CommonTable commonTable = new CommonTable(elimType);
            sbSQL = new StringBuffer("select distinct a.forgboundid, a.fperiodType, a.fyear, a.fperiod,a.fcurrencyid, a.ftempletid, b.fitemid, b.fCompanyID, \r\n");
            sbSQL.append(" sum(b.fvalidebit) as fvalidebit, sum(b.fvaliCredit) as fvaliCredit, \r\n");
            sbSQL.append("  c.fname_" + ctx.getLocale() + " as fCurrencyName, d.fname as fTempletname,  d.FIsCitedByLater as FIsCitedByLater,  \r\n");
            sbSQL.append(" e.fnumber as fItemNumber, e.fname_" + ctx.getLocale() + " as fItemName \r\n");
            sbSQL.append(" from ").append(commonTable.getMasterTable()).append(" a \r\n");
            sbSQL.append(" RIGHT OUTER JOIN ").append(commonTable.getEntryTable()).append(" AS b \r\n");
            sbSQL.append("  ON a.FID = b.FCheckageID \r\n");
            sbSQL.append(" INNER JOIN T_BD_Currency AS c \r\n");
            sbSQL.append("  ON a.FCurrencyID = c.FID \r\n");
            sbSQL.append(" INNER JOIN T_CSL_ElimTemplet AS d \r\n");
            sbSQL.append("  ON a.FTempletID = d.FID \r\n");
            sbSQL.append(" INNER JOIN T_CSL_RptItem AS e \r\n");
            sbSQL.append("  ON b.FItemID = e.FID \r\n");
            sbSQL.append(" INNER JOIN T_CSL_ElimTempletEntry AS f \r\n");
            sbSQL.append("  ON f.FTempletID = d.FID \r\n");
            sbSQL.append("  and f.fItemId = b.FItemID \r\n");
            sbSQL.append("  and f.fdataelement = b.fdataelement \r\n");
            sbSQL.append(" WHERE  a.fcheckedstatus = ").append(2).append(" \r\n");
            sbSQL.append("\tand a.fOrgBoundId = '").append(isByCompany ? basicTreeId : orgBoundId).append("' \r\n");
            sbSQL.append("  and a.fperiodType = ").append(periodType).append(" \r\n");
            sbSQL.append("  and a.fyear = ").append(year).append(" \r\n");
            sbSQL.append("  and a.fperiod = ").append(period).append(" \r\n");
            sbSQL.append("  and (b.fvalidebit<>0 or b.fvalicredit<>0) \r\n");
            sbSQL.append(" and b.fcompanyid <> b.ftargetcompanyid \r\n");
            sbSQL.append(" and b.fcompanyid IN (");
            sbSQL.append(" Select FCompanyId From ").append(elimOrgUnitsTable).append(" ) \r\n");
            sbSQL.append(" and b.ftargetcompanyid IN (");
            sbSQL.append(" Select FCompanyId From ").append(elimOrgUnitsTable).append(" ) \r\n");
            sbSQL.append(" and a.fid NOT IN ( SELECT fCheckageDataID  \r\n");
            sbSQL.append("    FROM t_csl_ElimRecord a, t_csl_Elimination b \r\n");
            sbSQL.append("    WHERE a.fEliminationId = b.fid and b.fOrgUnit = '");
            sbSQL.append(orgUnitId).append("')  \r\n");
            sbSQL.append(" GROUP BY a.forgboundid, a.fperiodType, a.fyear, a.fperiod,a.fcurrencyid, a.ftempletid, b.fCompanyID, \r\n");
            sbSQL.append("       b.fitemid, c.fname_" + ctx.getLocale() + " , d.fname , d.FIsCitedByLater, e.fnumber , e.fname_" + ctx.getLocale() + "  \r\n");
            sbSQL.append(" ORDER BY a.fcurrencyid, a.ftempletid, b.fCompanyID \r\n");
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            return iRowSet;
        }
        finally {
            if (!DebugLogger.isDebug && elimOrgUnitsTable != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(elimOrgUnitsTable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createElimination(Context ctx, String orgTreeId, int periodType, int year, int period, String sourceCurrencyId, String currencyId, String templetId, String eliminationId, String orgUnitId, int isCitedByLater, Timestamp elimDate, ElimTypeEnum elimType, boolean isByCompany, String basicTreeId, String displayTypeId, DataCollectInfo dataCollect, OrgTreeInfo orgTreeInfo, OrgUnitInfo orgUnitInfo, String number) throws BOSException, SQLDataException, CodingRuleException, EASBizException {
        String longNumber = null;
        int level = 0;
        String orgTreeNumber = null;
        String orgUnitNumber = null;
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)" select struct.FLongNumber,struct.FLevel,tree.fnumber treeNumber,unit.fnumber unitNumber From t_org_structure struct inner join t_org_baseunit unit on unit.fid=struct.funitid inner join t_org_tree tree on tree.fid=struct.ftreeid where struct.ftreeid = ? and struct.funitid = ?", (Object[])new Object[]{orgTreeId, orgUnitId});
        try {
            while (rsTemp.next()) {
                longNumber = rsTemp.getString("FLongNumber");
                orgTreeNumber = rsTemp.getString("treeNumber");
                orgUnitNumber = rsTemp.getString("unitNumber");
                level = rsTemp.getInt("FLevel");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        OrgTreeInfo orgTree = new OrgTreeInfo();
        orgTree.setId(BOSUuid.read((String)orgTreeId));
        int elimMethod = Integer.parseInt(CSLServerHelper.getSysParamValue(ctx, orgTree, "GR_CSL_ELIMMETHOD_001"));
        int mergeType = 0;
        mergeType = Integer.parseInt(CSLServerHelper.getSysParamValue(ctx, orgTree, "GR_CSL_MERGETYPE_004"));
        mergeType = mergeType == 0 ? 0 : 1;
        String elimOrgUnitsTable = SameControlUtil.getElimOrgUnitsTable((Context)ctx, (String)orgTreeId, (String)orgUnitId, (String)longNumber, (String)orgUnitNumber, (String)orgTreeNumber, (int)year, (int)period, (int)periodType, (int)level, (ElimTypeEnum)elimType, (int)mergeType);
        try {
            ResultSet rs_2;
            PreparedStatement ps2;
            ResultSet rs_1;
            PreparedStatement ps1;
            PreparedStatement pst1;
            PreparedStatement pst;
            PreparedStatement pst0;
            Connection conn;
            block26: {
                String elimNumber = number;
                if (StringUtils.isEmpty((String)elimNumber)) {
                    elimNumber = this.generateElimNumber(ctx, orgTreeId, periodType, year, period, orgTreeInfo, orgUnitInfo).toString();
                }
                CommonTable commonTable = new CommonTable(elimType);
                String creatorId = ctx.getCaller().toString();
                Timestamp createTime = new Timestamp(System.currentTimeMillis());
                IElimTemplet elimTemplet = ElimTempletFactory.getLocalInstance(ctx);
                ElimTempletInfo elimTempletInfo = elimTemplet.getElimTempletInfo("select eliminationmode where id = '" + templetId + "'");
                String eliminationModeId = null;
                if (elimTempletInfo != null && elimTempletInfo.getEliminationMode() != null) {
                    eliminationModeId = elimTempletInfo.getEliminationMode().getId().toString();
                }
                conn = null;
                pst0 = null;
                pst = null;
                pst1 = null;
                BOSUuid dataCollectID = null;
                String dataCollectNumber = null;
                if (dataCollect != null) {
                    dataCollectID = dataCollect.getId();
                    dataCollectNumber = dataCollect.getNumber();
                }
                ps1 = null;
                rs_1 = null;
                ps2 = null;
                rs_2 = null;
                StringBuffer sqlElimEntry = new StringBuffer(" SELECT DISTINCT b.fitemid, b.fCompanyID, f.FDataElement, f.fdc, f.fsummary, sum(b.fvalidebit) as fvalidebit, sum(b.fvaliCredit) as fvaliCredit \r\n");
                sqlElimEntry.append(" from ").append(commonTable.getMasterTable()).append(" a \r\n");
                sqlElimEntry.append(" RIGHT OUTER JOIN ").append(commonTable.getEntryTable()).append(" AS b \r\n");
                sqlElimEntry.append("  ON a.FID = b.FCheckageID \r\n");
                sqlElimEntry.append(" INNER JOIN T_BD_Currency AS c \r\n");
                sqlElimEntry.append("  ON a.FCurrencyID = c.FID \r\n");
                sqlElimEntry.append(" INNER JOIN T_CSL_ElimTemplet AS d \r\n");
                sqlElimEntry.append("  ON a.FTempletID = d.FID \r\n");
                sqlElimEntry.append(" INNER JOIN T_CSL_ElimTempletEntry AS f \r\n");
                sqlElimEntry.append("  ON f.FTempletID = d.FID \r\n");
                sqlElimEntry.append("  and f.fItemId = b.FItemID \r\n");
                sqlElimEntry.append("  and f.fdataelement = b.fdataelement \r\n");
                sqlElimEntry.append(" INNER JOIN T_CSL_RptItem AS e \r\n");
                sqlElimEntry.append("  ON b.FItemID = e.FID \r\n");
                if (mergeType == 1) {
                    sqlElimEntry.append(" INNER Join ").append(elimOrgUnitsTable).append(" x \r\n");
                    sqlElimEntry.append(" ON b.fcompanyid = x.fcompanyid And b.ftargetcompanyid=x.ftargetcompanyid");
                }
                StringBuffer whereSQL = new StringBuffer(" WHERE a.fcurrencyid = '").append(currencyId).append("' \r\n");
                whereSQL.append(" and a.ftempletid = '").append(templetId).append("' \r\n");
                whereSQL.append("  and a.fcheckedstatus = ").append(2).append(" \r\n");
                whereSQL.append("   and a.fOrgBoundId = '").append(isByCompany ? basicTreeId : orgTreeId).append("' \r\n");
                whereSQL.append("  and a.fperiodType = ").append(periodType).append(" \r\n");
                whereSQL.append("  and a.fyear = ").append(year).append(" \r\n");
                whereSQL.append("  and a.fperiod = ").append(period).append(" \r\n");
                whereSQL.append(" \r\n");
                if (dataCollectNumber != null && dataCollectNumber.length() != 0) {
                    whereSQL.append(" and a.fdatacollectnumber = '").append(dataCollectNumber).append("'");
                }
                whereSQL.append(" and a.fid NOT IN ( SELECT fCheckageDataID  \r\n");
                whereSQL.append("    FROM t_csl_ElimRecord a, t_csl_Elimination b \r\n");
                whereSQL.append("    WHERE a.fEliminationId = b.fid and b.fOrgUnit = '");
                whereSQL.append(orgUnitId).append("')  \r\n");
                sqlElimEntry.append(whereSQL.toString());
                if (mergeType == 1 && !isByCompany && elimMethod == 2) {
                    sqlElimEntry.append(" AND (x.fcompanyid || x.ftargetcompanyid) in ");
                    sqlElimEntry.append(" ( select a.FFromId || a.FToId From");
                    sqlElimEntry.append(" (select r1.finvestcompanyid as ffromid,r1.fcontrolcompanyid as ftoid from t_csl_relatedPartyRela r1");
                    sqlElimEntry.append(" join t_csl_relatedParty r2 on r1.FRelationShipId = r2.fid");
                    sqlElimEntry.append(" where r2.FNumber = '001' or r2.FNumber = '003' or r2.FNumber = '004' or r2.Fnumber = '005') a,");
                    sqlElimEntry.append(" (select r1.finvestcompanyid as ffromid,r1.fcontrolcompanyid as ftoid from t_csl_relatedPartyRela r1");
                    sqlElimEntry.append(" join t_csl_relatedParty r2 on r1.FRelationShipId = r2.fid");
                    sqlElimEntry.append(" where r2.FNumber = '001' or r2.FNumber = '003' or r2.FNumber = '004' or r2.Fnumber = '005') b ");
                    sqlElimEntry.append(" WHERE (a.ffromid=b.ftoid and a.ftoid=b.ffromid) ");
                    sqlElimEntry.append(")");
                }
                sqlElimEntry.append(" GROUP BY a.forgboundid, a.fperiodType, a.fyear, a.fperiod,a.fcurrencyid, a.ftempletid, b.fitemid, b.fCompanyID,f.FDataElement, f.fdc, f.fsummary \r\n");
                StringBuffer sqlElimRecord = new StringBuffer(" SELECT DISTINCT a.fid from ").append(commonTable.getMasterTable()).append(" a \r\n");
                sqlElimRecord.append(" RIGHT OUTER JOIN ").append(commonTable.getEntryTable()).append(" AS b \r\n");
                sqlElimRecord.append(" ON a.FID = b.FCheckageID \r\n");
                if (mergeType == 1) {
                    sqlElimRecord.append(" INNER Join ").append(elimOrgUnitsTable).append(" x \r\n");
                    sqlElimRecord.append(" ON b.fcompanyid = x.fcompanyid And b.ftargetcompanyid=x.ftargetcompanyid");
                }
                sqlElimRecord.append(whereSQL.toString());
                try {
                    EliminationInfo info;
                    conn = super.getConnection(ctx);
                    ps1 = conn.prepareStatement(sqlElimEntry.toString());
                    rs_1 = ps1.executeQuery();
                    ps2 = conn.prepareStatement(sqlElimRecord.toString());
                    rs_2 = ps2.executeQuery();
                    StringBuffer sbInsert = new StringBuffer(" INSERT INTO T_CSL_EliminationEntry \r\n");
                    sbInsert.append("   (fid, fseq, fitemid, fDataElement, fsummary, fdebit, fcredit, feliminationId, fCompanyID) VALUES(?,?,?,?,?,?,?,?,?) \r\n");
                    pst = conn.prepareStatement(sbInsert.toString());
                    int lineSeq = 0;
                    BigDecimal zero = new BigDecimal("0");
                    boolean isIncludeEntries = false;
                    while (rs_1.next()) {
                        String lineId = new ObjectUuidPK(new BOSObjectType(ELIMINATION_ENTRY_BOSTYPE)).toString();
                        ++lineSeq;
                        String itemId = rs_1.getString("fItemId");
                        BigDecimal valiDebit = rs_1.getBigDecimal("fValiDebit");
                        BigDecimal valiCredit = rs_1.getBigDecimal("fValiCredit");
                        String companyID = rs_1.getString("fCompanyID");
                        int dataElement = rs_1.getInt("fDataElement");
                        String summary = rs_1.getString("fsummary");
                        int dcType = rs_1.getInt("fdc");
                        if (valiDebit.compareTo(zero) != 0 && valiCredit.compareTo(zero) != 0) {
                            if (dcType == 0) {
                                valiCredit = valiCredit.subtract(valiDebit);
                                valiDebit = zero;
                            } else if (dcType == 1) {
                                valiDebit = valiDebit.subtract(valiCredit);
                                valiCredit = zero;
                            }
                        }
                        if (valiDebit.compareTo(zero) == 0 && valiCredit.compareTo(zero) == 0) continue;
                        pst.setString(1, lineId);
                        pst.setInt(2, lineSeq);
                        pst.setString(3, BOSUuid.read((String)itemId).toString());
                        pst.setInt(4, dataElement);
                        pst.setString(5, summary == null ? null : summary);
                        pst.setObject(6, valiDebit.compareTo(zero) == 0 ? null : CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)valiDebit));
                        pst.setObject(7, valiCredit.compareTo(zero) == 0 ? null : CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)valiCredit));
                        pst.setString(8, eliminationId);
                        pst.setString(9, BOSUuid.read((String)companyID).toString());
                        pst.addBatch();
                        isIncludeEntries = true;
                    }
                    if (isIncludeEntries) {
                        pst0 = this.insertDataToElimination(orgTreeId, periodType, year, period, sourceCurrencyId, currencyId, templetId, eliminationId, orgUnitId, isCitedByLater, elimDate, elimType, displayTypeId, elimNumber, creatorId, createTime, eliminationModeId, conn, dataCollectID, dataCollectNumber);
                        pst.executeBatch();
                        pst.clearBatch();
                        sbInsert = new StringBuffer(" INSERT INTO T_CSL_ElimRecord \r\n");
                        sbInsert.append("   (fid,fcreatorId,flastupdateUserId, feliminationid, fcheckageDataid) VALUES (?,?,?,?,?) \r\n");
                        pst1 = conn.prepareStatement(sbInsert.toString());
                        boolean hasData = false;
                        while (rs_2.next()) {
                            String id = new ObjectUuidPK(new BOSObjectType(ELIMRECORD_BOSTYPE)).toString();
                            String checkageDataId = rs_2.getString("fid");
                            pst1.setString(1, id);
                            pst1.setString(2, creatorId);
                            pst1.setString(3, creatorId);
                            pst1.setString(4, eliminationId);
                            pst1.setString(5, BOSUuid.read((String)checkageDataId).toString());
                            pst1.addBatch();
                            hasData = true;
                        }
                        if (hasData) {
                            pst1.executeBatch();
                            pst1.clearBatch();
                        }
                    }
                    ObjectUuidPK pk = new ObjectUuidPK(eliminationId);
                    IElimination iElimination = EliminationFactory.getLocalInstance(ctx);
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("*"));
                    selector.add(new SelectorItemInfo("entries.*"));
                    selector.add(new SelectorItemInfo("entries.item.id"));
                    selector.add(new SelectorItemInfo("entries.item.number"));
                    selector.add(new SelectorItemInfo("entries.item.isProfitAndLosses"));
                    selector.add(new SelectorItemInfo("entries.company.number"));
                    selector.add(new SelectorItemInfo("currency.precision"));
                    if (!iElimination.exists((IObjectPK)pk) || (info = iElimination.getEliminationInfo((IObjectPK)pk, selector)).getEntries() == null || info.getEntries().size() <= 0) break block26;
                    iElimination.submit((CoreBaseInfo)info);
                }
                catch (SQLException exc) {
                    try {
                        throw new BOSException("Sql execute exception : when insert records to tables", (Throwable)exc);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pst0);
                        SQLUtils.cleanup(pst);
                        SQLUtils.cleanup(pst1);
                        SQLUtils.cleanup(rs_1, (Statement)ps1);
                        SQLUtils.cleanup(rs_2, ps2, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((Statement)pst0);
            SQLUtils.cleanup((Statement)pst);
            SQLUtils.cleanup((Statement)pst1);
            SQLUtils.cleanup((ResultSet)rs_1, (Statement)ps1);
            SQLUtils.cleanup((ResultSet)rs_2, (Statement)ps2, (Connection)conn);
        }
        finally {
            if (!DebugLogger.isDebug && elimOrgUnitsTable != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(elimOrgUnitsTable);
            }
        }
    }

    private PreparedStatement insertDataToElimination(String orgTreeId, int periodType, int year, int period, String sourceCurrencyId, String currencyId, String templetId, String eliminationId, String orgUnitId, int isCitedByLater, Timestamp elimDate, ElimTypeEnum elimType, String displayTypeId, String elimNumber, String creatorId, Timestamp createTime, String eliminationModeId, Connection conn, BOSUuid dataCollectID, String dataCollectNumber) throws SQLException {
        StringBuffer insertHead = new StringBuffer(" INSERT INTO T_CSL_Elimination \r\n");
        insertHead.append("(fid, FDate, FCreateTime,FCreatorID,fnumber,forgboundid, forgunit,fperiodtype, fyear,fperiod,FSourceCurrencyID,fcurrencyid,ftempletid, \r\n ");
        insertHead.append(" fcheckedStatus, fdatasource, farchivedstatus, fvaluetype, felimtype, FIsCitedByLater \r\n");
        if (dataCollectID != null && dataCollectNumber != null) {
            insertHead.append(",fdatacollectid,fdatacollectnumber");
        }
        insertHead.append(" ,FDisplayTemplateTypeId ,FEliminationModeId ) \r\n");
        if (dataCollectID != null && dataCollectNumber != null) {
            insertHead.append(" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        } else {
            insertHead.append(" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        }
        PreparedStatement pst0 = conn.prepareStatement(insertHead.toString());
        pst0.setString(1, eliminationId);
        pst0.setDate(2, new java.sql.Date(elimDate.getTime()));
        pst0.setDate(3, new java.sql.Date(createTime.getTime()));
        pst0.setString(4, creatorId);
        pst0.setString(5, elimNumber);
        pst0.setString(6, orgTreeId);
        pst0.setString(7, orgUnitId);
        pst0.setInt(8, periodType);
        pst0.setInt(9, year);
        pst0.setInt(10, period);
        pst0.setString(11, sourceCurrencyId == null ? currencyId : sourceCurrencyId);
        pst0.setString(12, currencyId);
        pst0.setString(13, templetId);
        pst0.setInt(14, 1);
        pst0.setInt(15, 1);
        pst0.setInt(16, 1);
        pst0.setInt(17, 1);
        pst0.setInt(18, elimType.getValue());
        pst0.setInt(19, isCitedByLater);
        if (dataCollectID != null && dataCollectNumber != null) {
            pst0.setString(20, dataCollectID.toString());
            pst0.setString(21, dataCollectNumber);
            pst0.setString(22, displayTypeId != null ? displayTypeId : null);
            pst0.setString(23, eliminationModeId != null ? eliminationModeId : null);
        } else {
            pst0.setString(20, displayTypeId != null ? displayTypeId : null);
            pst0.setString(21, eliminationModeId != null ? eliminationModeId : null);
        }
        pst0.execute();
        return pst0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRowSet _gradeSumCheckRecord(Context ctx, String orgBoundId, int periodType, int year, int period, String orgUnitId, ElimTypeEnum elimType) throws BOSException, EASBizException {
        String longNumber = null;
        String orgTreeNumber = null;
        String orgUnitNumber = null;
        int level = 0;
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)" select struct.FLongNumber,struct.FLevel,tree.fnumber treeNumber,unit.fnumber unitNumber From t_org_structure struct inner join t_org_baseunit unit on unit.fid=struct.funitid inner join t_org_tree tree on tree.fid=struct.ftreeid where struct.ftreeid = ? and struct.funitid = ?", (Object[])new Object[]{orgBoundId, orgUnitId});
        try {
            while (rsTemp.next()) {
                longNumber = rsTemp.getString("FLongNumber");
                orgTreeNumber = rsTemp.getString("treeNumber");
                orgUnitNumber = rsTemp.getString("unitNumber");
                level = rsTemp.getInt("FLevel");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        String elimOrgUnitsTable = SameControlUtil.getElimOrgUnitsTable((Context)ctx, (String)orgBoundId, (String)orgUnitId, (String)longNumber, (String)orgUnitNumber, (String)orgTreeNumber, (int)year, (int)period, (int)periodType, (int)level, (ElimTypeEnum)elimType, (int)1);
        try {
            StringBuffer sbSQL = null;
            CommonTable commonTable = new CommonTable(elimType);
            sbSQL = new StringBuffer("select distinct a.forgboundid, a.fperiodType, a.fyear, a.fperiod,a.fcurrencyid, a.ftempletid, b.fitemid, b.fCompanyID, \r\n");
            sbSQL.append(" sum(b.fvalidebit) as fvalidebit, sum(b.fvaliCredit) as fvaliCredit, \r\n");
            sbSQL.append("  c.fname_" + ctx.getLocale() + " as fCurrencyName, d.fname as fTempletname,  d.FIsCitedByLater as FIsCitedByLater, \r\n");
            sbSQL.append(" e.fnumber as fItemNumber, e.fname_" + ctx.getLocale() + " as fItemName \r\n");
            sbSQL.append(" from ").append(commonTable.getMasterTable()).append(" a \r\n");
            sbSQL.append(" RIGHT OUTER JOIN ").append(commonTable.getEntryTable()).append(" AS b \r\n");
            sbSQL.append("  ON a.FID = b.FCheckageID \r\n");
            sbSQL.append(" INNER JOIN T_BD_Currency AS c \r\n");
            sbSQL.append("  ON a.FCurrencyID = c.FID \r\n");
            sbSQL.append(" INNER JOIN T_CSL_ElimTemplet AS d \r\n");
            sbSQL.append("  ON a.FTempletID = d.FID \r\n");
            sbSQL.append(" INNER JOIN T_CSL_RptItem AS e \r\n");
            sbSQL.append("  ON b.FItemID = e.FID \r\n");
            sbSQL.append(" INNER Join ").append(elimOrgUnitsTable).append(" x \r\n");
            sbSQL.append(" ON b.fcompanyid = x.fcompanyid And b.ftargetcompanyid=x.ftargetcompanyid");
            sbSQL.append(" INNER JOIN T_CSL_ElimTempletEntry AS f \r\n");
            sbSQL.append("  ON f.FTempletID = d.FID \r\n");
            sbSQL.append("  and f.fItemId = b.FItemID \r\n");
            sbSQL.append("  and f.fdataelement = b.fdataelement \r\n");
            sbSQL.append(" WHERE a.fcheckedstatus = ").append(2).append(" \r\n");
            sbSQL.append("\tand a.fOrgBoundId = '").append(orgBoundId).append("' \r\n");
            sbSQL.append("  and a.fperiodType = ").append(periodType).append(" \r\n");
            sbSQL.append("  and a.fyear = ").append(year).append(" \r\n");
            sbSQL.append("  and a.fperiod = ").append(period).append(" \r\n");
            sbSQL.append("  and (b.fvalidebit<>0 or b.fvalicredit<>0) \r\n");
            sbSQL.append(" and a.fid NOT IN ( SELECT fCheckageDataID  \r\n");
            sbSQL.append("    FROM t_csl_ElimRecord a, t_csl_Elimination b \r\n");
            sbSQL.append("    WHERE a.fEliminationId = b.fid and b.fOrgUnit = '");
            sbSQL.append(orgUnitId).append("')  \r\n");
            sbSQL.append(" GROUP BY a.forgboundid, a.fperiodType, a.fyear, a.fperiod,a.fcurrencyid, a.ftempletid, b.fitemid, b.fCompanyID,\r\n");
            sbSQL.append("   c.fname_" + ctx.getLocale() + " , d.fname , d.FIsCitedByLater, e.fnumber , e.fname_" + ctx.getLocale() + "  \r\n");
            sbSQL.append(" ORDER BY a.fcurrencyid, a.ftempletid, b.fCompanyID \r\n");
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            return iRowSet;
        }
        finally {
            if (!DebugLogger.isDebug && elimOrgUnitsTable != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(elimOrgUnitsTable);
            }
        }
    }

    @Override
    protected boolean _isHaveUnAuditCheck(Context ctx, String orgTree, RptPeriodTypeEnum rptPeriodType, int curYear, int curPeriod, String orgUnit, ElimTypeEnum elimType, String dataCollectNumber) throws BOSException, EASBizException {
        String inCompanys = this.getInSQL_ComOfCurOrgUnit(ctx, orgTree, orgUnit, rptPeriodType, curYear, curPeriod, elimType);
        CommonTable commonTable = new CommonTable(elimType);
        MergeModeEnum mergeType = CslRptUtil.getMergeMode(ctx, orgTree);
        StringBuffer sbSQL = new StringBuffer("Select a.fid from ").append(commonTable.getMasterTable()).append(" a  \r\n");
        sbSQL.append(" RIGHT OUTER JOIN ").append(commonTable.getEntryTable()).append(" AS b \r\n");
        sbSQL.append("  ON a.FID = b.FCheckageID \r\n");
        sbSQL.append("  INNER JOIN  (  \r\n");
        sbSQL.append("  select count(fdc) as fsingledc, fid from (  \r\n");
        sbSQL.append("  select distinct b.fdc, a.fid from t_csl_elimtemplet a  \r\n");
        sbSQL.append("  inner join t_csl_elimtempletentry b  \r\n");
        sbSQL.append("  on a.fid = b.ftempletid and a.fcheckedstatus = ").append(2).append(" ) tt group by fid  \r\n");
        sbSQL.append("   ) as t \r\n");
        sbSQL.append("  ON a.ftempletid = t.FID \r\n");
        sbSQL.append(" WHERE a.fcheckedstatus = ").append(1).append(" \r\n");
        sbSQL.append("\tand a.fOrgBoundId = '").append(orgTree).append("' \r\n");
        if (MergeModeEnum.ORDINAL.equals((Object)mergeType)) {
            sbSQL.append("  and a.FOrgUnitID = '").append(orgUnit).append("' \r\n");
        }
        sbSQL.append("  and a.fperiodType = ").append(rptPeriodType.getValue()).append(" \r\n");
        sbSQL.append("  and a.fyear = ").append(curYear).append(" \r\n");
        sbSQL.append("  and a.fperiod = ").append(curPeriod).append(" \r\n");
        sbSQL.append("  and (b.FDebit <> 0 OR b.FCredit <> 0 OR b.FValiDebit <> 0 OR b.FValiCredit <> 0) \r\n");
        if (inCompanys != null && inCompanys.length() != 0) {
            sbSQL.append("  and b.fcompanyid in ").append(inCompanys);
            sbSQL.append("\r\n  and  b.ftargetCompanyid in ").append(inCompanys).append(" \r\n");
        }
        if (!StringUtils.isEmpty((String)dataCollectNumber)) {
            sbSQL.append("  and a.FDataCollectNumber='").append(dataCollectNumber).append("' \r\n");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException exc) {
            throw new BOSException("Sql execute exception : " + sbSQL.toString(), (Throwable)exc);
        }
        return false;
    }

    private String doAudit(Context ctx, ArrayList idCollection, CheckedStatusEnum checkedType, ElimTypeEnum elimType, boolean isByCompany) throws BOSException, EASBizException {
        StringBuffer tips = new StringBuffer();
        Boolean isFromCompany = isByCompany ? isByCompany : this.isFromCompany(idCollection);
        String strIDs = this.getCheckageIDCollection(idCollection);
        CommonTable common = new CommonTable(elimType);
        this.checkRule(ctx, strIDs, checkedType, common, idCollection, isFromCompany, tips);
        if (idCollection.size() > 0) {
            strIDs = this.getCheckageIDCollection(idCollection);
            this.updateAuditFlag(ctx, strIDs, checkedType, common, isFromCompany);
        }
        return tips.toString();
    }

    private boolean isFromCompany(ArrayList idCollection) {
        if (idCollection != null && idCollection.size() > 0 && idCollection.get(idCollection.size() - 1) instanceof Boolean) {
            Boolean isFromCompany = (Boolean)idCollection.remove(idCollection.size() - 1);
            return isFromCompany;
        }
        return false;
    }

    private String getCheckageIDCollection(ArrayList idCollection) throws EASBizException {
        StringBuffer sb = new StringBuffer();
        if (idCollection.size() < 1) {
            throw new InterCheckException(InterCheckException.HAVE_NO_AUDIT);
        }
        Iterator it = idCollection.iterator();
        sb.append("(");
        boolean bfirst = true;
        Object obj = null;
        while (it.hasNext()) {
            obj = it.next();
            if (obj == null) continue;
            if (!bfirst) {
                sb.append(",");
            } else {
                bfirst = false;
            }
            sb.append("'").append(obj.toString()).append("'");
        }
        sb.append(")");
        return sb.toString();
    }

    private void checkRule(Context ctx, String ids, CheckedStatusEnum status, CommonTable common, List idCollection, boolean isByCompany, StringBuffer tips) throws BOSException, EASBizException {
        boolean isAudited = status.getValue() == 2;
        String resKey = null;
        ArrayList<String> excludeIds = new ArrayList<String>();
        SQLBuilder sql = this.getRule1Or2SQL(common, status, idCollection);
        resKey = isAudited ? "CantConfirmHasConfirmRec" : "CantUnConfirmIsUnConfirmRec";
        this.collectCheckRuleTips(ctx, sql, excludeIds, resKey, null, null, tips, common);
        if (status.getValue() == 1) {
            sql = this.getRule5SQL(ctx, common, status, idCollection);
            resKey = "OprtNeetTheSamePerson";
            this.collectCheckRuleTips(ctx, sql, excludeIds, resKey, new IValidated(){

                @Override
                public boolean isValidated(Context ctx, IRowSet rs) {
                    return CslRptUtil.canUnAuditCheck(ctx);
                }
            }, null, tips, common);
        }
        if (status.getValue() == 1) {
            sql = this.getRule6SQL(common, status, idCollection);
            resKey = "CantUnConfirmBecauseGenElim";
            this.collectCheckRuleTips(ctx, sql, excludeIds, resKey, null, new IValidated(){

                @Override
                public boolean isValidated(Context ctx, IRowSet rs) throws BOSException, EASBizException {
                    try {
                        return InterCheckControllerBean.this.isRealExistElimRecords(ctx, "('" + rs.getString("FID") + "')");
                    }
                    catch (SQLException e) {
                        throw new SQLDataException(e);
                    }
                }
            }, tips, common);
        }
        if (isByCompany) {
            sql = this.getRule7SQL(ctx, common, idCollection);
            resKey = "CantConfirnOrNotOprtBecauseNotBeCheckParty";
            this.collectCheckRuleTips(ctx, sql, excludeIds, resKey, null, null, tips, common);
            if (status.getValue() == 2) {
                sql = this.getRule8SQL(ctx, common, idCollection);
                resKey = "CantConfirmBecauseNotBeAuditRec";
                this.collectCheckRuleTips(ctx, sql, excludeIds, resKey, null, null, tips, common);
            }
        }
        idCollection.removeAll(excludeIds);
    }

    private String getMsgTitle(String resKey, Context _ctx) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)resKey, (Locale)_ctx.getOriginLocale());
    }

    private SQLBuilder getRule1Or2SQL(CommonTable common, CheckedStatusEnum status, List idCollection) {
        SQLBuilder sbSQL = new SQLBuilder();
        sbSQL.append("Select distinct fnumber,FID From ").append(common.getMasterTable()).append(" \r\n");
        sbSQL.append(" Where FID IN ", (Collection)idCollection).append(" \r\n");
        if (status.getValue() == 2) {
            sbSQL.append(" and FCheckedStatus = ? ", (Object)status.getValue());
        } else {
            sbSQL.append(" and FCheckedStatus in(0,1) \r\n");
        }
        sbSQL.append(" order by fnumber ");
        return sbSQL;
    }

    private SQLBuilder getRule3SQL(CommonTable common, CheckedStatusEnum status, List idCollection) {
        SQLBuilder sbSQL = new SQLBuilder();
        sbSQL.append("Select distinct fnumber,FID From ").append(common.getMasterTable()).append(" \r\n");
        sbSQL.append(" Where FDiffValue <> 0 AND FSingleDC = 0 ");
        sbSQL.append(" And FID in ", (Collection)idCollection);
        sbSQL.append(" order by fnumber ");
        return sbSQL;
    }

    private SQLBuilder getRule5SQL(Context ctx, CommonTable common, CheckedStatusEnum status, List idCollection) {
        SQLBuilder sbSQL = new SQLBuilder();
        sbSQL.append("Select distinct fnumber,FID From ").append(common.getMasterTable()).append(" \r\n");
        sbSQL.append(" Where FID in ", (Collection)idCollection).append(" \r\n");
        sbSQL.append(" And FCheckedStatus = ").append((Object)2).append(" \r\n");
        sbSQL.append(" And FAuditorID <> '").append((Object)ctx.getCaller()).append("'");
        sbSQL.append(" order by fnumber ");
        return sbSQL;
    }

    private SQLBuilder getRule6SQL(CommonTable common, CheckedStatusEnum status, List idCollection) {
        SQLBuilder sbSQL = new SQLBuilder();
        sbSQL.append("Select distinct mast.fnumber,mast.FID From T_CSL_ElimRecord elim \r\n");
        sbSQL.append(" INNER JOIN ").append(common.getMasterTable()).append(" mast \n");
        sbSQL.append(" ON mast.fid = FCheckageDataID \n");
        sbSQL.append(" Where mast.fid in ", (Collection)idCollection).append(" \r\n");
        sbSQL.append(" order by mast.fnumber ");
        return sbSQL;
    }

    private void collectCheckRuleTips(Context ctx, SQLBuilder sql, List<String> excludeIds, String resKey, IValidated out, IValidated in, StringBuffer tips, CommonTable common) throws BOSException, EASBizException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        try {
            if (rs.size() > 0 && (out == null || out.isValidated(ctx, rs))) {
                AuditOperator.MessageConstructor msgConst = new AuditOperator.MessageConstructor(this.getMsgTitle(resKey, ctx));
                while (rs.next()) {
                    if (in != null && !in.isValidated(ctx, rs)) continue;
                    msgConst.addItem((common._elimType.equals((Object)ElimTypeEnum.ComeAndGo) ? "WL-" : "JY-") + rs.getString("fnumber"));
                    excludeIds.add(rs.getString("FID"));
                }
                tips.append(msgConst.getMsgBuilded());
                tips.append("\n");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private SQLBuilder getRule7SQL(Context ctx, CommonTable common, List idCollection) {
        SQLBuilder sbSQL7 = new SQLBuilder();
        sbSQL7.append("select distinct a.fnumber,a.FID from ").append(common.getMasterTable());
        sbSQL7.append(" a join ").append(common.getEntryTable()).append(" b ON A.FID = B.FCHECKAGEID ");
        sbSQL7.append(" WHERE a.FID in", (Collection)idCollection);
        sbSQL7.append(" AND a.FCheckedParty = ? ", (Object)ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString());
        sbSQL7.append(" and B.FCOMPANYID <>b.FTARGETCOMPANYID ");
        sbSQL7.append(" order by fnumber ");
        return sbSQL7;
    }

    private SQLBuilder getRule8SQL(Context ctx, CommonTable common, List idCollection) {
        SQLBuilder sql = new SQLBuilder();
        sql.append("Select distinct fnumber,FID From ").append(common.getMasterTable()).append(" \r\n");
        sql.append(" Where FID in ", (Collection)idCollection).append(" \r\n");
        sql.append(" And FCheckedStatus = ?", (Object)1);
        sql.append(" And FCheckedParty is not null");
        sql.append(" order by fnumber ");
        return sql;
    }

    private boolean isRealExistElimRecords(Context ctx, String idStr) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct record.FEliminationId,record.FCheckageDataId,              \n").append(" elim.Fid ElimId,entry.Fid EntryId                                          \n").append(" from t_csl_ElimRecord record                                               \n").append(" left join t_csl_Elimination elim on record.FeliminationId = elim.Fid       \n").append(" left join t_csl_EliminationEntry entry on elim.Fid = entry.FEliminationId  \n").append(" where record.FCheckageDataId in ").append(idStr);
        IRowSet rs = null;
        String elimnationId = null;
        String FElimId = null;
        String FEntryId = null;
        HashSet<String> delElimIds = new HashSet<String>();
        HashSet<String> elimRecordIds = new HashSet<String>();
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                elimnationId = rs.getString("FEliminationId");
                FElimId = rs.getString("ElimId");
                FEntryId = rs.getString("EntryId");
                if (FElimId == null || FEntryId == null) {
                    delElimIds.add(elimnationId);
                }
                elimRecordIds.add(elimnationId);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (delElimIds.size() == 0 || delElimIds.size() != elimRecordIds.size()) {
            return true;
        }
        this.dealVoidElimRecords(ctx, delElimIds);
        return delElimIds.size() != elimRecordIds.size();
    }

    private void dealVoidElimRecords(Context ctx, Set delElimIds) throws BOSException, EASBizException {
        String idStr = CslRptUtil.AryToItemString(delElimIds);
        String delElimEntrySql = "delete t_csl_eliminationEntry where FeliminationId in(" + idStr + ")";
        String delElimSql = "delete t_csl_Elimination where Fid in(" + idStr + ")";
        String delElimRecord = "delete t_csl_ElimRecord where FEliminationId in(" + idStr + ")";
        Connection cnn = null;
        Statement st = null;
        try {
            cnn = this.getConnection(ctx);
            st = cnn.createStatement();
            st.addBatch(delElimEntrySql);
            st.addBatch(delElimSql);
            st.addBatch(delElimRecord);
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)cnn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)cnn);
    }

    private void updateAuditFlag(Context ctx, String ids, CheckedStatusEnum status, CommonTable common, Boolean isFromCompany) throws BOSException {
        Object helper;
        if (status.getValue() == 2) {
            helper = new UpdateAuditHelper();
            ((UpdateAuditHelper)helper).execUpdateSQL(ctx, common, CheckageConfirmEnum.Confirm, ids);
        } else {
            helper = new UpdateUnAuditHelper();
            if (!isFromCompany.booleanValue()) {
                ((UpdateUnAuditHelper)helper).execUpdate(ctx, common, CheckageConfirmEnum.UnConfirm, ids, false, false);
            } else {
                ((UpdateUnAuditHelper)helper).execUpdate(ctx, common, CheckageConfirmEnum.UnConfirm, ids, true, true);
                ((UpdateUnAuditHelper)helper).execUpdate(ctx, common, CheckageConfirmEnum.Audit, ids, false, true);
            }
        }
        StringBuffer updSQL = new StringBuffer(" UPDATE T_CSL_InterItemData SET FCheckageStatus = ").append(status.getValue());
        updSQL.append(" \r\n");
        updSQL.append(" WHERE FCheckageRecord in ").append(ids).append(" \r\n");
        try {
            DbUtil.execute((Context)ctx, (String)updSQL.toString());
        }
        catch (Exception exc) {
            throw new BOSException("Sql execute exception : " + updSQL.toString(), (Throwable)exc);
        }
    }

    private synchronized int getCurrentCheckageMaxNumber(Context ctx, String orgTreeId, String orgUnitId, int periodType, int year, int period, String tableName) throws BOSException {
        int number = 0;
        StringBuffer sbSQL = new StringBuffer(" SELECT Max(to_int(fnumber)) As Fmaxnumber From \r\n");
        sbSQL.append(tableName).append(" a  \r\n");
        sbSQL.append("  WHERE a.fOrgBoundId = '").append(orgTreeId).append("' \r\n");
        sbSQL.append("  and a.fyear = ").append(year).append(" \r\n");
        sbSQL.append("  and a.fperiod = ").append(period).append(" \r\n");
        sbSQL.append("  and a.fperiodType = ").append(periodType).append(" \r\n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            if (rs.next() && rs.getInt("Fmaxnumber") != 0) {
                number = rs.getInt("Fmaxnumber");
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        return ++number;
    }

    @Override
    protected String _batchAudit(Context ctx, ArrayList idCollection, ElimTypeEnum elimType) throws BOSException, EASBizException {
        return this.doAudit(ctx, idCollection, CheckedStatusEnum.AUDITED, elimType, false);
    }

    @Override
    protected String _batchUnAudit(Context ctx, ArrayList idCollection, ElimTypeEnum elimType) throws BOSException, EASBizException {
        return this.doAudit(ctx, idCollection, CheckedStatusEnum.UNAUDITED, elimType, false);
    }

    @Override
    protected void _batchUnAuditByCompany(Context ctx, ArrayList idCollection, ElimTypeEnum elimType, boolean isByCompany) throws BOSException, EASBizException {
        this.doAudit(ctx, idCollection, CheckedStatusEnum.UNAUDITED, elimType, isByCompany);
    }

    @Override
    protected List _getInterCheckSumValues(Context ctx, int year, int period, int periodType, String treeId, String currencyId) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IRowSet _getStepCheckRelation(Context ctx, Map param) throws BOSException, EASBizException {
        IRowSet rs = null;
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" select count(distinct case when t1.FCompanyId>t1.FTargetCompanyId THEN t1.fcompanyId || '!' ||t1.ftargetcompanyid ");
        sbSQL.append(" ELSE t1.ftargetcompanyid || '!' || t1.fcompanyid END) As fcount ");
        sbSQL.append(" From t_csl_InterItemData t1, t_csl_RptReceived t2 ");
        sbSQL.append(" WHERE t1.FPeriodType = ").append(param.get("periodType"));
        sbSQL.append(" AND t1.FYear = ").append(param.get("year"));
        sbSQL.append(" AND t1.FPeriod = ").append(param.get("period"));
        sbSQL.append(" AND t2.FOrgTreeId = '").append(param.get("orgTreeId")).append("'");
        rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
        try {
            if (rs.next()) {
                if (rs.getInt("fcount") <= 50) {
                    return null;
                }
                sbSQL = new StringBuffer();
                sbSQL.append(" select distinct case when t1.FCompanyId>t1.FTargetCompanyId THEN t1.fcompanyId || '!' ||t1.ftargetcompanyid ");
                sbSQL.append(" ELSE t1.ftargetcompanyid || '!' || t1.fcompanyid END As frelation ");
                sbSQL.append(" From t_csl_InterItemData t1, t_csl_RptReceived t2 ");
                sbSQL.append(" WHERE t1.FPeriodType = ").append(param.get("periodType"));
                sbSQL.append(" AND t1.FYear = ").append(param.get("year"));
                sbSQL.append(" AND t1.FPeriod = ").append(param.get("period"));
                sbSQL.append(" AND t2.FOrgTreeId = '").append(param.get("orgTreeId")).append("'");
                return DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }

    @Override
    protected IRowSet _getCheckageRecord(Context ctx, String checkageId, ElimTypeEnum elimType) throws BOSException, EASBizException {
        StringBuffer sbSQL = new StringBuffer();
        CommonTable common = new CommonTable(elimType);
        sbSQL.append(" select top 1 t1.ftempletid,t2.fcompanyid,t2.ftargetcompanyid,t1.fisOldData \r\n");
        sbSQL.append(" from ").append(common.getMasterTable()).append(" t1,").append(common.getEntryTable()).append(" t2 \r\n");
        sbSQL.append(" where t1.fid=t2.fcheckageid \r\n");
        sbSQL.append(" and t1.fid= ? ");
        String templateId = null;
        String companyId = null;
        String targetCompanyId = null;
        boolean isOldData = true;
        IRowSet rsTemp = null;
        try {
            rsTemp = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])new Object[]{checkageId});
            while (rsTemp.next()) {
                templateId = rsTemp.getString("ftempletId");
                companyId = rsTemp.getString("fcompanyid");
                targetCompanyId = rsTemp.getString("ftargetcompanyId");
                isOldData = rsTemp.getBoolean("fisOldData");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (isOldData) {
            return this.getCheckageOldDataRecord(ctx, checkageId, elimType, companyId, targetCompanyId, templateId, common);
        }
        return this.getCheckageNewDataRecord(ctx, checkageId, elimType, companyId, targetCompanyId, templateId, common);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRowSet getCheckageNewDataRecord(Context ctx, String checkageId, ElimTypeEnum elimType, String companyId, String targetCompanyId, String templateId, CommonTable common) throws BOSException, EASBizException {
        String sql = this.getCheckageRecordSQL(ctx, checkageId, elimType, companyId, targetCompanyId, templateId, common);
        String tmplTbl = null;
        try {
            tmplTbl = this.createTmplTable(ctx);
            StringBuffer insertSql = new StringBuffer();
            insertSql.append(" INSERT INTO ").append(tmplTbl).append(sql);
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
            StringBuffer query = new StringBuffer();
            query.append(" select * from ( \n");
            query.append("select own.* from ").append(tmplTbl).append(" own \n");
            query.append(" inner join ").append(tmplTbl).append(" has on has.fcompanyid=own.fcompanyid and has.fdc=own.fdc \n");
            query.append(" where has.fid is not null \n");
            query.append(" union ");
            query.append("select own.* from ").append(tmplTbl).append(" own \n");
            query.append(" inner join ").append(tmplTbl).append(" has on has.fcompanyid=own.FTargetCompanyId and (has.fdc=1 and own.fdc=0 or has.fdc=0 and own.fdc=1) \n");
            query.append(" where has.fid is not null \n");
            query.append(" ) record order by record.fcompanyid,record.ftemplateSeq ");
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)query.toString());
            return iRowSet;
        }
        finally {
            if (!StringUtils.isEmpty((String)tmplTbl)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tmplTbl);
            }
        }
    }

    private IRowSet getCheckageOldDataRecord(Context ctx, String checkageId, ElimTypeEnum elimType, String companyId, String targetCompanyId, String templateId, CommonTable common) throws BOSException, EASBizException {
        String sql = this.getCheckageRecordSQL(ctx, checkageId, elimType, companyId, targetCompanyId, templateId, common);
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    private String createTmplTable(Context ctx) throws BOSException {
        String tableName;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            tableName = pool.createTempTable(this.getCreateTblSql());
            pool.createIndex(tableName, "FItemNumber,FdataElement,FCompanyID,FTargetCompanyId", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    private String getCreateTblSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE T_CSL_INTERCHECKAGETMPL(FId VARCHAR(44),FNumber NVARCHAR(100),FDescription NVARCHAR(500),").append("FCurrencyId VARCHAR(44),FDiffValue NUMERIC(21,6),fconfirmdiffval NUMERIC(21,6),FDiffMode INT,").append("FCheckedStatus INT,FSingleDC INT,FEntryId VARCHAR(44),").append("FSeq INT,FItemId VARCHAR(44),FCOMPANYID VARCHAR(44),").append("FTARGETCOMPANYID VARCHAR(44),FCOMPANYNAME NVARCHAR(100),").append("FTARGETCOMPANYNAME NVARCHAR(100),FITEMNAME NVARCHAR(100),").append("FITEMNUMBER NVARCHAR(100),FDATAELEMENT INT,").append("FDEBIT NUMERIC(21,6),FCREDIT NUMERIC(21,6),fbeforeadjustdata NUMERIC(21,6),fadjustdata NUMERIC(21,6),").append("FVALIDEBIT NUMERIC(21,6),FVALICREDIT NUMERIC(21,6),").append("FDC INT,FDATASRCTYPE INT,FCheckageParty INT,FtemplateSeq int)");
        return sql.toString();
    }

    private String getCheckageRecordSQL(Context ctx, String checkageId, ElimTypeEnum elimType, String companyId, String targetCompanyId, String templateId, CommonTable common) throws BOSException, EASBizException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" select b.FId,b.FNumber,b.FDescription,b.FCurrencyId,b.FDiffValue,b.fconfirmdiffval,b.FDiffMode,b.FCheckedStatus,b.FSingleDC, \r\n");
        sbSQL.append(" b.FEntryId,b.FSeq,b.FItemId,c.FId as FCompanyId,d.FId as FTargetCompanyId,c.FName_" + ctx.getLocale() + " As FCompanyName, \r\n");
        sbSQL.append(" d.FName_" + ctx.getLocale() + " as FTargetCompanyName,e.FName_" + ctx.getLocale() + " As FItemName,e.FNumber as FItemNumber, \r\n");
        sbSQL.append(" a.fdataelement as fdataelement,  ");
        sbSQL.append(" Isnull(b.FDebit,0) As FDebit,Isnull(b.FCredit,0) As FCredit, Isnull(b.fbeforeadjustdata,0) As fbeforeadjustdata,Isnull(b.fadjustdata,0) As fadjustdata,\r\n");
        sbSQL.append(" Isnull(b.FValiDebit,0) As FValiDebit,IsNull(b.FValiCredit,0) As FValiCredit, \r\n");
        sbSQL.append(" a.FDC,a.fdatasrctype as fdatasrctype,a.FCheckageParty,a.FSEQ FtemplateSeq \r\n");
        sbSQL.append(" From \r\n");
        sbSQL.append(" ( \r\n");
        sbSQL.append(" select t2.FSEQ, t1.FId,t2.FItemId, t2.fdataelement,").append(" '").append(companyId).append("' As FCompanyId,t1.FCHECKAGEPARTY, \r\n");
        sbSQL.append(" '").append(targetCompanyId).append("' As FTargetCompanyId, t2.FDC,t2.fdatasrctype as fdatasrctype \r\n");
        sbSQL.append(" from t_csl_elimtemplet t1,t_csl_elimtempletentry t2 \r\n");
        sbSQL.append(" where t1.fid=t2.ftempletid And t1.fid = '").append(templateId).append("' \r\n");
        if (targetCompanyId.equals(companyId)) {
            sbSQL.append(" Union \r\n");
        } else {
            sbSQL.append(" Union all \r\n");
        }
        sbSQL.append(" select t2.FSEQ, t1.FId,t2.FItemId, t2.fdataelement,").append(" '").append(targetCompanyId).append("' As FCompanyId,t1.FCHECKAGEPARTY, \r\n");
        sbSQL.append(" '").append(companyId).append("' As FTargetCompanyId, t2.FDC,t2.fdatasrctype as fdatasrctype \r\n");
        sbSQL.append(" from t_csl_elimtemplet t1,t_csl_elimtempletentry t2 \r\n");
        sbSQL.append(" where t1.fid=t2.ftempletid And t1.fid = '").append(templateId).append("' \r\n");
        sbSQL.append(" ) a left Join \r\n");
        sbSQL.append(" ( \r\n");
        sbSQL.append(" select t1.FID,t1.FNumber,t1.FDescription,1.FCurrencyId,FYear,FPeriod,FDay,FOrgBoundId,FDiffValue,t1.fconfirmdiffval,FDiffMode,FCheckedStatus,FSingleDC, \r\n");
        sbSQL.append(" t2.fid as fentryid,t2.FSeq,t2.FItemID, t2.FCompanyId,t2.FTargetCompanyId,t2.FDebit,t2.FCredit, t2.fbeforeadjustdata,t2.fadjustdata,\r\n");
        sbSQL.append(" t2.fdataelement,  ");
        sbSQL.append(" t2.FValiDebit,t2.FValiCredit \r\n");
        sbSQL.append(" from ").append(common.getMasterTable()).append(" t1,").append(common.getEntryTable()).append(" t2 \r\n");
        sbSQL.append(" Where t1.fid=t2.fcheckageid And t1.fid = '").append(checkageId).append("' \r\n");
        sbSQL.append(" ) b ON a.FCompanyId=b.FCompanyId \r\n");
        sbSQL.append(" And a.FTargetCompanyId=b.FTargetCompanyId \r\n");
        sbSQL.append(" And a.FItemId=b.FItemId \r\n");
        sbSQL.append(" And a.fdataelement=b.fdataelement  ");
        sbSQL.append(" inner Join T_Org_baseunit c on a.FCompanyId=c.FId \r\n");
        sbSQL.append(" inner Join T_Org_baseunit d on a.FTargetCompanyId=d.FId \r\n");
        sbSQL.append(" inner Join T_Csl_RptItem e on a.FItemId=e.FId \r\n");
        sbSQL.append(" Order by IsNull(a.FCompanyID,'Z') asc, a.FSEQ asc \r\n");
        return sbSQL.toString();
    }

    @Override
    protected boolean _saveCheckageRecord(Context ctx, Map checkageMap, ElimTypeEnum elimType) throws BOSException, EASBizException {
        Set entries;
        BigDecimal validDebitTotal = new BigDecimal("0");
        BigDecimal validCreditTotal = new BigDecimal("0");
        if (checkageMap != null && !checkageMap.isEmpty() && (entries = (Set)checkageMap.get("entries")) != null && !entries.isEmpty()) {
            StringBuffer errorMsg = new StringBuffer();
            BigDecimal validDebitAmt = null;
            BigDecimal validCreditAmt = null;
            boolean validDebitAmtGreaterZero = false;
            boolean validCreditAmtGreaterZero = false;
            for (Map rowMap : entries) {
                validDebitAmt = (BigDecimal)rowMap.get("valiDebit");
                validCreditAmt = (BigDecimal)rowMap.get("valiCredit");
                validDebitTotal = validDebitTotal.add(validDebitAmt == null ? new BigDecimal("0") : validDebitAmt);
                validCreditTotal = validCreditTotal.add(validCreditAmt == null ? new BigDecimal("0") : validCreditAmt);
                validDebitAmtGreaterZero = validDebitAmt != null && validDebitAmt.signum() != 0;
                boolean bl = validCreditAmtGreaterZero = validCreditAmt != null && validCreditAmt.signum() != 0;
                if (!validDebitAmtGreaterZero || !validCreditAmtGreaterZero || validDebitAmt.compareTo(validCreditAmt) != 0) continue;
                errorMsg.append("companyid='").append(rowMap.get("companyid")).append("'");
                errorMsg.append(" targetcompanyid='").append(rowMap.get("targetcompanyid")).append("'");
                errorMsg.append(" itemnumber='").append(rowMap.get("itemnumber")).append("'");
                errorMsg.append(" dataelement='").append(rowMap.get("dataelement")).append("'");
                throw new InterCheckException(InterCheckException.VDEBIT_VCREDIT_GREATER_ZERO_S, new Object[]{errorMsg.toString()});
            }
        }
        BigDecimal confirmDiff = validDebitTotal.subtract(validCreditTotal);
        CommonTable common = new CommonTable(elimType);
        Connection conn = null;
        Statement st = null;
        StringBuffer sbSQL = null;
        Map entry = null;
        Date d = new Date();
        Timestamp time = new Timestamp(d.getTime());
        boolean isByCompany = checkageMap.containsKey("isByCompany") ? (Boolean)checkageMap.get("isByCompany") : false;
        try {
            conn = super.getConnection(ctx);
            st = conn.createStatement();
            StringBuffer sb = new StringBuffer();
            sb.append("select fid from ").append(common.getEntryTable()).append(" where fcompanyid = ? ").append(" and ftargetcompanyid = ? ").append(" and fitemid = ? ").append(" and fcheckageid = ? ");
            sb.append(" and fdataelement = ? ");
            String description = (String)checkageMap.get("description");
            if (description.length() > 200) {
                description = description.substring(0, 200);
            }
            StringBuffer masterSQL = new StringBuffer();
            masterSQL.append(" update ").append(common.getMasterTable()).append(" set FDescription = '").append(description).append(" ' \r\n").append(" ,FConfirmDiffVal = " + CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)confirmDiff)).append(" ,FDiffMode = ").append(((DiffModeEnum)((Object)checkageMap.get("diffmode"))).getValue()).append(", \r\n");
            if (!isByCompany || StringUtils.isEmpty((String)((String)checkageMap.get("checkedParty")))) {
                masterSQL.append(" FCheckedStatus = 2,  \r\n").append(" FAuditorId = '").append(ctx.getCaller()).append("', \r\n").append(" FAuditDate = TimeStamp'").append(time.toString()).append("' \r\n");
            } else {
                masterSQL.append(" FCheckedStatus = 0,  \r\n").append(" FAssessorId = '").append(ctx.getCaller()).append("', \r\n").append(" FAssessDate = TimeStamp'").append(time.toString()).append("' \r\n");
            }
            masterSQL.append(" where fid = '" + checkageMap.get("id") + "' \r\n");
            st.addBatch(masterSQL.toString());
            HashSet col = (HashSet)checkageMap.get("entries");
            Iterator it = col.iterator();
            if (elimType == ElimTypeEnum.ComeAndGo || elimType == ElimTypeEnum.exchange) {
                DbUtil.execute((Context)ctx, (String)("Delete " + common.getEntryTable() + " Where FCheckageId = '" + checkageMap.get("id") + "' and (fbeforeadjustdata is null or fbeforeadjustdata = 0)  and (fadjustdata is null or fadjustdata = 0)"));
            } else {
                DbUtil.execute((Context)ctx, (String)("Delete " + common.getEntryTable() + " Where FCheckageId = '" + checkageMap.get("id") + "'"));
            }
            int seq = 0;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select max(fseq) from " + common.getEntryTable() + " Where FCheckageId = '" + checkageMap.get("id") + "'"));
            if (rs.next()) {
                seq = rs.getInt(1);
            }
            IRowSet existRs = DbUtil.executeQuery((Context)ctx, (String)("select * from " + common.getEntryTable() + " Where FCheckageId = '" + checkageMap.get("id") + "'"));
            HashSet<String> existList = new HashSet<String>();
            StringBuffer exist = null;
            while (existRs.next()) {
                exist = new StringBuffer();
                exist.append(existRs.getString("FItemId")).append(existRs.getString("FCompanyId")).append(existRs.getString("FTargetCompanyId")).append(existRs.getInt("fdataelement"));
                existList.add(exist.toString());
            }
            while (it.hasNext()) {
                entry = (Map)it.next();
                String itemId = this.getItemIdByNumber(ctx, (String)entry.get("itemnumber"));
                exist = new StringBuffer();
                exist.append(itemId).append(entry.get("companyid")).append(entry.get("targetcompanyid")).append(((Integer)entry.get("dataelement")).toString());
                if (existList.contains(exist.toString())) {
                    sbSQL = new StringBuffer();
                    sbSQL.append(" update ").append(common.getEntryTable());
                    sbSQL.append(" set FDebit=").append(CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)(entry.get("debit") == null ? new BigDecimal("0") : entry.get("debit")))).append(" \r\n");
                    sbSQL.append(", FCredit=").append(CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)(entry.get("credit") == null ? new BigDecimal("0") : entry.get("credit")))).append(" \r\n");
                    sbSQL.append(", FValiDebit=").append(CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)(entry.get("valiDebit") == null ? new BigDecimal("0") : entry.get("valiDebit")))).append(" \r\n");
                    sbSQL.append(", FValiCredit=").append(CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)(entry.get("valiCredit") == null ? new BigDecimal("0") : entry.get("valiCredit")))).append(" \r\n");
                    sbSQL.append(" where FCheckageId = '").append(checkageMap.get("id")).append("' \r\n");
                    sbSQL.append(" and FItemId = '").append(itemId).append("' \r\n");
                    sbSQL.append(" and FCompanyId = '").append(entry.get("companyid")).append("' \r\n");
                    sbSQL.append(" and FTargetCompanyId = '").append(entry.get("targetcompanyid")).append("' \r\n");
                    sbSQL.append(" and fdataelement = ").append((Integer)entry.get("dataelement")).append(" \r\n");
                    st.addBatch(sbSQL.toString());
                    continue;
                }
                this.insertNotExist(ctx, st, ++seq, entry, common.getEntryTable(), checkageMap.get("id").toString(), itemId);
            }
            st.executeBatch();
            st.clearBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
        return true;
    }

    private void insertNotExist(Context ctx, Statement st, int seq, Map entry, String entryTable, String checkageId, String itemId) throws SQLException, BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" insert into ").append(entryTable);
        sbSQL.append(" (FID,FSeq,FItemId,FCompanyId,FTargetCompanyId,fdataelement, FDebit,FCredit,FValiDebit,FValiCredit,FCheckageId) \r\n");
        sbSQL.append(" values(newbosid('").append(CHECK_ENTRY_BOSTYPE).append("'),");
        sbSQL.append(seq).append(",");
        sbSQL.append(" '").append(itemId).append("', \r\n");
        sbSQL.append(" '").append(entry.get("companyid")).append("', \r\n");
        sbSQL.append(" '").append(entry.get("targetcompanyid")).append("', \r\n");
        sbSQL.append(" ").append((Integer)entry.get("dataelement")).append(", \r\n");
        sbSQL.append(CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)(entry.get("debit") == null ? new BigDecimal("0") : entry.get("debit")))).append(", \r\n");
        sbSQL.append(CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)(entry.get("credit") == null ? new BigDecimal("0") : entry.get("credit")))).append(", \r\n");
        sbSQL.append(CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)(entry.get("valiDebit") == null ? new BigDecimal("0") : entry.get("valiDebit")))).append(", \r\n");
        sbSQL.append(CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)(entry.get("valiCredit") == null ? new BigDecimal("0") : entry.get("valiCredit")))).append(", \r\n");
        sbSQL.append(" '").append(checkageId).append("') \r\n");
        st.addBatch(sbSQL.toString());
    }

    private String getItemIdByNumber(Context ctx, String number) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fid from t_csl_rptitem where fnumber = ? ", (Object[])new Object[]{number});
        String itemid = null;
        try {
            if (rs.next()) {
                itemid = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return itemid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _checkDataNew(Context ctx, Map param) throws BOSException, EASBizException {
        Uuid requestId = null;
        try {
            requestId = this.requestLock(ctx, param);
            checkageManager manager = new checkageManager(ctx, param);
            manager.deleteCheckData();
            manager.buildCheckage();
            manager.executeInsert();
            manager.updateItemDataTable(param);
            this.insertCheckLog(ctx, param);
        }
        finally {
            if (requestId != null) {
                CslRptUtil.releaseCheckControlLock(ctx, requestId);
            }
        }
    }

    protected void insertCheckLog(Context ctx, Map param) throws BOSException, EASBizException {
        try {
            boolean isByCompany = (Boolean)param.get("isByCompany");
            String orgUnitId = (String)(isByCompany ? param.get("companyId") : param.get("orgUnitId"));
            int periodType = (Integer)param.get("periodType");
            int year = (Integer)param.get("year");
            int period = (Integer)param.get("period");
            ElimTypeEnum elimType = (ElimTypeEnum)((Object)param.get("elimType"));
            SQLBuilder sql = new SQLBuilder();
            sql.append("select fid from T_Csl_InterExchCheckLog where FYear=? ", (Object)year);
            sql.append(" and FPeriod=?", (Object)period).append(" and FPeriodType=? ", (Object)periodType);
            sql.append(" and FElimType=? ", (Object)elimType.getValue()).append(" and FOrgUnitId=? ", (Object)orgUnitId);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
            String fid = null;
            if (rowSet != null && rowSet.next()) {
                fid = rowSet.getString("fid");
            }
            sql.reset();
            Timestamp createTime = new Timestamp(System.currentTimeMillis());
            Object[] params = null;
            if (!StringUtils.isEmpty((String)fid)) {
                sql.append(" update T_Csl_InterExchCheckLog set FCreateTime=? ", (Object)createTime);
                sql.append(" where fid=? ", (Object)fid);
                params = sql.getParams();
            } else {
                sql.append(" insert into T_Csl_InterExchCheckLog(FID,FOrgUnitId,FElimType,FPeriodType,FYear,FPeriod,FCreatorId,FCreateTime) values (?,?,?,?,?,?,?,?)");
                params = new Object[]{Uuid.create().toString(), orgUnitId, elimType.getValue(), periodType, year, period, ctx.getCaller().toString(), createTime};
            }
            DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])params);
        }
        catch (Exception e) {
            logger.error((Object)"insertCheckLog error", (Throwable)e);
            throw new BOSException("insertCheckLog error", (Throwable)e);
        }
    }

    protected Uuid requestLock(Context ctx, Map param) throws BOSException, EASBizException {
        boolean isByCompany = (Boolean)param.get("isByCompany");
        Uuid requestId = Uuid.create();
        String orgTreeId = (String)param.get("orgTreeId");
        String orgUnitId = (String)(isByCompany ? param.get("companyId") : param.get("orgUnitId"));
        ElimTypeEnum elimType = (ElimTypeEnum)((Object)param.get("elimType"));
        if (elimType != null) {
            SelectorItemCollection itemCol = new SelectorItemCollection();
            itemCol.add("name");
            OrgTreeInfo orgTree = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orgTreeId)), itemCol);
            FullOrgUnitInfo orgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orgUnitId)), itemCol);
            String mutexName = (isByCompany ? "" : orgTreeId + "!") + orgUnitId + "!" + elimType.getValue();
            MutexParameter mutexParam = new MutexParameter();
            mutexParam.setRequestId(requestId);
            String actionName = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"940isChecking", (Locale)ctx.getLocale(), (Object[])new Object[]{ctx.getUserName(), orgTree != null ? orgTree.getName() : "", orgUnit != null ? orgUnit.getName() : "null", elimType.getAlias()});
            mutexParam.setActionName(actionName);
            mutexParam.setMutexName(mutexName);
            mutexParam.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
            mutexParam.setUserID(BOSUuid.read((String)ctx.getCaller().toString()));
            IMutexServiceControl imc = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            MutexParameter mutex = imc.requestMutex3(mutexParam);
            if (mutex == null) {
                return requestId;
            }
            actionName = mutex.getActionName();
            if (!StringUtils.isEmpty((String)actionName)) {
                throw new InterCheckException(InterCheckException.ISLOCKED, new Object[]{actionName});
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _isReceiveReport(Context ctx, Map param, ArrayList checkIDList) throws BOSException, EASBizException {
        boolean isByCompany = false;
        if (param.containsKey("isByCompany")) {
            isByCompany = (Boolean)param.get("isByCompany");
        }
        ArrayList<Object> errorList = new ArrayList<Object>();
        StringBuffer sb = new StringBuffer();
        String strIDs = this.getCheckageIDCollection(checkIDList);
        ArrayList<String> tmpTbls = new ArrayList<String>();
        try {
            Statement st;
            Connection conn;
            block16: {
                CommonTable common = new CommonTable((ElimTypeEnum)((Object)param.get("elimType")));
                String idsTmp = InterExchReportValChgChecker.getCheckageIds(ctx, common, tmpTbls, null, strIDs);
                String checkagesTmp = InterExchReportValChgChecker.buildExistCheckagesByTemplate(ctx, idsTmp, common, tmpTbls);
                sb.append(" select distinct e.fnumber fnumber,b.fid fid,a.FCommitStatus FCommitStatus , \n\r");
                sb.append(" rpt.Fname rptName,company.Fname_").append(ctx.getLocale()).append(" compName \n");
                sb.append(" FROM ").append(checkagesTmp).append(" b  \r\n");
                sb.append(" INNER JOIN T_CSL_RptItem d ON d.FId=b.FItemId \n\r");
                sb.append(" INNER JOIN ").append(this.getItemDataTableName(param)).append(" a ON d.FNumber = a.FItemNumber And b.fdataelement = a.fdataelement ");
                sb.append("   AND b.FCurrencyID = a.FTargetCurrencyID AND b.FCompanyID = a.FCompanyID AND b.FTargetCompanyID = a.FTargetCompanyID \r\n");
                sb.append(" INNER JOIN T_CSL_CslReport rpt ON rpt.FID = a.FReport \n");
                sb.append(" INNER JOIN t_csl_rptreceived received ON rpt.FID = received.FReportid \n");
                sb.append(" INNER JOIN T_ORG_BASEUNIT company ON company.FID = a.FCompanyID  \n");
                sb.append(" INNER JOIN ").append(this.getMasterTableName(param)).append(" e on e.fid=b.fid \n");
                sb.append(" WHERE a.FMoney<>0    \n\r");
                sb.append(" And received.FORGTREEID = '").append(param.get("orgTreeId")).append("' \n\r");
                sb.append(" And a.FYear = ").append(param.get("year"));
                sb.append(" And a.FPeriod = ").append(param.get("period"));
                sb.append(" And a.FPeriodtype = ").append(param.get("periodType"));
                sb.append(" And rpt.fsourcetype not in (100,32,35) ");
                if (isByCompany) {
                    if (param.get("targetCompanyId") == null) {
                        sb.append(" And (b.FCompanyId='").append(param.get("companyId")).append("' or b.FTargetCompanyId='").append(param.get("companyId")).append("') \n\r");
                    } else {
                        sb.append(" And ((b.FCompanyId='").append(param.get("companyId")).append("' and b.FTargetCompanyId='").append(param.get("targetCompanyId")).append("')");
                        sb.append(" or (b.FCompanyId='").append(param.get("targetCompanyId")).append("' and b.FTargetCompanyId='").append(param.get("companyId")).append("')) \n\r");
                    }
                }
                sb.append(" And e.fid in ").append(strIDs);
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                conn = null;
                st = null;
                HashSet<String> key = new HashSet<String>();
                StringBuffer errorMsg = new StringBuffer();
                try {
                    conn = this.getConnection(ctx);
                    st = conn.createStatement();
                    int findCount = 0;
                    while (rs.next()) {
                        String id = rs.getString("fid");
                        String commitStatus = rs.getString("FCommitStatus");
                        if (commitStatus.equals("3")) continue;
                        String message = rs.getString("compName") + "  " + rs.getString("rptName");
                        if (!key.contains(message)) {
                            key.add(message);
                            errorMsg.append(message + "\n");
                        }
                        ++findCount;
                    }
                    if (findCount > 0) {
                        errorList.add(errorMsg.toString());
                    }
                    if (!param.containsKey("unAuditOprt") || findCount != errorList.size()) break block16;
                    errorList.add(true);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(st, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)st, (Connection)conn);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tmpTbls != null && !tmpTbls.isEmpty() && !DebugLogger.isDebug) {
                TempTablePool tablePool = TempTablePool.getInstance((Context)ctx);
                for (String tmpTbl : tmpTbls) {
                    tablePool.releaseTable(tmpTbl);
                }
            }
        }
        return errorList;
    }

    private String getMasterTableName(Map param) {
        String table = param.get("elimType").equals((Object)ElimTypeEnum.ComeAndGo) ? "T_CSL_InterDataCheckage" : "T_CSL_ExchCheckage";
        return table;
    }

    private String getItemDataTableName(Map param) {
        String table = param.get("elimType").equals((Object)ElimTypeEnum.ComeAndGo) ? "T_CSL_InterItemData" : "T_CSL_ExchItemData";
        return table;
    }

    private String getEntriesTableName(Map param) {
        String table = param.get("elimType").equals((Object)ElimTypeEnum.ComeAndGo) ? "T_CSL_DataCheckageEntry" : "T_CSL_ExchCheckageEntry";
        return table;
    }

    @Override
    protected Map _batchDiffHandle(Context ctx, List lstIds, ElimTypeEnum elimType, DiffModeEnum diffMode) throws BOSException, EASBizException {
        if (lstIds == null || lstIds.size() == 0) {
            return null;
        }
        Checkage[] checkages = this.getCheckageArrs(ctx, lstIds, elimType, diffMode);
        this.diffHandleProcess(checkages);
        this.batchSaveCheckageRecords(ctx, checkages, elimType, lstIds);
        HashMap<String, Integer> result = new HashMap<String, Integer>(2);
        result.put("success_count", new Integer(new HashSet(lstIds).size()));
        return result;
    }

    private void batchSaveCheckageRecords(Context ctx, Checkage[] checkages, ElimTypeEnum elimType, List lstIds) throws BOSException, EASBizException {
        if (checkages == null || checkages.length == 0) {
            return;
        }
        CommonTable common = new CommonTable(elimType);
        Connection conn = null;
        Statement st = null;
        conn = super.getConnection(ctx);
        Date d = new Date();
        Timestamp time = new Timestamp(d.getTime());
        try {
            st = conn.createStatement();
            Checkage checkage2 = null;
            for (Checkage checkage2 : checkages) {
                this.addBatchRecordsHeadSql(st, common, checkage2, ctx.getCaller().toString(), time);
                this.addBatchRecordsEntrySql(ctx, st, common, checkage2);
            }
            st.executeBatch();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)st, (Connection)conn);
        }
    }

    private void addBatchRecordsHeadSql(Statement st, CommonTable common, Checkage checkage, String auditorId, Timestamp time) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(common.getMasterTable()).append(" set FDiffMode = ").append(checkage.getDiffMode());
        if (checkage.getValiCreditTotal() != null && checkage.getValiDebitTotal() != null) {
            sql.append(",FCONFIRMDIFFVAL=").append(checkage.getValiDebitTotal().subtract(checkage.getValiCreditTotal()));
        }
        sql.append(" where fid = '" + checkage.getId()).append("'");
        st.addBatch(sql.toString());
    }

    private void addBatchRecordsEntrySql(Context ctx, Statement st, CommonTable common, Checkage checkage) throws SQLException, BOSException {
        List entries = checkage.getEntries();
        Map entry2 = null;
        int seq = 1;
        Connection conn = null;
        Statement delst = null;
        boolean isZeroDebitOrCreditTotal = CslConstant.BGZERO.compareTo(checkage.getDebitTotal()) == 0 || CslConstant.BGZERO.compareTo(checkage.getCreditTotal()) == 0;
        StringBuffer delSQL = new StringBuffer();
        try {
            conn = this.getConnection(ctx);
            delst = conn.createStatement();
            delst.addBatch(this.getRecordsEntryDelSql(ctx, entry2, common.getEntryTable(), checkage));
            for (Map entry2 : entries) {
                st.addBatch(this.getRecordsEntrySql(ctx, entry2, common.getEntryTable(), seq, checkage));
                ++seq;
            }
            if (entries.size() > 0) {
                delst.executeBatch();
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(delst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)delst, (Connection)conn);
    }

    private String getRecordsEntryDelSql(Context ctx, Map entry, String entryTable, Checkage checkage) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" delete from ").append(entryTable);
        sbSQL.append(" where FCheckageId = '").append(checkage.getId()).append("' \r\n");
        return sbSQL.toString();
    }

    private String getRecordsEntrySql(Context ctx, Map entry, String entryTable, int seq, Checkage checkage) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" insert into  ").append(entryTable);
        sbSQL.append(" (Fid,FSeq,FBeforeAdjustData,FAdjustData,FDebit,FCredit,FValiDebit,FValiCredit,FCheckageId,FItemId,FCompanyId,FTargetCompanyId,fdataelement) values (");
        sbSQL.append(" '").append(new ObjectUuidPK(new BOSObjectType(CHECK_ENTRY_BOSTYPE)).toString()).append("' \r\n");
        sbSQL.append(", '").append(seq).append("' \r\n");
        BigDecimal debit = entry.get("debit") == null ? new BigDecimal("0") : entry.get("debit");
        BigDecimal credit = entry.get("credit") == null ? new BigDecimal("0") : entry.get("credit");
        sbSQL.append(", ").append(CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)(entry.get("beforeAdjustData") == null ? new BigDecimal("0") : entry.get("beforeAdjustData")))).append(" \r\n");
        sbSQL.append(", ").append(CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)(entry.get("adjustData") == null ? new BigDecimal("0") : entry.get("adjustData")))).append(" \r\n");
        sbSQL.append(", ").append(CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)debit)).append(" \r\n");
        sbSQL.append(", ").append(CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)credit)).append(" \r\n");
        sbSQL.append(", ").append(CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)(entry.get("validebit") == null ? new BigDecimal("0") : entry.get("validebit")))).append(" \r\n");
        sbSQL.append(", ").append(CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)(entry.get("valicredit") == null ? new BigDecimal("0") : entry.get("valicredit")))).append(" \r\n");
        sbSQL.append(", '").append(checkage.getId()).append("' \r\n");
        sbSQL.append(", '").append(this.fixedItemDataID(ctx, entry)).append("' \r\n");
        sbSQL.append(", '").append(entry.get("companyid")).append("' \r\n");
        sbSQL.append(", '").append(entry.get("targetcompanyid")).append("' \r\n");
        sbSQL.append(", ").append((Integer)entry.get("dataelement")).append(" \r\n");
        sbSQL.append(")");
        return sbSQL.toString();
    }

    private String fixedItemDataID(Context ctx, Map entry) throws BOSException {
        String itemId = (String)entry.get("itemid");
        if (StringUtils.isEmpty((String)itemId)) {
            String number = (String)entry.get("itemnumber");
            itemId = this.getItemIdByNumber(ctx, number);
        }
        return itemId;
    }

    private boolean isCanInsert2DB(Map entry, boolean isZeroDebitOrCredit) {
        BigDecimal debit = (BigDecimal)entry.get("debit");
        BigDecimal credit = (BigDecimal)entry.get("credit");
        BigDecimal validebit = (BigDecimal)entry.get("validebit");
        BigDecimal valicredit = (BigDecimal)entry.get("valicredit");
        boolean isZeroDebit = debit == null || debit.compareTo(CslConstant.BGZERO) == 0;
        boolean isZeroCredit = credit == null || credit.compareTo(CslConstant.BGZERO) == 0;
        boolean isZeroValiDebit = validebit == null || validebit.compareTo(CslConstant.BGZERO) == 0;
        boolean isZeroValiCredit = valicredit == null || valicredit.compareTo(CslConstant.BGZERO) == 0;
        return !isZeroDebit || !isZeroCredit || !isZeroValiDebit || !isZeroValiCredit || isZeroDebitOrCredit;
    }

    private void diffHandleProcess(Checkage[] checkages) {
        if (checkages == null || checkages.length == 0) {
            return;
        }
        int len = checkages.length;
        for (int i = 0; i < len; ++i) {
            DiffHandleStrategy strategy = new DiffHandleStrategy(checkages[i].getDiffMode(), checkages[i]);
            strategy.execute();
        }
    }

    private Checkage[] getCheckageArrs(Context ctx, List lstIds, ElimTypeEnum elimType, DiffModeEnum diffMode) throws BOSException, EASBizException {
        HashSet setIds = new HashSet(lstIds);
        String checkageId2 = "";
        IRowSet rowSet = null;
        ArrayList<Checkage> lstCheckage = new ArrayList<Checkage>();
        CoreBaseCollection cbaseColl = null;
        for (String checkageId2 : setIds) {
            cbaseColl = this.getItemMapByCheckageId(ctx, checkageId2, elimType);
            rowSet = this._getCheckageRecord(ctx, checkageId2, elimType);
            lstCheckage.add(this.wrapRowSet2CheckageObj(rowSet, diffMode, checkageId2, cbaseColl));
        }
        Checkage[] checkages = new Checkage[lstCheckage.size()];
        lstCheckage.toArray(checkages);
        return checkages;
    }

    private Checkage wrapRowSet2CheckageObj(IRowSet iRowSet, DiffModeEnum diffMode, String checkageId, CoreBaseCollection cbaseColl) throws BOSException, EASBizException {
        ArrayList entries = new ArrayList();
        int index = 0;
        BigDecimal debitTotal = CslConstant.BGZERO;
        BigDecimal creditTotal = CslConstant.BGZERO;
        BigDecimal diffValue = CslConstant.BGZERO;
        int singleDC = 0;
        int checkedParty = 0;
        boolean isSameCompany = false;
        try {
            iRowSet.beforeFirst();
            while (iRowSet.next()) {
                ++index;
                HashMap<String, Object> entry = new HashMap<String, Object>();
                entry.put("itemnumber", iRowSet.getString("FItemNumber"));
                entry.put("itemid", iRowSet.getString("FItemId"));
                entry.put("dc", new Integer(iRowSet.getInt("FDC")));
                entry.put("dataSrcType", new Integer(iRowSet.getInt("fdatasrctype")));
                int isIncludeDiffItem = iRowSet.getInt("fdatasrctype") == 1 ? 0 : 1;
                entry.put("isIncludeDiffItem", new Integer(isIncludeDiffItem));
                entry.put("debit", this.sugarAmount(iRowSet.getBigDecimal("FDebit")));
                entry.put("credit", this.sugarAmount(iRowSet.getBigDecimal("FCredit")));
                entry.put("validebit", this.sugarAmount(iRowSet.getBigDecimal("FDebit")));
                entry.put("valicredit", this.sugarAmount(iRowSet.getBigDecimal("FCredit")));
                entry.put("beforeAdjustData", this.sugarAmount(iRowSet.getBigDecimal("fbeforeAdjustData")));
                entry.put("adjustData", this.sugarAmount(iRowSet.getBigDecimal("fadjustData")));
                entry.put("companyid", iRowSet.getString("FCompanyId"));
                entry.put("targetcompanyid", iRowSet.getString("FTargetCompanyId"));
                entry.put("dataelement", new Integer(iRowSet.getInt("fdataelement")));
                entry.put("seq", new Integer(index));
                debitTotal = debitTotal.add(this.sugarAmount(iRowSet.getBigDecimal("FDebit")));
                creditTotal = creditTotal.add(this.sugarAmount(iRowSet.getBigDecimal("FCredit")));
                singleDC = iRowSet.getInt("FSingleDC");
                checkedParty = iRowSet.getInt("FCheckageParty");
                if (iRowSet.getString("FCompanyId").equals(iRowSet.getString("FTargetCompanyId"))) {
                    isSameCompany = true;
                }
                entries.add(entry);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        diffValue = debitTotal.subtract(creditTotal);
        Checkage checkage = new Checkage();
        checkage.setDebitTotal(debitTotal);
        checkage.setCreditTotal(creditTotal);
        checkage.setDiffValue(diffValue);
        checkage.setAbsDiffValue(diffValue.abs());
        checkage.setEntries(entries);
        checkage.setDiffMode(diffMode.getValue());
        checkage.setId(checkageId);
        checkage.setCbaseColl(cbaseColl);
        checkage.setSingleDC(singleDC);
        checkage.setCheckedParty(checkedParty);
        checkage.setSameCompany(isSameCompany);
        return checkage;
    }

    private BigDecimal sugarAmount(BigDecimal amount) {
        if (amount == null) {
            return CslConstant.BGZERO;
        }
        return amount;
    }

    private CoreBaseCollection getItemMapByCheckageId(Context ctx, String checkageId, ElimTypeEnum elimType) throws BOSException, EASBizException {
        BillBaseInfo info;
        String elimTempletid = "";
        if (elimType == ElimTypeEnum.ComeAndGo) {
            info = InterDataCheckageFactory.getLocalInstance(ctx).getInterDataCheckageInfo("select templet.id where id='" + checkageId + "'");
            if (info != null) {
                elimTempletid = info.getTemplet().getId().toString();
            }
        } else if (elimType == ElimTypeEnum.exchange && (info = ExchCheckageFactory.getLocalInstance(ctx).getExchCheckageInfo("select templet.id where id='" + checkageId + "'")) != null) {
            elimTempletid = info.getTemplet().getId().toString();
        }
        CoreBaseCollection cbaseColl = new CoreBaseCollection();
        StringBuffer itemSql = new StringBuffer("select");
        itemSql.append(" selfCompanyTtem.Id,selfCompanyTtem.Name,selfCompanyTtem.number,");
        itemSql.append(" otherCompanyTtem.Id,otherCompanyTtem.Name,otherCompanyTtem.number,");
        itemSql.append("elimTemple.id ");
        itemSql.append(" where elimTemple='").append(elimTempletid).append("'");
        itemSql.append(" order by seq");
        cbaseColl = EliminationItemMapFactory.getLocalInstance(ctx).getCollection(itemSql.toString());
        return cbaseColl;
    }

    @Override
    protected boolean _checkInterItemDataExist(Context ctx, List checkIDList) throws BOSException, EASBizException {
        String strIDs = this.getCheckageIDCollection((ArrayList)checkIDList);
        StringBuffer sb = new StringBuffer();
        sb.append(" from T_CSL_InterItemData a, T_CSL_InterDataCheckage b,");
        sb.append(" T_CSL_DataCheckageEntry c, T_CSL_RptItem d, T_CSL_Cslreport e,t_csl_rptreceived f ");
        sb.append(" where a.FReport = e.fid and e.FDataCollectNumber = b.FDataCollectNumber and e.fid=f.freportid ");
        sb.append(" and b.fid = c.FCheckageID and d.FId=c.FItemId and a.FItemNumber = d.FNumber  ");
        sb.append(" and a.FCompanyID = c.FCompanyID and a.FTargetCompanyID = c.FTargetCompanyID  ");
        sb.append(" and a.FYear = b.FYear and a.FPeriod = b.FPeriod and b.FPeriodType = a.FPeriodType ");
        sb.append(" and b.FCurrencyID = a.FTargetCurrencyID and f.forgtreeid = b.FOrgBoundID ");
        sb.append(" and b.fid in ").append(strIDs);
        StringBuffer sbInterItemData = new StringBuffer();
        sbInterItemData.append("select count(a.Fid) count").append(sb.toString());
        StringBuffer sbInterDataCheckage = new StringBuffer();
        sbInterDataCheckage.append("select count(fid) count from T_CSL_DataCheckageEntry where FCheckageID in ");
        sbInterDataCheckage.append(strIDs).append(" and FCompanyID in ( select a.FCompanyID FCompanyID ");
        sbInterDataCheckage.append(sb.toString()).append(")");
        String countInterItemData = "0";
        String countInterDataCheckage = "0";
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sbInterItemData.toString());
            while (row.next()) {
                countInterItemData = row.getString("count");
            }
            row = DbUtil.executeQuery((Context)ctx, (String)sbInterDataCheckage.toString());
            while (row.next()) {
                countInterDataCheckage = row.getString("count");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return !"0".equals(countInterItemData) && countInterItemData.equals(countInterDataCheckage);
    }

    @Override
    protected void _noMergeCreateElimination(Context ctx, Map param) throws BOSException, EASBizException {
        String orgTreeId = (String)param.get("orgBoundId");
        int periodType = (Integer)param.get("periodType");
        int year = (Integer)param.get("year");
        int period = (Integer)param.get("period");
        String sourceCurrencyId = (String)param.get("sourceCurrencyId");
        String currencyId = (String)param.get("currencyId");
        String orgUnitId = (String)param.get("orgUnitId");
        Timestamp elimDate = (Timestamp)param.get("elimDate");
        ElimTypeEnum elimType = (ElimTypeEnum)((Object)param.get("elimType"));
        String basicTreeId = (String)param.get("basicTreeId");
        String displayTypeId = (String)param.get("displayTypeId");
        DataCollectInfo dataCollect = (DataCollectInfo)param.get("dataCollect");
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)param.get("KEY_ORGTREE_INFO");
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)param.get("KEY_ORGUNIT_INFO");
        boolean isByCompany = (Boolean)param.get("isByCompany");
        String fastMergeSoluId = (String)param.get("fastMergeSoluId");
        BOSUuid dataCollectID = null;
        String dataCollectNumber = null;
        if (dataCollect != null) {
            dataCollectID = dataCollect.getId();
            dataCollectNumber = dataCollect.getNumber();
        }
        Timestamp createTime = new Timestamp(System.currentTimeMillis());
        String creatorId = ctx.getCaller().toString();
        int mergeType = 0;
        mergeType = Integer.parseInt(CSLServerHelper.getSysParamValue(ctx, orgTreeInfo, "GR_CSL_MERGETYPE_004"));
        mergeType = mergeType == 0 ? 0 : 1;
        int elimMethod = Integer.parseInt(CSLServerHelper.getSysParamValue(ctx, orgTreeInfo, "GR_CSL_ELIMMETHOD_001"));
        BigDecimal zero = new BigDecimal("0");
        IRowSet set = mergeType == 1 ? this.getOrdinalCheckRecord(ctx, orgTreeId, periodType, year, period, orgUnitId, elimType, isByCompany, basicTreeId, mergeType, elimMethod) : this.getDirectCheckElimination(ctx, orgTreeId, periodType, year, period, orgUnitId, elimType, false, basicTreeId, mergeType, elimMethod);
        Connection conn = super.getConnection(ctx);
        String flagID = "";
        int count = 0;
        try {
            while (set.next()) {
                String checkid = set.getString("fid");
                if (!flagID.equals(checkid)) {
                    ++count;
                }
                flagID = checkid;
            }
            set.beforeFirst();
            flagID = "";
        }
        catch (SQLException exc) {
            throw new BOSException("Sql execute exception : when query to tables", (Throwable)exc);
        }
        String[] numberlist = new String[count];
        HashMap<String, Object> param1 = new HashMap<String, Object>();
        param1.put("OrgTreeID", orgTreeId);
        param1.put("Year", new Integer(year));
        param1.put("Period", new Integer(period));
        param1.put("PeriodType", new Integer(periodType));
        param1.put("KEY_ORGTREE_INFO", orgTreeInfo);
        param1.put("KEY_ORGUNIT_INFO", orgUnitInfo);
        if (set.size() > 0) {
            numberlist = CslElimUtil.getBatchNumber(ctx, param1, count);
        }
        this.insertBatchElimination(ctx, conn, set, flagID, numberlist, currencyId, dataCollectID, dataCollectNumber, elimDate, createTime, creatorId, orgTreeId, orgUnitId, periodType, year, period, sourceCurrencyId, elimType, displayTypeId, fastMergeSoluId, zero, param, param1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertBatchElimination(Context ctx, Connection conn, IRowSet set, String flagID, String[] numberlist, String currencyId, BOSUuid dataCollectID, String dataCollectNumber, Timestamp elimDate, Timestamp createTime, String creatorId, String orgTreeId, String orgUnitId, int periodType, int year, int period, String sourceCurrencyId, ElimTypeEnum elimType, String displayTypeId, String fastMergeSoluId, BigDecimal zero, Map param, Map param1, boolean isFirst) throws BOSException, EASBizException {
        block30: {
            Statement insertentry = null;
            Statement inserthead = null;
            Statement insertRecord = null;
            HashMap<String, Object> checktoeim = new HashMap<String, Object>();
            String templetId = "";
            HashSet<Object> addelimids = new HashSet<Object>();
            try {
                HashMap<String, List<Object>> sqlMap = new HashMap<String, List<Object>>();
                int atcount = 0;
                while (set.next()) {
                    Object eliminationId;
                    String elimNumber = "";
                    String checkid = set.getString("fid");
                    if (!flagID.equals(checkid)) {
                        elimNumber = numberlist[atcount];
                        ++atcount;
                    }
                    flagID = checkid;
                    StringBuffer insertHead = new StringBuffer();
                    int isCitedByLater = set.getInt("FIsCitedByLater");
                    String eliminationModeId = set.getString("eliminationModeId");
                    ArrayList<Object> params = new ArrayList<Object>();
                    if (checktoeim.get(checkid) == null) {
                        eliminationId = BOSUuid.create((String)ELIMINATION_BOSTYPE).toString();
                        currencyId = set.getString("fCurrencyId");
                        templetId = set.getString("fTempletId");
                        insertHead = new StringBuffer(" INSERT INTO T_CSL_Elimination \r\n");
                        insertHead.append("(fid, FDate, FCreateTime,FCreatorID,fnumber,forgboundid, forgunit,fperiodtype,");
                        insertHead.append(" fyear,fperiod,FSourceCurrencyID,fcurrencyid,ftempletid, \r\n ");
                        insertHead.append(" fcheckedStatus, fdatasource, farchivedstatus, fvaluetype, felimtype, FIsCitedByLater \r\n");
                        if (null != eliminationModeId) {
                            insertHead.append(" ,FEliminationModeId");
                        }
                        if (dataCollectID != null && dataCollectNumber != null) {
                            insertHead.append(",fdatacollectid,fdatacollectnumber");
                        }
                        insertHead.append(" ,FDisplayTemplateTypeId ) \r\n");
                        insertHead.append(" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?");
                        if (null != eliminationModeId) {
                            insertHead.append(",?");
                        }
                        if (dataCollectID != null && dataCollectNumber != null) {
                            insertHead.append(",?,?");
                        }
                        insertHead.append(",?) ");
                        params.add(eliminationId);
                        params.add(elimDate);
                        params.add(createTime);
                        params.add(creatorId);
                        params.add(elimNumber);
                        params.add(orgTreeId);
                        params.add(orgUnitId);
                        params.add(periodType);
                        params.add(year);
                        params.add(period);
                        params.add(sourceCurrencyId == null ? currencyId : sourceCurrencyId);
                        params.add(currencyId);
                        params.add(templetId);
                        params.add(1);
                        params.add(1);
                        params.add(1);
                        params.add(1);
                        params.add(elimType.getValue());
                        params.add(isCitedByLater);
                        if (null != eliminationModeId) {
                            params.add(eliminationModeId);
                        }
                        if (dataCollectID != null && dataCollectNumber != null) {
                            params.add(dataCollectID.toString());
                            params.add(dataCollectNumber);
                        }
                        params.add(displayTypeId != null ? displayTypeId : null);
                        checktoeim.put(checkid, eliminationId);
                    } else {
                        eliminationId = (String)checktoeim.get(checkid);
                        insertHead = null;
                    }
                    String lineId = new ObjectUuidPK(new BOSObjectType(ELIMINATION_ENTRY_BOSTYPE)).toString();
                    int lineSeq = set.getInt("fseq");
                    String itemId = set.getString("fItemId");
                    BigDecimal valiDebit = set.getBigDecimal("fValiDebit");
                    BigDecimal valiCredit = set.getBigDecimal("fValiCredit");
                    String companyID = set.getString("fCompanyID");
                    int dataElement = set.getInt("fDataElement");
                    String summary = set.getString("fsummary");
                    int dcType = set.getInt("fdc");
                    if (valiDebit.compareTo(zero) != 0 && valiCredit.compareTo(zero) != 0) {
                        if (dcType == 0) {
                            valiCredit = valiCredit.subtract(valiDebit);
                            valiDebit = zero;
                        } else if (dcType == 1) {
                            valiDebit = valiDebit.subtract(valiCredit);
                            valiCredit = zero;
                        }
                    }
                    if (valiDebit.compareTo(zero) == 0 && valiCredit.compareTo(zero) == 0) continue;
                    StringBuffer sbInsertLine = new StringBuffer(" INSERT INTO T_CSL_EliminationEntry \r\n");
                    sbInsertLine.append("   (fid, fseq, fitemid, fDataElement, fsummary, fdebit, fcredit, feliminationId, fCompanyID) \r\n");
                    sbInsertLine.append(" VALUES(?,?,?,?,?,?,?,?,?)");
                    List<Object[]> paramList = (ArrayList<Object[]>)sqlMap.get(sbInsertLine.toString());
                    if (paramList == null) {
                        paramList = new ArrayList<Object[]>();
                        sqlMap.put(sbInsertLine.toString(), paramList);
                    }
                    Object[] paramArr = new Object[9];
                    int i = 0;
                    paramArr[i++] = lineId;
                    paramArr[i++] = lineSeq;
                    paramArr[i++] = itemId;
                    paramArr[i++] = dataElement;
                    paramArr[i++] = summary == null ? "" : summary;
                    paramArr[i++] = valiDebit.compareTo(zero) == 0 ? null : valiDebit;
                    paramArr[i++] = valiCredit.compareTo(zero) == 0 ? null : valiCredit;
                    paramArr[i++] = eliminationId;
                    paramArr[i++] = companyID;
                    paramList.add(paramArr);
                    if (insertHead == null || insertHead.toString().equals("")) continue;
                    paramList = (List)sqlMap.get(insertHead.toString());
                    if (paramList == null) {
                        paramList = new ArrayList();
                        sqlMap.put(insertHead.toString(), paramList);
                    }
                    paramList.add(params.toArray());
                    addelimids.add(eliminationId);
                    String id = new ObjectUuidPK(new BOSObjectType(ELIMRECORD_BOSTYPE)).toString();
                    String checkageDataId = set.getString("fid");
                    StringBuffer sbInsert = new StringBuffer(" INSERT INTO T_CSL_ElimRecord \r\n");
                    sbInsert.append("   (fid,fcreatorId,flastupdateUserId, feliminationid, fcheckageDataid) \r\n");
                    sbInsert.append(" VALUES(?,?,?,?,?)");
                    paramList = (List)sqlMap.get(sbInsert.toString());
                    if (paramList == null) {
                        paramList = new ArrayList();
                        sqlMap.put(sbInsert.toString(), paramList);
                    }
                    paramArr = new Object[5];
                    i = 0;
                    paramArr[i++] = id;
                    paramArr[i++] = creatorId;
                    paramArr[i++] = creatorId;
                    paramArr[i++] = eliminationId;
                    paramArr[i++] = checkageDataId;
                    paramList.add(paramArr);
                }
                for (String sql : sqlMap.keySet()) {
                    DbUtil.executeBatch((Context)ctx, (String)sql, (List)((List)sqlMap.get(sql)));
                }
                sqlMap.clear();
                IElimination iElimination = EliminationFactory.getLocalInstance(ctx);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", addelimids, CompareType.INCLUDE));
                view.setFilter(filter);
                SelectorItemCollection selector = view.getSelector();
                selector.add(new SelectorItemInfo("*"));
                selector.add(new SelectorItemInfo("entries.*"));
                selector.add(new SelectorItemInfo("entries.item.id"));
                selector.add(new SelectorItemInfo("entries.item.number"));
                selector.add(new SelectorItemInfo("entries.item.isProfitAndLosses"));
                selector.add(new SelectorItemInfo("entries.company.number"));
                selector.add(new SelectorItemInfo("currency.precision"));
                EliminationCollection coll = iElimination.getEliminationCollection(view);
                CoreBaseCollection coll1 = new CoreBaseCollection();
                for (int i = 0; i < coll.size(); ++i) {
                    EliminationInfo info = coll.get(i);
                    if (info.getEntries() == null || info.getEntries().size() == 0) continue;
                    coll1.add((CoreBaseInfo)info);
                }
                if (coll1.size() > 0) {
                    iElimination.submit(coll1);
                }
                if (param.get("createIds") != null) {
                    HashSet<String> createIds = new HashSet<String>();
                    for (int i = 0; i < coll1.size(); ++i) {
                        createIds.add(coll1.get(i).getId().toString());
                    }
                    param.put("createIds", createIds);
                }
            }
            catch (SQLException exc) {
                if ("23000".equals(exc.getSQLState()) && exc.getMessage().contains("unique constraint") && isFirst) {
                    try {
                        numberlist = this.getNumberList(ctx, numberlist, param1);
                        this.insertBatchElimination(ctx, conn, set, flagID, numberlist, currencyId, dataCollectID, dataCollectNumber, elimDate, createTime, creatorId, orgTreeId, orgUnitId, periodType, year, period, sourceCurrencyId, elimType, displayTypeId, fastMergeSoluId, zero, param, param1, false);
                        break block30;
                    }
                    catch (Exception e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                throw new BOSException("Sql execute exception : when insert records to tables", (Throwable)exc);
            }
            finally {
                SQLUtils.cleanup(insertentry);
                SQLUtils.cleanup(inserthead);
                SQLUtils.cleanup(insertRecord);
                SQLUtils.cleanup((Connection)conn);
            }
        }
    }

    private String[] getNumberList(Context ctx, String[] numberlist, Map param1) throws BOSException, SQLException, EASBizException {
        if (numberlist == null || numberlist.length < 1) {
            return numberlist;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < numberlist.length; ++i) {
            sb.append("'");
            sb.append(numberlist[i]);
            sb.append("'");
            if (i == numberlist.length - 1) continue;
            sb.append(",");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select fnumber from T_CSL_Elimination where fnumber in (");
        sql.append(sb.toString());
        sql.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> numSet = new HashSet<String>();
        while (rs.next()) {
            numSet.add(rs.getString("fnumber"));
        }
        if (numSet.size() > 0) {
            String[] newNumberArry = new String[numberlist.length];
            String[] batchNumberArry = CslElimUtil.getBatchNumber(ctx, param1, numSet.size());
            int x = 0;
            for (int i = 0; i < numberlist.length; ++i) {
                if (numSet.contains(numberlist[i])) continue;
                newNumberArry[x] = numberlist[i];
                ++x;
            }
            int y = 0;
            x = newNumberArry.length - numSet.size();
            while (y < batchNumberArry.length) {
                newNumberArry[x] = batchNumberArry[y];
                ++y;
                ++x;
            }
            return newNumberArry;
        }
        return numberlist;
    }

    public static void main(String[] args) throws Exception {
        InterCheckControllerBean bean = new InterCheckControllerBean();
        Context ctx = new Context();
        ctx.setLocale(LocaleUtils.locale_l2);
        bean.getOrdinalCheckRecord(ctx, "?", 3, 2015, 6, "?", ElimTypeEnum.ComeAndGo, false, null, 1, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRowSet getOrdinalCheckRecord(Context ctx, String orgBoundId, int periodType, int year, int period, String orgUnitId, ElimTypeEnum elimType, boolean isByCompany, String basicTreeId, int mergeType, int elimMethod) throws BOSException, EASBizException {
        String longNumber = null;
        int level = 0;
        String orgTreeNumber = null;
        String orgUnitNumber = null;
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)" select struct.FLongNumber,struct.FLevel,tree.fnumber treeNumber,unit.fnumber unitNumber From t_org_structure struct inner join t_org_baseunit unit on unit.fid=struct.funitid inner join t_org_tree tree on tree.fid=struct.ftreeid where struct.ftreeid = ? and struct.funitid = ?", (Object[])new Object[]{orgBoundId, orgUnitId});
        try {
            while (rsTemp.next()) {
                longNumber = rsTemp.getString("FLongNumber");
                orgTreeNumber = rsTemp.getString("treeNumber");
                orgUnitNumber = rsTemp.getString("unitNumber");
                level = rsTemp.getInt("FLevel");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        String elimOrgUnitsTable = SameControlUtil.getElimOrgUnitsTable((Context)ctx, (String)orgBoundId, (String)orgUnitId, (String)longNumber, (String)orgUnitNumber, (String)orgTreeNumber, (int)year, (int)period, (int)periodType, (int)level, (ElimTypeEnum)elimType, (int)mergeType);
        try {
            StringBuffer sbSQL = null;
            CommonTable commonTable = new CommonTable(elimType);
            sbSQL = new StringBuffer("SELECT DISTINCT a.fid,a.fcurrencyid, a.ftempletid, b.fitemid,b.fCompanyID, f.fdc, f.fsummary,f.FDataElement fDataElement,\r\n");
            sbSQL.append(" b.fvalidebit as fvalidebit, b.fvaliCredit as fvaliCredit, \r\n");
            sbSQL.append("  c.fname_" + ctx.getLocale() + " as fCurrencyName, d.fname as fTempletname,  d.FIsCitedByLater as FIsCitedByLater, d.FEliminationModeId as eliminationModeId,\r\n");
            sbSQL.append(" e.fnumber as fItemNumber, e.fname_" + ctx.getLocale() + " as fItemName,b.fseq as fseq \r\n");
            sbSQL.append(" FROM ").append(commonTable.getMasterTable()).append(" a \r\n");
            sbSQL.append(" RIGHT OUTER JOIN ").append(commonTable.getEntryTable()).append(" AS b \r\n");
            sbSQL.append("  ON a.FID = b.FCheckageID \r\n");
            sbSQL.append(" INNER JOIN T_BD_Currency AS c \r\n");
            sbSQL.append("  ON a.FCurrencyID = c.FID \r\n");
            sbSQL.append(" INNER JOIN T_CSL_ElimTemplet AS d \r\n");
            sbSQL.append("  ON a.FTempletID = d.FID \r\n");
            sbSQL.append(" INNER JOIN T_CSL_RptItem AS e \r\n");
            sbSQL.append("  ON b.FItemID = e.FID \r\n");
            sbSQL.append(" INNER Join ").append(elimOrgUnitsTable).append(" x \r\n");
            sbSQL.append(" ON b.fcompanyid = x.fcompanyid And b.ftargetcompanyid=x.ftargetcompanyid");
            sbSQL.append(" INNER JOIN T_CSL_ElimTempletEntry AS f \r\n");
            sbSQL.append("  ON f.FTempletID = d.FID \r\n");
            sbSQL.append("  and f.fItemId = b.FItemID \r\n");
            sbSQL.append("  and f.fdataelement = b.fdataelement \r\n");
            sbSQL.append(" WHERE a.fcheckedstatus = ").append(2).append(" \r\n");
            sbSQL.append("\tand a.fOrgBoundId = '").append(isByCompany ? basicTreeId : orgBoundId).append("' \r\n");
            sbSQL.append("  and a.fperiodType = ").append(periodType).append(" \r\n");
            sbSQL.append("  and a.fyear = ").append(year).append(" \r\n");
            sbSQL.append("  and a.fperiod = ").append(period).append(" \r\n");
            sbSQL.append("  and (b.fvalidebit<>0 or b.fvalicredit<>0) \r\n");
            sbSQL.append(" and a.fid NOT IN ( SELECT fCheckageDataID  \r\n");
            sbSQL.append("    FROM t_csl_ElimRecord a, t_csl_Elimination b \r\n");
            sbSQL.append("    WHERE a.fEliminationId = b.fid and b.fOrgUnit = '").append(orgUnitId).append("' \r\n");
            sbSQL.append("\t  and b.fOrgBoundId = '").append(isByCompany ? basicTreeId : orgBoundId).append("' \r\n");
            sbSQL.append("    and b.fperiodType = ").append(periodType).append(" \r\n");
            sbSQL.append("    and b.fyear = ").append(year).append(" \r\n");
            sbSQL.append("    and b.fperiod = ").append(period).append(") \r\n");
            if (mergeType == 1 && !isByCompany && elimMethod == 2) {
                sbSQL.append(" AND (b.fcompanyid || b.ftargetcompanyid) in ");
                sbSQL.append(" ( select a.FFromId || a.FToId From");
                sbSQL.append(" (select r1.finvestcompanyid as ffromid,r1.fcontrolcompanyid as ftoid from t_csl_relatedPartyRela r1");
                sbSQL.append(" join t_csl_relatedParty r2 on r1.FRelationShipId = r2.fid");
                sbSQL.append(" where r2.FNumber = '001' or r2.FNumber = '003' or r2.FNumber = '004' or r2.Fnumber = '005') a,");
                sbSQL.append(" (select r1.finvestcompanyid as ffromid,r1.fcontrolcompanyid as ftoid from t_csl_relatedPartyRela r1");
                sbSQL.append(" join t_csl_relatedParty r2 on r1.FRelationShipId = r2.fid");
                sbSQL.append(" where r2.FNumber = '001' or r2.FNumber = '003' or r2.FNumber = '004' or r2.Fnumber = '005') b ");
                sbSQL.append(" WHERE (a.ffromid=b.ftoid and a.ftoid=b.ffromid) ");
                sbSQL.append(")");
            }
            SQLBuilder existsSqlPart = this.getExcludeAuditRecordSQLBuilder(orgBoundId, orgUnitId, year, period, periodType, elimType);
            sbSQL.append(existsSqlPart.getSQL());
            sbSQL.append(" ORDER BY a.fid \r\n");
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])existsSqlPart.getParams());
            return iRowSet;
        }
        finally {
            if (!DebugLogger.isDebug && elimOrgUnitsTable != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(elimOrgUnitsTable);
            }
        }
    }

    private SQLBuilder getExcludeAuditRecordSQLBuilder(String orgBoundId, String orgUnitId, int year, int period, int periodType, ElimTypeEnum elimType) {
        SQLBuilder existsSqlPart = new SQLBuilder();
        existsSqlPart.append(" and not exists ( \n").append(" select 'X' from t_csl_elimination e1 \n").append(" join t_csl_eliminationentry entry on e1.fid = entry.feliminationid \n").append(" join t_csl_rptitem rptitem on rptitem.fid = entry.fitemid \n").append(" join t_csl_dataelement de on de.finterseq = entry.fdataelement \n").append(" where e1.forgboundid = ? ", (Object)orgBoundId).append(" and e1.forgunit = ? ", (Object)orgUnitId).append(" and e1.fyear = ? ", (Object)year).append(" and e1.fperiod = ? ", (Object)period).append(" and e1.fperiodtype = ?", (Object)periodType).append(" and e1.fcheckedstatus = 2 \n").append(" and e1.felimtype = ? ", (Object)elimType.getValue()).append(" and e1.FElimDataSource = 0 ").append(" and b.fcompanyid = entry.fcompanyId \n").append(" and e1.fcurrencyid = a.fcurrencyId \n").append(" and b.ftargetcompanyId = entry.ftargetcompanyId \n").append(" and b.FItemID = entry.fitemId and b.fdataelement = entry.fdataelement) \n");
        return existsSqlPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRowSet getDirectCheckElimination(Context ctx, String orgBoundId, int periodType, int year, int period, String orgUnitId, ElimTypeEnum elimType, boolean isByCompany, String basicTreeId, int mergeType, int elimMethod) throws BOSException, SQLDataException, EASBizException {
        String longNumber = null;
        int level = 0;
        String orgTreeNumber = null;
        String orgUnitNumber = null;
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)" select struct.FLongNumber,struct.FLevel,tree.fnumber treeNumber,unit.fnumber unitNumber From t_org_structure struct inner join t_org_baseunit unit on unit.fid=struct.funitid inner join t_org_tree tree on tree.fid=struct.ftreeid where struct.ftreeid = ? and struct.funitid = ?", (Object[])new Object[]{orgBoundId, orgUnitId});
        try {
            while (rsTemp.next()) {
                longNumber = rsTemp.getString("FLongNumber");
                orgTreeNumber = rsTemp.getString("treeNumber");
                orgUnitNumber = rsTemp.getString("unitNumber");
                level = rsTemp.getInt("FLevel");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        String elimOrgUnitsTable = SameControlUtil.getElimOrgUnitsTable((Context)ctx, (String)orgBoundId, (String)orgUnitId, (String)longNumber, (String)orgUnitNumber, (String)orgTreeNumber, (int)year, (int)period, (int)periodType, (int)level, (ElimTypeEnum)elimType, (int)mergeType);
        try {
            StringBuffer sbSQL = null;
            CommonTable commonTable = new CommonTable(elimType);
            sbSQL = new StringBuffer("select distinct a.fid,a.fcurrencyid, a.ftempletid, b.fitemid, b.fCompanyID, f.fdc, f.fsummary,f.FDataElement fDataElement, ");
            sbSQL.append("b.fvalidebit as fvalidebit, b.fvaliCredit as fvaliCredit,  \r\n");
            sbSQL.append("  c.fname_" + ctx.getLocale() + " as fCurrencyName, d.fname as fTempletname,  d.FIsCitedByLater as FIsCitedByLater, d.FEliminationModeId as eliminationModeId,\r\n");
            sbSQL.append(" e.fnumber as fItemNumber, e.fname_" + ctx.getLocale() + " as fItemName ,b.fseq as fseq \r\n");
            sbSQL.append(" from ").append(commonTable.getMasterTable()).append(" a \r\n");
            sbSQL.append(" RIGHT OUTER JOIN ").append(commonTable.getEntryTable()).append(" AS b \r\n");
            sbSQL.append("  ON a.FID = b.FCheckageID \r\n");
            sbSQL.append(" INNER JOIN T_BD_Currency AS c \r\n");
            sbSQL.append("  ON a.FCurrencyID = c.FID \r\n");
            sbSQL.append(" INNER JOIN T_CSL_ElimTemplet AS d \r\n");
            sbSQL.append("  ON a.FTempletID = d.FID \r\n");
            sbSQL.append(" INNER JOIN T_CSL_RptItem AS e \r\n");
            sbSQL.append("  ON b.FItemID = e.FID \r\n");
            sbSQL.append(" INNER JOIN T_CSL_ElimTempletEntry AS f \r\n");
            sbSQL.append("  ON f.FTempletID = d.FID \r\n");
            sbSQL.append("  and f.fItemId = b.FItemID \r\n");
            sbSQL.append("  and f.fdataelement = b.fdataelement \r\n");
            sbSQL.append("  INNER JOIN  (  \r\n");
            sbSQL.append("  select count(fdc) as fsingledc, fid from (  \r\n");
            sbSQL.append("  select distinct b.fdc, a.fid from t_csl_elimtemplet a  \r\n");
            sbSQL.append("  inner join t_csl_elimtempletentry b  \r\n");
            sbSQL.append("  on a.fid = b.ftempletid and a.fcheckedstatus = ").append(2).append(" ) tt group by fid  \r\n");
            sbSQL.append("   ) as t \r\n");
            sbSQL.append("  ON d.FID = t.FID and  t.fsingledc =2 \r\n");
            sbSQL.append(" WHERE  a.fSingleDC = 0 and a.fcheckedstatus = ").append(2).append(" \r\n");
            sbSQL.append("\tand a.fOrgBoundId = '").append(isByCompany ? basicTreeId : orgBoundId).append("' \r\n");
            sbSQL.append("  and a.fperiodType = ").append(periodType).append(" \r\n");
            sbSQL.append("  and a.fyear = ").append(year).append(" \r\n");
            sbSQL.append("  and a.fperiod = ").append(period).append(" \r\n");
            sbSQL.append("  and (b.fvalidebit<>0 or b.fvalicredit<>0) \r\n");
            sbSQL.append(" and b.fcompanyid IN (select fcompanyId from ").append(elimOrgUnitsTable).append(") \r\n");
            sbSQL.append(" and b.ftargetcompanyid IN (select fcompanyId from ").append(elimOrgUnitsTable).append(") \r\n");
            sbSQL.append(" and a.fid NOT IN ( SELECT fCheckageDataID  \r\n");
            sbSQL.append("    FROM t_csl_ElimRecord a, t_csl_Elimination b \r\n");
            sbSQL.append("    WHERE a.fEliminationId = b.fid and b.fOrgUnit = '");
            sbSQL.append(orgUnitId).append("')  \r\n");
            if (mergeType == 1 && !isByCompany && elimMethod == 2) {
                sbSQL.append(" AND (x.fcompanyid || x.ftargetcompanyid) in ");
                sbSQL.append(" ( select a.FFromId || a.FToId From");
                sbSQL.append(" (select r1.finvestcompanyid as ffromid,r1.fcontrolcompanyid as ftoid from t_csl_relatedPartyRela r1");
                sbSQL.append(" join t_csl_relatedParty r2 on r1.FRelationShipId = r2.fid");
                sbSQL.append(" where r2.FNumber = '001' or r2.FNumber = '003' or r2.FNumber = '004' or r2.Fnumber = '005') a,");
                sbSQL.append(" (select r1.finvestcompanyid as ffromid,r1.fcontrolcompanyid as ftoid from t_csl_relatedPartyRela r1");
                sbSQL.append(" join t_csl_relatedParty r2 on r1.FRelationShipId = r2.fid");
                sbSQL.append(" where r2.FNumber = '001' or r2.FNumber = '003' or r2.FNumber = '004' or r2.Fnumber = '005') b ");
                sbSQL.append(" WHERE (a.ffromid=b.ftoid and a.ftoid=b.ffromid) ");
                sbSQL.append(")");
            }
            SQLBuilder existsSqlPart = this.getExcludeAuditRecordSQLBuilder(orgBoundId, orgUnitId, year, period, periodType, elimType);
            sbSQL.append(existsSqlPart.getSQL());
            sbSQL.append(" ORDER BY a.fid \r\n");
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])existsSqlPart.getParams());
            return iRowSet;
        }
        finally {
            if (!DebugLogger.isDebug && elimOrgUnitsTable != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(elimOrgUnitsTable);
            }
        }
    }

    private boolean isHavCodeRule(Context ctx, String orgTreeId, int periodType, int year, int period, OrgTreeInfo orgTreeInfo, OrgUnitInfo orgUnitInfo) throws CodingRuleException, EASBizException, BOSException {
        boolean isHavCodeRule = false;
        EliminationInfo elim = new EliminationInfo();
        elim.setOrgBound(orgTreeInfo);
        elim.setOrgUnit(orgUnitInfo);
        boolean hasCodeRule = CSLServerHelper.isHasCodingRuleByOrg(ctx, (IObjectValue)elim, CSLServerHelper.getRootOrgIDForRootCU(ctx));
        String strOrgID = CSLServerHelper.getRootOrgIDForRootCU(ctx);
        if (strOrgID != null && hasCodeRule) {
            isHavCodeRule = true;
        }
        return isHavCodeRule;
    }

    private BigDecimal getCurrentMaxNumberVauleFromDb(Context ctx, String orgTreeId, int periodType, int year, int period, String tableName) throws BOSException {
        BigDecimal number = new BigDecimal("1");
        StringBuffer sbSQL = new StringBuffer(" SELECT Max(to_int(Replace(fnumber,'AUTO_',''))) As Fmaxnumber From \r\n");
        sbSQL.append(tableName).append(" a  \r\n");
        sbSQL.append("\tWHERE a.fOrgBoundId = '").append(orgTreeId).append("' \r\n");
        sbSQL.append("  and a.fyear = ").append(year).append(" \r\n");
        sbSQL.append("  and a.fperiod = ").append(period).append(" \r\n");
        sbSQL.append("  and a.fperiodType = ").append(periodType).append(" \r\n");
        sbSQL.append("  and a.fNumber like N'AUTO\\_%' escape '\\' \r\n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            if (rs.next() && rs.getBigDecimal("Fmaxnumber") != null) {
                number = rs.getBigDecimal("Fmaxnumber").add(new BigDecimal("1"));
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        return number;
    }

    @Override
    protected List _batchAuditData(Context ctx, List idList, ElimTypeEnum elimType, CheckageConfirmEnum oprtState) throws BOSException, EASBizException {
        AuditOperator operator = new AuditOperator(ctx, elimType, oprtState, idList);
        try {
            String tips = operator.execute();
            if (!StringUtils.isEmpty((String)tips)) {
                return Arrays.asList((Object[])new Object[]{tips, operator.handledIds});
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return Arrays.asList((Object[])new Object[]{null, operator.handledIds});
    }

    @Override
    protected Map _checkInterExchRptDataIsChgInCheckage(Context ctx, Map param) throws BOSException, EASBizException {
        InterExchReportValChgChecker checker = new InterExchReportValChgChecker(param, ctx);
        return checker.check();
    }

    @Override
    protected Map _getLimitAmount(Context ctx, Map paramsMap) throws BOSException, EASBizException {
        HashMap<String, LimitAmountInfo> limit = new HashMap<String, LimitAmountInfo>();
        if (!this.isExistedLimitAmount(ctx)) {
            return limit;
        }
        String orgTreeId = (String)paramsMap.get("OrgTreeID");
        String orgUnitId = (String)paramsMap.get("OrgUnitID");
        int year = (Integer)paramsMap.get("Year");
        int period = (Integer)paramsMap.get("Period");
        int periodType = (Integer)paramsMap.get("PeriodType");
        int elimType = (Integer)paramsMap.get("elimType");
        String orgTreeNum = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo("select number where id ='" + orgTreeId + "'").getNumber();
        String orgUnitNum = null;
        if (!StringUtils.isEmpty((String)orgUnitId)) {
            orgUnitNum = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo("select number where id ='" + orgUnitId + "'").getNumber();
        }
        SQLBuilder sql = new SQLBuilder();
        sql.append(" Select unit.FID unitId,limit2.FLimitAmount amount,limit2.FToken token from T_ORG_Tree tree \n").append(" JOIN T_ORG_Structure s ON tree.FID = s.FTreeId \n").append(" JOIN T_ORG_BaseUnit unit ON unit.FID = s.FUnitID \n").append(" JOIN (SELECT FOrgTreeNumber,ForgUnitNumber,FperiodType,FElimType, max(fyear) fyear,max(fperiod) fperiod from T_CSL_CheckageLimitAoumt \n").append("       Where FOrgTreeNumber = ? \n", (Object)orgTreeNum);
        if (!StringUtils.isEmpty((String)orgUnitId)) {
            sql.append("       AND ForgUnitNumber = ? \n", (Object)orgUnitNum);
        }
        sql.append("       AND FperiodType = ? \n", (Object)periodType).append("       AND FYear <= ? \n", (Object)year).append("       AND Fperiod <= ? \n", (Object)period).append("       AND FElimType = ? \n", (Object)elimType).append("       GROUP BY FOrgTreeNumber,ForgUnitNumber,FperiodType,FElimType ) limit1 \n").append("       ON limit1.FOrgTreeNumber = tree.FNumber AND limit1.ForgUnitNumber = unit.Fnumber \n").append(" JOIN T_CSL_CheckageLimitAoumt limit2 on limit1.FOrgTreeNumber = limit2.FOrgTreeNumber \n").append(" \t  AND limit1.ForgUnitNumber = limit2.ForgUnitNumber \n").append(" \t  AND limit1.FYear = limit2.FYear     \n").append(" \t  AND limit1.FPeriod = limit2.FPeriod \n").append(" \t  AND limit1.FperiodType = limit2.FperiodType \n").append(" \t  AND limit1.FElimType = limit2.FElimType \n").append(" WHERE tree.FID = ? ", (Object)orgTreeId).append(" AND unit.FIsGrouping = 1 ");
        if (!StringUtils.isEmpty((String)orgUnitId)) {
            sql.append(" AND unit.FID = ? \n", (Object)orgUnitId);
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        try {
            while (rs.next()) {
                LimitAmountInfo limitAmountInfo = new LimitAmountInfo();
                limitAmountInfo.setLimitAmount(rs.getBigDecimal("amount"));
                limitAmountInfo.setToken(rs.getString("token"));
                limit.put(rs.getString("unitId"), limitAmountInfo);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return limit;
    }

    private boolean isExistedLimitAmount(Context ctx) throws BOSException, EASBizException {
        String sql = "select top 1  fyear from T_CSL_CheckageLimitAoumt";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        return rs.size() > 0;
    }

    @Override
    protected void _saveLimitAmount(Context ctx, Map paramsMap) throws BOSException, EASBizException {
        SQLBuilder sql = new SQLBuilder();
        String orgTreeId = (String)paramsMap.get("OrgTreeID");
        String orgUnitId = (String)paramsMap.get("OrgUnitID");
        String orgTreeNum = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo("select number where id ='" + orgTreeId + "'").getNumber();
        String orgUnitNum = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo("select number where id ='" + orgUnitId + "'").getNumber();
        int year = (Integer)paramsMap.get("Year");
        int period = (Integer)paramsMap.get("Period");
        int periodType = (Integer)paramsMap.get("PeriodType");
        int elimType = (Integer)paramsMap.get("elimType");
        String token = (String)paramsMap.get("token");
        sql.append("select 1 from T_CSL_CheckageLimitAoumt where FOrgTreeNumber = ?", (Object)orgTreeNum).append(" And FOrgUnitNumber = ? ", (Object)orgUnitNum).append(" And FPeriodType = ? ", (Object)periodType).append(" And Fyear = ? ", (Object)year).append(" And FPeriod = ? ", (Object)period).append(" And FElimType = ? ", (Object)elimType);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        java.sql.Date updateTime = new java.sql.Date(new Date().getTime());
        BigDecimal limitAmount = (BigDecimal)paramsMap.get("Value");
        if (limitAmount == null) {
            limitAmount = CslConstant.BGZERO;
        }
        if (rs.size() > 0) {
            String excSql = "update T_CSL_CheckageLimitAoumt set FLimitAmount = ?,FToken = ?,FLastUpdateUserID = ?, FLastUpdateTime = ? where FOrgTreeNumber = ? AND FOrgUnitNumber = ? And Fyear = ? And FPeriod = ? And FPeriodType = ? and FElimType = ? ";
            DbUtil.execute((Context)ctx, (String)excSql, (Object[])new Object[]{limitAmount, token, userId, updateTime, orgTreeNum, orgUnitNum, year, period, periodType, elimType});
        } else {
            String excSql = "insert into T_CSL_CheckageLimitAoumt(FOrgTreeNumber,FOrgUnitNumber,FYear,Fperiod,FPeriodType,FlimitAmount,FToken,FLastUpdateUserID,FLastUpdateTime,FElimType) values(?,?,?,?,?,?,?,?,?,?)";
            DbUtil.execute((Context)ctx, (String)excSql, (Object[])new Object[]{orgTreeNum, orgUnitNum, year, period, periodType, limitAmount, token, userId, updateTime, elimType});
        }
    }

    @Override
    protected String _batchDetele(Context ctx, ElimTypeEnum elimType, List idList) throws BOSException, EASBizException {
        StringBuffer tips = new StringBuffer();
        CommonTable common = new CommonTable(elimType);
        SQLBuilder sbSQL = this.getRule1Or2SQL(common, CheckedStatusEnum.AUDITED, idList);
        String resKey = "156_auditRowCanNotDelete";
        ArrayList<String> exeList = new ArrayList<String>();
        this.collectCheckRuleTips(ctx, sbSQL, exeList, resKey, null, null, tips, common);
        idList.removeAll(exeList);
        if (idList.size() > 0) {
            sbSQL = new SQLBuilder();
            sbSQL.append("delete from ").append(common.getMasterTable()).append(" \r\n");
            sbSQL.append(" Where FID IN ", (Collection)idList).append(" \r\n");
            sbSQL.append(" and FCheckedStatus <> 2 \r\n");
            DbUtil.execute((Context)ctx, (String)sbSQL.getSQL(), (Object[])sbSQL.getParams());
        }
        return tips.toString();
    }

    @Override
    protected void _batchUpdataStatus(Context ctx, Collection ids, ElimTypeEnum elimType, CheckageConfirmEnum status) throws BOSException, EASBizException {
        if (ids != null && !ids.isEmpty()) {
            CommonTable common = new CommonTable(elimType);
            SQLBuilder sql = new SQLBuilder();
            sql.append(" Update ").append(common.getMasterTable()).append(" \r\n");
            sql.append(" set FCheckedStatus = ").append((Object)status.getValue()).append(" \r\n");
            if (CheckageConfirmEnum.UnConfirm.equals((Object)status)) {
                sql.append(" ,FAuditorID = null \r\n ");
                sql.append(" ,FAuditDate = null \r\n  ");
                sql.append(",FAssessorID = null \r\n");
                sql.append(",FAssessDate = null \r\n");
            }
            sql.append(" Where FID in ", ids);
            DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
            sql.reset();
            sql.append(" UPDATE T_CSL_InterItemData SET FCheckageStatus =? ", (Object)status.getValue());
            sql.append(" WHERE FCheckageRecord in ", ids).append(" \r\n");
            DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        }
    }

    static interface IValidated {
        public boolean isValidated(Context var1, IRowSet var2) throws BOSException, EASBizException;
    }

    public class EntriesSort
    implements Comparator {
        public int compare(Object arg0, Object arg1) {
            String sort1 = null;
            String sort2 = null;
            String seq1 = null;
            String seq2 = null;
            try {
                HashMap e1 = (HashMap)arg0;
                HashMap e2 = (HashMap)arg1;
                seq1 = ((Integer)e1.get("seq")).toString().length() == 1 ? "0" + ((Integer)e1.get("seq")).toString() : ((Integer)e1.get("seq")).toString();
                seq2 = ((Integer)e2.get("seq")).toString().length() == 1 ? "0" + ((Integer)e2.get("seq")).toString() : ((Integer)e2.get("seq")).toString();
                sort1 = (String)e1.get("companyid") + "!" + seq1;
                sort2 = (String)e2.get("companyid") + "!" + seq2;
            }
            catch (Exception ex) {
                logger.error((Object)"EntriesSort_Exception", (Throwable)ex);
                return 0;
            }
            return sort1.compareTo(sort2);
        }
    }

    class checkageManager {
        private static final String KINGDEE_TOKEN = "!";
        boolean _isByCompany = false;
        String _companyId = null;
        String _targetCompanyId = null;
        HashMap _parent = new HashMap();
        HashMap _maxNumber = new HashMap();
        Context _ctx = null;
        List checkageSet = null;
        Map _param = null;
        HashMap _mTemplet = null;
        HashMap<String, Integer> _mTempletCheckedParty = new HashMap();
        HashMap _mRelationMoney = null;
        HashMap _mChecked = new HashMap();
        HashMap _mSingleDC = new HashMap();
        Set<String> _sCheckData = new HashSet<String>();
        Map<String, LimitAmountInfo> _mLimitAmount = null;
        String _masterTable = null;
        String _entryTable = null;
        String _creatorId = null;
        Timestamp _createTime = null;
        String _itemdataTable = null;
        String _currentlongNumber = null;
        int _currentlevel = 0;
        int _mergeType = 0;
        String elimOrgUnitsTable = null;
        List<String> clearCompanys = new ArrayList<String>();

        public checkageManager(Context ctx, Map param) throws EASBizException, BOSException {
            this.initParam(ctx, param);
            this.checkBusinessRule();
            this.setTempletMap();
            this.setCheckedMap(true);
        }

        private void checkBusinessRule() throws InterCheckException {
            if (this._param.get("elimType") != ElimTypeEnum.ComeAndGo && this._param.get("elimType") != ElimTypeEnum.exchange && this._param.get("elimType") != ElimTypeEnum.exchange) {
                throw new InterCheckException(InterCheckException.ERROR_ELIMTYPE);
            }
        }

        private void initParam(Context ctx, Map param) throws BOSException, EASBizException {
            this._param = param;
            this._isByCompany = (Boolean)this._param.get("isByCompany");
            this._ctx = ctx;
            if (this._isByCompany) {
                this._param.put("orgTreeId", (String)this._param.get("orgTreeId"));
                this._param.put("orgUnitId", InterCheckControllerBean.this.getUnitIdByLoginOrg(this._ctx, (String)this._param.get("orgTreeId")));
            }
            this._companyId = (String)this._param.get("companyId");
            this._mergeType = (Integer)this._param.get("mergeType");
            IRowSet rs = null;
            StringBuffer sbSQL = new StringBuffer("Select struct.FLongNumber,struct.FLevel,tree.fnumber treeNumber,unit.fnumber unitNumber ");
            sbSQL.append(" from t_org_structure struct ");
            sbSQL.append(" inner join t_org_tree tree on tree.fid=struct.ftreeid ");
            sbSQL.append(" inner join t_org_baseunit unit on unit.fid=struct.FUnitId ");
            sbSQL.append(" Where struct.FUnitId = '").append(param.get("orgUnitId")).append("'");
            sbSQL.append(" And struct.FTreeId = '").append(param.get("orgTreeId")).append("'");
            try {
                rs = DbUtil.executeQuery((Context)this._ctx, (String)sbSQL.toString());
                if (rs.next()) {
                    this._currentlongNumber = rs.getString("FLongNumber");
                    this._currentlevel = rs.getInt("FLevel");
                    String treeNumber = rs.getString("treeNumber");
                    String unitNumber = rs.getString("unitNumber");
                    this.elimOrgUnitsTable = SameControlUtil.getElimOrgUnitsTable((Context)ctx, (String)((String)param.get("orgTreeId")), (String)((String)param.get("orgUnitId")), (String)this._currentlongNumber, (String)unitNumber, (String)treeNumber, this.clearCompanys, (int)((Integer)this._param.get("year")), (int)((Integer)this._param.get("period")), (int)((Integer)this._param.get("periodType")), (int)this._currentlevel, (ElimTypeEnum)((ElimTypeEnum)((Object)this._param.get("elimType"))), (int)this._mergeType, (boolean)this._isByCompany);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }

        public String deleteCheckData() throws BOSException {
            ArrayList templateList;
            Object masterIds = null;
            SQLBuilder builder = new SQLBuilder();
            builder.append("SELECT DISTINCT t1.FId FROM ");
            builder.append(this.getMasterTableName()).append(" t1,").append(this.getEntriesTableName()).append(" t2");
            builder.append(" WHERE t1.FId = t2.FCheckageId");
            builder.append("   AND t1.FOrgBoundID = '").append(this._param.get("orgTreeId")).append("'");
            if (!this._isByCompany) {
                builder.append(" AND t1.FOrgUnitID = '").append(this._param.get("orgUnitId")).append("'");
            } else {
                if (this._targetCompanyId == null) {
                    builder.append(" AND (t2.FCompanyId =? ", (Object)this._companyId);
                    builder.append("  OR t2.FTargetCompanyId =?", (Object)this._companyId).append(") \r\n");
                } else {
                    builder.append(" AND ((t2.FCompanyId =?", (Object)this._companyId).append(" And t2.FTargetCompanyId =?", (Object)this._targetCompanyId).append(") \r\n");
                    builder.append(" OR ((t2.FCompanyId =?", (Object)this._targetCompanyId).append(" And t2.FTargetCompanyId =?", (Object)this._companyId).append(")) \r\n");
                }
                SameControlUtil.buildClearCompanySql((Object)builder, this.clearCompanys, (String)"t2", (ElimTypeEnum)((ElimTypeEnum)((Object)this._param.get("elimType"))));
            }
            if (this._param.get("solutionNumber") != null && (templateList = (ArrayList)this._param.get("templateList")) != null && templateList.size() > 0) {
                builder.append(" and t1.FTempletID in (");
                for (int i = 0; i < templateList.size(); ++i) {
                    builder.append("'").append(templateList.get(i).toString()).append("'");
                    if (i == templateList.size() - 1) continue;
                    builder.append(",");
                }
                builder.append(") ");
            }
            builder.append(" and t1.FPeriodType =?", this._param.get("periodType"));
            builder.append(" and t1.FYear = ?", this._param.get("year"));
            builder.append(" and t1.FPeriod =?", this._param.get("period"));
            builder.append(" and t1.FCheckedStatus = 1");
            String dataCollectNumber = (String)this._param.get("dataCollectNumber");
            if (!StringUtils.isEmpty((String)dataCollectNumber)) {
                builder.append(" and t1.FDataCollectNumber = ?", (Object)dataCollectNumber);
            }
            IRowSet rs = DbUtil.executeQuery((Context)this._ctx, (String)builder.getSQL(), (Object[])builder.getParams());
            Connection cn = null;
            PreparedStatement ps = null;
            PreparedStatement ps1 = null;
            try {
                cn = EJBFactory.getConnection((Context)this._ctx);
                StringBuffer delSql = new StringBuffer();
                delSql.append(" DELETE FROM ").append(this.getEntriesTableName());
                delSql.append("  WHERE FCheckageId = ?");
                ps = cn.prepareStatement(delSql.toString());
                StringBuffer delSQL = new StringBuffer();
                delSQL.append("DELETE FROM ").append(this.getMasterTableName());
                delSQL.append(" WHERE FId = ?");
                ps1 = cn.prepareStatement(delSQL.toString());
                boolean isExecute = false;
                while (rs.next()) {
                    isExecute = true;
                    String id = rs.getString("fid");
                    ps.setString(1, id);
                    ps1.setString(1, id);
                    ps.addBatch();
                    ps1.addBatch();
                }
                if (isExecute) {
                    ps.executeBatch();
                    ps1.executeBatch();
                }
            }
            catch (SQLException e) {
                try {
                    throw new SQLDataException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps1);
                    SQLUtils.cleanup(ps, (Connection)cn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)ps1);
            SQLUtils.cleanup((Statement)ps, (Connection)cn);
            return null;
        }

        private Map<Object, Object> getSugerMap() {
            HashMap<Object, Object> paramMap = new HashMap<Object, Object>();
            paramMap.put("OrgTreeID", this._param.get("orgTreeId"));
            if (!this._isByCompany) {
                paramMap.put("OrgUnitID", this._param.get("orgUnitId"));
            }
            paramMap.put("Year", this._param.get("year"));
            paramMap.put("Period", this._param.get("period"));
            paramMap.put("PeriodType", this._param.get("periodType"));
            paramMap.put("elimType", ((ElimTypeEnum)((Object)this._param.get("elimType"))).getValue());
            return paramMap;
        }

        public void buildCheckage() throws BOSException, EASBizException {
            try {
                if (this._param.get("elimType").equals((Object)ElimTypeEnum.exchange)) {
                    this.setExchItemAndRelationMap();
                } else {
                    this.setItemAndRelationMap();
                }
            }
            finally {
                if (!DebugLogger.isDebug && this.elimOrgUnitsTable != null) {
                    TempTablePool.getInstance((Context)this._ctx).releaseTable(this.elimOrgUnitsTable);
                }
            }
            if (this._mRelationMoney == null) {
                return;
            }
            Set currencySet = this._mRelationMoney.keySet();
            Set splitSet = null;
            ArrayList relationLst = null;
            ArrayList templetLst = null;
            Iterator it = currencySet.iterator();
            Iterator splitIt = null;
            Iterator relationIt = null;
            Iterator templetIt = null;
            String currencyId = null;
            String relation2 = null;
            String templetId = null;
            HashMap relationMoneyMap2 = null;
            Checkage checkage = null;
            if (this._mTemplet == null) {
                return;
            }
            if (this._mTemplet.keySet() == null) {
                return;
            }
            this._mLimitAmount = InterCheckControllerBean.this.getLimitAmount(this._ctx, this.getSugerMap());
            ArrayList templetidLst = new ArrayList(this._mTemplet.keySet());
            Map itemRelaMap = EliminationItemMapFactory.getLocalInstance(this._ctx).getBatchItemMapByTempleIds(templetidLst);
            boolean isCheckedInterExchReport = CSLParamUtil.isCheckInterExchRptIsCheckage(this._ctx);
            while (it.hasNext()) {
                currencyId = (String)it.next();
                if (this._mRelationMoney.get(currencyId) == null) continue;
                splitSet = (Set)this._mRelationMoney.get(currencyId);
                for (HashMap relationMoneyMap2 : splitSet) {
                    relationLst = new ArrayList(relationMoneyMap2.keySet());
                    Collections.sort(relationLst);
                    block5: for (String relation2 : relationLst) {
                        templetLst = new ArrayList(this._mTemplet.keySet());
                        Collections.sort(templetLst);
                        templetIt = templetLst.iterator();
                        int singleDC = 0;
                        while (templetIt.hasNext()) {
                            templetId = (String)templetIt.next();
                            singleDC = (Integer)this._mSingleDC.get(templetId);
                            if (this.checkageSet == null) {
                                this.checkageSet = new ArrayList();
                            }
                            this.deleteHasAuditEntry((Map)relationMoneyMap2.get(relation2), templetId, currencyId);
                            if (relationMoneyMap2.get(relation2) == null && ((Map)relationMoneyMap2.get(relation2)).size() == 0) continue block5;
                            CoreBaseCollection cc = (CoreBaseCollection)itemRelaMap.get(templetId);
                            checkage = this.constructureCheckage(currencyId, relation2, templetId, relationMoneyMap2, singleDC, cc, true);
                            if (checkage.isValidCheckage() && checkage.isUnlimitAmount(this._mLimitAmount)) {
                                this.checkageSet.add(checkage);
                                checkage.setCheckedInterExchReport(isCheckedInterExchReport);
                            }
                            if (checkage.isSameCompany() || checkage.getSingleDC() == 1 || this._mTempletCheckedParty.get(templetId) == 0 || !(checkage = this.constructureCheckage(currencyId, relation2, templetId, relationMoneyMap2, singleDC, cc, false)).isValidCheckage() || !checkage.isUnlimitAmount(this._mLimitAmount)) continue;
                            this.checkageSet.add(checkage);
                            checkage.setCheckedInterExchReport(isCheckedInterExchReport);
                        }
                    }
                }
            }
        }

        private void deleteHasAuditEntry(Map moneyMap, String templetId, String currencyId) {
            if (moneyMap == null || moneyMap.size() <= 0) {
                return;
            }
            ArrayList<String> delKeys = new ArrayList<String>();
            StringBuffer key = new StringBuffer();
            Iterator<Object> it = moneyMap.keySet().iterator();
            while (it.hasNext()) {
                key.setLength(0);
                String originalKey = (String)it.next();
                key.append(templetId).append(KINGDEE_TOKEN);
                key.append(this._mSingleDC.get(templetId)).append(KINGDEE_TOKEN);
                key.append(currencyId).append(KINGDEE_TOKEN);
                key.append(originalKey);
                String surgeKey = key.toString().substring(0, key.toString().lastIndexOf(KINGDEE_TOKEN));
                if (!this._mChecked.containsKey(surgeKey)) continue;
                delKeys.add(originalKey);
            }
            it = delKeys.iterator();
            while (it.hasNext()) {
                moneyMap.remove(it.next());
            }
        }

        private Checkage constructureCheckage(String currencyId, String relation, String templetId, HashMap relationMoneyMap, int singleDC, CoreBaseCollection cc, boolean isADebitToBCredit) {
            int checkedParty = this._mTempletCheckedParty.get(templetId);
            Checkage checkage = singleDC == 1 || 0 == checkedParty ? new Checkage(this._param, this._parent, this._maxNumber, currencyId, relation, (HashSet)this._mTemplet.get(templetId), (HashMap)relationMoneyMap.get(relation), singleDC, cc) : new Checkage(this._param, this._parent, this._maxNumber, currencyId, relation, (HashSet)this._mTemplet.get(templetId), (HashMap)relationMoneyMap.get(relation), singleDC, cc, isADebitToBCredit, checkedParty);
            checkage.setMasterTableName(this.getMasterTableName());
            checkage.setEntryTableName(this.getEntriesTableName());
            checkage.setCreatorId(this.getCreatorId());
            checkage.setCreateTime(this.getCreateTime());
            checkage.setOrgBoundId((String)this._param.get("orgTreeId"));
            if (!this._isByCompany) {
                checkage.setOrgUnitId((String)this._param.get("orgUnitId"));
            }
            return checkage;
        }

        private String getItemDataTableName() {
            if (this._itemdataTable == null) {
                this._itemdataTable = this._param.get("elimType").equals((Object)ElimTypeEnum.ComeAndGo) ? "T_CSL_InterItemData" : "T_CSL_ExchItemData";
            }
            return this._itemdataTable;
        }

        private String getMasterTableName() {
            if (this._masterTable == null) {
                this._masterTable = this._param.get("elimType").equals((Object)ElimTypeEnum.ComeAndGo) ? "T_CSL_InterDataCheckage" : "T_CSL_ExchCheckage";
            }
            return this._masterTable;
        }

        private String getEntriesTableName() {
            if (this._entryTable == null) {
                this._entryTable = this._param.get("elimType").equals((Object)ElimTypeEnum.ComeAndGo) ? "T_CSL_DataCheckageEntry" : "T_CSL_ExchCheckageEntry";
            }
            return this._entryTable;
        }

        private String getCreatorId() {
            if (this._creatorId == null) {
                this._creatorId = this._ctx.getCaller().toString();
            }
            return this._creatorId;
        }

        private Timestamp getCreateTime() {
            if (this._createTime == null) {
                this._createTime = new Timestamp(System.currentTimeMillis());
            }
            return this._createTime;
        }

        public void executeInsert() throws BOSException, EASBizException {
            HashMap<String, Uuid> mutexCompanyIds;
            IMutexServiceControl imc;
            PreparedStatement stmt;
            Connection conn;
            block20: {
                conn = null;
                stmt = null;
                HashMap<String, List> entry = null;
                imc = null;
                mutexCompanyIds = null;
                try {
                    conn = InterCheckControllerBean.this.getConnection(this._ctx);
                    if (this.checkageSet == null) {
                        return;
                    }
                    int number = InterCheckControllerBean.this.getCurrentCheckageMaxNumber(this._ctx, (String)this._param.get("orgTreeId"), (String)this._param.get("orgUnitId"), (Integer)this._param.get("periodType"), (Integer)this._param.get("year"), (Integer)this._param.get("period"), this.getMasterTableName());
                    Checkage checkage2 = null;
                    String master = null;
                    StringBuffer sbInsert = new StringBuffer(" INSERT INTO ").append(this.getMasterTableName());
                    sbInsert.append("  (fid,fnumber,fcreatorid,fcreatetime,fcheckedstatus,felimstatus, \r\n");
                    sbInsert.append("  ftempletid,fcurrencyid,fyear,fperiod,forgboundid,forgUnitId,fdiffvalue, \r\n");
                    sbInsert.append("  fdiffmode,fperiodtype,fSingleDC,fdescription,FDataCollectNumber,FCheckedParty,FIsOldData,FLimitAmount, FFastMergeSoluId)");
                    sbInsert.append("  VALUES  \r\n");
                    sbInsert.append(" (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    master = sbInsert.toString();
                    stmt = conn.prepareStatement(master);
                    ArrayList numberList = new ArrayList();
                    entry = new HashMap<String, List>();
                    if (this._isByCompany) {
                        imc = MutexServiceControlFactory.getLocalInstance((Context)this._ctx);
                        mutexCompanyIds = new HashMap<String, Uuid>();
                        this.removeLockedAndChecked(mutexCompanyIds, imc);
                    }
                    for (Checkage checkage2 : this.checkageSet) {
                        if (checkage2.isZeroAllEntriesMoney()) continue;
                        checkage2.setId(checkage2.getBOSId());
                        if (!this._isByCompany) {
                            checkage2.setHeadNumber(number);
                        } else {
                            checkage2.setHeadNumber(this.getNumberNoDup(numberList, number));
                        }
                        checkage2.setDataCollectNumber((String)this._param.get("dataCollectNumber"));
                        if (this._param.get("elimType") == ElimTypeEnum.exchange) {
                            checkage2.getExchEntriesInsertSQL(entry);
                        } else {
                            checkage2.getEntriesInsertSQL(entry);
                        }
                        if (StringUtils.isEmpty((String)master) || entry.isEmpty()) continue;
                        ++number;
                        checkage2.getMasterParam(stmt);
                        stmt.addBatch();
                    }
                    stmt.executeBatch();
                    if (!entry.isEmpty()) {
                        for (String sql : entry.keySet()) {
                            DbUtil.executeBatch((Context)this._ctx, (String)sql, (List)((List)entry.get(sql)));
                        }
                    }
                    if (entry == null) break block20;
                    entry.clear();
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
                finally {
                    if (entry != null) {
                        entry.clear();
                    }
                    SQLUtils.cleanup(stmt, (Connection)conn);
                    if (mutexCompanyIds != null && !mutexCompanyIds.isEmpty()) {
                        for (Uuid request : mutexCompanyIds.values()) {
                            imc.releaseMutex(request);
                        }
                        mutexCompanyIds.clear();
                    }
                }
            }
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
            if (mutexCompanyIds != null && !mutexCompanyIds.isEmpty()) {
                for (Uuid request : mutexCompanyIds.values()) {
                    imc.releaseMutex(request);
                }
                mutexCompanyIds.clear();
            }
        }

        private void removeLockedAndChecked(HashMap<String, Uuid> mutexCompanyIds, IMutexServiceControl imc) throws BOSException, EASBizException {
            if (this._isByCompany) {
                Checkage checkage = null;
                for (int i = this.checkageSet.size() - 1; i >= 0; --i) {
                    checkage = (Checkage)this.checkageSet.get(i);
                    if (this.isCanInsert(checkage, mutexCompanyIds, imc)) continue;
                    this.checkageSet.remove(i);
                }
                this.setCheckedMap(false);
                if (!this._sCheckData.isEmpty()) {
                    StringBuffer key = new StringBuffer();
                    StringBuffer auditKey = new StringBuffer();
                    for (int i = this.checkageSet.size() - 1; i >= 0; --i) {
                        checkage = (Checkage)this.checkageSet.get(i);
                        List entries = checkage.getEntries();
                        String currencyId = checkage.getCurrencyId();
                        String templetId = checkage.getTempletId();
                        if (entries == null || entries.isEmpty()) continue;
                        key.setLength(0);
                        key.append(templetId);
                        Map entry = (Map)entries.get(0);
                        String companyId = (String)entry.get("companyid");
                        String tarCompanyId = (String)entry.get("targetcompanyid");
                        key.append(currencyId);
                        if (checkage.getCheckedParty() == 0) {
                            if (companyId.compareTo(tarCompanyId) > 0) {
                                key.append(companyId).append(tarCompanyId);
                            } else {
                                key.append(tarCompanyId).append(companyId);
                            }
                        } else {
                            int dc = (Integer)entry.get("dc");
                            auditKey.setLength(0);
                            auditKey.append(key);
                            auditKey.append(companyId).append(tarCompanyId).append(dc);
                            if (this._sCheckData.contains(auditKey.toString())) {
                                this.checkageSet.remove(i);
                                continue;
                            }
                            key.append(tarCompanyId).append(companyId).append(dc == 1 ? 0 : 1);
                        }
                        if (!this._sCheckData.contains(key.toString())) continue;
                        this.checkageSet.remove(i);
                    }
                    this._sCheckData.clear();
                }
            }
        }

        private boolean isCanInsert(Checkage checkage, HashMap<String, Uuid> mutexNames, IMutexServiceControl imc) {
            block6: {
                List entries;
                if (this._isByCompany && (entries = checkage.getEntries()) != null && !entries.isEmpty()) {
                    try {
                        String orgTreeId = (String)this._param.get("orgTreeId");
                        String periodType = String.valueOf(this._param.get("periodType"));
                        String year = String.valueOf(this._param.get("year"));
                        String period = String.valueOf(this._param.get("period"));
                        Map entry = (Map)entries.get(0);
                        String companyId = (String)entry.get("companyid");
                        String tarCompanyId = (String)entry.get("targetcompanyid");
                        String currencyId = checkage.getCurrencyId();
                        StringBuffer mutexName = new StringBuffer();
                        mutexName.append(currencyId);
                        if (companyId.compareTo(tarCompanyId) > 0) {
                            mutexName.append(companyId).append(tarCompanyId);
                        } else {
                            mutexName.append(tarCompanyId).append(companyId);
                        }
                        mutexName.append(orgTreeId).append(periodType).append(year).append(period);
                        mutexName.append(((ElimTypeEnum)((Object)this._param.get("elimType"))).getValue());
                        if (mutexNames.containsKey(mutexName.toString())) break block6;
                        Uuid requestId = Uuid.create();
                        if (CslRptUtil.requestCheckControlLock(imc, requestId, "interExchCheck", mutexName.toString())) {
                            mutexNames.put(mutexName.toString(), requestId);
                            break block6;
                        }
                        return false;
                    }
                    catch (Exception ex) {
                        logger.error((Object)"isCanInsert error.", (Throwable)ex);
                        return false;
                    }
                }
            }
            return true;
        }

        private int getNumberNoDup(List numberList, int currNumber) {
            int noDupNumber = currNumber;
            while (numberList.contains(new Integer(noDupNumber))) {
                ++noDupNumber;
            }
            if (!numberList.contains(new Integer(noDupNumber))) {
                numberList.add(new Integer(noDupNumber));
            }
            return noDupNumber;
        }

        public void updateItemDataTable(Map param) throws BOSException {
            String sltSQL = this.createCheckageDataSQL(param);
            IRowSet rs = DbUtil.executeQuery((Context)this._ctx, (String)sltSQL);
            try {
                StringBuffer updSQL = new StringBuffer(" UPDATE ").append(this.getItemDataTableName()).append(" SET FCheckageRecord = ? \r\n ");
                updSQL.append(" WHERE FPeriodType = ?  \r\n ");
                updSQL.append(" AND FYear = ?  \r\n");
                updSQL.append(" AND FPeriod = ?  \r\n");
                updSQL.append(" AND FTargetCurrencyId = ?  \r\n");
                updSQL.append(" AND FCompanyId = ?  \r\n");
                updSQL.append(" AND FTargetCompanyId = ? \r\n");
                if (!this._isByCompany) {
                    updSQL.append(" AND FCommitStatus = ? ");
                    updSQL.append(" AND FOrgBoundId=? ");
                } else {
                    updSQL.append(" AND FCommitStatus > ").append(1);
                }
                updSQL.append(" AND FDataCollectNumber = ? \r\n");
                updSQL.append(" AND FItemNumber IN (");
                updSQL.append("\t\t\tSELECT i.FNumber                                          \t        \n");
                updSQL.append("  \t\t\tFROM T_CSL_ElimTempletEntry tempEntry                              \n");
                updSQL.append("  \t\t\tJOIN T_CSL_RptItem i ON i.FId = tempEntry.FItemId                 \t\n");
                updSQL.append(" \t\t\tWHERE tempEntry.FTempletId =? )         \n");
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                while (rs.next()) {
                    String checkId = rs.getString("FID");
                    String orgBoundId = rs.getString("FOrgTreeID");
                    int periodType = rs.getInt("FPeriodType");
                    int year = rs.getInt("FYear");
                    int period = rs.getInt("FPeriod");
                    String currencyId = rs.getString("FCurrencyID");
                    String companyId = rs.getString("FCompanyID");
                    String targetCompanyId = rs.getString("FTargetCompanyID");
                    int commitStatus = 3;
                    String dataCollectNumber = rs.getString("FDataCollectNumber");
                    Object[] params = null;
                    params = !this._isByCompany ? new Object[11] : new Object[9];
                    int index = 0;
                    params[index++] = checkId;
                    params[index++] = periodType;
                    params[index++] = year;
                    params[index++] = period;
                    params[index++] = currencyId;
                    params[index++] = companyId;
                    params[index++] = targetCompanyId;
                    if (!this._isByCompany) {
                        params[index++] = commitStatus;
                        params[index++] = orgBoundId;
                    }
                    params[index++] = dataCollectNumber;
                    params[index++] = rs.getString("FTempletId");
                    paramsList.add(params);
                }
                if (!paramsList.isEmpty()) {
                    DbUtil.executeBatch((Context)this._ctx, (String)updSQL.toString(), paramsList);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }

        private String createTempletFilterSql(String templetId) {
            StringBuffer buffer = new StringBuffer(500);
            buffer.append("SELECT i.FNumber                                          \t        \n");
            buffer.append("  FROM T_CSL_ElimTempletEntry tempEntry                              \n");
            buffer.append("  JOIN T_CSL_RptItem i ON i.FId = tempEntry.FItemId                 \t\n");
            buffer.append(" WHERE tempEntry.FTempletId ='").append(templetId).append("'         \n");
            return buffer.toString();
        }

        private String createCheckageDataSQL(Map param) {
            StringBuffer sltSQL = new StringBuffer(500);
            sltSQL.append(" SELECT distinct chck.FID,       \n");
            sltSQL.append(" chck.FOrgBoundId As FOrgTreeId, \n");
            sltSQL.append(" chck.FPeriodType, chck.FYear, chck.FPeriod, chck.FCurrencyID,     \n");
            sltSQL.append(" entry.FCompanyID, entry.FTargetCompanyID,chck.FDataCollectNumber, chck.FTempletId  \n");
            sltSQL.append(" FROM ").append(this.getMasterTableName()).append(" chck           \n");
            sltSQL.append(" INNER JOIN ").append(this.getEntriesTableName()).append(" entry ON chck.FID = entry.FCheckageID \n");
            sltSQL.append(" INNER JOIN T_CSL_RptItem item ON item.FId=entry.FItemId \n");
            sltSQL.append(" WHERE exists( \n");
            sltSQL.append(this.getExistsSQL(param));
            sltSQL.append(" ) \n");
            sltSQL.append(" And chck.FDataCollectNumber = '").append(param.get("dataCollectNumber")).append("' \n");
            sltSQL.append(" And chck.FOrgBoundId = '").append(param.get("orgTreeId")).append("' \n");
            if (!this._isByCompany) {
                sltSQL.append(" And chck.FOrgUnitId = '").append(param.get("orgUnitId")).append("' \n");
            } else if (this._targetCompanyId == null) {
                sltSQL.append(" And (entry.FCompanyId='").append(this._companyId).append("' or entry.FTargetCompanyId='").append(this._companyId).append("')");
            } else {
                sltSQL.append(" And ((entry.FCompanyId='").append(this._companyId).append("' and entry.FTargetCompanyId='").append(this._targetCompanyId).append("')");
                sltSQL.append(" or (entry.FCompanyId='").append(this._targetCompanyId).append("' and entry.FTargetCompanyId='").append(this._companyId).append("'))");
            }
            if (this._param.get("solutionNumber") != null) {
                ArrayList templateList = new ArrayList();
                templateList = (ArrayList)this._param.get("templateList");
                if (templateList != null && templateList.size() > 0) {
                    sltSQL.append(" and chck.FTempletID in (");
                    for (int i = 0; i < templateList.size(); ++i) {
                        sltSQL.append("'").append(templateList.get(i).toString()).append("'");
                        if (i == templateList.size() - 1) continue;
                        sltSQL.append(",");
                    }
                    sltSQL.append(") ");
                }
            }
            sltSQL.append(" and chck.FYear=").append((Integer)param.get("year"));
            sltSQL.append(" and chck.FPeriod=").append((Integer)param.get("period"));
            sltSQL.append(" and chck.FPeriodtype=").append((Integer)param.get("periodType"));
            sltSQL.append(" order by entry.FCompanyID, entry.FTargetCompanyID,chck.FTempletId,chck.FID \n");
            return sltSQL.toString();
        }

        private String getExistsSQL(Map param) {
            StringBuffer sql = new StringBuffer(200);
            sql.append(" Select 'X' From ").append(this.getItemDataTableName()).append(" data \n");
            if (!this._isByCompany) {
                sql.append(" Join T_CSL_RptReceived rec ON data.FReport = rec.FReportID \n");
            }
            sql.append(" WHERE ").append(" data.FPeriodType = chck.FPeriodType \n").append(" And data.FYear = chck.FYear \n").append(" And data.FPeriod = chck.FPeriod \n").append(" And data.FTargetCurrencyID = chck.FCurrencyID \n").append(" And data.FCompanyID = entry.FCompanyID \n").append(" And data.FTargetCompanyId = entry.FTargetCompanyId \n").append(" And data.FMoney<>0 \n").append(" And data.FYear=").append((Integer)param.get("year")).append(" And data.FPeriod=").append((Integer)param.get("period")).append(" And data.FPeriodtype=").append((Integer)param.get("periodType"));
            if (!this._isByCompany) {
                sql.append(" And data.FCommitStatus = 3 \n");
                sql.append(" And rec.FOrgTreeId = '").append(param.get("orgTreeId")).append("' \n");
            } else {
                sql.append(" And data.FCommitStatus > 1 \n");
            }
            return sql.toString();
        }

        private void setCheckedMap(boolean isAudited) throws BOSException {
            StringBuffer sbSQL = new StringBuffer();
            String dataCollectNumber = (String)this._param.get("dataCollectNumber");
            if (!this._isByCompany) {
                sbSQL.append(" select t1.FCurrencyId,t2.FCompanyId,t2.FTargetCompanyId, \r\n");
                sbSQL.append(" t1.FTempletId,t1.FSingleDC, \r\n");
                sbSQL.append(" t1.FCheckedParty FCheckedParty, \r\n");
                sbSQL.append(" case when t2.fcompanyid>t2.ftargetcompanyid \r\n");
                sbSQL.append(" THEN t2.fcompanyid || '!' ||t2.ftargetcompanyid \r\n");
                sbSQL.append(" ELSE t2.ftargetcompanyid || '!' || t2.fcompanyid \r\n");
                sbSQL.append(" end As FTag, \r\n");
                sbSQL.append(" item.Fnumber itemNum,t2.FDataElement ");
                sbSQL.append(" From ").append(this.getMasterTableName()).append(" t1,");
                sbSQL.append(this.getEntriesTableName()).append(" t2 \r\n");
                sbSQL.append(" ,T_CSL_RptItem item  \n");
                sbSQL.append(" WHERE t1.fid=t2.fcheckageid \r\n");
                sbSQL.append(" AND item.FID = t2.FItemID");
                sbSQL.append(" AND t1.fcheckedstatus in(0,2)");
                sbSQL.append(" AND t1.FOrgBoundId='").append(this._param.get("orgTreeId")).append("'");
                sbSQL.append(" AND (t1.FOrgUnitId IS NULL OR t1.FOrgUnitId='").append(this._param.get("orgUnitId")).append("')");
                sbSQL.append(" AND t1.FPeriodType=").append(this._param.get("periodType"));
                sbSQL.append(" AND t1.FYear = ").append(this._param.get("year"));
                sbSQL.append(" AND t1.FPeriod = ").append(this._param.get("period"));
                if (dataCollectNumber != null && dataCollectNumber.length() != 0) {
                    sbSQL.append(" AND t1.FDataCollectNumber = '").append(dataCollectNumber).append("'");
                }
            } else {
                if (isAudited) {
                    sbSQL.append(" select t1.FCurrencyId,t2.FCompanyId, \r\n");
                    sbSQL.append(" t2.FTargetCompanyId,t1.FTempletId,t1.FSingleDC, \r\n");
                    sbSQL.append(" item.Fnumber itemNum,t2.FDataElement ");
                } else {
                    sbSQL.append(" select distinct t1.FCurrencyId,t1.FTempletId,t2.FCompanyId, \r\n");
                    sbSQL.append(" t2.FTargetCompanyId,t1.fisolddata,item.fdc  \r\n");
                }
                sbSQL.append(" ,t1.FCheckedParty FCheckedParty ");
                sbSQL.append(" From ").append(this.getMasterTableName()).append(" t1,");
                sbSQL.append(this.getEntriesTableName()).append(" t2 \r\n");
                sbSQL.append(" ,T_CSL_RptItem item  \n");
                sbSQL.append(" WHERE t1.fid=t2.fcheckageid \r\n");
                sbSQL.append(" AND item.FID = t2.FItemID");
                if (isAudited) {
                    sbSQL.append(" AND t1.fcheckedstatus in(0,2)");
                }
                sbSQL.append(" AND t1.FOrgBoundId='").append(this._param.get("orgTreeId")).append("' \r\n");
                if (this._targetCompanyId != null) {
                    sbSQL.append(" and ((t2.fcompanyid='").append(this._companyId).append("' and t2.ftargetcompanyid='").append(this._targetCompanyId).append("') \r\n");
                    sbSQL.append(" or (t2.fcompanyid='").append(this._targetCompanyId).append("' and t2.ftargetcompanyid='").append(this._companyId).append("')) \r\n");
                } else {
                    sbSQL.append(" and (t2.fcompanyid='").append(this._companyId).append("' or t2.ftargetcompanyid='").append(this._companyId).append("') \r\n");
                }
                SameControlUtil.buildClearCompanySql((Object)sbSQL, this.clearCompanys, (String)"t2", (ElimTypeEnum)((ElimTypeEnum)((Object)this._param.get("elimType"))));
                sbSQL.append(" AND t1.FPeriodType=").append(this._param.get("periodType"));
                sbSQL.append(" AND t1.FYear = ").append(this._param.get("year"));
                sbSQL.append(" AND t1.FPeriod = ").append(this._param.get("period"));
                if (dataCollectNumber != null && dataCollectNumber.length() != 0) {
                    sbSQL.append(" AND t1.FDataCollectNumber = '").append(dataCollectNumber).append("'");
                }
            }
            if (this._param.get("solutionNumber") != null) {
                ArrayList templateList = new ArrayList();
                templateList = (ArrayList)this._param.get("templateList");
                if (templateList != null && templateList.size() > 0) {
                    sbSQL.append(" and t1.FTempletID in (");
                    for (int i = 0; i < templateList.size(); ++i) {
                        sbSQL.append("'").append(templateList.get(i).toString()).append("'");
                        if (i == templateList.size() - 1) continue;
                        sbSQL.append(",");
                    }
                    sbSQL.append(") ");
                }
            }
            try {
                IRowSet rsChecked = DbUtil.executeQuery((Context)this._ctx, (String)sbSQL.toString());
                while (rsChecked.next()) {
                    StringBuffer key = new StringBuffer();
                    String checkedPartyId = rsChecked.getString("FCheckedParty");
                    if (isAudited) {
                        key.append(rsChecked.getString("FTempletId")).append(KINGDEE_TOKEN);
                        key.append(this._mSingleDC.get(rsChecked.getString("FTempletId"))).append(KINGDEE_TOKEN);
                        key.append(rsChecked.getString("FCurrencyId")).append(KINGDEE_TOKEN);
                        key.append(rsChecked.getString("FCompanyId")).append(KINGDEE_TOKEN).append(rsChecked.getString("FTargetCompanyId"));
                        key.append(KINGDEE_TOKEN).append(rsChecked.getString("itemNum")).append(KINGDEE_TOKEN);
                        key.append(rsChecked.getString("FDataElement"));
                        this._mChecked.put(key.toString(), "");
                        continue;
                    }
                    if (!this._isByCompany) continue;
                    key.append(rsChecked.getString("FTempletID"));
                    key.append(rsChecked.getString("FCurrencyId"));
                    String companyId = rsChecked.getString("FCompanyId");
                    String targetCompanyId = rsChecked.getString("FTargetCompanyId");
                    int isolddata = rsChecked.getInt("fisolddata");
                    if (isolddata == 1) {
                        if (companyId.compareTo(targetCompanyId) > 0) {
                            key.append(companyId).append(targetCompanyId);
                        } else {
                            key.append(targetCompanyId).append(companyId);
                        }
                    } else {
                        int dc = rsChecked.getInt("fdc");
                        key.append(companyId).append(targetCompanyId).append(dc == 1 ? 0 : 1);
                    }
                    if (this._sCheckData.contains(key.toString())) continue;
                    this._sCheckData.add(key.toString());
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }

        private List setSpecifyTempletMap() throws Exception {
            ArrayList<String> temList = new ArrayList<String>();
            StringBuffer sbSQL2 = new StringBuffer();
            sbSQL2.append("select distinct s1.ftemnumber as templateNumber\n");
            sbSQL2.append(" from t_csl_interchecksolutionentry as s1 \r\n");
            sbSQL2.append(" inner join t_csl_interchecksolution as s2 \r\n");
            sbSQL2.append(" on s1.fchecksolutionid = s2.fid \r\n");
            sbSQL2.append(" where s2.fid = '").append(this._param.get("solutionId").toString()).append("' \r\n");
            sbSQL2.append(" and s1.ftemtype =" + ((ElimTypeEnum)((Object)this._param.get("elimType"))).getValue() + "");
            IRowSet rs = null;
            try {
                rs = DbUtil.executeQuery((Context)this._ctx, (String)sbSQL2.toString());
                while (rs.next()) {
                    temList.add(rs.getString("templateNumber").toString());
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            return temList;
        }

        private void setTempletMap() throws BOSException {
            StringBuffer sbSQL2 = new StringBuffer();
            sbSQL2.append(" select a.FId,ABS(count(*)-2) As FSingleDC From \r\n");
            sbSQL2.append(" (select distinct t1.FId,t1.Fname,t2.FDC \r\n");
            sbSQL2.append(" from t_csl_elimtemplet t1,t_csl_elimTempletEntry t2 \r\n");
            sbSQL2.append(" where t1.FId=t2.FTempletId");
            if (this._param.get("solutionNumber") != null) {
                List temList = new ArrayList();
                try {
                    temList = this.setSpecifyTempletMap();
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
                if (temList != null) {
                    sbSQL2.append(" and t1.fElimtype =" + ((ElimTypeEnum)((Object)this._param.get("elimType"))).getValue() + "");
                    sbSQL2.append(" and t1.FNumber in (");
                    for (int i = 0; i < temList.size(); ++i) {
                        sbSQL2.append("'").append(temList.get(i).toString()).append("'");
                        if (i == temList.size() - 1) continue;
                        sbSQL2.append(",");
                    }
                    sbSQL2.append(") ");
                }
            }
            sbSQL2.append(") a \r\n");
            sbSQL2.append(" Group by a.FId \r\n");
            sbSQL2.append(" order by a.FId ");
            IRowSet rs = null;
            ArrayList<String> templateList = new ArrayList<String>();
            try {
                rs = DbUtil.executeQuery((Context)this._ctx, (String)sbSQL2.toString());
                while (rs.next()) {
                    if (this._mSingleDC == null) {
                        this._mSingleDC = new HashMap();
                    }
                    this._mSingleDC.put(rs.getString("FId"), new Integer(rs.getInt("FSingleDC")));
                    templateList.add(rs.getString("FId"));
                }
                this._param.put("templateList", templateList);
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            HashMap mTemplet = null;
            HashSet entries = null;
            HashMap<String, Object> item = null;
            StringBuffer sbSQL = new StringBuffer();
            sbSQL.append(" SELECT b.ftempletid, a.fdiffmode, b.FSummary As FDescription,  \r\n");
            sbSQL.append(" c.fnumber AS fitemnumber, b.fitemid, b.fdc,b.fseq, ");
            sbSQL.append(" b.fdataelement,b.FDataSrcType,a.FCheckageParty");
            sbSQL.append(" FROM t_csl_elimtemplet a, t_csl_elimtempletentry b, t_csl_rptitem c \r\n");
            sbSQL.append(" WHERE a.fid = b.ftempletid AND b.fitemid = c.fid AND a.felimtype = ").append(((ElimTypeEnum)((Object)this._param.get("elimType"))).getValue());
            if ((ElimTypeEnum)((Object)this._param.get("elimType")) == ElimTypeEnum.ComeAndGo) {
                sbSQL.append("  and b.FDataElement in (select  FInterSEQ from t_csl_Dataelement where FISUSEDELIM=1)");
            }
            sbSQL.append(" and a.fCheckedStatus=").append(2);
            if (this._param.get("solutionNumber") != null && templateList != null) {
                sbSQL.append(" and a.Fid in (");
                for (int i = 0; i < templateList.size(); ++i) {
                    sbSQL.append("'").append(templateList.get(i).toString()).append("'");
                    if (i == templateList.size() - 1) continue;
                    sbSQL.append(",");
                }
                sbSQL.append(") ");
            }
            sbSQL.append(" and a.felimGroupId in (select fid from ");
            sbSQL.append(InterCheckControllerBean.ELIMTEMPLET_GROUP_TBNAME);
            sbSQL.append(" where fid in (select fdispensesrcid from ");
            sbSQL.append(InterCheckControllerBean.TEMPLET_DISPENSE_TBNAME).append(" where forgBoundID ='").append(this._param.get("orgTreeId"));
            if (this._mergeType == 1) {
                sbSQL.append("' and FCOMPANYID ='").append(this._param.get("orgUnitId"));
            }
            sbSQL.append("' and fsourceType = 2))");
            sbSQL.append(" Order by a.fnumber,b.FSeq");
            try {
                IRowSet rsTemplet = DbUtil.executeQuery((Context)this._ctx, (String)sbSQL.toString());
                int isIncludeDiffItem = 0;
                Object var10_15 = null;
                Iterator itEntries = null;
                String oldTempletId = null;
                entries = new HashSet();
                while (rsTemplet.next()) {
                    if (oldTempletId == null) {
                        oldTempletId = rsTemplet.getString("ftempletid");
                    }
                    if (mTemplet == null) {
                        mTemplet = new HashMap();
                    }
                    if (!oldTempletId.equals(rsTemplet.getString("ftempletid")) && entries != null) {
                        for (HashMap hashMap : entries) {
                            hashMap.put("isIncludeDiffItem", new Integer(isIncludeDiffItem));
                        }
                        mTemplet.put(oldTempletId, entries);
                        oldTempletId = rsTemplet.getString("ftempletid");
                        entries = new HashSet();
                        isIncludeDiffItem = 0;
                    }
                    item = new HashMap<String, Object>();
                    item.put("templetid", rsTemplet.getString("ftempletid"));
                    item.put("diffMode", new Integer(rsTemplet.getInt("fdiffmode")));
                    item.put("description", rsTemplet.getString("fdescription"));
                    item.put("itemnumber", rsTemplet.getString("fitemnumber"));
                    item.put("itemid", rsTemplet.getString("fitemid"));
                    item.put("dc", new Integer(rsTemplet.getInt("fdc")));
                    item.put("seq", new Integer(rsTemplet.getInt("fseq")));
                    item.put("dataelement", new Integer(rsTemplet.getInt("fdataelement")));
                    item.put("dataSrcType", new Integer(rsTemplet.getInt("FDataSrcType")));
                    if (rsTemplet.getInt("FDataSrcType") == 2) {
                        isIncludeDiffItem = 1;
                    }
                    entries.add(item);
                    this._mTempletCheckedParty.put(rsTemplet.getString("ftempletid"), rsTemplet.getInt("FCheckageParty"));
                }
                if (entries != null && oldTempletId != null) {
                    for (HashMap hashMap : entries) {
                        hashMap.put("isIncludeDiffItem", new Integer(isIncludeDiffItem));
                    }
                    mTemplet.put(oldTempletId, entries);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            this._mTemplet = mTemplet;
        }

        private void setExchItemAndRelationMap() throws BOSException, EASBizException {
            HashMap mRelationMoney = null;
            IRowSet rsItem = null;
            Object rsTemp = null;
            StringBuffer sbSQL = null;
            ArrayList<Object> params = new ArrayList<Object>();
            String exchAdjustDataSql = RelatingAdjustElimHelper.getExchAdjustDataSql(RptProperties.parseFrom(this._param));
            sbSQL = new StringBuffer("(\r\n");
            boolean isReceivedToCheck = CSLParamUtil.isCheckedInterExchRptByReceived(this._ctx);
            if (!this._isByCompany) {
                sbSQL.append(" SELECT b.fcompanyid, b.ftargetcompanyid, b.FTargetCurrencyID As FCurrencyId, \r\n");
                sbSQL.append(" r.FOrgTreeID as forgboundid, b.fperiodType, b.fyear, b.fperiod, \r\n");
                sbSQL.append(" isnull(sum(exchAdjust.adjustData),0) adjustData, b.fitemNumber,isnull(SUM(b.fmoney),0) AS beforeAdjustData,\r\n");
                sbSQL.append(" b.FCheckageStatus, b.FCommitStatus,b.FDataElement, \r\n");
                sbSQL.append(" Case When b.fcompanyid>b.ftargetcompanyid \r\n");
                sbSQL.append(" THEN b.fcompanyid||b.ftargetcompanyid \r\n");
                sbSQL.append(" ELSE b.ftargetcompanyid||b.fcompanyid \r\n");
                sbSQL.append(" END As FTag \r\n");
                sbSQL.append(" FROM  ").append(this.getItemDataTableName()).append(" b inner join t_csl_rptreceived r on b.FReport = r.FReportID   \r\n");
                sbSQL.append(" inner join T_CSL_CslReport c on b.FReport = c.FID\t\t\r\n");
                sbSQL.append(" left join (").append(exchAdjustDataSql).append(") exchAdjust on  b.fid=exchAdjust.fid ");
                if (this._mergeType == 1) {
                    sbSQL.append(" inner join ").append(this.elimOrgUnitsTable).append(" x \r\n");
                    sbSQL.append(" on b.fcompanyid = x.fcompanyid and b.ftargetcompanyid=x.ftargetcompanyid ");
                }
                sbSQL.append(" where r.FOrgTreeID = ? ");
                sbSQL.append("   AND (b.FOrgBoundID = ? OR b.FOrgBoundID IS NULL)");
                if (this._mergeType == 0) {
                    sbSQL.append(" AND b.FCompanyId in");
                    sbSQL.append(" (Select fcompanyid from ").append(this.elimOrgUnitsTable).append(") \r\n");
                    sbSQL.append(" AND b.FTargetCompanyId in");
                    sbSQL.append(" (Select fcompanyid from ").append(this.elimOrgUnitsTable).append(") \r\n");
                }
                sbSQL.append(" AND b.FPeriodType = ? \r\n");
                sbSQL.append(" AND b.FYear = ? \r\n");
                sbSQL.append(" AND b.FPeriod = ? \r\n");
                if (this._param.get("relations") == null) {
                    params.add(this._param.get("orgTreeId"));
                    params.add(this._param.get("orgTreeId"));
                    params.add(this._param.get("periodType"));
                    params.add(this._param.get("year"));
                    params.add(this._param.get("period"));
                }
                String fastMergeSoluId = (String)this._param.get("fastMergeSoluId");
                boolean isUnReceive = false;
                if (this._param.get("isUnReceive") != null && this._param.get("isUnReceive") instanceof Boolean) {
                    isUnReceive = (Boolean)this._param.get("isUnReceive");
                }
                if (!StringUtils.isEmpty((String)fastMergeSoluId) && isUnReceive) {
                    sbSQL.append(" AND (b.FFastMergeSoluId = ? \r\n");
                    params.add(fastMergeSoluId);
                    sbSQL.append(" OR c.FsourceType in (1, 7)) \r\n");
                } else if (isReceivedToCheck) {
                    sbSQL.append(" AND b.FCommitStatus = 3 \r\n");
                } else {
                    sbSQL.append(" AND c.FAuditedStatus = 2 \r\n");
                }
                sbSQL.append(" AND b.FMoney<>0 \r\n");
                sbSQL.append(" AND b.FDataCollectNumber='").append(this._param.get("dataCollectNumber")).append("' \r\n");
                sbSQL.append(" GROUP BY r.FOrgTreeID, b.fperiodtype, b.fyear, b.fperiod, b.fcompanyid, \r\n");
                sbSQL.append(" b.ftargetcompanyid, b.fitemNumber, b.ftargetCurrencyId, b.FCheckageStatus, b.FCommitStatus, b.fdataelement \r\n");
            } else {
                String basicTreeId = (String)this._param.get("orgTreeId");
                sbSQL.append(" SELECT b.fcompanyid, b.ftargetcompanyid, b.FTargetCurrencyID As FCurrencyId, \r\n");
                sbSQL.append(" r.FOrgTreeID as forgboundid, b.fperiodType, b.fyear, b.fperiod, \r\n");
                sbSQL.append(" isnull(sum(exchAdjust.adjustData),0) adjustData, b.fitemNumber,isnull(SUM(b.fmoney),0) AS beforeAdjustData,\r\n");
                sbSQL.append(" b.FCheckageStatus, b.FCommitStatus,b.fdataelement, \r\n");
                sbSQL.append(" Case When b.fcompanyid>b.ftargetcompanyid \r\n");
                sbSQL.append(" THEN b.fcompanyid||b.ftargetcompanyid \r\n");
                sbSQL.append(" ELSE b.ftargetcompanyid||b.fcompanyid \r\n");
                sbSQL.append(" END As FTag \r\n");
                sbSQL.append(" FROM  ").append(this.getItemDataTableName()).append(" b inner join t_csl_rptreceived r on b.FReport = r.FReportID \r\n");
                sbSQL.append(" inner join T_CSL_CslReport c on b.FReport = c.FID\t\t\r\n");
                sbSQL.append(" left join (").append(exchAdjustDataSql).append(") exchAdjust on b.fid=exchAdjust.fid ");
                sbSQL.append(" where r.FOrgTreeID = ? ");
                sbSQL.append("   AND (b.FOrgBoundID = ? OR b.FOrgBoundID IS NULL) ");
                sbSQL.append(" AND b.FYear = ? ");
                sbSQL.append(" AND b.FPeriod = ? ");
                sbSQL.append(" AND b.FPeriodType = ? ");
                if (isReceivedToCheck) {
                    sbSQL.append(" AND b.FCommitStatus = 3 \r\n");
                } else {
                    sbSQL.append(" AND c.FAuditedStatus = 2 \r\n");
                }
                sbSQL.append(" AND b.FMoney<>0 \r\n");
                sbSQL.append(" and b.FCompanyId IN (select funitid from t_org_structure where ftreeid = ? )   ");
                sbSQL.append("  and  b.FTargetCompanyId IN (select funitid from t_org_structure where ftreeid = ? )     ");
                params.add(basicTreeId);
                params.add(basicTreeId);
                params.add(this._param.get("year"));
                params.add(this._param.get("period"));
                params.add(this._param.get("periodType"));
                params.add(basicTreeId);
                params.add(basicTreeId);
                if (this._targetCompanyId == null) {
                    sbSQL.append(" AND (b.FCompanyId = ? or b.FTargetCompanyId = ?)");
                    params.add(this._companyId);
                    params.add(this._companyId);
                } else {
                    sbSQL.append(" AND ((b.FCompanyId = ? And b.FTargetCompanyId = ?) or (b.FCompanyId = ? And b.FTargetCompanyId))");
                    params.add(this._companyId);
                    params.add(this._targetCompanyId);
                    params.add(this._companyId);
                }
                SameControlUtil.buildClearCompanySql((Object)sbSQL, this.clearCompanys, (String)"b", (ElimTypeEnum)ElimTypeEnum.exchange);
                sbSQL.append(" AND b.FDataCollectNumber='").append(this._param.get("dataCollectNumber")).append("' \r\n");
                sbSQL.append(" GROUP BY r.FOrgTreeID, b.fperiodtype, b.fyear, b.fperiod, b.fcompanyid, \r\n");
                sbSQL.append(" b.ftargetcompanyid, b.fitemNumber, b.ftargetCurrencyId, b.FCheckageStatus, b.FCommitStatus, b.fdataelement \r\n");
            }
            sbSQL.append(" )");
            sbSQL.append(" UNION ALL ");
            sbSQL.append(" ( ");
            Object[] obj = this.getAdjustNoReportDataSqlAndParam();
            sbSQL.append(obj[0]);
            params.addAll((List)obj[1]);
            sbSQL.append(" ) ");
            sbSQL.append(" ORDER BY FCurrencyId, FTag");
            rsItem = DbUtil.executeQuery((Context)this._ctx, (String)sbSQL.toString(), (Object[])params.toArray());
            try {
                String tag = null;
                String oldCurrencyId = null;
                HashSet entries = null;
                HashMap<String, HashMap> entryMap = null;
                HashMap moneyMap = null;
                StringBuffer key = new StringBuffer();
                rsItem.beforeFirst();
                while (rsItem.next()) {
                    if (this._isByCompany) {
                        this.setMasterUnit(rsItem.getString("fcompanyid"), rsItem.getString("ftargetcompanyid"));
                    }
                    if (oldCurrencyId == null) {
                        oldCurrencyId = rsItem.getString("fcurrencyid");
                    }
                    if (mRelationMoney == null) {
                        mRelationMoney = new HashMap();
                    }
                    if (!mRelationMoney.containsKey(rsItem.getString("fcurrencyid"))) {
                        entries = new HashSet();
                        mRelationMoney.put(rsItem.getString("fcurrencyid"), entries);
                        oldCurrencyId = rsItem.getString("fcurrencyid");
                        entryMap = null;
                    }
                    if (entryMap == null) {
                        entryMap = new HashMap<String, HashMap>();
                        if (entries != null) {
                            entries.add(entryMap);
                        }
                    }
                    String string = tag = rsItem.getString("fcompanyid").compareTo(rsItem.getString("ftargetcompanyid")) > 0 ? rsItem.getString("fcompanyid") + KINGDEE_TOKEN + rsItem.getString("ftargetcompanyid") : rsItem.getString("ftargetcompanyid") + KINGDEE_TOKEN + rsItem.getString("fcompanyid");
                    if (!entryMap.containsKey(tag)) {
                        moneyMap = new HashMap();
                        entryMap.put(tag, moneyMap);
                    }
                    moneyMap = (HashMap)entryMap.get(tag);
                    key.setLength(0);
                    key.append(rsItem.getString("fcompanyid")).append(KINGDEE_TOKEN);
                    key.append(rsItem.getString("ftargetcompanyid")).append(KINGDEE_TOKEN);
                    key.append(rsItem.getString("fitemnumber")).append(KINGDEE_TOKEN);
                    key.append(rsItem.getString("fdataelement")).append(KINGDEE_TOKEN);
                    moneyMap.put(key.toString() + "beforeAdjustData", rsItem.getBigDecimal("beforeAdjustData"));
                    moneyMap.put(key.toString() + "adjustData", rsItem.getBigDecimal("adjustData"));
                    moneyMap.put(key.toString() + "afterAdjustData", rsItem.getBigDecimal("adjustData").add(rsItem.getBigDecimal("beforeAdjustData")));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            this._mRelationMoney = mRelationMoney;
        }

        private Object[] getAdjustNoReportDataSqlAndParam() throws EASBizException, BOSException {
            ArrayList<Object> params = new ArrayList<Object>();
            boolean isFromCompany = this._isByCompany;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT adjust.forgunit fcompanyid, \t\t\t\t\t\r\n");
            buffer.append("       adjustDetails.Fcompanyid ftargetcompanyid, \t\r\n");
            buffer.append("       adjust.fcurrencyid FCURRENCYID,\t\t\t\t\r\n");
            buffer.append("       adjust.FOrgboundID FORGBOUNDID,\t\t\t\t\r\n");
            buffer.append("       adjust.fperiodType,\t\t\t\t\t\t\t\r\n");
            buffer.append("       adjust.fyear,\t\t\t\t\t\t\t\t\t\r\n");
            buffer.append("       adjust.fperiod,\t\t\t\t\t\t\t\t\r\n");
            buffer.append("       sum(adjustDetails.fitemdcvalue) ADJUSTDATA,\t\r\n");
            buffer.append("       item.fnumber,\t\t\t\t\t\t\t\t\t\r\n");
            buffer.append("       0 BEFOREADJUSTDATA,\t\t\t\t\t\t\t\r\n");
            buffer.append("       1 FCheckageStatus,\t\t\t\t\t\t\t\r\n");
            buffer.append("       1 FCommitStatus,\t\t\t\t\t\t\t\t\r\n");
            buffer.append("       adjustDetails.Fdataelement,\t\t\t\t\t\r\n");
            buffer.append("       CASE\t\t\t\t\t\t\t\t\t\t\t\r\n");
            buffer.append("         WHEN (adjust.forgunit > adjustDetails.Fcompanyid) THEN \r\n");
            buffer.append("          (adjust.forgunit || adjustDetails.Fcompanyid)\r\n");
            buffer.append("         ELSE\t\r\n");
            buffer.append("          (adjustDetails.Fcompanyid || adjust.forgunit) \r\n");
            buffer.append("       END FTAG\t\r\n");
            buffer.append("  FROM T_CSL_AdjustEntryDetails adjustDetails\t\r\n");
            buffer.append("  INNER JOIN T_CSL_Adjustentry adjustEntry on adjustDetails.FAdjustEntryID = adjustEntry.fid \r\n");
            buffer.append("  INNER JOIN T_CSL_Adjust adjust on adjustentry.fadjustid = adjust.fid \t\r\n");
            buffer.append("  INNER JOIN T_CSL_Rptitem ITEM on item.fid = adjustentry.fitemid\t\t\r\n");
            if (!isFromCompany && this._mergeType == 1) {
                buffer.append("  INNER JOIN ").append(this.elimOrgUnitsTable).append(" company  \r\n");
                buffer.append("               ON company.fcompanyid = adjust.forgunit \r\n");
                buffer.append("               AND company.ftargetcompanyid = adjustDetails.Fcompanyid \r\n");
            }
            buffer.append("  WHERE adjust.fcheckedStatus = 2 AND \r\n");
            buffer.append("   adjust.forgboundid = ? AND \r\n");
            params.add(this._param.get("orgTreeId"));
            buffer.append("   adjust.fyear = ? AND  \r\n");
            params.add(this._param.get("year"));
            buffer.append("   adjust.fperiod = ? AND \r\n");
            params.add(this._param.get("period"));
            buffer.append("   adjust.fperiodtype = ? AND \r\n");
            params.add(this._param.get("periodType"));
            buffer.append("   adjust.FDataCollectNumber = 'ACTUALDATA' \r\n");
            if (!isFromCompany) {
                if (this._mergeType == 1) {
                    buffer.append(" and adjust.forgunit in (select fcompanyid from ").append(this.elimOrgUnitsTable).append(")");
                    buffer.append(" and adjustDetails.Fcompanyid in (select fcompanyid from ").append(this.elimOrgUnitsTable).append(")");
                }
            } else {
                buffer.append(" AND adjust.FOrgUnit IN (SELECT FUnitId FROM T_ORG_Structure WHERE FTreeId = ? ) \r\n");
                params.add(this._param.get("orgTreeId"));
                buffer.append(" AND adjustDetails.FCompanyId IN (SELECT FUnitId FROM T_ORG_Structure WHERE FTreeId = ? ) \r\n");
                params.add(this._param.get("orgTreeId"));
                if (this._targetCompanyId == null) {
                    buffer.append(" AND (adjust.FOrgunIt = ? OR adjustDetails.FCompanyId = ?) \r\n");
                    params.add(this._companyId);
                    params.add(this._companyId);
                } else {
                    buffer.append(" AND ((adjust.FOrgunIt = ? AND adjustDetails.FCompanyId = ?) OR (adjust.FOrgUnit = ? AND adjustDetails.FCompanyId=?)) \r\n");
                    params.add(this._companyId);
                    params.add(this._targetCompanyId);
                    params.add(this._targetCompanyId);
                    params.add(this._companyId);
                }
            }
            if (!isFromCompany) {
                buffer.append("   AND NOT EXISTS (SELECT 1 FROM " + this.getItemDataTableName() + " itemData WHERE  \r\n");
                buffer.append("      itemData.FCompanyID = adjust.FOrgUnit AND \r\n");
                buffer.append("      itemData.fyear = adjust.fyear AND \r\n");
                buffer.append("      itemData.fperiod = adjust.fperiod AND \r\n");
                buffer.append("      itemData.FPeriodType = adjust.FPeriodType AND \r\n");
                buffer.append("      itemData.FDataCollectNumber = adjust.FDataCollectNumber AND \r\n");
                buffer.append("      itemData.FTargetCompanyID = adjustDetails.FCompanyID AND \r\n");
                buffer.append("      itemData.FDATAELEMENT = adjustDetails.FDataElement AND  \r\n");
                buffer.append("      itemData.FCurrencyId = adjust.FCurrencyId AND \r\n");
                buffer.append("      itemData.FTargetCompanyID = adjustDetails.FCompanyID AND \r\n");
                buffer.append("      itemData.FDataElement = adjustDetails.FDataElement AND \r\n");
                buffer.append("      itemData.fitemnumber = item.fnumber AND \r\n");
                buffer.append("      itemData.FCheckageStatus = 1 \r\n");
                buffer.append("      AND itemData.fcommitstatus = 3 \r\n");
            } else {
                buffer.append("   AND NOT EXISTS (SELECT 1 FROM T_CSL_CslReport rpt \r\n");
                buffer.append("    INNER JOIN T_CSL_RptReceived rec ON rpt.FId = rec.FReportId AND rec.forgtreeid = ? \r\n");
                params.add(this._param.get("orgTreeId"));
                buffer.append("    WHERE rpt.FAuditedStatus = 2 AND rpt.FId IN \r\n");
                buffer.append(" (SELECT itemData.FReport FROM " + this.getItemDataTableName() + " itemData WHERE  \r\n");
                buffer.append("      itemData.FCompanyID = adjust.FOrgUnit AND \r\n");
                buffer.append("      itemData.fyear = adjust.fyear AND \r\n");
                buffer.append("      itemData.fperiod = adjust.fperiod AND \r\n");
                buffer.append("      itemData.FPeriodType = adjust.FPeriodType AND \r\n");
                buffer.append("      itemData.FDataCollectNumber = adjust.FDataCollectNumber AND \r\n");
                buffer.append("      itemData.FCurrencyId = adjust.FCurrencyId AND \r\n");
                buffer.append("      itemData.FTargetCompanyID = adjustDetails.FCompanyID AND \r\n");
                buffer.append("      itemData.FDATAELEMENT = adjustDetails.FDataElement AND  \r\n");
                buffer.append("      itemData.FTargetCompanyID = adjustDetails.FCompanyID AND \r\n");
                buffer.append("      itemData.FDataElement = adjustDetails.FDataElement AND \r\n");
                buffer.append("      itemData.fitemnumber = item.fnumber AND \r\n");
                buffer.append("      itemData.FCheckageStatus = 1 \r\n");
                buffer.append(" AND itemData.FCompanyId IN (SELECT FUnitId FROM T_ORG_Structure WHERE FTreeId = ? ) \r\n");
                params.add(this._param.get("orgTreeId"));
                buffer.append(" AND itemData.FTargetCompanyId IN (SELECT FUnitId FROM T_ORG_Structure WHERE FTreeId = ? ) \r\n");
                params.add(this._param.get("orgTreeId"));
                if (this._targetCompanyId == null) {
                    buffer.append(" AND (itemData.FCompanyId = ? OR itemData.FTargetCompanyId = ?) \r\n");
                    params.add(this._companyId);
                    params.add(this._companyId);
                } else {
                    buffer.append(" AND ((itemData.FCompanyId = ? AND itemData.FTargetCompanyId = ?) OR (itemData.FCompanyId = ? AND itemData.FTargetCompanyId = ?)) \r\n");
                    params.add(this._companyId);
                    params.add(this._targetCompanyId);
                    params.add(this._targetCompanyId);
                    params.add(this._companyId);
                }
                buffer.append(")");
            }
            buffer.append(")");
            buffer.append(" GROUP BY adjust.FOrgboundID, \r\n");
            buffer.append("          adjust.fperiodtype, \r\n");
            buffer.append("          adjust.fyear, \r\n");
            buffer.append("          adjust.fperiod, \r\n");
            buffer.append("          adjust.forgunit, \r\n");
            buffer.append("          adjustDetails.Fcompanyid, \r\n");
            buffer.append("          item.fnumber, \r\n");
            buffer.append("          adjust.fcurrencyid, \r\n");
            buffer.append("          adjustDetails.FDataElement \r\n");
            return new Object[]{buffer.toString(), params};
        }

        private void setItemAndRelationMap() throws BOSException, EASBizException {
            HashMap mRelationMoney = null;
            IRowSet rsItem = null;
            Object rsTemp = null;
            StringBuffer sbSQL = null;
            ArrayList<Object> params = new ArrayList<Object>();
            boolean isInter = false;
            String interAdjustDataSql = null;
            if (this._param.get("elimType").equals((Object)ElimTypeEnum.ComeAndGo)) {
                isInter = true;
                interAdjustDataSql = RelatingAdjustElimHelper.getInterAdjustDataSql(RptProperties.parseFrom(this._param));
            }
            sbSQL = new StringBuffer("(\r\n");
            boolean isReceivedToCheck = CSLParamUtil.isCheckedInterExchRptByReceived(this._ctx);
            if (!this._isByCompany) {
                sbSQL.append(" SELECT b.fcompanyid, b.ftargetcompanyid, b.FTargetCurrencyID As FCurrencyId, \r\n");
                sbSQL.append(" r.FOrgTreeID as forgboundid, b.fperiodType, b.fyear, b.fperiod, \r\n");
                if (isInter) {
                    sbSQL.append(" isnull(sum(interAdjust.adjustData),0) adjustData, \r\n");
                }
                sbSQL.append(" b.fitemNumber, isnull(SUM(b.fmoney),0) AS beforeAdjustData, b.FCheckageStatus, b.FCommitStatus,b.FDataElement, \r\n");
                sbSQL.append(" Case When b.fcompanyid>b.ftargetcompanyid \r\n");
                sbSQL.append(" THEN b.fcompanyid||b.ftargetcompanyid \r\n");
                sbSQL.append(" ELSE b.ftargetcompanyid||b.fcompanyid \r\n");
                sbSQL.append(" END As FTag \r\n");
                sbSQL.append(" FROM  ").append(this.getItemDataTableName()).append(" b inner join t_csl_rptreceived r on b.FReport = r.FReportID \r\n");
                sbSQL.append(" inner join T_CSL_CslReport c on b.FReport = c.FID\t\t\r\n");
                if (isInter) {
                    sbSQL.append(" left join (").append(interAdjustDataSql).append(") interAdjust on  b.fid=interAdjust.fid ");
                }
                if (this._mergeType == 1) {
                    sbSQL.append(" inner join ").append(this.elimOrgUnitsTable).append(" x  \r\n");
                    sbSQL.append(" on b.fcompanyid = x.fcompanyid And b.ftargetcompanyid=x.ftargetcompanyid");
                }
                sbSQL.append(" WHERE r.FOrgTreeID = ? ");
                sbSQL.append("   AND (b.FOrgBoundID = ? OR b.FOrgBoundID IS NULL) ");
                if (this._mergeType == 0) {
                    sbSQL.append(" and b.FCompanyId in(select fcompanyid from ").append(this.elimOrgUnitsTable).append(")");
                    sbSQL.append(" and b.FTargetCompanyId in(select fcompanyid from ").append(this.elimOrgUnitsTable).append(")");
                }
                sbSQL.append(" AND b.FPeriodType = ? \r\n");
                sbSQL.append(" AND b.FYear = ? \r\n");
                sbSQL.append(" AND b.FPeriod = ? \r\n");
                if (this._param.get("relations") == null) {
                    params.add(this._param.get("orgTreeId"));
                    params.add(this._param.get("orgTreeId"));
                    params.add(this._param.get("periodType"));
                    params.add(this._param.get("year"));
                    params.add(this._param.get("period"));
                }
                String fastMergeSoluId = (String)this._param.get("fastMergeSoluId");
                boolean isUnReceive = false;
                if (this._param.get("isUnReceive") != null && this._param.get("isUnReceive") instanceof Boolean) {
                    isUnReceive = (Boolean)this._param.get("isUnReceive");
                }
                if (!StringUtils.isEmpty((String)fastMergeSoluId) && isUnReceive) {
                    sbSQL.append(" AND (b.FFastMergeSoluId = ? \r\n");
                    params.add(fastMergeSoluId);
                    sbSQL.append(" OR c.FsourceType in (1, 7)) \r\n");
                } else if (isReceivedToCheck) {
                    sbSQL.append(" AND b.FCommitStatus = 3 \r\n");
                } else {
                    sbSQL.append(" AND c.FAuditedStatus = 2 \r\n");
                }
                sbSQL.append(" AND b.FMoney<>0 \r\n");
                sbSQL.append(" AND b.FDataCollectNumber='").append(this._param.get("dataCollectNumber")).append("' \r\n");
                sbSQL.append(" GROUP BY r.FOrgTreeID, b.fperiodtype, b.fyear, b.fperiod, b.fcompanyid, \r\n");
                sbSQL.append(" b.ftargetcompanyid, b.fitemNumber, b.ftargetCurrencyId, b.FCheckageStatus, b.FCommitStatus, b.FDataElement \r\n");
            } else {
                String basicTreeId = (String)this._param.get("orgTreeId");
                sbSQL.append(" SELECT b.fcompanyid, b.ftargetcompanyid, b.FTargetCurrencyID As FCurrencyId, \r\n");
                sbSQL.append(" r.FOrgTreeID as forgboundid, b.fperiodType, b.fyear, b.fperiod, \r\n");
                if (isInter) {
                    sbSQL.append(" isnull(sum(interAdjust.adjustData),0) adjustData, \r\n");
                }
                sbSQL.append(" b.fitemNumber, isnull(SUM(b.fmoney),0) AS beforeAdjustData, b.FCheckageStatus, b.FCommitStatus,b.FDataElement, \r\n");
                sbSQL.append(" Case When b.fcompanyid>b.ftargetcompanyid \r\n");
                sbSQL.append(" THEN b.fcompanyid||b.ftargetcompanyid \r\n");
                sbSQL.append(" ELSE b.ftargetcompanyid||b.fcompanyid \r\n");
                sbSQL.append(" END As FTag \r\n");
                sbSQL.append(" FROM  ").append(this.getItemDataTableName()).append(" b \r\n");
                sbSQL.append(" inner join t_csl_rptreceived r on b.FReport = r.FReportID \r\n");
                sbSQL.append(" inner join T_CSL_CslReport c on b.FReport = c.FID\t\t\r\n");
                if (isInter) {
                    sbSQL.append(" left join (").append(interAdjustDataSql).append(") interAdjust on b.fid=interAdjust.fid ");
                }
                sbSQL.append(" where r.FOrgTreeID = ? ");
                sbSQL.append("   AND (b.FOrgBoundID = ? OR b.FOrgBoundID IS NULL)");
                sbSQL.append(" AND b.FYear = ? ");
                sbSQL.append(" AND b.FPeriod = ? ");
                sbSQL.append(" AND b.FPeriodType = ? ");
                if (isReceivedToCheck) {
                    sbSQL.append(" AND b.FCommitStatus = 3 \r\n");
                } else {
                    sbSQL.append(" AND c.FAuditedStatus = 2 \r\n");
                }
                sbSQL.append(" AND b.FMoney<>0 \r\n");
                sbSQL.append(" and b.FCompanyId IN (select funitid from t_org_structure where ftreeid = ? )     ");
                sbSQL.append(" and b.FTargetCompanyId IN (select funitid from t_org_structure where ftreeid = ? )     ");
                params.add(basicTreeId);
                params.add(basicTreeId);
                params.add(this._param.get("year"));
                params.add(this._param.get("period"));
                params.add(this._param.get("periodType"));
                params.add(basicTreeId);
                params.add(basicTreeId);
                if (this._targetCompanyId == null) {
                    sbSQL.append(" AND (b.FCompanyId = ? or b.FTargetCompanyId = ?)");
                    params.add(this._companyId);
                    params.add(this._companyId);
                } else {
                    sbSQL.append(" AND ((b.FCompanyId = ? And b.FTargetCompanyId = ?) or (b.FCompanyId = ? And b.FTargetCompanyId))");
                    params.add(this._companyId);
                    params.add(this._targetCompanyId);
                    params.add(this._companyId);
                }
                sbSQL.append(" AND b.FDataCollectNumber='").append(this._param.get("dataCollectNumber")).append("' \r\n");
                sbSQL.append(" GROUP BY r.FOrgTreeID, b.fperiodtype, b.fyear, b.fperiod, b.fcompanyid, \r\n");
                sbSQL.append(" b.ftargetcompanyid, b.fitemNumber, b.ftargetCurrencyId, b.FCheckageStatus, b.FCommitStatus,b.FDataElement \r\n");
            }
            sbSQL.append(" )");
            sbSQL.append(" UNION ALL ");
            sbSQL.append(" ( ");
            Object[] obj = this.getAdjustNoReportDataSqlAndParam();
            sbSQL.append(obj[0]);
            params.addAll((List)obj[1]);
            sbSQL.append(" ) ");
            sbSQL.append(" ORDER BY FCurrencyId, FTag");
            rsItem = DbUtil.executeQuery((Context)this._ctx, (String)sbSQL.toString(), (Object[])params.toArray());
            try {
                rsItem.beforeFirst();
                String tag = null;
                String oldCurrencyId = null;
                HashSet entries = null;
                HashMap<String, HashMap> entryMap = null;
                HashMap moneyMap = null;
                StringBuffer key = new StringBuffer();
                rsItem.beforeFirst();
                while (rsItem.next()) {
                    if (this._isByCompany) {
                        this.setMasterUnit(rsItem.getString("fcompanyid"), rsItem.getString("ftargetcompanyid"));
                    } else {
                        this.setMaxNumber();
                    }
                    if (oldCurrencyId == null) {
                        oldCurrencyId = rsItem.getString("fcurrencyid");
                    }
                    if (mRelationMoney == null) {
                        mRelationMoney = new HashMap();
                    }
                    if (!mRelationMoney.containsKey(rsItem.getString("fcurrencyid"))) {
                        entries = new HashSet();
                        entryMap = null;
                        mRelationMoney.put(rsItem.getString("fcurrencyid"), entries);
                        oldCurrencyId = rsItem.getString("fcurrencyid");
                    }
                    if (entryMap == null) {
                        entryMap = new HashMap<String, HashMap>();
                        if (entries != null) {
                            entries.add(entryMap);
                        }
                    }
                    String string = tag = rsItem.getString("fcompanyid").compareTo(rsItem.getString("ftargetcompanyid")) > 0 ? rsItem.getString("fcompanyid") + KINGDEE_TOKEN + rsItem.getString("ftargetcompanyid") : rsItem.getString("ftargetcompanyid") + KINGDEE_TOKEN + rsItem.getString("fcompanyid");
                    if (!entryMap.containsKey(tag)) {
                        moneyMap = new HashMap();
                        entryMap.put(tag, moneyMap);
                    }
                    moneyMap = (HashMap)entryMap.get(tag);
                    key.setLength(0);
                    key.append(rsItem.getString("fcompanyid")).append(KINGDEE_TOKEN);
                    key.append(rsItem.getString("ftargetcompanyid")).append(KINGDEE_TOKEN);
                    key.append(rsItem.getString("fitemnumber")).append(KINGDEE_TOKEN);
                    key.append(rsItem.getString("fdataelement")).append(KINGDEE_TOKEN);
                    moneyMap.put(key.toString() + "beforeAdjustData", rsItem.getBigDecimal("beforeAdjustData"));
                    moneyMap.put(key.toString() + "adjustData", rsItem.getBigDecimal("adjustData"));
                    moneyMap.put(key.toString() + "afterAdjustData", rsItem.getBigDecimal("adjustData").add(rsItem.getBigDecimal("beforeAdjustData")));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            this._mRelationMoney = mRelationMoney;
        }

        private void setMaxNumber() throws BOSException {
            if (this._maxNumber.containsKey(this._param.get("orgTreeId") + "" + this._param.get("year") + this._param.get("period") + this._param.get("periodType"))) {
                return;
            }
            String sql = "select max(to_int(fnumber)) as fmaxnumber from " + this.getMasterTableName() + " where forgboundid=?  and fyear =? and fperiod=? and fperiodtype=? ";
            IRowSet rs = DbUtil.executeQuery((Context)this._ctx, (String)sql, (Object[])new Object[]{(String)this._param.get("orgTreeId"), this._param.get("year"), this._param.get("period"), this._param.get("periodType")});
            try {
                if (rs.next()) {
                    this._maxNumber.put(this._param.get("orgTreeId") + "" + this._param.get("year") + this._param.get("period") + this._param.get("periodType"), rs.getString("fmaxnumber") == null ? "0" : "" + rs.getInt("fmaxnumber"));
                }
            }
            catch (SQLException ex) {
                throw new SQLDataException(ex);
            }
        }

        private boolean isAuditRecord(IRowSet rsItem) throws SQLException {
            StringBuffer key = new StringBuffer();
            key.append(rsItem.getString("FTempletId")).append(KINGDEE_TOKEN);
            key.append(this._mSingleDC.get(rsItem.getString("FTempletId"))).append(KINGDEE_TOKEN);
            key.append(rsItem.getString("FCurrencyId")).append(KINGDEE_TOKEN);
            if (rsItem.getString("FCompanyId").compareTo(rsItem.getString("FTargetCompanyId")) > 0) {
                key.append(rsItem.getString("FCompanyId")).append(KINGDEE_TOKEN).append(rsItem.getString("FTargetCompanyId"));
            } else {
                key.append(rsItem.getString("FTargetCompanyId")).append(KINGDEE_TOKEN).append(rsItem.getString("FCompanyId"));
            }
            key.append(KINGDEE_TOKEN).append(rsItem.getString("itemNum")).append(KINGDEE_TOKEN);
            key.append(rsItem.getString("FDataElement"));
            return this._mChecked.containsKey(key.toString());
        }

        private boolean setMasterUnit(String companyId, String targetCompanyId) throws BOSException {
            if (!this._isByCompany) {
                return true;
            }
            String key = null;
            key = companyId.compareTo(targetCompanyId) > 0 ? companyId + KINGDEE_TOKEN + targetCompanyId : targetCompanyId + KINGDEE_TOKEN + companyId;
            if (this._parent.containsKey(key)) {
                return true;
            }
            String sql = "select * from t_org_structure where ftreeid= ? and (funitid= ? or funitid = ?)";
            String number1 = null;
            String number2 = null;
            String[] num1 = null;
            IRowSet rs = null;
            rs = DbUtil.executeQuery((Context)this._ctx, (String)sql, (Object[])new Object[]{(String)this._param.get("orgTreeId"), companyId, targetCompanyId});
            try {
                while (rs.next()) {
                    if (rs.getString("funitid").equalsIgnoreCase(companyId)) {
                        number1 = rs.getString("flongnumber");
                        continue;
                    }
                    number2 = rs.getString("flongnumber");
                }
            }
            catch (SQLException ex) {
                throw new SQLDataException(ex);
            }
            if (targetCompanyId.equals(companyId)) {
                number2 = number1;
            }
            if (number1 == null || number2 == null) {
                return false;
            }
            num1 = number1.split(KINGDEE_TOKEN);
            StringBuffer st = new StringBuffer();
            String ret = null;
            for (int i = 0; i < num1.length; ++i) {
                st.append(num1[i] + KINGDEE_TOKEN);
                if (!number2.startsWith(st.toString())) break;
                ret = st.toString();
            }
            if (ret != null) {
                String unitid = null;
                sql = "select * from t_org_structure where ftreeid= ? and flongnumber = ? ";
                rs = DbUtil.executeQuery((Context)this._ctx, (String)sql, (Object[])new Object[]{(String)this._param.get("orgTreeId"), ret.substring(0, ret.length() - 1)});
                try {
                    if (rs.next()) {
                        unitid = rs.getString("funitid");
                        if (companyId.compareTo(targetCompanyId) > 0) {
                            this._parent.put(companyId + KINGDEE_TOKEN + targetCompanyId, unitid);
                        } else {
                            this._parent.put(targetCompanyId + KINGDEE_TOKEN + companyId, unitid);
                        }
                    }
                }
                catch (SQLException ex) {
                    throw new SQLDataException(ex);
                }
            }
            this.setMaxNumber();
            return true;
        }
    }

    public static class CommonTable {
        ElimTypeEnum _elimType;

        public CommonTable(ElimTypeEnum elimType) throws EASBizException {
            if (elimType != ElimTypeEnum.ComeAndGo && elimType != ElimTypeEnum.exchange) {
                throw new InterCheckException(InterCheckException.ERROR_ELIMTYPE);
            }
            this._elimType = elimType;
        }

        public String getMasterTable() {
            return this._elimType == ElimTypeEnum.ComeAndGo ? "T_CSL_InterDataCheckage" : "T_CSL_ExchCheckage";
        }

        public String getEntryTable() {
            return this._elimType == ElimTypeEnum.ComeAndGo ? "T_CSL_DataCheckageEntry" : "T_CSL_ExchCheckageEntry";
        }

        public String getItemDataTable() {
            return this._elimType == ElimTypeEnum.ComeAndGo ? "T_CSL_InterItemData" : "T_CSL_ExchItemData";
        }

        public String getCheckElimRelationTable() {
            return "T_CSL_ElimRecord";
        }

        public int getElimTypeValue() {
            return this._elimType.getValue();
        }
    }

    class UpdateUnAuditHelper {
        UpdateUnAuditHelper() {
        }

        void execUpdate(Context ctx, CommonTable common, CheckageConfirmEnum status, String ids, boolean partyIsNullFilter, boolean isFromCompany) throws BOSException {
            SQLBuilder sql = new SQLBuilder();
            sql.append(" Update ").append(common.getMasterTable()).append(" \r\n").append(" set FCheckedStatus = ").append((Object)status.getValue()).append(", \r\n").append(" FAuditorID = null, \r\n ").append(" FAuditDate = null \r\n  ");
            if (!isFromCompany || partyIsNullFilter) {
                sql.append(",FAssessorID = null, \r\n");
                sql.append("FAssessDate = null \r\n");
            }
            sql.append(" Where FID in ").append(ids);
            if (isFromCompany) {
                sql.append(" and ").append(partyIsNullFilter ? "FCheckedParty is null" : "FCheckedParty is not null");
            }
            DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        }
    }

    class UpdateAuditHelper {
        UpdateAuditHelper() {
        }

        void execUpdateSQL(Context ctx, CommonTable common, CheckageConfirmEnum status, String ids) throws BOSException {
            SQLBuilder sql = new SQLBuilder();
            Date d = new Date();
            Timestamp date = new Timestamp(new Date().getTime());
            sql.append(" Update ").append(common.getMasterTable()).append(" \r\n").append(" set FCheckedStatus = ").append((Object)status.getValue()).append(", \r\n").append(" FAuditorID = ? ", (Object)ctx.getCaller().toString()).append(", \r\n").append(" FAuditDate = ?", (Object)date).append(" Where FID in ").append(ids).append(" ");
            DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        }
    }
}

