/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractInterCheckSumControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.QueryHisBudgetUtils;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class InterCheckSumControllerBean
extends AbstractInterCheckSumControllerBean {
    protected Map _init(Context ctx, CompanyOrgUnitInfo company) throws BOSException, ReportBizException, EASBizException {
        if (company == null) {
            throw new ReportBizException(ReportBizException.COMPANY_EMPTY);
        }
        HashMap initMap = new HashMap();
        return initMap;
    }

    @Override
    protected RptRowSet _createInterCheckSumTempTable(Context ctx, RptProperties params) throws EASBizException, BOSException {
        String tableName = params.getString("tableName");
        if (!StringUtils.isEmpty((String)tableName)) {
            DbUtil.execute((Context)ctx, (String)(" drop table " + tableName));
        }
        String currencyId = params.getString("currencyId");
        String detailTableName = this.createDetailTable(ctx, params);
        tableName = "Tmp_InterCheck_" + System.currentTimeMillis();
        StringBuffer create = new StringBuffer();
        create.append("create table " + tableName);
        create.append(" (companyId varchar(44),");
        create.append(" company nvarchar(510),");
        create.append(" targetCompanyId varchar(44),");
        create.append(" targetCompany nvarchar(510),");
        create.append(" comeA NUMERIC(21,6),");
        create.append(" goA NUMERIC(21,6),");
        create.append(" sumA NUMERIC(21,6),");
        create.append(" comeB NUMERIC(21,6),");
        create.append(" goB NUMERIC(21,6),");
        create.append(" sumB NUMERIC(21,6),");
        create.append(" diff NUMERIC(21,6))");
        tableName = this._createTable(ctx, create.toString());
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tableName);
        sql.append(" select a.fcompanyid as companyId, a.fcompanyName as company,");
        sql.append(" a.ftargetcompanyid as targetCompanyId, a.ftargetCompanyName as targetCompany,");
        sql.append(" a.come as comeA, a.go as goA, a.come-a.go as sumA,");
        sql.append(" b.come as comeB, b.go as goB, b.come-b.go as sumB,");
        sql.append(" a.come-a.go+b.come-b.go as diff from ");
        StringBuffer innersql = new StringBuffer();
        innersql.append("(select t.fcompanyid, t.fcompanyName, t.ftargetcompanyid, t.ftargetCompanyName,");
        innersql.append(" sum(t.fdebit) as come,sum(t.fcredit) as go ");
        innersql.append(" from " + detailTableName + " as t ");
        innersql.append(" group by t.fcompanyid,t.fcompanyName,t.ftargetcompanyid,t.ftargetCompanyName)");
        sql.append(innersql.toString() + " a join " + innersql.toString() + " b on");
        sql.append(" a.fcompanyid=b.ftargetcompanyid and a.ftargetcompanyid=b.fcompanyid");
        sql.append(" where a.fcompanyid > a.ftargetcompanyid");
        this._executeUpdate(ctx, sql.toString());
        sql = new StringBuffer();
        sql.append("insert into " + tableName);
        sql.append(" select a.fcompanyid as companyId, a.fcompanyName as company,");
        sql.append(" a.ftargetcompanyid as targetCompanyId, a.ftargetCompanyName as targetCompany,");
        sql.append(" a.come as comeA, a.go as goA, a.come-a.go as sumA,");
        sql.append(" 0, 0, 0, a.come-a.go as diff from ");
        sql.append("(select t.FCompanyId,t.FCompanyName,");
        sql.append(" t.FTargetCompanyId, t.FTargetCompanyName,");
        sql.append(" sum(fdebit) as come, sum(fcredit) as go ");
        sql.append(" from " + detailTableName);
        sql.append(" as t where t.FCompanyId || t.FTargetCompanyId not in ");
        sql.append("(select distinct companyid || targetcompanyid from " + tableName + ") ");
        sql.append(" and t.FTargetCompanyId || t.FCompanyId not in ");
        sql.append("(select distinct companyid || targetcompanyid from " + tableName + ") ");
        sql.append(" group by t.fcompanyid,t.fcompanyName,t.ftargetcompanyid,t.ftargetCompanyName) a");
        this._executeUpdate(ctx, sql.toString());
        DbUtil.execute((Context)ctx, (String)(" drop table " + detailTableName));
        StringBuffer count = new StringBuffer();
        count.append("insert into " + tableName).append(" ");
        count.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"217_InterCheckSumControllerBean", (Locale)ctx.getOriginLocale()));
        count.append(" from " + tableName);
        if (!params.getBoolean("showZeroDiff")) {
            count.append(" where diff<>0 or companyId='zzzzzzzzzzzz'");
        }
        this._executeUpdate(ctx, count.toString());
        RptRowSet rst = new RptRowSet(new String[0], (Object[][])new Object[0][]);
        rst.setProperty("tableName", (Object)tableName);
        if (!currencyId.equals("all")) {
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectStringPK(currencyId));
            rst.setProperty("currencyName", (Object)currency.getName());
        }
        return rst;
    }

    private String createDetailTable(Context ctx, RptProperties params) throws EASBizException, BOSException {
        int year = params.getInt("year");
        int period = params.getInt("period");
        int periodType = params.getInt("periodType");
        String currencyId = params.getString("currencyId");
        String treeId = params.getString("treeId");
        String orgUnitId = params.getString("orgUnitId");
        String theCompanyId = params.getString("theCompanyId");
        int mergeType = params.getInt("MERGETYPE");
        String authicateSql = params.getString("authicateSql");
        boolean isQueryHisBudget = params.getBoolean("isQueryHisBudget");
        String interCheckageTabName = QueryHisBudgetUtils.getInterCheckageTabName(isQueryHisBudget);
        String interCheckageEntryTabName = QueryHisBudgetUtils.getInterCheckageEntryTabName(isQueryHisBudget);
        String longNumber = null;
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)" select FLongNumber,FLevel From t_org_structure where ftreeid = ? and funitid = ?", (Object[])new Object[]{treeId, orgUnitId});
        try {
            while (rsTemp.next()) {
                longNumber = rsTemp.getString("FLongNumber");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        String tableName = "Tmp_InterCheck_" + System.currentTimeMillis();
        StringBuffer create = new StringBuffer();
        create.append("create table " + tableName);
        create.append(" (FID varchar(44),");
        create.append(" FCurrencyId varchar(44),");
        create.append(" FCompanyId varchar(44),");
        create.append(" FCompanyName nvarchar(510),");
        create.append(" FTargetCompanyId varchar(44),");
        create.append(" FTargetCompanyName nvarchar(510),");
        create.append(" FDebit NUMERIC(21,6),");
        create.append(" FCredit NUMERIC(21,6))");
        tableName = this._createTable(ctx, create.toString());
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tableName);
        sql.append(" select                                              \r\n");
        sql.append(" entries.FID as FID ,                                \r\n");
        sql.append(" InterDataCheckage.FCurrencyID as FCurrencyId ,      \r\n");
        sql.append(" entries.FCompanyID as FCompanyId ,                  \r\n");
        sql.append(" Company1.FName_" + ctx.getLocale() + " as FCompanyName ,                 \r\n");
        sql.append(" entries.FTargetCompanyID as FTargetCompanyId ,      \r\n");
        sql.append(" TargetCompany.FName_" + ctx.getLocale() + " as FTargetCompanyName ,      \r\n");
        sql.append(" CASE item.FDC ");
        sql.append(" WHEN 1 THEN entries.FCredit - entries.FDebit  ");
        sql.append(" ELSE 0 END as FDebit, ");
        sql.append(" CASE item.FDC ");
        sql.append(" WHEN 0 THEN entries.FDebit - entries.FCredit  ");
        sql.append(" ELSE 0 END as FCredit ");
        sql.append(" from ").append(interCheckageTabName).append(" as InterDataCheckage   \r\n");
        sql.append(" inner join T_ORG_Tree as orgBound                   \r\n");
        sql.append(" on InterDataCheckage.FOrgBoundID = orgBound.FID     \r\n");
        sql.append(" inner join ").append(interCheckageEntryTabName).append(" as entries       \r\n");
        sql.append(" on InterDataCheckage.FID = entries.FCheckageID      \r\n");
        sql.append(" inner join T_Csl_RptItem as item                    \r\n");
        sql.append(" on entries.FItemID = item.FID                       \r\n");
        sql.append(" inner join T_ORG_BaseUnit as Company1               \r\n");
        sql.append(" on entries.FCompanyID = Company1.FID                \r\n");
        sql.append(" inner join T_ORG_BaseUnit as TargetCompany          \r\n");
        sql.append(" on entries.FTargetCompanyID = TargetCompany.FID     \r\n");
        if (mergeType == 1) {
            sql.append(" inner Join (");
            sql.append(" Select f1.FCompanyId,f1.FLongNumber as FLongNumber,f2.FTargetCompanyId,f2.FlongNumber As FTargetLongNumber \r\n");
            sql.append(" From \r\n");
            sql.append(" (Select t1.FUnitId As FCompanyId,t1.FLongNumber");
            sql.append(" From t_org_structure t1 join t_org_baseunit t2 on t1.funitid=t2.fid");
            sql.append(" where t2.fisgrouping=0 and t1.fisleaf=1 and t1.flongnumber like '");
            sql.append(longNumber).append("%' and t1.ftreeid='").append(treeId).append("') f1, \r\n");
            sql.append(" (Select t1.FUnitId As FTargetCompanyId,t1.FLongNumber");
            sql.append(" From t_org_structure t1 join t_org_baseunit t2 on t1.funitid=t2.fid");
            sql.append(" where t2.fisgrouping=0 and t1.fisleaf=1 and  t1.flongnumber like '");
            sql.append(longNumber).append("%' and t1.ftreeid='").append(treeId).append("') f2 \r\n");
            sql.append(" ) f \r\n");
            sql.append(" on entries.fcompanyid = f.fcompanyid And entries.ftargetcompanyid=f.ftargetcompanyid");
        }
        sql.append(" where (entries.FDebit <> 0 or entries.FCredit <> 0)        \r\n");
        sql.append("  and InterDataCheckage.FOrgBoundID = '" + treeId);
        sql.append("' and InterDataCheckage.FYear = " + year);
        sql.append("  and InterDataCheckage.FPeriod = " + period);
        sql.append("  and InterDataCheckage.FPeriodType = " + periodType);
        if (!StringUtils.isEmpty((String)currencyId)) {
            sql.append("  and InterDataCheckage.FCurrencyId = '" + currencyId + "'");
        }
        if (!StringUtils.isEmpty((String)theCompanyId)) {
            sql.append(" and (entries.FCompanyId = '" + theCompanyId + "' or entries.FTargetCompanyId = '" + theCompanyId + "') \r\n");
        }
        sql.append(authicateSql);
        if (mergeType == 1) {
            sql.append(this.getParamCompanyUnionSql(ctx, treeId, orgUnitId, "f"));
        }
        this._executeUpdate(ctx, sql.toString());
        return tableName;
    }

    private StringBuffer getParamCompanyUnionSql(Context ctx, String treeId, String orgUnitId, String tableAliasName) throws BOSException, EASBizException {
        int level = 0;
        String longNumber = null;
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)" select FLongNumber,FLevel From t_org_structure where ftreeid = ? and funitid = ?", (Object[])new Object[]{treeId, orgUnitId});
        try {
            while (rsTemp.next()) {
                longNumber = rsTemp.getString("FLongNumber");
                level = rsTemp.getInt("FLevel");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        StringBuffer sbSQL = null;
        sbSQL = new StringBuffer();
        sbSQL.append(" select distinct t1.FLongNumber \r\n");
        sbSQL.append(" from t_org_structure t1 join t_org_baseunit t2 on t1.FUnitId=t2.FId \r\n");
        sbSQL.append(" where t1.FTreeId = '").append(treeId).append("'");
        sbSQL.append(" And t1.FLongNumber like '").append(longNumber).append("%'");
        sbSQL.append(" And t1.FLevel = ").append(level + 1);
        sbSQL.append(" And t2.FIsCompanyOrgUnit = 0");
        rsTemp = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
        StringBuffer rtSql = new StringBuffer();
        try {
            while (rsTemp.next()) {
                rtSql.append(" and (Left(Replace(").append(tableAliasName).append(".FLongNumber,'").append(rsTemp.getString("FLongNumber")).append("','@#$'),3)<>'@#$' \r\n");
                rtSql.append(" or Left(Replace(").append(tableAliasName).append(".FTargetLongNumber,'").append(rsTemp.getString("FLongNumber")).append("','@#$'),3)<>'@#$') \r\n");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return rtSql;
    }

    @Override
    protected RptRowSet _queryInterCheckSum(Context ctx, String tableName, int fromIndex, int length, boolean showZeroDiff) throws BOSException, ReportBizException {
        RptRowSet rst;
        StringBuffer sql = new StringBuffer();
        sql.append("select companyId, company, targetCompanyId, targetCompany, comeA, goA, sumA, comeB, goB, sumB, diff");
        sql.append(" from " + tableName);
        if (!showZeroDiff) {
            sql.append(" where diff<>0 or companyId='zzzzzzzzzzzz'");
        }
        sql.append(" order by companyId, targetCompanyId");
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            rst = DBUtil.executeQuery((String)sql.toString(), null, (int)fromIndex, (int)length, (Connection)con);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        if (fromIndex > 0) {
            return rst;
        }
        StringBuffer countSql = new StringBuffer();
        countSql.append("select count(1) from ").append(tableName);
        if (!showZeroDiff) {
            countSql.append(" where diff<>0 or companyId='zzzzzzzzzzzz'");
        }
        rst.setVirtualRowCount(this._getRecordCount(ctx, countSql.toString(), null));
        if (rst.getVirtualRowCount() == 1) {
            rst.removeRow(0);
            rst.setVirtualRowCount(0);
        }
        return rst;
    }

    @Override
    protected void _releaseTempTable(Context ctx, String tableName) throws BOSException {
        this._dropTable(ctx, tableName);
    }
}

