/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.IElimInvestRate;
import com.kingdee.eas.fi.gr.cslrpt.IElimination;
import com.kingdee.eas.fi.gr.cslrpt.IInvestCheck;
import com.kingdee.eas.fi.gr.cslrpt.InvestCheckCondition;
import com.kingdee.eas.fi.gr.cslrpt.InvestCheckFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.RptItemRelationshipFactory;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractInvestDataProviderControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.RelatingAdjustElimHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InvestDataProviderControllerBean
extends AbstractInvestDataProviderControllerBean {
    private static final String SPLITCHAR = "@@@";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.InvestDataProviderControllerBean");
    private static final String ELIMINATION_BOSTYPE = "C1258B61";
    public static final String ELIMINATION_ENTRY_BOSTYPE = "091F8191";
    public static final String ELIMRECORD_BOSTYPE = "419657E0";
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg";

    protected Map _init(Context ctx, CompanyOrgUnitInfo company) throws BOSException, ReportBizException, EASBizException {
        if (company == null) {
            throw new ReportBizException(ReportBizException.COMPANY_EMPTY);
        }
        HashMap initMap = new HashMap();
        return initMap;
    }

    @Override
    public List _getDatasByInvestTempletID(Context ctx, String investTempletID) throws BOSException, EASBizException {
        StringBuffer strSql = new StringBuffer();
        ArrayList<Object> listParams = new ArrayList<Object>();
        ArrayList listResult = null;
        try {
            strSql.append(" select * from (");
            strSql.append(" select b.Fname_" + ctx.getLocale() + " as templateName,a.Fsummary, a.fcompanytype, a.fdctype, a.fdataelement, c.fnumber, c.fname_" + ctx.getLocale() + " ,a.FIsUserDefinded,c.fid as itemId,a.fid as entryId,fdebitformula,FCreditFormula,a.fseq as seq \r\n");
            strSql.append(" from t_csl_investTempletEntry as a, T_CSL_InvestTemplet as b, t_csl_rptitem as c   \r\n");
            strSql.append(" where a.FIsVisible = 1 and a.ftempletid = b.fid and c.fcontrol = a.fcontrolAttr and a.fisusingtype = 0  \r\n");
            strSql.append(" and FIsUserDefinded=0 ");
            strSql.append(" and a.FIsSumItemExtend = 0 and b.fid = ?  \r\n");
            strSql.append(" union  \r\n");
            strSql.append(" select b.Fname_" + ctx.getLocale() + " as templateName,a.Fsummary, a.fcompanytype, a.fdctype, a.fdataelement, c.fnumber, c.fname_" + ctx.getLocale() + " ,a.FIsUserDefinded,c.fid as itemId,a.fid as entryId,fdebitformula,FCreditFormula,a.fseq as seq \r\n");
            strSql.append(" from t_csl_investTempletEntry a  \r\n");
            strSql.append(" join T_CSL_InvestTemplet b on a.ftempletid = b.fid \r\n");
            strSql.append(" left join t_csl_rptitem c on a.fcontrolAttr =-1 and a.fitemid=c.fid \r\n");
            strSql.append(" where a.FIsVisible = 1 and a.fisusingtype = 0  \r\n");
            strSql.append(" and FIsUserDefinded=0 ");
            strSql.append(" and b.FInvestNewType is not null ");
            strSql.append(" and a.FIsSumItemExtend = 0 and b.fid = ?  \r\n");
            strSql.append(" union  \r\n");
            strSql.append(" select b.Fname_" + ctx.getLocale() + " as templateName,a.Fsummary, a.fcompanytype, a.fdctype, a.fdataelement, c.fnumber, c.fname_" + ctx.getLocale() + ",a.FIsUserDefinded,c.fid as itemId,a.fid as entryId,fdebitformula,FCreditFormula,a.fseq as seq   \r\n");
            strSql.append(" from t_csl_investTempletEntry as a, T_CSL_InvestTemplet as b, t_csl_rptitem as c, t_csl_rptcontrol r   \r\n");
            strSql.append(" where a.FIsVisible = 1 and a.ftempletid = b.fid and c.fcontrol = r.fcontrol  \r\n");
            strSql.append(" and FIsUserDefinded=0 ");
            strSql.append(" and a.FIsSumItemExtend = 0 and a.ftype = r.ftype and a.fisusingtype = 1 and b.fid = ?  \r\n");
            listParams.add(investTempletID);
            listParams.add(investTempletID);
            listParams.add(investTempletID);
            StringBuffer sumItemSql = new StringBuffer();
            sumItemSql.append(" select a.fcontrolAttr from t_csl_investTempletEntry as a, T_CSL_InvestTemplet as b  \r\n");
            sumItemSql.append(" where a.FIsVisible = 1 and a.ftempletid = b.fid and a.FIsSumItemExtend = 1 and b.fid = ? \r\n\r\n");
            ArrayList<String> sumtParams = new ArrayList<String>();
            sumtParams.add(investTempletID);
            IRowSet sumRs = DbUtil.executeQuery((Context)ctx, (String)sumItemSql.toString(), (Object[])sumtParams.toArray());
            while (sumRs.next()) {
                int controlAttr = sumRs.getInt("fcontrolAttr");
                StringBuffer inIds = this.getSumItemIds(ctx, investTempletID, controlAttr);
                strSql.append(" union  \r\n");
                strSql.append(" select b.Fname_" + ctx.getLocale() + " as templateName,a.Fsummary, a.fcompanytype, a.fdctype, a.fdataelement, c.fnumber, c.fname_" + ctx.getLocale() + ",a.FIsUserDefinded,c.fid as itemId,a.fid as entryId,fdebitformula,FCreditFormula,a.fseq as seq   \r\n");
                strSql.append(" from t_csl_investTempletEntry as a, T_CSL_InvestTemplet as b, \r\n");
                strSql.append(" (select * from t_csl_rptitem where fid in( ").append(inIds).append(")) c  \r\n");
                strSql.append(" where a.FIsSumItemExtend = 1 and a.FIsVisible = 1 and a.ftempletid = b.fid  and a.fisusingtype = 0 and FIsUserDefinded=0  \r\n");
                strSql.append(" and FIsUserDefinded=0 ");
                strSql.append("  and b.fid = ? and a.fcontrolAttr = ? \r\n");
                listParams.add(investTempletID);
                listParams.add(new Integer(controlAttr));
                strSql.append(" union  \r\n");
                strSql.append(" select b.Fname_" + ctx.getLocale() + " as templateName,a.Fsummary, a.fcompanytype, a.fdctype, a.fdataelement, c.fnumber, c.fname_" + ctx.getLocale() + ",a.FIsUserDefinded,c.fid as itemId,a.fid as entryId,fdebitformula,FCreditFormula,a.fseq as seq   \r\n");
                strSql.append(" from t_csl_investTempletEntry as a, T_CSL_InvestTemplet as b, ");
                strSql.append(" (select * from t_csl_rptitem where fid in( ").append(inIds).append(")) c  \r\n");
                strSql.append(" where a.FIsSumItemExtend = 1 and a.FIsVisible = 1 and a.ftempletid = b.fid \r\n");
                strSql.append(" and FIsUserDefinded=0 ");
                strSql.append(" and a.fisusingtype = 1 and b.fid = ? and a.fcontrolAttr = ? \r\n");
                listParams.add(investTempletID);
                listParams.add(new Integer(controlAttr));
            }
            strSql.append(" union  \r\n");
            strSql.append(" select b.Fname_" + ctx.getLocale() + " as templateName,a.Fsummary, a.fcompanytype, a.fdctype, a.fdataelement, c.fnumber, c.fname_" + ctx.getLocale() + " ,a.FIsUserDefinded,c.fid as itemId,a.fid as entryId,fdebitformula,FCreditFormula,a.fseq as seq  \r\n");
            strSql.append(" from t_csl_investTempletEntry as a inner join T_CSL_InvestTemplet as b on a.ftempletid = b.fid inner join  t_csl_rptitem as c   \r\n");
            strSql.append(" on c.fid = a.fitemID ");
            strSql.append(" where a.FIsVisible = 1  and a.fisusingtype = 0  \r\n");
            strSql.append(" and FIsUserDefinded=1 ");
            strSql.append(" and a.FIsSumItemExtend = 0 \r\n");
            strSql.append(" and b.fid = '").append(investTempletID).append("'");
            strSql.append(" )t order by t.seq");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])listParams.toArray());
            while (rowSet.next()) {
                if (listResult == null) {
                    listResult = new ArrayList();
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("summary", rowSet.getString("Fsummary") == null || rowSet.getString("Fsummary").length() == 0 ? rowSet.getString("templateName") : rowSet.getString("Fsummary"));
                map.put("companytype", new Integer(rowSet.getInt("fcompanytype")));
                map.put("dctype", new Integer(rowSet.getInt("fdctype")));
                map.put("dataelement", new Integer(rowSet.getInt("fdataelement")));
                map.put("number", rowSet.getString("fnumber"));
                map.put("name", rowSet.getString("fname_" + ctx.getLocale() + ""));
                Integer isUserDefinded = new Integer(rowSet.getInt("FIsUserDefinded"));
                map.put("isUserDefinded", isUserDefinded);
                map.put("itemId", rowSet.getString("itemId"));
                map.put("entryId", rowSet.getString("entryId"));
                map.put("fdebitformula", rowSet.getString("fdebitformula"));
                map.put("FCreditFormula", rowSet.getString("FCreditFormula"));
                listResult.add(map);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return listResult;
    }

    private StringBuffer getSumItemIds(Context ctx, String investTempletID, int controlAttr) throws BOSException, SQLException {
        StringBuffer strSql = new StringBuffer();
        ArrayList<Object> listParams = new ArrayList<Object>();
        strSql.append(" select distinct c.fid, c.fnumber, c.fisSumItem  \r\n");
        strSql.append(" from t_csl_investTempletEntry as a, T_CSL_InvestTemplet as b, t_csl_rptitem as c   \r\n");
        strSql.append(" where a.FIsVisible = 1 and a.ftempletid = b.fid and c.fcontrol = a.fcontrolAttr  and a.fisusingtype = 0  \r\n");
        strSql.append(" and a.FIsSumItemExtend = 1 and b.fid = ? and a.fcontrolAttr = ? \r\n");
        listParams.add(investTempletID);
        listParams.add(new Integer(controlAttr));
        strSql.append(" union  \r\n");
        strSql.append(" select distinct c.fid, c.fnumber, c.fisSumItem \r\n");
        strSql.append(" from t_csl_investTempletEntry as a, T_CSL_InvestTemplet as b, t_csl_rptitem as c, t_csl_rptcontrol r   \r\n");
        strSql.append(" where a.FIsVisible = 1 and a.ftempletid = b.fid and c.fcontrol = r.fcontrol  \r\n");
        strSql.append(" and a.FIsSumItemExtend = 1 and a.ftype = r.ftype and a.fisusingtype = 1 and b.fid = ? and a.fcontrolAttr = ? ");
        listParams.add(investTempletID);
        listParams.add(new Integer(controlAttr));
        IRowSet rSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])listParams.toArray());
        ArrayList<String> itemsList = new ArrayList<String>();
        while (rSet.next()) {
            if (!rSet.getBoolean("FIsSumItem")) {
                itemsList.add(rSet.getString("fid"));
                continue;
            }
            this.setSumItemControlCircle(ctx, rSet.getString("fid"), itemsList);
        }
        Object[] itemLists = itemsList.toArray();
        StringBuffer inIds = new StringBuffer();
        if (itemLists.length == 0) {
            inIds.append("''");
        } else {
            for (int i = 0; i < itemLists.length; ++i) {
                inIds.append("'").append(itemLists[i].toString()).append("'");
                if (i == itemLists.length - 1) continue;
                inIds.append(",");
            }
        }
        return inIds;
    }

    private void setSumItemControlCircle(Context ctx, String id, List items) throws BOSException {
        IRowSet rs = null;
        ArrayList<String> listParams = new ArrayList<String>();
        StringBuffer sbSQL = new StringBuffer(" SELECT t1.fid, t1.fisSumItem ");
        sbSQL.append(" FROM t_csl_Rptitem t1 join t_csl_rptitemmapping t2 on t1.fid=t2.fsourceitem ");
        sbSQL.append(" where t2.ftargetitem = ? ");
        listParams.add(id);
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])listParams.toArray());
            while (rs.next()) {
                if (!rs.getBoolean("FIsSumItem")) {
                    items.add(rs.getString("fid"));
                    continue;
                }
                this.setSumItemControlCircle(ctx, rs.getString("fid"), items);
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
    }

    @Override
    public List _getEliminationSumByCompany(Context ctx, String eliminationID, int isQueryBudget) throws BOSException, EASBizException {
        StringBuffer strSql = new StringBuffer();
        ArrayList<String> listParams = new ArrayList<String>();
        ArrayList listResult = null;
        strSql.append(" select * from (select b.fnumber, b.fname_" + ctx.getLocale() + ", a.fdataelement,                    \r\n");
        strSql.append(" sum(isnull(a.fdebit,0))as fdebit, sum(isnull(a.fcredit,0)) As FCredit           \r\n");
        if (isQueryBudget == 1) {
            strSql.append(" from t_csl_HisEliminationentry a                                                                    \r\n");
        } else {
            strSql.append(" from t_csl_eliminationentry a                                                                    \r\n");
        }
        strSql.append(" inner join t_csl_rptitem b on a.fitemid = b.fid                                 \r\n");
        strSql.append(" where a.fisVisible = 1 and a.FEliminationID = ?                                 \r\n");
        strSql.append(" group by b.fnumber, b.fname_" + ctx.getLocale() + ", a.fdataelement                                  \r\n");
        strSql.append(" ) tt order by tt.fnumber, tt.fdataelement                                       \r\n");
        listParams.add(eliminationID);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])listParams.toArray());
        try {
            while (rowSet.next()) {
                if (listResult == null) {
                    listResult = new ArrayList();
                }
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                map.put("number", rowSet.getString("fnumber"));
                map.put("name", rowSet.getString("fname_" + ctx.getLocale() + ""));
                map.put("dataelement", new Integer(rowSet.getInt("fdataelement")));
                map.put("debit", rowSet.getBigDecimal("fDebit"));
                map.put("credit", rowSet.getBigDecimal("fCredit"));
                listResult.add(map);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return listResult;
    }

    private void insertCompanyRelationParallel(Context ctx, RptProperties params, String tempTable) throws BOSException {
        StringBuffer sbSQL = new StringBuffer(" insert into ").append(tempTable);
        String orgTreeId = params.getString("treeId");
        Timestamp time = new Timestamp(((Date)params.getObject("day")).getTime());
        sbSQL.append(" select sr.FShareHolderId As FFromCompanyId,sr.FInvesteeCompanyId As FToCompanyId, ");
        sbSQL.append(" sr2.FToIsStockControl As FToIsStockControl,sr.FShareScale As FRate from t_csl_ShareRela sr, ");
        sbSQL.append(" (select t1.FShareHolderId As FFromCompanyId, t1.FInvesteeCompanyId As FToCompanyId, \r\n");
        sbSQL.append(" Case Isnull(FStockControlCompanyId,'*') when '*' THEN 0 ELSE 1 END As FToIsStockControl,max(t1.FChangeDate) as maxdate \r\n ");
        sbSQL.append(" From t_csl_ShareRela t1 left outer join t_org_OUPartUnionGroup t2 on t1.FInvesteeCompanyId=t2.FStockControlCompanyId \r\n");
        sbSQL.append(" Where FChangeDate <= TimeStamp'").append(time.toString()).append("'");
        sbSQL.append(" And FInvesteeCompanyId IN  \r\n");
        sbSQL.append(" (Select FUnitId From t_org_structure Where FTreeId='").append(orgTreeId).append("') \r\n");
        sbSQL.append(" And FShareHolderId IN \r\n");
        sbSQL.append(" (Select FUnitId From t_org_structure Where FTreeId='").append(orgTreeId).append("') \r\n");
        sbSQL.append(" group by t1.FShareHolderId, t1.FInvesteeCompanyId, t2.FStockControlCompanyId) sr2 ");
        sbSQL.append(" where sr.FShareHolderId = sr2.FFromCompanyId ");
        sbSQL.append(" and sr.FInvesteeCompanyId = sr2.FToCompanyId and sr.FChangeDate = sr2.maxdate ");
        DbUtil.execute((Context)ctx, (String)sbSQL.toString());
    }

    private void insertCompanyRelationInStep(Context ctx, RptProperties params, String tempTable) throws BOSException {
        String treeId = params.getString("treeId");
        String orgUnitId = params.getString("orgUnitId");
        Timestamp time = new Timestamp(((Date)params.getObject("day")).getTime());
        StringBuffer sbSQL = null;
        IRowSet rs = null;
        try {
            String numberAndLevelSql = "select flongNumber, flevel from t_org_structure where funitid = '" + orgUnitId + "'";
            rs = DbUtil.executeQuery((Context)ctx, (String)numberAndLevelSql);
            String number = "";
            int level = 0;
            if (rs.next()) {
                number = rs.getString("FLongNumber");
                level = rs.getInt("FLevel");
            }
            sbSQL = new StringBuffer();
            sbSQL.append(" select distinct t1.FLongNumber \r\n");
            sbSQL.append(" from t_org_structure t1 join t_org_baseunit t2 on t1.FUnitId=t2.FId \r\n");
            sbSQL.append(" where t1.FTreeId = '").append(treeId).append("'");
            sbSQL.append(" And t1.FLongNumber like '").append(number).append("%'");
            sbSQL.append(" And t1.FLevel = ").append(level + 1);
            sbSQL.append(" And t2.FIsCompanyOrgUnit = 0");
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            sbSQL = new StringBuffer();
            sbSQL.append(" Insert into ").append(tempTable);
            sbSQL.append(" select sr.FShareHolderId As FFromCompanyId,sr.FInvesteeCompanyId As FToCompanyId, ");
            sbSQL.append(" sr2.FToIsStockControl As FToIsStockControl,sr.FShareScale As FRate from t_csl_ShareRela sr, ");
            sbSQL.append(" (select t1.FShareHolderId As FFromCompanyId, t1.FInvesteeCompanyId As FToCompanyId,  \r\n");
            sbSQL.append(" Case Isnull(t4.FStockControlCompanyId,'*') when '*' then 0 ELSE 1 END As FToIsStockControl, \r\n");
            sbSQL.append(" max(t1.FChangeDate) as maxdate ");
            sbSQL.append(" From t_csl_ShareRela t1 INNER join t_org_structure t2 on t1.FShareHolderId=t2.FUnitId \r\n");
            sbSQL.append(" INNER join t_org_structure t3 on t1.FInvesteeCompanyId=t3.FUnitId \r\n");
            sbSQL.append(" Left join t_org_OUPartUnionGroup t4 on t4.FUnitId=t3.FUnitId And t1.FInvesteeCompanyId=t4.FStockControlCompanyId \r\n");
            sbSQL.append(" Where t2.FTreeId = '").append(treeId).append("'");
            sbSQL.append(" And t3.FTreeId = '").append(treeId).append("'");
            sbSQL.append(" And FIsOut = 0 \r\n");
            sbSQL.append(" And t1.FInvesteeCompanyId in \r\n");
            sbSQL.append(" (Select FUnitId From t_org_structure ");
            sbSQL.append(" where FLongNumber like '").append(number).append("%')");
            sbSQL.append(" And t1.FShareHolderId in \r\n");
            sbSQL.append(" (Select FUnitId From t_org_structure");
            sbSQL.append(" where FLongNumber like '").append(number).append("%')");
            while (rs.next()) {
                sbSQL.append(" and (Left(Replace(t2.FLongNumber,'").append(rs.getString("FLongNumber")).append("','@#$'),3)<>'@#$' \r\n");
                sbSQL.append(" or Left(Replace(t3.FLongNumber,'").append(rs.getString("FLongNumber")).append("','@#$'),3)<>'@#$') \r\n");
            }
            sbSQL.append(" and FChangeDate <= TimeStamp'").append(time.toString()).append("'");
            sbSQL.append(" group by t1.FShareHolderId, t1.FInvesteeCompanyId,t4.FStockControlCompanyId) sr2 ");
            sbSQL.append(" where sr.FShareHolderId = sr2.FFromCompanyId ");
            sbSQL.append(" and sr.FInvesteeCompanyId = sr2.FToCompanyId and sr.FChangeDate = sr2.maxdate ");
            DbUtil.execute((Context)ctx, (String)sbSQL.toString());
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void createCompanyRelationTempTable(Context ctx, String tempTable) throws BOSException {
        StringBuffer createTableSQL = null;
        createTableSQL = new StringBuffer("Create Table ");
        createTableSQL.append(tempTable);
        createTableSQL.append("( FFromCompanyId VARCHAR(44),  FToCompanyID VARCHAR(44) , \r\n");
        createTableSQL.append(" FToIsStockControl int, FRate NUMERIC(21,6)) \r\n");
        DbUtil.execute((Context)ctx, (String)createTableSQL.toString());
    }

    @Override
    protected RptRowSet _getInvestItemData(Context ctx, int mergeType, RptProperties params, String tableName) throws BOSException, EASBizException {
        this.updateInvestItemData(ctx);
        this.createCompanyRelationTempTable(ctx, tableName);
        if (mergeType == 0) {
            this.insertCompanyRelationParallel(ctx, params, tableName);
        } else if (mergeType == 1) {
            this.insertCompanyRelationInStep(ctx, params, tableName);
        }
        this.createIndexForTempTable(ctx, tableName);
        return this.getInvestItemData(ctx, params, tableName);
    }

    private void updateInvestItemData(Context ctx) throws BOSException, EASBizException {
        String sql = "select FId, FOrgBoundID, FReportID from t_csl_investItemData where FSourceType = 2 and FImportedGroup is null";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            sql = "Update t_csl_investItemData set FImportedGroup = ? where FId = ?";
            HashMap<String, String> cache = new HashMap<String, String>();
            while (rowSet.next()) {
                String id = rowSet.getString("FId");
                String treeId = rowSet.getString("FOrgBoundID");
                String reportId = rowSet.getString("FReport");
                String groupId = (String)cache.get(treeId + "-" + reportId);
                if (groupId == null) {
                    groupId = this.getCurGroup(ctx, treeId, reportId);
                    cache.put(treeId + "-" + reportId, groupId);
                }
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{groupId, id});
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private String getCurGroup(Context ctx, String treeId, String reportId) throws EASBizException, BOSException {
        CslReportInfo report = CslReportFactory.getLocalInstance(ctx).getCslReportInfo("select orgUnit.id, orgUnit.isGrouping where id = '" + reportId + "'");
        if (report == null) {
            String oql = "select unit.id where tree.id = '" + treeId + "' and level = 1";
            OrgStructureInfo stru = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo(oql);
            return stru.getUnit().getId().toString();
        }
        String unitId = report.getOrgUnit().getId().toString();
        if (report.getOrgUnit().isIsGrouping()) {
            return unitId;
        }
        String oql = "select parent.* where tree.id = '" + treeId + "' and unit.id = '" + unitId + "'";
        OrgStructureInfo stru = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo(oql);
        return stru.getParent().getUnit().getId().toString();
    }

    private RptRowSet getInvestItemData(Context ctx, RptProperties params, String tempTable) throws BOSException, EASBizException {
        StringBuffer sbSQL = null;
        RptRowSet rst = null;
        int year = params.getInt("year");
        int period = params.getInt("period");
        int periodType = params.getInt("periodType");
        String treeId = params.getString("treeId");
        boolean isSelectMode = params.getBoolean("isSelectMode");
        String[] itemNumbers = this.getItemNumbers(ctx);
        String[] aliasTableNames = new String[]{"invest", "diff", "yield", "accum"};
        String locale = ctx.getLocale().toString();
        Connection con = null;
        try {
            sbSQL = new StringBuffer();
            sbSQL.append(" select * from (( Select N'0' as FDataType, \r\n");
            if (!isSelectMode) {
                sbSQL.append(" company.fname_").append(locale).append(" as FCompanyName, \r\n");
                sbSQL.append(" targetCompany.fname_").append(locale).append(" as FTargetCompanyName, \r\n");
            } else {
                sbSQL.append(" targetCompany.fname_").append(locale).append(" as FTargetCompanyName, \r\n");
                sbSQL.append(" company.fname_").append(locale).append(" as FCompanyName, \r\n");
            }
            sbSQL.append(" FRate as FRate, \r\n");
            sbSQL.append(" currency.FName_").append(locale).append(" As FCurrencyName, \r\n");
            sbSQL.append(" targetCurrency.FName_").append(locale).append(" As FTargetCurrencyName, \r\n");
            sbSQL.append(aliasTableNames[0]).append(".FMoney As FInvestLong, \r\n");
            sbSQL.append(aliasTableNames[1]).append(".FMoney As FInvestDiff,");
            sbSQL.append(aliasTableNames[2]).append(".FMoney As FInterest, ");
            sbSQL.append(aliasTableNames[3]).append(".FMoney As FYearInterest, \r\n");
            sbSQL.append(" company.fid as FCompanyId, \r\n");
            sbSQL.append(" targetCompany.fid as FTargetCompanyId, \r\n");
            sbSQL.append(" currency.fid as FCurrencyId, \r\n");
            sbSQL.append(" targetCurrency.fid as FTargetCurrencyId \r\n");
            sbSQL.append(" From \r\n");
            sbSQL.append(" (select temp1.*,a.fcurrencyid,a.ftargetCurrencyId from ").append(tempTable).append(" temp1,  \r\n");
            sbSQL.append("(select distinct inv.FCurrencyId, inv.FTargetCurrencyId  from t_csl_InvestItemData inv ");
            sbSQL.append(" INNER JOIN t_csl_RptReceived r ON r.FReportId = inv.FReportId ");
            sbSQL.append(" And r.FOrgTreeId = '").append(treeId).append("' \r\n");
            sbSQL.append(" where inv.FPeriodType = ").append(periodType);
            sbSQL.append(" And inv.FYear = ").append(year);
            sbSQL.append(" And inv.FPeriod = ").append(period);
            sbSQL.append(" ) a )");
            sbSQL.append(" tempt  \r\n");
            sbSQL.append(this.getLeftJoinSql(params, aliasTableNames[0], false, itemNumbers[0], -1));
            sbSQL.append(this.getLeftJoinSql(params, aliasTableNames[1], false, itemNumbers[1], -1));
            sbSQL.append(this.getLeftJoinSql(params, aliasTableNames[2], true, itemNumbers[2], 2));
            sbSQL.append(this.getLeftJoinSql(params, aliasTableNames[3], true, itemNumbers[2], 3));
            sbSQL.append(" inner join t_org_company company on tempt.FFromCompanyId = company.fid \r\n");
            sbSQL.append(" inner join t_org_company targetCompany on tempt.FToCompanyID = targetCompany.fid \r\n");
            sbSQL.append(" inner join T_BD_Currency currency on tempt.FCurrencyId = currency.fid \r\n");
            sbSQL.append(" inner join T_BD_Currency targetCurrency on tempt.FTargetCurrencyId = targetCurrency.fid \r\n)");
            sbSQL.append("  union (");
            sbSQL.append(" Select N'2' as FDataType, \r\n");
            if (!isSelectMode) {
                sbSQL.append(" company.fname_").append(locale).append(" as FCompanyName, \r\n");
                sbSQL.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"219_InvestDataProviderControllerBean", (Locale)ctx.getOriginLocale())).append(" \r\n");
            } else {
                sbSQL.append(" targetCompany.fname_").append(locale).append(" as FTargetCompanyName, \r\n");
                sbSQL.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"220_InvestDataProviderControllerBean", (Locale)ctx.getOriginLocale())).append(" \r\n");
            }
            sbSQL.append(" 0 as FRate, \r\n");
            sbSQL.append(" currency.FName_").append(locale).append(" As FCurrencyName, \r\n");
            sbSQL.append(" targetCurrency.FName_").append(locale).append(" As FTargetCurrencyName, \r\n");
            sbSQL.append(" sum(").append(aliasTableNames[0]).append(".FMoney) As FInvestLong, \r\n");
            sbSQL.append(" sum(").append(aliasTableNames[1]).append(".FMoney) As FInvestDiff,");
            sbSQL.append(" sum(").append(aliasTableNames[2]).append(".FMoney) As FInterest,");
            sbSQL.append(" sum(").append(aliasTableNames[3]).append(".FMoney) As FYearInterest, \r\n");
            if (!isSelectMode) {
                sbSQL.append(" company.FId as FCompanyId, \r\n");
                sbSQL.append(" null as FTargetCompanyId, \r\n");
            } else {
                sbSQL.append(" null as FCompanyId, \r\n");
                sbSQL.append(" targetCompany.FId as FTargetCompanyId, \r\n");
            }
            sbSQL.append(" currency.FId as FCurrencyId, \r\n");
            sbSQL.append(" targetCurrency.FId as FTargetCurrencyId \r\n");
            sbSQL.append(" From \r\n");
            sbSQL.append(" (select temp1.*,a.fcurrencyid,a.FTargetCurrencyId from ").append(tempTable).append(" temp1,  \r\n");
            sbSQL.append("(select distinct inv.FCurrencyId,inv.FTargetCurrencyId  from t_csl_InvestItemData inv ");
            sbSQL.append(" INNER JOIN t_csl_RptReceived r ON r.FReportId = inv.FReportId ");
            sbSQL.append(" And r.FOrgTreeId = '").append(treeId).append("' \r\n");
            sbSQL.append(" where inv.FPeriodType = ").append(periodType);
            sbSQL.append(" And inv.FYear = ").append(year);
            sbSQL.append(" And inv.FPeriod = ").append(period);
            sbSQL.append(" ) a )");
            sbSQL.append(" tempt  \r\n");
            sbSQL.append(this.getLeftJoinSql(params, aliasTableNames[0], false, itemNumbers[0], -1));
            sbSQL.append(this.getLeftJoinSql(params, aliasTableNames[1], false, itemNumbers[1], -1));
            sbSQL.append(this.getLeftJoinSql(params, aliasTableNames[2], true, itemNumbers[2], 2));
            sbSQL.append(this.getLeftJoinSql(params, aliasTableNames[3], true, itemNumbers[2], 3));
            sbSQL.append(" inner join t_org_company company on tempt.FFromCompanyId = company.fid  \r\n");
            sbSQL.append(" inner join t_org_company targetCompany on tempt.FToCompanyID = targetCompany.fid  \r\n");
            sbSQL.append(" inner join T_BD_Currency currency on tempt.FCurrencyId = currency.fid  \r\n");
            sbSQL.append(" inner join T_BD_Currency targetCurrency on tempt.FTargetCurrencyId = targetCurrency.fid  \r\n");
            if (!isSelectMode) {
                sbSQL.append(" group by  company.FId, currency.FId, targetCurrency.FId,");
                sbSQL.append(" company.FName_").append(locale).append(",");
                sbSQL.append(" currency.FName_").append(locale).append(",");
                sbSQL.append(" targetCurrency.FName_").append(locale).append(")");
                sbSQL.append(" ) a");
            } else {
                sbSQL.append(" group by  targetCompany.FId, currency.FId, targetCurrency.FId,");
                sbSQL.append(" targetCompany.FName_").append(locale).append(",");
                sbSQL.append(" currency.FName_").append(locale).append(",");
                sbSQL.append(" targetCurrency.FName_").append(locale).append(")");
                sbSQL.append(" ) a");
            }
            sbSQL.append(" where (a.FInvestLong is not null or a.FInvestDiff is not null or a.FInterest is not null or a.FYearInterest is not null) ");
            if (!isSelectMode) {
                sbSQL.append(" order by a.FCompanyName, a.FCurrencyName,a.FTargetCurrencyName, a.FDataType");
            } else {
                sbSQL.append(" order by a.FTargetCompanyName, a.FCurrencyName,a.FTargetCurrencyName, FDataType ");
            }
            con = this.getConnection(ctx);
            rst = DBUtil.executeQuery((String)sbSQL.toString(), (Connection)con);
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                this.dropTempTable(ctx, tempTable);
                SQLUtils.cleanup(con);
                throw throwable;
            }
        }
        this.dropTempTable(ctx, tempTable);
        SQLUtils.cleanup((Connection)con);
        return rst;
    }

    private String getLeftJoinSql(RptProperties params, String aliasTableName, boolean needDataElement, String itemNumber, int dataElement) {
        String fromCompany = params.getString("fromCompany");
        String toCompany = params.getString("toCompany");
        String fromCurrency = params.getString("fromCurrency");
        String toCurrency = params.getString("toCurrency");
        int year = params.getInt("year");
        int period = params.getInt("period");
        int periodType = params.getInt("periodType");
        String treeId = params.getString("treeId");
        if (!needDataElement) {
            dataElement = 4;
        }
        String investAdjustDataSql = RelatingAdjustElimHelper.getInvestAdjustDataSql(params, itemNumber, dataElement);
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" left join \r\n");
        sbSQL.append(" (Select t2.FOrgTreeId As FOrgBoundId,t1.FCompanyId, ");
        sbSQL.append("   t1.FTargetCompanyId,t1.FCurrencyID,t1.FTargetCurrencyID, \r\n");
        sbSQL.append("  t1.FPeriodType,t1.FYear,t1.FPeriod,t1.FItemNumber, \r\n");
        if (needDataElement) {
            sbSQL.append(" t1.FDataElement, ");
        }
        if (investAdjustDataSql != null) {
            sbSQL.append(" isnull(t1.FMoney,0)+isnull( investdata.adjustdata,0) as FMoney ");
        } else {
            sbSQL.append(" t1.FMoney as FMoney ");
        }
        sbSQL.append("  From t_csl_InvestItemData t1 join t_csl_RptReceived t2 ");
        sbSQL.append("   on t1.FReportId=t2.FReportId\t\r\n  ");
        if (investAdjustDataSql != null) {
            sbSQL.append(" left join ( ").append(investAdjustDataSql).append(" )  investdata on investdata.fid = t1.fid");
        }
        sbSQL.append("   ) @aliasTableName@ \r\n  ");
        sbSQL.append(" on (@aliasTableName@.FCompanyId = tempt.FFromCompanyId \r\n");
        if (fromCompany != null) {
            sbSQL.append(" And @aliasTableName@.FCompanyId = '").append(fromCompany).append("'");
        }
        sbSQL.append(" And @aliasTableName@.FTargetCompanyId = FToCompanyID \r\n");
        if (toCompany != null) {
            sbSQL.append(" And @aliasTableName@.FTargetCompanyId = '").append(toCompany).append("'");
        }
        if (fromCurrency != null) {
            sbSQL.append(" And @aliasTableName@.FCurrencyId = '").append(fromCurrency).append("'");
        }
        if (toCurrency != null) {
            sbSQL.append(" And @aliasTableName@.FTargetCurrencyId = '").append(toCurrency).append("'");
        }
        sbSQL.append(" And @aliasTableName@.FOrgBoundId = '").append(treeId).append("' \r\n");
        sbSQL.append(" And @aliasTableName@.FPeriodType = ").append(periodType);
        sbSQL.append(" And @aliasTableName@.FYear = ").append(year);
        sbSQL.append(" And @aliasTableName@.FPeriod = ").append(period);
        sbSQL.append(" And @aliasTableName@.FItemNumber = '").append(itemNumber).append("'  \r\n");
        if (needDataElement) {
            sbSQL.append(" And @aliasTableName@.FDataElement = ").append(dataElement).append(" \r\n");
        }
        sbSQL.append(" And @aliasTableName@.FCurrencyId = tempt.FCurrencyID  \r\n");
        sbSQL.append(" And @aliasTableName@.FTargetCurrencyId = tempt.FTargetCurrencyID)  \r\n");
        return sbSQL.toString().replaceAll("@aliasTableName@", aliasTableName);
    }

    private String[] getItemNumbers(Context ctx) throws BOSException, EASBizException {
        IInvestCheck ic = InvestCheckFactory.getLocalInstance(ctx);
        Map map = null;
        map = ic.getItemControlInRpt(null);
        Set set = map.keySet();
        int i = 0;
        String[] itemNumbers = new String[]{"", "", ""};
        for (Integer key : set) {
            String nameAndNumber = (String)map.get(key);
            itemNumbers[i] = nameAndNumber.split(SPLITCHAR)[1];
            ++i;
        }
        return itemNumbers;
    }

    @Override
    protected RptRowSet _createInvestCompanyTempTable(Context ctx, RptProperties params) throws BOSException, ReportBizException, EASBizException {
        String tableName = "temp_" + this.getCurTimeStr();
        RptRowSet rst = new RptRowSet(new String[0], (Object[][])new Object[0][]);
        rst.setProperty("tableName", (Object)tableName);
        return rst;
    }

    private List getInvestTempletList(Context ctx, ElimTypeEnum elimType) throws BOSException {
        String sql = " select FID, FTempletType from T_CSL_InvestTemplet where FElimType =" + elimType.getValue();
        ArrayList<String> list = new ArrayList<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                list.add(rs.getString(1) + SPLITCHAR + rs.getInt(2));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return list;
    }

    private IRowSet getItemDataCurrencyList(Context ctx, Map mapParams) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" SELECT distinct FCurrencyId From t_csl_IIAssistantItemData \r\n");
        sbSQL.append(" Where FOrgBoundId = '").append((String)mapParams.get("OrgTreeID")).append("' \r\n");
        sbSQL.append(" And FOrgUnitId = '").append((String)mapParams.get("OrgUnitID")).append("' \r\n");
        sbSQL.append(" And FYear = ").append((Integer)mapParams.get("Year"));
        sbSQL.append(" And FPeriod = ").append((Integer)mapParams.get("Period"));
        sbSQL.append(" And FPeriodType =").append((Integer)mapParams.get("PeriodType"));
        return DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
    }

    @Override
    protected String _isHaveAuditElimData(Context ctx, Map mapParams) throws BOSException {
        StringBuffer msg = new StringBuffer();
        StringBuffer sbSQL = new StringBuffer(" select top 1 fnumber from t_csl_elimination  a  \r\n");
        sbSQL.append("  INNER JOIN T_CSL_EliminationEntry b  \r\n");
        sbSQL.append("  ON a.FID = b.FEliminationID \r\n");
        sbSQL.append(" WHERE a.fcheckedstatus = ").append(2).append(" \r\n");
        sbSQL.append("\tand a.fOrgBoundId = '").append(this.getOrgTreeId(mapParams)).append("' \r\n");
        sbSQL.append("\tand a.fOrgUnit = '").append(this.getOrgUnitId(mapParams)).append("' \r\n");
        sbSQL.append("  and a.fperiodType = ").append(this.getPeriodType(mapParams)).append(" \r\n");
        sbSQL.append("  and a.fyear = ").append(this.getYear(mapParams)).append(" \r\n");
        sbSQL.append("  and a.fperiod = ").append(this.getPeriod(mapParams)).append(" \r\n");
        sbSQL.append("  and a.FElimType = ").append(this.getElimType(mapParams)).append(" \r\n");
        sbSQL.append("  and ((b.FDebit <> 0) OR (b.FCredit <> 0)) ");
        sbSQL.append("  and a.FCurrencyId = a.FSourceCurrencyId");
        sbSQL.append("  and a.FDataCollectNumber = '").append(mapParams.get("dataCollectNumber")).append("'");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            while (rs.next()) {
                msg.append(rs.getString("fnumber")).append("  ");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return msg.toString();
    }

    @Override
    protected boolean _isExistElimData(Context ctx, Map mapParams) throws BOSException {
        StringBuffer sbSQL = new StringBuffer(" select  top 1 a.fid from t_csl_elimination  a  \r\n");
        sbSQL.append("  INNER JOIN T_CSL_EliminationEntry b  \r\n");
        sbSQL.append("  ON a.FID = b.FEliminationID \r\n");
        sbSQL.append(" WHERE a.fOrgBoundId = '").append(this.getOrgTreeId(mapParams)).append("' \r\n");
        sbSQL.append("\tand a.fOrgUnit = '").append(this.getOrgUnitId(mapParams)).append("' \r\n");
        sbSQL.append("  and a.fperiodType = ").append(this.getPeriodType(mapParams)).append(" \r\n");
        sbSQL.append("  and a.fyear = ").append(this.getYear(mapParams)).append(" \r\n");
        sbSQL.append("  and a.fperiod = ").append(this.getPeriod(mapParams)).append(" \r\n");
        sbSQL.append("  and a.FElimType = ").append(this.getElimType(mapParams)).append(" \r\n");
        sbSQL.append("  and ((b.FDebit <> 0) OR (b.FCredit <> 0)) ");
        sbSQL.append("  and a.FDataCollectNumber = '").append(mapParams.get("dataCollectNumber")).append("'");
        sbSQL.append("  and a.fcheckedstatus = 1 ");
        sbSQL.append("  and a.FElimDataSource=0 \n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return false;
    }

    @Override
    protected boolean _isHaveUnAuditCheckageData(Context ctx, Map mapParams) throws BOSException {
        StringBuffer sbSQL = new StringBuffer(" select fid from T_CSL_InvestCheckage  a  \r\n");
        sbSQL.append(" WHERE a.FCheckedStatus = ").append(1).append(" \r\n");
        sbSQL.append("\tand a.fOrgBoundId = '").append(this.getOrgTreeId(mapParams)).append("' \r\n");
        sbSQL.append("\tand a.fOrgUnitID = '").append(this.getOrgUnitId(mapParams)).append("' \r\n");
        sbSQL.append("  and a.fperiodType = ").append(this.getPeriodType(mapParams)).append(" \r\n");
        sbSQL.append("  and a.fyear = ").append(this.getYear(mapParams)).append(" \r\n");
        sbSQL.append("  and a.fperiod = ").append(this.getPeriod(mapParams)).append(" \r\n");
        sbSQL.append("\tunion (");
        sbSQL.append(" select fid from T_CSL_InterestCheckage  a  \r\n");
        sbSQL.append(" WHERE a.FCheckedStatus = ").append(1).append(" \r\n");
        sbSQL.append("\tand a.fOrgBoundId = '").append(this.getOrgTreeId(mapParams)).append("' \r\n");
        sbSQL.append("\tand a.fOrgUnitID = '").append(this.getOrgUnitId(mapParams)).append("' \r\n");
        sbSQL.append("  and a.fperiodType = ").append(this.getPeriodType(mapParams)).append(" \r\n");
        sbSQL.append("  and a.fyear = ").append(this.getYear(mapParams)).append(" \r\n");
        sbSQL.append("  and a.fperiod = ").append(this.getPeriod(mapParams)).append(") \r\n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return false;
    }

    @Override
    protected boolean _isExistInvestCheckageData(Context ctx, Map mapParams) throws BOSException {
        StringBuffer sbSQL = new StringBuffer(" select top 1 fid from T_CSL_InvestCheckage  a  \r\n");
        sbSQL.append(" WHERE a.fOrgBoundId = '").append(this.getOrgTreeId(mapParams)).append("' \r\n");
        sbSQL.append("\tand a.fOrgUnitID = '").append(this.getOrgUnitId(mapParams)).append("' \r\n");
        sbSQL.append("  and a.fperiodType = ").append(this.getPeriodType(mapParams)).append(" \r\n");
        sbSQL.append("  and a.fyear = ").append(this.getYear(mapParams)).append(" \r\n");
        sbSQL.append("  and a.fperiod = ").append(this.getPeriod(mapParams)).append(" \r\n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return false;
    }

    private void fillAssistantItemData(Context ctx, Map mapParams) throws BOSException, EASBizException {
        if (!this._isExistInvestCheckageData(ctx, mapParams)) {
            return;
        }
        try {
            InvestCheckCondition ic = new InvestCheckCondition();
            ic.setOrgTreeId(this.getOrgTreeId(mapParams));
            ic.setOrgBoundId(this.getOrgUnitId(mapParams));
            ic.setPeriodType(this.getPeriodType(mapParams));
            ic.setYear(this.getYear(mapParams));
            ic.setPeriod(this.getPeriod(mapParams));
            ic.setDay(new Date(this.getDate(mapParams).getTime()));
            ic.setCurrencyId(null);
            ic.setCompanyId(null);
            ic.setTargetCompanyId(null);
            ic.setMergeMode(new Boolean(this.getMergeType(mapParams) == 1));
            IInvestCheck iInvestCheck = InvestCheckFactory.getLocalInstance(ctx);
            iInvestCheck.fillInvestItemData(ic);
            logger.info((Object)" execute fillInvestItemData finished.");
            iInvestCheck.fillInterestItemData(ic);
            logger.info((Object)" execute fillInterestItemData finished.");
        }
        catch (EASBizException e) {
            logger.error((Object)(" fill itemdata exception : " + ExceptionUtil.getExcLinkStackTrace((Throwable)e)));
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)(" fill itemdata exception : " + ExceptionUtil.getExcLinkStackTrace((Throwable)e)));
            throw e;
        }
    }

    private String createTempTable(Context ctx) throws BOSException {
        String temp_table1 = "temp_" + this.getCurTimeStr();
        StringBuffer createTableSQL = null;
        createTableSQL = new StringBuffer("Create Table ");
        createTableSQL.append(temp_table1);
        createTableSQL.append("( FItemID VARCHAR(44),  FDataElement int,  FDebit NUMERIC(21,6), FCredit NUMERIC(21,6), \t\r\n");
        createTableSQL.append("  FSummary NVARCHAR(80), FCompanyID VARCHAR(44), FIsVisible int)\t \r\n");
        DbUtil.execute((Context)ctx, (String)createTableSQL.toString());
        return temp_table1;
    }

    private void createIndexForTempTable(Context ctx, String tableName) throws BOSException {
        Timestamp curTime = new Timestamp(System.currentTimeMillis());
        String strTime = curTime.toString();
        StringBuffer sbTableName = new StringBuffer();
        sbTableName.append(strTime.substring(11, 13)).append(strTime.substring(14, 16)).append(strTime.substring(17, 19)).append(strTime.substring(20));
        StringBuffer createIndexSQL = null;
        createIndexSQL = new StringBuffer("CREATE INDEX IX_CSL_").append(sbTableName);
        createIndexSQL.append(" on ").append(tableName);
        createIndexSQL.append(" (FFROMCOMPANYID ASC,Ftocompanyid ASC)\t\r\n");
        DbUtil.execute((Context)ctx, (String)createIndexSQL.toString());
    }

    @Override
    protected void _createElimRecords(Context ctx, Map mapParams) throws BOSException, EASBizException {
        this.fillAssistantItemData(ctx, mapParams);
        String temp_table1 = this.createTempTable(ctx);
        String templetID = null;
        String currencyID = null;
        int templateType = 0;
        List lstTemplate = this.getInvestTempletList(ctx, ElimTypeEnum.MAIN_INVEST);
        IRowSet rs = this.getItemDataCurrencyList(ctx, mapParams);
        try {
            while (rs.next()) {
                int n = lstTemplate.size();
                for (int i = 0; i < n; ++i) {
                    currencyID = rs.getString("FCurrencyId");
                    templetID = ((String)lstTemplate.get(i)).split(SPLITCHAR)[0];
                    templateType = Integer.parseInt(((String)lstTemplate.get(i)).split(SPLITCHAR)[1]);
                    if (this.getMergeType(mapParams) == 1) {
                        if (templateType == 1) {
                            this.generateInvestElimData(ctx, templetID, currencyID, templateType, mapParams, 1, 1, ResourceBase.getString((String)this.resClassName, (String)"Invest_Elimination_NetAsset_BigZero", (Locale)ctx.getOriginLocale()), temp_table1);
                        }
                        if (templateType == 1) {
                            this.generateInvestElimData(ctx, templetID, currencyID, templateType, mapParams, 2, 1, ResourceBase.getString((String)this.resClassName, (String)"Invest_Elimination_NetAsset_SmallZero", (Locale)ctx.getOriginLocale()), temp_table1);
                        }
                        if (templateType == 2) {
                            this.generateInvestElimData(ctx, templetID, currencyID, templateType, mapParams, 1, 2, ResourceBase.getString((String)this.resClassName, (String)"Invest_Elimination_SH_NetAsset_BigZero", (Locale)ctx.getOriginLocale()), temp_table1);
                        }
                        if (templateType == 3) {
                            this.generateInvestElimData(ctx, templetID, currencyID, templateType, mapParams, 1, 1, ResourceBase.getString((String)this.resClassName, (String)"Invest_Elimination_PL_NetAsset_BigZero", (Locale)ctx.getOriginLocale()), temp_table1);
                        }
                        if (templateType == 3) {
                            this.generateInvestElimData(ctx, templetID, currencyID, templateType, mapParams, 2, 1, ResourceBase.getString((String)this.resClassName, (String)"Invest_Elimination_PL_NetAsset_SmallZero", (Locale)ctx.getOriginLocale()), temp_table1);
                        }
                        if (templateType == 4) {
                            this.generateInvestElimData(ctx, templetID, currencyID, templateType, mapParams, 1, 2, ResourceBase.getString((String)this.resClassName, (String)"Invest_Elimination_SHAREHOLDER_PL_BigZero", (Locale)ctx.getOriginLocale()), temp_table1);
                        }
                    }
                    if (this.getMergeType(mapParams) != 0) continue;
                    if (templateType == 5) {
                        this.generateInvestElimData(ctx, templetID, currencyID, templateType, mapParams, 1, 0, ResourceBase.getString((String)this.resClassName, (String)"Invest_Elimination_PARALLEL_RI_BigZero", (Locale)ctx.getOriginLocale()), temp_table1);
                    }
                    if (templateType != 5) continue;
                    this.generateInvestElimData(ctx, templetID, currencyID, templateType, mapParams, 2, 0, ResourceBase.getString((String)this.resClassName, (String)"Invest_Elimination_PARALLEL_RI_SmallZero", (Locale)ctx.getOriginLocale()), temp_table1);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        this.dropTempTable(ctx, temp_table1);
    }

    private void dropTempTable(Context ctx, String tempTableName) throws BOSException {
        DbUtil.execute((Context)ctx, (String)(" drop table " + tempTableName));
    }

    private String getOrgTreeId(Map mapParams) {
        return (String)mapParams.get("OrgTreeID");
    }

    private String getOrgUnitId(Map mapParams) {
        return (String)mapParams.get("OrgUnitID");
    }

    private int getYear(Map mapParams) {
        return (Integer)mapParams.get("Year");
    }

    private int getPeriod(Map mapParams) {
        return (Integer)mapParams.get("Period");
    }

    private int getPeriodType(Map mapParams) {
        return (Integer)mapParams.get("PeriodType");
    }

    private int getMergeType(Map mapParams) {
        return (Integer)mapParams.get("MERGETYPE");
    }

    private Timestamp getDate(Map mapParams) {
        return (Timestamp)mapParams.get("Day");
    }

    private int getElimType(Map mapParams) {
        return (Integer)mapParams.get("ElimType");
    }

    private String getMaxNumber(Context ctx, Map mapParams, String tableName) throws BOSException {
        BigDecimal number = new BigDecimal("1");
        StringBuffer sbSQL = new StringBuffer(" SELECT Max(to_int(substring(fnumber,6,8))) As Fmaxnumber From \r\n");
        sbSQL.append(tableName).append(" a  \r\n");
        sbSQL.append("\tWHERE a.fOrgBoundId = '").append(this.getOrgTreeId(mapParams)).append("' \r\n");
        sbSQL.append("  and a.fyear = ").append(this.getYear(mapParams)).append(" \r\n");
        sbSQL.append("  and a.fperiod = ").append(this.getPeriod(mapParams)).append(" \r\n");
        sbSQL.append("  and a.fperiodType = ").append(this.getPeriodType(mapParams)).append(" \r\n");
        sbSQL.append("  and a.fNumber like N'AUTO\\_%' escape '\\' \r\n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            if (rs.next() && rs.getBigDecimal("Fmaxnumber") != null) {
                number = rs.getBigDecimal("Fmaxnumber").add(new BigDecimal("1"));
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        StringBuffer ret = new StringBuffer("AUTO_");
        int n = 8 - number.toString().length();
        for (int i = 0; i < n; ++i) {
            ret.append("0");
        }
        ret.append(number);
        return ret.toString();
    }

    private void createHeadData(Context ctx, String eliminationID, String templetID, String currencyID, Timestamp elimDate, ElimTypeEnum elimType, Map mapParams) throws BOSException, EASBizException {
        String creatorID = ctx.getCaller().toString();
        Timestamp createTime = new Timestamp(System.currentTimeMillis());
        StringBuffer elimNumber = new StringBuffer();
        EliminationInfo elim = new EliminationInfo();
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)mapParams.get("KEY_ORGTREE_INFO");
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)mapParams.get("KEY_ORGUNIT_INFO");
        elim.setOrgBound(orgTreeInfo);
        elim.setOrgUnit(orgUnitInfo);
        elim.setYear((Integer)mapParams.get("Year"));
        elim.setPeriod((Integer)mapParams.get("Period"));
        boolean hasCodeRule = CSLServerHelper.isHasCodingRuleByOrg(ctx, (IObjectValue)elim, CSLServerHelper.getRootOrgIDForRootCU(ctx));
        String strOrgID = CSLServerHelper.getRootOrgIDForRootCU(ctx);
        String number = "";
        if (strOrgID != null && hasCodeRule) {
            number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)elim, strOrgID);
            elimNumber.append(String.valueOf(number));
        } else {
            elimNumber.append(this.getMaxNumber(ctx, mapParams, "T_CSL_Elimination"));
        }
        StringBuffer insertHead = new StringBuffer(" INSERT INTO T_CSL_Elimination \r\n");
        insertHead.append("(fid, FDate, FCreateTime,FCreatorID,fnumber,forgboundid, forgunit,fperiodtype,  \r\n ");
        insertHead.append(" fyear,fperiod,fsourceCurrencyId,fcurrencyid,ftempletid, \r\n");
        insertHead.append(" fcheckedStatus, fdatasource, farchivedstatus, fvaluetype, felimtype , \r\n");
        insertHead.append(" FDisplayTemplateTypeId) \r\n");
        insertHead.append(" VALUES ('").append(eliminationID).append("', \r\n");
        insertHead.append("TimeStamp'").append(elimDate.toString()).append("', \r\n");
        insertHead.append("TimeStamp'").append(createTime.toString()).append("', \r\n");
        insertHead.append("'").append(creatorID).append("','");
        insertHead.append(elimNumber).append("','").append(this.getOrgTreeId(mapParams)).append("', \r\n");
        insertHead.append("'").append(this.getOrgUnitId(mapParams)).append("', \r\n");
        insertHead.append(this.getPeriodType(mapParams)).append(",").append(this.getYear(mapParams)).append(", \r\n");
        insertHead.append(this.getPeriod(mapParams)).append(",'").append(currencyID).append("','").append(currencyID).append("', \r\n");
        insertHead.append("'").append(templetID).append("', \r\n");
        insertHead.append(1).append(", \r\n");
        insertHead.append(1).append(", \r\n");
        insertHead.append(1).append(", \r\n");
        insertHead.append(1).append(", \r\n");
        insertHead.append(elimType.getValue()).append(", \r\n");
        String displayType = (String)mapParams.get("displayTypeId");
        displayType = displayType == null || "NULL".equals(displayType.toUpperCase(Locale.ENGLISH)) ? "NULL" : "'" + displayType + "'";
        insertHead.append(displayType).append(") \r\n");
        DbUtil.execute((Context)ctx, (String)insertHead.toString());
    }

    private void doInterestReportItemForAllRows(Context ctx, String tempTableName, String summary) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        String fid = null;
        fid = this.getLostProfitRptItem(ctx);
        if (fid == null) {
            return;
        }
        sbSQL.append(" insert into ").append(tempTableName);
        sbSQL.append("(FItemId,FDataElement,FDebit,FCredit,FSummary,FCompanyID,FIsVisible) \r\n");
        sbSQL.append(" select '").append(fid).append("' As FItemId, \r\n");
        sbSQL.append(4).append(" As FDataElement, \r\n");
        sbSQL.append(" fdebit, FCredit, \r\n");
        sbSQL.append(" '").append(summary).append("' As FSummary, \r\n");
        sbSQL.append(" fcompanyid As FCompanyId, \r\n");
        sbSQL.append(" 0 As FIsVisible \r\n");
        sbSQL.append(" from ").append(tempTableName).append(" t1 join t_csl_RptItem t2 on t1.FItemId = t2.FId \r\n");
        sbSQL.append(" where t2.FIsProfitAndLosses = 1 \r\n");
        sbSQL.append(" and t1.FDataElement = ").append(3);
        DbUtil.execute((Context)ctx, (String)sbSQL.toString());
    }

    private void generateInvestElimData(Context ctx, String templetID, String currencyID, int templateType, Map mapParams, int isNetAsset, int isChecked, String summary, String tempTableName) throws BOSException, EASBizException {
        Statement st2;
        Statement st;
        Connection conn;
        block25: {
            int currencyPrecision = 2;
            String currencySql = " select fprecision from t_bd_currency where fid = '" + currencyID + "'";
            IRowSet currencyRowSet = DbUtil.executeQuery((Context)ctx, (String)currencySql);
            try {
                if (currencyRowSet.next()) {
                    currencyPrecision = currencyRowSet.getInt("fprecision");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            IRowSet rs_1 = this.getEliminationTempData(ctx, templateType, this.getOrgTreeId(mapParams), this.getOrgUnitId(mapParams), this.getYear(mapParams), this.getPeriod(mapParams), this.getPeriodType(mapParams), currencyID, isNetAsset, isChecked);
            conn = null;
            st = null;
            st2 = null;
            try {
                String eliminationID = null;
                boolean isInsertHead = false;
                conn = super.getConnection(ctx);
                st = conn.createStatement();
                st2 = conn.createStatement();
                Hashtable ht = this.getParentItemList(ctx);
                while (rs_1.next()) {
                    BigDecimal valiCredit;
                    String itemId = rs_1.getString("fItemId");
                    BigDecimal valiDebit = rs_1.getBigDecimal("fDebit");
                    if (valiDebit != null) {
                        valiDebit = valiDebit.setScale(currencyPrecision, 4);
                    }
                    if ((valiCredit = rs_1.getBigDecimal("fCredit")) != null) {
                        valiCredit = valiCredit.setScale(currencyPrecision, 4);
                    }
                    String companyID = rs_1.getString("fCompanyID");
                    int dataElement = rs_1.getInt("FDataElement");
                    StringBuffer sbInsertLine = new StringBuffer(" INSERT INTO ").append(tempTableName).append("\t\r\n");
                    sbInsertLine.append("   (fitemid, fDataElement, fdebit, fcredit, FSummary, fCompanyID,fisvisible) \r\n");
                    sbInsertLine.append(" VALUES (");
                    sbInsertLine.append("'").append(itemId).append("', \r\n");
                    sbInsertLine.append(dataElement).append(", \r\n");
                    sbInsertLine.append(valiDebit).append(",").append(valiCredit).append(",'").append(summary).append("','");
                    sbInsertLine.append(companyID).append("',1) \r\n");
                    st.addBatch(sbInsertLine.toString());
                    this.doInsertParentEntry(ctx, itemId, rs_1, ht, tempTableName, summary, currencyPrecision);
                }
                st.executeBatch();
                st.clearBatch();
                this.doInterestReportItemForAllRows(ctx, tempTableName, summary);
                this.autoCreateRelationshipItems(ctx, tempTableName, currencyPrecision);
                IRowSet rsSumItem = this.generateSumItem(ctx, tempTableName);
                int lineSeq = 0;
                boolean isInsert = true;
                while (rsSumItem.next()) {
                    if (rsSumItem.getBigDecimal("FDebit") != null && rsSumItem.getBigDecimal("FCredit") != null && rsSumItem.getBigDecimal("FDebit").compareTo(new BigDecimal("0")) == 0 && rsSumItem.getBigDecimal("FCredit").compareTo(new BigDecimal("0")) == 0) {
                        isInsert = false;
                    }
                    if (isInsert) {
                        BigDecimal valiCredit;
                        if (!isInsertHead) {
                            eliminationID = BOSUuid.create((String)ELIMINATION_BOSTYPE).toString();
                            this.createHeadData(ctx, eliminationID, templetID, currencyID, this.getDate(mapParams), ElimTypeEnum.MAIN_INVEST, mapParams);
                            isInsertHead = true;
                        }
                        String lineId = new ObjectUuidPK(new BOSObjectType(ELIMINATION_ENTRY_BOSTYPE)).toString();
                        ++lineSeq;
                        String itemId = rsSumItem.getString("fItemId");
                        BigDecimal valiDebit = rsSumItem.getBigDecimal("fDebit");
                        if (valiDebit != null) {
                            valiDebit = valiDebit.setScale(currencyPrecision, 4);
                        }
                        if ((valiCredit = rsSumItem.getBigDecimal("fCredit")) != null) {
                            valiCredit = valiCredit.setScale(currencyPrecision, 4);
                        }
                        String companyID = rsSumItem.getString("fCompanyID");
                        int dataElement = rsSumItem.getInt("FDataElement");
                        StringBuffer sbInsertLine = new StringBuffer(" INSERT INTO T_CSL_EliminationEntry \r\n");
                        sbInsertLine.append("   (fid, fseq, fitemid, fDataElement, fdebit, fcredit, FSummary, feliminationId, fCompanyID, FIsVisible) \r\n");
                        sbInsertLine.append(" VALUES  \r\n");
                        sbInsertLine.append(" ('").append(lineId).append("',").append(lineSeq);
                        sbInsertLine.append(",'").append(itemId).append("', \r\n");
                        sbInsertLine.append(dataElement).append(", \r\n");
                        sbInsertLine.append(valiDebit).append(",").append(valiCredit).append(",'").append(summary).append("','");
                        sbInsertLine.append(eliminationID).append("','").append(companyID).append("', \r\n");
                        sbInsertLine.append(rsSumItem.getInt("fisvisible")).append(")");
                        st2.addBatch(sbInsertLine.toString());
                    }
                    isInsert = true;
                }
                st2.executeBatch();
                st2.clearBatch();
                this.removeDataFromTempTable(ctx, tempTableName);
                String investTableName = "T_CSL_InvestCheckage";
                String interestTableName = "T_CSL_InterestCheckage";
                if (eliminationID == null) break block25;
                if (this.getMergeType(mapParams) == 1) {
                    if (templateType == 1) {
                        this.generateElimRecordData(ctx, investTableName, eliminationID, mapParams, currencyID, 1, 1);
                    }
                    if (templateType == 1) {
                        this.generateElimRecordData(ctx, investTableName, eliminationID, mapParams, currencyID, 2, 1);
                    }
                    if (templateType == 2) {
                        this.generateElimRecordData(ctx, investTableName, eliminationID, mapParams, currencyID, 2, 1);
                    }
                    if (templateType == 3) {
                        this.generateElimRecordData(ctx, interestTableName, eliminationID, mapParams, currencyID, 1, 1);
                    }
                    if (templateType == 3) {
                        this.generateElimRecordData(ctx, interestTableName, eliminationID, mapParams, currencyID, 2, 1);
                    }
                    if (templateType == 4) {
                        this.generateElimRecordData(ctx, interestTableName, eliminationID, mapParams, currencyID, 1, 2);
                    }
                }
                if (this.getMergeType(mapParams) != 0) break block25;
                if (templateType == 5) {
                    this.generateElimRecordData(ctx, investTableName, eliminationID, mapParams, currencyID, 1, 0);
                }
                if (templateType == 5) {
                    this.generateElimRecordData(ctx, investTableName, eliminationID, mapParams, currencyID, 2, 0);
                }
            }
            catch (SQLException e) {
                try {
                    throw new SQLDataException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(st, conn);
                    SQLUtils.cleanup(st2);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
        SQLUtils.cleanup((Statement)st2);
    }

    private void autoCreateRelationshipItems(Context ctx, String tempTableName, int currencyPrecision) throws BOSException, EASBizException {
        Map itemMap = RptItemRelationshipFactory.getLocalInstance(ctx).getItemRelationshipMap(3);
        this.autoCreateRelationshipItems(ctx, tempTableName, itemMap, currencyPrecision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoCreateRelationshipItems(Context ctx, String tempTableName, Map itemMap, int currencyPrecision) throws BOSException, EASBizException {
        block15: {
            if (itemMap != null) {
                Map itemIdMap = (Map)itemMap.get("itemIdMap");
                itemMap.remove("itemIdMap");
                if (itemMap.isEmpty()) {
                    return;
                }
                IRowSet rs = null;
                Connection conn = null;
                Statement st = null;
                try {
                    conn = super.getConnection(ctx);
                    st = conn.createStatement();
                    StringBuffer sql = new StringBuffer();
                    sql.append("select t2.fid,t2.fnumber,t1.FDataElement,t1.FDebit,t1.FCredit,t1.FCompanyID from ").append(tempTableName).append(" t1 \r\n");
                    sql.append(" join t_csl_RptItem t2 on t1.FItemId = t2.FId ");
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    String summary = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ItemRelationshipResource", (String)"1SysAutoElim", (Locale)ctx.getOriginLocale());
                    while (rs.next()) {
                        BigDecimal valiCredit;
                        BigDecimal valiDebit = rs.getBigDecimal("fDebit");
                        if (valiDebit != null) {
                            valiDebit = valiDebit.setScale(currencyPrecision, 4);
                        }
                        if ((valiCredit = rs.getBigDecimal("fCredit")) != null) {
                            valiCredit = valiCredit.setScale(currencyPrecision, 4);
                        }
                        String companyID = rs.getString("fCompanyID");
                        List createItemList = RptItemRelationshipFactory.getLocalInstance(ctx).getAutoCreateItemList(itemMap, rs.getString("fnumber"), rs.getString("FDataElement"));
                        Iterator iter = createItemList.iterator();
                        while (iter.hasNext()) {
                            String element = iter.next().toString();
                            String number = element.split(";")[0];
                            RPTItemInfo item = (RPTItemInfo)itemIdMap.get(number);
                            String itemId = null;
                            if (item == null) {
                                RPTItemCollection itemCollection = RPTItemFactory.getLocalInstance(ctx).getRPTItemCollection("select id,number where isFreezed = 0 and number='" + number + "'");
                                if (itemCollection != null && itemCollection.size() > 0) {
                                    itemId = itemCollection.get(0).getId().toString();
                                    itemIdMap.put(itemCollection.get(0).getNumber(), itemCollection.get(0));
                                }
                            } else if (!item.isIsFreezed()) {
                                itemId = item.getId().toString();
                            }
                            if (itemId == null) continue;
                            String dataElement = element.split(";")[1];
                            StringBuffer sbInsertLine = new StringBuffer(" INSERT INTO ").append(tempTableName).append("\t\r\n");
                            sbInsertLine.append(" (fitemid, fDataElement, fdebit, fcredit, FSummary, fCompanyID,fisvisible) \r\n");
                            sbInsertLine.append(" VALUES (");
                            sbInsertLine.append("'").append(itemId).append("', \r\n");
                            sbInsertLine.append(dataElement).append(", \r\n");
                            sbInsertLine.append(valiDebit).append(",").append(valiCredit).append(",'").append(summary).append("','");
                            sbInsertLine.append(companyID).append("',0) \r\n");
                            st.addBatch(sbInsertLine.toString());
                        }
                    }
                    st.executeBatch();
                    st.clearBatch();
                    SQLUtils.cleanup((ResultSet)rs);
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage());
                    break block15;
                }
                finally {
                    SQLUtils.cleanup(rs);
                    SQLUtils.cleanup((Statement)st, (Connection)conn);
                }
                SQLUtils.cleanup((Statement)st, (Connection)conn);
            }
        }
    }

    private String getLostProfitRptItem(Context ctx) throws BOSException {
        String fid = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)"select FId From t_csl_RptItem where FControl = 27");
            if (rs.next()) {
                fid = rs.getString("FId");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return fid;
    }

    private IRowSet getEliminationTempData(Context ctx, int templetType, String orgTreeID, String orgUnitID, int year, int period, int periodType, String currencyId, int isNetAsset, int isChecked) throws BOSException {
        StringBuffer target = new StringBuffer();
        ResultSet rsTemp = null;
        PreparedStatement ps = null;
        Connection conn = null;
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" SELECT FTargetCompanyID FROM T_CSL_IIASSISTANT ");
        sbSQL.append(this.getNetAssetAndCheckedSQL(isNetAsset, isChecked, orgTreeID, orgUnitID));
        try {
            conn = super.getConnection(ctx);
            ps = conn.prepareStatement(sbSQL.toString());
            rsTemp = ps.executeQuery();
            boolean first = true;
            while (rsTemp.next()) {
                if (!first) {
                    target.append(",");
                } else {
                    first = false;
                }
                target.append("'").append(rsTemp.getString("FTargetCompanyId")).append("'");
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rsTemp, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rsTemp, (Statement)ps, (Connection)conn);
        if (target.length() < 1) {
            target.append("''");
        }
        StringBuffer investSql = new StringBuffer();
        investSql.append(" SELECT '' as FID, '' as FEliminationID, item.FID as fItemID,a1.FCurrencyId,a2.FDataElement, \r\n");
        investSql.append(" case a1.Fdc WHEN 1 THEN SUM(a1.FMoney) WHEN 5 THEN SUM(a1.FMoney) ELSE NULL END As FDebit,  \r\n");
        investSql.append(" TO_Decimal(null) As FCredit, \r\n");
        investSql.append(" a1.FTargetCompanyID as FCompanyId \r\n");
        investSql.append(" FROM T_CSL_IIASSISTANTITEMDATA a1 join \r\n");
        investSql.append(" (select t2.FCompanyType,t2.FdcType,t2.FControlAttr,t2.FDataElement \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 0 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2) ");
        investSql.append(" union \r\n");
        investSql.append(" select t2.FCompanyType,t2.FDcType,t3.FControl as FControlAttr,t2.FDataElement \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" join t_csl_RptControl t3 on t2.FType = t3.FType \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 1 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2) ");
        investSql.append(" ) a2 \r\n");
        investSql.append(" on a1.FControlAttr = a2.FControlAttr \r\n");
        investSql.append(" and a1.FDataElement = a2.FDataElement");
        investSql.append(" join T_CSL_RptItem item \r\n");
        investSql.append(" on item.fNumber=a1.FItemNumber \r\n");
        investSql.append(" where a1.forgboundid='").append(orgTreeID).append("' \r\n");
        investSql.append(" and a1.forgunitid='").append(orgUnitID).append("' \r\n");
        investSql.append(" and a1.fperiodtype = ").append(periodType).append(" \r\n");
        investSql.append(" and a1.fyear = ").append(year).append(" \r\n");
        investSql.append(" and a1.fperiod = ").append(period).append(" \r\n");
        investSql.append(" and a1.fcurrencyId = '").append(currencyId).append("' \r\n");
        investSql.append(" and a1.FControlAttr in ( \r\n");
        investSql.append(" select t2.FControlAttr \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId  \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 0 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2)");
        investSql.append(" And a2.FCompanyType = 2 \r\n");
        investSql.append(" union \r\n ");
        investSql.append(" select t3.FControl as FControlAttr \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" join t_csl_RptControl t3 on t2.FType = t3.FType \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 1 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2)");
        investSql.append(" And a2.FCompanyType = 2 \r\n");
        investSql.append(" ) \r\n");
        if (templetType != 31) {
            investSql.append(" and ftargetcompanyid in  \r\n");
            investSql.append(" ( \r\n");
            investSql.append(target.toString());
            investSql.append(" )  \r\n");
        }
        investSql.append(" and a1.fdc = 1 \r\n");
        if (templetType == 31) {
            investSql.append(" and (a1.FFlag <> ").append(3);
            investSql.append(" and a1.FFlag <> ").append(5).append(") \r\n");
        } else if (templetType == 3) {
            investSql.append(" and (a1.FFlag <> ").append(31);
            investSql.append(" and a1.FFlag <> ").append(5).append(") \r\n");
        } else if (templetType == 5) {
            investSql.append(" and (a1.FFlag <> ").append(31);
            investSql.append(" and a1.FFlag <> ").append(3).append(") \r\n");
        }
        investSql.append(" Group by ftargetcompanyid,FCurrencyId,item.FID,a2.FDataElement,a1.FDc,a2.FCompanyType \r\n");
        if (templetType == 31) {
            IRowSet rs = null;
            String itemId = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)"select fid from t_csl_rptitem where fcontrol=5");
                if (rs.next()) {
                    itemId = rs.getString("fid");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (itemId != null) {
                investSql.append(" UNION \r\n");
                investSql.append(" SELECT '' as FID, '' as FEliminationID, ");
                investSql.append(" '").append(itemId).append("' As FItemId,");
                investSql.append(" a1.FCurrencyId As FCurrencyId,").append(4).append(" As FDataElement, \r\n");
                investSql.append(" TO_DECIMAL(null) As Fdebit, \r\n");
                investSql.append(" case a1.Fdc WHEN 1 THEN SUM(a1.FMoney) WHEN 5 THEN SUM(a1.FMoney) ELSE NULL END As FCredit,  \r\n");
                investSql.append(" a1.FTargetCompanyID as FCompanyId \r\n");
                investSql.append(" FROM T_CSL_IIASSISTANTITEMDATA a1 join \r\n");
                investSql.append(" (select t2.FCompanyType,t2.FdcType,t2.FControlAttr,t2.FDataElement \r\n");
                investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
                investSql.append(" Where FElimType=").append(4);
                investSql.append(" and FIsUsingType = 0 and FTempletType=").append(templetType);
                investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2) ");
                investSql.append(" union \r\n");
                investSql.append(" select t2.FCompanyType,t2.FDcType,t3.FControl as FControlAttr,t2.FDataElement \r\n");
                investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
                investSql.append(" join t_csl_RptControl t3 on t2.FType = t3.FType \r\n");
                investSql.append(" Where FElimType=").append(4);
                investSql.append(" and FIsUsingType = 1 and FTempletType=").append(templetType);
                investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2) ");
                investSql.append(" ) a2 \r\n");
                investSql.append(" on a1.FControlAttr = a2.FControlAttr \r\n");
                investSql.append(" and a1.FDataElement = a2.FDataElement");
                investSql.append(" join T_CSL_RptItem item \r\n");
                investSql.append(" on item.fNumber=a1.FItemNumber \r\n");
                investSql.append(" where a1.forgboundid='").append(orgTreeID).append("' \r\n");
                investSql.append(" and a1.forgunitid='").append(orgUnitID).append("' \r\n");
                investSql.append(" and a1.fperiodtype = ").append(periodType).append(" \r\n");
                investSql.append(" and a1.fyear = ").append(year).append(" \r\n");
                investSql.append(" and a1.fperiod = ").append(period).append(" \r\n");
                investSql.append(" and a1.fcurrencyId = '").append(currencyId).append("' \r\n");
                investSql.append(" and a1.FControlAttr in ( \r\n");
                investSql.append(" select t2.FControlAttr \r\n");
                investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId  \r\n");
                investSql.append(" Where FElimType=").append(4);
                investSql.append(" and FIsUsingType = 0 and FTempletType=").append(templetType);
                investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2)");
                investSql.append(" And a2.FCompanyType = 2 \r\n");
                investSql.append(" union \r\n ");
                investSql.append(" select t3.FControl as FControlAttr \r\n");
                investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
                investSql.append(" join t_csl_RptControl t3 on t2.FType = t3.FType \r\n");
                investSql.append(" Where FElimType=").append(4);
                investSql.append(" and FIsUsingType = 1 and FTempletType=").append(templetType);
                investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2)");
                investSql.append(" And a2.FCompanyType = 2 \r\n");
                investSql.append(" ) \r\n");
                if (templetType != 31) {
                    investSql.append(" and ftargetcompanyid in  \r\n");
                    investSql.append(" ( \r\n");
                    investSql.append(target.toString());
                    investSql.append(" )  \r\n");
                }
                investSql.append(" and a1.fdc = 1 \r\n");
                investSql.append(" and a2.fDataElement = ").append(3);
                if (templetType == 31) {
                    investSql.append(" and (a1.FFlag <> ").append(3);
                    investSql.append(" and a1.FFlag <> ").append(5).append(") \r\n");
                } else if (templetType == 3) {
                    investSql.append(" and (a1.FFlag <> ").append(31);
                    investSql.append(" and a1.FFlag <> ").append(5).append(") \r\n");
                } else if (templetType == 5) {
                    investSql.append(" and (a1.FFlag <> ").append(31);
                    investSql.append(" and a1.FFlag <> ").append(3).append(") \r\n");
                }
                investSql.append(" Group by ftargetcompanyid,FCurrencyId,a2.FDataElement,a1.FDc,a2.FCompanyType \r\n");
            }
            return DbUtil.executeQuery((Context)ctx, (String)investSql.toString());
        }
        investSql.append(" UNION \r\n");
        investSql.append(" SELECT '' as FID, '' as FEliminationID, item.FID as fItemID,a1.FCurrencyId,a2.FDataElement, \r\n");
        investSql.append(" TO_DECIMAL(null) As FDebit,  \r\n");
        investSql.append(" case a1.Fdc WHEN 2 THEN SUM(a1.FMoney) WHEN 6 THEN SUM(a1.FMoney) ELSE NULL END As FCredit, \r\n");
        investSql.append(" a1.FTargetCompanyID as FCompanyId \r\n");
        investSql.append(" FROM T_CSL_IIASSISTANTITEMDATA a1 join \r\n");
        investSql.append(" (select t2.FCompanyType,t2.FdcType,t2.FControlAttr,t2.FDataElement \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 0 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2) ");
        investSql.append(" union \r\n");
        investSql.append(" select t2.FCompanyType,t2.FDcType,t3.FControl as FControlAttr,t2.FDataElement \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" join t_csl_RptControl t3 on t2.FType = t3.FType \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 1 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2) ");
        investSql.append(" ) a2 \r\n");
        investSql.append(" on a1.FControlAttr = a2.FControlAttr \r\n");
        investSql.append(" and a1.FDataElement = a2.FDataElement");
        investSql.append(" join T_CSL_RptItem item \r\n");
        investSql.append(" on item.fNumber=a1.FItemNumber \r\n");
        investSql.append(" where a1.forgboundid='").append(orgTreeID).append("' \r\n");
        investSql.append(" and a1.forgunitid='").append(orgUnitID).append("' \r\n");
        investSql.append(" and a1.fperiodtype = ").append(periodType).append(" \r\n");
        investSql.append(" and a1.fyear = ").append(year).append(" \r\n");
        investSql.append(" and a1.fperiod = ").append(period).append(" \r\n");
        investSql.append(" and a1.fcurrencyId = '").append(currencyId).append("' \r\n");
        investSql.append(" and a1.FControlAttr in ( \r\n");
        investSql.append(" select t2.FControlAttr \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId  \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 0 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2)");
        investSql.append(" And a2.FCompanyType = 2 \r\n");
        investSql.append(" union \r\n ");
        investSql.append(" select t3.FControl as FControlAttr \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" join t_csl_RptControl t3 on t2.FType = t3.FType \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 1 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2)");
        investSql.append(" And a2.FCompanyType = 2 \r\n");
        investSql.append(" ) \r\n");
        if (templetType != 31) {
            investSql.append(" and ftargetcompanyid in  \r\n");
            investSql.append(" ( \r\n");
            investSql.append(target.toString());
            investSql.append(" )  \r\n");
        }
        investSql.append(" and a1.fdc = 2 \r\n");
        if (templetType == 31) {
            investSql.append(" and (a1.FFlag <> ").append(3);
            investSql.append(" and a1.FFlag <> ").append(5).append(") \r\n");
        } else if (templetType == 3) {
            investSql.append(" and (a1.FFlag <> ").append(31);
            investSql.append(" and a1.FFlag <> ").append(5).append(") \r\n");
        } else if (templetType == 5) {
            investSql.append(" and (a1.FFlag <> ").append(31);
            investSql.append(" and a1.FFlag <> ").append(3).append(") \r\n");
        }
        investSql.append(" Group by ftargetcompanyid,FCurrencyId,item.FID,a2.FDataElement,a1.FDc,a2.FCompanyType \r\n");
        investSql.append(" UNION \r\n");
        investSql.append(" SELECT '' as FID, '' as FEliminationID, item.FID as fItemID,a1.FCurrencyId,a2.FDataElement, \r\n");
        investSql.append(" case a1.Fdc WHEN 1 THEN SUM(a1.FMoney) WHEN 5 THEN SUM(a1.FMoney) ELSE NULL END As FDebit, \r\n");
        investSql.append(" case a1.Fdc WHEN 2 THEN SUM(a1.FMoney) WHEN 6 THEN SUM(a1.FMoney) ELSE NULL END As FCredit, \r\n");
        investSql.append(" a1.FTargetCompanyID as FCompanyId \r\n");
        investSql.append(" FROM T_CSL_IIASSISTANTITEMDATA a1 join \r\n");
        investSql.append(" (select t2.FCompanyType,t2.FdcType,t2.FControlAttr,t2.FDataElement \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 0 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2) ");
        investSql.append(" union \r\n");
        investSql.append(" select t2.FCompanyType,t2.FDcType,t3.FControl as FControlAttr,t2.FDataElement \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" join t_csl_RptControl t3 on t2.FType = t3.FType \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 1 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2) ");
        investSql.append(" ) a2 \r\n");
        investSql.append(" on a1.FControlAttr = a2.FControlAttr \r\n");
        investSql.append(" and a1.FDataElement = a2.FDataElement \r\n");
        investSql.append(" join T_CSL_RptItem item \r\n");
        investSql.append(" on item.fNumber=a1.FItemNumber \r\n");
        investSql.append(" where a1.forgboundid='").append(orgTreeID).append("' \r\n");
        investSql.append(" and a1.forgunitid='").append(orgUnitID).append("' \r\n");
        investSql.append(" and a1.fperiodtype = ").append(periodType).append(" \r\n");
        investSql.append(" and a1.fyear = ").append(year).append(" \r\n");
        investSql.append(" and a1.fperiod = ").append(period).append(" \r\n");
        investSql.append(" and a1.fcurrencyId = '").append(currencyId).append("' \r\n");
        investSql.append(" and a1.FControlAttr in ( \r\n");
        investSql.append(" select t2.FControlAttr \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId  \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 0 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2)");
        investSql.append(" And a2.FCompanyType = 2 \r\n");
        investSql.append(" union \r\n ");
        investSql.append(" select t3.FControl as FControlAttr \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" join t_csl_RptControl t3 on t2.FType = t3.FType \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 1 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2)");
        investSql.append(" And a2.FCompanyType = 2 \r\n");
        investSql.append(" ) \r\n");
        if (templetType != 31) {
            investSql.append(" and ftargetcompanyid in  \r\n");
            investSql.append(" ( \r\n");
            investSql.append(target.toString());
            investSql.append(" )  \r\n");
        }
        investSql.append(" and (a1.fdc<>1 and a1.fdc<>2)");
        if (templetType == 31) {
            investSql.append(" and (a1.FFlag <> ").append(3);
            investSql.append(" and a1.FFlag <> ").append(5).append(") \r\n");
        } else if (templetType == 3) {
            investSql.append(" and (a1.FFlag <> ").append(31);
            investSql.append(" and a1.FFlag <> ").append(5).append(") \r\n");
        } else if (templetType == 5) {
            investSql.append(" and (a1.FFlag <> ").append(31);
            investSql.append(" and a1.FFlag <> ").append(3).append(") \r\n");
        }
        investSql.append(" Group by ftargetcompanyid,FCurrencyId,item.FID,a2.FDataElement,a1.FDc,a2.FCompanyType \r\n");
        investSql.append(" Having  Sum(a1.FMoney)>=0  \r\n");
        investSql.append(" UNION \r\n");
        investSql.append(" SELECT '' as FID, '' as FEliminationID, item.FID as fItemID,a1.FCurrencyId,a2.FDataElement, \r\n");
        investSql.append(" case a1.Fdc WHEN 1 THEN SUM(a1.FMoney) WHEN 6 THEN ABS(SUM(a1.FMoney)) ELSE NULL END As FDebit, \r\n");
        investSql.append(" case a1.Fdc WHEN 2 THEN SUM(a1.FMoney) WHEN 5 THEN ABS(SUM(a1.FMoney)) ELSE NULL END As FCredit, \r\n");
        investSql.append(" a1.FTargetCompanyID as FCompanyId \r\n");
        investSql.append(" FROM T_CSL_IIASSISTANTITEMDATA a1 join \r\n");
        investSql.append(" (select t2.FCompanyType,t2.FDcType,t2.FControlAttr,t2.FDataElement \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 0 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2) ");
        investSql.append(" union \r\n");
        investSql.append(" select t2.FCompanyType,t2.FDcType,t3.FControl as FControlAttr,t2.FDataElement \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" join t_csl_RptControl t3 on t2.FType = t3.FType \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 1 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2) ");
        investSql.append(" ) a2 \r\n");
        investSql.append(" on a1.FControlAttr = a2.FControlAttr \r\n");
        investSql.append(" and a1.FDataElement = a2.FDataElement \r\n");
        investSql.append(" join T_CSL_RptItem item \r\n");
        investSql.append(" on item.fNumber=a1.FItemNumber \r\n");
        investSql.append(" where a1.forgboundid='").append(orgTreeID).append("' \r\n");
        investSql.append(" and a1.forgunitid='").append(orgUnitID).append("' \r\n");
        investSql.append(" and a1.fperiodtype = ").append(periodType).append(" \r\n");
        investSql.append(" and a1.fyear = ").append(year).append(" \r\n");
        investSql.append(" and a1.fperiod = ").append(period).append(" \r\n");
        investSql.append(" and a1.fcurrencyId = '").append(currencyId).append("' \r\n");
        investSql.append(" and a1.FControlAttr in ( \r\n");
        investSql.append(" select t2.FControlAttr \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId  \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 0 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2)");
        investSql.append(" And a2.FCompanyType = 2 \r\n");
        investSql.append(" union \r\n ");
        investSql.append(" select t3.FControl as FControlAttr \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" join t_csl_RptControl t3 on t2.FType = t3.FType \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 1 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2)");
        investSql.append(" And a2.FCompanyType = 2 \r\n");
        investSql.append(" ) \r\n");
        if (templetType != 31) {
            investSql.append(" and ftargetcompanyid in  \r\n");
            investSql.append(" ( \r\n");
            investSql.append(target.toString());
            investSql.append(" )  \r\n");
        }
        investSql.append(" and (a1.fdc<>1 and a1.fdc<>2)");
        if (templetType == 31) {
            investSql.append(" and (a1.FFlag <> ").append(3);
            investSql.append(" and a1.FFlag <> ").append(5).append(") \r\n");
        } else if (templetType == 3) {
            investSql.append(" and (a1.FFlag <> ").append(31);
            investSql.append(" and a1.FFlag <> ").append(5).append(") \r\n");
        } else if (templetType == 5) {
            investSql.append(" and (a1.FFlag <> ").append(31);
            investSql.append(" and a1.FFlag <> ").append(3).append(") \r\n");
        }
        investSql.append(" Group by ftargetcompanyid,FCurrencyId,item.FID,a2.FDataElement,a1.FDc,a2.FCompanyType \r\n");
        investSql.append(" Having  Sum(a1.FMoney) < 0  \r\n");
        investSql.append(" UNION \r\n");
        investSql.append(" SELECT '' as FID, '' as FEliminationID, item.FID as fItemID,a1.FCurrencyId,a2.FDataElement, \r\n");
        investSql.append(" case a1.Fdc WHEN 1 THEN SUM(a1.FMoney) WHEN 5 THEN SUM(a1.FMoney) ELSE NULL END As FDebit, \r\n");
        investSql.append(" TO_DECIMAL(null) As FCredit, \r\n");
        investSql.append(" a1.FCompanyID as FCompanyId \r\n");
        investSql.append(" FROM T_CSL_IIASSISTANTITEMDATA a1 join \r\n");
        investSql.append(" (select t2.FCompanyType,t2.FDcType,t2.FControlAttr,t2.FDataElement \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 0 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2) ");
        investSql.append(" union \r\n");
        investSql.append(" select t2.FCompanyType,t2.FDcType,t3.FControl as FControlAttr,t2.FDataElement \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" join t_csl_RptControl t3 on t2.FType = t3.FType \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 1 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2) ");
        investSql.append(" ) a2 \r\n");
        investSql.append(" on a1.FControlAttr = a2.FControlAttr \r\n");
        investSql.append(" and a1.FDataElement = a2.FDataElement \r\n");
        investSql.append(" join T_CSL_RptItem item \r\n");
        investSql.append(" on item.fNumber=a1.FItemNumber \r\n");
        investSql.append(" where a1.forgboundid='").append(orgTreeID).append("' \r\n");
        investSql.append(" and a1.forgunitid='").append(orgUnitID).append("' \r\n");
        investSql.append(" and a1.fperiodtype = ").append(periodType).append(" \r\n");
        investSql.append(" and a1.fyear = ").append(year).append(" \r\n");
        investSql.append(" and a1.fperiod = ").append(period).append(" \r\n");
        investSql.append(" and a1.fcurrencyId = '").append(currencyId).append("' \r\n");
        investSql.append(" and a1.FControlAttr in ( \r\n");
        investSql.append(" select t2.FControlAttr \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId  \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 0 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2)");
        investSql.append(" And a2.FCompanyType = 1 \r\n");
        investSql.append(" union \r\n ");
        investSql.append(" select t3.FControl as FControlAttr \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" join t_csl_RptControl t3 on t2.FType = t3.FType \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 1 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2)");
        investSql.append(" And a2.FCompanyType = 1 \r\n");
        investSql.append(" ) \r\n");
        if (templetType != 31) {
            investSql.append(" and a1.FTargetCompanyID in ( \r\n");
            investSql.append(target.toString());
            investSql.append(")  \r\n");
        }
        investSql.append(" and a1.fdc=1 \r\n");
        if (templetType == 31) {
            investSql.append(" and (a1.FFlag <> ").append(3);
            investSql.append(" and a1.FFlag <> ").append(5).append(") \r\n");
        } else if (templetType == 3) {
            investSql.append(" and (a1.FFlag <> ").append(31);
            investSql.append(" and a1.FFlag <> ").append(5).append(") \r\n");
        } else if (templetType == 5) {
            investSql.append(" and (a1.FFlag <> ").append(31);
            investSql.append(" and a1.FFlag <> ").append(3).append(") \r\n");
        }
        investSql.append(" Group by fcompanyid,FCurrencyId,item.FID,a2.FDataElement,a1.FDc,a2.FCompanyType \r\n");
        investSql.append(" UNION \r\n");
        investSql.append(" SELECT '' as FID, '' as FEliminationID, item.FID as fItemID,a1.FCurrencyId,a2.FDataElement, \r\n");
        investSql.append(" TO_DECIMAL(null) As FDebit, \r\n");
        investSql.append(" case a1.Fdc WHEN 2 THEN SUM(a1.FMoney) WHEN 6 THEN SUM(a1.FMoney) ELSE NULL END As FCredit, \r\n");
        investSql.append(" a1.FCompanyID as FCompanyId \r\n");
        investSql.append(" FROM T_CSL_IIASSISTANTITEMDATA a1 join \r\n");
        investSql.append(" (select t2.FCompanyType,t2.FDcType,t2.FControlAttr,t2.FDataElement \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 0 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2) ");
        investSql.append(" union \r\n");
        investSql.append(" select t2.FCompanyType,t2.FDcType,t3.FControl as FControlAttr,t2.FDataElement \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" join t_csl_RptControl t3 on t2.FType = t3.FType \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 1 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2) ");
        investSql.append(" ) a2 \r\n");
        investSql.append(" on a1.FControlAttr = a2.FControlAttr \r\n");
        investSql.append(" and a1.FDataElement = a2.FDataElement \r\n");
        investSql.append(" join T_CSL_RptItem item \r\n");
        investSql.append(" on item.fNumber=a1.FItemNumber \r\n");
        investSql.append(" where a1.forgboundid='").append(orgTreeID).append("' \r\n");
        investSql.append(" and a1.forgunitid='").append(orgUnitID).append("' \r\n");
        investSql.append(" and a1.fperiodtype = ").append(periodType).append(" \r\n");
        investSql.append(" and a1.fyear = ").append(year).append(" \r\n");
        investSql.append(" and a1.fperiod = ").append(period).append(" \r\n");
        investSql.append(" and a1.fcurrencyId = '").append(currencyId).append("' \r\n");
        investSql.append(" and a1.FControlAttr in ( \r\n");
        investSql.append(" select t2.FControlAttr \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId  \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 0 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2)");
        investSql.append(" And a2.FCompanyType = 1 \r\n");
        investSql.append(" union \r\n ");
        investSql.append(" select t3.FControl as FControlAttr \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" join t_csl_RptControl t3 on t2.FType = t3.FType \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 1 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2)");
        investSql.append(" And a2.FCompanyType = 1 \r\n");
        investSql.append(" ) \r\n");
        if (templetType != 31) {
            investSql.append(" and a1.FTargetCompanyID in ( \r\n");
            investSql.append(target.toString());
            investSql.append(")  \r\n");
        }
        investSql.append(" and a1.fdc=2 \r\n");
        if (templetType == 31) {
            investSql.append(" and (a1.FFlag <> ").append(3);
            investSql.append(" and a1.FFlag <> ").append(5).append(") \r\n");
        } else if (templetType == 3) {
            investSql.append(" and (a1.FFlag <> ").append(31);
            investSql.append(" and a1.FFlag <> ").append(5).append(") \r\n");
        } else if (templetType == 5) {
            investSql.append(" and (a1.FFlag <> ").append(31);
            investSql.append(" and a1.FFlag <> ").append(3).append(") \r\n");
        }
        investSql.append(" Group by fcompanyid,FCurrencyId,item.FID,a2.FDataElement,a1.FDc,a2.FCompanyType \r\n");
        investSql.append(" UNION \r\n");
        investSql.append(" SELECT '' as FID, '' as FEliminationID, item.FID as fItemID,a1.FCurrencyId,a2.FDataElement, \r\n");
        investSql.append(" case a1.Fdc WHEN 1 THEN SUM(a1.FMoney) WHEN 5 THEN SUM(a1.FMoney) ELSE NULL END As FDebit, \r\n");
        investSql.append(" case a1.Fdc WHEN 2 THEN SUM(a1.FMoney) WHEN 6 THEN SUM(a1.FMoney) ELSE NULL END As FCredit, \r\n");
        investSql.append(" a1.FCompanyID as FCompanyId \r\n");
        investSql.append(" FROM T_CSL_IIASSISTANTITEMDATA a1 join \r\n");
        investSql.append(" (select t2.FCompanyType,t2.FDcType,t2.FControlAttr,t2.FDataElement \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 0 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2) ");
        investSql.append(" union \r\n");
        investSql.append(" select t2.FCompanyType,t2.FDcType,t3.FControl as FControlAttr,t2.FDataElement \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" join t_csl_RptControl t3 on t2.FType = t3.FType \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 1 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2) ");
        investSql.append(" ) a2 \r\n");
        investSql.append(" on a1.FControlAttr = a2.FControlAttr \r\n");
        investSql.append(" and a1.FDataElement = a2.FDataElement \r\n");
        investSql.append(" join T_CSL_RptItem item \r\n");
        investSql.append(" on item.fNumber=a1.FItemNumber \r\n");
        investSql.append(" where a1.forgboundid='").append(orgTreeID).append("' \r\n");
        investSql.append(" and a1.forgunitid='").append(orgUnitID).append("' \r\n");
        investSql.append(" and a1.fperiodtype = ").append(periodType).append(" \r\n");
        investSql.append(" and a1.fyear = ").append(year).append(" \r\n");
        investSql.append(" and a1.fperiod = ").append(period).append(" \r\n");
        investSql.append(" and a1.fcurrencyId = '").append(currencyId).append("' \r\n");
        investSql.append(" and a1.FControlAttr in ( \r\n");
        investSql.append(" select t2.FControlAttr \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId  \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 0 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2)");
        investSql.append(" And a2.FCompanyType = 1 \r\n");
        investSql.append(" union \r\n ");
        investSql.append(" select t3.FControl as FControlAttr \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" join t_csl_RptControl t3 on t2.FType = t3.FType \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 1 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2)");
        investSql.append(" And a2.FCompanyType = 1 \r\n");
        investSql.append(" ) \r\n");
        if (templetType != 31) {
            investSql.append(" and a1.FTargetCompanyID in ( \r\n");
            investSql.append(target.toString());
            investSql.append(")  \r\n");
        }
        investSql.append(" and (a1.fdc<>1 and a1.fdc<>2)");
        if (templetType == 31) {
            investSql.append(" and (a1.FFlag <> ").append(3);
            investSql.append(" and a1.FFlag <> ").append(5).append(") \r\n");
        } else if (templetType == 3) {
            investSql.append(" and (a1.FFlag <> ").append(31);
            investSql.append(" and a1.FFlag <> ").append(5).append(") \r\n");
        } else if (templetType == 5) {
            investSql.append(" and (a1.FFlag <> ").append(31);
            investSql.append(" and a1.FFlag <> ").append(3).append(") \r\n");
        }
        investSql.append(" Group by fcompanyid,FCurrencyId,item.FID,a2.FDataElement,a1.FDc,a2.FCompanyType \r\n");
        investSql.append(" Having  Sum(a1.FMoney)>=0  \r\n");
        investSql.append(" UNION \r\n");
        investSql.append(" SELECT '' as FID, '' as FEliminationID, item.FID as fItemID,a1.FCurrencyId,a2.FDataElement, \r\n");
        investSql.append(" case a1.Fdc WHEN 1 THEN SUM(a1.FMoney) WHEN 6 THEN ABS(SUM(a1.FMoney)) ELSE NULL END As FDebit, \r\n");
        investSql.append(" case a1.Fdc WHEN 2 THEN SUM(a1.FMoney) WHEN 5 THEN ABS(SUM(a1.FMoney)) ELSE NULL END As FCredit, \r\n");
        investSql.append(" a1.FCompanyID as FCompanyId \r\n");
        investSql.append(" FROM T_CSL_IIASSISTANTITEMDATA a1 join \r\n");
        investSql.append(" (select t2.FCompanyType,t2.FDcType,t2.FControlAttr,t2.FDataElement \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 0 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2) ");
        investSql.append(" union \r\n");
        investSql.append(" select t2.FCompanyType,t2.FDcType,t3.FControl as FControlAttr,t2.FDataElement \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" join t_csl_RptControl t3 on t2.FType = t3.FType \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 1 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2) ");
        investSql.append(" ) a2 \r\n");
        investSql.append(" on a1.FControlAttr = a2.FControlAttr \r\n");
        investSql.append(" and a1.FDataElement = a2.FDataElement \r\n");
        investSql.append(" join T_CSL_RptItem item \r\n");
        investSql.append(" on item.fNumber=a1.FItemNumber \r\n");
        investSql.append(" where a1.forgboundid='").append(orgTreeID).append("' \r\n");
        investSql.append(" and a1.forgunitid='").append(orgUnitID).append("' \r\n");
        investSql.append(" and a1.fperiodtype = ").append(periodType).append(" \r\n");
        investSql.append(" and a1.fyear = ").append(year).append(" \r\n");
        investSql.append(" and a1.fperiod = ").append(period).append(" \r\n");
        investSql.append(" and a1.fcurrencyId = '").append(currencyId).append("' \r\n");
        investSql.append(" and a1.FControlAttr in ( \r\n");
        investSql.append(" select t2.FControlAttr \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId  \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 0 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2)");
        investSql.append(" And a2.FCompanyType = 1 \r\n");
        investSql.append(" union \r\n ");
        investSql.append(" select t3.FControl as FControlAttr \r\n");
        investSql.append(" From t_csl_InvestTemplet t1 join t_csl_InvestTempletEntry t2 on t1.FId=t2.FTempletId \r\n");
        investSql.append(" join t_csl_RptControl t3 on t2.FType = t3.FType \r\n");
        investSql.append(" Where FElimType=").append(4);
        investSql.append(" and FIsUsingType = 1 and FTempletType=").append(templetType);
        investSql.append(isNetAsset == 1 ? " and (FIsNetAsset=0 or FIsNetAsset=1)" : " And (FIsNetAsset=0 or FIsNetAsset=2)");
        investSql.append(" And a2.FCompanyType = 1 \r\n");
        investSql.append(" ) \r\n");
        if (templetType != 31) {
            investSql.append(" and a1.FTargetCompanyID in ( \r\n");
            investSql.append(target.toString());
            investSql.append(" )  \r\n");
        }
        investSql.append(" and (a1.fdc<>1 and a1.fdc<>2)");
        if (templetType == 31) {
            investSql.append(" and (a1.FFlag <> ").append(3);
            investSql.append(" and a1.FFlag <> ").append(5).append(") \r\n");
        } else if (templetType == 3) {
            investSql.append(" and (a1.FFlag <> ").append(31);
            investSql.append(" and a1.FFlag <> ").append(5).append(") \r\n");
        } else if (templetType == 5) {
            investSql.append(" and (a1.FFlag <> ").append(31);
            investSql.append(" and a1.FFlag <> ").append(3).append(") \r\n");
        }
        investSql.append(" Group by fcompanyid,FCurrencyId,item.FID,a2.FDataElement,a1.FDc,a2.FCompanyType \r\n");
        investSql.append(" Having  Sum(a1.FMoney) < 0 \r\n");
        return DbUtil.executeQuery((Context)ctx, (String)investSql.toString());
    }

    private Hashtable getParentItemList(Context ctx) throws BOSException {
        String sql = " select fid, fparent from t_csl_rptitem where fparent is not null ";
        Hashtable<String, String> ht = new Hashtable<String, String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                ht.put(rs.getString("fid"), rs.getString("fparent"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ht;
    }

    private void doInsertParentEntry(Context ctx, String itemId, IRowSet rs, Hashtable ht, String tempTableName, String summary, int currencyPrecision) throws BOSException {
        if (ht.containsKey(itemId)) {
            try {
                BigDecimal valiCredit;
                BigDecimal valiDebit = rs.getBigDecimal("fDebit");
                if (valiDebit != null) {
                    valiDebit = valiDebit.setScale(currencyPrecision, 4);
                }
                if ((valiCredit = rs.getBigDecimal("fCredit")) != null) {
                    valiCredit = valiCredit.setScale(currencyPrecision, 4);
                }
                StringBuffer sbInsertLine = new StringBuffer(" INSERT INTO ").append(tempTableName).append("\t\r\n");
                sbInsertLine.append("   (fitemid, fDataElement, fdebit, fcredit, FSummary, fCompanyID,fisvisible) \r\n");
                sbInsertLine.append(" VALUES (");
                sbInsertLine.append("'").append((String)ht.get(itemId)).append("', \r\n");
                sbInsertLine.append(rs.getInt("FDataElement")).append(", \r\n");
                sbInsertLine.append(valiDebit).append(",");
                sbInsertLine.append(valiCredit).append(",'").append(summary).append("','");
                sbInsertLine.append(rs.getString("fCompanyID")).append("',0) \r\n");
                DbUtil.execute((Context)ctx, (String)sbInsertLine.toString());
                this.doInsertParentEntry(ctx, (String)ht.get(itemId), rs, ht, tempTableName, summary, currencyPrecision);
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
    }

    private void removeDataFromTempTable(Context ctx, String tempTableName) throws BOSException {
        StringBuffer sSql = new StringBuffer();
        sSql.append(" delete from ").append(tempTableName);
        DbUtil.execute((Context)ctx, (String)sSql.toString());
    }

    private IRowSet generateSumItem(Context ctx, String tempTableName) throws BOSException {
        StringBuffer sSql = new StringBuffer();
        sSql.append(" select a.fitemid,a.fdataelement,a.fsummary,a.fcompanyid,0 as fdebit,(isnull(b.fcredit,0)) as fcredit,a.fisvisible from   \r\n");
        sSql.append(" (select fitemid,fdataelement,fsummary,fcompanyid,sum(isnull(fdebit,0)) as fdebit,fisVisible from ").append(tempTableName).append("\t \r\n");
        sSql.append(" Group by fitemid,fdataelement,fsummary,fcompanyid,fisVisible                                                                           \r\n");
        sSql.append(" Having sum(isnull(fdebit,0)) = 0) a\t\t\t\t\t\t\t\t");
        sSql.append(" left join                                                                                                                      \r\n");
        sSql.append(" (select fitemid,fdataelement,fsummary,fcompanyid,sum(isnull(fcredit,0)) as fcredit,fisVisible from ").append(tempTableName).append("\t \r\n");
        sSql.append(" Group by fitemid,fdataelement,fsummary,fcompanyid,fisVisible                                                                           \r\n");
        sSql.append(" Having sum(isnull(fcredit,0)) <> 0)b     ");
        sSql.append(" on a.fitemid=b.fitemid and a.fdataelement = b.fdataelement and a.fcompanyid = b.fcompanyid                                     \r\n");
        sSql.append(" where a.fdebit=0 and b.fcredit<>0 and a.fisvisible=1 and b.fisvisible=1                                                                              \r\n");
        sSql.append(" union                                                                                                                          \r\n");
        sSql.append(" select a.fitemid,a.fdataelement,a.fsummary,a.fcompanyid,(isnull(a.fdebit,0)) as fdebit,0 as fcredit,a.fisvisible from   \r\n");
        sSql.append(" (select fitemid,fdataelement,fsummary,fcompanyid,sum(isnull(fdebit,0)) as fdebit,fisVisible from ").append(tempTableName).append("\t \r\n");
        sSql.append(" Group by fitemid,fdataelement,fsummary,fcompanyid,fisVisible                                                                           \r\n");
        sSql.append(" Having sum(isnull(fdebit,0)) <> 0) a\t\t\t\t\t\t\t\t");
        sSql.append(" left join                                                                                                                      \r\n");
        sSql.append(" (select fitemid,fdataelement,fsummary,fcompanyid,sum(isnull(fcredit,0)) as fcredit,fisVisible from ").append(tempTableName).append("\t \r\n");
        sSql.append(" Group by fitemid,fdataelement,fsummary,fcompanyid,fisVisible                                                                           \r\n");
        sSql.append(" Having sum(isnull(fcredit,0)) = 0)b     ");
        sSql.append(" on a.fitemid=b.fitemid and a.fdataelement = b.fdataelement and a.fcompanyid = b.fcompanyid                                     \r\n");
        sSql.append(" where b.fcredit=0 and a.fdebit<>0 and a.fisvisible=1 and b.fisvisible=1                                                                              \r\n");
        sSql.append(" union                                                                                                                          \r\n");
        sSql.append(" select a.fitemid,a.fdataelement,a.fsummary,a.fcompanyid,                                                                       \r\n");
        sSql.append(" case when (isnull(a.fdebit,0)-isnull(b.fcredit,0)) > 0 then (isnull(a.fdebit,0)-isnull(b.fcredit,0)) end as fdebit,           \r\n");
        sSql.append(" case when (isnull(a.fdebit,0)-isnull(b.fcredit,0)) < 0 then (isnull(b.fcredit,0)-isnull(a.fdebit,0)) end as fcredit,a.fisvisible from       \r\n");
        sSql.append(" (select fitemid,fdataelement,fsummary,fcompanyid,sum(isnull(fdebit,0)) as fdebit,fisVisible from ").append(tempTableName).append("\t \r\n");
        sSql.append(" Group by fitemid,fdataelement,fsummary,fcompanyid,fisVisible                                                                           \r\n");
        sSql.append(" Having sum(isnull(fdebit,0)) <> 0) a\t\t\t\t\t\t\t\t");
        sSql.append(" left join                                                                                                                      \r\n");
        sSql.append(" (select fitemid,fdataelement,fsummary,fcompanyid,sum(isnull(fcredit,0)) as fcredit,fisVisible from ").append(tempTableName).append("\t \r\n");
        sSql.append(" Group by fitemid,fdataelement,fsummary,fcompanyid,fisVisible                                                                           \r\n");
        sSql.append(" Having sum(isnull(fcredit,0)) <> 0)b     ");
        sSql.append(" on a.fitemid=b.fitemid and a.fdataelement = b.fdataelement and a.fcompanyid = b.fcompanyid                                     \r\n");
        sSql.append(" where b.fcredit<>0 and a.fdebit<>0  and a.fdebit-b.fcredit <> 0 and a.fisvisible=1 and b.fisvisible=1                       \r\n");
        sSql.append(" union                                                                                                                          \r\n");
        sSql.append(" select a.fitemid,a.fdataelement,a.fsummary,a.fcompanyid,0 as fdebit,(isnull(b.fcredit,0)) as fcredit,a.fisvisible from   \r\n");
        sSql.append(" (select fitemid,fdataelement,fsummary,fcompanyid,sum(isnull(fdebit,0)) as fdebit,fisVisible from ").append(tempTableName).append("\t \r\n");
        sSql.append(" Group by fitemid,fdataelement,fsummary,fcompanyid,fisVisible                                                                           \r\n");
        sSql.append(" Having sum(isnull(fdebit,0)) = 0) a\t\t\t\t\t\t\t\t");
        sSql.append(" left join                                                                                                                      \r\n");
        sSql.append(" (select fitemid,fdataelement,fsummary,fcompanyid,sum(isnull(fcredit,0)) as fcredit,fisVisible from ").append(tempTableName).append("\t \r\n");
        sSql.append(" Group by fitemid,fdataelement,fsummary,fcompanyid,fisVisible                                                                           \r\n");
        sSql.append(" Having sum(isnull(fcredit,0)) <> 0)b     ");
        sSql.append(" on a.fitemid=b.fitemid and a.fdataelement = b.fdataelement and a.fcompanyid = b.fcompanyid                                     \r\n");
        sSql.append(" where a.fdebit=0 and b.fcredit<>0 and a.fisvisible=0 and b.fisvisible=0                                                                              \r\n");
        sSql.append(" union                                                                                                                          \r\n");
        sSql.append(" select a.fitemid,a.fdataelement,a.fsummary,a.fcompanyid,(isnull(a.fdebit,0)) as fdebit,0 as fcredit,a.fisvisible from   \r\n");
        sSql.append(" (select fitemid,fdataelement,fsummary,fcompanyid,sum(isnull(fdebit,0)) as fdebit,fisVisible from ").append(tempTableName).append("\t \r\n");
        sSql.append(" Group by fitemid,fdataelement,fsummary,fcompanyid,fisVisible                                                                           \r\n");
        sSql.append(" Having sum(isnull(fdebit,0)) <> 0) a\t\t\t\t\t\t\t\t");
        sSql.append(" left join                                                                                                                      \r\n");
        sSql.append(" (select fitemid,fdataelement,fsummary,fcompanyid,sum(isnull(fcredit,0)) as fcredit,fisVisible from ").append(tempTableName).append("\t \r\n");
        sSql.append(" Group by fitemid,fdataelement,fsummary,fcompanyid,fisVisible                                                                           \r\n");
        sSql.append(" Having sum(isnull(fcredit,0)) = 0)b     ");
        sSql.append(" on a.fitemid=b.fitemid and a.fdataelement = b.fdataelement and a.fcompanyid = b.fcompanyid                                     \r\n");
        sSql.append(" where b.fcredit=0 and a.fdebit<>0 and a.fisvisible=0 and b.fisvisible=0                                                                              \r\n");
        sSql.append(" union                                                                                                                          \r\n");
        sSql.append(" select a.fitemid,a.fdataelement,a.fsummary,a.fcompanyid,                                                                       \r\n");
        sSql.append(" case when (isnull(a.fdebit,0)-isnull(b.fcredit,0)) > 0 then (isnull(a.fdebit,0)-isnull(b.fcredit,0)) end as fdebit,           \r\n");
        sSql.append(" case when (isnull(a.fdebit,0)-isnull(b.fcredit,0)) < 0 then (isnull(b.fcredit,0)-isnull(a.fdebit,0)) end as fcredit,a.fisvisible from       \r\n");
        sSql.append(" (select fitemid,fdataelement,fsummary,fcompanyid,sum(isnull(fdebit,0)) as fdebit,fisVisible from ").append(tempTableName).append("\t \r\n");
        sSql.append(" Group by fitemid,fdataelement,fsummary,fcompanyid,fisVisible                                                                           \r\n");
        sSql.append(" Having sum(isnull(fdebit,0)) <> 0) a\t\t\t\t\t\t\t\t");
        sSql.append(" left join                                                                                                                      \r\n");
        sSql.append(" (select fitemid,fdataelement,fsummary,fcompanyid,sum(isnull(fcredit,0)) as fcredit,fisVisible from ").append(tempTableName).append("\t \r\n");
        sSql.append(" Group by fitemid,fdataelement,fsummary,fcompanyid,fisVisible                                                                           \r\n");
        sSql.append(" Having sum(isnull(fcredit,0)) <> 0)b     ");
        sSql.append(" on a.fitemid=b.fitemid and a.fdataelement = b.fdataelement and a.fcompanyid = b.fcompanyid                                     \r\n");
        sSql.append(" where b.fcredit<>0 and a.fdebit<>0  and a.fdebit-b.fcredit <> 0 and a.fisvisible=0 and b.fisvisible=0                       \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sSql.toString());
        return rs;
    }

    private void generateElimRecordData(Context ctx, String tableName, String eliminationID, Map mapParams, String currencyId, int isNetAsset, int isChecked) throws BOSException {
        StringBuffer sqlElimRecord = new StringBuffer(" Select FId From ").append(tableName);
        sqlElimRecord.append(" where forgboundid='").append(this.getOrgTreeId(mapParams)).append("' \r\n");
        sqlElimRecord.append(" and forgunitid='").append(this.getOrgUnitId(mapParams)).append("' \r\n");
        sqlElimRecord.append(" and fperiodtype = ").append(this.getPeriodType(mapParams)).append(" \r\n");
        sqlElimRecord.append(" and fyear = ").append(this.getYear(mapParams)).append(" \r\n");
        sqlElimRecord.append(" and fperiod = ").append(this.getPeriod(mapParams)).append(" \r\n");
        sqlElimRecord.append(" And FTargetCompanyId IN  ");
        sqlElimRecord.append(" (Select FTargetCompanyId From t_csl_IIAssistant ");
        sqlElimRecord.append(this.getNetAssetAndCheckedSQL(isNetAsset, isChecked, this.getOrgTreeId(mapParams), this.getOrgUnitId(mapParams))).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlElimRecord.toString());
        String creatorID = ctx.getCaller().toString();
        try {
            while (rs.next()) {
                String fid = new ObjectUuidPK(new BOSObjectType(ELIMRECORD_BOSTYPE)).toString();
                String checkageDataId = rs.getString("fid");
                if (this.checkExistsElimRecord(eliminationID, checkageDataId, ctx)) continue;
                StringBuffer sbInsert = new StringBuffer(" INSERT INTO T_CSL_ElimRecord \r\n");
                sbInsert.append("   (fid,fcreatorId,flastupdateUserId, feliminationid, fcheckageDataid) \r\n");
                sbInsert.append(" VALUES  \r\n");
                sbInsert.append(" ('").append(fid).append("','");
                sbInsert.append(creatorID).append("','").append(creatorID).append("', \r\n");
                sbInsert.append("'").append(eliminationID).append("','").append(checkageDataId);
                sbInsert.append("') \r\n");
                DbUtil.execute((Context)ctx, (String)sbInsert.toString());
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private boolean checkExistsElimRecord(String ElimRecordId, String checkageDataId, Context ctx) throws BOSException {
        StringBuffer existElimRecordSql = new StringBuffer();
        existElimRecordSql.append("select fid from t_csl_ElimRecord where fEliminationId = ? and fCheckageDataId = ? \n");
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(ElimRecordId);
        params.add(checkageDataId);
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)existElimRecordSql.toString(), (Object[])params.toArray());
        try {
            if (rowset.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return false;
    }

    private String getNetAssetAndCheckedSQL(int isNetAsset, int isChecked, String treeId, String unitId) {
        StringBuffer investSql = new StringBuffer();
        investSql.append(" where forgboundid = '").append(treeId).append("' \r\n");
        investSql.append(" and forgunitid = '").append(unitId).append("' \r\n");
        if (isNetAsset == 1) {
            investSql.append(" And FNetAsset >=0 ");
        } else if (isNetAsset == 2) {
            investSql.append(" And FNetAsset <0 ");
        }
        if (isChecked == 1) {
            investSql.append(" And FIsChecked = 0 ");
        } else if (isChecked == 2) {
            investSql.append(" And FIsChecked = 1 ");
        }
        return investSql.toString();
    }

    @Override
    protected void _deleteElimRecord(Context ctx, Map mapParams) throws BOSException, EASBizException {
        SQLBuilder builder = new SQLBuilder();
        builder.append(" DELETE FROM T_CSL_ElimRecord WHERE FEliminationid IN (");
        builder.append("SELECT FID FROM T_CSL_Elimination a \r\n");
        builder.append(" WHERE a.FOrgBoundId = ?", (Object)this.getOrgTreeId(mapParams)).append(" \r\n");
        builder.append("   AND a.FOrgUnit = ?", (Object)this.getOrgUnitId(mapParams)).append(" \r\n");
        builder.append("   AND a.FPeriodType = ?", (Object)this.getPeriodType(mapParams)).append(" \r\n");
        builder.append("   AND a.FYear = ?", (Object)this.getYear(mapParams)).append(" \r\n");
        builder.append("   AND a.FPeriod = ?", (Object)this.getPeriod(mapParams)).append(" \r\n");
        builder.append("   AND a.FElimType = ?", (Object)this.getElimType(mapParams)).append(" \r\n");
        builder.append("   AND a.FDataCollectNumber = ?", mapParams.get("dataCollectNumber"));
        builder.append("   AND a.FCheckedStatus = 1 \n");
        builder.append("  and a.FElimDataSource=0 \n");
        builder.append(")");
        DbUtil.execute((Context)ctx, (String)builder.getSQL(), (Object[])builder.getParams());
        builder.reset();
        builder.append("DELETE FROM T_CSL_Eliminationentry WHERE FEliminationid IN (  \r\n");
        builder.append("SELECT FID FROM T_CSL_Elimination    \r\n");
        builder.append(" WHERE FOrgBoundId = '").append(this.getOrgTreeId(mapParams)).append("' \r\n");
        builder.append("   AND FOrgUnit = '").append(this.getOrgUnitId(mapParams)).append("' \r\n");
        builder.append("   AND FperiodType = ").append((Object)this.getPeriodType(mapParams)).append(" \r\n");
        builder.append("   AND FYear = ").append((Object)this.getYear(mapParams)).append(" \r\n");
        builder.append("   AND FPeriod = ").append((Object)this.getPeriod(mapParams)).append(" \r\n");
        builder.append("   AND FElimType = ").append((Object)this.getElimType(mapParams)).append(" \r\n");
        builder.append("   AND FDataCollectNumber = '").append(mapParams.get("dataCollectNumber")).append("'");
        builder.append("  AND FCheckedStatus = 1 \n");
        builder.append(" and FElimDataSource=0 \n");
        builder.append(")");
        DbUtil.execute((Context)ctx, (String)builder.getSQL(), (Object[])builder.getParams());
        IElimination elimination = EliminationFactory.getLocalInstance(ctx);
        StringBuffer oql = new StringBuffer();
        oql.append(" WHERE orgBound.id = '").append(this.getOrgTreeId(mapParams)).append("' \r\n");
        oql.append("  AND orgUnit.id = '").append(this.getOrgUnitId(mapParams)).append("' \r\n");
        oql.append("  AND periodType = ").append(this.getPeriodType(mapParams)).append(" \r\n");
        oql.append("  AND year = ").append(this.getYear(mapParams)).append(" \r\n");
        oql.append("  AND period = ").append(this.getPeriod(mapParams)).append(" \r\n");
        oql.append("  AND elimType = ").append(this.getElimType(mapParams)).append(" \r\n");
        oql.append("  AND dataCollectNumber = '").append(mapParams.get("dataCollectNumber")).append("'");
        oql.append("  AND checkedStatus = 1 ");
        oql.append("  AND elimDataSource = 0 ");
        elimination.delete(oql.toString());
    }

    @Override
    protected boolean _checkElimExist(Context ctx, Map mapParams) throws BOSException {
        return false;
    }

    private String getCurTimeStr() {
        Timestamp curTime = new Timestamp(System.currentTimeMillis());
        String strTime = curTime.toString();
        StringBuffer sbTableName = new StringBuffer();
        sbTableName.append(strTime.substring(0, 4)).append(strTime.substring(5, 7)).append(strTime.substring(8, 10)).append(strTime.substring(11, 13)).append(strTime.substring(14, 16)).append(strTime.substring(17, 19)).append(strTime.substring(20));
        return sbTableName.toString();
    }

    @Override
    protected ArrayList _getInvCompanyByShareHolder(Context ctx, String shareHolderID) throws BOSException, EASBizException {
        ArrayList<String> listParams = new ArrayList<String>();
        ArrayList<CompanyOrgUnitInfo> listResult = new ArrayList<CompanyOrgUnitInfo>();
        StringBuffer sb = new StringBuffer();
        sb.append("select distinct finvesteecompanyid from t_csl_sharerela ");
        sb.append("where fisout = 0 and fislatest = 1 ");
        sb.append("and fshareholderid = ? ");
        listParams.add(shareHolderID);
        CompanyOrgUnitInfo companyInfo = null;
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])listParams.toArray());
        try {
            while (rowSet.next()) {
                if (listResult == null) {
                    listResult = new ArrayList();
                }
                companyInfo = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(rowSet.getString("finvesteecompanyid")));
                listResult.add(companyInfo);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        Collections.sort(listResult, new CompanyListSort());
        return listResult;
    }

    @Override
    protected List _getInvestCompanyList(Context ctx, Map param) throws BOSException, EASBizException {
        IElimInvestRate iElimInvest = ElimInvestRateFactory.getLocalInstance(ctx);
        IFullOrgUnit iCompany = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        HashSet IDs = new HashSet();
        HashSet unitIDs = new HashSet();
        ArrayList listResult = new ArrayList();
        IRowSet rowSet = iElimInvest.getInvestCompanyList(param);
        try {
            this.appendId2Set(rowSet, IDs);
            this.findNextGradeOrgUnit(ctx, unitIDs, param);
            for (String unitId : unitIDs) {
                param.put("orgUnitId", unitId);
                rowSet = iElimInvest.getInvestCompanyList(param);
                this.appendId2Set(rowSet, IDs);
            }
            if (!IDs.isEmpty()) {
                EntityViewInfo view = new EntityViewInfo();
                SorterItemInfo sort = new SorterItemInfo("number");
                sort.setSortType(SortType.ASCEND);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", IDs, CompareType.INCLUDE));
                view.setFilter(filter);
                view.getSorter().add(sort);
                OrgUnitCollection orgcol = iCompany.getOrgUnitCollection(view);
                Iterator it = orgcol.iterator();
                while (it.hasNext()) {
                    listResult.add(it.next());
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return listResult;
    }

    private void findNextGradeOrgUnit(Context ctx, Set IDs, Map param) throws BOSException, EASBizException {
        String isIncludeAllTargCom = (String)param.get("isIncludeAllTargCom");
        if (isIncludeAllTargCom.equalsIgnoreCase("true")) {
            OrgUnitInfo unitInfo = (OrgUnitInfo)param.get("orgUnit");
            OrgTreeInfo treeInfo = (OrgTreeInfo)param.get("orgBound");
            String treeId = treeInfo.getId().toString();
            String longNumber = unitInfo.getLongNumber();
            StringBuffer sql = new StringBuffer();
            sql.append("select unit.fid id from t_org_baseunit unit join t_org_structure struct \n").append(" on unit.fid = struct.funitid \n").append(" where unit.flongnumber like '" + longNumber + "!%' \n").append(" and unit.fisCompanyOrgUnit = 0 and struct.ftreeid = ? ");
            ArrayList<String> params = new ArrayList<String>(1);
            params.add(treeId);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            try {
                while (rs.next()) {
                    IDs.add(rs.getString("id"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
    }

    private void appendId2Set(IRowSet rowSet, Set IDs) throws SQLException {
        while (rowSet.next()) {
            IDs.add(rowSet.getString("id"));
        }
    }

    public class CompanyListSort
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            CompanyOrgUnitInfo company1 = (CompanyOrgUnitInfo)obj1;
            CompanyOrgUnitInfo company2 = (CompanyOrgUnitInfo)obj2;
            if (company1 == null || company2 == null) {
                return 1;
            }
            return company1.getNumber().compareTo(company2.getNumber());
        }
    }
}

