/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CombineTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.IInvestDay;
import com.kingdee.eas.fi.gr.cslrpt.InvestCheckException;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractInvestDayControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class InvestDayControllerBean
extends AbstractInvestDayControllerBean {
    private static final BigDecimal ZERO = new BigDecimal("0");

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, (InvestDayInfo)model);
        this.consistentCheck(ctx, (InvestDayInfo)model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, (InvestDayInfo)model);
        this.consistentCheck(ctx, (InvestDayInfo)model);
        return super._addnew(ctx, model);
    }

    private void addnewCheck(Context ctx, InvestDayInfo model) throws EASBizException, BOSException {
        IInvestDay iinvestDay = InvestDayFactory.getLocalInstance(ctx);
        StringBuffer oql = new StringBuffer();
        oql.append(" where company.id = '");
        oql.append(model.getCompany().getId().toString());
        oql.append("' and targetCompany.id = '");
        oql.append(model.getTargetCompany().getId().toString());
        oql.append("' and changeDate = '");
        oql.append(model.getChangeDate());
        oql.append("' and currency.id = '");
        oql.append(model.getCurrency().getId().toString());
        if (model.getId() != null) {
            oql.append("' and id <> '");
            oql.append(model.getId().toString());
        }
        oql.append("'");
        if (iinvestDay.exists(oql.toString())) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{""});
        }
        this.checkCycleInvest(ctx, model.getTargetCompany().getId().toString(), model.getCompany().getId().toString());
    }

    private void checkCycleInvest(Context ctx, String companyId, String targetCompanyId) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String tempCompanyId2 = companyId;
        ArrayList<String> list = null;
        try {
            conn = super.getConnection(ctx);
            while (tempCompanyId2 != null) {
                ps = conn.prepareStatement("Select ftargetCompanyId From t_csl_investday Where fcompanyId = ?");
                ps.setString(1, BOSUuid.read((String)tempCompanyId2).toString());
                rs = ps.executeQuery();
                boolean isTrue = false;
                tempCompanyId2 = null;
                list = new ArrayList<String>();
                while (rs.next()) {
                    tempCompanyId2 = rs.getString("ftargetCompanyId");
                    list.add(tempCompanyId2);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
                for (String tempCompanyId2 : list) {
                    if (targetCompanyId.trim().equals(tempCompanyId2)) {
                        throw new ServerException(ServerException.NOT_CYCLE_INVEST);
                    }
                    this.checkCycleInvest(ctx, tempCompanyId2, targetCompanyId);
                    isTrue = true;
                }
                if (isTrue) continue;
                tempCompanyId2 = null;
            }
        }
        catch (SQLException exc) {
            try {
                throw new SQLDataException(exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, (InvestDayInfo)model);
        this.updateCheck(ctx, (InvestDayInfo)model);
        this.consistentCheck(ctx, (InvestDayInfo)model);
        super._update(ctx, pk, model);
    }

    private void updateCheck(Context ctx, InvestDayInfo model) throws EASBizException, BOSException {
        IInvestDay iinvestDay = InvestDayFactory.getLocalInstance(ctx);
        StringBuffer oql = new StringBuffer();
        oql.append(" where id = '");
        oql.append(model.getId().toString());
        oql.append("'");
        InvestDayInfo old = iinvestDay.getInvestDayInfo(oql.toString());
        if (!model.getChangeDate().equals(old.getChangeDate())) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"InvestDay_ChangeDate_CannotModify", (Locale)ctx.getOriginLocale())));
        }
        this.checkCycleInvest(ctx, model.getTargetCompany().getId().toString(), model.getCompany().getId().toString());
    }

    private void consistentCheck(Context ctx, InvestDayInfo model) throws EASBizException, BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("select FSumInvestRate, FOwnerSumOld, FOwnerSumNew, FProfit from t_csl_investDay");
        oql.append(" where FTargetCompanyId = '");
        oql.append(model.getTargetCompany().getId().toString());
        oql.append("' and FCompanyId <> '");
        oql.append(model.getCompany().getId().toString());
        oql.append("' and FCurrencyId = '");
        oql.append(model.getCurrency().getId().toString());
        oql.append("' and FChangeDate = ");
        oql.append(CslRptUtil.formatDateForSql(model.getChangeDate()));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        BigDecimal sumInvestRate = model.getSumInvestRate();
        try {
            while (rowSet.next()) {
                BigDecimal otherProfit;
                BigDecimal otherOwnerNew;
                BigDecimal otherOwnerOld;
                BigDecimal profit;
                BigDecimal ownerNew;
                BigDecimal ownerOld = rowSet.getBigDecimal("FOwnerSumOld");
                if (ownerOld == null) {
                    ownerOld = ZERO;
                }
                if ((ownerNew = rowSet.getBigDecimal("FOwnerSumNew")) == null) {
                    ownerNew = ZERO;
                }
                if ((profit = rowSet.getBigDecimal("FProfit")) == null) {
                    profit = ZERO;
                }
                if ((otherOwnerOld = model.getOwnerSumOld()) == null) {
                    otherOwnerOld = ZERO;
                }
                if ((otherOwnerNew = model.getOwnerSumNew()) == null) {
                    otherOwnerNew = ZERO;
                }
                if ((otherProfit = model.getProfit()) == null) {
                    otherProfit = ZERO;
                }
                if (ownerOld.compareTo(otherOwnerOld) != 0 || profit.compareTo(otherProfit) != 0) {
                    throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_InvestDay_NotConsistent", (Locale)ctx.getOriginLocale())), new Object[]{model.getTargetCompany().getName()});
                }
                sumInvestRate = sumInvestRate.add(rowSet.getBigDecimal("FSumInvestRate"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (sumInvestRate.compareTo(new BigDecimal(1.0)) > 0) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_InvestDay_TotalRateOver100p", (Locale)ctx.getOriginLocale())), new Object[]{model.getTargetCompany().getName()});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.deleteCheck(ctx, pk);
        String oql = " where investDay.id = '" + pk.toString() + "'";
        InvestDayEntryFactory.getLocalInstance(ctx).delete(oql);
        StringBuffer s = new StringBuffer();
        s.append("delete from T_CSL_InvestOwnerEntry where FInvestDayID ='").append(pk.toString()).append("'");
        DbUtil.execute((Context)ctx, (String)s.toString());
        super._delete(ctx, pk);
    }

    private void deleteCheck(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IInvestDay iinvestDay = InvestDayFactory.getLocalInstance(ctx);
        InvestDayInfo info = iinvestDay.getInvestDayInfo(pk);
        StringBuffer oql = new StringBuffer();
        oql.append(" where company.id = '");
        oql.append(info.getCompany().getId().toString());
        oql.append("' and targetCompany.id = '");
        oql.append(info.getTargetCompany().getId().toString());
        oql.append("' and changeDate > ");
        oql.append(CslRptUtil.formatDateForSql(RPTDateUtil.getEndOfDay(info.getChangeDate())));
        oql.append(" and currency.id = '");
        oql.append(info.getCurrency().getId().toString());
        oql.append("'");
        if (iinvestDay.exists(oql.toString())) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_InvestDay_CanNotDelete", (Locale)ctx.getOriginLocale())));
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvestDayInfo info = this.getInvestDayInfo(ctx, "select company.name, targetCompany.name, currency.name where id = '" + pk.toString() + "'");
        return info.getCompany().getName() + "/" + info.getTargetCompany().getName() + " " + info.getCurrency().getName();
    }

    @Override
    protected Map _getTwoTypeCompanyForInvest(Context ctx, String orgTreeID, String orgUnitID, int relaParty, int controlRelationShip) throws BOSException, EASBizException {
        String longnumber;
        String numberSql = "select flongnumber from t_org_structure t where ftreeId = ? and funitId = ?";
        Object[] params = new Object[]{orgTreeID, orgUnitID};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)numberSql, (Object[])params);
        try {
            rowSet.next();
            longnumber = rowSet.getString(1);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        String relationShipNumber = "";
        if (relaParty == 1) {
            relationShipNumber = "001";
        } else if (relaParty == 2) {
            relationShipNumber = "002";
        }
        String controlRelaNumber = "";
        if (controlRelationShip == 3) {
            controlRelaNumber = "003";
        } else if (controlRelationShip == 4) {
            controlRelaNumber = "004', '005";
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct t1.fcompanyid, t1.ftargetCompanyid, t2.flongnumber,");
        sql.append(" t3.flongnumber from t_csl_investDay t1");
        sql.append(" inner join");
        sql.append(" (select FUnitId, FLongNumber from t_org_structure");
        sql.append(" where FTreeId = '" + orgTreeID);
        sql.append("' and FLongNumber like '" + longnumber + "!%') t2");
        sql.append(" on t1.fcompanyid = t2.funitid");
        sql.append(" inner join ");
        sql.append(" (select FUnitId, FLongNumber from t_org_structure");
        sql.append(" where FTreeId = '" + orgTreeID);
        sql.append("' and FLongNumber like '" + longnumber + "!%') t3");
        sql.append(" on t1.ftargetCompanyid = t3.funitid");
        sql.append(" where (t1.fcompanyid || t1.ftargetcompanyid) in");
        if (StringUtils.isEmpty((String)controlRelaNumber)) {
            sql.append(" (select (r1.fcontrolCompanyId || r1.finvestCompanyId) as funionid");
            sql.append(" from t_csl_relatedPartyRela r1 join t_csl_relatedParty r2");
            sql.append(" on r1.frelationShipId = r2.fid");
            sql.append(" where r2.fnumber = '" + relationShipNumber + "')");
        } else {
            sql.append(" (select p1.funionid from");
            sql.append(" (select (r1.finvestCompanyId || r1.fcontrolCompanyId) as funionid");
            sql.append(" from t_csl_relatedPartyRela r1 join t_csl_relatedParty r2");
            sql.append(" on r1.frelationShipId = r2.fid");
            sql.append(" where r2.fnumber in ('" + controlRelaNumber + "')) p1");
            sql.append(" join");
            sql.append(" (select (r1.fcontrolCompanyId || r1.finvestCompanyId) as funionid");
            sql.append(" from t_csl_relatedPartyRela r1 join t_csl_relatedParty r2");
            sql.append(" on r1.frelationShipId = r2.fid");
            sql.append(" where r2.fnumber = '" + relationShipNumber + "') p2");
            sql.append(" on p1.funionid = p2.funionid)");
        }
        HashMap result = new HashMap();
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            String[] numbers = StringUtils.split((String)longnumber, (String)"!");
            int size = numbers.length;
            while (rowSet.next()) {
                String targetCompanyNumber;
                String[] num2;
                String companyNumber = rowSet.getString(3);
                String[] num1 = StringUtils.split((String)companyNumber, (String)"!");
                if (StringUtils.equals((String)num1[size], (String)(num2 = StringUtils.split((String)(targetCompanyNumber = rowSet.getString(4)), (String)"!"))[size])) continue;
                String companyid = rowSet.getString(1);
                String targetCompanyid = rowSet.getString(2);
                List<String> toCompanys = new ArrayList();
                if (result.containsKey(companyid)) {
                    toCompanys = (List)result.get(companyid);
                } else {
                    result.put(companyid, toCompanys);
                }
                if (toCompanys.contains(targetCompanyid)) continue;
                toCompanys.add(targetCompanyid);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    private IRowSet getEndOfYearInvest(Context ctx, String companyId, String targetCompanyId, String currencyId, int year) throws BOSException {
        String endOfYear = CslRptUtil.formatDateForSql(RPTDateUtil.getEndOfYear(year));
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 FID, FChangeDate, FInvestRate, FSumInvestRate, ");
        sql.append("FInvestAmount, FSumInvestAmout, FOwnerSumNew, FOwnerSumOld, FProfit, ");
        sql.append("FHonor, FHonorSum, FMinorityChange from t_csl_investDay");
        sql.append(" where FCurrencyId = ?");
        sql.append(" and FCompanyId = ?");
        sql.append(" and FTargetCompanyId = ?");
        sql.append(" and FChangeDate <= ");
        sql.append(endOfYear);
        sql.append(" order by FChangeDate desc");
        Object[] param = new Object[]{currencyId, companyId, targetCompanyId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        return rowSet;
    }

    private IRowSet getFirstInvest(Context ctx, String companyId, String targetCompanyId, String currencyId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 FID, FChangeDate, FInvestRate, FSumInvestRate, ");
        sql.append("FInvestAmount, FSumInvestAmout, FOwnerSumNew, FOwnerSumOld, FProfit, ");
        sql.append("FHonor, FHonorSum, FMinorityChange from t_csl_investDay");
        sql.append(" where FCurrencyId = ?");
        sql.append(" and FCompanyId = ?");
        sql.append(" and FTargetCompanyId = ?");
        sql.append(" order by FChangeDate asc");
        Object[] param = new Object[]{currencyId, companyId, targetCompanyId};
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
    }

    private IRowSet getThisYearInvests(Context ctx, String companyId, String targetCompanyId, String currencyId, int year, boolean isIncludeFirst) throws BOSException {
        String beginOfYear = CslRptUtil.formatDateForSql(RPTDateUtil.getBeginOfYear(year));
        String endOfYear = CslRptUtil.formatDateForSql(RPTDateUtil.getEndOfYear(year));
        if (!isIncludeFirst) {
            IRowSet firstInvest = this.getFirstInvest(ctx, companyId, targetCompanyId, currencyId);
            try {
                Date first;
                if (firstInvest.next() && DateTimeUtils.getYear((java.util.Date)(first = firstInvest.getDate("FChangeDate"))) == year) {
                    beginOfYear = CslRptUtil.formatDateForSql(RPTDateUtil.getEndOfDay(first));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FChangeDate, FInvestRate, FSumInvestRate, ");
        sql.append("FInvestAmount, FSumInvestAmout, FOwnerSumNew, FOwnerSumOld, FProfit, ");
        sql.append("FHonor, FHonorSum, FMinorityChange from t_csl_investDay");
        sql.append(" where FCurrencyId = ?");
        sql.append(" and FCompanyId = ?");
        sql.append(" and FTargetCompanyId = ?");
        if (isIncludeFirst) {
            sql.append(" and FChangeDate >= " + beginOfYear);
        } else {
            sql.append(" and FChangeDate > " + beginOfYear);
        }
        sql.append(" and FChangeDate <= " + endOfYear);
        sql.append(" order by FChangeDate asc");
        Object[] param = new Object[]{currencyId, companyId, targetCompanyId};
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
    }

    @Override
    protected List _getEndOfLastYearOwnerSum(Context ctx, String companyID, String targetCompanyID, int year, boolean expanded, boolean isChanged) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = this.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = this.getEndOfYearInvest(ctx, companyID, targetCompanyID, currencyId, year - 1);
            try {
                if (!info.next()) continue;
                if (expanded) {
                    int flag = isChanged ? 1 : 0;
                    StringBuffer sql = new StringBuffer();
                    sql.append("select t1.fitemid, t1.famount");
                    sql.append(" from t_csl_investDayEntry t1");
                    sql.append(" join t_csl_rptItem t2 on t1.fitemId = t2.fid");
                    sql.append(" where t1.finvestDayId = '");
                    sql.append(info.getString("FID"));
                    sql.append("' and t1.fcontrolAttr = ");
                    sql.append(20);
                    sql.append(" and t1.famount > 0 and t2.fisSumItem = 0");
                    sql.append(" and FAssistantFlag = " + flag);
                    IRowSet entry = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    while (entry.next()) {
                        HashMap<String, Object> data = new HashMap<String, Object>(4);
                        data.put("RPTITEM_ID", entry.getString("fitemid"));
                        data.put("KEY_CURRENCY_ID", currencyId);
                        data.put("Value", entry.getBigDecimal("famount"));
                        result.add(data);
                    }
                    continue;
                }
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", currencyId);
                if (isChanged) {
                    data.put("Value", info.getBigDecimal("FOwnerSumNew"));
                } else {
                    data.put("Value", info.getBigDecimal("FOwnerSumOld"));
                }
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    @Override
    protected List _getEndOfLastYearHonorSum(Context ctx, String companyID, String targetCompanyID, int year) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = this.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = this.getEndOfYearInvest(ctx, companyID, targetCompanyID, currencyId, year - 1);
            try {
                if (!info.next()) continue;
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", info.getBigDecimal("FHonorSum"));
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    @Override
    protected List _getEndOfLastYearSumInvestAmount(Context ctx, String companyID, String targetCompanyID, int year) throws EASBizException, BOSException {
        ArrayList result = new ArrayList();
        List currencies = this.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = this.getEndOfYearInvest(ctx, companyID, targetCompanyID, currencyId, year - 1);
            try {
                if (!info.next()) continue;
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", info.getBigDecimal("FSumInvestAmout"));
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    @Override
    protected List _getEndOfLastYearSumInvestRate(Context ctx, String companyID, String targetCompanyID, int year) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = this.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = this.getEndOfYearInvest(ctx, companyID, targetCompanyID, currencyId, year - 1);
            try {
                if (!info.next()) continue;
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", info.getBigDecimal("FSumInvestRate"));
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    @Override
    protected List _getFirstOwnerSum(Context ctx, String companyID, String targetCompanyID, boolean expanded, boolean isChanged) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = this.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = this.getFirstInvest(ctx, companyID, targetCompanyID, currencyId);
            try {
                if (!info.next()) continue;
                if (expanded) {
                    int flag = isChanged ? 1 : 0;
                    StringBuffer sql = new StringBuffer();
                    sql.append("select t1.fitemid, t1.famount");
                    sql.append(" from t_csl_investDayEntry t1");
                    sql.append(" join t_csl_rptItem t2 on t1.fitemId = t2.fid");
                    sql.append(" where t1.finvestDayId = '");
                    sql.append(info.getString("FID"));
                    sql.append("' and t1.fcontrolAttr = ");
                    sql.append(20);
                    sql.append(" and t1.famount > 0 and t2.fisSumItem = 0");
                    sql.append(" and FAssistantFlag = " + flag);
                    IRowSet entry = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    while (entry.next()) {
                        HashMap<String, Object> data = new HashMap<String, Object>(4);
                        data.put("RPTITEM_ID", entry.getString("fitemid"));
                        data.put("KEY_CURRENCY_ID", currencyId);
                        data.put("Value", entry.getBigDecimal("FAmount"));
                        result.add(data);
                    }
                    continue;
                }
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", currencyId);
                if (isChanged) {
                    data.put("Value", info.getBigDecimal("FOwnerSumNew"));
                } else {
                    data.put("Value", info.getBigDecimal("FOwnerSumOld"));
                }
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    @Override
    protected List _getFirstHonor(Context ctx, String companyID, String targetCompanyID) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = this.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = this.getFirstInvest(ctx, companyID, targetCompanyID, currencyId);
            try {
                if (!info.next()) continue;
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", info.getBigDecimal("FHonor"));
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    @Override
    protected List _getFirstSumInvestAmount(Context ctx, String companyID, String targetCompanyID) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = this.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = this.getFirstInvest(ctx, companyID, targetCompanyID, currencyId);
            try {
                if (!info.next()) continue;
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", info.getBigDecimal("FSumInvestAmout"));
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    @Override
    protected List _getFirstMinority(Context ctx, String companyID, String targetCompanyID) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = this.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = this.getFirstInvest(ctx, companyID, targetCompanyID, currencyId);
            try {
                if (!info.next()) continue;
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", info.getBigDecimal("FMinorityChange"));
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    @Override
    protected List _getThisYearMinoritySum(Context ctx, String companyID, String targetCompanyID, int year, boolean isIncludeFirst) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = this.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet invests = this.getThisYearInvests(ctx, companyID, targetCompanyID, currencyId, year, isIncludeFirst);
            BigDecimal sumMinority = ZERO;
            try {
                while (invests.next()) {
                    BigDecimal minority = invests.getBigDecimal("FMinorityChange");
                    if (minority == null) {
                        minority = ZERO;
                    }
                    sumMinority = sumMinority.add(minority);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (sumMinority.compareTo(ZERO) == 0) continue;
            HashMap<String, Object> data = new HashMap<String, Object>(4);
            data.put("KEY_CURRENCY_ID", currencyId);
            data.put("Value", sumMinority);
            result.add(data);
        }
        return result;
    }

    @Override
    protected List _getThisYearHonorSum(Context ctx, String companyID, String targetCompanyID, int year, boolean isIncludeFirst) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = this.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet invests = this.getThisYearInvests(ctx, companyID, targetCompanyID, currencyId, year, isIncludeFirst);
            BigDecimal sumHonor = ZERO;
            try {
                while (invests.next()) {
                    BigDecimal honor = invests.getBigDecimal("FHonor");
                    if (honor == null) {
                        honor = ZERO;
                    }
                    sumHonor = sumHonor.add(honor);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (sumHonor.compareTo(ZERO) == 0) continue;
            HashMap<String, Object> data = new HashMap<String, Object>(4);
            data.put("KEY_CURRENCY_ID", currencyId);
            data.put("Value", sumHonor);
            result.add(data);
        }
        return result;
    }

    @Override
    protected List _getThisYearOwnerSum(Context ctx, String companyID, String targetCompanyID, int year, boolean expanded, boolean isIncludeFirst) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = this.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet invests = this.getThisYearInvests(ctx, companyID, targetCompanyID, currencyId, year, isIncludeFirst);
            if (expanded) {
                HashMap<String, BigDecimal> sumItem = new HashMap<String, BigDecimal>();
                try {
                    while (invests.next()) {
                        BigDecimal amount;
                        BigDecimal sum;
                        String itemid;
                        StringBuffer sql = new StringBuffer();
                        sql.append("select t1.fitemid, t1.famount");
                        sql.append(" from t_csl_investDayEntry t1");
                        sql.append(" join t_csl_rptItem t2 on t1.fitemId = t2.fid");
                        sql.append(" where t1.finvestDayId = '");
                        sql.append(invests.getString("FID"));
                        sql.append("' and t1.fcontrolAttr = ");
                        sql.append(20);
                        sql.append(" and t1.famount > 0 and t2.fisSumItem = 0");
                        sql.append(" and FAssistantFlag = ");
                        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)(sql.toString() + "1"));
                        while (rowSet.next()) {
                            itemid = rowSet.getString("fitemid");
                            sum = (BigDecimal)sumItem.get(itemid);
                            if (sum == null) {
                                sum = ZERO;
                            }
                            if ((amount = rowSet.getBigDecimal("FAmount")) == null) {
                                amount = ZERO;
                            }
                            sumItem.put(itemid, sum.add(amount));
                        }
                        rowSet = DbUtil.executeQuery((Context)ctx, (String)(sql.toString() + "0"));
                        while (rowSet.next()) {
                            itemid = rowSet.getString("fitemid");
                            sum = (BigDecimal)sumItem.get(itemid);
                            if (sum == null) {
                                sum = ZERO;
                            }
                            if ((amount = rowSet.getBigDecimal("FAmount")) == null) {
                                amount = ZERO;
                            }
                            sumItem.put(itemid, sum.subtract(amount));
                        }
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
                for (String itemid : sumItem.keySet()) {
                    HashMap<String, String> data = new HashMap<String, String>(4);
                    data.put("RPTITEM_ID", itemid);
                    data.put("KEY_CURRENCY_ID", currencyId);
                    data.put("Value", (String)sumItem.get(itemid));
                    result.add(data);
                }
                continue;
            }
            BigDecimal sumOwner = ZERO;
            try {
                while (invests.next()) {
                    BigDecimal ownernew = invests.getBigDecimal("FOwnerSumNew");
                    BigDecimal ownerold = invests.getBigDecimal("FOwnerSumOld");
                    sumOwner = sumOwner.add(ownernew.subtract(ownerold));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (sumOwner.compareTo(ZERO) == 0) continue;
            HashMap<String, Object> data = new HashMap<String, Object>(4);
            data.put("KEY_CURRENCY_ID", currencyId);
            data.put("Value", sumOwner);
            result.add(data);
        }
        return result;
    }

    @Override
    protected List _getThisYearSumInvestAmount(Context ctx, String companyID, String targetCompanyID, int year, boolean isIncludeFirst) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = this.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet invests = this.getThisYearInvests(ctx, companyID, targetCompanyID, currencyId, year, isIncludeFirst);
            BigDecimal sumInvestAmount = ZERO;
            try {
                while (invests.next()) {
                    BigDecimal investAmount = invests.getBigDecimal("FInvestAmount");
                    sumInvestAmount = sumInvestAmount.add(investAmount);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (sumInvestAmount.compareTo(ZERO) == 0) continue;
            HashMap<String, Object> data = new HashMap<String, Object>(4);
            data.put("KEY_CURRENCY_ID", currencyId);
            data.put("Value", sumInvestAmount);
            result.add(data);
        }
        return result;
    }

    @Override
    protected List _getThisYearProfit(Context ctx, String companyID, String targetCompanyID, int year, boolean expanded) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = this.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = this.getFirstThisYearInvest(ctx, companyID, targetCompanyID, currencyId, year);
            if (info == null) continue;
            try {
                if (!info.next()) continue;
                if (expanded) {
                    StringBuffer sql = new StringBuffer();
                    sql.append("select t1.fitemid, t1.famount");
                    sql.append(" from t_csl_investDayEntry t1");
                    sql.append(" join t_csl_rptItem t2 on t1.fitemId = t2.fid");
                    sql.append(" where t1.finvestDayId = '");
                    sql.append(info.getString("FID"));
                    sql.append("' and t1.fcontrolAttr = ");
                    sql.append(21);
                    sql.append(" and t1.famount > 0 and t2.fisSumItem = 0");
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    while (rowSet.next()) {
                        HashMap<String, Object> data = new HashMap<String, Object>(4);
                        data.put("RPTITEM_ID", rowSet.getString("fitemid"));
                        data.put("KEY_CURRENCY_ID", currencyId);
                        data.put("Value", rowSet.getBigDecimal("famount"));
                        result.add(data);
                    }
                    continue;
                }
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", info.getBigDecimal("FProfit"));
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    private IRowSet getFirstThisYearInvest(Context ctx, String companyId, String targetCompanyId, String currencyId, int year) throws EASBizException, BOSException {
        int firstYear = this.getFirstInvestYear(ctx, companyId, targetCompanyId, currencyId);
        if (firstYear != year) {
            return null;
        }
        return this.getFirstInvest(ctx, companyId, targetCompanyId, currencyId);
    }

    @Override
    protected List _getEndOfThisYearSumInvestRate(Context ctx, String companyId, String targetCompanyId, int year) throws EASBizException, BOSException {
        ArrayList result = new ArrayList();
        List currencies = this.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = this.getEndOfYearInvest(ctx, companyId, targetCompanyId, currencyId, year);
            try {
                if (!info.next()) continue;
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", info.getBigDecimal("FSumInvestRate"));
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    @Override
    protected BigDecimal _getEndOfThisYearSumInvestRate(Context ctx, String companyId, String targetCompanyId, int year, String currencyId) throws EASBizException, BOSException {
        IRowSet info = this.getEndOfYearInvest(ctx, companyId, targetCompanyId, currencyId, year);
        try {
            if (info.next()) {
                return info.getBigDecimal("FSumInvestRate");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ZERO;
    }

    @Override
    protected BigDecimal _getBeginOfThisYearSumInvestRate(Context ctx, String companyId, String targetCompanyId, String currencyId, int year) throws EASBizException, BOSException {
        return this._getEndOfThisYearSumInvestRate(ctx, companyId, targetCompanyId, year - 1, currencyId);
    }

    @Override
    protected Map _getThisYearAllProfit(Context ctx, String companyId, String targetCompanyId, int year) throws EASBizException, BOSException {
        HashMap result = new HashMap();
        List currencies = this.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet invests = this.getThisYearInvests(ctx, companyId, targetCompanyId, currencyId, year, true);
            ArrayList allProfit = new ArrayList();
            try {
                while (invests.next()) {
                    BigDecimal profit = invests.getBigDecimal("FProfit");
                    if (profit == null) {
                        profit = ZERO;
                    }
                    HashMap<String, BigDecimal> data = new HashMap<String, BigDecimal>(4);
                    data.put("Value", profit);
                    data.put("SumInvestRate", invests.getBigDecimal("FSumInvestRate"));
                    allProfit.add(data);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            result.put(currencyId, allProfit);
        }
        return result;
    }

    @Override
    protected List _getThisYearAllSumInvestRate(Context ctx, String companyId, String targetCompanyId, String currencyId, int year) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        IRowSet invests = this.getThisYearInvests(ctx, companyId, targetCompanyId, currencyId, year, true);
        try {
            while (invests.next()) {
                BigDecimal sumInvestRate = invests.getBigDecimal("FSumInvestRate");
                if (sumInvestRate == null) {
                    sumInvestRate = ZERO;
                }
                HashMap<String, BigDecimal> data = new HashMap<String, BigDecimal>(4);
                data.put("Profit", invests.getBigDecimal("FProfit"));
                data.put("SumInvestRate", sumInvestRate);
                result.add(data);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    @Override
    protected List _getThisDaySumInvestRate(Context ctx, String companyId, String targetCompanyId, java.util.Date day) throws EASBizException, BOSException {
        ArrayList result = new ArrayList();
        List currencies = this.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = this.getThisDayInvest(ctx, companyId, targetCompanyId, currencyId, day);
            try {
                if (!info.next()) continue;
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", info.getBigDecimal("FSumInvestRate"));
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    @Override
    protected BigDecimal _getThisDaySumInvestRate(Context ctx, String companyId, String targetCompanyId, String currencyId, java.util.Date day) throws EASBizException, BOSException {
        IRowSet info = this.getThisDayInvest(ctx, companyId, targetCompanyId, currencyId, day);
        try {
            if (info.next()) {
                return info.getBigDecimal("FSumInvestRate");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ZERO;
    }

    private IRowSet getThisDayInvest(Context ctx, String companyId, String targetCompanyId, String currencyId, java.util.Date day) throws BOSException {
        String endOfDate = CslRptUtil.formatDateForSql(RPTDateUtil.getEndOfDay(day));
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 FID, FChangeDate, FInvestRate, FSumInvestRate, ");
        sql.append("FInvestAmount, FSumInvestAmout, FOwnerSumNew, FOwnerSumOld, FProfit, ");
        sql.append("FHonor, FHonorSum, FMinorityChange from t_csl_investDay");
        sql.append(" where FCurrencyId = ?");
        sql.append(" and FCompanyId = ?");
        sql.append(" and FTargetCompanyId = ?");
        sql.append(" and FChangeDate <= ");
        sql.append(endOfDate);
        sql.append(" order by FChangeDate desc");
        Object[] param = new Object[]{currencyId, companyId, targetCompanyId};
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
    }

    @Override
    protected boolean _existsInvest(Context ctx, String companyId, String targetCompanyId, int year) throws BOSException, EASBizException {
        String beginOfYear = CslRptUtil.formatDateForSql(RPTDateUtil.getBeginOfYear(year));
        String endOfYear = CslRptUtil.formatDateForSql(RPTDateUtil.getEndOfYear(year));
        IInvestDay iinvestDay = InvestDayFactory.getLocalInstance(ctx);
        StringBuffer oql = new StringBuffer();
        oql.append("where company.id = '" + companyId);
        oql.append("' and targetCompany.id = '" + targetCompanyId);
        oql.append("' and changeDate >= " + beginOfYear);
        oql.append(" and changeDate <= " + endOfYear);
        return iinvestDay.exists(oql.toString());
    }

    @Override
    protected boolean _isThisYearByFirstInvest(Context ctx, String companyId, String targetCompanyId, String currencyId, int year) throws BOSException, EASBizException {
        int firstYear = this._getFirstInvestYear(ctx, companyId, targetCompanyId, currencyId);
        return firstYear == year;
    }

    @Override
    protected int _getFirstInvestYear(Context ctx, String companyId, String targetCompanyId, String currencyId) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        oql.append("select min(FChangeDate) as firstDate from t_csl_investDay");
        oql.append(" where FCompanyId = '");
        oql.append(companyId);
        oql.append("' and FTargetCompanyId = '");
        oql.append(targetCompanyId);
        if (!StringUtils.isEmpty((String)currencyId)) {
            oql.append("' and FCurrencyId = '");
            oql.append(currencyId);
        }
        oql.append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        try {
            if (rowSet.next()) {
                Date changeDate = rowSet.getDate("firstDate");
                if (changeDate == null) {
                    return -1;
                }
                return DateTimeUtils.getYear((java.util.Date)changeDate);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return -1;
    }

    private List getCurrencyIds(Context ctx) throws BOSException {
        ArrayList<String> result = new ArrayList<String>();
        String sql = "select fcurrencyId from t_csl_investDay group by fcurrencyId";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                result.add(rowSet.getString("fcurrencyId"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    @Override
    protected boolean _checkCombineTypeConstant(Context ctx, IObjectValue targetCompany, java.util.Date changeDate, CombineTypeEnum combineType, Map param) throws BOSException, EASBizException {
        if (((Boolean)param.get("isAddnew")).booleanValue()) {
            this.addnewCheck(ctx, targetCompany, changeDate, combineType, param);
        } else {
            this.updateCheck(ctx, targetCompany, changeDate, combineType, param);
        }
        return true;
    }

    private boolean addnewCheck(Context ctx, IObjectValue targetCompany, java.util.Date changeDate, CombineTypeEnum combineType, Map param) throws BOSException, EASBizException {
        CompanyOrgUnitInfo tarCompany = (CompanyOrgUnitInfo)targetCompany;
        if (tarCompany != null) {
            Calendar ca = Calendar.getInstance();
            ca.setTime(changeDate);
            int year = ca.get(1);
            StringBuffer buffer = new StringBuffer();
            buffer.append("select top 1 fid,FChangeDate,FCombineType from T_CSL_InvestDay where");
            buffer.append(" FTargetCompanyID = '");
            buffer.append(tarCompany.getId().toString());
            if (changeDate != null) {
                buffer.append("' and FChangeDate <= Date'");
                buffer.append(changeDate);
            }
            if (!((Boolean)param.get("isAddnew")).booleanValue()) {
                InvestDayInfo info = (InvestDayInfo)param.get("editData");
                buffer.append("' and fid !='").append(info.getId().toString());
            }
            buffer.append("' order by FChangeDate desc");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
            try {
                if (rs != null && rs.next()) {
                    Date lastChangeDate = rs.getDate("FChangeDate");
                    int lastCombineType = rs.getInt("FCombineType");
                    ca.setTime(lastChangeDate);
                    int lastYear = ca.get(1);
                    if (combineType.getValue() != lastCombineType && year == lastYear) {
                        throw new InvestCheckException(InvestCheckException.CHECKCOMBINETYPE, new Object[]{new Integer(year).toString(), tarCompany.getName(), CombineTypeEnum.getEnum(lastCombineType).getAlias()});
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return true;
    }

    private boolean updateCheck(Context ctx, IObjectValue targetCompany, java.util.Date changeDate, CombineTypeEnum combineType, Map param) throws BOSException, EASBizException {
        this.addnewCheck(ctx, targetCompany, changeDate, combineType, param);
        CompanyOrgUnitInfo tarCompany = (CompanyOrgUnitInfo)targetCompany;
        if (tarCompany != null) {
            Calendar ca = Calendar.getInstance();
            ca.setTime(changeDate);
            int year = ca.get(1);
            StringBuffer buffer = new StringBuffer();
            buffer.append("select top 1 fid,FChangeDate,FCombineType from T_CSL_InvestDay where");
            buffer.append(" FTargetCompanyID = '");
            buffer.append(tarCompany.getId().toString());
            if (changeDate != null) {
                buffer.append("' and FChangeDate >= Date'");
                buffer.append(changeDate);
            }
            if (!((Boolean)param.get("isAddnew")).booleanValue()) {
                InvestDayInfo info = (InvestDayInfo)param.get("editData");
                buffer.append("' and fid !='").append(info.getId().toString());
            }
            buffer.append("' order by FChangeDate asc");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
            try {
                if (rs != null && rs.next()) {
                    Date lastChangeDate = rs.getDate("FChangeDate");
                    int lastCombineType = rs.getInt("FCombineType");
                    ca.setTime(lastChangeDate);
                    int lastYear = ca.get(1);
                    if (combineType.getValue() != lastCombineType && year == lastYear) {
                        throw new InvestCheckException(InvestCheckException.CHECKCOMBINETYPE, new Object[]{new Integer(year).toString(), tarCompany.getName(), CombineTypeEnum.getEnum(lastCombineType).getAlias()});
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return true;
    }
}

