/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataRepairUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractItemFieldMappedControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableField;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableItem;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableField;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableFieldItem;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableJdbcTemplate;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableUtil;
import com.kingdee.eas.fi.rpt.jdbc.PreparedStatementCallback;
import com.kingdee.eas.fi.rpt.jdbc.SqlParameter;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ItemFieldMappedControllerBean
extends AbstractItemFieldMappedControllerBean {
    @Override
    public void _addnew(Context ctx, IObjectPK itemID) throws BOSException, EASBizException {
        StringBuffer strSql = null;
        Map mapNames = null;
        if (itemID != null && itemID.getKeyValue("ID") != null) {
            if (this.existsMapped(ctx, itemID)) {
                return;
            }
            Uuid uuid = Uuid.create();
            mapNames = this.getTableNameAndFieldName(ctx);
            strSql = new StringBuffer("Insert into T_CSL_ItemFieldMapped(FID,FItemID,FTableName,FFieldName,FSeq) Values(");
            strSql = strSql.append("'" + uuid.toString() + "',");
            strSql = strSql.append("'" + itemID.getKeyValue("ID") + "',");
            strSql = strSql.append("'" + (String)mapNames.get("FTableName") + "',");
            strSql = strSql.append("'" + (String)mapNames.get("FFieldName") + "',");
            strSql = strSql.append((Integer)mapNames.get("FSeq") + ")");
            DbUtil.execute((Context)ctx, (String)strSql.toString());
        }
    }

    @Override
    public void _delete(Context ctx, IObjectPK itemID) throws BOSException, EASBizException {
        ArrayList<String> alParams = new ArrayList<String>();
        String strSql = "Delete From T_CSL_ItemFieldMapped Where FItemID = ?";
        alParams.add(itemID.getKeyValue("ID").toString());
        DbUtil.execute((Context)ctx, (String)strSql, (Object[])alParams.toArray());
    }

    private boolean existsMapped(Context ctx, IObjectPK itemID) throws BOSException, EASBizException {
        if (itemID != null) {
            StringBuffer strSql = new StringBuffer();
            Object[] params = new Object[]{itemID.toString()};
            strSql.append("Select top 1 FID from ").append("T_CSL_ItemFieldMapped").append(" where FItemID = ?");
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])params);
                if (rowSet.next()) {
                    return true;
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return false;
    }

    @Override
    public Map _getHiberMapInfoByItemNumbers(Context ctx, List itemList) throws BOSException, EASBizException {
        Map mapResult = null;
        IRowSet rowSet = null;
        if (itemList != null && itemList.size() > 0) {
            try {
                rowSet = this.HiberMapInfoByItemNumbers(ctx, itemList);
                if (rowSet != null && rowSet.size() < itemList.size()) {
                    ArrayList<String> existHiberMapRptItems = new ArrayList<String>();
                    while (rowSet.next()) {
                        existHiberMapRptItems.add(rowSet.getString("FNumber"));
                    }
                    this.createHiberMap(ctx, itemList, existHiberMapRptItems);
                    rowSet = this.HiberMapInfoByItemNumbers(ctx, itemList);
                }
                mapResult = this.constructTableNameAndItem(ctx, rowSet);
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return mapResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRowSet HiberMapInfoByItemNumbers(Context ctx, List itemList) throws BOSException, EASBizException {
        IRowSet rowSet = null;
        ArrayList<String> alParams = new ArrayList<String>();
        StringBuffer strSql = new StringBuffer();
        if (itemList != null && itemList.size() > 0) {
            int MAX_QUERY_SIZE;
            int iItemList = itemList.size();
            if (iItemList > (MAX_QUERY_SIZE = 800)) {
                String itemTempTableName = null;
                TempTableJdbcTemplate tempTableJdbcTemplate = new TempTableJdbcTemplate(ctx);
                try {
                    tempTableJdbcTemplate.initConnection();
                    itemTempTableName = this.getItemTable(itemList, tempTableJdbcTemplate);
                    strSql.append("\tSelect \tb.FTableName FTableName,\t\t\t\t\t\t\t\n");
                    strSql.append("\tb.FFieldName FFieldName,\t\t\t\t\t\t\t\t\t\n");
                    strSql.append("\ta.FNumber FNumber \t\t\t\t\t\t\t\t\t\t\t\n");
                    strSql.append("\tFrom\tT_CSL_RptItem a \t\t\t\t\n");
                    strSql.append("\tINNER JOIN \tT_CSL_ItemFieldMapped b \t\n");
                    strSql.append("\t\tON a.FID=b.FItemID \t\n");
                    strSql.append("\tINNER JOIN \t" + itemTempTableName + " ITEM \t\t\t\t\t\n");
                    strSql.append("\t\tON a.Fnumber  = ITEM.FNUMBER \t\t\t\t\t\t\t\n");
                    strSql.append("\t");
                    try {
                        rowSet = new JdbcRowSet();
                    }
                    catch (SQLException exc) {
                        throw new BOSException((Throwable)exc);
                    }
                    final JdbcRowSet finalRowSet = (JdbcRowSet)rowSet;
                    tempTableJdbcTemplate.execute(strSql.toString(), new PreparedStatementCallback(){

                        public Object doInPreparedStatement(PreparedStatement ps) throws SQLException {
                            ResultSet rs = ps.executeQuery();
                            finalRowSet.populate(rs);
                            return null;
                        }
                    });
                    IRowSet iRowSet = rowSet;
                    return iRowSet;
                }
                finally {
                    if (!StringUtils.isEmpty((String)itemTempTableName) && !DebugLogger.isDebug) {
                        TempTableUtil.releaseDBSystemTempTable((TempTableJdbcTemplate)tempTableJdbcTemplate, (String)itemTempTableName);
                    }
                    tempTableJdbcTemplate.cleanupConnection();
                }
            }
            strSql.append("Select b.FTableName FTableName,b.FFieldName FFieldName,a.FNumber FNumber From T_CSL_RptItem a,T_CSL_ItemFieldMapped b where a.FID=b.FItemID and a.Fnumber in (");
            for (int i = 0; i < iItemList; ++i) {
                if (i > 0) {
                    strSql.append(",");
                }
                strSql.append("?");
                alParams.add(itemList.get(i).toString());
            }
            strSql.append(")");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])alParams.toArray());
        }
        return rowSet;
    }

    private String getItemTable(final List itemList, TempTableJdbcTemplate tempTableJdbcTemplate) throws BOSException {
        TempTableField tempTableField = new TempTableField();
        tempTableField.addTempTableItem((ITempTableItem)new TempTableFieldItem("FNUMBER", "FNUMBER", new SqlParameter(12, "nvarchar(80)")));
        String tmpTplItemTableName = TempTableUtil.createDBSystemTempTable((TempTableJdbcTemplate)tempTableJdbcTemplate, (ITempTableField)tempTableField, (String)"T_TMP_ITEM_NUM", (boolean)DebugLogger.isDebug);
        StringBuffer ksqlBuffer = new StringBuffer();
        ksqlBuffer.append(" INSERT INTO ").append(tmpTplItemTableName).append(" \n");
        ksqlBuffer.append(" VALUES(?)");
        tempTableJdbcTemplate.execute(ksqlBuffer.toString(), new PreparedStatementCallback(){

            public Object doInPreparedStatement(PreparedStatement ps) throws SQLException {
                for (int i = 0; i < itemList.size(); ++i) {
                    ps.setString(1, (String)itemList.get(i));
                    ps.addBatch();
                }
                return ps.executeBatch();
            }
        });
        tempTableJdbcTemplate.analyzeTable(tmpTplItemTableName);
        return tmpTplItemTableName;
    }

    private void createHiberMap(Context ctx, List itemList, List existHiberMapRptItems) throws BOSException, EASBizException, SQLException {
        StringBuffer rptItemNumbers = new StringBuffer();
        String rptItemNumber = null;
        for (int i = 0; i < itemList.size(); ++i) {
            rptItemNumber = (String)itemList.get(i);
            if (existHiberMapRptItems.contains(rptItemNumber)) continue;
            if (rptItemNumbers.length() > 0) {
                rptItemNumbers.append(",");
            }
            rptItemNumbers.append("'").append(rptItemNumber).append("'");
        }
        if (rptItemNumbers.length() > 0) {
            String sql = "select fid from T_CSL_RptItem where Fnumber in (" + rptItemNumbers.toString() + ")";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                this._addnew(ctx, (IObjectPK)new ObjectStringPK(rowSet.getString("fid")));
            }
        }
    }

    private Map constructTableNameAndItem(Context ctx, IRowSet rowSet) throws SQLException, BOSException {
        String strCurTableName = null;
        Map<String, String> mapTemp = null;
        TreeMap mapResult = new TreeMap();
        ArrayList<String> tableNames = new ArrayList<String>();
        while (rowSet.next()) {
            strCurTableName = rowSet.getString("FTableName");
            if (StringUtils.isEmpty((String)strCurTableName)) continue;
            if (mapResult.containsKey(strCurTableName = strCurTableName.trim())) {
                mapTemp = (Map)mapResult.get(strCurTableName);
            } else {
                mapTemp = new TreeMap();
                tableNames.add(strCurTableName);
            }
            mapTemp.put(rowSet.getString("FNumber"), rowSet.getString("FFieldName"));
            mapResult.put(strCurTableName, mapTemp);
        }
        DataRepairUtil.fixItemDataEntryTable(ctx, tableNames);
        return mapResult;
    }

    @Override
    public Map _getFlatMapInfoByItemNumbers(Context ctx, List itemList) throws BOSException, EASBizException {
        TreeMap<String, String> mapResult = null;
        ArrayList<String> alParams = new ArrayList<String>();
        ArrayList<String> tableNames = new ArrayList<String>();
        StringBuffer strSql = new StringBuffer();
        if (itemList != null && itemList.size() > 0) {
            int iItemListCount = itemList.size();
            strSql.append("Select b.FTableName FTableName,b.FFieldName FFieldName,a.FNumber FNumber From ").append("T_CSL_RptItem").append(" a,").append("T_CSL_ItemFieldMapped").append(" b where a.FID=b.FItemID and (");
            for (int i = 0; i < iItemListCount; ++i) {
                if (i > 0) {
                    strSql.append(" or ");
                }
                strSql.append("a.FNumber = ?");
                alParams.add(itemList.get(i).toString());
            }
            strSql.append(") order by a.FNumber ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])alParams.toArray());
            try {
                mapResult = new TreeMap<String, String>();
                while (rowSet.next()) {
                    String tableName = rowSet.getString("FTableName");
                    mapResult.put(rowSet.getString("FNumber"), tableName + "." + rowSet.getString("FFieldName"));
                    if (tableNames.contains(tableName)) continue;
                    tableNames.add(tableName);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        DataRepairUtil.fixItemDataEntryTable(ctx, tableNames);
        return mapResult;
    }

    @Override
    public Map _getHiberMapInfoByCondition(Context ctx, ItemDataCondition condition) throws BOSException, EASBizException {
        Map mapResult = null;
        ArrayList<Object> alParams = new ArrayList<Object>();
        StringBuffer strSql = new StringBuffer();
        if (condition != null) {
            IRowSet rowSet;
            String sql;
            Map map = condition.getItemList();
            if (map != null && map.size() > 0) {
                Set set = map.keySet();
                return this._getHiberMapInfoByItemNumbers(ctx, new ArrayList(set));
            }
            strSql.append("Select b.FTableName FTableName,b.FFieldName FFieldName,a.FNumber FNumber From T_CSL_RptItem a,T_CSL_ItemFieldMapped b where a.FID=b.FItemID ");
            if (condition.getItemNumberStart() != null) {
                sql = "select fid from t_csl_rptItem where FNumber = ?";
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{condition.getItemNumberStart()});
                if (rowSet.size() == 0) {
                    throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Csl_Item_NotExist", (Locale)ctx.getOriginLocale())), new Object[]{condition.getItemNumberStart()});
                }
                strSql.append("and a.FNumber >= ?");
                alParams.add(condition.getItemNumberStart());
            }
            if (condition.getItemNumberEnd() != null) {
                sql = "select fid from t_csl_rptItem where FNumber = ?";
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{condition.getItemNumberEnd()});
                if (rowSet.size() == 0) {
                    throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Csl_Item_NotExist", (Locale)ctx.getOriginLocale())), new Object[]{condition.getItemNumberEnd()});
                }
                strSql.append("and a.FNumber <= ?");
                alParams.add(condition.getItemNumberEnd());
            }
            if (condition.getItemNumberLevelStart() != -1) {
                strSql.append("and a.FLevel >= ?");
                alParams.add(new Integer(condition.getItemNumberLevelStart()));
            }
            if (condition.getItemNumberLevelEnd() != -1) {
                strSql.append("and a.FLevel <= ?");
                alParams.add(new Integer(condition.getItemNumberLevelEnd()));
            }
            if (!condition.isShowFreezeItem()) {
                strSql.append(" and FIsFreezed=0");
            }
            if (condition.getReportClass() != null) {
                strSql.append(" and FReportClassID = ?");
                alParams.add(condition.getReportClass());
            }
            IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])alParams.toArray());
            try {
                mapResult = this.constructTableNameAndItem(ctx, rowSet2);
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return mapResult;
    }

    @Override
    public Map _getFlatMapInfoByCondition(Context ctx, ItemDataCondition condition) throws BOSException, EASBizException {
        TreeMap<String, String> mapResult = null;
        ArrayList<Object> alParams = new ArrayList<Object>();
        ArrayList<String> tableNames = new ArrayList<String>();
        StringBuffer strSql = new StringBuffer();
        if (condition != null) {
            Map map = condition.getItemList();
            if (map != null && map.size() > 0) {
                Set set = map.keySet();
                return this._getFlatMapInfoByItemNumbers(ctx, new ArrayList(set));
            }
            strSql.append("Select b.FTableName FTableName,b.FFieldName FFieldName,a.FNumber FNumber From ").append("T_CSL_RptItem").append(" a,").append("T_CSL_ItemFieldMapped").append(" b where a.FID=b.FItemID ");
            if (condition.getItemNumberStart() != null && condition.getItemNumberEnd() != null && condition.getItemNumberEnd().equals(condition.getItemNumberStart())) {
                strSql.append("and a.FNumber = ? ");
                alParams.add(condition.getItemNumberStart());
            } else {
                if (condition.getItemNumberStart() != null) {
                    strSql.append("and a.FNumber >= ? ");
                    alParams.add(condition.getItemNumberStart());
                }
                if (condition.getItemNumberEnd() != null) {
                    strSql.append("and a.FNumber <= ? ");
                    alParams.add(condition.getItemNumberEnd());
                }
            }
            if (condition.getItemNumberLevelStart() != -1 && condition.getItemNumberLevelEnd() != -1 && condition.getItemNumberLevelStart() == condition.getItemNumberLevelEnd()) {
                strSql.append("and a.FLevel = ? ");
                alParams.add(new Integer(condition.getItemNumberLevelStart()));
            } else {
                if (condition.getItemNumberLevelStart() != -1) {
                    strSql.append("and a.FLevel >= ? ");
                    alParams.add(new Integer(condition.getItemNumberLevelStart()));
                }
                if (condition.getItemNumberLevelEnd() != -1) {
                    strSql.append("and a.FLevel <= ? ");
                    alParams.add(new Integer(condition.getItemNumberLevelEnd()));
                }
            }
            strSql.append(" order by b.FTableName");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])alParams.toArray());
            try {
                mapResult = new TreeMap<String, String>();
                while (rowSet.next()) {
                    String tableName = rowSet.getString("FTableName");
                    mapResult.put(rowSet.getString("FNumber"), tableName + "." + rowSet.getString("FFieldName"));
                    if (tableNames.contains(tableName)) continue;
                    tableNames.add(tableName);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        DataRepairUtil.fixItemDataEntryTable(ctx, tableNames);
        return mapResult;
    }

    private Map getTableNameAndFieldName(Context ctx) throws BOSException {
        String strSql = "";
        int preSeq = -1;
        boolean bIsmaxSeq = false;
        String strTableName = "T_CSL_ItemDataEntry";
        HashMap<String, Object> map = new HashMap<String, Object>();
        strSql = "select FSeq From T_CSL_ItemFieldMapped order by FSeq asc";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql);
        try {
            while (rowSet.next()) {
                if (preSeq == -1) {
                    preSeq = rowSet.getInt("FSeq");
                    continue;
                }
                int curSeq = rowSet.getInt("FSeq");
                if (curSeq != preSeq + 1) break;
                preSeq = curSeq;
            }
            if (preSeq == -1) {
                preSeq = 1;
                bIsmaxSeq = true;
            } else {
                ++preSeq;
            }
            if (rowSet.isAfterLast()) {
                bIsmaxSeq = true;
            }
        }
        catch (SQLException ex) {
            throw new SQLDataException(ex);
        }
        strTableName = this.getTableNameByFieldSeq(preSeq);
        map.put("FTableName", strTableName);
        map.put("FFieldName", "F" + preSeq);
        map.put("FSeq", new Integer(preSeq));
        if (bIsmaxSeq && (preSeq - 1) % 300 == 0) {
            this.createItemDataEntryTable(ctx, strTableName, preSeq);
        }
        return map;
    }

    private void createItemDataEntryTable(Context ctx, String strTableName, int seq) throws BOSException {
        StringBuffer strSql = new StringBuffer();
        if (this.isTableExist(ctx, strTableName)) {
            return;
        }
        strSql.append("Create Table " + strTableName + "(FID CHAR(36) NOT NULL");
        for (int i = 0; i < 300; ++i) {
            strSql = strSql.append(",F" + (i + seq) + " NUMERIC(21,6)");
        }
        strSql = strSql.append(",CONSTRAINT PK_CSL_ItmDtEty" + this.getStrSeqHasPreZero(seq) + " PRIMARY KEY (FID))");
        DbUtil.execute((Context)ctx, (String)strSql.toString());
        strSql.delete(0, strSql.length());
        Uuid uuid = Uuid.create();
        strSql.append("select FTableName from ").append("T_CSL_ItemDataTable");
        strSql.append(" where FTableName = '").append(strTableName).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString());
        if (rowSet.size() == 0) {
            strSql.delete(0, strSql.length());
            strSql.append("Insert Into T_CSL_ItemDataTable(FID,FTableName) Values('" + uuid.toString() + "','" + strTableName + "')");
            DbUtil.execute((Context)ctx, (String)strSql.toString());
        }
    }

    private String getTableNameByFieldSeq(int seq) {
        String strTableName = "T_CSL_ItemDataEntry" + this.getStrSeqHasPreZero(seq);
        return strTableName;
    }

    private String getStrSeqHasPreZero(int seq) {
        return CslRptUtil.repeartStr("0", 3 - String.valueOf((seq - 1 + 300) / 300).length()) + (seq - 1 + 300) / 300;
    }

    @Override
    public List _getTableNameByItemNumber(Context ctx, List itemList) throws BOSException, EASBizException {
        if (itemList.size() <= 0) {
            return null;
        }
        StringBuffer strSql = new StringBuffer();
        ArrayList listParams = new ArrayList();
        ArrayList<String> listResult = null;
        ArrayList<String> tableNames = new ArrayList<String>();
        strSql = strSql.append("Select b.FTableName FTableName From T_Csl_RptItem a,T_Csl_ItemDataMapped b where a.FID = b.FItemDataID and (");
        for (int i = 0; i < itemList.size(); ++i) {
            if (i > 0) {
                strSql = strSql.append(" or ");
            }
            strSql = strSql.append("a.FNumber = ?");
            listParams.add(itemList.get(i));
        }
        strSql = strSql.append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])listParams.toArray());
        try {
            while (rowSet.next()) {
                if (listResult == null) {
                    listResult = new ArrayList<String>();
                }
                String tableName = rowSet.getString("FTableName");
                listResult.add(tableName);
                if (tableNames.contains(tableName)) continue;
                tableNames.add(tableName);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        DataRepairUtil.fixItemDataEntryTable(ctx, tableNames);
        return listResult;
    }

    @Override
    public List _getTableNameByReportId(Context ctx, String reportID) throws BOSException, EASBizException {
        if (reportID.length() <= 0) {
            return null;
        }
        StringBuffer strSql = new StringBuffer();
        ArrayList<String> listParams = new ArrayList<String>();
        ArrayList<String> listResult = null;
        strSql = strSql.append("Select distinct(b.FTableName) FTableName ");
        strSql = strSql.append("From T_Csl_RptItem a,T_Csl_ItemFieldMapped b,T_Csl_CslReport c,T_CSL_TempletItemList d ");
        strSql = strSql.append("where c.FTemplateID=d.FTemplateID and d.FItemNumber = a.FNumber and a.FID = b.FItemID and ");
        strSql = strSql.append("c.FID = ?");
        listParams.add(reportID);
        ArrayList<String> tableNames = new ArrayList<String>();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])listParams.toArray());
        try {
            while (rowSet.next()) {
                if (listResult == null) {
                    listResult = new ArrayList<String>();
                }
                String tableName = rowSet.getString("FTableName");
                listResult.add(tableName);
                if (tableNames.contains(tableName)) continue;
                tableNames.add(tableName);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        DataRepairUtil.fixItemDataEntryTable(ctx, tableNames);
        return listResult;
    }

    @Override
    public Map _getFlatMapInfoByReportID(Context ctx, String reportID) throws BOSException, EASBizException {
        TreeMap<String, String> mapResult = null;
        ArrayList<String> alParams = new ArrayList<String>();
        StringBuffer strSql = new StringBuffer();
        ArrayList<String> tableNames = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)reportID)) {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"select FTemplateID from t_csl_cslreport where fid = ?", (Object[])new Object[]{reportID});
            try {
                if (rowSet.next()) {
                    String templateId = rowSet.getString("FTemplateID");
                    strSql.append("Select distinct b.FTableName FTableName,b.FFieldName FFieldName,a.FNumber FNumber From ");
                    strSql.append("T_CSL_RptItem a,");
                    strSql.append("T_CSL_ItemFieldMapped b,");
                    strSql.append("T_CSL_TempletItemList d ");
                    strSql.append("where d.FItemNumber = a.FNumber and a.FID = b.FItemID");
                    strSql.append(" and (d.FTemplateID = ? or d.FTemplateID in");
                    strSql.append("(select FGroupTemplateID from T_Rpt_Template where FID = ?))");
                    alParams.add(templateId);
                    alParams.add(templateId);
                    IRowSet rset = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])alParams.toArray());
                    mapResult = new TreeMap<String, String>();
                    while (rset.next()) {
                        String tableName = rset.getString("FTableName");
                        mapResult.put(rset.getString("FNumber"), tableName + "." + rset.getString("FFieldName"));
                        if (tableNames.contains(tableName)) continue;
                        tableNames.add(tableName);
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        DataRepairUtil.fixItemDataEntryTable(ctx, tableNames);
        return mapResult;
    }

    @Override
    public Map _getHiberMapInfoByReportID(Context ctx, String reportID) throws BOSException, EASBizException {
        Map mapResult = null;
        ArrayList<String> alParams = new ArrayList<String>();
        StringBuffer strSql = new StringBuffer();
        if (!StringUtils.isEmpty((String)reportID)) {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"select FTemplateID from t_csl_cslreport where fid = ?", (Object[])new Object[]{reportID});
            try {
                if (rowSet.next()) {
                    String templateId = rowSet.getString("FTemplateID");
                    strSql.append("Select distinct b.FTableName FTableName,b.FFieldName FFieldName,a.FNumber FNumber From ");
                    strSql.append("T_CSL_RptItem a,");
                    strSql.append("T_CSL_ItemFieldMapped b,");
                    strSql.append("T_CSL_TempletItemList d ");
                    strSql.append("where d.FItemNumber = a.FNumber and a.FID = b.FItemID");
                    strSql.append(" and d.FTemplateID in");
                    strSql.append("(select case when FGroupTemplateID IS NULL then FID ELSE FGroupTemplateID END from T_Rpt_Template where FID = ?)");
                    alParams.add(templateId);
                    rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])alParams.toArray());
                    mapResult = this.constructTableNameAndItem(ctx, rowSet);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return mapResult;
    }

    private boolean isTableExist(Context ctx, String tableName) throws BOSException {
        return DataRepairUtil.isTableExist(ctx, tableName);
    }

    @Override
    protected Map _getHiberMapInfoByReportID(Context ctx, List reportIds) throws BOSException, EASBizException {
        if (reportIds == null || reportIds.size() == 0) {
            return null;
        }
        Map mapResult = null;
        SQLBuilder builder = new SQLBuilder();
        builder.append("SELECT FTemplateID FROM T_CSL_Cslreport WHERE FId IN ", (Collection)reportIds);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)builder.getSQL(), (Object[])builder.getParams());
        try {
            ArrayList<String> templateIds = new ArrayList<String>();
            while (rowSet.next()) {
                templateIds.add(rowSet.getString("FTemplateID"));
            }
            if (templateIds.size() == 0) {
                return null;
            }
            builder.reset();
            builder.append("SELECT DISTINCT b.FTableName FTableName,b.FFieldName FFieldName,a.FNumber FNumber From ");
            builder.append("T_CSL_RptItem a,");
            builder.append("T_CSL_ItemFieldMapped b,");
            builder.append("T_CSL_TempletItemList d ");
            builder.append("WHERE d.FItemNumber = a.FNumber and a.FID = b.FItemID");
            builder.append(" AND d.FTemplateID IN (");
            builder.append("   select case when FGroupTemplateID IS NULL then FID ELSE FGroupTemplateID END from T_Rpt_Template where FID IN ", templateIds);
            builder.append(" )");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)builder.getSQL(), (Object[])builder.getParams());
            mapResult = this.constructTableNameAndItem(ctx, rowSet);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return mapResult;
    }
}

