/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.INoticeSchema;
import com.kingdee.eas.fi.gr.cslrpt.NoticeSchemaAutoPressFactory;
import com.kingdee.eas.fi.gr.cslrpt.NoticeSchemaAutoPressInfo;
import com.kingdee.eas.fi.gr.cslrpt.NoticeSchemaFactory;
import com.kingdee.eas.fi.gr.cslrpt.NoticeSchemaInfo;
import com.kingdee.eas.fi.gr.cslrpt.NoticeSchemaRemindFactory;
import com.kingdee.eas.fi.gr.cslrpt.NoticeSchemaRemindInfo;
import com.kingdee.eas.fi.gr.cslrpt.NoticeTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.PressMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.SchemaCurrencyCollection;
import com.kingdee.eas.fi.gr.cslrpt.SchemaCurrencyFactory;
import com.kingdee.eas.fi.gr.cslrpt.SchemaCurrencyInfo;
import com.kingdee.eas.fi.gr.cslrpt.SchemaReceivorCollection;
import com.kingdee.eas.fi.gr.cslrpt.SchemaReceivorFactory;
import com.kingdee.eas.fi.gr.cslrpt.SchemaReceivorInfo;
import com.kingdee.eas.fi.gr.cslrpt.SchemaTemplateCollection;
import com.kingdee.eas.fi.gr.cslrpt.SchemaTemplateFactory;
import com.kingdee.eas.fi.gr.cslrpt.SchemaTemplateInfo;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseCollection;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractNoticeSchemaControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.MessageFillAndSendUtils;
import com.kingdee.eas.fi.gr.cslrpt.app.ReportCommitAutoNoticeTool;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.SendMail;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class NoticeSchemaControllerBean
extends AbstractNoticeSchemaControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.NoticeSchemaControllerBean");

    @Override
    protected void _checkReportCommitAndNotice(Context ctx, IObjectPK schemaPK) throws BOSException, EASBizException {
        if (!this._exists(ctx, schemaPK)) {
            return;
        }
        NoticeSchemaInfo info = (NoticeSchemaInfo)this._getValue(ctx, schemaPK);
        NoticeTypeEnum noticeType = info.getNoticeType();
        if (noticeType != NoticeTypeEnum.AUTO_NOTICE) {
            return;
        }
        if (ReportCommitAutoNoticeTool.isShowAutoNoticeDebugInfo(ctx)) {
            StringBuffer logInfoBuf = new StringBuffer();
            logInfoBuf.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"252_NoticeSchemaControllerBean", (Locale)ctx.getOriginLocale()));
            logInfoBuf.append(info.getNumber());
            logInfoBuf.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"253_NoticeSchemaControllerBean", (Locale)ctx.getOriginLocale()));
            logInfoBuf.append(schemaPK.toString());
            logInfoBuf.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"254_NoticeSchemaControllerBean", (Locale)ctx.getOriginLocale()));
            DateFormat format = CslRptUtil.getNationalTimeFormat(ctx);
            if (format != null) {
                logInfoBuf.append(format.format(Calendar.getInstance().getTime()));
            } else {
                logInfoBuf.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime()));
            }
            logger.info((Object)logInfoBuf.toString());
        }
        String schemaID = schemaPK.toString();
        NoticeSchemaAutoPressInfo schemaAutoPressInfo = NoticeSchemaAutoPressFactory.getLocalInstance(ctx).getNoticeSchemaAutoPressInfo(schemaPK);
        PressMethodEnum pressMethod = schemaAutoPressInfo.getPressMethod();
        RptPeriodTypeEnum periodType = info.getPeriodType();
        String dataCollectNumber = schemaAutoPressInfo.getDataCollectNumber();
        String emailTemplate = MessageFillAndSendUtils.getEMailMessageTemplate(ctx);
        String smsTemplate = MessageFillAndSendUtils.getSMSMessageTemplate(ctx);
        SchemaCurrencyCollection schemaCurrencyCollection = SchemaCurrencyFactory.getLocalInstance(ctx).getSchemaCurrencyCollection("select * where schemaID = '" + schemaID + "'");
        HashSet<String> currencyIdSet = new HashSet<String>();
        SchemaCurrencyInfo scInfo = null;
        int count = schemaCurrencyCollection.size();
        for (int i = 0; i < count; ++i) {
            scInfo = schemaCurrencyCollection.get(i);
            currencyIdSet.add(scInfo.getCurrencyID().toString());
        }
        CurrencyCollection currencyCollection = this.getCurrencyCollection(ctx, currencyIdSet);
        Map receivers = MessageFillAndSendUtils.getReceivorMap(ctx, schemaID);
        Set templateIdSet = this.getTemplateIdSet(ctx, schemaID);
        HashMap<String, String> templateGroupMap = new HashMap<String, String>();
        EntityViewInfo templateView = new EntityViewInfo();
        FilterInfo templateFilter = new FilterInfo();
        templateFilter.getFilterItems().add(new FilterItemInfo("id", (Object)templateIdSet, CompareType.INCLUDE));
        templateView.setFilter(templateFilter);
        templateView.getSelector().add("group");
        TemplateCollection templateCollection = TemplateFactory.getLocalInstance((Context)ctx).getTemplateCollection(templateView);
        HashMap<String, String> templateMap = new HashMap<String, String>();
        HashMap<String, String> temNumMap = new HashMap<String, String>();
        TemplateInfo templateInfo = null;
        HashSet<String> groupSet = new HashSet<String>();
        int count2 = templateCollection.size();
        for (int i = 0; i < count2; ++i) {
            templateInfo = templateCollection.get(i);
            groupSet.add(templateInfo.getGroup());
        }
        templateView = new EntityViewInfo();
        templateFilter = new FilterInfo();
        templateFilter.getFilterItems().add(new FilterItemInfo("group", groupSet, CompareType.INCLUDE));
        templateFilter.getFilterItems().add(new FilterItemInfo("versionStatus", (Object)new Integer(1)));
        templateView.setFilter(templateFilter);
        templateView.getSelector().add("id");
        templateView.getSelector().add("name");
        templateView.getSelector().add("number");
        templateView.getSelector().add("group");
        TemplateCollection latestVerTemplateCollection = TemplateFactory.getLocalInstance((Context)ctx).getTemplateCollection(templateView);
        HashSet<String> latestVerTemIdSet = new HashSet<String>();
        int n = latestVerTemplateCollection.size();
        for (int i = 0; i < n; ++i) {
            templateInfo = latestVerTemplateCollection.get(i);
            String tmpId = templateInfo.getId().toString();
            latestVerTemIdSet.add(tmpId);
            temNumMap.put(tmpId, templateInfo.getNumber());
            templateMap.put(tmpId, templateInfo.getName());
            templateGroupMap.put(tmpId, templateInfo.getGroup());
        }
        EntityViewInfo templateDispenseView = new EntityViewInfo();
        FilterInfo templateDispenseFilter = new FilterInfo();
        templateDispenseFilter.getFilterItems().add(new FilterItemInfo("dispenseSrcID", latestVerTemIdSet, CompareType.INCLUDE));
        templateDispenseFilter.getFilterItems().add(new FilterItemInfo("orgBound.status", (Object)new Integer(1)));
        templateDispenseView.setFilter(templateDispenseFilter);
        templateDispenseView.getSelector().add("company.id");
        templateDispenseView.getSelector().add("company.name");
        templateDispenseView.getSelector().add("dispenseSrcID");
        TempletDispenseCollection templetDispenseCollection = TempletDispenseFactory.getLocalInstance(ctx).getTempletDispenseCollection(templateDispenseView);
        TempletDispenseInfo templetDispenseInfo = null;
        String companyId = null;
        String currencyId = null;
        String companyName = null;
        ICslReport cslReport = CslReportFactory.getLocalInstance(ctx);
        CurrencyInfo currencyInfo = null;
        boolean isPeriodBefore = schemaAutoPressInfo.isIsPeriodBefore();
        int noticeDays = schemaAutoPressInfo.getNoticeDays();
        Map reportPeriod = ReportCommitAutoNoticeTool.getReportPeriodByCurrentDate(periodType, isPeriodBefore, noticeDays);
        int year = (Integer)reportPeriod.get("year");
        int period = (Integer)reportPeriod.get("period");
        java.util.Date reportDate = (java.util.Date)reportPeriod.get("reportDate");
        HashMap companyMessagesMap = new HashMap();
        StringBuffer currencyBuf = null;
        List templateList = null;
        HashMap<String, String> tempMap = null;
        String CURRENCY_KEY = "currencyStr";
        String TEMNUM_KEY = "templateNum";
        String TEMPLATE_KEY = "templateName";
        HashMap<String, String> companyMap = new HashMap<String, String>();
        FilterInfo dispenseFilter = null;
        HashSet<Integer> rptStatusSet = new HashSet<Integer>();
        rptStatusSet.add(new Integer(2));
        rptStatusSet.add(new Integer(3));
        boolean isExistUnCommitRpt = false;
        int count3 = templetDispenseCollection.size();
        for (int i = 0; i < count3; ++i) {
            templetDispenseInfo = templetDispenseCollection.get(i);
            companyId = templetDispenseInfo.getCompany().getId().toString();
            String templateId = templetDispenseInfo.getDispenseSrcID();
            companyName = templetDispenseInfo.getCompany().getName();
            companyMap.put(companyId, companyName);
            currencyBuf = new StringBuffer();
            isExistUnCommitRpt = false;
            int curCount = currencyCollection.size();
            for (int j = 0; j < curCount; ++j) {
                currencyInfo = currencyCollection.get(j);
                currencyId = currencyInfo.getId().toString();
                dispenseFilter = new FilterInfo();
                dispenseFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
                dispenseFilter.getFilterItems().add(new FilterItemInfo("template.group", templateGroupMap.get(templateId)));
                dispenseFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
                dispenseFilter.getFilterItems().add(new FilterItemInfo("committedStatus", rptStatusSet, CompareType.INCLUDE));
                dispenseFilter.getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(year)));
                dispenseFilter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(period)));
                dispenseFilter.getFilterItems().add(new FilterItemInfo("dataCollectNumber", (Object)dataCollectNumber));
                if (cslReport.exists(dispenseFilter)) continue;
                currencyBuf.append(currencyInfo.getName());
                currencyBuf.append("\u3001");
                isExistUnCommitRpt = true;
            }
            if (!isExistUnCommitRpt) continue;
            templateList = companyMessagesMap.containsKey(companyId) ? (List)companyMessagesMap.get(companyId) : new ArrayList();
            tempMap = new HashMap<String, String>(4);
            String currencyStr = currencyBuf.toString();
            if (currencyStr.length() > 2) {
                currencyStr = currencyStr.substring(0, currencyStr.length() - 1);
            }
            tempMap.put("currencyStr", currencyStr);
            tempMap.put("templateNum", (String)temNumMap.get(templateId));
            tempMap.put("templateName", (String)templateMap.get(templateId));
            templateList.add(tempMap);
            companyMessagesMap.put(companyId, templateList);
        }
        if (!schemaAutoPressInfo.isIsNoticeOnece() && !companyMessagesMap.isEmpty()) {
            ReportCommitAutoNoticeTool tool = new ReportCommitAutoNoticeTool(info.getEfficientDate(), info.getDisabledDate(), info.getPeriodType(), schemaAutoPressInfo.isIsPeriodBefore(), schemaAutoPressInfo.isIsNoticeOnece(), schemaAutoPressInfo.getNoticeDays(), schemaAutoPressInfo.getNoticeTime(), schemaID, info.getNumber(), ctx, logger);
            Calendar curCal = Calendar.getInstance();
            curCal.add(5, 1);
            java.util.Date noticeDate = DateTimeUtils.truncateDate((java.util.Date)curCal.getTime());
            if (noticeDate.before(info.getDisabledDate())) {
                tool.createJob(noticeDate);
            }
        }
        String periodTypeStr = periodType.getAlias();
        String yearStr = String.valueOf(year);
        String periodStr = String.valueOf(period);
        String reportDateStr = new SimpleDateFormat("yyyy-MM-dd").format(reportDate);
        DateFormat format = CslRptUtil.getNationalDateFormat(ctx);
        if (format != null) {
            reportDateStr = format.format(reportDate);
        }
        Set keySet = companyMessagesMap.keySet();
        List currTempList = null;
        String emailContent = null;
        StringBuffer emailContentReportListBuf = null;
        String smsContent = null;
        StringBuffer smsContentReportListBuf = null;
        Map currencyTemplateMap2 = null;
        String companyKey2 = null;
        Locale cnLocal = Locale.SIMPLIFIED_CHINESE;
        ResourceBundleHelper rprUIMsgHelper = new ResourceBundleHelper("com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", cnLocal);
        String emailTitle = rprUIMsgHelper.getString("l14");
        String dataCollectName = null;
        if (dataCollectNumber != null) {
            DataCollectInfo dataCollect = DataCollectFactory.getLocalInstance(ctx).getDataCollectInfo("select * where number in ('" + dataCollectNumber + "')");
            dataCollectName = dataCollect.getName();
        }
        SendMail cn = new SendMail(true, ctx);
        for (String companyKey2 : keySet) {
            companyName = (String)companyMap.get(companyKey2);
            if (pressMethod == PressMethodEnum.MAIL || pressMethod == PressMethodEnum.ALL) {
                emailContent = MessageFillAndSendUtils.fillHeaderMessage(receivers, companyKey2, emailTemplate, companyName, yearStr, periodStr, periodTypeStr, null, reportDateStr, null, dataCollectName, cnLocal);
                emailContentReportListBuf = new StringBuffer();
                currTempList = (List)companyMessagesMap.get(companyKey2);
                for (Map currencyTemplateMap2 : currTempList) {
                    emailContentReportListBuf.append("\t");
                    emailContentReportListBuf.append(currencyTemplateMap2.get("currencyStr"));
                    emailContentReportListBuf.append("  ");
                    emailContentReportListBuf.append(currencyTemplateMap2.get("templateNum"));
                    emailContentReportListBuf.append("  ");
                    emailContentReportListBuf.append(currencyTemplateMap2.get("templateName"));
                    emailContentReportListBuf.append("\r\n");
                }
                emailContent = MessageFillAndSendUtils.fillReportListMessage(emailContentReportListBuf, emailContent, cnLocal);
                emailContent = MessageFillAndSendUtils.fillFooterMessage(emailContent, null, cnLocal, ctx);
                if (DebugLogger.isDebug) {
                    cn.sendEmail(emailTitle, emailContent);
                }
                MessageFillAndSendUtils.sendEmailByCompany(ctx, receivers, companyKey2, companyName, emailContent, emailTitle, null);
            }
            if (pressMethod != PressMethodEnum.SHORT_MESSAGE && pressMethod != PressMethodEnum.ALL) continue;
            smsContent = MessageFillAndSendUtils.fillHeaderMessage(receivers, companyKey2, smsTemplate, companyName, yearStr, periodStr, periodTypeStr, null, reportDateStr, null, dataCollectNumber, cnLocal);
            smsContentReportListBuf = new StringBuffer();
            currTempList = (List)companyMessagesMap.get(companyKey2);
            for (Map currencyTemplateMap2 : currTempList) {
                smsContentReportListBuf.append("\t");
                smsContentReportListBuf.append(currencyTemplateMap2.get("currencyStr"));
                smsContentReportListBuf.append(" ");
                smsContentReportListBuf.append(currencyTemplateMap2.get("templateNum"));
                smsContentReportListBuf.append(" ");
                smsContentReportListBuf.append(currencyTemplateMap2.get("templateName"));
                smsContentReportListBuf.append("\r\n");
            }
            smsContent = MessageFillAndSendUtils.fillReportListMessage(smsContentReportListBuf, smsContent, cnLocal);
            smsContent = MessageFillAndSendUtils.fillFooterMessage(smsContent, null, cnLocal, ctx);
            MessageFillAndSendUtils.sendSMSByCompany(ctx, receivers, companyId, companyName, smsContent);
        }
    }

    private CurrencyCollection getCurrencyCollection(Context ctx, Set currencyIdSet) throws BOSException {
        EntityViewInfo currencyView = new EntityViewInfo();
        FilterInfo currencyFilter = new FilterInfo();
        currencyFilter.getFilterItems().add(new FilterItemInfo("id", (Object)currencyIdSet, CompareType.INCLUDE));
        currencyView.setFilter(currencyFilter);
        currencyView.getSelector().add("id");
        currencyView.getSelector().add("number");
        currencyView.getSelector().add("name");
        SorterItemInfo sorter = new SorterItemInfo("number");
        sorter.setSortType(SortType.ASCEND);
        currencyView.getSorter().add(sorter);
        CurrencyCollection currencyCollection = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(currencyView);
        return currencyCollection;
    }

    private Set getTemplateIdSet(Context ctx, String schemaID) throws BOSException {
        SchemaTemplateCollection schemaTemplateCollection = SchemaTemplateFactory.getLocalInstance(ctx).getSchemaTemplateCollection("select * where schemaID = '" + schemaID + "'");
        HashSet<String> templateIdSet = new HashSet<String>();
        String templateId = null;
        SchemaTemplateInfo schemaTemplateInfo = null;
        int count = schemaTemplateCollection.size();
        for (int i = 0; i < count; ++i) {
            schemaTemplateInfo = schemaTemplateCollection.get(i);
            templateId = schemaTemplateInfo.getTemplateID().toString();
            templateIdSet.add(templateId);
        }
        return templateIdSet;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        NoticeSchemaInfo info;
        int i;
        this.CheckModel(ctx, model);
        NoticeSchemaInfo schemaInfo = this.truncateDate(model);
        CtrlUnitInfo cu = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4")));
        if (cu != null) {
            schemaInfo.setCU(cu);
        }
        IObjectPK objectPK = super._addnew(ctx, (IObjectValue)schemaInfo);
        NoticeSchemaAutoPressInfo autoPress = null;
        NoticeSchemaRemindInfo remind = null;
        SchemaCurrencyCollection currencys = (SchemaCurrencyCollection)((Object)model.get("currency"));
        SchemaTemplateCollection templates = (SchemaTemplateCollection)((Object)model.get("template"));
        SchemaReceivorCollection receivors = (SchemaReceivorCollection)((Object)model.get("receivors"));
        BOSUuid schemaId = BOSUuid.read((String)objectPK.toString());
        NoticeSchemaInfo noticeSchemaInfo = (NoticeSchemaInfo)model;
        if (noticeSchemaInfo.getNoticeType().equals((Object)NoticeTypeEnum.NOTICE_REMIND)) {
            remind = (NoticeSchemaRemindInfo)model.get("remind");
            remind.setId(schemaId);
            NoticeSchemaRemindFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)remind);
        }
        if (noticeSchemaInfo.getNoticeType().equals((Object)NoticeTypeEnum.AUTO_NOTICE)) {
            autoPress = (NoticeSchemaAutoPressInfo)model.get("autoPress");
            autoPress.setId(schemaId);
            NoticeSchemaAutoPressFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)autoPress);
        }
        int count = currencys.size();
        for (i = 0; i < count; ++i) {
            SchemaCurrencyInfo schemaCurrencyInfo = currencys.get(i);
            schemaCurrencyInfo.setSchemaID(schemaId);
            SchemaCurrencyFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)schemaCurrencyInfo);
        }
        count = templates.size();
        for (i = 0; i < count; ++i) {
            SchemaTemplateInfo schemaTemplateInfo = templates.get(i);
            schemaTemplateInfo.setSchemaID(schemaId);
            SchemaTemplateFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)schemaTemplateInfo);
        }
        count = receivors.size();
        for (i = 0; i < count; ++i) {
            SchemaReceivorInfo schemaReceivorInfo = receivors.get(i);
            schemaReceivorInfo.setSchemaID(schemaId);
            SchemaReceivorFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)schemaReceivorInfo);
        }
        if (objectPK != null && (info = (NoticeSchemaInfo)this._getValue(ctx, objectPK)).getNoticeType() == NoticeTypeEnum.AUTO_NOTICE) {
            if (DebugLogger.isDebug) {
                this._checkReportCommitAndNotice(ctx, objectPK);
            }
            NoticeSchemaAutoPressInfo autoPressInfo = NoticeSchemaAutoPressFactory.getLocalInstance(ctx).getNoticeSchemaAutoPressInfo(objectPK);
            ReportCommitAutoNoticeTool tool = new ReportCommitAutoNoticeTool(info.getEfficientDate(), info.getDisabledDate(), info.getPeriodType(), autoPressInfo.isIsPeriodBefore(), autoPressInfo.isIsNoticeOnece(), autoPressInfo.getNoticeDays(), autoPressInfo.getNoticeTime(), objectPK.toString(), info.getNumber(), ctx, logger);
            tool.createJobs();
        }
        return objectPK;
    }

    private NoticeSchemaInfo truncateDate(IObjectValue model) {
        NoticeSchemaInfo info = (NoticeSchemaInfo)model;
        if (info.getEfficientDate() != null) {
            info.setEfficientDate(DateTimeUtils.truncateDate((java.util.Date)info.getEfficientDate()));
        }
        if (info.getDisabledDate() != null) {
            info.setDisabledDate(DateTimeUtils.truncateDate((java.util.Date)info.getDisabledDate()));
        }
        return info;
    }

    private void CheckModel(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        NoticeSchemaInfo info = (NoticeSchemaInfo)model;
        BOSUuid id = info.getId();
        INoticeSchema notice = NoticeSchemaFactory.getLocalInstance(ctx);
        if (notice.exists("where number = '" + info.getNumber() + "'" + (id != null ? " and id <>'" + info.getId().toString() + "'" : "") + " and noticeType = '" + info.getNoticeType().getValue() + "'")) {
            throw new EASBizException(new NumericExceptionSubItem("0001", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"255_NoticeSchemaControllerBean", (Locale)ctx.getOriginLocale())));
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        NoticeSchemaInfo info;
        int i;
        this.CheckModel(ctx, model);
        NoticeSchemaInfo schemaInfo = this.truncateDate(model);
        CtrlUnitInfo cu = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4")));
        if (cu != null) {
            schemaInfo.setCU(cu);
        }
        super._update(ctx, pk, (IObjectValue)schemaInfo);
        NoticeSchemaAutoPressInfo autoPress = null;
        NoticeSchemaRemindInfo remind = null;
        BOSUuid schemaId = BOSUuid.read((String)pk.toString());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("schemaId", (Object)pk.toString()));
        SchemaCurrencyFactory.getLocalInstance(ctx).delete(filter);
        SchemaTemplateFactory.getLocalInstance(ctx).delete(filter);
        SchemaReceivorFactory.getLocalInstance(ctx).delete(filter);
        NoticeSchemaInfo noticeSchemaInfo = (NoticeSchemaInfo)model;
        if (noticeSchemaInfo.getNoticeType().equals((Object)NoticeTypeEnum.NOTICE_REMIND)) {
            NoticeSchemaRemindFactory.getLocalInstance(ctx).delete(pk);
            remind = (NoticeSchemaRemindInfo)model.get("remind");
            remind.setId(schemaId);
            NoticeSchemaRemindFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)remind);
        }
        if (noticeSchemaInfo.getNoticeType().equals((Object)NoticeTypeEnum.AUTO_NOTICE)) {
            NoticeSchemaAutoPressFactory.getLocalInstance(ctx).delete(pk);
            autoPress = (NoticeSchemaAutoPressInfo)model.get("autoPress");
            autoPress.setId(schemaId);
            NoticeSchemaAutoPressFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)autoPress);
        }
        SchemaCurrencyCollection currencys = (SchemaCurrencyCollection)((Object)model.get("currency"));
        SchemaTemplateCollection templates = (SchemaTemplateCollection)((Object)model.get("template"));
        SchemaReceivorCollection receivors = (SchemaReceivorCollection)((Object)model.get("receivors"));
        int count = currencys.size();
        for (i = 0; i < count; ++i) {
            SchemaCurrencyInfo schemaCurrencyInfo = currencys.get(i);
            schemaCurrencyInfo.setSchemaID(schemaId);
            SchemaCurrencyFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)schemaCurrencyInfo);
        }
        count = templates.size();
        for (i = 0; i < count; ++i) {
            SchemaTemplateInfo schemaTemplateInfo = templates.get(i);
            schemaTemplateInfo.setSchemaID(schemaId);
            SchemaTemplateFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)schemaTemplateInfo);
        }
        count = receivors.size();
        for (i = 0; i < count; ++i) {
            SchemaReceivorInfo schemaReceivorInfo = receivors.get(i);
            schemaReceivorInfo.setSchemaID(schemaId);
            SchemaReceivorFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)schemaReceivorInfo);
        }
        if (pk != null && (info = (NoticeSchemaInfo)this._getValue(ctx, pk)).getNoticeType() == NoticeTypeEnum.AUTO_NOTICE) {
            if (DebugLogger.isDebug) {
                this._checkReportCommitAndNotice(ctx, pk);
            }
            NoticeSchemaAutoPressInfo autoPressInfo = NoticeSchemaAutoPressFactory.getLocalInstance(ctx).getNoticeSchemaAutoPressInfo(pk);
            ReportCommitAutoNoticeTool tool = new ReportCommitAutoNoticeTool(info.getEfficientDate(), info.getDisabledDate(), info.getPeriodType(), autoPressInfo.isIsPeriodBefore(), autoPressInfo.isIsNoticeOnece(), autoPressInfo.getNoticeDays(), autoPressInfo.getNoticeTime(), pk.toString(), info.getNumber(), ctx, logger);
            tool.updateJobs();
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        NoticeSchemaInfo info;
        if (pk != null && (info = (NoticeSchemaInfo)this._getValue(ctx, pk)).getNoticeType() == NoticeTypeEnum.AUTO_NOTICE) {
            NoticeSchemaAutoPressInfo autoPressInfo = NoticeSchemaAutoPressFactory.getLocalInstance(ctx).getNoticeSchemaAutoPressInfo(pk);
            ReportCommitAutoNoticeTool tool = new ReportCommitAutoNoticeTool(info.getEfficientDate(), info.getDisabledDate(), info.getPeriodType(), autoPressInfo.isIsPeriodBefore(), autoPressInfo.isIsNoticeOnece(), autoPressInfo.getNoticeDays(), autoPressInfo.getNoticeTime(), pk.toString(), info.getNumber(), ctx, logger);
            tool.deleteJobs();
        }
        NoticeSchemaRemindFactory.getLocalInstance(ctx).delete(pk);
        NoticeSchemaAutoPressFactory.getLocalInstance(ctx).delete(pk);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("schemaId", (Object)pk.toString()));
        SchemaCurrencyFactory.getLocalInstance(ctx).delete(filter);
        SchemaTemplateFactory.getLocalInstance(ctx).delete(filter);
        SchemaReceivorFactory.getLocalInstance(ctx).delete(filter);
        super._delete(ctx, pk);
    }

    private ParamTempTblService getTempTblService(Context ctx, Collection params) {
        TableInfo table = new TableInfo("t_csl_report_temp");
        table.addColumn(new ColumnInfo("FReportId", "varchar(80)"));
        ParamTempTblService service = ParamTempTblService.getInstance(ctx, table, params, null);
        return service;
    }

    @Override
    protected void _reportNotice(Context ctx, List reportIds, String when, String errorMsg) throws BOSException, EASBizException {
        ParamTempTblService reportService = null;
        ParamTempTblService templateService = null;
        try {
            int i;
            if (reportIds == null || reportIds.isEmpty()) {
                return;
            }
            reportService = this.getTempTblService(ctx, reportIds);
            String reportTempTableName = "";
            try {
                reportTempTableName = reportService.getTmpTableName();
            }
            catch (BOSException e) {
                logger.error((Object)"RPTDataServiceControllerBean.setItemDataStatus get tempTableName service.getTmpTableName() error");
            }
            if (reportTempTableName == null || reportTempTableName.length() == 0) {
                throw new SQLDataException("RPTDataServiceControllerBean.setItemDataStatus get tempTableName service.getTmpTableName() error table name is" + reportTempTableName);
            }
            StringBuffer rptSql = new StringBuffer();
            StringBuffer rptUnionCSLRptSql = new StringBuffer();
            rptUnionCSLRptSql.append("(select fid, fname, fcompanyid, ftemplateid, fcurrencyid, fperiodtype, fyear, fperiod, FDataCollectNumber");
            rptUnionCSLRptSql.append(" from t_rpt_report");
            rptUnionCSLRptSql.append("\n union all \n");
            rptUnionCSLRptSql.append("select fid, fname, fcompanyid, ftemplateid, fcurrencyid, fperiodtype, fyear, fperiod, FDataCollectNumber");
            rptUnionCSLRptSql.append(" from t_csl_cslreport)");
            rptSql.append("select ftemplateid, fcurrencyid, fperiodtype, fyear, fperiod from ");
            rptSql.append(rptUnionCSLRptSql);
            rptSql.append(" rpt where fid in(");
            rptSql.append("select FReportId from ").append(reportTempTableName).append(")");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)rptSql.toString());
            ArrayList<String> templateIds = new ArrayList<String>();
            ArrayList<String> currencyIds = new ArrayList<String>();
            int year = 0;
            int period = 0;
            int periodType = 0;
            try {
                boolean first = true;
                while (rs.next()) {
                    templateIds.add(rs.getString("ftemplateid"));
                    currencyIds.add(rs.getString("fcurrencyid"));
                    if (!first) continue;
                    periodType = rs.getInt("fperiodtype");
                    year = rs.getInt("fyear");
                    period = rs.getInt("fperiod");
                    first = false;
                }
            }
            catch (SQLException e1) {
                throw new BOSException((Throwable)e1);
            }
            StringBuffer sb = new StringBuffer();
            sb.append(" select case when FgroupTemplateid is null then FId else FgroupTemplateid end as FFid ").append(" from t_rpt_template where fid in(").append(CslRptUtil.AryToItemString(templateIds)).append(")");
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            templateIds.clear();
            try {
                while (rs.next()) {
                    templateIds.add(rs.getString("FFid"));
                }
            }
            catch (SQLException e1) {
                throw new BOSException((Throwable)e1);
            }
            ArrayList<Object> paramList = new ArrayList<Object>();
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("select a.fid from T_CSL_NoticeSchema a");
            sqlBuf.append(" inner join T_CSL_NoticeSchemaRemind b on a.fid = b.fid");
            sqlBuf.append(" inner join T_CSL_SchemaTemplate c on a.fid = c.FSchemaId");
            sqlBuf.append(" inner join T_CSL_SchemaCurrency d on a.fid = d.FSchemaId");
            sqlBuf.append(" where ");
            sqlBuf.append(" a.FEfficientDate <= ? and a.FDisabledDate > ?");
            Calendar startCal = Calendar.getInstance();
            startCal.add(5, 1);
            Date startDate = new Date(startCal.getTime().getTime());
            java.util.Date currentDate = DateTimeUtils.truncateDate((java.util.Date)new java.util.Date());
            Date currentSqlDate = new Date(currentDate.getTime());
            paramList.add(startDate);
            paramList.add(currentSqlDate);
            int size = templateIds.size();
            if (size > 0) {
                sqlBuf.append(" and c.FTemplateId in(?");
                paramList.add(currencyIds.get(0));
                for (i = 1; i < size; ++i) {
                    sqlBuf.append(",?");
                    paramList.add(templateIds.get(i));
                }
                sqlBuf.append(")");
            }
            if ((size = currencyIds.size()) > 0) {
                sqlBuf.append(" and d.FCurrencyId in(").append("?");
                paramList.add(currencyIds.get(0));
                size = currencyIds.size();
                for (i = 1; i < size; ++i) {
                    sqlBuf.append(",?");
                    paramList.add(currencyIds.get(i));
                }
                sqlBuf.append(")");
            }
            boolean isReportNotice = false;
            if (when.equals("reportCommit")) {
                sqlBuf.append(" and b.FIsReportCommit = ?");
                isReportNotice = true;
            } else if (when.equals("reportReceive")) {
                sqlBuf.append(" and b.FIsReportReceive = ?");
                isReportNotice = true;
            } else if (when.equals("checkAudit")) {
                sqlBuf.append(" and b.FIsCheckAudit = ?");
            } else if (when.equals("checkReceive")) {
                sqlBuf.append(" and b.FIsCheckReceive = ?");
            } else {
                throw new IllegalArgumentException("bad when argument");
            }
            paramList.add(new Integer(1));
            sqlBuf.append(" group by a.fid");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString(), (Object[])paramList.toArray());
            String schemaId = null;
            Locale locale = ctx.getLocale();
            StringBuffer reportLineBuf = null;
            HashMap<String, StringBuffer> companyMessageMap = new HashMap<String, StringBuffer>();
            String companyId = null;
            ResourceBundleHelper resHelper = new ResourceBundleHelper("com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", ctx.getOriginLocale());
            String di = resHelper.getString("di");
            String nian = resHelper.getString("nian");
            String qi = resHelper.getString("qi1");
            HashMap<String, String> dataCollectNameMap = new HashMap<String, String>();
            DataCollectCollection dataCollects = DataCollectFactory.getLocalInstance(ctx).getDataCollectCollection();
            int n = dataCollects.size();
            for (int i2 = 0; i2 < n; ++i2) {
                DataCollectInfo dc = dataCollects.get(i2);
                dataCollectNameMap.put(dc.getNumber(), dc.getName(ctx.getLocale()));
            }
            try {
                HashMap<String, String> companyNameMap = null;
                int pt = 0;
                String msgTemplate = null;
                String emailContent = null;
                String emailTitle = null;
                Map receiversMap = null;
                Set keySet = null;
                String companyKey2 = null;
                String ptName = null;
                StringBuffer msgBuf = null;
                while (rowSet.next()) {
                    schemaId = rowSet.getString(1);
                    sqlBuf = new StringBuffer();
                    sqlBuf.append("select ");
                    sqlBuf.append(this.getFieldNameByLocale("y.fname", locale)).append(" companyName");
                    sqlBuf.append(", t.fname templateName");
                    sqlBuf.append(", r.fname reportName");
                    sqlBuf.append(", r.fyear");
                    sqlBuf.append(", r.fperiod");
                    sqlBuf.append(", r.fperiodtype, ");
                    sqlBuf.append(this.getFieldNameByLocale("u.fname", locale)).append(" currencyName");
                    sqlBuf.append(", r.FDataCollectNumber");
                    sqlBuf.append(", r.fcompanyid");
                    sqlBuf.append(" from ");
                    sqlBuf.append(rptUnionCSLRptSql);
                    sqlBuf.append(" r inner join t_bd_currency u on r.fcurrencyid = u.fid");
                    sqlBuf.append(" inner join t_rpt_template t on r.ftemplateid = t.fid");
                    sqlBuf.append(" inner join t_org_company y on r.fcompanyid = y.fid");
                    sqlBuf.append(" where r.fid in(");
                    rptSql.append("select FReportId from ").append(reportTempTableName).append(")");
                    sqlBuf.append(" and exists(");
                    sqlBuf.append("select a.fid from T_CSL_NoticeSchema a");
                    sqlBuf.append(" inner join T_CSL_NoticeSchemaRemind b on a.fid = b.fid");
                    sqlBuf.append(" inner join T_CSL_SchemaTemplate c on a.fid = c.FSchemaId");
                    sqlBuf.append(" inner join T_CSL_SchemaCurrency d on a.fid = d.FSchemaId");
                    sqlBuf.append(" where ");
                    sqlBuf.append(" d.FCurrencyId = r.fcurrencyid");
                    sqlBuf.append(" and a.fid = ?)");
                    paramList.clear();
                    paramList.add(schemaId);
                    rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString(), (Object[])paramList.toArray());
                    companyNameMap = new HashMap<String, String>();
                    while (rs.next()) {
                        reportLineBuf = new StringBuffer();
                        String companyName = rs.getString("companyName");
                        reportLineBuf.append(companyName);
                        reportLineBuf.append("  ");
                        reportLineBuf.append(rs.getString("templateName"));
                        reportLineBuf.append("  ");
                        reportLineBuf.append(rs.getString("reportName"));
                        reportLineBuf.append("  ");
                        reportLineBuf.append(rs.getString("fyear"));
                        reportLineBuf.append(nian);
                        reportLineBuf.append("  ");
                        reportLineBuf.append(di);
                        reportLineBuf.append(rs.getString("fperiod"));
                        reportLineBuf.append(qi);
                        reportLineBuf.append("  ");
                        pt = rs.getInt("fperiodType");
                        ptName = RptPeriodTypeEnum.getEnum((int)pt).getAlias();
                        reportLineBuf.append(ptName);
                        reportLineBuf.append("  ");
                        reportLineBuf.append(rs.getString("currencyName"));
                        reportLineBuf.append("  ");
                        reportLineBuf.append((String)dataCollectNameMap.get(rs.getString("FDataCollectNumber")));
                        reportLineBuf.append("  ");
                        companyId = rs.getString("fcompanyid");
                        if (companyMessageMap.containsKey(companyId)) {
                            msgBuf = (StringBuffer)companyMessageMap.get(companyId);
                            msgBuf.append("\n");
                            msgBuf.append(reportLineBuf);
                        } else {
                            companyMessageMap.put(companyId, reportLineBuf);
                        }
                        companyNameMap.put(companyId, companyName);
                    }
                    if (isReportNotice) {
                        if (msgTemplate == null) {
                            msgTemplate = MessageFillAndSendUtils.getRemindEmail(ctx);
                        }
                        emailTitle = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.reportNotice", (Locale)ctx.getOriginLocale());
                    } else {
                        if (msgTemplate == null) {
                            msgTemplate = MessageFillAndSendUtils.getRelCheckEmail(ctx);
                        }
                        emailTitle = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.checkRelNotice", (Locale)ctx.getOriginLocale());
                    }
                    receiversMap = MessageFillAndSendUtils.getReceivorMap(ctx, schemaId);
                    keySet = companyMessageMap.keySet();
                    for (String companyKey2 : keySet) {
                        emailContent = MessageFillAndSendUtils.fillHeaderMessage(null, null, msgTemplate, null, String.valueOf(year), String.valueOf(period), RptPeriodTypeEnum.getEnum((int)periodType).getAlias(), null, null, when, null, ctx.getOriginLocale());
                        StringBuffer reportListBuf = (StringBuffer)companyMessageMap.get(companyKey2);
                        emailContent = MessageFillAndSendUtils.fillReportListMessage(reportListBuf, emailContent, ctx.getOriginLocale());
                        emailContent = MessageFillAndSendUtils.fillFooterMessage(emailContent, null, ctx.getOriginLocale(), ctx);
                        MessageFillAndSendUtils.sendEmailByCompany(ctx, receiversMap, companyKey2, (String)companyNameMap.get(companyKey2), emailContent, emailTitle, errorMsg);
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (reportService != null) {
                reportService.release();
            }
            if (templateService != null) {
                templateService.release();
            }
        }
    }

    private String getFieldNameByLocale(String fieldName, Locale locale) {
        return fieldName + "_" + locale.toString();
    }
}

