/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DebitOrCreditEnum;
import com.kingdee.eas.fi.gr.cslrpt.IItemFieldMapped;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.ItemFieldMappedFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTEffectItemEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemControlEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemMappingFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemMappingInfo;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassInfo;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.SumRptException;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractRPTItemControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.RptItemQuery;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.SundryException;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableJdbcTemplate;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RPTItemControllerBean
extends AbstractRPTItemControllerBean {
    private static final String sumItemPatternString = "([\\(]*)([^\\+|^\\-|^\\*|^\\/|^\\(|^\\))]{1,})([\\+|\\-|\\*|\\/|\\(|\\)]*)";
    ParamTempTblService srv = null;

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, (RPTItemInfo)model);
        this.saveToSpecSumFormula(model);
        super._addnew(ctx, pk, model);
    }

    @Override
    protected IObjectCollection _getCollectionNoChild(Context ctx, EntityViewInfo view) throws BOSException {
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            ORMappingDAO orMapping = new ORMappingDAO(this.getBOSType(), ctx, cn);
            IObjectCollection iObjectCollection = orMapping.getCollectionNoChild(view);
            return iObjectCollection;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IObjectCollection _getCollectionNoChild(Context ctx, RptItemQuery rptItemQuery) throws BOSException {
        RPTItemCollection collection = new RPTItemCollection();
        if (ctx == null) {
            return collection;
        }
        Connection conn = null;
        try {
            int selectType = rptItemQuery.getSelectType();
            boolean isQueryReportClass = rptItemQuery.isQueryReportClass();
            String language = ctx.getLocale().getLanguage();
            String sql = this.makeSql(ctx, rptItemQuery, language);
            conn = this.getConnection(ctx);
            SqlParams sp = new SqlParams();
            int from = 0;
            int length = 9000;
            RPTItemInfo itemInfo = null;
            boolean hasNext = false;
            while (from >= 0) {
                hasNext = false;
                RptRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (SqlParams)sp, (int)from, (int)length, (Connection)conn);
                while (rs.next()) {
                    hasNext = true;
                    itemInfo = new RPTItemInfo();
                    if (selectType == 0) {
                        itemInfo.put("id", rs.getString("fid"));
                    } else if (selectType == 1) {
                        itemInfo.setNumber(rs.getString("fnumber"));
                    } else {
                        itemInfo.put("id", rs.getString("fid"));
                        itemInfo.setName(rs.getString("itemName"));
                        itemInfo.setNumber(rs.getString("fnumber"));
                    }
                    if (isQueryReportClass) {
                        ReportClassInfo classInfo = new ReportClassInfo();
                        classInfo.setName(rs.getString("reportClassName"));
                        itemInfo.setReportClass(classInfo);
                    }
                    collection.add(itemInfo);
                }
                if (hasNext) {
                    from += 9000;
                    continue;
                }
                from = -1;
            }
            if (this.srv != null && !DebugLogger.isDebug) {
                this.srv.release();
                this.srv = null;
            }
        }
        catch (SQLDataException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (SQLException e2) {
                    throw new BOSException((Throwable)e2);
                }
                catch (Exception e3) {
                    throw new BOSException((Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                if (this.srv != null && !DebugLogger.isDebug) {
                    this.srv.release();
                    this.srv = null;
                }
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        return collection;
    }

    private String makeSql(Context ctx, RptItemQuery rptItemQuery, String language) throws Exception {
        String tmpTableName;
        int selectType = rptItemQuery.getSelectType();
        boolean isQueryReportClass = rptItemQuery.isQueryReportClass();
        StringBuffer sql = new StringBuffer();
        if (selectType == 0) {
            sql.append(" select item.fid fid");
        } else if (selectType == 1) {
            sql.append(" select item.fnumber fnumber");
        } else {
            sql.append(" select item.fid fid, item.fnumber fnumber, item.fname_").append(language).append(" itemName ");
        }
        if (isQueryReportClass) {
            sql.append(" , reportClass.fname_").append(language).append(" reportClassName ");
        }
        sql.append(" from T_CSL_RptItem as item ");
        if (isQueryReportClass) {
            sql.append(" LEFT OUTER JOIN T_CSL_ReportClass as reportClass ");
            sql.append(" ON item.FReportClassID=reportClass.fid\t");
        }
        StringBuffer whereSql = new StringBuffer();
        if (rptItemQuery.getIdList() != null) {
            this.srv = this.getTempTblService(ctx, rptItemQuery.getIdList());
            tmpTableName = this.srv.getTmpTableName();
            this.executeTempTable(ctx, tmpTableName);
            sql.append(" INNER JOIN ").append(tmpTableName).append(" temp ON temp.FRptItem = item.fid \n");
        }
        if (rptItemQuery.getNumberList() != null) {
            this.srv = this.getTempTblService(ctx, rptItemQuery.getNumberList());
            tmpTableName = this.srv.getTmpTableName();
            this.executeTempTable(ctx, tmpTableName);
            sql.append(" INNER JOIN ").append(tmpTableName).append(" temp ON temp.FRptItem = item.fnumber \n");
        }
        if (!rptItemQuery.isIncludeFreezed()) {
            if (whereSql.length() == 0) {
                whereSql.append(" WHERE ");
            } else {
                whereSql.append(" AND ");
            }
            whereSql.append(" ITEM.FIsFreezed = 0 ");
        }
        if (rptItemQuery.isFilterSumItemOnly()) {
            if (whereSql.length() == 0) {
                whereSql.append(" WHERE ");
            } else {
                whereSql.append(" AND ");
            }
            whereSql.append(" ITEM.FIsSumItem = 1 ");
        }
        if (rptItemQuery.getFilterReportClassID() != null) {
            if (whereSql.length() == 0) {
                whereSql.append(" WHERE ");
            } else {
                whereSql.append(" AND ");
            }
            if (rptItemQuery.getFilterReportClassID().equals("")) {
                whereSql.append(" ITEM.FReportClassID IS NULL ");
            } else {
                whereSql.append(" ITEM.FReportClassID = '").append(rptItemQuery.getFilterReportClassID()).append("'");
            }
        }
        if (rptItemQuery.getItemGroup() != null) {
            if (whereSql.length() == 0) {
                whereSql.append(" WHERE ");
            } else {
                whereSql.append(" AND ");
            }
            whereSql.append(" ITEM.FItemGroup = ").append(rptItemQuery.getItemGroup().getValue());
        }
        String gradeManageFilterSql = null;
        if (rptItemQuery.isGradeManage()) {
            gradeManageFilterSql = CslGradeManageUtil.getGradeManageFilterSql((Context)ctx, (String)"item.FTRACKRECORDCREATORID", (String)"com.kingdee.eas.fi.gr.cslrpt.client.RptItemListUI", (String)rptItemQuery.getCompanyId());
        }
        if (whereSql.length() > 0) {
            sql.append(whereSql);
            if (!StringUtils.isEmpty((String)gradeManageFilterSql)) {
                sql.append(" and ");
                sql.append(gradeManageFilterSql);
            }
        } else if (!StringUtils.isEmpty(gradeManageFilterSql)) {
            sql.append(" where ");
            sql.append(gradeManageFilterSql);
        }
        sql.append(" ORDER BY ITEM.FNUMBER ");
        return sql.toString();
    }

    private void executeTempTable(Context ctx, String tblName) throws BOSException {
        TempTableJdbcTemplate tableJdbcTemplate = new TempTableJdbcTemplate(ctx);
        StringBuffer columns = new StringBuffer();
        columns.append("FRptItem");
        tableJdbcTemplate.createIndex(tblName, columns.toString(), true, false);
        tableJdbcTemplate.analyzeTable(tblName);
    }

    private ParamTempTblService getTempTblService(Context ctx, Collection params) {
        TableInfo table = new TableInfo("t_temp_rptItem");
        table.addColumn(new ColumnInfo("FRptItem", "varchar(80)"));
        ParamTempTblService service = ParamTempTblService.getInstance(ctx, table, params, null);
        return service;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, (RPTItemInfo)model);
        this.saveToSpecSumFormula(model);
        IObjectPK pk = super._addnew(ctx, model);
        IItemFieldMapped itemFieldMap = ItemFieldMappedFactory.getLocalInstance(ctx);
        itemFieldMap.addnew(pk);
        return pk;
    }

    private void saveToSpecSumFormula(IObjectValue model) {
        RPTItemInfo info = (RPTItemInfo)model;
        if (info.getControl() != null && info.getControl().getValue() == 38) {
            if (info.isIsSumItem()) {
                info.setSpecSumFormula(info.getSumItemFormula());
                info.setSumItemFormula(null);
            } else {
                info.setSpecSumFormula(null);
            }
        }
    }

    @Override
    public void _checkIsUsed(Context ctx, String itemNumber) throws BOSException, SumRptException {
        PreparedStatement ps;
        ResultSet rs;
        Connection connection;
        StringBuffer templateNames;
        block9: {
            templateNames = new StringBuffer();
            connection = this.getConnection(ctx);
            if (connection == null) {
                throw new BOSException("Can't get connection!");
            }
            rs = null;
            ps = null;
            ps = connection.prepareStatement(this.getSQLForItemIsUsedByTMP());
            ps.setString(1, itemNumber);
            rs = ps.executeQuery();
            if (rs != null) break block9;
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
            return;
        }
        try {
            while (rs.next()) {
                templateNames = templateNames.append(rs.getString("TemplateName"));
                templateNames.append(',');
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        if (templateNames != null && templateNames.length() > 0) {
            String result = templateNames.toString();
            if (result.endsWith(",")) {
                result = result.substring(0, result.length() - 1);
            }
            Object[] params = new Object[]{result};
            throw new SumRptException(SumRptException.RPTITEMUSED, params);
        }
    }

    private String getSQLForItemIsUsedByTMP() {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append(" SELECT DISTINCT template.fnumber AS TemplateNumber , template.fname AS TemplateName , template.ftemplatetype AS TemplateType");
        strSQL.append(" FROM T_RPT_Template template,T_CSL_TempletItemList ItemList");
        strSQL.append(" WHERE itemList.FTemplateID = template.FID");
        strSQL.append("     AND itemlist.fitemNumber = ? ");
        return strSQL.toString();
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.deleteCheck(ctx, pk);
        try {
            IItemFieldMapped itemFieldMap = ItemFieldMappedFactory.getLocalInstance(ctx);
            itemFieldMap.delete(pk);
            super._delete(ctx, pk);
        }
        catch (BOSException e) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Rpt_Item_In_Use", (Locale)ctx.getOriginLocale())));
        }
    }

    protected void _deleteWithChildren(Context ctx, IObjectValue model) throws BOSException, EASBizException, TreeBaseException {
        super._deleteWithChildren(ctx, model);
    }

    @Override
    public void _freezeItem(Context ctx, IObjectPK pk, boolean isFreeze) throws EASBizException, BOSException {
        int freeze = isFreeze ? 1 : 0;
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        this.getChildIds(ctx, pk.toString(), ids);
        StringBuffer idBuffer = new StringBuffer();
        String[] idsArray = new String[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            String id = (String)ids.get(i);
            idBuffer.append("'").append(id).append("',");
            idsArray[i] = id;
        }
        String tmp = idBuffer.toString();
        tmp = tmp.substring(0, tmp.length() - 1);
        String sql = "update T_Csl_RptItem set FIsFreezed = " + freeze + " where FId in (" + tmp + ")";
        DbUtil.execute((Context)ctx, (String)sql);
        ORMValueCacheService.getInstance().removeBatch(ctx, this.getBOSType(), idsArray);
    }

    private void getChildIds(Context ctx, String id, List ids) throws BOSException {
        String sql = "select FId from t_csl_rptItem where FParent = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id});
        try {
            while (rowSet.next()) {
                String subId = rowSet.getString("FId");
                ids.add(subId);
                this.getChildIds(ctx, subId, ids);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException();
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateCheck(ctx, pk, model);
        this.saveToSpecSumFormula(model);
        super._update(ctx, pk, model);
    }

    private void updateChild(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        RPTItemInfo parentItem = (RPTItemInfo)model;
        String parentNumber = parentItem.getNumber();
        IRPTItem iRPTItem = RPTItemFactory.getLocalInstance(ctx);
        RPTItemCollection rc = iRPTItem.getRPTItemCollection("select *,parent.* where number like '" + parentNumber + ".%'");
        Iterator iter = rc.iterator();
        while (iter.hasNext()) {
            RPTItemInfo element = (RPTItemInfo)iter.next();
            element.setItemGroup(parentItem.getItemGroup());
            element.setReportClass(parentItem.getReportClass());
            element.setIsProfitAndLosses(parentItem.isIsProfitAndLosses());
            element.setEffectItem(parentItem.getEffectItem());
            element.setControl(RPTItemControlEnum.NULL_VALUE);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(element.getId()), (IObjectValue)element);
        }
    }

    protected void deleteCheck(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IRPTItem iRptItem = RPTItemFactory.getLocalInstance(ctx);
        RPTItemInfo item = iRptItem.getRPTItemInfo(pk);
        if (!item.isIsLeaf()) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptItem_CannotDelete", (Locale)ctx.getOriginLocale())));
        }
        String sumNumbers = RPTItemMappingFactory.getLocalInstance(ctx).getRefSumItems(item.getNumber());
        if (!StringUtils.isEmpty((String)sumNumbers)) {
            throw new ServerException(ServerException.RPTITEMISREFBYSUMITEM, new Object[]{sumNumbers});
        }
        this._checkIsUsed(ctx, item.getNumber());
        this.isReferenced(ctx, pk);
    }

    @Override
    protected boolean _isReferencedByOthers(Context ctx, IObjectPK pk) throws BOSException {
        try {
            IRPTItem iRptItem = RPTItemFactory.getLocalInstance(ctx);
            RPTItemInfo item = iRptItem.getRPTItemInfo(pk);
            String sumNumbers = RPTItemMappingFactory.getLocalInstance(ctx).getRefSumItems(item.getNumber());
            if (!StringUtils.isEmpty((String)sumNumbers)) {
                return true;
            }
            StringBuffer strSQL = new StringBuffer();
            strSQL.append(" SELECT top 1 template.FID ");
            strSQL.append(" FROM T_RPT_Template template,T_CSL_TempletItemList ItemList");
            strSQL.append(" WHERE itemList.FTemplateID = template.FID");
            strSQL.append("     AND itemlist.fitemNumber = ? ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])new Object[]{item.getNumber()});
            if (rowSet.next()) {
                return true;
            }
            this.isReferenced(ctx, pk);
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private void addnewCheck(Context ctx, RPTItemInfo model) throws BOSException, EASBizException {
        String number = model.getNumber();
        if (number != null && number.indexOf(42) != -1) {
            model.setNumber(number.replaceAll("\\*", ""));
        }
        String itemName = null;
        int itemNameLenth = 0;
        if (ctx.getLocale().equals(locale_L1)) {
            itemName = model.getName(locale_L1);
        } else if (ctx.getLocale().equals(locale_L2)) {
            itemName = model.getName(locale_L2);
        } else if (ctx.getLocale().equals(locale_L3)) {
            itemName = model.getName(locale_L3);
        }
        if (itemName != null && (itemNameLenth = itemName.length()) > 80) {
            throw new EASBizException(new NumericExceptionSubItem("001", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"272_RPTItemControllerBean", (Locale)ctx.getOriginLocale())));
        }
        if (model.getNumber().trim().length() > 80) {
            throw new EASBizException(new NumericExceptionSubItem("001", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"273_RPTItemControllerBean", (Locale)ctx.getOriginLocale())));
        }
        this._checkNumberBlank(ctx, (IObjectValue)model);
        this._checkNumberDup(ctx, (IObjectValue)model);
        this._checkNameBlank(ctx, (IObjectValue)model);
        model.setNumber(model.getNumber().trim());
        this.checkIsInvest(ctx, model);
    }

    private void checkIsInvest(Context ctx, RPTItemInfo model) throws EASBizException {
        if (model.getItemGroup().getValue() != 2 && model.getControl() != null && model.getControl().getValue() != 0) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptItem_NoInvest_NotHaveControl", (Locale)ctx.getOriginLocale())));
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RPTItemInfo dataBaseInfo = (RPTItemInfo)model;
        EntityViewInfo view = this.buildIsNumExistView(dataBaseInfo);
        RPTItemCollection rptItemCollection = this.getRPTItemCollection(ctx, view);
        if (rptItemCollection.size() > 0) {
            RPTItemInfo infoInDB = rptItemCollection.get(0);
            throw new SundryException(SundryException.NUMEXISTINORG, new Object[]{infoInDB.getNumber(), infoInDB.getTrackRecordCreator().getName()});
        }
    }

    private EntityViewInfo buildIsNumExistView(RPTItemInfo dataBaseInfo) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("trackRecordCreator.name"));
        coll.add(new SelectorItemInfo("number"));
        view.setFilter(filter);
        view.setSelector(coll);
        return view;
    }

    private void updateCheck(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        String number = ((RPTItemInfo)model).getNumber();
        if (number != null && number.indexOf(42) != -1) {
            ((RPTItemInfo)model).setNumber(number.replaceAll("\\*", ""));
        }
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this.checkIsInvest(ctx, (RPTItemInfo)model);
        IRPTItem iRPTItem = RPTItemFactory.getLocalInstance(ctx);
        RPTItemInfo oldItem = iRPTItem.getRPTItemInfo(pk);
        String oldNumber = oldItem.getNumber();
        RPTItemInfo newItem = (RPTItemInfo)model;
        String newNumber = newItem.getNumber();
        if (!oldNumber.equals(newNumber)) {
            String sql;
            this._checkIsUsed(ctx, oldItem.getNumber());
            this._isReferenced(ctx, pk);
            RPTItemInfo parent = oldItem.getParent();
            if (parent != null) {
                sql = "update T_CSL_RptItem set FIsLeaf = 1 where fid = '" + parent.getId().toString() + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            }
            if ((parent = newItem.getParent()) != null) {
                sql = "update T_CSL_RptItem set FIsLeaf = 0 where fid = '" + parent.getId().toString() + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            }
        }
        this.updateChild(ctx, pk, model);
    }

    @Override
    protected Map _checkIsUptSumItem(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        HashMap<String, Object> extraInfomation = new HashMap<String, Object>();
        IRPTItem iRPTItem = RPTItemFactory.getLocalInstance(ctx);
        RPTItemInfo oldItem = iRPTItem.getRPTItemInfo(pk);
        String oldNumber = oldItem.getNumber();
        RPTItemInfo newItem = (RPTItemInfo)model;
        try {
            IRowSet rs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)this.getSQLForItemIsUsedByTMP(), (Object[])new Object[]{oldNumber});
            boolean isUptSumItem = false;
            if (rs != null && rs.next()) {
                if (oldItem.isIsSumItem() != newItem.isIsSumItem()) {
                    isUptSumItem = true;
                } else if (oldItem.isIsSumItem() == newItem.isIsSumItem() && oldItem.isIsSumItem()) {
                    String oldFString = oldItem.getSumItemFormula();
                    String newFString = newItem.getSumItemFormula();
                    oldFString = oldFString != null && oldFString.length() == 0 ? null : oldFString;
                    String string = newFString = newFString != null && newFString.length() == 0 ? null : newFString;
                    if (oldItem.getSumItemFormula() != null && newItem.getSumItemFormula() == null || oldItem.getSumItemFormula() == null && newItem.getSumItemFormula() != null || oldItem.getSumItemFormula() != null && newItem.getSumItemFormula() != null && oldFString != null && !oldFString.equalsIgnoreCase(newFString)) {
                        isUptSumItem = true;
                    }
                }
                if (isUptSumItem) {
                    StringBuffer relatedTemplates = new StringBuffer();
                    rs.beforeFirst();
                    while (rs.next()) {
                        relatedTemplates.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ItemRelatedTemplate_Number", (Locale)ctx.getOriginLocale())).append(": ").append(rs.getString("TemplateNumber")).append("\r\n").append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ItemRelatedTemplate_Name", (Locale)ctx.getOriginLocale())).append(": ").append(rs.getString("TemplateName")).append("\r\n").append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ItemRelatedTemplate_TemplateType", (Locale)ctx.getOriginLocale())).append(": ").append(RptTmpTypeEnum.getEnum((int)Integer.parseInt(rs.getString("TemplateType")))).append("\r\n").append("-----------------------------------------------------------------------\r\n");
                    }
                    if (relatedTemplates.length() != 0) {
                        relatedTemplates.insert(0, "-----------------------------------------------------------------------\r\n");
                        String str = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ItemRelatedTemplate_TemplateReferred", (Locale)ctx.getOriginLocale());
                        if (str != null && str.length() > 0) {
                            str = str.replaceAll("\\\\r", "\r").replaceAll("\\\\n", "\n");
                        }
                        relatedTemplates.insert(0, str + "\r\n\r\n");
                    }
                    extraInfomation.put("relatedTemplates", relatedTemplates.toString());
                }
            }
            extraInfomation.put("isUptSumItem", new Boolean(isUptSumItem));
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return extraInfomation;
    }

    @Override
    protected void _initItem(Context ctx, String varCreatorID, Date varCreateTime) throws BOSException, EASBizException {
        IRPTItem iRPTItem = RPTItemFactory.getLocalInstance(ctx);
        RPTItemCollection rc = iRPTItem.getRPTItemCollection("select id, isSumItem, sumItemFormula where creator = '" + varCreatorID + "' and createTime = " + this.formatDate(varCreateTime));
        RPTItemCollection sumItemCol = new RPTItemCollection();
        IItemFieldMapped itemFieldMap = ItemFieldMappedFactory.getLocalInstance(ctx);
        Iterator iter = rc.iterator();
        while (iter.hasNext()) {
            RPTItemInfo item = (RPTItemInfo)iter.next();
            itemFieldMap.addnew((IObjectPK)new ObjectUuidPK(item.getId()));
            if (!item.isIsSumItem()) continue;
            sumItemCol.add(item);
        }
        this.save_SumItemMapping(ctx, sumItemCol);
    }

    @Override
    protected RPTItemCollection _getItemListBySumItemFormula(Context ctx, String sumItemFormula) throws BOSException, EASBizException {
        Pattern pt = Pattern.compile(sumItemPatternString);
        return this.get_ItemListBySumItemFormula(ctx, sumItemFormula, pt);
    }

    private void save_SumItemMapping(Context ctx, RPTItemCollection sumItems) throws EASBizException, BOSException {
        if (sumItems == null || sumItems.size() == 0) {
            return;
        }
        this.clearSumItemMapping(ctx, sumItems);
        RPTItemInfo sumItem = null;
        IRPTItem ie = RPTItemFactory.getLocalInstance(ctx);
        Pattern pt = Pattern.compile(sumItemPatternString);
        int count = sumItems.size();
        for (int i = 0; i < count; ++i) {
            sumItem = sumItems.get(i);
            this.putSumItemMappingRef(sumItem, this.get_ItemListBySumItemFormula(ctx, sumItem.getSumItemFormula(), pt));
            ie.save((CoreBaseInfo)sumItem);
        }
    }

    private void clearSumItemMapping(Context ctx, RPTItemCollection sumItems) throws BOSException {
        StringBuffer idString = new StringBuffer();
        int count = sumItems.size();
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                idString.append(",");
            }
            idString.append("'").append(sumItems.get(i).getId().toString()).append("'");
        }
        if (idString.length() != 0) {
            DbUtil.execute((Context)ctx, (String)("Delete From T_CSL_RptItemMapping Where FTargetItem In (" + idString.toString() + ")"));
        }
    }

    private RPTItemCollection get_ItemListBySumItemFormula(Context ctx, String sumItemFormula, Pattern pt) throws BOSException, ServerException {
        if (sumItemFormula == null || sumItemFormula.length() == 0) {
            return null;
        }
        Matcher matcher = pt.matcher(sumItemFormula);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        ArrayList<String> sumItemNumber = new ArrayList<String>();
        String itemNumber = null;
        StringBuffer maskString = new StringBuffer("(");
        int count = 0;
        while (matcher.find()) {
            itemNumber = matcher.group(2);
            if (sumItemNumber.contains(itemNumber)) {
                throw new ServerException(ServerException.FORMULARPTITEMREPEAT, new Object[]{itemNumber});
            }
            sumItemNumber.add(itemNumber);
            if (itemNumber == null || itemNumber.trim().length() == 0) continue;
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)itemNumber.trim(), CompareType.EQUALS));
            if (count != 0) {
                maskString.append(" OR ");
            }
            maskString.append("#").append(count);
            ++count;
        }
        maskString.append(")");
        filter.setMaskString(maskString.toString());
        view.setFilter(filter);
        IRPTItem ie = RPTItemFactory.getLocalInstance(ctx);
        RPTItemCollection subItems = ie.getRPTItemCollection(view);
        if (subItems == null || subItems.isEmpty()) {
            throw new ServerException(ServerException.SUMITEMFORMULAERROR, new Object[]{((Object)sumItemNumber).toString()});
        }
        if (sumItemNumber.size() != subItems.size()) {
            for (int i = 0; i < subItems.size(); ++i) {
                sumItemNumber.remove(subItems.get(i).getNumber());
            }
            if (!sumItemNumber.isEmpty()) {
                throw new ServerException(ServerException.SUMITEMFORMULAERROR, new Object[]{((Object)sumItemNumber).toString()});
            }
        }
        sumItemNumber.clear();
        sumItemNumber = null;
        return subItems;
    }

    private void putSumItemMappingRef(RPTItemInfo sumItem, RPTItemCollection subItems) {
        if (subItems != null && subItems.size() != 0) {
            RPTItemMappingInfo itemMapping = null;
            if (sumItem.getSumItems() != null) {
                sumItem.getSumItems().clear();
            }
            int count = subItems.size();
            for (int i = 0; i < count; ++i) {
                itemMapping = new RPTItemMappingInfo();
                itemMapping.setTargetItem(sumItem);
                itemMapping.setSourceItem(subItems.get(i));
                sumItem.getSumItems().add(itemMapping);
            }
        }
    }

    private String formatDate(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        StringBuffer sb = new StringBuffer();
        sb.append("{ts'");
        sb.append(cal.get(1)).append("-").append(cal.get(2) + 1).append("-").append(cal.get(5));
        sb.append("'}");
        return sb.toString();
    }

    @Override
    protected void _unFreezeItem(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        RPTItemInfo info = (RPTItemInfo)this.getValue(ctx, id);
        info.setIsFreezed(false);
        this.update(ctx, id, (CoreBaseInfo)info);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void _importDataFromXsl(Context ctx, boolean isOverride, IObjectValue model) throws BOSException, EASBizException {
        iRptItem = RPTItemFactory.getLocalInstance(ctx);
        rptItemInfo = (RPTItemInfo)model;
        sql = new StringBuffer();
        sql.append("select r.fid,r.FTrackRecordCreatorID,c.fname_" + ctx.getLocale() + " from t_csl_rptitem r inner join T_ORG_Company c on r.FTrackRecordCreatorID = c.fid where r.fnumber = ?");
        params = new Object[]{rptItemInfo.getNumber()};
        if (rptItemInfo.getBoolean("isProfitAndLosses") && rptItemInfo.getEffectItem() == RPTEffectItemEnum.UNSET) {
            rptItemInfo.setEffectItem(RPTEffectItemEnum.UNSHARED_PROFIT);
        }
        if (!rptItemInfo.getBoolean("isProfitAndLosses") && rptItemInfo.getEffectItem() != RPTEffectItemEnum.UNSET) {
            rptItemInfo.setEffectItem(RPTEffectItemEnum.UNSET);
        }
        if (isOverride) {
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
                if (rs.next()) {
                    this.doDataRepeatInCreateOrg(ctx, rptItemInfo.getNumber(), rs);
                    rptItemInfo.setId(BOSUuid.read((String)rs.getString(1)));
                }
                obj = new Object[]{new Object()};
                switch (rptItemInfo.getControl().getValue()) {
                    case 20: {
                        obj[0] = new Integer(20);
                        break;
                    }
                    case 3: {
                        obj[0] = new Integer(3);
                        break;
                    }
                    case 21: {
                        obj[0] = new Integer(21);
                        break;
                    }
                    case 35: {
                        obj[0] = new Integer(35);
                        break;
                    }
                    case 29: {
                        obj[0] = new Integer(29);
                        break;
                    }
                    case 30: {
                        obj[0] = new Integer(30);
                        break;
                    }
                    case 31: {
                        obj[0] = new Integer(31);
                        break;
                    }
                    case 8: {
                        obj[0] = new Integer(8);
                        break;
                    }
                    case 7: {
                        obj[0] = new Integer(7);
                        break;
                    }
                    case 10: {
                        obj[0] = new Integer(10);
                        break;
                    }
                    case 27: {
                        obj[0] = new Integer(27);
                        break;
                    }
                    case 5: {
                        obj[0] = new Integer(5);
                        break;
                    }
                    case 2: {
                        obj[0] = new Integer(2);
                        break;
                    }
                    case 1: {
                        obj[0] = new Integer(1);
                        break;
                    }
                    case 6: {
                        obj[0] = new Integer(6);
                        break;
                    }
                    case 9: {
                        obj[0] = new Integer(9);
                        break;
                    }
                    case 13: {
                        obj[0] = new Integer(13);
                        break;
                    }
                    case 14: {
                        obj[0] = new Integer(14);
                    }
                }
                sql1 = "select fid from t_csl_rptItem where FControl = ?";
                if (obj == null || !(obj[0] instanceof Integer) || obj.length <= 0 || !(rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])obj)).next()) ** GOTO lbl136
                rptItemInfo.setId(BOSUuid.read((String)rs1.getString(1)));
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        } else {
            obj = new Object[]{new Object()};
            switch (rptItemInfo.getControl().getValue()) {
                case 20: {
                    obj[0] = new Integer(20);
                    break;
                }
                case 3: {
                    obj[0] = new Integer(3);
                    break;
                }
                case 21: {
                    obj[0] = new Integer(21);
                    break;
                }
                case 35: {
                    obj[0] = new Integer(35);
                    break;
                }
                case 29: {
                    obj[0] = new Integer(29);
                    break;
                }
                case 30: {
                    obj[0] = new Integer(30);
                    break;
                }
                case 31: {
                    obj[0] = new Integer(31);
                    break;
                }
                case 8: {
                    obj[0] = new Integer(8);
                    break;
                }
                case 7: {
                    obj[0] = new Integer(7);
                    break;
                }
                case 10: {
                    obj[0] = new Integer(10);
                    break;
                }
                case 27: {
                    obj[0] = new Integer(27);
                    break;
                }
                case 5: {
                    obj[0] = new Integer(5);
                    break;
                }
                case 2: {
                    obj[0] = new Integer(2);
                    break;
                }
                case 1: {
                    obj[0] = new Integer(1);
                    break;
                }
                case 6: {
                    obj[0] = new Integer(6);
                    break;
                }
                case 9: {
                    obj[0] = new Integer(9);
                    break;
                }
                case 13: {
                    obj[0] = new Integer(13);
                    break;
                }
                case 14: {
                    obj[0] = new Integer(14);
                }
            }
            if (obj.length > 0 && obj[0] != null && obj[0] instanceof Integer && (rs = DbUtil.executeQuery((Context)ctx, (String)(sql1 = "select fid from t_csl_rptItem where FControl = ?"), (Object[])obj)).size() != 0) {
                throw new AdjustException(AdjustException.CONTROL_ISDUP, new Object[]{RPTItemControlEnum.getEnum((Integer)obj[0]).getAlias()});
            }
        }
lbl136:
        // 5 sources

        if (!StringUtil.isEmptyString((String)rptItemInfo.getSumItemFormula())) {
            sumItems = iRptItem.getItemListBySumItemFormula(rptItemInfo.getSumItemFormula());
            for (i = 0; i < sumItems.size(); ++i) {
                itemMapping = new RPTItemMappingInfo();
                if (sumItems.get(i).getNumber().equals(rptItemInfo.getNumber())) {
                    throw new BOSException(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"sumItemCycleRef"));
                }
                itemMapping.setTargetItem(rptItemInfo);
                itemMapping.setSourceItem(sumItems.get(i));
                rptItemInfo.getSumItems().add(itemMapping);
            }
        }
        this.addCreateOrg(rptItemInfo, ctx);
        iRptItem.submit((CoreBaseInfo)rptItemInfo);
    }

    private void doDataRepeatInCreateOrg(Context ctx, String num, IRowSet rs) throws SQLException, SundryException {
        if (!rs.getString(2).equals(ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString())) {
            throw new SundryException(SundryException.NUMEXISTINORG, new Object[]{num, rs.getString(3)});
        }
    }

    private void addCreateOrg(RPTItemInfo rptItemInfo, Context ctx) {
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(ContextUtil.getCurrentFIUnit((Context)ctx).getId());
        rptItemInfo.setTrackRecordCreator(companyOrgUnitInfo);
    }

    @Override
    protected boolean _isBalanceSheet(Context ctx, String reportClassId) throws BOSException, EASBizException {
        String sql = "select FName_" + ctx.getLocale().getLanguage() + " from T_CSL_ReportClass where FID=?";
        Object[] params = new Object[]{reportClassId};
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        try {
            if (rows.next()) {
                String name = rows.getString(1);
                return ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"BALANCE_SHEET", (Locale)ctx.getOriginLocale()).equals(name);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return false;
    }

    @Override
    protected IObjectValue _getReportClassDataElement(Context ctx, String id) throws BOSException, EASBizException {
        String sql = "select t2.fDataElement From t_csl_RptItem t1 join t_csl_ReportClass t2 on t1.FReportClassID = t2.FId where t1.FId = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id});
        String dataElementId = null;
        try {
            if (rs.next()) {
                dataElementId = rs.getString("fDataElement");
            }
        }
        catch (SQLException ex) {
            throw new SQLDataException(ex);
        }
        if (dataElementId != null) {
            return DataElementFactory.getLocalInstance(ctx).getDataElementInfo("select * where id ='" + dataElementId + "'");
        }
        return null;
    }

    @Override
    protected Map _getRPTItemInfoList(Context ctx, List rptItemNumberList) throws BOSException {
        HashMap<String, RPTItemInfo> RPTItemInfoMap = new HashMap<String, RPTItemInfo>();
        if (rptItemNumberList != null && rptItemNumberList.size() > 0) {
            StringBuffer sqlBuffer = new StringBuffer("SELECT FNUMBER,FISSUMITEM,FDC FROM T_CSL_RPTITEM WHERE FNUMBER IN");
            sqlBuffer.append(RptUtilForServer.createInStringSql(rptItemNumberList.iterator(), (Context)ctx));
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            try {
                while (iRowSet.next()) {
                    RPTItemInfo rptitem = new RPTItemInfo();
                    rptitem.setIsSumItem(iRowSet.getBoolean("FISSUMITEM"));
                    rptitem.setDc(DebitOrCreditEnum.getEnum(iRowSet.getInt("FDC")));
                    RPTItemInfoMap.put(iRowSet.getString("FNUMBER"), rptitem);
                }
            }
            catch (SQLException sqlex) {
                throw new BOSException((Throwable)sqlex);
            }
        }
        return RPTItemInfoMap;
    }
}

