/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.IReportClass;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassFactory;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReportClassImportControllerbean
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.ReportClassImportControllerbean");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ReportClassFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public IReportClass getBizInterface(Context ctx) {
        IReportClass rpt = null;
        try {
            rpt = ReportClassFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)"IReportClass_getBizInterface_BOSException", (Throwable)e);
        }
        return rpt;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            IReportClass iRpClass = ReportClassFactory.getLocalInstance(ctx);
            ReportClassInfo rptInfo = (ReportClassInfo)coreBaseInfo;
            iRpClass.importDataFromXsl(this.isSltImportUpdate(), rptInfo);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    private String fecthData(Hashtable htData, String key) {
        DataToken dataToken = (DataToken)htData.get(key);
        if (dataToken != null) {
            return dataToken.toString();
        }
        return null;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        ReportClassInfo info = new ReportClassInfo();
        info.setName(this.fecthData(hsData, "FName_L1"), new Locale("L1"));
        info.setName(this.fecthData(hsData, "FName_L2"), new Locale("L2"));
        info.setName(this.fecthData(hsData, "FName_L3"), new Locale("L3"));
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString()));
        info.setTrackRecordCreator(companyOrgUnitInfo);
        String number = this.fecthData(hsData, "FNumber");
        if (number != null && number.length() > 80) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"89_numberIsTooLong", (Locale)ctx.getOriginLocale()));
        }
        info.setNumber(number);
        info.setDescription(this.fecthData(hsData, "FDescription_L1"), new Locale("L1"));
        info.setDescription(this.fecthData(hsData, "FDescription_L2"), new Locale("L2"));
        info.setDescription(this.fecthData(hsData, "FDescription_L3"), new Locale("L3"));
        String dataElementNumber = this.fecthData(hsData, "FDataElement_number");
        DataElementInfo dataElement = DataElementProvider.getDataElementInfo(ctx, dataElementNumber);
        if (null != dataElement && dataElement.isIsUsedElim()) {
            info.setDataElement(dataElement);
        } else {
            info.setDataElement(DataElementProvider.getDataElementInfo(ctx, "ENDBALANCE"));
        }
        if (info.getNumber().trim().startsWith("=")) {
            throw new TaskExternalException(info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"88_notequalsStart", (Locale)ctx.getLocale()));
        }
        if (info.getName().trim().startsWith("=")) {
            throw new TaskExternalException(info.getName() + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"88_notequalsStart", (Locale)ctx.getLocale()));
        }
        if (info.getDescription() != null && info.getDescription().trim().startsWith("=")) {
            throw new TaskExternalException(info.getDescription() + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"88_notequalsStart", (Locale)ctx.getLocale()));
        }
        return info;
    }

    private Map initMultiLanguage(Context ctx) {
        HashMap<String, ReportClassInfo> multiLanguage = new HashMap<String, ReportClassInfo>();
        StringBuffer querySql = new StringBuffer("select");
        querySql.append(" fnumber,fname_l1,fname_l2,fname_l3");
        querySql.append(",fdescription_l1,fdescription_l2,fdescription_l3");
        querySql.append(" from T_CSL_ReportClass");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            while (rowSet.next()) {
                ReportClassInfo rptItem = new ReportClassInfo();
                rptItem.setNumber(rowSet.getString(1));
                rptItem.setName(rowSet.getString(2), new Locale("L1"));
                rptItem.setName(rowSet.getString(3), new Locale("L2"));
                rptItem.setName(rowSet.getString(4), new Locale("L3"));
                rptItem.setDescription(rowSet.getString(5), new Locale("L1"));
                rptItem.setDescription(rowSet.getString(6), new Locale("L2"));
                rptItem.setDescription(rowSet.getString(7), new Locale("L3"));
                multiLanguage.put(rowSet.getString(1), rptItem);
            }
        }
        catch (BOSException bOSException) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return multiLanguage;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Map multiLanguage = this.initMultiLanguage(ctx);
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            String number = rs.getString("ReportClass.number");
            ReportClassInfo rptItem = (ReportClassInfo)multiLanguage.remove(number);
            result.put("FNumber", number);
            if (rs.getString("ReportClass.name") != null) {
                result.put("FName_L1", rptItem.getName(new Locale("L1")) == null ? "" : rptItem.getName(new Locale("L1")));
                result.put("FName_L2", rptItem.getName(new Locale("L2")) == null ? "" : rptItem.getName(new Locale("L2")));
                result.put("FName_L3", rptItem.getName(new Locale("L3")) == null ? "" : rptItem.getName(new Locale("L3")));
            } else {
                result.put("FName_L1", "");
                result.put("FName_L2", "");
                result.put("FName_L3", "");
            }
            if (rs.getString("ReportClass.description") != null) {
                result.put("FDescription_L1", rptItem.getDescription(new Locale("L1")) == null ? "" : rptItem.getDescription(new Locale("L1")));
                result.put("FDescription_L2", rptItem.getDescription(new Locale("L2")) == null ? "" : rptItem.getDescription(new Locale("L2")));
                result.put("FDescription_L3", rptItem.getDescription(new Locale("L3")) == null ? "" : rptItem.getDescription(new Locale("L3")));
            } else {
                result.put("FDescription_L1", "");
                result.put("FDescription_L2", "");
                result.put("FDescription_L3", "");
            }
            if (rs.getString("dataElement.number") != null) {
                result.put("FDataElement_number", rs.getString("dataElement.number"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"exportTransmit_SQLException", (Throwable)e);
        }
        result.keySet();
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.gr.cslrpt.RPTItemTypeQuery";
    }
}

