/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ReportCommitAutoNoticeTool {
    public static final String REPORT_DATE = "reportDate";
    public static final String PERIOD = "period";
    public static final String YEAR = "year";
    private static final String SPACE = " ";
    private static final String TIME_SEPARATOR = ":";
    private Date efficientDate = null;
    private Date disableDate = null;
    private RptPeriodTypeEnum periodType = RptPeriodTypeEnum.MONTHLY;
    private boolean isPeriodBefore = true;
    private boolean isNoticeOnece = true;
    private int noticeDays = 3;
    private String noticeTime = "12:00:00";
    private String schemaId = null;
    private String schemaNumber = null;
    private Context ctx = null;
    Logger logger = null;
    public static final String KEY_CSLPARAM_SHOW_REPORT_AUTO_NOTICE_DEBUG_INFO = "KEY_CSLPARAM_SHOW_REPORT_AUTO_NOTICE_DEBUG_INFO";
    private List noticeDateList;
    public static final int MID_MONTH_OF_YEAR = 5;
    public static final int LAST_DAY_OF_MID_MONTH = 30;
    public static final int LAST_MONTH_OF_YEAR = 11;
    public static final int LAST_DAY_OF_YEAR = 31;
    public static final int LAST_MONTH_OF_FIST_QUARTER = 2;
    public static final int LAST_DAY_OF_FIRST_QUARTER = 31;
    public static final int LAST_MONTH_OF_SECOND_QUARTER = 5;
    public static final int LAST_DAY_OF_SECOND_QUARTER = 30;
    public static final int LAST_MONTH_OF_THIRD_QUARTER = 8;
    public static final int LAST_DAY_OF_THIRD_QUARTER_ = 30;
    public static final int NUMBER_OF_WEEK_OF_YEAR = 52;

    public static boolean isShowAutoNoticeDebugInfo(Context ctx) throws BOSException {
        boolean result = false;
        try {
            String sql = "select fvalue from t_csl_cslparam\twhere fkey = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{KEY_CSLPARAM_SHOW_REPORT_AUTO_NOTICE_DEBUG_INFO});
            if (rs.next()) {
                String value = rs.getString(1);
                result = value != null && value.equalsIgnoreCase("true");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public ReportCommitAutoNoticeTool(Date efficientDate, Date disableDate, RptPeriodTypeEnum periodType, boolean isPeriodBefore, boolean isNoticeOnece, int noticeDays, String noticeTime, String schemaId, String schemaNumber, Context ctx, Logger logger) {
        this.efficientDate = DateTimeUtils.truncateDate((Date)efficientDate);
        this.disableDate = DateTimeUtils.truncateDate((Date)disableDate);
        this.periodType = periodType;
        this.isPeriodBefore = isPeriodBefore;
        this.isNoticeOnece = isNoticeOnece;
        this.noticeDays = noticeDays;
        this.noticeTime = noticeTime;
        this.schemaId = schemaId;
        this.schemaNumber = schemaNumber;
        this.noticeDateList = new ArrayList();
        this.ctx = ctx;
        this.logger = logger;
    }

    public Date getEfficientDate() {
        return this.efficientDate;
    }

    public void setEfficientDate(Date efficientDate) {
        this.efficientDate = efficientDate;
    }

    public Date getDisableDate() {
        return this.disableDate;
    }

    public void setDisableDate(Date disableDate) {
        this.disableDate = disableDate;
    }

    public RptPeriodTypeEnum getPeriodType() {
        return this.periodType;
    }

    public void setPeriodType(RptPeriodTypeEnum periodType) {
        this.periodType = periodType;
    }

    public boolean isPeriodBefore() {
        return this.isPeriodBefore;
    }

    public void setPeriodBefore(boolean isPeriodBefore) {
        this.isPeriodBefore = isPeriodBefore;
    }

    public boolean isNoticeOnece() {
        return this.isNoticeOnece;
    }

    public void setNoticeOnece(boolean isNoticeOnece) {
        this.isNoticeOnece = isNoticeOnece;
    }

    public int getNoticeDays() {
        return this.noticeDays;
    }

    public void setNoticeDays(int noticeDays) {
        this.noticeDays = noticeDays;
    }

    public String getNoticeTime() {
        return this.noticeTime;
    }

    public void setNoticeTime(String noticeTime) {
        this.noticeTime = noticeTime;
    }

    public String getSchemaId() {
        return this.schemaId;
    }

    public void setSchemaId(String schemaId) {
        this.schemaId = schemaId;
    }

    public String getSchemaNumber() {
        return this.schemaNumber;
    }

    public void setSchemaNumber(String schemaNumber) {
        this.schemaNumber = schemaNumber;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public List getNoticeDateList() {
        return this.noticeDateList;
    }

    public void setNoticeDateList(List noticeDateList) {
        this.noticeDateList = noticeDateList;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public List calNoticeDates() {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(this.getEfficientDate());
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(this.getDisableDate());
        int startYear = startCalendar.get(1);
        int endYear = endCalendar.get(1);
        Calendar noticeDateCalendar = Calendar.getInstance();
        switch (this.getPeriodType().getValue()) {
            case 6: {
                for (int i = startYear; i < endYear + 1; ++i) {
                    noticeDateCalendar.set(i, 11, 31);
                    this.calAndAddNoticeDate(noticeDateCalendar);
                }
                break;
            }
            case 5: {
                for (int i = startYear; i < endYear + 1; ++i) {
                    noticeDateCalendar.set(i, 5, 30);
                    this.calAndAddNoticeDate(noticeDateCalendar);
                    noticeDateCalendar.set(i, 11, 31);
                    this.calAndAddNoticeDate(noticeDateCalendar);
                }
                break;
            }
            case 4: {
                for (int i = startYear; i < endYear + 1; ++i) {
                    noticeDateCalendar.set(i, 2, 31);
                    this.calAndAddNoticeDate(noticeDateCalendar);
                    noticeDateCalendar.set(i, 5, 30);
                    this.calAndAddNoticeDate(noticeDateCalendar);
                    noticeDateCalendar.set(i, 8, 30);
                    this.calAndAddNoticeDate(noticeDateCalendar);
                    noticeDateCalendar.set(i, 11, 31);
                    this.calAndAddNoticeDate(noticeDateCalendar);
                }
                break;
            }
            case 3: {
                int lastDay = 0;
                for (int i = startYear; i < endYear + 1; ++i) {
                    for (int j = 0; j <= 11; ++j) {
                        noticeDateCalendar.set(i, j, 1);
                        lastDay = noticeDateCalendar.getActualMaximum(5);
                        noticeDateCalendar.set(5, lastDay);
                        this.calAndAddNoticeDate(noticeDateCalendar);
                    }
                }
                break;
            }
            case 2: {
                int lastDay = 0;
                for (int i = startYear; i < endYear + 1; ++i) {
                    for (int j = 0; j < 52; ++j) {
                        noticeDateCalendar.set(1, i);
                        noticeDateCalendar.set(3, j);
                        lastDay = noticeDateCalendar.getActualMaximum(7);
                        noticeDateCalendar.set(7, lastDay);
                        this.calAndAddNoticeDate(noticeDateCalendar);
                    }
                }
                break;
            }
            case 1: {
                int maxDayOfMonth = 0;
                for (int i = startYear; i < endYear + 1; ++i) {
                    for (int j = 0; j <= 11; ++j) {
                        noticeDateCalendar.set(i, j, 1);
                        maxDayOfMonth = noticeDateCalendar.getActualMaximum(5);
                        for (int k = 1; k < maxDayOfMonth + 1; ++k) {
                            noticeDateCalendar.set(5, k);
                            this.calAndAddNoticeDate(noticeDateCalendar);
                        }
                    }
                }
                break;
            }
        }
        return this.noticeDateList;
    }

    private void calAndAddNoticeDate(Calendar noticeDateCalendar) {
        int noticeDays = this.getNoticeDays();
        if (this.isPeriodBefore()) {
            noticeDays *= -1;
        }
        noticeDateCalendar.add(5, noticeDays + 1);
        this.addDateToList(noticeDateCalendar);
    }

    private void handleEveryDayNotice(Calendar noticeDateCalendar) {
        int noticeDays = this.getNoticeDays();
        if (this.isPeriodBefore()) {
            noticeDateCalendar.add(5, noticeDays * -1);
        }
        this.addDateToList(noticeDateCalendar);
        for (int i = 0; i < noticeDays; ++i) {
            noticeDateCalendar.add(5, 1);
            this.addDateToList(noticeDateCalendar);
        }
    }

    private void addDateToList(Calendar noticeDateCalendar) {
        Date noticeDate = noticeDateCalendar.getTime();
        if (this.isInValidRange(noticeDate)) {
            this.noticeDateList.add(noticeDate);
        }
    }

    private boolean isInValidRange(Date noticeDate) {
        Date truncateDate = DateTimeUtils.truncateDate((Date)noticeDate);
        Date today = DateTimeUtils.truncateDate((Date)Calendar.getInstance().getTime());
        return truncateDate.compareTo(this.getEfficientDate()) >= 0 && truncateDate.compareTo(this.getDisableDate()) < 0 && truncateDate.compareTo(today) >= 0;
    }

    public void createJobs() throws BOSException, WfException {
        List noticeDates = this.calNoticeDates();
        HashSet<Date> dateSet = new HashSet<Date>();
        for (Date date : noticeDates) {
            dateSet.add(date);
        }
        for (Date noticeDate : dateSet) {
            this.createJob(noticeDate);
        }
    }

    public void createJob(Date noticeDate) throws WfException, BOSException {
        StringBuffer jobName = new StringBuffer();
        jobName.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"258_ReportCommitAutoNoticeTool", (Locale)this.ctx.getOriginLocale()));
        jobName.append(this.getSchemaNumber());
        jobName.append("|ID:");
        jobName.append(this.schemaId);
        if (this.isPeriodBefore) {
            jobName.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"791_ReportCommitAutoNoticeTool", (Locale)this.ctx.getOriginLocale()));
        } else {
            jobName.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"792_ReportCommitAutoNoticeTool", (Locale)this.ctx.getOriginLocale()));
        }
        jobName.append(this.noticeDays);
        jobName.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"259_ReportCommitAutoNoticeTool", (Locale)this.ctx.getOriginLocale()));
        if (this.isNoticeOnece) {
            jobName.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"260_ReportCommitAutoNoticeTool", (Locale)this.ctx.getOriginLocale()));
        } else {
            jobName.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"261_ReportCommitAutoNoticeTool", (Locale)this.ctx.getOriginLocale()));
        }
        SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd");
        String fmtDate = format1.format(noticeDate);
        DateFormat format = CslRptUtil.getNationalDateFormat(this.ctx);
        if (format != null) {
            fmtDate = format.format(noticeDate);
        }
        jobName.append("|").append(fmtDate);
        String functionMetaPath = "com.kingdee.eas.fi.gr.cslrpt.app.ReportCommitAutoNoticeFunction";
        FunctionObjectInfo funciton = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getFunction((IMetaDataPK)new MetaDataPK(functionMetaPath));
        OperationInfo operation = funciton.getOperation().get(0);
        HashMap<String, ObjectStringPK> jobContext = new HashMap<String, ObjectStringPK>();
        jobContext.put("schemaPK", new ObjectStringPK(this.getSchemaId()));
        StringBuffer sbSchedule = new StringBuffer();
        String nt = this.getNoticeTime();
        if (nt == null || nt.length() < 20) {
            throw new IllegalArgumentException("Notice Time is null");
        }
        int indexOfSpace = nt.indexOf(SPACE);
        nt = nt.substring(indexOfSpace + 1, indexOfSpace + 9);
        StringTokenizer st = new StringTokenizer(nt, TIME_SEPARATOR);
        ArrayList<String> timeElementList = new ArrayList<String>();
        while (st.hasMoreElements()) {
            String timeElement = (String)st.nextElement();
            timeElementList.add(timeElement);
        }
        for (int i = timeElementList.size() - 1; i > -1; --i) {
            String timeElement = (String)timeElementList.get(i);
            sbSchedule.append(timeElement);
            sbSchedule.append(SPACE);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(noticeDate);
        int day = calendar.get(5);
        sbSchedule.append(day);
        sbSchedule.append(SPACE);
        int month = calendar.get(2);
        sbSchedule.append(month + 1);
        sbSchedule.append(SPACE);
        sbSchedule.append("?");
        sbSchedule.append(SPACE);
        int year = calendar.get(1);
        sbSchedule.append(year);
        ScheduleDef define = new ScheduleDef(null);
        define.setType(ScheduleType.ONETIME);
        define.setBeginTime(noticeDate);
        define.setEndTime(noticeDate);
        define.setUseCalendar(false);
        define.setInstructionType(1);
        define.setDefine(sbSchedule.toString());
        String scheduleXML = KpdlParser.scheduleToString((ScheduleDef)define);
        String jobId = EnactmentServiceProxy.getEnacementService((Context)this.ctx).createJobProcessDef(jobName.toString(), funciton, operation, jobContext, scheduleXML, this.ctx.getLocale());
        if (ReportCommitAutoNoticeTool.isShowAutoNoticeDebugInfo(this.ctx)) {
            StringBuffer logInfoBuf = new StringBuffer();
            logInfoBuf.append("CSLReport Commit Notice Job: create, JobID=");
            logInfoBuf.append(jobId);
            logInfoBuf.append(", Job Schedule=");
            logInfoBuf.append(new SimpleDateFormat("yyyy-MM-dd").format(noticeDate));
            logInfoBuf.append(SPACE);
            logInfoBuf.append(this.getNoticeTime());
            logInfoBuf.append(", Job schemaInfo=");
            logInfoBuf.append(jobName);
            this.logger.info((Object)logInfoBuf.toString());
        }
    }

    public static Map getReportPeriodByCurrentDate(RptPeriodTypeEnum periodType, boolean isPeriodBefore, int noticeDays) {
        Calendar cal = Calendar.getInstance();
        Date currentDate = DateTimeUtils.truncateDate((Date)cal.getTime());
        cal.setTime(currentDate);
        int year = 0;
        int period = 0;
        Date reportDate = null;
        switch (periodType.getValue()) {
            case 6: {
                if (!isPeriodBefore) {
                    cal.add(1, -1);
                }
                year = cal.get(1);
                period = 1;
                cal.set(year, 11, 31);
                reportDate = cal.getTime();
                break;
            }
            case 5: {
                cal.set(cal.get(1), 5, 30);
                Date midDate = DateTimeUtils.truncateDate((Date)cal.getTime());
                if (isPeriodBefore) {
                    if (currentDate.compareTo(midDate) <= 0) {
                        year = cal.get(1);
                        period = 1;
                    } else {
                        year = cal.get(1);
                        period = 2;
                    }
                } else if (currentDate.before(midDate)) {
                    cal.add(1, -1);
                    year = cal.get(1);
                    period = 2;
                } else {
                    year = cal.get(1);
                    period = 1;
                }
                if (period == 1) {
                    cal.set(year, 5, 30);
                } else {
                    cal.set(year, 11, 31);
                }
                reportDate = cal.getTime();
                break;
            }
            case 4: {
                cal.set(cal.get(1), 2, 31);
                Date q1Date = cal.getTime();
                cal.set(cal.get(1), 5, 30);
                Date q2Date = cal.getTime();
                cal.set(cal.get(1), 8, 30);
                Date q3Date = cal.getTime();
                cal.set(cal.get(1), 11, 31);
                Date q4Date = cal.getTime();
                if (isPeriodBefore) {
                    if (currentDate.compareTo(q1Date) <= 0) {
                        period = 1;
                        reportDate = q1Date;
                    } else if (currentDate.compareTo(q2Date) <= 0) {
                        period = 2;
                        reportDate = q2Date;
                    } else if (currentDate.compareTo(q3Date) <= 0) {
                        period = 3;
                        reportDate = q3Date;
                    } else if (currentDate.compareTo(q4Date) <= 0) {
                        period = 4;
                        reportDate = q4Date;
                    }
                } else if (currentDate.compareTo(q1Date) < 0) {
                    period = 4;
                    cal.setTime(q4Date);
                    cal.set(1, -1);
                    reportDate = cal.getTime();
                } else if (currentDate.compareTo(q2Date) < 0) {
                    period = 1;
                    reportDate = q1Date;
                } else if (currentDate.compareTo(q3Date) < 0) {
                    period = 2;
                    reportDate = q2Date;
                } else if (currentDate.compareTo(q4Date) < 0) {
                    period = 3;
                    reportDate = q3Date;
                }
                year = cal.get(1);
                break;
            }
            case 3: {
                if (isPeriodBefore) {
                    period = cal.get(2) + 1;
                    year = cal.get(1);
                    int maxDay = cal.getActualMaximum(5);
                    cal.set(cal.get(1), cal.get(2), maxDay);
                    reportDate = cal.getTime();
                    break;
                }
                cal.add(2, -1);
                period = cal.get(2) + 1;
                year = cal.get(1);
                int maxDay = cal.getActualMaximum(5);
                cal.set(cal.get(1), cal.get(2), maxDay);
                reportDate = cal.getTime();
                cal.set(cal.get(1), 0, 31);
                if (!currentDate.before(cal.getTime())) break;
                cal.add(1, -1);
                period = 12;
                cal.set(cal.get(1), 11, 31);
                year = cal.get(1);
                reportDate = cal.getTime();
                break;
            }
            case 2: {
                if (isPeriodBefore) {
                    period = cal.get(3);
                    year = cal.get(1);
                    int maxDay = cal.getActualMaximum(7);
                    cal.set(cal.get(1), cal.get(2), maxDay);
                    reportDate = cal.getTime();
                    break;
                }
                cal.add(3, -1);
                period = cal.get(4);
                year = cal.get(1);
                int maxDay = cal.getActualMaximum(7);
                cal.set(cal.get(1), cal.get(2), maxDay);
                reportDate = cal.getTime();
                cal.set(3, 1);
                maxDay = cal.getActualMaximum(7);
                cal.set(7, maxDay);
                if (!currentDate.before(cal.getTime())) break;
                cal.add(1, -1);
                period = 52;
                cal.set(3, 52);
                maxDay = cal.getActualMaximum(7);
                cal.set(7, maxDay);
                year = cal.get(1);
                reportDate = cal.getTime();
                break;
            }
            case 1: {
                if (isPeriodBefore) {
                    cal.add(5, noticeDays);
                } else {
                    cal.add(5, noticeDays * -1);
                }
                year = cal.get(1);
                period = cal.get(6);
                reportDate = cal.getTime();
                break;
            }
        }
        HashMap<String, Comparable<Integer>> result = new HashMap<String, Comparable<Integer>>();
        result.put(YEAR, new Integer(year));
        result.put(PERIOD, new Integer(period));
        result.put(REPORT_DATE, reportDate);
        return result;
    }

    public void updateJobs() throws BOSException {
        this.deleteJobs();
        this.createJobs();
    }

    public void deleteJobs() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_job_trigger set fholderid = null, flasttriggeredtime = null, fisValid = 'N' ");
        sql.append("where fisValid = 'Y' and fjobdefid in (select fjobdefid from t_job_def where ftitle like '%");
        sql.append(this.getSchemaId()).append("%')");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
        StringBuffer logInfoBuf = new StringBuffer();
        logInfoBuf.append("CSLReport Commit Notice Job: disabled jobs of schema(schema id is:");
        logInfoBuf.append(this.getSchemaId()).append(")");
        this.logger.info((Object)logInfoBuf.toString());
    }
}

