/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.DebitOrCreditEnum;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.IReportClass;
import com.kingdee.eas.fi.gr.cslrpt.RPTEffectItemEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemControlEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassCollection;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassFactory;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class RptItemDataImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.RptItemDataImport");
    Map multiLanguage = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return RPTItemFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public IRPTItem getBizInterface(Context ctx) {
        IRPTItem rpt = null;
        try {
            rpt = RPTItemFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)"IRPTItem_getBizInterface_BOSException", (Throwable)e);
        }
        return rpt;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            IRPTItem iRptItem = RPTItemFactory.getLocalInstance(ctx);
            RPTItemInfo rptInfo = (RPTItemInfo)coreBaseInfo;
            iRptItem.importDataFromXsl(this.isSltImportUpdate(), rptInfo);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    private String fecthData(Hashtable htData, String key) {
        DataToken dataToken = (DataToken)htData.get(key);
        if (dataToken != null) {
            return dataToken.toString();
        }
        return null;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        RPTItemInfo info = new RPTItemInfo();
        info.setName(this.fecthData(hsData, "FName_L1"), new Locale("L1"));
        info.setName(this.fecthData(hsData, "FName_L2"), new Locale("L2"));
        info.setName(this.fecthData(hsData, "FName_L3"), new Locale("L3"));
        String number = this.fecthData(hsData, "FNumber");
        if (StringUtil.isEmptyString((String)number)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_NumberNull", (Locale)ctx.getOriginLocale()));
        }
        if ((number = number.replaceAll(" ", "")).startsWith(".") || number.endsWith(".")) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_RPTItemNumberErr4", (Locale)ctx.getOriginLocale()));
        }
        info.setNumber(number);
        RPTItemInfo parentRptItem = null;
        if (number.indexOf(".") != -1) {
            try {
                parentRptItem = this.getParentRptItem(ctx, number);
                info.setParent(parentRptItem);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage());
            }
            if (info.getParent() == null) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_RPTItemParentIsNull", (Locale)ctx.getOriginLocale()));
            }
        }
        info.setDescription(this.fecthData(hsData, "FDescription_L1"), new Locale("L1"));
        info.setDescription(this.fecthData(hsData, "FDescription_L2"), new Locale("L2"));
        info.setDescription(this.fecthData(hsData, "FDescription_L3"), new Locale("L3"));
        if (info.getNumber().trim().startsWith("=")) {
            throw new TaskExternalException(info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"88_notequalsStart", (Locale)ctx.getLocale()));
        }
        if (info.getName().trim().startsWith("=")) {
            throw new TaskExternalException(info.getName() + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"88_notequalsStart", (Locale)ctx.getLocale()));
        }
        if (info.getDescription() != null && info.getDescription().trim().startsWith("=")) {
            throw new TaskExternalException(info.getDescription() + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"88_notequalsStart", (Locale)ctx.getLocale()));
        }
        info.setDc(this.getDc(ctx, this.fecthData(hsData, "FDc")));
        info.setReportClass(parentRptItem != null ? parentRptItem.getReportClass() : this.getReportClassView(ctx, this.fecthData(hsData, "FReportClassID")));
        info.setSimpleCode(this.fecthData(hsData, "FSimpleCode"));
        info.setIsSumItem(!StringUtil.isEmptyString((String)this.fecthData(hsData, "FSumItemFormula")));
        info.setSumItemFormula(this.fecthData(hsData, "FSumItemFormula"));
        info.setItemGroup(parentRptItem != null ? parentRptItem.getItemGroup() : this.getItemGroup(ctx, this.fecthData(hsData, "FItemGroup")));
        boolean isRight = info.getItemGroup().getValue() == 2;
        RPTItemControlEnum itemControl = this.getItemControl(ctx, this.fecthData(hsData, "FControl"));
        if (itemControl == null) {
            if (isRight) {
                String erroInfo = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptItemControlNotExist", (Locale)ctx.getOriginLocale()), this.fecthData(hsData, "FControl"));
                throw new TaskExternalException(erroInfo);
            }
            info.setControl(RPTItemControlEnum.NULL_VALUE);
        } else {
            info.setControl(itemControl);
            if (!isRight && itemControl.getValue() != 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptItem_NoInvest_NotHaveControl", (Locale)ctx.getOriginLocale()));
            }
        }
        info.setEffectItem(parentRptItem != null ? parentRptItem.getEffectItem() : this.getEffectItem(ctx, this.fecthData(hsData, "FEffectItem")));
        info.setIsFreezed(this.getBooleanFromAlias(this.fecthData(hsData, "FIsFreezed"), ctx));
        info.setIsProfitAndLosses(parentRptItem != null ? parentRptItem.isIsProfitAndLosses() : this.getBooleanFromAlias(this.fecthData(hsData, "FIsProfitAndLosses"), ctx));
        return info;
    }

    private boolean getBooleanFromAlias(String bool, Context ctx) {
        if (StringUtils.isEmpty((String)bool)) {
            return false;
        }
        String upperCase = bool.toUpperCase(ctx.getOriginLocale());
        return ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptItem_Yes", (Locale)ctx.getOriginLocale()).equals(upperCase) || ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptItem_True", (Locale)ctx.getOriginLocale()).equals(upperCase) || "Y".equals(upperCase) || "TRUE".equals(upperCase);
    }

    private ReportClassInfo getReportClassView(Context ctx, String name) throws TaskExternalException {
        IReportClass irc = null;
        ReportClassInfo info = null;
        ReportClassCollection collection = null;
        try {
            irc = ReportClassFactory.getLocalInstance(ctx);
            String oql = "select id where name = '" + name + "'";
            collection = irc.getReportClassCollection(oql);
            if (collection.size() > 0) {
                info = collection.get(0);
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return info;
    }

    private RPTItemInfo getParentRptItem(Context ctx, String number) throws EASBizException, BOSException {
        String parentNumber = number.substring(0, number.lastIndexOf(46));
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.getSelector().add(new SelectorItemInfo("id"));
        entityView.getSelector().add(new SelectorItemInfo("itemGroup"));
        entityView.getSelector().add(new SelectorItemInfo("reportClass"));
        entityView.getSelector().add(new SelectorItemInfo("isProfitAndLosses"));
        entityView.getSelector().add(new SelectorItemInfo("effectItem"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)parentNumber));
        entityView.setFilter(filter);
        IRPTItem iRPTItem = RPTItemFactory.getLocalInstance(ctx);
        RPTItemCollection itemCollection = iRPTItem.getRPTItemCollection(entityView);
        if (itemCollection.size() > 0) {
            return itemCollection.get(0);
        }
        return null;
    }

    private DebitOrCreditEnum getDc(Context ctx, String aliasName) {
        Iterator iterator = DebitOrCreditEnum.iterator();
        while (iterator.hasNext()) {
            DebitOrCreditEnum dcEnum = (DebitOrCreditEnum)((Object)iterator.next());
            if (!dcEnum.getAlias(ctx.getOriginLocale()).equals(aliasName)) continue;
            return dcEnum;
        }
        return DebitOrCreditEnum.DEBIT;
    }

    private RPTEffectItemEnum getEffectItem(Context ctx, String aliasName) {
        Iterator iterator = RPTEffectItemEnum.iterator();
        while (iterator.hasNext()) {
            RPTEffectItemEnum effectItemEnum = (RPTEffectItemEnum)((Object)iterator.next());
            if (!effectItemEnum.getAlias(ctx.getOriginLocale()).equals(aliasName)) continue;
            return effectItemEnum;
        }
        return RPTEffectItemEnum.UNSET;
    }

    private RPTItemGroupEnum getItemGroup(Context ctx, String aliasName) {
        Iterator iterator = RPTItemGroupEnum.iterator();
        while (iterator.hasNext()) {
            RPTItemGroupEnum rptGroup = (RPTItemGroupEnum)((Object)iterator.next());
            if (!rptGroup.getAlias(ctx.getOriginLocale()).equals(aliasName)) continue;
            return rptGroup;
        }
        return RPTItemGroupEnum.OTHER;
    }

    private RPTItemControlEnum getItemControl(Context ctx, String name) {
        Iterator iterator = RPTItemControlEnum.iterator();
        while (iterator.hasNext()) {
            RPTItemControlEnum itemControlEnum = (RPTItemControlEnum)((Object)iterator.next());
            if (!itemControlEnum.getAlias(ctx.getOriginLocale()).equals(name)) continue;
            return itemControlEnum;
        }
        return null;
    }

    private void initMultiLanguage(Context ctx, IRowSet rs) throws TaskExternalException {
        if (this.multiLanguage == null) {
            this.multiLanguage = new HashMap();
            StringBuffer querySql = new StringBuffer("select");
            querySql.append(" fnumber,fname_l1,fname_l2,fname_l3");
            querySql.append(",fdescription_l1,fdescription_l2,fdescription_l3");
            querySql.append(" from t_csl_rptitem");
            try {
                IRowSet rowSet;
                IRowSet copyRs = rs.createCopy();
                copyRs.beforeFirst();
                StringBuffer numbers = new StringBuffer();
                ArrayList<String> paramList = new ArrayList<String>();
                while (copyRs.next()) {
                    paramList.add(copyRs.getString("number"));
                }
                if (paramList.size() > 0) {
                    querySql.append(" where fnumber in (?");
                    for (int i = 1; i < paramList.size(); ++i) {
                        querySql.append(",?");
                    }
                    querySql.append(")");
                }
                IRowSet iRowSet = rowSet = paramList.isEmpty() ? DbUtil.executeQuery((Context)ctx, (String)querySql.toString()) : DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])paramList.toArray());
                while (rowSet.next()) {
                    RPTItemInfo rptItem = new RPTItemInfo();
                    rptItem.setNumber(rowSet.getString(1));
                    rptItem.setName(rowSet.getString(2), new Locale("L1"));
                    rptItem.setName(rowSet.getString(3), new Locale("L2"));
                    rptItem.setName(rowSet.getString(4), new Locale("L3"));
                    rptItem.setDescription(rowSet.getString(5), new Locale("L1"));
                    rptItem.setDescription(rowSet.getString(6), new Locale("L2"));
                    rptItem.setDescription(rowSet.getString(7), new Locale("L3"));
                    this.checkStr(rptItem.getNumber());
                    this.checkStr(rptItem.getName());
                    this.checkStr(rptItem.getDescription());
                    this.multiLanguage.put(rowSet.getString(1), rptItem);
                }
            }
            catch (BOSException e) {
                throw new TaskExternalException("exportTransmit_SQLException", e.getCause());
            }
            catch (SQLException e) {
                throw new TaskExternalException("exportTransmit_SQLException", e.getCause());
            }
        }
    }

    private void checkStr(String str) throws TaskExternalException {
        if (str != null && str.trim().startsWith("=")) {
            throw new TaskExternalException(str + " is start with '='");
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        this.initMultiLanguage(ctx, rs);
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            String number = rs.getString("number");
            RPTItemInfo rptItem = (RPTItemInfo)this.multiLanguage.remove(number);
            result.put("FNumber", number);
            result.put("FItemGroup", RPTItemGroupEnum.getEnum(rs.getInt("itemGroup")).getAlias(ctx.getOriginLocale()));
            if (rs.getString("isFreezed").equalsIgnoreCase("true")) {
                result.put("FIsFreezed", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"793_RptItemDataImport", (Locale)ctx.getOriginLocale()));
            } else {
                result.put("FIsFreezed", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"794_RptItemDataImport", (Locale)ctx.getOriginLocale()));
            }
            result.put("FDc", DebitOrCreditEnum.getEnum(rs.getInt("dc")).getAlias(ctx.getOriginLocale()));
            result.put("FName_L1", rptItem.getName(new Locale("L1")) == null ? "" : rptItem.getName(new Locale("L1")));
            result.put("FName_L2", rptItem.getName(new Locale("L2")) == null ? "" : rptItem.getName(new Locale("L2")));
            result.put("FName_L3", rptItem.getName(new Locale("L3")) == null ? "" : rptItem.getName(new Locale("L3")));
            result.put("FDescription_L1", rptItem.getDescription(new Locale("L1")) == null ? "" : rptItem.getDescription(new Locale("L1")));
            result.put("FDescription_L2", rptItem.getDescription(new Locale("L2")) == null ? "" : rptItem.getDescription(new Locale("L2")));
            result.put("FDescription_L3", rptItem.getDescription(new Locale("L3")) == null ? "" : rptItem.getDescription(new Locale("L3")));
            if (rs.getString("reportClass") != null) {
                result.put("FReportClassID", rs.getString("reportClass"));
            } else {
                result.put("FReportClassID", "");
            }
            if (rs.getString("simpleCode") != null) {
                result.put("FSimpleCode", rs.getString("simpleCode"));
            } else {
                result.put("FSimpleCode", "");
            }
            if (rs.getString("parent") != null) {
                result.put("FParent", rs.getString("parent"));
            } else {
                result.put("FParent", "");
            }
            if (rs.getString("control") != null) {
                result.put("FControl", RPTItemControlEnum.getEnum(rs.getInt("control")).getAlias(ctx.getOriginLocale()));
            }
            if (rs.getString("sumItemFormula") != null) {
                result.put("FSumItemFormula", rs.getString("sumItemFormula"));
            } else if (rs.getString("specSumFormula") != null) {
                result.put("FSumItemFormula", rs.getString("specSumFormula"));
            } else {
                result.put("FSumItemFormula", "");
            }
            result.put("FIsSumItem", rs.getBoolean("isSumItem") ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"793_RptItemDataImport", (Locale)ctx.getOriginLocale()) : ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"794_RptItemDataImport", (Locale)ctx.getOriginLocale()));
            if (rs.getString("isProfitAndLosses").equalsIgnoreCase("true")) {
                result.put("FIsProfitAndLosses", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"793_RptItemDataImport", (Locale)ctx.getOriginLocale()));
            } else {
                result.put("FIsProfitAndLosses", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"794_RptItemDataImport", (Locale)ctx.getOriginLocale()));
            }
            if (rs.getString("effectItem") != null) {
                result.put("FEffectItem", RPTEffectItemEnum.getEnum(rs.getInt("effectItem")).getAlias(ctx.getOriginLocale()));
            } else {
                result.put("FEffectItem", "");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"exportTransmit_SQLException", (Throwable)e);
        }
        result.keySet();
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.gr.cslrpt.app.RptItemListQuery";
    }
}

