/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.RptItemRelationshipCollection;
import com.kingdee.eas.fi.gr.cslrpt.RptItemRelationshipFactory;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractRptItemRelationshipControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptItemRelationshipControllerBean
extends AbstractRptItemRelationshipControllerBean {
    private static final long serialVersionUID = -3846859847235190780L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.RptItemRelationshipControllerBean");
    private static final String SPLIT = ";";

    @Override
    protected void _freezed(Context ctx, List list, boolean isFreezed) throws BOSException, EASBizException {
        if (list != null && list.size() > 0) {
            int freeze = isFreezed ? 1 : 0;
            StringBuffer sb = new StringBuffer("update T_CSL_RptItemRelationship set FIsFreezed =");
            sb.append(freeze).append(" where FId in (");
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                sb.append("'").append(iter.next()).append("',");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(" )");
            logger.debug((Object)sb.toString());
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
    }

    @Override
    protected Map _getItemRelationshipMap(Context ctx, int scope) throws BOSException, EASBizException {
        String oql = "select id,dataElement,remark,item.number,item.id,item.isFreezed,entries,entries.dataElement,entries.targetItem.number where isFreezed = 0 and (scope=1 or scope=" + scope + ")";
        RptItemRelationshipCollection coll = RptItemRelationshipFactory.getLocalInstance(ctx).getRptItemRelationshipCollection(oql);
        if (coll != null && coll.size() > 0) {
            HashMap<String, Cloneable> map = new HashMap<String, Cloneable>();
            HashMap<String, RPTItemInfo> itemIdMap = new HashMap<String, RPTItemInfo>();
            HashMap<String, String> remarkMap = new HashMap<String, String>();
            String head = null;
            String body = null;
            for (int i = 0; i < coll.size(); ++i) {
                if (coll.get(i).getItem().isIsFreezed()) continue;
                head = new StringBuffer(coll.get(i).getItem().getNumber()).append(SPLIT).append(coll.get(i).getDataElement()).toString();
                HashSet<String> set = new HashSet<String>();
                map.put(head, set);
                itemIdMap.put(coll.get(i).getItem().getNumber(), coll.get(i).getItem());
                remarkMap.put(coll.get(i).getItem().getId().toString() + coll.get(i).getDataElement(), coll.get(i).getRemark());
                for (int j = 0; j < coll.get(i).getEntries().size(); ++j) {
                    body = new StringBuffer(coll.get(i).getEntries().get(j).getTargetItem().getNumber()).append(SPLIT).append(coll.get(i).getEntries().get(j).getDataElement()).toString();
                    set.add(body);
                }
            }
            map.put("itemIdMap", itemIdMap);
            map.put("remarkMap", remarkMap);
            return map;
        }
        return null;
    }

    @Override
    protected void _autoCreateRelationshipItems(Context ctx, AdjustInfo adjustInfo, Map itemMap) throws BOSException, EASBizException {
        if (adjustInfo == null || adjustInfo.getEntries() == null) {
            return;
        }
        if (itemMap != null) {
            Map remarkMap = (Map)itemMap.get("remarkMap");
            itemMap.remove("remarkMap");
            Map itemIdMap = (Map)itemMap.get("itemIdMap");
            itemMap.remove("itemIdMap");
            if (itemMap.size() > 0) {
                HashMap autoAdjustData = new HashMap();
                Iterator iter = adjustInfo.getEntries().iterator();
                while (iter.hasNext()) {
                    AdjustEntryInfo entryInfo = (AdjustEntryInfo)iter.next();
                    String value = entryInfo.getItem().getNumber() + SPLIT + entryInfo.getDataElement();
                    this.getAutoAdjustDataMap(ctx, itemMap, value, autoAdjustData, entryInfo, itemIdMap, remarkMap);
                }
                int seq = adjustInfo.getEntries().size();
                for (Map.Entry entry : autoAdjustData.entrySet()) {
                    AdjustEntryInfo adjustEntry = (AdjustEntryInfo)entry.getValue();
                    if (!this.offsetDebitOrCredit(adjustEntry)) continue;
                    adjustEntry.setSeq(++seq);
                    adjustInfo.getEntries().add((AdjustEntryInfo)entry.getValue());
                }
            }
        }
    }

    @Override
    protected void _autoCreateRelationshipItems(Context ctx, EliminationInfo eliminationInfo) throws BOSException, EASBizException {
        if (eliminationInfo == null || eliminationInfo.getEntries() == null) {
            return;
        }
        Map[] ItemRelationshipMaps = NewRptUtil.getItemRelationShipMaps((Context)ctx, (int)3);
        if (ItemRelationshipMaps != null || !ItemRelationshipMaps[2].isEmpty()) {
            Map remarkMap = ItemRelationshipMaps[1];
            Map itemIdMap = ItemRelationshipMaps[0];
            Map itemMap = ItemRelationshipMaps[2];
            if (itemMap.size() > 0) {
                HashMap autoEliminationData = new HashMap();
                int precision = this.getCurrencyPrecision(eliminationInfo);
                Iterator iter = eliminationInfo.getEntries().iterator();
                while (iter.hasNext()) {
                    EliminationEntryInfo entryInfo = (EliminationEntryInfo)iter.next();
                    String value = entryInfo.getItem().getNumber() + SPLIT + entryInfo.getDataElement();
                    this.getAutoEliminationDataMap(ctx, itemMap, value, autoEliminationData, entryInfo, itemIdMap, remarkMap, precision);
                }
                int seq = eliminationInfo.getEntries().size();
                Iterator iterator = autoEliminationData.entrySet().iterator();
                ArrayList<EliminationEntryInfo> entryColl = new ArrayList<EliminationEntryInfo>();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    EliminationEntryInfo elimEntry = (EliminationEntryInfo)entry.getValue();
                    if (!this.offsetDebitOrCredit(elimEntry)) continue;
                    elimEntry.setSeq(++seq);
                    entryColl.add((EliminationEntryInfo)entry.getValue());
                }
                Collections.sort(entryColl, new Comparator<EliminationEntryInfo>(){

                    @Override
                    public int compare(EliminationEntryInfo o1, EliminationEntryInfo o2) {
                        if (o1.getCompany() == null && o2.getCompany() == null) {
                            return 0;
                        }
                        if (o1.getCompany() == null) {
                            return -1;
                        }
                        if (o2.getCompany() == null) {
                            return 1;
                        }
                        String v1 = o1.getCompany().getNumber();
                        String v2 = o2.getCompany().getNumber();
                        return v1 == null ? -1 : v1.compareTo(v2);
                    }
                });
                seq = eliminationInfo.getEntries().size();
                for (int i = 0; i < entryColl.size(); ++i) {
                    EliminationEntryInfo info = (EliminationEntryInfo)entryColl.get(i);
                    info.setSeq(++seq);
                    eliminationInfo.getEntries().add(info);
                }
            }
        }
    }

    private int getCurrencyPrecision(EliminationInfo eliminationInfo) {
        if (eliminationInfo.getCurrency() != null) {
            return eliminationInfo.getCurrency().getPrecision();
        }
        return 2;
    }

    @Override
    protected List _getAutoCreateItemList(Context ctx, Map itemMap, String itemNumber, String dataElement) throws BOSException {
        ArrayList createItemList = new ArrayList();
        String value = itemNumber + SPLIT + dataElement;
        HashSet<String> createItemParentList = new HashSet<String>();
        this.loadAutoCreateItemList(itemMap, createItemList, value, createItemParentList);
        return createItemList;
    }

    private boolean offsetDebitOrCredit(AdjustEntryInfo adjustEntry) {
        boolean isAdd = true;
        if (adjustEntry.getDebit() != null && adjustEntry.getCredit() != null) {
            if (adjustEntry.getDebit().compareTo(adjustEntry.getCredit()) > 0) {
                adjustEntry.setDebit(adjustEntry.getDebit().subtract(adjustEntry.getCredit()));
                adjustEntry.setCredit(null);
            } else if (adjustEntry.getDebit().compareTo(adjustEntry.getCredit()) < 0) {
                adjustEntry.setCredit(adjustEntry.getCredit().subtract(adjustEntry.getDebit()));
                adjustEntry.setDebit(null);
            } else {
                isAdd = false;
            }
        }
        return isAdd;
    }

    private boolean offsetDebitOrCredit(EliminationEntryInfo elimEntry) {
        boolean isAdd = true;
        if (elimEntry.getDebit() != null && elimEntry.getCredit() != null) {
            if (elimEntry.getDebit().compareTo(elimEntry.getCredit()) > 0) {
                elimEntry.setDebit(elimEntry.getDebit().subtract(elimEntry.getCredit()));
                elimEntry.setCredit(null);
            } else if (elimEntry.getDebit().compareTo(elimEntry.getCredit()) < 0) {
                elimEntry.setCredit(elimEntry.getCredit().subtract(elimEntry.getDebit()));
                elimEntry.setDebit(null);
            } else {
                isAdd = false;
            }
        }
        return isAdd;
    }

    private void getAutoEliminationDataMap(Context ctx, Map itemMap, String value, Map autoEliminationData, EliminationEntryInfo entryInfo, Map itemIdMap, Map remarkMap, int precision) throws EASBizException, BOSException {
        ArrayList createItemList = new ArrayList();
        HashSet<String> createItemParentList = new HashSet<String>();
        this.loadAutoCreateItemList(itemMap, createItemList, value, createItemParentList);
        String summary = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ItemRelationshipResource", (String)"1SysAutoElim", (Locale)ctx.getOriginLocale());
        Iterator iter = createItemList.iterator();
        while (iter.hasNext()) {
            EliminationEntryInfo entry;
            String element = iter.next().toString();
            if (entryInfo.getCompany() != null) {
                element = element + SPLIT + entryInfo.getCompany().getNumber();
            }
            if ((entry = (EliminationEntryInfo)autoEliminationData.get(element)) == null) {
                String number = element.split(SPLIT)[0];
                int dataElement = new Integer(element.split(SPLIT)[1]);
                entry = new EliminationEntryInfo();
                entry.setElimination(entryInfo.getElimination());
                RPTItemInfo item = this.getRPTItemInfo(ctx, itemIdMap, number);
                if (item == null) continue;
                entry.setItem(item);
                entry.setCompany(entryInfo.getCompany());
                String summaryExtend = (String)remarkMap.get(entry.getItem().getId().toString() + dataElement);
                if (!StringUtils.isEmpty((String)summaryExtend) && !createItemParentList.contains(number + SPLIT + dataElement)) {
                    entry.setSummaryExtend(summaryExtend);
                }
                entry.setSummary(summary);
                entry.setDataElement(dataElement);
                entry.setIsVisible(false);
                if (createItemParentList.contains(number)) {
                    entry.put("isAutoCreateParentItem", true);
                }
            }
            if (entryInfo.getDebit() != null) {
                if (entry.getDebit() == null) {
                    entry.setDebit(entryInfo.getDebit());
                } else {
                    BigDecimal debit = entry.getDebit().setScale(precision, 4).add(entryInfo.getDebit().setScale(precision, 4));
                    entry.setDebit(debit);
                }
            } else if (entryInfo.getCredit() != null) {
                if (entry.getCredit() == null) {
                    entry.setCredit(entryInfo.getCredit());
                } else {
                    BigDecimal credit = entry.getCredit().setScale(precision, 4).add(entryInfo.getCredit().setScale(precision, 4));
                    entry.setCredit(credit);
                }
            }
            autoEliminationData.put(element, entry);
        }
    }

    private RPTItemInfo getRPTItemInfo(Context ctx, Map itemIdMap, String number) throws BOSException, EASBizException {
        RPTItemInfo item = null;
        if (!itemIdMap.containsKey(number)) {
            RPTItemCollection itemCollection = RPTItemFactory.getLocalInstance(ctx).getRPTItemCollection("select id,number,isProfitAndLosses,effectItem where isFreezed = 0 and number='" + number + "'");
            if (itemCollection != null && itemCollection.size() > 0) {
                item = itemCollection.get(0);
                itemIdMap.put(item.getNumber(), item);
            } else {
                itemIdMap.put(number, "");
            }
        } else {
            Object obj = itemIdMap.get(number);
            if (obj instanceof RPTItemInfo) {
                item = (RPTItemInfo)obj;
                if (item != null && item.isIsFreezed()) {
                    return null;
                }
            } else {
                item = null;
            }
        }
        return item;
    }

    private void getAutoAdjustDataMap(Context ctx, Map itemMap, String value, Map autoAdjustData, AdjustEntryInfo entryInfo, Map itemIdMap, Map remarkMap) throws EASBizException, BOSException {
        ArrayList createItemList = new ArrayList();
        HashSet<String> createItemParentList = new HashSet<String>();
        this.loadAutoCreateItemList(itemMap, createItemList, value, createItemParentList);
        String summary = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ItemRelationshipResource", (String)"2SysAutoAdjust", (Locale)ctx.getOriginLocale());
        Iterator iter = createItemList.iterator();
        while (iter.hasNext()) {
            String element = iter.next().toString();
            AdjustEntryInfo entry = (AdjustEntryInfo)autoAdjustData.get(element);
            if (entry == null) {
                String number = element.split(SPLIT)[0];
                int dataElement = new Integer(element.split(SPLIT)[1]);
                entry = new AdjustEntryInfo();
                entry.setAdjust(entryInfo.getAdjust());
                RPTItemInfo item = this.getRPTItemInfo(ctx, itemIdMap, number);
                if (item == null) continue;
                entry.setItem(item);
                String summaryExtend = (String)remarkMap.get(entry.getItem().getId().toString() + dataElement);
                if (summaryExtend != null && !createItemParentList.contains(number + SPLIT + dataElement)) {
                    entry.setSummaryExtend(summaryExtend);
                }
                entry.setSummary(summary);
                entry.setDataElement(dataElement);
                entry.setIsVisible(false);
                if (createItemParentList.contains(number)) {
                    entry.put("isAutoCreateParentItem", true);
                }
            }
            if (entryInfo.getDebit() != null) {
                if (entry.getDebit() == null) {
                    entry.setDebit(entryInfo.getDebit());
                } else {
                    entry.setDebit(entry.getDebit().add(entryInfo.getDebit()));
                }
            } else if (entry.getCredit() == null) {
                entry.setCredit(entryInfo.getCredit());
            } else {
                entry.setCredit(entry.getCredit().add(entryInfo.getCredit()));
            }
            autoAdjustData.put(element, entry);
        }
    }

    private void loadAutoCreateItemList(Map itemMap, List createItemList, String value, Set<String> createItemParentList, String srcValue) {
        List containItemList = this.getContainItemList(itemMap, value, createItemParentList);
        Iterator iter = containItemList.iterator();
        while (iter.hasNext()) {
            String element = iter.next().toString();
            if (element != null && (element.equals(srcValue) || createItemList.contains(element))) continue;
            createItemList.add(element);
            this.loadAutoCreateItemList(itemMap, createItemList, element, createItemParentList, srcValue);
        }
    }

    private void loadAutoCreateItemList(Map itemMap, List createItemList, String value, Set<String> createItemParentList) {
        this.loadAutoCreateItemList(itemMap, createItemList, value, createItemParentList, value);
    }

    private List getContainItemList(Map itemMap, String value, Set<String> createItemParentList) {
        ArrayList<String> containItemList = new ArrayList<String>();
        Iterator iter = itemMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            Set set = (Set)itemMap.get(key);
            if (!set.contains(value)) continue;
            List parentList = this.getParentNumbers(key.split(SPLIT)[0]);
            if (createItemParentList != null && parentList != null && parentList.size() > 0) {
                createItemParentList.addAll(parentList);
            }
            for (int m = 0; parentList != null && m < parentList.size(); ++m) {
                containItemList.add(parentList.get(m) + SPLIT + key.split(SPLIT)[1]);
                createItemParentList.add(parentList.get(m) + SPLIT + key.split(SPLIT)[1]);
            }
            containItemList.add(key);
        }
        return containItemList;
    }

    private List getParentNumbers(String number) {
        if (number.indexOf(46) == -1) {
            return null;
        }
        ArrayList<String> numbers = new ArrayList<String>();
        int end = number.length();
        while ((end = number.lastIndexOf(46, end)) > 0) {
            numbers.add(number.substring(0, end));
            --end;
        }
        return numbers;
    }
}

