/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.IShareRela;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.ShareRelaCollection;
import com.kingdee.eas.fi.gr.cslrpt.ShareRelaFactory;
import com.kingdee.eas.fi.gr.cslrpt.ShareRelaInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractShareRelaControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ShareRelaControllerBean
extends AbstractShareRelaControllerBean {
    private static final String CU_FIELD = "00000000-0000-0000-0000-000000000000CCE7AED4";
    public static final String SHARERELA_BOSTYPE = "7555AB43";

    @Override
    protected void _recordChange(Context ctx, IObjectPK pk, java.util.Date chgeDate, IObjectCollection model) throws BOSException, EASBizException {
        ShareRelaInfo shInfo;
        EntityViewInfo view = new EntityViewInfo();
        ShareRelaCollection shcol = null;
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("changeDate"));
        sic.add(new SelectorItemInfo("isLatest"));
        sic.add(new SelectorItemInfo("investeeCompany.id"));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem0 = new FilterItemInfo("investeeCompany.id", (Object)pk.toString(), CompareType.EQUALS);
        FilterItemInfo filterItem1 = new FilterItemInfo("changeDate", (Object)chgeDate, CompareType.EQUALS);
        FilterItemInfo filterItem2 = new FilterItemInfo("isLatest", (Object)Integer.valueOf("1"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem0);
        filter.getFilterItems().add(filterItem1);
        filter.getFilterItems().add(filterItem2);
        filter.setMaskString(" #0 and #1 and #2 ");
        view.setFilter(filter);
        IShareRela ie = ShareRelaFactory.getLocalInstance(ctx);
        shcol = ie.getShareRelaCollection(view);
        Iterator iter = shcol.iterator();
        String company = null;
        String targetCompany = null;
        while (iter.hasNext()) {
            shInfo = (ShareRelaInfo)iter.next();
            shInfo.setIsLatest(false);
            ie.update((IObjectPK)new ObjectUuidPK(shInfo.getId()), (CoreBaseInfo)shInfo);
        }
        ShareRelaCollection shmodel = (ShareRelaCollection)model;
        if (shmodel == null) {
            return;
        }
        this.checkScale(shmodel);
        Iterator itr = shmodel.iterator();
        boolean first = true;
        while (itr.hasNext()) {
            shInfo = (ShareRelaInfo)itr.next();
            if (first) {
                this.Delete(ctx, shInfo.getInvesteeCompany().getId().toString(), false);
                first = false;
            }
            if (shInfo.getShareHolder() != null) {
                company = shInfo.getShareHolder().getId().toString();
                targetCompany = shInfo.getInvesteeCompany().getId().toString();
                this.CheckCycleInvest(ctx, company, targetCompany);
            }
            ie.addnew((CoreBaseInfo)shInfo);
        }
    }

    private void CheckCycleInvest(Context ctx, String companyId, String targetCompanyId) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String tempCompanyId = companyId;
        try {
            conn = super.getConnection(ctx);
            while (tempCompanyId != null) {
                ps = conn.prepareStatement("Select tempCompanyId=FShareHolderId From t_csl_ShareRela Where FIsout=0 And FInvesteeCompanyId = ?");
                ps.setString(1, BOSUuid.read((String)tempCompanyId).toString());
                rs = ps.executeQuery();
                if (rs.next()) {
                    if (targetCompanyId.trim().equals(rs.getString("tempCompanyId").toString())) {
                        throw new ServerException(ServerException.NOT_CYCLE_INVEST);
                    }
                    tempCompanyId = rs.getString("tempCompanyId");
                    continue;
                }
                tempCompanyId = null;
            }
        }
        catch (SQLException exc) {
            try {
                throw new SQLDataException(exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
    }

    private void checkScale(ShareRelaCollection shmodel) throws EASBizException {
        Iterator iter = shmodel.iterator();
        BigDecimal scaleSum = new BigDecimal("0");
        while (iter.hasNext()) {
            ShareRelaInfo shInfo = (ShareRelaInfo)iter.next();
            this.CheckInfo(shInfo);
            scaleSum = scaleSum.add(shInfo.getBigDecimal("shareScale"));
        }
        if (scaleSum.doubleValue() > 100.0 || scaleSum.doubleValue() < 0.0) {
            throw new ServerException(ServerException.ALL_MORE_100);
        }
    }

    @Override
    protected void _addNewCollection(Context ctx, IObjectPK pk, java.util.Date changeDt, IObjectCollection model) throws BOSException, EASBizException {
        IShareRela ie = ShareRelaFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem0 = new FilterItemInfo("investeeCompany.id", (Object)pk.toString(), CompareType.EQUALS);
        FilterItemInfo filterItem2 = new FilterItemInfo("isLatest", (Object)Integer.valueOf("1"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem0);
        filter.getFilterItems().add(filterItem2);
        filter.setMaskString(" #0 and #1 ");
        view.setFilter(filter);
        ShareRelaCollection shcol = ie.getShareRelaCollection(view);
        if (shcol != null && shcol.size() != 0) {
            throw new ServerException(ServerException.COMPANY_DUP);
        }
        ShareRelaCollection shmodel = (ShareRelaCollection)model;
        this.checkScale(shmodel);
        Iterator itr = shmodel.iterator();
        while (itr.hasNext()) {
            ShareRelaInfo shInfo = (ShareRelaInfo)itr.next();
            if (shInfo.getShareHolder() != null) {
                this.CheckCycleInvest(ctx, shInfo.getShareHolder().getId().toString(), shInfo.getInvesteeCompany().getId().toString());
            }
            ie.addnew((CoreBaseInfo)shInfo);
        }
    }

    @Override
    protected void _updateCollection(Context ctx, IObjectPK pk, java.util.Date chgeDate, IObjectCollection model) throws BOSException, EASBizException {
        IShareRela ie = ShareRelaFactory.getLocalInstance(ctx);
        ShareRelaCollection shmodel = (ShareRelaCollection)model;
        if (shmodel == null) {
            return;
        }
        this.checkScale(shmodel);
        Iterator itr = shmodel.iterator();
        boolean first = true;
        while (itr.hasNext()) {
            ShareRelaInfo shInfo = (ShareRelaInfo)itr.next();
            if (first) {
                this.Delete(ctx, shInfo.getInvesteeCompany().getId().toString(), true);
                first = false;
            }
            if (shInfo.getShareHolder() != null) {
                this.CheckCycleInvest(ctx, shInfo.getShareHolder().getId().toString(), shInfo.getInvesteeCompany().getId().toString());
            }
            ie.addnew((CoreBaseInfo)shInfo);
        }
    }

    private void CheckInfo(ShareRelaInfo si) throws EASBizException {
        if (si == null) {
            return;
        }
        if (si.getOuterShareHolder() != null && si.getOuterShareHolder().length() >= 200) {
            throw new ServerException(ServerException.SHARERELA_OUTERLONG);
        }
        if (si.getRemark() != null && si.getRemark().length() >= 500) {
            throw new ServerException(ServerException.SHARERELA_REMARKLONG);
        }
    }

    private void Delete(Context ctx, String investeeCmpnyID, boolean isModify) throws BOSException, EASBizException {
        StringBuffer sbDel = new StringBuffer();
        sbDel.append("DELETE FROM T_CSL_ShareRela  \r\n").append("WHERE FInvesteeCompanyID = ?\t\r\n").append("\t\tAND FIsLatest = ?\t");
        Object[] pams = new Object[]{investeeCmpnyID, Integer.valueOf("1")};
        DbUtil.execute((Context)ctx, (String)sbDel.toString(), (Object[])pams);
    }

    @Override
    protected void _batchDelete(Context ctx, IObjectPK investeeCmpnyID) throws BOSException, EASBizException {
        StringBuffer sbDel = new StringBuffer();
        sbDel.append("DELETE FROM T_CSL_ShareRela  \r\n").append("WHERE FInvesteeCompanyID = ?\t\r\n").append("\t\tAND FIsLatest = ?\t");
        Object[] pams = new Object[]{investeeCmpnyID.toString(), Integer.valueOf("1")};
        DbUtil.execute((Context)ctx, (String)sbDel.toString(), (Object[])pams);
        IRowSet rs = null;
        Date fdate = null;
        int fcount = 0;
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" select max(fchangedate) as fdate from t_csl_sharerela \r\n");
        sbSQL.append(" where finvesteecompanyid= ? ");
        StringBuffer sbSQL1 = new StringBuffer();
        sbSQL1.append(" select count(*) as fcount from t_csl_sharerela \r\n");
        sbSQL1.append(" where finvesteecompanyid= ? ");
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL1.toString(), (Object[])new Object[]{investeeCmpnyID.toString()});
            if (rs.next()) {
                fcount = rs.getInt("fcount");
            }
            if (fcount > 0 && (rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])new Object[]{investeeCmpnyID.toString()})).next()) {
                fdate = rs.getDate("fdate");
                sbSQL = new StringBuffer();
                sbSQL.append("update t_csl_shareRela set FIsLatest = 1 Where FChangeDate = ? And FInvesteeCompanyId = ? ");
                DbUtil.execute((Context)ctx, (String)sbSQL.toString(), (Object[])new Object[]{fdate, investeeCmpnyID.toString()});
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected String _updateRateFromInvestDay(Context ctx) throws BOSException, EASBizException {
        IRowSet rs = null;
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select distinct ftargetcompanyid as ftargetcompanyid,fchangedate as fmaxdate,1 as ftag \r\n");
        sbSQL.append(" from t_csl_investday \r\n");
        sbSQL.append(" where ftargetcompanyid not IN \r\n");
        sbSQL.append(" (select distinct finvesteecompanyid \r\n");
        sbSQL.append(" from t_csl_sharerela \r\n");
        sbSQL.append(" ) \r\n");
        sbSQL.append(" UNION \r\n");
        sbSQL.append(" select a.ftargetcompanyid as ftargetcompanyid,a.fmaxdate as fmaxdate, 2 as ftag from \r\n");
        sbSQL.append(" (select ftargetcompanyid,fchangedate as fmaxdate from t_csl_investday) a, \r\n");
        sbSQL.append(" (select finvesteecompanyid as ftargetcompanyid,max(fchangedate) as fmaxdate from t_csl_sharerela group by finvesteecompanyid) b \r\n");
        sbSQL.append(" where a.ftargetcompanyid = b.ftargetcompanyid \r\n");
        sbSQL.append(" and a.fmaxdate>b.fmaxdate \r\n");
        sbSQL.append(" UNION \r\n");
        sbSQL.append(" select t2.ftargetcompanyid as ftargetcompanyid,max(t2.fchangedate) as fmaxdate,3 as ftag \r\n");
        sbSQL.append(" from t_csl_sharerela t1,t_csl_investday t2 \r\n");
        sbSQL.append(" where t1.finvesteecompanyid=t2.ftargetcompanyid \r\n");
        sbSQL.append(" and DAYOFYEAR(t1.fchangedate)=DAYOFYEAR(t2.fchangedate ) \r\n");
        sbSQL.append(" and Year(t1.fchangedate)=Year(t2.fchangedate) \r\n");
        sbSQL.append(" and t1.fsharescale<>t2.fsuminvestrate*100 \r\n");
        sbSQL.append(" group by t2.ftargetcompanyid \r\n");
        sbSQL.append(" order by FTag, FTargetCompanyId, FMaxDate");
        rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
        IRowSet rsEntry = null;
        try {
            sbSQL = new StringBuffer();
            sbSQL.append(" select fcompanyid,ftargetcompanyid,fchangedate,FSumInvestRate ");
            sbSQL.append(" From T_csl_investday ");
            sbSQL.append(" where ftargetcompanyid = ? and fchangedate = ? order by FCreateTime ");
            SimpleDateFormat startDateFormat = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
            SimpleDateFormat endDateFormat = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
            StringBuffer overFlowErr = new StringBuffer();
            while (rs.next()) {
                ShareRelaInfo info3;
                ShareRelaInfo info2;
                String targetCompanyId = rs.getString("ftargetcompanyid");
                Date maxdate = rs.getDate("fmaxdate");
                int tag = rs.getInt("ftag");
                rsEntry = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])new Object[]{targetCompanyId, maxdate});
                ShareRelaCollection col = ShareRelaFactory.getLocalInstance(ctx).getShareRelaCollection(" where investeeCompany.id = '" + targetCompanyId + "' and isLatest = 1 and changeDate >= '" + startDateFormat.format(maxdate) + "' and changeDate <= '" + endDateFormat.format(maxdate) + "' ");
                HashMap<String, ShareRelaInfo> innerRela = new HashMap<String, ShareRelaInfo>();
                ArrayList<ShareRelaInfo> outerRela = new ArrayList<ShareRelaInfo>();
                Iterator iter = col.iterator();
                while (iter.hasNext()) {
                    info2 = (ShareRelaInfo)iter.next();
                    if (tag != 3) {
                        info2 = (ShareRelaInfo)info2.clone();
                        info2.setId(null);
                        info2.setChangeDate(maxdate);
                        if (info2.isIsOut()) {
                            outerRela.add(info2);
                            continue;
                        }
                        innerRela.put(info2.getShareHolder().getId().toString(), info2);
                        continue;
                    }
                    if (!info2.isIsOut()) {
                        innerRela.put(info2.getShareHolder().getId().toString(), info2);
                        continue;
                    }
                    outerRela.add(info2);
                }
                while (rsEntry.next()) {
                    String companyId = rsEntry.getString("FCompanyId");
                    BigDecimal investRate = rsEntry.getBigDecimal("FSumInvestRate");
                    if (innerRela.containsKey(companyId)) {
                        info3 = (ShareRelaInfo)innerRela.get(companyId);
                        info3.setShareScale(investRate.multiply(new BigDecimal(100.0)));
                        continue;
                    }
                    try {
                        this.CheckCycleInvest(ctx, companyId, targetCompanyId);
                    }
                    catch (EASBizException e) {
                        continue;
                    }
                    info3 = new ShareRelaInfo();
                    info3.setIsOut(false);
                    info3.setInvesteeCompany(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(targetCompanyId)));
                    info3.setShareHolder(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(companyId)));
                    info3.setShareScale(investRate.multiply(new BigDecimal(100.0)));
                    info3.setChangeDate(maxdate);
                    info3.setIsLatest(true);
                    innerRela.put(companyId, info3);
                }
                BigDecimal rate = new BigDecimal(0.0);
                for (int i = 0; i < outerRela.size(); ++i) {
                    info3 = (ShareRelaInfo)outerRela.get(i);
                    rate = rate.add(new BigDecimal("" + info3.getShareScale()));
                }
                for (ShareRelaInfo info3 : innerRela.values()) {
                    rate = rate.add(new BigDecimal("" + info3.getShareScale()));
                }
                if (rate.compareTo(new BigDecimal(100.0)) > 0) {
                    info2 = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo((IObjectPK)new ObjectStringPK(targetCompanyId));
                    if (overFlowErr.length() > 0) {
                        overFlowErr.append("\uff0c");
                    }
                    overFlowErr.append(info2.getName());
                    continue;
                }
                String sql = "Update T_CSL_ShareRela set FIsLatest = 0 Where FIsLatest = 1 and FInvesteeCompanyID = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{targetCompanyId});
                for (ShareRelaInfo info4 : outerRela) {
                    ShareRelaFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info4);
                }
                for (ShareRelaInfo info4 : innerRela.values()) {
                    ShareRelaFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info4);
                }
            }
            if (overFlowErr.length() > 0) {
                return overFlowErr.toString();
            }
            return null;
        }
        catch (SQLException e) {
            throw new SQLDataException();
        }
    }

    @Override
    protected IRowSet _getCompanyListByDate(Context ctx, Map param) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        boolean isFrom = (Boolean)param.get("isfrom");
        String companyId = (String)param.get("companyid");
        Timestamp changeDate = new Timestamp(((java.util.Date)param.get("changedate")).getTime());
        IRowSet rs = null;
        if (isFrom) {
            sbSQL.append(" select fcompany AS \"SHAREHOLDER.NAME\", \n");
            sbSQL.append(" ftargetcompany AS \"INVESTEECOMPANY.NAME\", \n");
            sbSQL.append(" fchangedate AS \"changeDate\", \n");
            sbSQL.append(" fsharescale AS \"shareScale\", \n");
            sbSQL.append(" fid AS \"ID\", \n");
            sbSQL.append(" FRemark AS \"remark\" \n");
            sbSQL.append(" From (select t2.fname_" + ctx.getLocale() + " as fcompany,to_char(t3.fname_" + ctx.getLocale() + ") as ftargetcompany,t1.fchangedate,t1.fsharescale,t1.fid,t1.FRemark \n");
            sbSQL.append(" from t_csl_sharerela t1 join t_org_baseunit t2 on t1.fshareholderid=t2.fid \n");
            sbSQL.append(" join t_org_baseunit t3 on t1.finvesteecompanyid=t3.fid \n");
            sbSQL.append(" where t1.finvesteecompanyid= ? \n");
            sbSQL.append(" and fchangedate=( \n");
            sbSQL.append(" select max(fchangedate) from t_csl_sharerela \n");
            sbSQL.append(" where fchangedate<= ? \n");
            sbSQL.append(" and finvesteecompanyid= ?) \n");
            sbSQL.append(" UNION \n");
            sbSQL.append(" select t1.foutershareholder as fcompany, to_char('') as ftargetcompany,t1.fchangedate,t1.fsharescale,t1.fid,t1.FRemark \n");
            sbSQL.append(" from t_csl_sharerela t1 \n");
            sbSQL.append(" where t1.finvesteecompanyid= ? \n");
            sbSQL.append(" and fchangedate=( \n");
            sbSQL.append(" select max(fchangedate) from t_csl_sharerela \n");
            sbSQL.append(" where fchangedate<= ? \n");
            sbSQL.append(" and finvesteecompanyid= ?) \n");
            sbSQL.append(" and fisout=1) a \n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])new Object[]{companyId, changeDate, companyId, companyId, changeDate, companyId});
        } else {
            sbSQL.append(" select t2.fname_" + ctx.getLocale() + " AS \"SHAREHOLDER.NAME\", \n");
            sbSQL.append(" t3.fname_" + ctx.getLocale() + " AS \"INVESTEECOMPANY.NAME\", \n");
            sbSQL.append(" t1.fchangedate AS \"changeDate\", \n");
            sbSQL.append(" t1.fsharescale AS \"shareScale\", \n");
            sbSQL.append(" t2.fid AS \"SHAREHOLDER.ID\", \n");
            sbSQL.append(" t3.fid AS \"INVESTEECOMPANY.ID\", \n");
            sbSQL.append(" t1.fid AS \"ID\", \n");
            sbSQL.append(" t1.FRemark AS \"remark\" \n");
            sbSQL.append(" from t_csl_sharerela t1 join t_org_baseunit t2 on t1.fshareholderid=t2.fid \r\n");
            sbSQL.append(" join t_org_baseunit t3 on t1.finvesteecompanyid=t3.fid \r\n");
            sbSQL.append(" join ");
            sbSQL.append(" (select max(FChangeDate) as changedate, FInvesteeCompanyId");
            sbSQL.append(" from t_csl_sharerela where FChangeDate <= ? and FShareHolderId = ?");
            sbSQL.append(" group by FInvesteeCompanyId) a \r\n");
            sbSQL.append(" on t1.FInvesteeCompanyId = a.FInvesteeCompanyId and t1.FChangeDate = a.changedate \r\n");
            sbSQL.append(" where t1.fshareholderid= ?  \r\n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])new Object[]{changeDate, companyId, companyId});
        }
        return rs;
    }

    @Override
    protected int _getRelaCount(Context ctx, Map condition) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        ArrayList params = new ArrayList();
        sql.append("Select COUNT(DISTINCT FInvesteeCompanyID) as count from T_CSL_ShareRela ShareRela\t\t\n");
        sql.append("where ShareRela.FIsLatest = ?");
        params.add(condition.get("isLatest"));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        int result = 0;
        try {
            if (rowSet.next()) {
                result = rowSet.getInt("count");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }
}

