/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CheckFormulaException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.TempletItemListCollection;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractTempletItemListControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.util.TemplateItemListNewUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TempletItemListControllerBean
extends AbstractTempletItemListControllerBean {
    protected static final String TEMPLETITEMLISTINFO_TABLENAME = "T_CSL_TEMPLETITEMLIST";
    protected static final String TEMPLETITEMLISTINFO_BOSTYPE = "25EFA814";
    private static final int SQL_LENGTH = 200;

    @Override
    public boolean _importItemList(Context ctx, String templet, Map items) throws BOSException, EASBizException {
        return this._import(ctx, templet, items);
    }

    @Override
    public boolean _clearItemList(Context ctx, String templet) throws BOSException {
        return this._clear(ctx, templet, TemplateItemListNewUtil.getTemplateItemListTableNameById((Context)ctx, (String)templet, (String)TemplateItemListNewUtil.templateItemList_his), true);
    }

    private boolean _import(Context ctx, String templet, Map items) throws BOSException, EASBizException {
        Collection itemFormulas = items.values();
        if (itemFormulas.size() == 0) {
            return true;
        }
        Object[] tableAndIsLastTmp = TemplateItemListNewUtil.getTemplateItemListTableAndIsLastTmp((Context)ctx, (String)templet);
        String templateItemListTable = (String)tableAndIsLastTmp[0];
        boolean isLastTmp = (Boolean)tableAndIsLastTmp[1];
        this._clear(ctx, templet, templateItemListTable, !isLastTmp);
        String table = isLastTmp ? TemplateItemListNewUtil.templateItemList_new : TemplateItemListNewUtil.templateItemList_his;
        String SQL = " INSERT INTO " + table + " (FID, FTemplateID, FItemNumber, FItemFormula, FYear, FPeriod, FDataElement, FValueType, FSheetID, FSheetName, FCellName, FPosX, FPosY, FKeyNumber,FAsstActTypeNumber) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        Connection cn = null;
        PreparedStatement st = null;
        try {
            cn = super.getConnection(ctx);
            st = cn.prepareStatement(SQL);
            String itemFormula = null;
            int count = 0;
            int size = itemFormulas.size();
            StringBuffer errMsgArg = new StringBuffer();
            Iterator iterator = itemFormulas.iterator();
            while (iterator.hasNext()) {
                ++count;
                ItemFormula itemformula = (ItemFormula)iterator.next();
                st.setString(1, BOSUuid.create((String)TEMPLETITEMLISTINFO_BOSTYPE).toString());
                st.setString(2, templet);
                if (StringUtils.isEmpty((String)itemformula.getItemNumber())) {
                    throw new BOSException("rptItemNumber is null ");
                }
                st.setString(3, this.formatSQLParam(itemformula.getItemNumber()));
                itemFormula = this.formatSQLParam(itemformula.getFormula());
                if (itemFormula.length() > 200) {
                    errMsgArg.append(itemformula.getExt("6").toString());
                    errMsgArg.append("$");
                    errMsgArg.append(itemformula.getExt("7").toString());
                    errMsgArg.append(";");
                    continue;
                }
                st.setString(4, itemFormula);
                st.setInt(5, itemformula.getYearOffSet());
                st.setInt(6, itemformula.getPeriodOffSet());
                st.setInt(7, DataElementProvider.getDataElementInnerValue(ctx, itemformula.getDataElementNumber()));
                st.setInt(8, itemformula.getValueType());
                st.setString(9, itemformula.getExt("5").toString());
                st.setString(10, this.formatSQLParam(itemformula.getExt("6").toString()));
                st.setString(11, itemformula.getExt("7").toString());
                st.setInt(12, Integer.parseInt(itemformula.getExt("8").toString()));
                st.setInt(13, Integer.parseInt(itemformula.getExt("9").toString()));
                if (itemformula.getDItemNumber() != null && this.formatSQLParam(itemformula.getDItemNumber()).length() > 200) {
                    throw new EASBizException(new NumericExceptionSubItem("0001", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"275_TempletItemListControllerBean", (Locale)ctx.getOriginLocale()) + "\"" + itemformula.getDItemNumber() + "\"" + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"276_TempletItemListControllerBean", (Locale)ctx.getOriginLocale())));
                }
                st.setString(14, itemformula.getDItemNumber() == null ? "NULL" : this.formatSQLParam(itemformula.getDItemNumber()));
                String asstNumber = itemformula.getExt("27");
                st.setString(15, asstNumber == null ? "NULL" : this.formatSQLParam(asstNumber));
                st.addBatch();
                if (count % 1000 != 0 && count != size) continue;
                if (errMsgArg.length() > 0) {
                    String errMsg = errMsgArg.deleteCharAt(errMsgArg.length() - 1).toString();
                    throw new CheckFormulaException(CheckFormulaException.ITEMFORMUALTOOLARGE, new Object[]{errMsg});
                }
                st.executeBatch();
                st.clearBatch();
            }
            if (isLastTmp) {
                TemplateItemListNewUtil.insertTemplateItemListLog((Context)ctx, (String[])new String[]{templet});
            }
        }
        catch (SQLException e2) {
            try {
                throw new SQLDataException(e2);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)cn);
        return true;
    }

    private List removeExistingItem(Context ctx, String templetID, Collection itemFormulas) throws BOSException {
        if (itemFormulas.size() == 0) {
            return new ArrayList();
        }
        List<ItemFormula> commonSheetItem = new ArrayList();
        List<ItemFormula> notCommonSheetItem = new ArrayList();
        for (ItemFormula itemFormula : itemFormulas) {
            boolean isCommonSheet;
            String sheetType = itemFormula.getExt("SHEETTYPE");
            boolean bl = isCommonSheet = sheetType == null || sheetType.equals(String.valueOf(1));
            if (isCommonSheet) {
                commonSheetItem.add(itemFormula);
                continue;
            }
            notCommonSheetItem.add(itemFormula);
        }
        commonSheetItem = this.getUsedItemFormula(ctx, templetID, commonSheetItem, true);
        notCommonSheetItem = this.getUsedItemFormula(ctx, templetID, notCommonSheetItem, false);
        commonSheetItem.addAll(notCommonSheetItem);
        return commonSheetItem;
    }

    private List getUsedItemFormula(Context ctx, String templetID, List itemFormulas, boolean isCommonSheet) throws BOSException {
        if (itemFormulas.size() == 0) {
            return itemFormulas;
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        HashSet<String> keySet = new HashSet<String>();
        boolean isFirst = true;
        int formulaIndex = 0;
        String templateItemListTable = TemplateItemListNewUtil.getTemplateItemListTableNameById((Context)ctx, (String)templetID, (String)TemplateItemListNewUtil.templateItemList_his);
        Iterator iterator = itemFormulas.iterator();
        while (formulaIndex < itemFormulas.size()) {
            sql.append(" Select itemList.FItemFormula ItemFormula ");
            sql.append(" From ").append(templateItemListTable).append(" itemList ");
            sql.append(" INNER JOIN T_RPT_RptSheetPara sheetPara on itemList.FTemplateID = sheetPara.FReportID and itemList.fsheetid = sheetPara.fsheetid ");
            sql.append(" where  itemList.FTemplateID = ? ");
            params.add(templetID);
            if (isCommonSheet) {
                sql.append(" and sheetPara.FReportClass = ? ");
            } else {
                sql.append(" and sheetPara.FReportClass <> ? ");
            }
            sql.append(" and ( ");
            params.add(new Integer(1));
            for (int i = 0; i < 200 && (!isFirst || iterator.hasNext()); ++i) {
                if (i != 0) {
                    sql.append(" or ");
                }
                sql.append(" itemList.FItemFormula = ? ");
                if (iterator.hasNext()) {
                    ItemFormula itemFormula = (ItemFormula)iterator.next();
                    params.add(this.formatSQLParam(itemFormula.getFormula()));
                    ++formulaIndex;
                    continue;
                }
                if (isFirst) continue;
                params.add("");
            }
            sql.append(" )");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            try {
                while (rowSet.next()) {
                    keySet.add(rowSet.getString("ItemFormula"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            isFirst = false;
            sql.setLength(0);
            params.clear();
        }
        if (keySet.size() > 0) {
            iterator = itemFormulas.iterator();
            while (iterator.hasNext()) {
                ItemFormula itemFormula = (ItemFormula)iterator.next();
                if (!keySet.contains(this.formatSQLParam(itemFormula.getFormula()))) continue;
                iterator.remove();
            }
        }
        return itemFormulas;
    }

    private boolean _clear(Context ctx, String templet, String table, boolean deleteLog) throws BOSException {
        if (StringUtils.isEmpty((String)table)) {
            return true;
        }
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Delete From ").append(table).append(" Where FTemplateID =?");
        PreparedStatement stmt = null;
        Connection cn = super.getConnection(ctx);
        int index = 1;
        try {
            stmt = cn.prepareStatement(strSQL.toString());
            stmt.setString(index++, templet);
            stmt.execute();
            if (deleteLog && table.equals(TemplateItemListNewUtil.templateItemList_new)) {
                TemplateItemListNewUtil.deleteTemplateItemListLog((Context)ctx, (String)templet);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        }
        return true;
    }

    protected String _getInsertString(Context ctx, ItemFormula i, String templeteId, String table) throws BOSException, EASBizException {
        StringBuffer strInsert = new StringBuffer();
        String sheetType = i.getExt("SHEETTYPE");
        boolean isCommonSheet = sheetType == null || sheetType.equals(String.valueOf(1));
        String id = BOSUuid.create((BOSObjectType)new BOSObjectType(TEMPLETITEMLISTINFO_BOSTYPE)).toString();
        String asstNumber = i.getExt("27");
        strInsert.append("INSERT INTO ");
        strInsert.append(table);
        strInsert.append("(FID,FTemplateID,FItemNumber,FItemFormula,FYear,FPeriod,FDataElement,FValueType,FSheetID,FSheetName,FCellName,FPosX,FPosY,FKeyNumber");
        if (asstNumber != null) {
            strInsert.append(", FAsstActTypeNumber");
        }
        strInsert.append(") \r\n SELECT '");
        strInsert.append(id).append("','");
        strInsert.append(templeteId).append("','");
        strInsert.append(this.formatSQLParam(i.getItemNumber())).append("','");
        strInsert.append(this.formatSQLParam(i.getFormula())).append("',");
        strInsert.append(i.getYearOffSet()).append(",");
        strInsert.append(i.getPeriodOffSet()).append(",");
        strInsert.append(DataElementProvider.getDataElementInnerValue(ctx, i.getDataElementNumber())).append(",");
        strInsert.append(i.getValueType()).append(",'");
        strInsert.append(i.getExt("5").toString()).append("','");
        strInsert.append(this.formatSQLParam(i.getExt("6").toString())).append("','");
        strInsert.append(i.getExt("7").toString()).append("',");
        strInsert.append(Integer.parseInt(i.getExt("8").toString())).append(",");
        strInsert.append(Integer.parseInt(i.getExt("9").toString()));
        if (i.getDItemNumber() != null) {
            strInsert.append(", '").append(this.formatSQLParam(i.getDItemNumber())).append("'");
        } else {
            strInsert.append(", 'NULL'");
        }
        if (asstNumber != null) {
            strInsert.append(", '").append(this.formatSQLParam(asstNumber)).append("'");
        }
        strInsert.append("  WHERE NOT EXISTS ( \r\n");
        strInsert.append("\tSELECT t1.FID \r\n");
        strInsert.append("\tFROM ").append(TEMPLETITEMLISTINFO_TABLENAME).append(" t1 \r\n");
        strInsert.append("\tinner join T_RPT_RptSheetPara t2");
        strInsert.append("\ton t1.FTemplateID=t2.FReportID and t1.fsheetid=t2.fsheetid");
        strInsert.append("\tWHERE FTemplateID='").append(templeteId).append("' \r\n");
        if (isCommonSheet) {
            strInsert.append(" and t2.FReportClass = ").append(1);
        } else {
            strInsert.append(" and t2.FReportClass != ").append(1);
        }
        strInsert.append("\tAND FItemFormula='").append(this.formatSQLParam(i.getFormula())).append("') ");
        return strInsert.toString();
    }

    private String formatSQLParam(String s) {
        return StringUtils.replace((String)s, (String)"'", (String)"''");
    }

    @Override
    protected boolean _batchImportItemList(Context ctx, Map template2ItemMap) throws BOSException, EASBizException {
        Connection cn = null;
        Statement st = null;
        try {
            cn = super.getConnection(ctx);
            st = cn.createStatement();
            HashSet<String> newTemplateIds = new HashSet<String>();
            HashMap tables = TemplateItemListNewUtil.getTemplateItemListTableName((Context)ctx, (String[])((String[])template2ItemMap.keySet().toArray()), (String)TemplateItemListNewUtil.templateItemList_his);
            for (Map.Entry entry : template2ItemMap.entrySet()) {
                String templet = (String)entry.getKey();
                Map items = (Map)entry.getValue();
                ItemFormula i2 = null;
                for (ItemFormula i2 : items.values()) {
                    if (i2 == null) continue;
                    String table = (String)tables.get(templet);
                    if (TemplateItemListNewUtil.templateItemList_new.equals(table)) {
                        newTemplateIds.add(templet);
                    }
                    st.addBatch(this._getInsertString(ctx, i2, templet, table));
                }
            }
            st.executeBatch();
            st.clearBatch();
            if (!newTemplateIds.isEmpty()) {
                TemplateItemListNewUtil.insertTemplateItemListLog((Context)ctx, (String[])((String[])newTemplateIds.toArray()));
            }
        }
        catch (SQLException e2) {
            try {
                throw new SQLDataException(e2);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)cn);
        return true;
    }

    @Override
    protected TempletItemListCollection _getItemByTemplateID(Context ctx, String templateID) throws BOSException, EASBizException {
        String templateSql = "Select template.FGroup TemplateGroup,template.FVersionNumber versionNumber from T_RPT_Template template where template.FID = ? ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)templateSql, (Object[])new Object[]{templateID});
        try {
            if (rowSet.next()) {
                String versionNumber = rowSet.getString("versionNumber");
                String group = rowSet.getString("TemplateGroup");
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("template.versionNumber", (Object)(versionNumber.substring(0, versionNumber.indexOf(".")) + ".0")));
                filter.getFilterItems().add(new FilterItemInfo("template.group", (Object)group));
                return this.getTempletItemListCollection(ctx, view);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return new TempletItemListCollection();
    }
}

