/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.gr.cslrpt.ConvertModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataElementCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.UserDefinedRateException;
import com.kingdee.eas.fi.gr.cslrpt.UserDefinedRateInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractUserDefinedRateControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.ConvtParamsManager;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.ConvtUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.newrpt.CslCustomerExChangeRateTabInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserDefinedRateControllerBean
extends AbstractUserDefinedRateControllerBean {
    private static final long serialVersionUID = -1252757668250155016L;
    private static final String COL_NAME_DE = "dataElement.name";
    private static final String COL_NAME_CONVERTMODE = "convertMode";
    private static final String COL_NAME_CONVERTRATE = "convertRate";
    private static final String COL_NAME_PRECISION = "precision";
    private static final String COL_NAME_RATETABLENAME = "rateTbl.name";
    private static final String COL_NAME_ISREVERSIBLE = "isReversible";
    private static final String COL_NAME_ISPREINSTALL = "isPreinstall";
    private static final String COL_NAME_PREIODTYPE = "periodType";
    private static final String COL_NAME_SRCCURRENCY = "sourceCurrency.name";
    private static final String COL_NAME_TARCURRENCY = "targetCurrency.name";
    private static final String COL_NAME_YEAR = "year";
    private static final String COL_NAME_PERIOD = "period";
    private static final String COL_NAME_CREATOR = "creator.name";
    private static final String COL_NAME_UPDATOR = "lastUpdateUser.name";
    private static final String COL_NAME_REMARK = "remark";
    private static final String COL_NAME_TRACKOR = "trackRecordCreatorName";
    private static final String COL_NAME_TRACKORID = "trackRecordCreatorid";
    private static final String COL_NAME_ID = "id";
    private static final String COL_NAME_DEINTERSEQ = "dataElement.interSeq";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.UserDefinedRateControllerBean");

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._submit(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UserDefinedRateInfo rate = (UserDefinedRateInfo)model;
        if (rate.getDataCollect() == null) {
            DataCollectInfo datacollect = this.getActualData(ctx);
            rate.setDataCollect(datacollect);
        }
        if (this.isExistsByCondition(ctx, model)) {
            throw new UserDefinedRateException(UserDefinedRateException.EXISTSSAMERECORD);
        }
        return super._submit(ctx, model);
    }

    private boolean isExistsByCondition(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UserDefinedRateInfo rate = (UserDefinedRateInfo)model;
        String pk = rate.getId() == null ? null : rate.getId().toString();
        String sourceCurrencyPK = rate.getSourceCurrency().getId().toString();
        String targetCurrencyPK = rate.getTargetCurrency().getId().toString();
        String dataElementPK = rate.getDataElement().getId().toString();
        String dataCollectPK = rate.getDataCollect().getId().toString();
        String fRateTabID = rate.getRateTabID().getId().toString();
        int periodType = rate.getPeriodType().getValue();
        int period = rate.getPeriod();
        Date getAvailTime = rate.getAvailTime();
        StringBuffer sql = new StringBuffer(100);
        ArrayList<Object> params = new ArrayList<Object>(6);
        sql.append("select fid from t_csl_userDefinedRate where FsourceCurrencyId = ? \n");
        params.add(sourceCurrencyPK);
        sql.append(" and FtargetCurrencyId = ? \n");
        params.add(targetCurrencyPK);
        sql.append(" and FdataElementId = ? \n");
        params.add(dataElementPK);
        sql.append(" and FdataCollectId = ? \n");
        params.add(dataCollectPK);
        sql.append(" and FperiodType = ? \n");
        params.add(new Integer(periodType));
        sql.append(" and FavailTime = ? \n");
        params.add(new Timestamp(getAvailTime.getTime()));
        sql.append(" and FRateTabID = ? \n");
        params.add(fRateTabID);
        sql.append(" and FPeriod=?\n");
        params.add(period);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            if (rs.next()) {
                return pk == null || !pk.equals(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return false;
    }

    private DataCollectInfo getActualData(Context ctx) throws BOSException, EASBizException {
        return (DataCollectInfo)DataCollectFactory.getLocalInstance(ctx).getDataBaseInfo("where number='ACTUALDATA'");
    }

    @Override
    protected IObjectCollection _getDataCollectByPermission(Context ctx) throws BOSException, EASBizException {
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        String userPk = user.getId().toString();
        int permission = CSLPermissionUtil.checkDataCollectPermission(ctx, userPk);
        ArrayList<String> params = new ArrayList<String>(2);
        if (permission == 0) {
            return null;
        }
        if (permission == 1) {
            params.add("ACTUALDATA");
            return this.getDataCollects(ctx, params);
        }
        if (permission == 2) {
            params.add("BUDGETDATA");
            return this.getDataCollects(ctx, params);
        }
        if (permission == 10) {
            params.add("ACTUALDATA");
            params.add("BUDGETDATA");
            return this.getDataCollects(ctx, params);
        }
        return null;
    }

    private DataCollectCollection getDataCollects(Context ctx, List params) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer("select * where number in (");
        oql.append("'").append(params.get(0)).append("'");
        for (int i = 1; i < params.size(); ++i) {
            oql.append(",'").append(params.get(i)).append("'");
        }
        oql.append(") order by number ");
        return DataCollectFactory.getLocalInstance(ctx).getDataCollectCollection(oql.toString());
    }

    @Override
    protected BigDecimal _cusExchangeRate(Context ctx, String sourceCurrency, String targetCurrency, int periodType, String dataElement, Date date, String cusExRtTb) throws BOSException, EASBizException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = "{" + format.format(date) + "}";
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("select fconvertrate,d.fisreversible,d.fprecision, sc.fnumber as scnumber,tc.fnumber as tcnumber ");
        sqlBuf.append(" from T_csl_userdefinedrate d  inner join T_BD_Currency sc on sc.FID =d.FSourceCurrencyID ");
        sqlBuf.append(" inner join T_BD_Currency tc on tc.FID = d.FTargetCurrencyID ");
        sqlBuf.append(" inner join  T_CSL_DataElement e on d.FdataElementID=e.fid ");
        sqlBuf.append(" inner join  T_CslCustomerExChangeRateTab custab on d.FRateTabID=custab.fid ");
        sqlBuf.append(" where ((sc.fnumber =? and tc.fnumber=? ) or (sc.fnumber =? and tc.fnumber=?) ) ");
        sqlBuf.append(" and e.fnumber=? and fperiodType=?");
        sqlBuf.append("  and d.favailtime<=").append(dateStr);
        sqlBuf.append("  and custab.fnumber=?");
        sqlBuf.append(" order by favailtime desc");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(sourceCurrency);
        params.add(targetCurrency);
        params.add(targetCurrency);
        params.add(sourceCurrency);
        params.add(dataElement);
        params.add(new Integer(periodType));
        params.add(cusExRtTb);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString(), (Object[])params.toArray());
        BigDecimal reversedRate = null;
        boolean islastRate = false;
        try {
            while (rowSet.next()) {
                boolean isReversible = rowSet.getBoolean("fisreversible");
                String sourceCurr = rowSet.getString("scnumber");
                String targetCurr = rowSet.getString("tcnumber");
                BigDecimal convertRate = rowSet.getBigDecimal("fconvertrate");
                int precision = rowSet.getInt("fprecision");
                if (sourceCurr.trim().equals(sourceCurrency) && targetCurr.trim().equals(targetCurrency)) {
                    convertRate = convertRate.setScale(precision, 4);
                    return convertRate;
                }
                if (!isReversible || !sourceCurr.trim().equals(targetCurrency) || !targetCurr.trim().equals(sourceCurrency) || convertRate.compareTo(SysConstant.BIGZERO) == 0 || islastRate) continue;
                islastRate = true;
                BigDecimal one = new BigDecimal("1");
                reversedRate = one.divide(convertRate, precision, 4);
            }
        }
        catch (SQLException e) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Throwable)e);
        }
        if (reversedRate != null) {
            return reversedRate;
        }
        throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"NoExistsExchangeRate", (Locale)ctx.getLocale())});
    }

    @Override
    protected Map _getConvertRateData(Context ctx, Map condition) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        Map baseCondition = (Map)condition.get("KEY_BASE");
        SQLBuilder buffer = new SQLBuilder();
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)condition.get(COL_NAME_PREIODTYPE);
        Object srcCurrency = baseCondition.get("KEY_SOURCECURRENCY");
        ConvtParamsManager pm = this.newConvtParamsManager(ctx, condition);
        CurrencyCollection srcCurrencyCol = null;
        srcCurrencyCol = srcCurrency == null || StringUtils.isEmpty((String)srcCurrency.toString()) ? CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection("select * where deletedStatus=1 and id<>'11111111-1111-1111-1111-111111111111DEB58FDC' and id<>'22222222-2222-2222-2222-222222222222DEB58FDC' order by number") : CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection("select * where id ='" + srcCurrency.toString() + "'");
        DataElementCollection deCol = DataElementFactory.getLocalInstance(ctx).getDataElementCollection("select id,number,name,interSeq where isSys = 1");
        Iterator it = ConvertModeEnum.iterator();
        ArrayList table = new ArrayList();
        while (it.hasNext()) {
            ConvertModeEnum cm = (ConvertModeEnum)((Object)it.next());
            if (ConvertModeEnum.USERDIFINEDEXCHAGERATE.equals((Object)cm) || ConvertModeEnum.DONTCONVERT.equals((Object)cm) || ConvertModeEnum.HISTORYEXCHANGERATE.equals((Object)cm)) continue;
            for (int i = 0; i < deCol.size(); ++i) {
                DataElementInfo de = deCol.get(i);
                for (int j = 0; j < srcCurrencyCol.size(); ++j) {
                    int precision;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    if (srcCurrencyCol.get(j).getId().toString().equals(pm.getTargetCurrencyInfo().getId().toString())) continue;
                    map.put(COL_NAME_DE, de.getName());
                    map.put(COL_NAME_CONVERTMODE, (Object)cm);
                    BigDecimal b = this.getExgRate(ctx, periodType, srcCurrencyCol.get(j), de.getInterSeq(), cm, pm);
                    if (b == null) {
                        b = BigDecimal.ZERO;
                        precision = 2;
                    } else {
                        precision = b.scale();
                    }
                    map.put(COL_NAME_CONVERTRATE, b);
                    map.put(COL_NAME_PRECISION, precision);
                    map.put(COL_NAME_RATETABLENAME, condition.get("exgTabName"));
                    map.put(COL_NAME_ISREVERSIBLE, pm.getExchangeTableInfo().isIsReversible());
                    map.put(COL_NAME_ISPREINSTALL, Boolean.TRUE);
                    map.put(COL_NAME_PREIODTYPE, periodType);
                    map.put(COL_NAME_SRCCURRENCY, srcCurrencyCol.get(j).getName());
                    map.put(COL_NAME_TARCURRENCY, pm.getTargetCurrencyInfo().getName());
                    map.put(COL_NAME_YEAR, pm.getYear());
                    map.put(COL_NAME_PERIOD, pm.getPeriod());
                    map.put(COL_NAME_CREATOR, "");
                    map.put(COL_NAME_UPDATOR, "");
                    map.put(COL_NAME_REMARK, "");
                    map.put(COL_NAME_TRACKOR, "");
                    map.put(COL_NAME_TRACKORID, condition.get("curCompanyId"));
                    map.put(COL_NAME_ID, "");
                    map.put(COL_NAME_DEINTERSEQ, de.getInterSeq());
                    map.put("sourceCurrency.id", srcCurrencyCol.get(j).getId().toString());
                    map.put("targetCurrency.id", pm.getTargetCurrencyInfo().getId().toString());
                    table.add(map);
                }
            }
        }
        String lcl = ctx.getLocale().toString();
        buffer.append(" SELECT ");
        buffer.append(" dataEle.FName_" + lcl + " AS deName, ");
        buffer.append(" ud.FConvertMode AS convertMode, ");
        buffer.append(" ud.FPeriodType AS periodType, ");
        buffer.append(" ud.FYear AS year, ud.FPeriod AS period, ");
        buffer.append(" ud.FAvailTime AS availTime, ");
        buffer.append(" ud.FConvertRate AS convertRate, ");
        buffer.append(" ud.FPrecision AS fprecision, ");
        buffer.append(" ud.FIsReversible AS isReversible, ");
        buffer.append(" ud.FRemark AS remark, ");
        buffer.append(" ud.FID AS id, ");
        buffer.append(" lastUpdator.FName_" + lcl + " AS lastUpdatorName, ");
        buffer.append(" sourceCurrency.FId AS srcCurrencyId, ");
        buffer.append(" sourceCurrency.FName_" + lcl + " AS srcCurrencyName, ");
        buffer.append(" creator.FName_" + lcl + " AS creatorName, ");
        buffer.append(" targetCurrency.FId AS targetCurrencyId, ");
        buffer.append(" targetCurrency.FName_" + lcl + " AS targetCurrencyName, ");
        buffer.append(" dataCollect.FName_" + lcl + " AS dataCollectName, ");
        buffer.append(" dataEle.FInterSeq AS deInterSeq,");
        buffer.append(" trackerUser.FName_" + lcl + " AS trackName, ");
        buffer.append(" trackerUser.FID AS trackId, ");
        buffer.append(" rateTab.FID AS rateTabId, ");
        buffer.append(" exchTab.FName_" + lcl + " AS exchTabName, ");
        buffer.append(" exchTab.Fid AS exchTabId ");
        buffer.append(" FROM T_CSL_UserDefinedRate AS ud ");
        buffer.append(" INNER JOIN T_CSL_DataCollect AS dataCollect ON ud.FDataCollectID = dataCollect.FID ");
        buffer.append(" INNER JOIN T_CSL_DataElement AS dataEle ON ud.FdataElementID = dataEle.FID ");
        buffer.append(" INNER JOIN T_PM_User AS lastUpdator ON ud.FLastUpdateUserID = lastUpdator.FID ");
        buffer.append(" INNER JOIN T_BD_Currency AS sourceCurrency ON ud.FSourceCurrencyID = sourceCurrency.FID ");
        buffer.append(" INNER JOIN T_PM_User AS creator ON ud.FCreatorID = creator.FID ");
        buffer.append(" INNER JOIN T_BD_Currency AS targetCurrency ON ud.FTargetCurrencyID = targetCurrency.FID ");
        buffer.append(" INNER JOIN T_ORG_Company AS trackerUser ON ud.FTrackRecordCreatorID = trackerUser.FID ");
        buffer.append(" INNER JOIN T_CslCustomerExChangeRateTab AS rateTab ON ud.FRateTabID = rateTab.FID ");
        buffer.append("  LEFT JOIN T_BD_ExchangeTable AS exchTab ON rateTab.FExchTableId = exchTab.FID ");
        buffer.append(" WHERE rateTab.FId = ?", (Object)baseCondition.get("KEY_BASE_CUSTOMERATETABLE").toString());
        buffer.append("   AND ud.FYear = ?", (Object)((Integer)condition.get(COL_NAME_YEAR)));
        buffer.append("   AND ud.FPeriod = ?", (Object)((Integer)condition.get(COL_NAME_PERIOD)));
        buffer.append("   AND ud.FPeriodType = ?", (Object)((RptPeriodTypeEnum)condition.get(COL_NAME_PREIODTYPE)).getValue());
        buffer.append("   AND ud.FTargetCurrencyId = ?", (Object)baseCondition.get("KEY_BASE_TARGETCY").toString());
        if (!StringUtils.isEmpty((String)baseCondition.get("KEY_SOURCECURRENCY").toString())) {
            buffer.append("   AND ud.FSourceCurrencyId = ?", (Object)baseCondition.get("KEY_SOURCECURRENCY").toString());
        } else {
            buffer.append("   AND ud.FSourceCurrencyId <> ?", (Object)baseCondition.get("KEY_BASE_TARGETCY").toString());
        }
        buffer.append(" ORDER BY availTime DESC, id ASC ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])buffer.getParams());
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(COL_NAME_DE, rs.getString("deName"));
                map.put(COL_NAME_CONVERTMODE, (Object)ConvertModeEnum.getEnum(rs.getInt(COL_NAME_CONVERTMODE)));
                map.put(COL_NAME_CONVERTRATE, rs.getString(COL_NAME_CONVERTRATE));
                map.put(COL_NAME_PRECISION, rs.getInt("fprecision"));
                map.put(COL_NAME_RATETABLENAME, rs.getString("exchTabName"));
                map.put(COL_NAME_ISREVERSIBLE, "1".equals(rs.getString(COL_NAME_ISREVERSIBLE)));
                map.put(COL_NAME_ISPREINSTALL, Boolean.FALSE);
                map.put(COL_NAME_PREIODTYPE, RptPeriodTypeEnum.getEnum((int)rs.getInt(COL_NAME_PREIODTYPE)));
                map.put(COL_NAME_SRCCURRENCY, rs.getString("srcCurrencyName"));
                map.put(COL_NAME_TARCURRENCY, rs.getString("targetCurrencyName"));
                map.put(COL_NAME_YEAR, rs.getInt(COL_NAME_YEAR));
                map.put(COL_NAME_PERIOD, rs.getInt(COL_NAME_PERIOD));
                map.put(COL_NAME_CREATOR, rs.getString("creatorName"));
                map.put(COL_NAME_UPDATOR, rs.getString("lastUpdatorName"));
                map.put(COL_NAME_REMARK, rs.getString(COL_NAME_REMARK));
                map.put(COL_NAME_TRACKOR, rs.getString("trackName"));
                map.put(COL_NAME_TRACKORID, rs.getString("trackId"));
                map.put(COL_NAME_ID, rs.getString(COL_NAME_ID));
                map.put(COL_NAME_DEINTERSEQ, rs.getString("deInterSeq"));
                map.put("sourceCurrency.id", rs.getString("srcCurrencyId"));
                map.put("targetCurrency.id", rs.getString("targetCurrencyId"));
                table.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        result.put("rowData", table);
        return result;
    }

    private BigDecimal getExgRate(Context ctx, RptPeriodTypeEnum periodType, CurrencyInfo currency, int deValue, ConvertModeEnum cm, ConvtParamsManager pm) throws EASBizException, BOSException {
        return ConvtUtil.getExgRate(ctx, cm, deValue, periodType, currency, pm);
    }

    private ConvtParamsManager newConvtParamsManager(Context ctx, Map convtParams) throws EASBizException, BOSException {
        ConvtParamsManager pm = new ConvtParamsManager(ctx, convtParams, "OTHER");
        pm.initParams();
        return pm;
    }

    @Override
    protected Map _getArithmeticProcess(Context ctx, Map condition) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (!Boolean.valueOf(condition.get(COL_NAME_ISPREINSTALL).toString()).booleanValue()) {
            result.put("arithmeticRule", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ConvertRate", (String)"18_UserDefinedRate", (Locale)ctx.getLocale()));
            result.put("arithmeticProcess", (String)condition.get(COL_NAME_CONVERTRATE));
            return result;
        }
        ConvtParamsManager pm = this.newConvtParamsManager(ctx, condition);
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)condition.get(COL_NAME_PREIODTYPE);
        Map baseCondition = (Map)condition.get("KEY_BASE");
        String srcCurrencyId = baseCondition.get("KEY_SOURCECURRENCY").toString();
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(srcCurrencyId));
        int deValue = Integer.valueOf(condition.get("dataElement").toString());
        ConvertModeEnum cm = (ConvertModeEnum)((Object)condition.get(COL_NAME_CONVERTMODE));
        BigDecimal exhgRate = ConvtUtil.getExgRate(ctx, cm, deValue, periodType, currency, pm, true);
        String arithmeticProcess = pm.getArithmeticProcess();
        if (!StringUtils.isEmpty((String)arithmeticProcess)) {
            if (arithmeticProcess.startsWith("(")) {
                arithmeticProcess = arithmeticProcess.substring(1, arithmeticProcess.length() - 1);
            }
        } else {
            arithmeticProcess = exhgRate == null ? "0.00" : exhgRate.toString();
        }
        result.put("arithmeticRule", this.getArithmeticRule(ctx, periodType.getValue(), cm.getValue(), deValue));
        result.put("arithmeticProcess", this.formatArithMeticProcess(arithmeticProcess));
        return result;
    }

    private String formatArithMeticProcess(String s) {
        if (s == null) {
            return "";
        }
        int i = s.indexOf("/");
        if (i > 0) {
            s = s.replaceAll("\\(", "").replaceAll("\\)", "");
            i = s.indexOf("/");
            s = "(" + s.substring(0, i) + ")" + s.substring(i);
        }
        return s;
    }

    public String getArithmeticRule(Context ctx, int periodType, int cm, int dataElementValue) throws EASBizException, BOSException {
        DataElementInfo deInfo = DataElementFactory.getLocalInstance(ctx).getDataElementByInterSeq(dataElementValue);
        String key = this.getResKey(periodType, cm, deInfo.getNumber());
        if (StringUtils.isEmpty((String)key)) {
            return "";
        }
        String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ConvertRate", (String)key, (Locale)ctx.getLocale());
        if ("Missing Resource".equals(msg)) {
            return "";
        }
        return msg;
    }

    private String getResKey(int periodType, int cm, String deNumber) {
        String resKey = "";
        if (periodType == 1) {
            resKey = "RB";
        } else if (periodType == 1) {
            resKey = "RB";
        } else if (periodType == 2) {
            resKey = "ZB";
        } else if (periodType == 3) {
            resKey = "YB";
        } else if (periodType == 4) {
            resKey = "JB";
        } else if (periodType == 5) {
            resKey = "BNB";
        } else if (periodType == 6) {
            resKey = "NB";
        } else {
            return "";
        }
        resKey = resKey + "_";
        if (cm == 1) {
            resKey = resKey + "QM";
        } else if (cm == 2) {
            resKey = resKey + "JQPJ";
        } else if (cm == 6) {
            resKey = resKey + "RPJ";
        } else {
            return "";
        }
        resKey = resKey + "_" + deNumber;
        return resKey;
    }

    @Override
    protected Map _copyRate(Context ctx, Map param, int offset, boolean isOverride) throws BOSException, EASBizException {
        if (param == null) {
            return null;
        }
        if (offset >= 0) {
            return null;
        }
        int year = Integer.valueOf(param.get(COL_NAME_YEAR).toString());
        int period = Integer.valueOf(param.get(COL_NAME_PERIOD).toString());
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)param.get(COL_NAME_PREIODTYPE);
        String dataCollectId = DataCollectConstant.getActualDC().getId().toString();
        String companyId = param.get("curCompanyId") == null ? "" : param.get("curCompanyId").toString();
        Map baseMap = (Map)param.get("KEY_BASE");
        String srcCurrencyId = baseMap.get("KEY_SOURCECURRENCY").toString();
        String tarCurrencyId = baseMap.get("KEY_BASE_TARGETCY").toString();
        String rateTabId = baseMap.get("KEY_BASE_CUSTOMERATETABLE").toString();
        int[] ym = new int[]{year, period};
        for (int i = 0; i < -offset; ++i) {
            ym = RPTDateUtil.getPrevYearAndPeriod(ym[0], ym[1], periodType);
        }
        SQLBuilder builder = new SQLBuilder();
        builder.append("SELECT * FROM T_CSL_UserDefinedRate u                              ");
        builder.append(" WHERE 1=1                                                         ");
        if (!StringUtils.isEmpty((String)srcCurrencyId)) {
            builder.append("  AND u.FSourceCurrencyId=?                                        ", (Object)srcCurrencyId);
        }
        builder.append("  AND u.FTargetCurrencyId=?                                        ", (Object)tarCurrencyId);
        builder.append("  AND u.FPeriodType=?                                              ", (Object)periodType.getValue());
        builder.append("  AND u.FYear=?                                                    ", (Object)ym[0]);
        builder.append("  AND u.FPeriod=?                                                  ", (Object)ym[1]);
        builder.append("  AND u.FDataCollectId=?                                           ", (Object)dataCollectId);
        builder.append("  AND u.FTrackRecordCreatorId=?                                    ", (Object)companyId);
        builder.append("  AND u.FRateTabId=?                                               ", (Object)rateTabId);
        if (!isOverride) {
            builder.append("  AND NOT EXISTS (SELECT 1 FROM T_CSL_UserDefinedRate u1 WHERE 1=1 ");
            builder.append("  AND u1.FSourceCurrencyId = u.FSourceCurrencyId                   ");
            builder.append("  AND u1.FTargetCurrencyId = u.FTargetCurrencyId                   ");
            builder.append("  AND u1.FPeriodType=u.FPeriodType                                 ");
            builder.append("  AND u1.FYear=?                                                   ", (Object)year);
            builder.append("  AND u1.FPeriod=?                                                 ", (Object)period);
            builder.append("  AND u1.FDataElementId=u.FDataElementId                           ");
            builder.append("  AND u1.FDataCollectId=u.FDataCollectId                           ");
            builder.append("  AND u1.FTrackRecordCreatorId=u.FTrackRecordCreatorId             ");
            builder.append("  AND u1.FRateTabId=u.FRateTabId)                                  ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)builder.getSQL(), (Object[])builder.getParams());
        HashMap<String, IObjectPK> result = new HashMap<String, IObjectPK>();
        try {
            while (rs.next()) {
                UserDefinedRateInfo info = new UserDefinedRateInfo();
                CurrencyInfo currencyInfo = new CurrencyInfo();
                currencyInfo.setId(BOSUuid.read((String)rs.getString("FSourceCurrencyID")));
                info.setSourceCurrency(currencyInfo);
                CurrencyInfo targetCurrencyInfo = new CurrencyInfo();
                targetCurrencyInfo.setId(BOSUuid.read((String)rs.getString("FTargetCurrencyID")));
                info.setTargetCurrency(targetCurrencyInfo);
                info.setPeriodType(RptPeriodTypeEnum.getEnum((int)rs.getInt("FPeriodType")));
                info.setYear(year);
                info.setPeriod(period);
                info.setAvailTime(rs.getDate("FAvailTime"));
                DataCollectInfo dataCollectInfo = new DataCollectInfo();
                dataCollectInfo.setId(BOSUuid.read((String)rs.getString("FDataCollectID")));
                info.setDataCollect(dataCollectInfo);
                info.setConvertRate(rs.getBigDecimal("FConvertRate"));
                info.setPrecision(rs.getInt("FPrecision"));
                info.setIsReversible(rs.getBoolean("FIsReversible"));
                info.setRemark(info.getString("FRemark"));
                DataElementInfo dataElementInfo = new DataElementInfo();
                dataElementInfo.setId(BOSUuid.read((String)rs.getString("FdataElementID")));
                info.setDataElement(dataElementInfo);
                CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
                companyInfo.setId(BOSUuid.read((String)rs.getString("FTrackRecordCreatorID")));
                info.setTrackRecordCreator(companyInfo);
                CslCustomerExChangeRateTabInfo rateTabInfo = new CslCustomerExChangeRateTabInfo();
                rateTabInfo.setId(BOSUuid.read((String)rs.getString("FRateTabID")));
                info.setRateTabID(rateTabInfo);
                info.setConvertMode(ConvertModeEnum.getEnum(rs.getInt("FConvertMode")));
                IObjectPK pk = this.addnew(ctx, info);
                result.put(pk.toString(), pk);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }
}

