/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.convt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.ConvtParamsManager;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.ICslConvt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractCslConvt
implements ICslConvt {
    private static Logger logger = Logger.getLogger(AbstractCslConvt.class);
    protected ConvtParamsManager paramsManager;
    private String _convtType;

    public AbstractCslConvt(String convtType) {
        this._convtType = convtType;
    }

    @Override
    public void initConvtParams(Context ctx, Map convtParams) throws BOSException, EASBizException {
        this.paramsManager = new ConvtParamsManager(ctx, convtParams, this._convtType);
        this.paramsManager.initParams();
    }

    @Override
    public Map convert(Context ctx, List idList, Map convtParams) throws BOSException, EASBizException {
        IObjectCollection bizCollection = this.getBizCollectionByIdList(ctx, idList);
        IObjectValue info = null;
        StringBuffer error = new StringBuffer();
        ArrayList<String> reports = new ArrayList<String>();
        for (int i = 0; i < bizCollection.size(); ++i) {
            info = bizCollection.getObject(i);
            try {
                reports.add(this.excConvert(ctx, info));
                continue;
            }
            catch (Exception e) {
                error.append(this.getExceptionReport(info, e));
                logger.error((Object)"rptconvert", (Throwable)e);
            }
        }
        this.paramsManager.clearCache();
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("Message", error.toString());
        result.put("reports", reports);
        return result;
    }

    public abstract IObjectCollection getBizCollectionByIdList(Context var1, List var2) throws BOSException, EASBizException;

    public abstract String getExceptionReport(IObjectValue var1, Exception var2);

    public abstract String excConvert(Context var1, IObjectValue var2) throws BOSException, EASBizException;
}

